/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import sharpen.core.DocumentationOverlay;

public class XmlDocumentationOverlay
implements DocumentationOverlay {
    private Document _document;
    private LSSerializer _serializer;
    private XPath _xpath;

    public XmlDocumentationOverlay(String uri) {
        this._document = XmlDocumentationOverlay.loadXML(uri);
    }

    @Override
    public String forType(String fullName) {
        return this.forXPath("/doc/type[@name='" + fullName + "']/doc");
    }

    @Override
    public String forMember(String fullTypeName, String signature) {
        return this.forXPath("/doc/type[@name='" + fullTypeName + "']/member[@name='" + signature + "']/doc");
    }

    private String forXPath(String xpath) {
        Element found = this.selectElement(xpath);
        if (found == null) {
            return null;
        }
        return this.serializeContent(found);
    }

    private String serializeContent(Element e) {
        return this.stripFirstAndLastLines(this.serializer().writeToString(e));
    }

    private String stripFirstAndLastLines(String s) {
        int firstLineFeed = s.indexOf("\n");
        int lastLineFeed = s.lastIndexOf("\n");
        return s.substring(firstLineFeed + 1, lastLineFeed);
    }

    private LSSerializer serializer() {
        if (this._serializer != null) {
            return this._serializer;
        }
        this._serializer = this.newSerializer();
        return this._serializer;
    }

    private LSSerializer newSerializer() {
        LSSerializer serializer = ((DOMImplementationLS)((Object)this._document.getImplementation())).createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", Boolean.FALSE);
        serializer.getDomConfig().setParameter("well-formed", Boolean.FALSE);
        return serializer;
    }

    protected Element selectElement(String xpath) {
        try {
            return (Element)this.xpath().evaluate(xpath, this._document, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private XPath xpath() {
        if (this._xpath != null) {
            return this._xpath;
        }
        this._xpath = this.newXPath();
        return this._xpath;
    }

    private XPath newXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    private static Document loadXML(String uri) {
        try {
            return XmlDocumentationOverlay.builderFactory().newDocumentBuilder().parse(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static DocumentBuilderFactory builderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        factory.setXIncludeAware(true);
        return factory;
    }
}

