/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;

class BlockMetadataHeader {
    static final short METADATA_VERSION = 1;
    private short version;
    private DataChecksum checksum = null;

    BlockMetadataHeader(short version, DataChecksum checksum) {
        this.checksum = checksum;
        this.version = version;
    }

    short getVersion() {
        return this.version;
    }

    DataChecksum getChecksum() {
        return this.checksum;
    }

    static BlockMetadataHeader readHeader(DataInputStream in) throws IOException {
        return BlockMetadataHeader.readHeader(in.readShort(), in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BlockMetadataHeader readHeader(File file) throws IOException {
        BlockMetadataHeader blockMetadataHeader;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            blockMetadataHeader = BlockMetadataHeader.readHeader(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream(in);
        return blockMetadataHeader;
    }

    private static BlockMetadataHeader readHeader(short version, DataInputStream in) throws IOException {
        DataChecksum checksum = DataChecksum.newDataChecksum(in);
        return new BlockMetadataHeader(version, checksum);
    }

    private static void writeHeader(DataOutputStream out, BlockMetadataHeader header) throws IOException {
        out.writeShort(header.getVersion());
        header.getChecksum().writeHeader(out);
    }

    static void writeHeader(DataOutputStream out, DataChecksum checksum) throws IOException {
        BlockMetadataHeader.writeHeader(out, new BlockMetadataHeader(1, checksum));
    }

    static int getHeaderSize() {
        return 2 + DataChecksum.getChecksumHeaderSize();
    }
}

