/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef H_Palette
#define H_Palette
#include <X11/Intrinsic.h>

typedef struct _Palette *Palette;

typedef struct RGBColor {
	double red;
	double green;
	double blue;

#if defined(__cplusplus) || defined(c_plusplus)
       RGBColor(double r = 0,double g = 0,double b = 0):
       	red(r),green(g),blue(b) {}	
#endif

} RGBColor;

typedef struct HSLColor {
	double hue;
	double saturation;
	double lightness;
#if defined(__cplusplus) || defined(c_plusplus)
       HSLColor(double h = 0,double s = 0,double l = 0):
       	hue(h),saturation(s),lightness(l) {}	
#endif
} HSLColor; 

typedef struct HSVColor {
	double hue;
	double saturation;
	double value;
#if defined(__cplusplus) || defined(c_plusplus)
       HSVColor(double h = 0,double s = 0,double v = 0):
       	hue(h),saturation(s),value(v) {}	
#endif
} HSVColor; 

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

long RGBDistance(const XColor *c1, const XColor *c2);

void    DisposePalette(Palette palette);
Palette NewPalette(Widget w);

Pixel PaletteNamedColor(Palette palette, const char *name);
Pixel PaletteHSVColor(Palette palette, const HSVColor*);
Pixel PaletteHSLColor(Palette palette, const HSLColor*);
Pixel PaletteRGBColor(Palette palette, const RGBColor*);
Pixel PaletteXColor(Palette palette, XColor *col);

void PaletteRGBToHSL(Palette palette,const RGBColor*,HSLColor*);
void PaletteHSLToRGB(Palette palette,const HSLColor*,RGBColor*); 
void PaletteRGBToHSV(Palette palette,const RGBColor*,HSVColor*);
void PaletteHSVToRGB(Palette palette,const HSVColor*,RGBColor*); 
void PaletteNameToRGB(Palette palette,const char *name,RGBColor*);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif		    


#endif















