/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#include "testlib/testutils.h"

// GLib related libraries
#include <grilo.h>

// Google Tests
#include <gtest/gtest.h>

// C++ Standard Library
#include <string>

// Media Scanner
#include "mediascanner/locale.h"
#include "mediascanner/logging.h"

// Test Suite
#include "testlib/environments.h"

namespace mediascanner {

void InitTests(int *argc, char **argv) {
    std::set_terminate(mediascanner::abort_with_backtrace);

    // Override some essential environment variables
    g_setenv("GIO_USE_VFS", "local", true);
    g_setenv(GRL_PLUGIN_PATH_VAR, GRILO_PLUGIN_DIR, true);
    g_setenv("XDG_DATA_DIRS", USER_DATA_DIR ":/usr/share", true);
    g_setenv("MEDIASCANNER_UNDER_TEST", "1", true);

    // Redirect, so that we check for operating without errors
    logging::capture_glib_messages();

    // Install boost locale facets.
    SetupLocale();

    ::testing::InitGoogleTest(argc, argv);
    ::testing::AddGlobalTestEnvironment(new FakeUDevEnvironment);
}

std::string make_base_url() {
    std::string base_url = "file://" MEDIA_DIR;

    if (base_url.at(base_url.length() - 1) != '/')
        base_url.append(1, '/');

    return base_url;
}

} // namespace mediascanner
