/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: James Henstridge <james.henstridge@canonical.com>
 */

#ifndef MEDIAARTDOWNLOADER_H
#define MEDIAARTDOWNLOADER_H

#include <string>

namespace mediascanner {

class MediaArtDownloader {
    class Private;
    friend class Private;
private:

public:
    MediaArtDownloader();
    ~MediaArtDownloader();

    static void LoadGriloPlugin();

    void resolve(const std::string &artist, const std::string &album);

    bool is_idle() const;
    void WaitForFinished();

private:
    Private *const d;
};

}

#endif
