C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4RD (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=10)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4D
C       PARAMETER (ISET=2)                                            
        DATA  DrI, FlI, AlI /             2.,   5.,  .2020 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                                 1.600,    5.000,  180.000 /
C        DATA  NXI,  NTI, NfMxI /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .160000D+01, .100000D+05,
     +  .160000D+01, .203369D+01, .265779D+01, .358285D+01, .500000D+01,
     +  .794903D+01, .135129D+02, .248012D+02, .496935D+02, .110086D+03,
     +  .273574D+03, .775412D+03, .255482D+04, .100000D+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000D-04,
     +  .000000D+00, .999983D-05, .124433D-04, .154836D-04, .192668D-04,
     +  .239740D-04, .298310D-04, .371184D-04, .461852D-04, .574656D-04,
     +  .714994D-04, .889575D-04, .110674D-03, .137686D-03, .171280D-03,
     +  .213055D-03, .264997D-03, .329564D-03, .409809D-03, .509508D-03,
     +  .633332D-03, .787053D-03, .977784D-03, .121428D-02, .150728D-02,
     +  .186993D-02, .231825D-02, .288037D-02, .356397D-02, .440443D-02,
     +  .543508D-02, .669508D-02, .822984D-02, .100851D-01, .123281D-01,
     +  .150167D-01, .182174D-01, .219985D-01, .264278D-01, .315720D-01,
     +  .374800D-01, .442088D-01, .517931D-01, .602576D-01, .696136D-01,
     +  .798586D-01, .909356D-01, .102935D+00, .115681D+00, .129293D+00,
     +  .143599D+00, .158606D+00, .174271D+00, .190550D+00, .207405D+00,
     +  .224796D+00, .242685D+00, .261038D+00, .279820D+00, .299001D+00,
     +  .318550D+00, .338442D+00, .358653D+00, .379067D+00, .399881D+00,
     +  .420953D+00, .442266D+00, .463806D+00, .485559D+00, .507513D+00,
     +  .529656D+00, .551978D+00, .574483D+00, .597187D+00, .619860D+00,
     +  .642828D+00, .665921D+00, .689135D+00, .712467D+00, .735911D+00,
     +  .759464D+00, .783080D+00, .806909D+00, .830741D+00, .854673D+00,
     +  .878696D+00, .902804D+00, .926992D+00, .951257D+00, .975603D+00,
     +  .100000D+01 /
C Parton Distribution Table:                                                     
        DATA (UPDI(I),I=1,52) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=365,416) /
     +  .226654D+06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .897108D+05,
     +  .686463D+05, .517218D+05, .389374D+05, .292956D+05,
     +  .220207D+05, .165416D+05, .124134D+05, .930878D+04,
     +  .697318D+04, .521954D+04, .390241D+04, .291518D+04 /
        DATA (UPDI(I),I=469,520) /
     +  .217500D+04, .162125D+04, .120687D+04, .897493D+03,
     +  .666456D+03, .494347D+03, .366111D+03, .270819D+03,
     +  .199996D+03, .147501D+03, .108592D+03, .798304D+02,
     +  .585835D+02, .429415D+02, .312733D+02, .228460D+02,
     +  .166570D+02, .121304D+02, .881848D+01, .640438D+01,
     +  .464946D+01, .337199D+01, .244431D+01, .177337D+01,
     +  .128721D+01, .936279D+00, .682179D+00, .498985D+00,
     +  .366110D+00, .269832D+00, .199688D+00, .148575D+00,
     +  .111012D+00, .834718D-01, .628547D-01, .476389D-01,
     +  .361111D-01, .274702D-01, .209009D-01, .159135D-01,
     +  .120971D-01, .918436D-02, .694634D-02, .523485D-02,
     +  .392273D-02, .292526D-02, .216467D-02, .159116D-02,
     +  .115845D-02, .835839D-03, .597217D-03, .420800D-03 /
        DATA (UPDI(I),I=521,572) /
     +  .291664D-03, .198804D-03, .132360D-03, .857791D-04,
     +  .532939D-04, .312489D-04, .163928D-04, .674397D-05,
     +  .660468D-06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .205743D+06, .156969D+06,
     +  .117863D+06, .884242D+05, .662953D+05, .496568D+05,
     +  .371677D+05, .277914D+05, .207643D+05, .154971D+05,
     +  .115563D+05, .860740D+04, .640513D+04, .476028D+04,
     +  .353429D+04, .262045D+04, .194078D+04, .143526D+04,
     +  .106015D+04, .781820D+03, .575825D+03, .423380D+03,
     +  .310854D+03, .227820D+03, .166706D+03, .121761D+03 /
        DATA (UPDI(I),I=573,624) /
     +  .888208D+02, .643667D+02, .467867D+02, .339403D+02,
     +  .245888D+02, .177820D+02, .128448D+02, .927473D+01,
     +  .668910D+01, .482181D+01, .347828D+01, .251030D+01,
     +  .181526D+01, .131488D+01, .956033D+00, .697237D+00,
     +  .510716D+00, .375609D+00, .277674D+00, .206120D+00,
     +  .153942D+00, .115127D+00, .866363D-01, .651987D-01,
     +  .492304D-01, .371793D-01, .280929D-01, .211942D-01,
     +  .159678D-01, .119856D-01, .896471D-02, .666883D-02,
     +  .493751D-02, .362910D-02, .265064D-02, .191893D-02,
     +  .137798D-02, .981230D-03, .690430D-03, .479449D-03,
     +  .329001D-03, .222232D-03, .147922D-03, .964239D-04,
     +  .616091D-04, .381510D-04, .227522D-04, .128320D-04,
     +  .669470D-05, .292815D-05, .787968D-06, .000000D+00 /
        DATA (UPDI(I),I=625,676) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .353063D+06, .268559D+06, .200947D+06,
     +  .150227D+06, .112230D+06, .837620D+05, .624672D+05,
     +  .465376D+05, .346414D+05, .257573D+05, .191343D+05,
     +  .141972D+05, .105236D+05, .779042D+04, .576093D+04,
     +  .425417D+04, .313783D+04, .231092D+04, .169975D+04,
     +  .124817D+04, .915305D+03, .670029D+03, .489744D+03,
     +  .357296D+03, .260240D+03, .189182D+03, .137337D+03,
     +  .990341D+02, .716269D+02, .516986D+02, .372607D+02,
     +  .268055D+02, .192593D+02, .138317D+02, .992055D+01,
     +  .711149D+01, .510080D+01, .366033D+01, .263147D+01 /
        DATA (UPDI(I),I=677,728) /
     +  .189501D+01, .136963D+01, .992886D+00, .722813D+00,
     +  .528308D+00, .388067D+00, .286201D+00, .212325D+00,
     +  .157715D+00, .117853D+00, .880627D-01, .660120D-01,
     +  .494913D-01, .371196D-01, .277983D-01, .207876D-01,
     +  .154892D-01, .115008D-01, .849501D-02, .624554D-02,
     +  .455993D-02, .330902D-02, .238132D-02, .170064D-02,
     +  .120524D-02, .844825D-03, .585382D-03, .401644D-03,
     +  .272160D-03, .182554D-03, .120801D-03, .791885D-04,
     +  .512019D-04, .327713D-04, .207975D-04, .132245D-04,
     +  .838629D-05, .540409D-05, .353667D-05, .239559D-05,
     +  .166217D-05, .119868D-05, .872543D-06, .641448D-06,
     +  .459211D-06, .315701D-06, .200342D-06, .112761D-06,
     +  .516724D-07, .153904D-07, .119126D-08, .000000D+00 /
        DATA (UPDI(I),I=729,780) /
     +  .537276D+06, .407439D+06, .303778D+06, .226292D+06,
     +  .168443D+06, .125258D+06, .930688D+05, .690780D+05,
     +  .512260D+05, .379442D+05, .280790D+05, .207532D+05,
     +  .153226D+05, .112980D+05, .832107D+04, .611973D+04,
     +  .449518D+04, .329675D+04, .241456D+04, .176547D+04,
     +  .128900D+04, .939413D+03, .683555D+03, .496420D+03,
     +  .359895D+03, .260391D+03, .188120D+03, .134983D+03,
     +  .971416D+02, .697622D+02, .500207D+02, .357980D+02,
     +  .255834D+02, .182752D+02, .130355D+02, .929280D+01,
     +  .662771D+01, .472908D+01, .338016D+01, .242005D+01,
     +  .173874D+01, .125295D+01, .906569D+00, .658537D+00,
     +  .480662D+00, .352212D+00, .259571D+00, .191518D+00,
     +  .142124D+00, .105459D+00, .784898D-01, .584287D-01 /
        DATA (UPDI(I),I=781,832) /
     +  .435068D-01, .323484D-01, .240155D-01, .177675D-01,
     +  .130996D-01, .960994D-02, .701755D-02, .509068D-02,
     +  .367115D-02, .262670D-02, .186577D-02, .131597D-02,
     +  .918721D-03, .634820D-03, .435000D-03, .295066D-03,
     +  .198702D-03, .132615D-03, .881935D-04, .583619D-04,
     +  .386723D-04, .257963D-04, .175236D-04, .121014D-04,
     +  .859959D-05, .625646D-05, .466914D-05, .352084D-05,
     +  .267479D-05, .200426D-05, .146940D-05, .103231D-05,
     +  .683654D-06, .413598D-06, .219190D-06, .934045D-07,
     +  .258026D-07, .206160D-08, .000000D+00, .764386D+06,
     +  .577888D+06, .429307D+06, .318644D+06, .236317D+06,
     +  .175083D+06, .129604D+06, .958337D+05, .707965D+05,
     +  .522395D+05, .385074D+05, .283494D+05, .208480D+05 /
        DATA (UPDI(I),I=833,884) /
     +  .153107D+05, .112306D+05, .822572D+04, .601697D+04,
     +  .439430D+04, .320469D+04, .233310D+04, .169596D+04,
     +  .123053D+04, .891347D+03, .644371D+03, .464989D+03,
     +  .334837D+03, .240740D+03, .171888D+03, .123086D+03,
     +  .879517D+02, .627394D+02, .446679D+02, .317534D+02,
     +  .225618D+02, .160054D+02, .113473D+02, .804756D+01,
     +  .570985D+01, .405775D+01, .288842D+01, .206304D+01,
     +  .147782D+01, .106280D+01, .767298D+00, .556528D+00,
     +  .405204D+00, .296676D+00, .217447D+00, .160270D+00,
     +  .118108D+00, .872921D-01, .645300D-01, .477123D-01,
     +  .352283D-01, .259704D-01, .190819D-01, .139732D-01,
     +  .101834D-01, .738815D-02, .532651D-02, .381836D-02,
     +  .271703D-02, .192003D-02, .134810D-02, .937524D-03 /
        DATA (UPDI(I),I=885,936) /
     +  .646057D-03, .442070D-03, .300029D-03, .202634D-03,
     +  .136118D-03, .914899D-04, .615445D-04, .417310D-04,
     +  .286888D-04, .201931D-04, .145092D-04, .107109D-04,
     +  .806150D-05, .616521D-05, .472438D-05, .360646D-05,
     +  .269674D-05, .195610D-05, .135347D-05, .877740D-06,
     +  .517723D-06, .265870D-06, .108891D-06, .287924D-07,
     +  .234200D-08, .000000D+00, .104071D+07, .784368D+06,
     +  .580580D+06, .429349D+06, .317244D+06, .234167D+06,
     +  .172688D+06, .127209D+06, .936149D+05, .688103D+05,
     +  .505241D+05, .370498D+05, .271375D+05, .198495D+05,
     +  .145006D+05, .105771D+05, .770469D+04, .560319D+04,
     +  .406884D+04, .294944D+04, .213459D+04, .154192D+04,
     +  .111187D+04, .800124D+03, .574707D+03, .411892D+03 /
        DATA (UPDI(I),I=937,988) /
     +  .294721D+03, .209395D+03, .149204D+03, .106082D+03,
     +  .752873D+02, .533256D+02, .377088D+02, .266516D+02,
     +  .188043D+02, .132589D+02, .935100D+01, .659755D+01,
     +  .466192D+01, .329948D+01, .234289D+01, .166840D+01,
     +  .119264D+01, .855812D+00, .616866D+00, .446300D+00,
     +  .324662D+00, .236405D+00, .173079D+00, .126690D+00,
     +  .929967D-01, .682808D-01, .501402D-01, .367702D-01,
     +  .269234D-01, .196508D-01, .142956D-01, .103524D-01,
     +  .746416D-02, .534965D-02, .381324D-02, .269928D-02,
     +  .189828D-02, .132720D-02, .919711D-03, .632231D-03,
     +  .432080D-03, .293425D-03, .198709D-03, .134249D-03,
     +  .910494D-04, .620658D-04, .428306D-04, .300792D-04,
     +  .216639D-04, .159302D-04, .119921D-04, .916191D-05 /
        DATA (UPDI(I),I=989,1040) /
     +  .706472D-05, .542950D-05, .413037D-05, .306618D-05,
     +  .219756D-05, .149824D-05, .953843D-06, .550489D-06,
     +  .275264D-06, .109028D-06, .277889D-07, .229487D-08,
     +  .000000D+00, .137276D+07, .103144D+07, .760671D+06,
     +  .560467D+06, .412592D+06, .303410D+06, .222908D+06,
     +  .163580D+06, .119918D+06, .878032D+05, .642172D+05,
     +  .469053D+05, .342190D+05, .249285D+05, .181366D+05,
     +  .131749D+05, .955695D+04, .692098D+04, .500431D+04,
     +  .361191D+04, .260259D+04, .187166D+04, .134358D+04,
     +  .962469D+03, .688122D+03, .490859D+03, .349549D+03,
     +  .247135D+03, .175232D+03, .123970D+03, .875374D+02,
     +  .616857D+02, .433934D+02, .305083D+02, .214100D+02,
     +  .150145D+02, .105309D+02, .738881D+01, .519160D+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .365350D+01, .257926D+01, .182599D+01, .129753D+01,
     +  .925475D+00, .662975D+00, .476667D+00, .344552D+00,
     +  .249272D+00, .181304D+00, .131835D+00, .961291D-01,
     +  .701133D-01, .511433D-01, .372590D-01, .271022D-01,
     +  .196545D-01, .142081D-01, .102265D-01, .732960D-02,
     +  .522371D-02, .370349D-02, .260874D-02, .182632D-02,
     +  .127192D-02, .878577D-03, .602679D-03, .411509D-03,
     +  .279687D-03, .189932D-03, .129022D-03, .882222D-04,
     +  .608316D-04, .425856D-04, .303970D-04, .222502D-04,
     +  .166058D-04, .126389D-04, .972269D-05, .751050D-05,
     +  .576001D-05, .435343D-05, .320232D-05, .226661D-05,
     +  .152277D-05, .952502D-06, .538510D-06, .262635D-06,
     +  .100852D-06, .248614D-07, .208221D-08, .000000D+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .176712D+07, .132365D+07, .972609D+06, .713996D+06,
     +  .523664D+06, .383654D+06, .280798D+06, .205279D+06,
     +  .149910D+06, .109338D+06, .796548D+05, .579519D+05,
     +  .421092D+05, .305531D+05, .221382D+05, .160157D+05,
     +  .115693D+05, .834313D+04, .600695D+04, .431693D+04,
     +  .309704D+04, .221743D+04, .158467D+04, .113004D+04,
     +  .804218D+03, .570993D+03, .404688D+03, .284730D+03,
     +  .200907D+03, .141435D+03, .993694D+02, .696690D+02,
     +  .487566D+02, .341008D+02, .238042D+02, .166041D+02,
     +  .115823D+02, .808193D+01, .564694D+01, .395158D+01,
     +  .277373D+01, .195231D+01, .137912D+01, .977816D+00,
     +  .696215D+00, .497483D+00, .357352D+00, .256894D+00,
     +  .185647D+00, .134120D+00, .971601D-01, .704078D-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .510259D-01, .369361D-01, .266967D-01, .192405D-01,
     +  .138244D-01, .989220D-02, .704972D-02, .499735D-02,
     +  .352500D-02, .247156D-02, .172301D-02, .119570D-02,
     +  .823570D-03, .563952D-03, .384851D-03, .261863D-03,
     +  .178355D-03, .121810D-03, .839295D-04, .584649D-04,
     +  .414269D-04, .299515D-04, .221854D-04, .167209D-04,
     +  .128048D-04, .987506D-05, .761633D-05, .581418D-05,
     +  .435940D-05, .317446D-05, .221835D-05, .146860D-05,
     +  .902861D-06, .500304D-06, .238179D-06, .887944D-07,
     +  .212180D-07, .180121D-08, .000000D+00, .223025D+07,
     +  .166544D+07, .121930D+07, .891817D+06, .651665D+06,
     +  .475655D+06, .346825D+06, .252589D+06, .183753D+06,
     +  .133506D+06, .968818D+05, .702082D+05, .508122D+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .367201D+05, .264988D+05, .190920D+05, .137344D+05,
     +  .986307D+04, .707122D+04, .506006D+04, .361444D+04,
     +  .257654D+04, .183313D+04, .130135D+04, .921912D+03,
     +  .651521D+03, .459595D+03, .321804D+03, .225973D+03,
     +  .158307D+03, .110672D+03, .772045D+02, .537546D+02,
     +  .374033D+02, .259725D+02, .180206D+02, .125027D+02,
     +  .867684D+01, .602919D+01, .419559D+01, .292835D+01,
     +  .204935D+01, .143925D+01, .101445D+01, .717968D+00,
     +  .509911D+00, .364029D+00, .260065D+00, .186756D+00,
     +  .134068D+00, .965063D-01, .694940D-01, .500470D-01,
     +  .360030D-01, .258624D-01, .185277D-01, .132346D-01,
     +  .941695D-02, .667459D-02, .470729D-02, .330444D-02,
     +  .230687D-02, .160192D-02, .110806D-02, .761297D-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .520576D-03, .355177D-03, .242016D-03, .165360D-03,
     +  .113537D-03, .787960D-04, .553951D-04, .396588D-04,
     +  .289685D-04, .216459D-04, .164194D-04, .126118D-04,
     +  .972414D-05, .747320D-05, .566999D-05, .421376D-05,
     +  .303582D-05, .209414D-05, .136609D-05, .825586D-06,
     +  .448519D-06, .208531D-06, .755492D-07, .175302D-07,
     +  .150778D-08, .000000D+00, .104420D+06, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .228600D+05, .178890D+05, .138296D+05,
     +  .106819D+05, .825026D+04, .636621D+04, .491186D+04,
     +  .378604D+04, .291776D+04, .224627D+04, .172890D+04,
     +  .132923D+04, .102163D+04, .784296D+03, .601860D+03,
     +  .461284D+03, .353376D+03, .270348D+03, .206710D+03,
     +  .157827D+03, .120429D+03, .917551D+02, .698565D+02,
     +  .531000D+02, .403276D+02, .305810D+02, .231746D+02,
     +  .174622D+02, .131994D+02, .995951D+01, .751022D+01,
     +  .565418D+01, .425465D+01, .320012D+01, .240570D+01,
     +  .180737D+01, .135939D+01, .102266D+01, .771113D+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .582241D+00, .441444D+00, .335654D+00, .256480D+00,
     +  .196785D+00, .151916D+00, .117805D+00, .920111D-01,
     +  .720128D-01, .567789D-01, .447966D-01, .354918D-01,
     +  .281253D-01, .223128D-01, .176686D-01, .139742D-01,
     +  .110027D-01, .862838D-02, .672196D-02, .520900D-02,
     +  .400119D-02, .305117D-02, .230253D-02, .172120D-02,
     +  .127399D-02, .930178D-03, .668543D-03, .473557D-03,
     +  .329098D-03, .224495D-03, .149085D-03, .962552D-04,
     +  .593266D-04, .345183D-04, .178334D-04, .726259D-05,
     +  .622594D-06, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .546769D+05, .426066D+05, .327817D+05, .252023D+05,
     +  .193719D+05, .148775D+05, .114232D+05, .876294D+04,
     +  .672024D+04, .514874D+04, .394331D+04, .301699D+04,
     +  .230728D+04, .176258D+04, .134580D+04, .102635D+04,
     +  .782273D+03, .595476D+03, .452980D+03, .344110D+03,
     +  .261216D+03, .198002D+03, .149958D+03, .113396D+03,
     +  .856650D+02, .646178D+02, .487049D+02, .364998D+02,
     +  .274384D+02, .205907D+02, .154404D+02, .115601D+02,
     +  .864944D+01, .646922D+01, .483536D+01, .361218D+01,
     +  .270119D+01, .202058D+01, .151478D+01, .113730D+01,
     +  .857325D+00, .648180D+00, .492412D+00, .375632D+00,
     +  .288249D+00, .222185D+00, .172446D+00, .134110D+00,
     +  .105032D+00, .823057D-01, .647500D-01, .509489D-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .401250D-01, .315431D-01, .247626D-01, .193548D-01,
     +  .150672D-01, .116551D-01, .896809D-02, .684261D-02,
     +  .518429D-02, .388906D-02, .289170D-02, .213069D-02,
     +  .155060D-02, .111308D-02, .789724D-03, .552160D-03,
     +  .381436D-03, .259266D-03, .174149D-03, .114985D-03,
     +  .750891D-04, .481369D-04, .306780D-04, .191969D-04,
     +  .119905D-04, .734705D-05, .448448D-05, .265260D-05,
     +  .154555D-05, .838377D-06, .433788D-06, .187456D-06,
     +  .615284D-07, .313946D-08, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .969487D+05,
     +  .752560D+05, .576493D+05, .441287D+05, .337697D+05,
     +  .258214D+05, .197373D+05, .150737D+05, .115075D+05,
     +  .877695D+04, .669127D+04, .509614D+04, .387927D+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .294981D+04, .224172D+04, .170164D+04, .129082D+04,
     +  .977947D+03, .740350D+03, .559723D+03, .422817D+03,
     +  .318937D+03, .240355D+03, .180854D+03, .135940D+03,
     +  .102024D+03, .765048D+02, .570348D+02, .426509D+02,
     +  .318396D+02, .237482D+02, .176855D+02, .131607D+02,
     +  .979029D+01, .727733D+01, .540676D+01, .402071D+01,
     +  .299116D+01, .222994D+01, .166509D+01, .124820D+01,
     +  .938513D+00, .708966D+00, .537807D+00, .410308D+00,
     +  .314429D+00, .242559D+00, .187481D+00, .145886D+00,
     +  .113577D+00, .887476D-01, .693599D-01, .542445D-01,
     +  .423473D-01, .330089D-01, .256202D-01, .198049D-01,
     +  .152156D-01, .116276D-01, .881368D-02, .663446D-02,
     +  .494652D-02, .365645D-02, .267950D-02, .194036D-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .138734D-02, .981506D-03, .685540D-03, .474166D-03,
     +  .323906D-03, .219720D-03, .147669D-03, .991184D-04,
     +  .663373D-04, .449340D-04, .306628D-04, .214323D-04,
     +  .151946D-04, .110353D-04, .806045D-05, .595766D-05,
     +  .433798D-05, .312046D-05, .215535D-05, .141935D-05,
     +  .862052D-06, .467279D-06, .210284D-06, .638622D-07,
     +  .491282D-08, .000000D+00, .192837D+06, .117146D+06,
     +  .893695D+05, .681297D+05, .519193D+05, .395344D+05,
     +  .300915D+05, .228846D+05, .173957D+05, .132113D+05,
     +  .100281D+05, .760445D+04, .576315D+04, .436307D+04,
     +  .330093D+04, .249450D+04, .188368D+04, .142066D+04,
     +  .107056D+04, .805650D+03, .605748D+03, .454790D+03,
     +  .341105D+03, .255442D+03, .191074D+03, .142705D+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .106482D+03, .789833D+02, .587658D+02, .436480D+02,
     +  .323879D+02, .239952D+02, .177622D+02, .131444D+02,
     +  .971839D+01, .718212D+01, .531219D+01, .393091D+01,
     +  .291472D+01, .216481D+01, .161403D+01, .120706D+01,
     +  .906832D+00, .684147D+00, .519011D+00, .395469D+00,
     +  .303277D+00, .233014D+00, .180187D+00, .139396D+00,
     +  .108213D+00, .840212D-01, .652706D-01, .506151D-01,
     +  .391853D-01, .302101D-01, .231960D-01, .177041D-01,
     +  .134405D-01, .101234D-01, .757270D-02, .561252D-02,
     +  .412487D-02, .300632D-02, .216594D-02, .154187D-02,
     +  .108687D-02, .757306D-03, .523263D-03, .357893D-03,
     +  .243730D-03, .165131D-03, .112247D-03, .765789D-04,
     +  .531761D-04, .374556D-04, .271031D-04, .199442D-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .149885D-04, .113043D-04, .856571D-05, .637400D-05,
     +  .464861D-05, .324741D-05, .214983D-05, .130749D-05,
     +  .704897D-06, .312281D-06, .920994D-07, .717893D-08,
     +  .000000D+00, .238273D+06, .183527D+06, .139344D+06,
     +  .105724D+06, .801793D+05, .607595D+05, .460198D+05,
     +  .348270D+05, .263416D+05, .199059D+05, .150331D+05,
     +  .113423D+05, .855162D+04, .644091D+04, .484743D+04,
     +  .364407D+04, .273710D+04, .205335D+04, .153895D+04,
     +  .115188D+04, .861290D+03, .643087D+03, .479618D+03,
     +  .357152D+03, .265622D+03, .197239D+03, .146309D+03,
     +  .107878D+03, .797816D+02, .589024D+02, .434386D+02,
     +  .319854D+02, .235286D+02, .173036D+02, .127121D+02,
     +  .933530D+01, .686034D+01, .504430D+01, .371610D+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .274245D+01, .203142D+01, .150945D+01, .112655D+01,
     +  .844349D+00, .636205D+00, .481472D+00, .366628D+00,
     +  .279683D+00, .214670D+00, .164831D+00, .126969D+00,
     +  .978261D-01, .753930D-01, .580060D-01, .445468D-01,
     +  .340729D-01, .259539D-01, .196552D-01, .148042D-01,
     +  .110653D-01, .821288D-02, .604082D-02, .440492D-02,
     +  .318511D-02, .227538D-02, .160552D-02, .112048D-02,
     +  .771892D-03, .525877D-03, .353403D-03, .235079D-03,
     +  .154317D-03, .100441D-03, .646410D-04, .415811D-04,
     +  .265559D-04, .170719D-04, .109583D-04, .711160D-05,
     +  .460112D-05, .300681D-05, .193603D-05, .124677D-05,
     +  .774317D-06, .466757D-06, .263100D-06, .136301D-06,
     +  .603287D-07, .185758D-07, .139526D-08, .000000D+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .351461D+06, .269627D+06, .203772D+06, .153894D+06,
     +  .116163D+06, .876150D+05, .660444D+05, .497430D+05,
     +  .374412D+05, .281566D+05, .211595D+05, .158858D+05,
     +  .119174D+05, .893092D+04, .668719D+04, .500147D+04,
     +  .373720D+04, .278905D+04, .207932D+04, .154811D+04,
     +  .115133D+04, .855010D+03, .634173D+03, .469641D+03,
     +  .347328D+03, .256453D+03, .189143D+03, .138645D+03,
     +  .101935D+03, .748159D+02, .548439D+02, .401414D+02,
     +  .293479D+02, .214518D+02, .156617D+02, .114303D+02,
     +  .834718D+01, .609930D+01, .446493D+01, .327443D+01,
     +  .241004D+01, .177944D+01, .131947D+01, .982549D+00,
     +  .735408D+00, .552807D+00, .418034D+00, .316659D+00,
     +  .241283D+00, .183903D+00, .140590D+00, .107503D+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .822111D-01, .627659D-01, .478261D-01, .363000D-01,
     +  .274372D-01, .206223D-01, .154155D-01, .114384D-01,
     +  .842845D-02, .615664D-02, .445902D-02, .320355D-02,
     +  .227449D-02, .159614D-02, .110856D-02, .760861D-03,
     +  .517085D-03, .347402D-03, .231623D-03, .153055D-03,
     +  .100772D-03, .661563D-04, .438163D-04, .291839D-04,
     +  .197969D-04, .136119D-04, .955083D-05, .675408D-05,
     +  .482512D-05, .341115D-05, .238107D-05, .160048D-05,
     +  .102477D-05, .604498D-06, .316916D-06, .135894D-06,
     +  .384733D-07, .302742D-08, .000000D+00, .495983D+06,
     +  .379033D+06, .285172D+06, .214402D+06, .161100D+06,
     +  .120953D+06, .907531D+05, .680353D+05, .509688D+05,
     +  .381484D+05, .285310D+05, .213171D+05, .159139D+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .118675D+05, .884193D+04, .658004D+04, .489189D+04,
     +  .363223D+04, .269398D+04, .199534D+04, .147614D+04,
     +  .109042D+04, .804438D+03, .592511D+03, .435796D+03,
     +  .319990D+03, .234677D+03, .171035D+03, .125027D+03,
     +  .912351D+02, .664875D+02, .483768D+02, .351572D+02,
     +  .255443D+02, .185361D+02, .134457D+02, .975842D+01,
     +  .708670D+01, .515551D+01, .375749D+01, .274824D+01,
     +  .201642D+01, .148565D+01, .109922D+01, .817324D+00,
     +  .610298D+00, .458362D+00, .344800D+00, .260850D+00,
     +  .197380D+00, .149780D+00, .113683D+00, .862840D-01,
     +  .653819D-01, .494422D-01, .372463D-01, .279428D-01,
     +  .208493D-01, .154720D-01, .113997D-01, .834182D-02,
     +  .605312D-02, .435584D-02, .311038D-02, .219562D-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .153298D-02, .106001D-02, .725155D-03, .491820D-03,
     +  .330443D-03, .220860D-03, .146845D-03, .976918D-04,
     +  .652091D-04, .441794D-04, .303145D-04, .212779D-04,
     +  .152008D-04, .110710D-04, .811684D-05, .597438D-05,
     +  .433500D-05, .307882D-05, .209756D-05, .135090D-05,
     +  .797164D-06, .414237D-06, .174130D-06, .478270D-07,
     +  .382103D-08, .000000D+00, .677442D+06, .515764D+06,
     +  .386348D+06, .289193D+06, .216332D+06, .161695D+06,
     +  .120774D+06, .901293D+05, .672101D+05, .500714D+05,
     +  .372728D+05, .277172D+05, .205931D+05, .152832D+05,
     +  .113314D+05, .839140D+04, .620762D+04, .458615D+04,
     +  .338430D+04, .249387D+04, .183543D+04, .134877D+04,
     +  .989787D+03, .725153D+03, .530482D+03, .387390D+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .282539D+03, .204754D+03, .148831D+03, .107989D+03,
     +  .782429D+02, .565998D+02, .408912D+02, .295353D+02,
     +  .213038D+02, .153607D+02, .110805D+02, .799807D+01,
     +  .578290D+01, .418896D+01, .304485D+01, .222018D+01,
     +  .162547D+01, .119503D+01, .882799D+00, .654850D+00,
     +  .488515D+00, .364969D+00, .274172D+00, .205987D+00,
     +  .155182D+00, .116931D+00, .880988D-01, .662695D-01,
     +  .497448D-01, .372023D-01, .277085D-01, .205286D-01,
     +  .151274D-01, .110705D-01, .804716D-02, .580241D-02,
     +  .414991D-02, .294630D-02, .206863D-02, .143758D-02,
     +  .990141D-03, .675470D-03, .457442D-03, .307512D-03,
     +  .206124D-03, .137899D-03, .926502D-04, .627546D-04,
     +  .433128D-04, .303915D-04, .218339D-04, .159658D-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .118611D-04, .884211D-05, .657937D-05, .480859D-05,
     +  .341986D-05, .232597D-05, .148816D-05, .868972D-06,
     +  .444089D-06, .182103D-06, .484923D-07, .392652D-08,
     +  .000000D+00, .901840D+06, .684098D+06, .510248D+06,
     +  .380291D+06, .283241D+06, .210778D+06, .156738D+06,
     +  .116446D+06, .864427D+05, .641071D+05, .475016D+05,
     +  .351602D+05, .260007D+05, .192054D+05, .141715D+05,
     +  .104441D+05, .768851D+04, .565234D+04, .415036D+04,
     +  .304306D+04, .222826D+04, .162905D+04, .118927D+04,
     +  .866742D+03, .630700D+03, .458101D+03, .332295D+03,
     +  .239473D+03, .173102D+03, .124896D+03, .899797D+02,
     +  .647183D+02, .464857D+02, .333812D+02, .239359D+02,
     +  .171564D+02, .123019D+02, .882654D+01, .634337D+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .456716D+01, .329945D+01, .239103D+01, .173965D+01,
     +  .127094D+01, .932849D+00, .687473D+00, .509451D+00,
     +  .378042D+00, .282034D+00, .210416D+00, .157398D+00,
     +  .117762D+00, .880899D-01, .657908D-01, .490325D-01,
     +  .364111D-01, .269298D-01, .198155D-01, .145034D-01,
     +  .105447D-01, .761628D-02, .545859D-02, .388136D-02,
     +  .274072D-02, .191471D-02, .132496D-02, .909417D-03,
     +  .618984D-03, .418803D-03, .281843D-03, .189551D-03,
     +  .127622D-03, .865716D-04, .594163D-04, .416562D-04,
     +  .297427D-04, .217252D-04, .161251D-04, .121119D-04,
     +  .909791D-05, .678861D-05, .496014D-05, .351140D-05,
     +  .237121D-05, .150063D-05, .863851D-06, .432994D-06,
     +  .172911D-06, .446337D-07, .366178D-08, .000000D+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .117549D+07, .888494D+06, .659917D+06, .489763D+06,
     +  .363218D+06, .269131D+06, .199260D+06, .147389D+06,
     +  .108929D+06, .804224D+05, .593219D+05, .437097D+05,
     +  .321743D+05, .236553D+05, .173732D+05, .127431D+05,
     +  .933600D+04, .683038D+04, .499086D+04, .364127D+04,
     +  .265298D+04, .192979D+04, .140163D+04, .101625D+04,
     +  .735632D+03, .531489D+03, .383466D+03, .274838D+03,
     +  .197580D+03, .141773D+03, .101568D+03, .726420D+02,
     +  .518798D+02, .370415D+02, .264063D+02, .188168D+02,
     +  .134130D+02, .956690D+01, .683448D+01, .489135D+01,
     +  .351231D+01, .252981D+01, .182928D+01, .132811D+01,
     +  .968632D+00, .709252D+00, .522156D+00, .384891D+00,
     +  .285200D+00, .211320D+00, .156980D+00, .116636D+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .866396D-01, .642585D-01, .475578D-01, .350744D-01,
     +  .257657D-01, .188337D-01, .136952D-01, .989470D-02,
     +  .710328D-02, .506160D-02, .357930D-02, .251459D-02,
     +  .174864D-02, .120539D-02, .824877D-03, .560444D-03,
     +  .379059D-03, .255511D-03, .172497D-03, .116907D-03,
     +  .800459D-04, .556009D-04, .395057D-04, .285985D-04,
     +  .211412D-04, .158428D-04, .119685D-04, .901302D-05,
     +  .671534D-05, .488660D-05, .343334D-05, .229595D-05,
     +  .143432D-05, .812578D-06, .398976D-06, .155076D-06,
     +  .388269D-07, .322688D-08, .000000D+00, .150491D+07,
     +  .113351D+07, .838428D+06, .619664D+06, .457630D+06,
     +  .337654D+06, .248926D+06, .183333D+06, .134904D+06,
     +  .991637D+05, .728217D+05, .534167D+05, .391418D+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .286467D+05, .209420D+05, .152893D+05, .111487D+05,
     +  .811783D+04, .590306D+04, .428591D+04, .310732D+04,
     +  .224906D+04, .162532D+04, .117245D+04, .844348D+03,
     +  .606858D+03, .435540D+03, .310478D+03, .222001D+03,
     +  .158433D+03, .112880D+03, .802853D+02, .570169D+02,
     +  .404801D+02, .286926D+02, .203285D+02, .144065D+02,
     +  .102157D+02, .725508D+01, .516173D+01, .368434D+01,
     +  .263778D+01, .189574D+01, .136790D+01, .991407D+00,
     +  .721319D+00, .527621D+00, .386371D+00, .284394D+00,
     +  .209307D+00, .154431D+00, .113966D+00, .840802D-01,
     +  .619386D-01, .455314D-01, .333569D-01, .243436D-01,
     +  .176805D-01, .127760D-01, .917497D-02, .654822D-02,
     +  .464046D-02, .326442D-02, .228248D-02, .158050D-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .108574D-02, .741113D-03, .502887D-03, .340189D-03,
     +  .229801D-03, .155797D-03, .106300D-03, .734425D-04,
     +  .515725D-04, .370631D-04, .271236D-04, .202236D-04,
     +  .152446D-04, .115431D-04, .868714D-05, .644643D-05,
     +  .466138D-05, .324502D-05, .214574D-05, .132175D-05,
     +  .736213D-06, .353864D-06, .133860D-06, .325373D-07,
     +  .273898D-08, .000000D+00, .189667D+07, .142370D+07,
     +  .104881D+07, .771995D+06, .567780D+06, .417188D+06,
     +  .306271D+06, .224614D+06, .164574D+06, .120451D+06,
     +  .880689D+05, .643171D+05, .469197D+05, .341851D+05,
     +  .248775D+05, .180794D+05, .131222D+05, .951014D+04,
     +  .688282D+04, .497340D+04, .358834D+04, .258454D+04,
     +  .185854D+04, .133400D+04, .955830D+03, .683461D+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .487978D+03, .346015D+03, .246104D+03, .174697D+03,
     +  .123794D+03, .875689D+02, .618464D+02, .436654D+02,
     +  .307763D+02, .216815D+02, .152774D+02, .107711D+02,
     +  .760523D+01, .537933D+01, .381706D+01, .271658D+01,
     +  .194064D+01, .139179D+01, .100250D+01, .724821D+00,
     +  .526822D+00, .383299D+00, .280291D+00, .204929D+00,
     +  .150199D+00, .110110D+00, .806967D-01, .590546D-01,
     +  .431266D-01, .313914D-01, .227639D-01, .164311D-01,
     +  .118015D-01, .842593D-02, .598009D-02, .421569D-02,
     +  .295102D-02, .205419D-02, .141691D-02, .970393D-03,
     +  .660988D-03, .448155D-03, .303370D-03, .205462D-03,
     +  .139932D-03, .961237D-04, .669863D-04, .475015D-04,
     +  .344674D-04, .254385D-04, .190797D-04, .144277D-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .109233D-04, .819776D-05, .604855D-05, .433985D-05,
     +  .299027D-05, .195333D-05, .118559D-05, .648882D-06,
     +  .305205D-06, .112378D-06, .265455D-07, .226305D-08,
     +  .000000D+00, .235725D+07, .176350D+07, .129396D+07,
     +  .948635D+06, .694873D+06, .508490D+06, .371760D+06,
     +  .271510D+06, .198099D+06, .144374D+06, .105108D+06,
     +  .764295D+05, .555122D+05, .402672D+05, .291729D+05,
     +  .211057D+05, .152489D+05, .110007D+05, .792459D+04,
     +  .569929D+04, .409253D+04, .293355D+04, .209927D+04,
     +  .149938D+04, .106899D+04, .760525D+03, .540235D+03,
     +  .381074D+03, .269630D+03, .190394D+03, .134201D+03,
     +  .944216D+02, .663244D+02, .465716D+02, .326431D+02,
     +  .228686D+02, .160232D+02, .112331D+02, .788613D+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .554598D+01, .391246D+01, .276817D+01, .196577D+01,
     +  .140137D+01, .100325D+01, .720890D+00, .520699D+00,
     +  .376442D+00, .273516D+00, .198684D+00, .144680D+00,
     +  .105378D+00, .767295D-01, .557911D-01, .404837D-01,
     +  .292833D-01, .211047D-01, .151424D-01, .108125D-01,
     +  .767681D-02, .541933D-02, .380136D-02, .264863D-02,
     +  .183608D-02, .126199D-02, .861982D-03, .586160D-03,
     +  .397277D-03, .269235D-03, .182889D-03, .125159D-03,
     +  .865547D-04, .608090D-04, .434973D-04, .318153D-04,
     +  .236323D-04, .177921D-04, .134684D-04, .101775D-04,
     +  .760499D-05, .557258D-05, .396349D-05, .270105D-05,
     +  .174192D-05, .104128D-05, .559770D-06, .257597D-06,
     +  .923464D-07, .212207D-07, .183188D-08, .000000D+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .889481D+05, .526114D+05, .402316D+05, .307651D+05,
     +  .235262D+05, .179908D+05, .137580D+05, .105213D+05,
     +  .804616D+04, .615347D+04, .470614D+04, .359936D+04,
     +  .275300D+04, .210577D+04, .161082D+04, .123232D+04,
     +  .942848D+03, .721471D+03, .552160D+03, .422667D+03,
     +  .323620D+03, .247858D+03, .189901D+03, .145561D+03,
     +  .111635D+03, .856726D+02, .658008D+02, .503993D+02,
     +  .387971D+02, .299076D+02, .230934D+02, .178669D+02,
     +  .138553D+02, .107815D+02, .841076D+01, .658532D+01,
     +  .517706D+01, .408802D+01, .324336D+01, .258561D+01,
     +  .207198D+01, .166828D+01, .134939D+01, .109600D+01,
     +  .893432D+00, .730497D+00, .599104D+00, .491512D+00,
     +  .404050D+00, .331772D+00, .272440D+00, .223415D+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .182843D+00, .149241D+00, .121414D+00, .983935D-01,
     +  .793829D-01, .637244D-01, .508699D-01, .403595D-01,
     +  .318059D-01, .248816D-01, .193096D-01, .148735D-01,
     +  .113308D-01, .854347D-02, .636988D-02, .469141D-02,
     +  .340915D-02, .244114D-02, .171987D-02, .119020D-02,
     +  .807216D-03, .535049D-03, .347108D-03, .218308D-03,
     +  .132991D-03, .780970D-04, .439464D-04, .235202D-04,
     +  .118582D-04, .556891D-05, .238198D-05, .912564D-06,
     +  .301294D-06, .811985D-07, .163082D-07, .205790D-08,
     +  .111205D-09, .755118D-12, .000000D+00, .896413D+05,
     +  .696290D+05, .533943D+05, .409375D+05, .313865D+05,
     +  .240591D+05, .184418D+05, .141330D+05, .108305D+05,
     +  .829778D+04, .635697D+04, .486893D+04, .372894D+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .285514D+04, .218593D+04, .167314D+04, .128055D+04,
     +  .979826D+03, .749677D+03, .573453D+03, .438647D+03,
     +  .335471D+03, .256575D+03, .196216D+03, .150079D+03,
     +  .114800D+03, .878512D+02, .669938D+02, .513213D+02,
     +  .393406D+02, .301904D+02, .231956D+02, .178514D+02,
     +  .137749D+02, .106495D+02, .825670D+01, .642438D+01,
     +  .501740D+01, .393586D+01, .310094D+01, .245584D+01,
     +  .195396D+01, .156214D+01, .125432D+01, .101135D+01,
     +  .818177D+00, .664385D+00, .539833D+00, .439847D+00,
     +  .358060D+00, .291649D+00, .237284D+00, .192732D+00,
     +  .156147D+00, .126119D+00, .101467D+00, .812730D-01,
     +  .647638D-01, .513222D-01, .404125D-01, .316070D-01,
     +  .245345D-01, .188896D-01, .144334D-01, .109048D-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .815139D-02, .602387D-02, .439561D-02, .316381D-02,
     +  .224244D-02, .156289D-02, .106852D-02, .715024D-03,
     +  .466185D-03, .296333D-03, .181267D-03, .106123D-03,
     +  .585403D-04, .295931D-04, .128683D-04, .384236D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .120393D+06, .935206D+05,
     +  .717146D+05, .549749D+05, .421385D+05, .322879D+05,
     +  .247369D+05, .189447D+05, .145065D+05, .111036D+05,
     +  .849739D+04, .650012D+04, .497129D+04, .380031D+04,
     +  .290451D+04, .221881D+04, .169459D+04, .129358D+04,
     +  .987228D+03, .753057D+03, .574308D+03, .437785D+03,
     +  .333654D+03, .254188D+03, .193626D+03, .147454D+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .112312D+03, .852049D+02, .649168D+02, .494692D+02,
     +  .377258D+02, .287901D+02, .219986D+02, .168456D+02,
     +  .129188D+02, .993070D+01, .765829D+01, .592543D+01,
     +  .460379D+01, .359156D+01, .281631D+01, .221847D+01,
     +  .175615D+01, .139639D+01, .111529D+01, .893963D+00,
     +  .719551D+00, .579630D+00, .468442D+00, .378308D+00,
     +  .305796D+00, .246941D+00, .199127D+00, .160179D+00,
     +  .128472D+00, .102638D+00, .816402D-01, .646015D-01,
     +  .508371D-01, .397482D-01, .308684D-01, .237909D-01,
     +  .181862D-01, .137972D-01, .103497D-01, .768107D-02,
     +  .563657D-02, .408493D-02, .292144D-02, .205850D-02,
     +  .142773D-02, .972677D-03, .650092D-03, .424689D-03,
     +  .271947D-03, .168994D-03, .102014D-03, .594741D-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .333805D-04, .178795D-04, .909273D-05, .432092D-05,
     +  .189433D-05, .735630D-06, .238372D-06, .496738D-07,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .161646D+06, .125380D+06, .959782D+05,
     +  .734396D+05, .561832D+05, .429618D+05, .328445D+05,
     +  .250975D+05, .191730D+05, .146394D+05, .111746D+05,
     +  .852519D+04, .650189D+04, .495588D+04, .377620D+04,
     +  .287555D+04, .218892D+04, .166517D+04, .126626D+04,
     +  .962277D+03, .731004D+03, .554956D+03, .421156D+03,
     +  .319420D+03, .242184D+03, .183533D+03, .139085D+03,
     +  .104946D+03, .795107D+02, .602344D+02, .456533D+02,
     +  .346150D+02, .262705D+02, .199747D+02, .152054D+02,
     +  .115984D+02, .887309D+01, .680872D+01, .524540D+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .405678D+01, .315347D+01, .246233D+01, .193222D+01,
     +  .152314D+01, .120625D+01, .958863D+00, .765600D+00,
     +  .611857D+00, .490744D+00, .393365D+00, .315669D+00,
     +  .253105D+00, .202681D+00, .161921D+00, .128991D+00,
     +  .102360D+00, .808731D-01, .635657D-01, .496881D-01,
     +  .385893D-01, .297681D-01, .227892D-01, .173038D-01,
     +  .130403D-01, .971687D-02, .716368D-02, .522293D-02,
     +  .376142D-02, .267426D-02, .187418D-02, .129400D-02,
     +  .878610D-03, .586379D-03, .383548D-03, .246950D-03,
     +  .155296D-03, .958351D-04, .579792D-04, .345782D-04,
     +  .203713D-04, .120084D-04, .710568D-05, .426994D-05,
     +  .258237D-05, .155553D-05, .897458D-06, .474111D-06,
     +  .211115D-06, .639063D-07, .491315D-08, .000000D+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .178323D+06, .166510D+06, .127117D+06, .969964D+05,
     +  .739929D+05, .564149D+05, .429999D+05, .327564D+05,
     +  .249449D+05, .189848D+05, .144434D+05, .109815D+05,
     +  .834593D+04, .633867D+04, .481208D+04, .365055D+04,
     +  .276811D+04, .209740D+04, .158844D+04, .120205D+04,
     +  .909210D+03, .687179D+03, .519116D+03, .391860D+03,
     +  .295663D+03, .222933D+03, .168069D+03, .126126D+03,
     +  .950266D+02, .715739D+02, .539240D+02, .406327D+02,
     +  .306394D+02, .231418D+02, .174949D+02, .132499D+02,
     +  .100623D+02, .766317D+01, .585832D+01, .449542D+01,
     +  .346691D+01, .268564D+01, .209079D+01, .163520D+01,
     +  .128496D+01, .101362D+01, .803284D+00, .637239D+00,
     +  .507444D+00, .403874D+00, .321861D+00, .256314D+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .203876D+00, .161798D+00, .128049D+00, .100951D+00,
     +  .792434D-01, .618830D-01, .480621D-01, .370871D-01,
     +  .284267D-01, .216238D-01, .163147D-01, .122176D-01,
     +  .904681D-02, .662840D-02, .480353D-02, .343926D-02,
     +  .243188D-02, .169584D-02, .116595D-02, .789205D-03,
     +  .525962D-03, .344352D-03, .222694D-03, .141391D-03,
     +  .887460D-04, .551510D-04, .342224D-04, .212862D-04,
     +  .134317D-04, .858075D-05, .555645D-05, .358129D-05,
     +  .225513D-05, .133454D-05, .710051D-06, .312901D-06,
     +  .921321D-07, .717919D-08, .000000D+00, .300831D+06,
     +  .231994D+06, .176405D+06, .134066D+06, .101851D+06,
     +  .773328D+05, .586932D+05, .445191D+05, .337532D+05,
     +  .255742D+05, .193680D+05, .146577D+05, .110873D+05 /
        DATA (UPDI(I),I=3017,3068) /
     +  .838046D+04, .633098D+04, .477899D+04, .360535D+04,
     +  .271770D+04, .204732D+04, .154099D+04, .115916D+04,
     +  .871177D+03, .654323D+03, .491022D+03, .368245D+03,
     +  .275946D+03, .206717D+03, .154107D+03, .115329D+03,
     +  .862692D+02, .645342D+02, .482738D+02, .361271D+02,
     +  .270768D+02, .203068D+02, .152543D+02, .114875D+02,
     +  .867401D+01, .657336D+01, .499973D+01, .382153D+01,
     +  .293394D+01, .226365D+01, .175467D+01, .136666D+01,
     +  .106866D+01, .839627D+00, .660401D+00, .521503D+00,
     +  .411639D+00, .325385D+00, .257050D+00, .202844D+00,
     +  .159722D+00, .125427D+00, .981242D-01, .764353D-01,
     +  .592369D-01, .456582D-01, .349662D-01, .265986D-01,
     +  .200809D-01, .150354D-01, .111738D-01, .820958D-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .596740D-02, .428935D-02, .304525D-02, .213413D-02,
     +  .147398D-02, .100270D-02, .670496D-03, .440431D-03,
     +  .283225D-03, .179013D-03, .110218D-03, .663227D-04,
     +  .388704D-04, .222366D-04, .123840D-04, .676633D-05,
     +  .362477D-05, .193433D-05, .102443D-05, .544701D-06,
     +  .282882D-06, .140020D-06, .607704D-07, .185989D-07,
     +  .139544D-08, .000000D+00, .412883D+06, .317214D+06,
     +  .240160D+06, .181721D+06, .137442D+06, .103887D+06,
     +  .784877D+05, .592590D+05, .447183D+05, .337219D+05,
     +  .254156D+05, .191410D+05, .144069D+05, .108351D+05,
     +  .814371D+04, .611569D+04, .458959D+04, .344124D+04,
     +  .257837D+04, .193006D+04, .144371D+04, .107888D+04,
     +  .805630D+03, .601008D+03, .448017D+03, .333663D+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .248389D+03, .183973D+03, .136778D+03, .101630D+03,
     +  .755035D+02, .560837D+02, .416699D+02, .310023D+02,
     +  .230756D+02, .172012D+02, .128519D+02, .962691D+01,
     +  .723629D+01, .545886D+01, .413791D+01, .315043D+01,
     +  .241038D+01, .185286D+01, .143115D+01, .110987D+01,
     +  .864876D+00, .674729D+00, .528545D+00, .413873D+00,
     +  .324573D+00, .254412D+00, .199211D+00, .155664D+00,
     +  .121311D+00, .941899D-01, .728211D-01, .560171D-01,
     +  .428573D-01, .325808D-01, .246035D-01, .184407D-01,
     +  .137080D-01, .101151D-01, .737917D-02, .532655D-02,
     +  .380271D-02, .268209D-02, .186793D-02, .128276D-02,
     +  .868266D-03, .578351D-03, .379025D-03, .243798D-03,
     +  .154704D-03, .961804D-04, .589273D-04, .356064D-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .213660D-04, .127783D-04, .770648D-05, .469201D-05,
     +  .289665D-05, .178576D-05, .108175D-05, .618755D-06,
     +  .319556D-06, .136203D-06, .384894D-07, .302756D-08,
     +  .000000D+00, .556292D+06, .425757D+06, .320901D+06,
     +  .241724D+06, .181993D+06, .136931D+06, .102971D+06,
     +  .773787D+05, .581138D+05, .436127D+05, .327098D+05,
     +  .245131D+05, .183582D+05, .137371D+05, .102719D+05,
     +  .767393D+04, .572871D+04, .427248D+04, .318388D+04,
     +  .237027D+04, .176312D+04, .131014D+04, .972701D+03,
     +  .721414D+03, .534580D+03, .395724D+03, .292778D+03,
     +  .215473D+03, .159174D+03, .117502D+03, .867150D+02,
     +  .639757D+02, .472044D+02, .348731D+02, .257699D+02,
     +  .190690D+02, .141411D+02, .105126D+02, .784135D+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .586948D+01, .441436D+01, .333450D+01, .253104D+01,
     +  .193025D+01, .147914D+01, .113804D+01, .879883D+00,
     +  .681064D+00, .529373D+00, .411319D+00, .320100D+00,
     +  .249004D+00, .193508D+00, .150080D+00, .116092D+00,
     +  .894748D-01, .686707D-01, .524428D-01, .398345D-01,
     +  .300676D-01, .225455D-01, .167806D-01, .123876D-01,
     +  .907857D-02, .657827D-02, .471712D-02, .334606D-02,
     +  .234557D-02, .162419D-02, .110961D-02, .747792D-03,
     +  .496537D-03, .324941D-03, .209271D-03, .133458D-03,
     +  .838479D-04, .522986D-04, .324931D-04, .202794D-04,
     +  .127688D-04, .817744D-05, .530410D-05, .346447D-05,
     +  .223446D-05, .139243D-05, .807412D-06, .416106D-06,
     +  .174346D-06, .478381D-07, .382113D-08, .000000D+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .736658D+06, .561642D+06, .421429D+06, .316020D+06,
     +  .236847D+06, .177383D+06, .132770D+06, .993033D+05,
     +  .742254D+05, .554366D+05, .413757D+05, .308551D+05,
     +  .229929D+05, .171187D+05, .127354D+05, .946534D+04,
     +  .702914D+04, .521468D+04, .386520D+04, .286190D+04,
     +  .211710D+04, .156440D+04, .115490D+04, .851628D+03,
     +  .627389D+03, .461667D+03, .339507D+03, .248312D+03,
     +  .182289D+03, .133714D+03, .980414D+02, .718574D+02,
     +  .526650D+02, .386434D+02, .283580D+02, .208367D+02,
     +  .153416D+02, .113225D+02, .838358D+01, .622897D+01,
     +  .464975D+01, .348594D+01, .262600D+01, .198752D+01,
     +  .151147D+01, .115409D+01, .885554D+00, .680264D+00,
     +  .524775D+00, .404684D+00, .312588D+00, .241364D+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .186191D+00, .143353D+00, .110085D+00, .842365D-01,
     +  .641903D-01, .486762D-01, .367150D-01, .275218D-01,
     +  .204956D-01, .151523D-01, .111109D-01, .808960D-02,
     +  .582381D-02, .414992D-02, .292593D-02, .203934D-02,
     +  .140468D-02, .955201D-03, .641320D-03, .424806D-03,
     +  .277839D-03, .179326D-03, .115033D-03, .730705D-04,
     +  .463694D-04, .295296D-04, .190211D-04, .124259D-04,
     +  .825978D-05, .554004D-05, .370763D-05, .242688D-05,
     +  .151837D-05, .876320D-06, .445409D-06, .182254D-06,
     +  .485000D-07, .392659D-08, .000000D+00, .959983D+06,
     +  .729144D+06, .544694D+06, .406632D+06, .303383D+06,
     +  .226181D+06, .168516D+06, .125453D+06, .933307D+05,
     +  .693748D+05, .515300D+05, .382410D+05, .283569D+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .210075D+05, .155498D+05, .114984D+05, .849499D+04,
     +  .626933D+04, .462241D+04, .340428D+04, .250470D+04,
     +  .184066D+04, .135129D+04, .990820D+03, .725752D+03,
     +  .530938D+03, .388143D+03, .282160D+03, .205876D+03,
     +  .150083D+03, .109352D+03, .796363D+02, .579873D+02,
     +  .422692D+02, .308111D+02, .224856D+02, .164416D+02,
     +  .120499D+02, .885930D+01, .653566D+01, .484369D+01,
     +  .360513D+01, .269605D+01, .202567D+01, .152920D+01,
     +  .115906D+01, .882853D+00, .673202D+00, .515529D+00,
     +  .394645D+00, .302617D+00, .231979D+00, .177667D+00,
     +  .135816D+00, .103559D+00, .786880D-01, .595459D-01,
     +  .448446D-01, .335950D-01, .250142D-01, .185048D-01,
     +  .135913D-01, .990213D-02, .716406D-02, .512559D-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .363057D-02, .254515D-02, .176448D-02, .120946D-02,
     +  .819064D-03, .548189D-03, .362493D-03, .237145D-03,
     +  .153528D-03, .991373D-04, .636885D-04, .410853D-04,
     +  .267389D-04, .176656D-04, .118519D-04, .806718D-05,
     +  .551083D-05, .372559D-05, .244540D-05, .152255D-05,
     +  .869108D-06, .433925D-06, .173015D-06, .446390D-07,
     +  .366183D-08, .000000D+00, .123258D+07, .932723D+06,
     +  .693738D+06, .515625D+06, .382995D+06, .284254D+06,
     +  .210825D+06, .156233D+06, .115691D+06, .855943D+05,
     +  .632769D+05, .467344D+05, .344875D+05, .254245D+05,
     +  .187263D+05, .137781D+05, .101277D+05, .743601D+04,
     +  .545419D+04, .399579D+04, .292427D+04, .213743D+04,
     +  .156059D+04, .113796D+04, .828851D+03, .602903D+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .438206D+03, .316661D+03, .229677D+03, .166425D+03,
     +  .120516D+03, .872221D+02, .631101D+02, .457101D+02,
     +  .331029D+02, .239995D+02, .174316D+02, .126896D+02,
     +  .926611D+01, .678887D+01, .499650D+01, .369293D+01,
     +  .274231D+01, .204589D+01, .153350D+01, .115404D+01,
     +  .872776D+00, .660755D+00, .502391D+00, .381842D+00,
     +  .290721D+00, .221289D+00, .168291D+00, .127754D+00,
     +  .967383D-01, .730026D-01, .548695D-01, .410464D-01,
     +  .305460D-01, .225957D-01, .166081D-01, .121213D-01,
     +  .877612D-02, .631085D-02, .448835D-02, .316112D-02,
     +  .220410D-02, .152044D-02, .103758D-02, .700119D-03,
     +  .467386D-03, .308745D-03, .202194D-03, .131404D-03,
     +  .854671D-04, .555339D-04, .363809D-04, .241279D-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .162656D-04, .111241D-04, .768572D-05, .530016D-05,
     +  .359235D-05, .235036D-05, .145018D-05, .816329D-06,
     +  .399630D-06, .155148D-06, .388305D-07, .322692D-08,
     +  .000000D+00, .156096D+07, .117694D+07, .871634D+06,
     +  .645057D+06, .477047D+06, .352502D+06, .260280D+06,
     +  .192016D+06, .141544D+06, .104241D+06, .767046D+05,
     +  .563862D+05, .414127D+05, .303835D+05, .222703D+05,
     +  .163053D+05, .119258D+05, .871227D+04, .635781D+04,
     +  .463383D+04, .337353D+04, .245279D+04, .178126D+04,
     +  .129183D+04, .935756D+03, .676863D+03, .489181D+03,
     +  .351445D+03, .253426D+03, .182554D+03, .131406D+03,
     +  .945288D+02, .679768D+02, .489299D+02, .352111D+02,
     +  .253652D+02, .183045D+02, .132381D+02, .960294D+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .698888D+01, .510919D+01, .375069D+01, .276622D+01,
     +  .204959D+01, .152568D+01, .114019D+01, .856327D+00,
     +  .643777D+00, .486077D+00, .366867D+00, .277383D+00,
     +  .209682D+00, .158371D+00, .119405D+00, .898060D-01,
     +  .673184D-01, .502628D-01, .373550D-01, .276196D-01,
     +  .203013D-01, .148284D-01, .107561D-01, .774077D-02,
     +  .553374D-02, .391326D-02, .274114D-02, .190155D-02,
     +  .130568D-02, .887456D-03, .596944D-03, .397724D-03,
     +  .262634D-03, .172304D-03, .112487D-03, .737269D-04,
     +  .484455D-04, .321909D-04, .216961D-04, .148598D-04,
     +  .103014D-04, .718104D-05, .497114D-05, .336277D-05,
     +  .218553D-05, .133320D-05, .738883D-06, .354323D-06,
     +  .133910D-06, .325398D-07, .273901D-08, .000000D+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .195170D+07, .146633D+07, .108141D+07, .796925D+06,
     +  .586844D+06, .431766D+06, .317418D+06, .233138D+06,
     +  .171092D+06, .125436D+06, .918809D+05, .672323D+05,
     +  .491490D+05, .358901D+05, .261814D+05, .190766D+05,
     +  .138849D+05, .100936D+05, .732910D+04, .531481D+04,
     +  .384954D+04, .278440D+04, .201149D+04, .145106D+04,
     +  .104545D+04, .752072D+03, .540531D+03, .386132D+03,
     +  .276860D+03, .198289D+03, .141902D+03, .101477D+03,
     +  .725368D+02, .518970D+02, .371171D+02, .265724D+02,
     +  .190553D+02, .136939D+02, .986992D+01, .713681D+01,
     +  .518331D+01, .378010D+01, .276943D+01, .203829D+01,
     +  .150707D+01, .111868D+01, .834490D+00, .623084D+00,
     +  .467256D+00, .350259D+00, .263031D+00, .197494D+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .148165D+00, .110968D+00, .829091D-01, .617428D-01,
     +  .458022D-01, .338231D-01, .248509D-01, .181533D-01,
     +  .131789D-01, .950272D-02, .679883D-02, .483291D-02,
     +  .339898D-02, .236861D-02, .163525D-02, .111803D-02,
     +  .757181D-03, .507967D-03, .337966D-03, .223237D-03,
     +  .146817D-03, .963385D-04, .636460D-04, .422768D-04,
     +  .284547D-04, .194393D-04, .134770D-04, .942899D-05,
     +  .660328D-05, .457130D-05, .307725D-05, .198237D-05,
     +  .119383D-05, .650778D-06, .305526D-06, .112413D-06,
     +  .265472D-07, .226307D-08, .000000D+00, .241127D+07,
     +  .180536D+07, .132597D+07, .973111D+06, .713588D+06,
     +  .522802D+06, .382704D+06, .279879D+06, .204498D+06,
     +  .149268D+06, .108851D+06, .792912D+05, .577006D+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .419408D+05, .304528D+05, .220845D+05, .159975D+05,
     +  .115733D+05, .836252D+04, .603427D+04, .434878D+04,
     +  .312959D+04, .224926D+04, .161416D+04, .115683D+04,
     +  .827753D+03, .591709D+03, .420347D+03, .299722D+03,
     +  .213461D+03, .151890D+03, .107996D+03, .767462D+02,
     +  .545856D+02, .388067D+02, .276144D+02, .196815D+02,
     +  .140567D+02, .100683D+02, .723454D+01, .522096D+01,
     +  .378320D+01, .275381D+01, .201362D+01, .147907D+01,
     +  .109065D+01, .808212D+00, .599443D+00, .446541D+00,
     +  .332501D+00, .248040D+00, .185011D+00, .137890D+00,
     +  .102600D+00, .761622D-01, .563563D-01, .415427D-01,
     +  .304868D-01, .222621D-01, .161642D-01, .116653D-01,
     +  .836276D-02, .594938D-02, .420602D-02, .294258D-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .204048D-02, .140238D-02, .955041D-03, .644733D-03,
     +  .431590D-03, .286904D-03, .189679D-03, .125127D-03,
     +  .825618D-04, .549831D-04, .368987D-04, .251189D-04,
     +  .173520D-04, .121389D-04, .854179D-05, .599045D-05,
     +  .413598D-05, .276513D-05, .176306D-05, .104721D-05,
     +  .561113D-06, .257821D-06, .923702D-07, .212218D-07,
     +  .183189D-08, .000000D+00, .733714D+05, .105255D+06,
     +  .804893D+05, .615512D+05, .470695D+05, .359956D+05,
     +  .275275D+05, .210520D+05, .161002D+05, .123135D+05,
     +  .941781D+04, .720341D+04, .550999D+04, .421497D+04,
     +  .322459D+04, .246717D+04, .188790D+04, .144487D+04,
     +  .110600D+04, .846812D+03, .648543D+03, .496867D+03,
     +  .380824D+03, .292031D+03, .224080D+03, .172070D+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .132252D+03, .101384D+03, .781233D+02, .602956D+02,
     +  .466250D+02, .361355D+02, .280808D+02, .219060D+02,
     +  .171412D+02, .134702D+02, .106364D+02, .844336D+01,
     +  .674092D+01, .541371D+01, .437576D+01, .355826D+01,
     +  .291067D+01, .239411D+01, .197898D+01, .164281D+01,
     +  .136939D+01, .114313D+01, .956896D+00, .800749D+00,
     +  .670456D+00, .560839D+00, .468337D+00, .390122D+00,
     +  .323930D+00, .267925D+00, .220600D+00, .180699D+00,
     +  .147163D+00, .119090D+00, .957006D-01, .763203D-01,
     +  .603613D-01, .473645D-01, .367503D-01, .282134D-01,
     +  .214106D-01, .160449D-01, .118598D-01, .863534D-02,
     +  .618449D-02, .434923D-02, .299670D-02, .201739D-02,
     +  .132869D-02, .848235D-03, .524366D-03, .312387D-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .178285D-03, .967508D-04, .494479D-04, .235342D-04,
     +  .101999D-04, .395847D-05, .132364D-05, .361202D-06,
     +  .734415D-07, .938010D-08, .512944D-09, .352406D-11,
     +  .000000D+00, .156462D+06, .121401D+06, .929849D+05,
     +  .712139D+05, .545397D+05, .417658D+05, .319831D+05,
     +  .244894D+05, .187511D+05, .143559D+05, .109906D+05,
     +  .841335D+04, .644030D+04, .492946D+04, .377300D+04,
     +  .288759D+04, .220998D+04, .169128D+04, .129438D+04,
     +  .990607D+03, .758215D+03, .580384D+03, .444358D+03,
     +  .340282D+03, .260681D+03, .199782D+03, .153215D+03,
     +  .117146D+03, .900057D+02, .692334D+02, .533382D+02,
     +  .411661D+02, .318438D+02, .247160D+02, .192343D+02,
     +  .150250D+02, .117891D+02, .929485D+01, .736823D+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .587356D+01, .471151D+01, .380154D+01, .308543D+01,
     +  .251794D+01, .206527D+01, .170127D+01, .140753D+01,
     +  .116621D+01, .969215D+00, .805264D+00, .669540D+00,
     +  .556209D+00, .461319D+00, .381687D+00, .314814D+00,
     +  .258653D+00, .211551D+00, .172134D+00, .139258D+00,
     +  .111942D+00, .893574D-01, .707875D-01, .556088D-01,
     +  .433433D-01, .334017D-01, .254663D-01, .191916D-01,
     +  .142806D-01, .104801D-01, .757481D-02, .538394D-02,
     +  .375614D-02, .256658D-02, .171190D-02, .111596D-02,
     +  .703778D-03, .428508D-03, .250151D-03, .138626D-03,
     +  .718391D-04, .338538D-04, .137278D-04, .396784D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .186149D+06, .144467D+06, .110673D+06, .847683D+05,
     +  .649221D+05, .497121D+05, .380621D+05, .291359D+05,
     +  .223007D+05, .170651D+05, .130571D+05, .998803D+04,
     +  .763940D+04, .584157D+04, .446628D+04, .341392D+04,
     +  .260922D+04, .199372D+04, .152327D+04, .116359D+04,
     +  .888804D+03, .678817D+03, .518464D+03, .395977D+03,
     +  .302482D+03, .231094D+03, .176645D+03, .134567D+03,
     +  .102992D+03, .788916D+02, .605086D+02, .464766D+02,
     +  .357685D+02, .276114D+02, .213641D+02, .165869D+02,
     +  .129317D+02, .101275D+02, .797292D+01, .631022D+01,
     +  .502513D+01, .402471D+01, .324242D+01, .262647D+01,
     +  .213852D+01, .174879D+01, .143656D+01, .118182D+01,
     +  .975423D+00, .804865D+00, .664712D+00, .548522D+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .451956D+00, .371504D+00, .304437D+00, .248516D+00,
     +  .201956D+00, .163273D+00, .131247D+00, .104829D+00,
     +  .831462D-01, .654494D-01, .510877D-01, .395680D-01,
     +  .302985D-01, .229535D-01, .171885D-01, .127097D-01,
     +  .926960D-02, .665915D-02, .470534D-02, .326442D-02,
     +  .221941D-02, .147390D-02, .957843D-03, .603329D-03,
     +  .368112D-03, .216480D-03, .122030D-03, .654403D-04,
     +  .330844D-04, .155829D-04, .669792D-05, .256838D-05,
     +  .839233D-06, .210293D-06, .282463D-07, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .226383D+06,
     +  .175537D+06, .134333D+06, .102771D+06, .786135D+05,
     +  .601160D+05, .459631D+05, .351308D+05, .268464D+05,
     +  .205085D+05, .156637D+05, .119591D+05, .912868D+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .696555D+04, .531380D+04, .405219D+04, .308942D+04,
     +  .235450D+04, .179402D+04, .136648D+04, .104065D+04,
     +  .792279D+03, .603125D+03, .459033D+03, .349371D+03,
     +  .265891D+03, .202433D+03, .153552D+03, .117003D+03,
     +  .892057D+02, .680859D+02, .520286D+02, .398263D+02,
     +  .305712D+02, .235157D+02, .181459D+02, .140577D+02,
     +  .109373D+02, .855265D+01, .672254D+01, .531628D+01,
     +  .422796D+01, .338216D+01, .272036D+01, .219949D+01,
     +  .178616D+01, .145726D+01, .119069D+01, .976230D+00,
     +  .800205D+00, .656569D+00, .538315D+00, .440723D+00,
     +  .359983D+00, .293149D+00, .237811D+00, .192057D+00,
     +  .154311D+00, .123279D+00, .978601D-01, .771445D-01,
     +  .603559D-01, .468247D-01, .360471D-01, .274349D-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .206582D-01, .153765D-01, .113019D-01, .819429D-02,
     +  .585265D-02, .411235D-02, .283787D-02, .192015D-02,
     +  .126982D-02, .822698D-03, .517502D-03, .316226D-03,
     +  .187093D-03, .106930D-03, .588834D-04, .312695D-04,
     +  .160666D-04, .805429D-05, .401122D-05, .201852D-05,
     +  .101972D-05, .498064D-06, .214074D-06, .640655D-07,
     +  .491438D-08, .000000D+00, .163673D+06, .215907D+06,
     +  .164891D+06, .125884D+06, .960835D+05, .733093D+05,
     +  .559198D+05, .426378D+05, .325021D+05, .247651D+05,
     +  .188646D+05, .143634D+05, .109330D+05, .831795D+04,
     +  .632644D+04, .480941D+04, .365501D+04, .277633D+04,
     +  .210824D+04, .160016D+04, .121420D+04, .920935D+03,
     +  .698352D+03, .529378D+03, .401243D+03, .304057D+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .230468D+03, .174004D+03, .131956D+03, .100110D+03,
     +  .760181D+02, .577821D+02, .439875D+02, .335739D+02,
     +  .256739D+02, .196912D+02, .151600D+02, .117196D+02,
     +  .910468D+01, .710901D+01, .558431D+01, .441119D+01,
     +  .350489D+01, .280005D+01, .224876D+01, .181400D+01,
     +  .147026D+01, .119344D+01, .972201D+00, .791803D+00,
     +  .645578D+00, .525996D+00, .427974D+00, .347425D+00,
     +  .281201D+00, .226737D+00, .182012D+00, .145364D+00,
     +  .115440D+00, .910936D-01, .713868D-01, .555238D-01,
     +  .428231D-01, .327749D-01, .247989D-01, .185648D-01,
     +  .137386D-01, .100403D-01, .723851D-02, .514144D-02,
     +  .359331D-02, .246711D-02, .166162D-02, .109446D-02,
     +  .706994D-03, .444116D-03, .271711D-03, .161592D-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .934305D-04, .525589D-04, .289417D-04, .157335D-04,
     +  .854815D-05, .469937D-05, .261334D-05, .142802D-05,
     +  .728128D-06, .315107D-06, .922501D-07, .718013D-08,
     +  .000000D+00, .363428D+06, .280492D+06, .213492D+06,
     +  .162428D+06, .123540D+06, .939201D+05, .713782D+05,
     +  .542209D+05, .411731D+05, .312495D+05, .237088D+05,
     +  .179783D+05, .136274D+05, .103238D+05, .781786D+04,
     +  .591684D+04, .447617D+04, .338433D+04, .255772D+04,
     +  .193190D+04, .145864D+04, .110071D+04, .830327D+03,
     +  .626064D+03, .471924D+03, .355608D+03, .267992D+03,
     +  .201121D+03, .151592D+03, .114288D+03, .862258D+02,
     +  .651083D+02, .492273D+02, .373119D+02, .283279D+02,
     +  .215677D+02, .164802D+02, .126430D+02, .974582D+01 /
        DATA (UPDI(I),I=4317,4368) /
     +  .754991D+01, .588371D+01, .461076D+01, .363425D+01,
     +  .288034D+01, .229494D+01, .183670D+01, .147709D+01,
     +  .118969D+01, .961765D+00, .777358D+00, .629050D+00,
     +  .508728D+00, .410881D+00, .331121D+00, .266068D+00,
     +  .212998D+00, .169764D+00, .134623D+00, .106158D+00,
     +  .831828D-01, .647333D-01, .500001D-01, .382948D-01,
     +  .291063D-01, .218690D-01, .162562D-01, .119445D-01,
     +  .866609D-02, .620161D-02, .437132D-02, .303066D-02,
     +  .206311D-02, .137670D-02, .897349D-03, .572708D-03,
     +  .354498D-03, .212836D-03, .123429D-03, .688813D-04,
     +  .368067D-04, .187664D-04, .910518D-05, .420244D-05,
     +  .186268D-05, .810041D-06, .351254D-06, .153067D-06,
     +  .623428D-07, .186825D-07, .139614D-08, .000000D+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .474344D+06, .364833D+06, .276574D+06, .209568D+06,
     +  .158737D+06, .120174D+06, .909428D+05, .687850D+05,
     +  .520037D+05, .392944D+05, .296777D+05, .224014D+05,
     +  .169010D+05, .127433D+05, .960370D+04, .723297D+04,
     +  .544468D+04, .409584D+04, .307957D+04, .231393D+04,
     +  .173780D+04, .130429D+04, .978469D+03, .733622D+03,
     +  .549832D+03, .411892D+03, .308560D+03, .230139D+03,
     +  .172385D+03, .129140D+03, .967982D+02, .726071D+02,
     +  .545245D+02, .410419D+02, .309396D+02, .233869D+02,
     +  .177395D+02, .135081D+02, .103344D+02, .794520D+01,
     +  .614448D+01, .477823D+01, .373732D+01, .293933D+01,
     +  .232402D+01, .184581D+01, .147322D+01, .117762D+01,
     +  .944920D+00, .758071D+00, .608933D+00, .488872D+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .391989D+0, .313633D+00, .250220D+00, .198895D+00,
     +  .157410D+00, .123956D+00, .970686D-01, .755370D-01,
     +  .583807D-01, .447869D-01, .340688D-01, .257197D-01,
     +  .191938D-01, .141715D-01, .103429D-01, .745414D-02,
     +  .529916D-02, .371098D-02, .255656D-02, .172982D-02,
     +  .114779D-02, .744410D-03, .473253D-03, .292304D-03,
     +  .175609D-03, .102381D-03, .578735D-04, .317147D-04,
     +  .169175D-04, .885419D-05, .459932D-05, .240730D-05,
     +  .127584D-05, .668057D-06, .328821D-06, .137303D-06,
     +  .385474D-07, .302806D-08, .000000D+00, .616640D+06,
     +  .472513D+06, .356656D+06, .269068D+06, .202903D+06,
     +  .152922D+06, .115200D+06, .867323D+05, .652674D+05,
     +  .490843D+05, .368949D+05, .277145D+05, .208072D+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .156108D+05, .117055D+05, .877105D+04, .656838D+04,
     +  .491528D+04, .367605D+04, .274723D+04, .205192D+04,
     +  .153149D+04, .114243D+04, .851645D+03, .634566D+03,
     +  .472545D+03, .351865D+03, .260806D+03, .194135D+03,
     +  .144510D+03, .107617D+03, .801911D+02, .598154D+02,
     +  .447183D+02, .334771D+02, .251269D+02, .189233D+02,
     +  .143056D+02, .108647D+02, .829150D+01, .636492D+01,
     +  .491297D+01, .381413D+01, .297747D+01, .233672D+01,
     +  .184215D+01, .145950D+01, .115807D+01, .922472D+00,
     +  .734682D+00, .585895D+00, .467016D+00, .371806D+00,
     +  .295390D+00, .234018D+00, .184725D+00, .145188D+00,
     +  .113549D+00, .883143D-01, .682607D-01, .524032D-01,
     +  .399337D-01, .301749D-01, .226299D-01, .167763D-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .123052D-01, .892213D-02, .638860D-02, .451264D-02,
     +  .314040D-02, .215033D-02, .144659D-02, .954816D-03,
     +  .616464D-03, .390637D-03, .240958D-03, .145013D-03,
     +  .851023D-04, .487863D-04, .274165D-04, .152306D-04,
     +  .845731D-05, .473946D-05, .269412D-05, .153405D-05,
     +  .842866D-06, .422667D-06, .175114D-06, .478783D-07,
     +  .382149D-08, .000000D+00, .795913D+06, .607551D+06,
     +  .456537D+06, .342869D+06, .257378D+06, .193085D+06,
     +  .144779D+06, .108488D+06, .812496D+05, .608093D+05,
     +  .454851D+05, .339988D+05, .253977D+05, .189586D+05,
     +  .141431D+05, .105427D+05, .785368D+04, .584589D+04,
     +  .434851D+04, .323207D+04, .240071D+04, .178178D+04,
     +  .132159D+04, .979518D+03, .725576D+03, .537103D+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .397526D+03, .292822D+03, .216612D+03, .160224D+03,
     +  .118556D+03, .877672D+02, .650337D+02, .482946D+02,
     +  .359087D+02, .267667D+02, .200178D+02, .150268D+02,
     +  .113316D+02, .858618D+01, .654391D+01, .501482D+01,
     +  .386514D+01, .299554D+01, .233394D+01, .182670D+01,
     +  .143689D+01, .113194D+01, .895235D+00, .707913D+00,
     +  .560561D+00, .443690D+00, .350775D+00, .276755D+00,
     +  .217748D+00, .170711D+00, .133265D+00, .103525D+00,
     +  .799802D-01, .614098D-01, .468338D-01, .354567D-01,
     +  .266174D-01, .198329D-01, .146078D-01, .106458D-01,
     +  .766981D-02, .545731D-02, .383093D-02, .264987D-02,
     +  .180390D-02, .120693D-02, .792756D-03, .509782D-03,
     +  .322189D-03, .198636D-03, .119867D-03, .708808D-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .412278D-04, .237288D-04, .136476D-04, .792303D-05,
     +  .466003D-05, .276599D-05, .162144D-05, .901756D-06,
     +  .450045D-06, .182788D-06, .485278D-07, .392685D-08,
     +  .000000D+00, .101816D+07, .774222D+06, .579165D+06,
     +  .432995D+06, .323543D+06, .241599D+06, .180307D+06,
     +  .134471D+06, .100228D+06, .746504D+05, .555651D+05,
     +  .413278D+05, .307182D+05, .228141D+05, .169322D+05,
     +  .125563D+05, .930466D+04, .688917D+04, .509701D+04,
     +  .376779D+04, .278320D+04, .205412D+04, .151497D+04,
     +  .111641D+04, .822168D+03, .605010D+03, .445110D+03,
     +  .325859D+03, .239569D+03, .176103D+03, .129481D+03,
     +  .952425D+02, .701148D+02, .517270D+02, .382050D+02,
     +  .282872D+02, .210115D+02, .156649D+02, .117314D+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .882759D+01, .668109D+01, .508420D+01, .389116D+01,
     +  .299456D+01, .231679D+01, .180054D+01, .140640D+01,
     +  .110014D+01, .864020D+00, .678463D+00, .533521D+00,
     +  .419383D+00, .329290D+00, .258040D+00, .201653D+00,
     +  .157034D+00, .121773D+00, .939735D-01, .721255D-01,
     +  .550189D-01, .416890D-01, .313595D-01, .233911D-01,
     +  .173186D-01, .126751D-01, .917932D-02, .657214D-02,
     +  .464761D-02, .324292D-02, .223006D-02, .150968D-02,
     +  .100490D-02, .657111D-03, .421082D-03, .265608D-03,
     +  .163804D-03, .992092D-04, .591621D-04, .349220D-04,
     +  .205522D-04, .121725D-04, .730718D-05, .443522D-05,
     +  .269494D-05, .159738D-05, .887312D-06, .437193D-06,
     +  .173387D-06, .446581D-07, .366202D-08, .000000D+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .128971D+07, .976984D+06, .727585D+06, .541510D+06,
     +  .402790D+06, .299393D+06, .222402D+06, .165087D+06,
     +  .122464D+06, .907743D+05, .672391D+05, .497654D+05,
     +  .368062D+05, .271985D+05, .200837D+05, .148169D+05,
     +  .109227D+05, .804467D+04, .592024D+04, .435275D+04,
     +  .319776D+04, .234705D+04, .172132D+04, .126128D+04,
     +  .923523D+03, .675631D+03, .494134D+03, .359558D+03,
     +  .262747D+03, .191958D+03, .140263D+03, .102526D+03,
     +  .749971D+02, .549745D+02, .403399D+02, .296723D+02,
     +  .218946D+02, .162147D+02, .120618D+02, .901511D+01,
     +  .677686D+01, .512206D+01, .389341D+01, .297584D+01,
     +  .228654D+01, .176483D+01, .136909D+01, .106359D+01,
     +  .829611D+00, .646988D+00, .505314D+00, .394529D+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .307694D+00, .239508D+00, .185930D+00, .143837D+00,
     +  .110810D+00, .849594D-01, .647873D-01, .491055D-01,
     +  .369724D-01, .276365D-01, .204847D-01, .150724D-01,
     +  .109626D-01, .789031D-02, .561492D-02, .394696D-02,
     +  .273797D-02, .187225D-02, .126074D-02, .835168D-03,
     +  .543916D-03, .347516D-03, .218922D-03, .135165D-03,
     +  .822345D-04, .494879D-04, .296417D-04, .178041D-04,
     +  .108059D-04, .665079D-05, .411974D-05, .253352D-05,
     +  .150438D-05, .829325D-06, .401929D-06, .155405D-06,
     +  .388437D-07, .322705D-08, .000000D+00, .161705D+07,
     +  .122039D+07, .904867D+06, .670472D+06, .496483D+06,
     +  .367367D+06, .271648D+06, .200711D+06, .148194D+06,
     +  .109327D+06, .805950D+05, .593623D+05, .436894D+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .321254D+05, .236031D+05, .173253D+05, .127065D+05,
     +  .930994D+04, .681544D+04, .498434D+04, .364207D+04,
     +  .265862D+04, .193908D+04, .141291D+04, .102871D+04,
     +  .748264D+03, .544083D+03, .393549D+03, .285878D+03,
     +  .207604D+03, .150774D+03, .109532D+03, .796239D+02,
     +  .580008D+02, .422908D+02, .309086D+02, .226599D+02,
     +  .166728D+02, .123217D+02, .914905D+01, .683227D+01,
     +  .512980D+01, .387341D+01, .294083D+01, .224454D+01,
     +  .172080D+01, .132600D+01, .102318D+01, .792755D+00,
     +  .614097D+00, .476429D+00, .369511D+00, .286281D+00,
     +  .221379D+00, .170736D+00, .131228D+00, .100447D+00,
     +  .765230D-01, .579844D-01, .436732D-01, .326772D-01,
     +  .242747D-01, .178817D-01, .130768D-01, .945319D-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .676287D-02, .478401D-02, .334330D-02, .230610D-02,
     +  .156841D-02, .105083D-02, .693010D-03, .449705D-03,
     +  .286633D-03, .180458D-03, .111629D-03, .682758D-04,
     +  .414823D-04, .252021D-04, .154171D-04, .954638D-05,
     +  .598404D-05, .375371D-05, .231962D-05, .137235D-05,
     +  .748138D-06, .355936D-06, .134089D-06, .325488D-07,
     +  .273911D-08, .000000D+00, .200677D+07, .150900D+07,
     +  .111404D+07, .821878D+06, .605926D+06, .446360D+06,
     +  .328579D+06, .241675D+06, .177621D+06, .130430D+06,
     +  .957007D+05, .701544D+05, .513845D+05, .376004D+05,
     +  .274901D+05, .200782D+05, .146515D+05, .106804D+05,
     +  .777845D+04, .565898D+04, .411322D+04, .298650D+04,
     +  .216645D+04, .156994D+04, .113670D+04, .822162D+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .594419D+03, .427452D+03, .308701D+03, .222860D+03,
     +  .160892D+03, .116181D+03, .839442D+02, .607744D+02,
     +  .440392D+02, .319860D+02, .233026D+02, .170376D+02,
     +  .125114D+02, .923062D+01, .684900D+01, .510923D+01,
     +  .383289D+01, .289116D+01, .219222D+01, .166967D+01,
     +  .127818D+01, .979777D+00, .754146D+00, .580344D+00,
     +  .447296D+00, .344657D+00, .265294D+00, .203828D+00,
     +  .156191D+00, .119285D+00, .907283D-01, .686852D-01,
     +  .517210D-01, .387147D-01, .287893D-01, .212561D-01,
     +  .155630D-01, .113127D-01, .812898D-02, .578114D-02,
     +  .406577D-02, .282524D-02, .193809D-02, .131129D-02,
     +  .874386D-03, .574275D-03, .371478D-03, .236337D-03,
     +  .148801D-03, .922894D-04, .567830D-04, .348387D-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .214537D-04, .133370D-04, .839186D-05, .532897D-05,
     +  .336629D-05, .208028D-05, .122204D-05, .657352D-06,
     +  .306655D-06, .112536D-06, .265534D-07, .226314D-08,
     +  .000000D+00, .246534D+07, .184725D+07, .135801D+07,
     +  .997610D+06, .732324D+06, .537131D+06, .393662D+06,
     +  .288260D+06, .210908D+06, .154171D+06, .112601D+06,
     +  .821602D+05, .598954D+05, .436201D+05, .317377D+05,
     +  .230679D+05, .167502D+05, .121495D+05, .880372D+04,
     +  .637220D+04, .460768D+04, .332801D+04, .240140D+04,
     +  .173087D+04, .124641D+04, .896548D+03, .644594D+03,
     +  .460890D+03, .330956D+03, .237555D+03, .170504D+03,
     +  .122400D+03, .879139D+02, .632692D+02, .455706D+02,
     +  .328975D+02, .238202D+02, .173090D+02, .126321D+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .926180D+01, .682920D+01, .506246D+01, .377381D+01,
     +  .282852D+01, .213104D+01, .161266D+01, .122662D+01,
     +  .934177D+00, .714420D+00, .546221D+00, .418290D+00,
     +  .320243D+00, .244930D+00, .186989D+00, .142384D+00,
     +  .108058D+00, .816778D-01, .614514D-01, .459896D-01,
     +  .342148D-01, .252890D-01, .185596D-01, .135074D-01,
     +  .976035D-02, .697224D-02, .492974D-02, .344730D-02,
     +  .238223D-02, .162554D-02, .109437D-02, .726484D-03,
     +  .475348D-03, .306653D-03, .194845D-03, .122763D-03,
     +  .763917D-04, .473043D-04, .293081D-04, .182761D-04,
     +  .115197D-04, .733953D-05, .470132D-05, .297830D-05,
     +  .183437D-05, .106748D-05, .565772D-06, .258610D-06,
     +  .924549D-07, .212261D-07, .183194D-08, .000000D+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .732910D+05, .105236D+06, .804723D+05, .615360D+05,
     +  .470559D+05, .359835D+05, .275166D+05, .210423D+05,
     +  .160915D+05, .123057D+05, .941084D+04, .719717D+04,
     +  .550441D+04, .420997D+04, .322011D+04, .246316D+04,
     +  .188431D+04, .144165D+04, .110312D+04, .844223D+03,
     +  .646220D+03, .494780D+03, .378947D+03, .290342D+03,
     +  .222558D+03, .170695D+03, .131009D+03, .100257D+03,
     +  .770989D+02, .593608D+02, .457686D+02, .353477D+02,
     +  .273526D+02, .212294D+02, .165092D+02, .128768D+02,
     +  .100763D+02, .791230D+01, .623534D+01, .493097D+01,
     +  .391398D+01, .311631D+01, .248806D+01, .199086D+01,
     +  .159553D+01, .127982D+01, .102755D+01, .823343D+00,
     +  .659655D+00, .526628D+00, .419542D+00, .333016D+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .263194D+00, .206970D+00, .161833D+00, .125735D+00,
     +  .970011D-01, .742544D-01, .563605D-01, .423832D-01,
     +  .315507D-01, .232278D-01, .168938D-01, .121426D-01,
     +  .858277D-02, .596797D-02, .407444D-02, .272480D-02,
     +  .177981D-02, .113135D-02, .696507D-03, .412594D-03,
     +  .232869D-03, .123275D-03, .600395D-04, .251857D-04,
     +  .771451D-05, .692590D-07, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .156439D+06,
     +  .121380D+06, .929663D+05, .711972D+05, .545248D+05,
     +  .417524D+05, .319712D+05, .244787D+05, .187415D+05,
     +  .143473D+05, .109830D+05, .840650D+04, .643417D+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .492398D+04, .376809D+04, .288320D+04, .220605D+04,
     +  .168775D+04, .129122D+04, .987772D+03, .755672D+03,
     +  .578100D+03, .442305D+03, .338434D+03, .259016D+03,
     +  .198279D+03, .151857D+03, .115916D+03, .888879D+02,
     +  .682145D+02, .524061D+02, .403102D+02, .310544D+02,
     +  .239845D+02, .185534D+02, .143882D+02, .111907D+02,
     +  .873040D+01, .683393D+01, .536660D+01, .422978D+01,
     +  .334373D+01, .265082D+01, .210634D+01, .167681D+01,
     +  .133629D+01, .106638D+01, .849429D+00, .676903D+00,
     +  .537623D+00, .426273D+00, .336845D+00, .265122D+00,
     +  .207678D+00, .161805D+00, .125286D+00, .963457D-01,
     +  .735271D-01, .556519D-01, .417369D-01, .309929D-01,
     +  .227647D-01, .165219D-01, .118538D-01, .836557D-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .580864D-02, .396154D-02, .264717D-02, .172865D-02,
     +  .109859D-02, .676399D-03, .400149D-03, .225074D-03,
     +  .117558D-03, .550974D-04, .202014D-04, .244712D-05,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .186123D+06, .144444D+06,
     +  .110653D+06, .847500D+05, .649058D+05, .496976D+05,
     +  .380491D+05, .291243D+05, .222903D+05, .170558D+05,
     +  .130488D+05, .998058D+04, .763273D+04, .583561D+04,
     +  .446094D+04, .340914D+04, .260494D+04, .198988D+04,
     +  .151983D+04, .116051D+04, .886041D+03, .676336D+03,
     +  .516235D+03, .393972D+03, .300676D+03, .229465D+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .175172D+03, .133235D+03, .101783D+03, .777904D+02,
     +  .595027D+02, .455546D+02, .349199D+02, .268272D+02,
     +  .206364D+02, .159088D+02, .122973D+02, .953195D+01,
     +  .741212D+01, .578120D+01, .452552D+01, .355301D+01,
     +  .279763D+01, .220813D+01, .174645D+01, .138301D+01,
     +  .109705D+01, .868749D+00, .688516D+00, .543957D+00,
     +  .429143D+00, .337490D+00, .264423D+00, .206227D+00,
     +  .160008D+00, .123396D+00, .945255D-01, .718669D-01,
     +  .542005D-01, .405068D-01, .299808D-01, .219530D-01,
     +  .158869D-01, .113693D-01, .800660D-02, .555028D-02,
     +  .378254D-02, .252872D-02, .165550D-02, .105790D-02,
     +  .658383D-03, .397066D-03, .231280D-03, .128907D-03,
     +  .688007D-04, .343855D-04, .160407D-04, .676776D-05 /
        DATA (UPDI(I),I=5357,5408) /
     +  .254786D-05, .785684D-06, .202013D-06, .270276D-07,
     +  .130897D-07, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .000000D+00, .000000D+00, .000000D+00,
     +  .000000D+00, .226356D+06, .175512D+06, .134310D+06,
     +  .102751D+06, .785958D+05, .601002D+05, .459490D+05,
     +  .351182D+05, .268351D+05, .204984D+05, .156547D+05,
     +  .119510D+05, .912147D+04, .695910D+04, .530803D+04,
     +  .404702D+04, .308479D+04, .235035D+04, .179031D+04,
     +  .136315D+04, .103767D+04, .789602D+03, .600720D+03,
     +  .456870D+03, .347424D+03, .264135D+03, .200847D+03,
     +  .152119D+03, .115702D+03, .880234D+02, .670074D+02,
     +  .510418D+02, .389201D+02, .297360D+02, .227430D+02,
     +  .174284D+02, .133892D+02, .103125D+02, .796729D+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .617334D+01, .480061D+01, .374408D+01, .292877D+01,
     +  .229671D+01, .180507D+01, .142064D+01, .112024D+01,
     +  .881985D+00, .695168D+00, .546273D+00, .428761D+00,
     +  .335516D+00, .261621D+00, .203097D+00, .156873D+00,
     +  .120450D+00, .918749D-01, .695607D-01, .522495D-01,
     +  .388948D-01, .286787D-01, .209232D-01, .150894D-01,
     +  .107641D-01, .755859D-02, .522685D-02, .355590D-02,
     +  .237534D-02, .155634D-02, .997595D-03, .625128D-03,
     +  .381868D-03, .227558D-03, .131968D-03, .754080D-04,
     +  .424649D-04, .243148D-04, .144721D-04, .933241D-05,
     +  .649179D-05, .485425D-05, .368261D-05, .278555D-05,
     +  .200792D-05, .136500D-05, .846036D-06, .463825D-06,
     +  .209820D-06, .638352D-07, .491260D-08, .000000D+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .163573D+06, .215880D+06, .164867D+06, .125862D+06,
     +  .960644D+05, .732923D+05, .559046D+05, .426242D+05,
     +  .324899D+05, .247542D+05, .188548D+05, .143547D+05,
     +  .109252D+05, .831100D+04, .632022D+04, .480385D+04,
     +  .365003D+04, .277187D+04, .210425D+04, .159658D+04,
     +  .121099D+04, .918059D+03, .695769D+03, .527057D+03,
     +  .399154D+03, .302175D+03, .228769D+03, .172470D+03,
     +  .130566D+03, .988472D+02, .748682D+02, .567318D+02,
     +  .430251D+02, .326890D+02, .248576D+02, .189359D+02,
     +  .144589D+02, .110672D+02, .849646D+01, .654133D+01,
     +  .505424D+01, .391667D+01, .304434D+01, .237238D+01,
     +  .185312D+01, .144968D+01, .113648D+01, .889655D+00,
     +  .697362D+00, .545049D+00, .425574D+00, .331334D+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .257087D+00, .198618D+00, .152694D+00, .116701D+00,
     +  .886144D-01, .667956D-01, .499559D-01, .370302D-01,
     +  .271920D-01, .197601D-01, .141963D-01, .100907D-01,
     +  .706234D-02, .486939D-02, .330502D-02, .220449D-02,
     +  .144415D-02, .927287D-03, .583835D-03, .359985D-03,
     +  .218091D-03, .130018D-03, .775780D-04, .466266D-04,
     +  .291203D-04, .191539D-04, .134990D-04, .998611D-05,
     +  .765807D-05, .584338D-05, .438121D-05, .313126D-05,
     +  .210759D-05, .129521D-05, .702286D-06, .311935D-06,
     +  .920794D-07, .717876D-08, .000000D+00, .363395D+06,
     +  .280462D+06, .213466D+06, .162405D+06, .123519D+06,
     +  .939015D+05, .713616D+05, .542060D+05, .411598D+05,
     +  .312377D+05, .236982D+05, .179688D+05, .136189D+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .103163D+05, .781109D+04, .591078D+04, .447076D+04,
     +  .337948D+04, .255338D+04, .192801D+04, .145515D+04,
     +  .109759D+04, .827523D+03, .623545D+03, .469659D+03,
     +  .353569D+03, .266153D+03, .199463D+03, .150091D+03,
     +  .112927D+03, .849889D+02, .639813D+02, .481974D+02,
     +  .363679D+02, .274603D+02, .207681D+02, .157415D+02,
     +  .119591D+02, .911181D+01, .696176D+01, .533809D+01,
     +  .410522D+01, .316678D+01, .244942D+01, .189924D+01,
     +  .147507D+01, .114826D+01, .892668D+00, .695038D+00,
     +  .539661D+00, .418667D+00, .323919D+00, .249794D+00,
     +  .191828D+00, .146607D+00, .111402D+00, .841093D-01,
     +  .630459D-01, .468918D-01, .345711D-01, .252508D-01,
     +  .182537D-01, .130458D-01, .922561D-02, .642360D-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .440610D-02, .297469D-02, .197309D-02, .128455D-02,
     +  .818785D-03, .510659D-03, .310690D-03, .184439D-03,
     +  .106457D-03, .602989D-04, .333336D-04, .183537D-04,
     +  .101599D-04, .585526D-05, .353393D-05, .228857D-05,
     +  .152331D-05, .104194D-05, .686607D-06, .435317D-06,
     +  .254090D-06, .134414D-06, .600815D-07, .185616D-07,
     +  .139513D-08, .000000D+00, .474309D+06, .364801D+06,
     +  .276545D+06, .209543D+06, .158715D+06, .120154D+06,
     +  .909247D+05, .687688D+05, .519892D+05, .392815D+05,
     +  .296662D+05, .223911D+05, .168918D+05, .127351D+05,
     +  .959635D+04, .722640D+04, .543881D+04, .409058D+04,
     +  .307486D+04, .230972D+04, .173402D+04, .130090D+04,
     +  .975437D+03, .730900D+03, .547387D+03, .409692D+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .306579D+03, .228355D+03, .170772D+03, .127680D+03,
     +  .954742D+02, .714036D+02, .534276D+02, .400397D+02,
     +  .300218D+02, .225445D+02, .169648D+02, .127946D+02,
     +  .967656D+01, .733854D+01, .558526D+01, .426353D+01,
     +  .326466D+01, .250672D+01, .192966D+01, .148804D+01,
     +  .115028D+01, .888072D+00, .686803D+00, .529722D+00,
     +  .408276D+00, .313858D+00, .240510D+00, .183555D+00,
     +  .139426D+00, .105308D+00, .790348D-01, .588957D-01,
     +  .435520D-01, .319268D-01, .231897D-01, .166730D-01,
     +  .118530D-01, .833947D-02, .577830D-02, .394563D-02,
     +  .265317D-02, .175414D-02, .113956D-02, .726067D-03,
     +  .453812D-03, .277843D-03, .167003D-03, .986224D-04,
     +  .580272D-04, .341069D-04, .205407D-04, .128401D-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .849907D-05, .589549D-05, .426066D-05, .309264D-05,
     +  .222557D-05, .153494D-05, .100165D-05, .597979D-06,
     +  .315573D-06, .135721D-06, .384634D-07, .302733D-08,
     +  .000000D+00, .616602D+06, .472478D+06, .356625D+06,
     +  .269040D+06, .202879D+06, .152900D+06, .115181D+06,
     +  .867147D+05, .652518D+05, .490704D+05, .368824D+05,
     +  .277034D+05, .207972D+05, .156019D+05, .116976D+05,
     +  .876394D+04, .656202D+04, .490960D+04, .367096D+04,
     +  .274268D+04, .204785D+04, .152785D+04, .113917D+04,
     +  .848715D+03, .631936D+03, .470181D+03, .349738D+03,
     +  .258893D+03, .192409D+03, .142950D+03, .106206D+03,
     +  .789111D+02, .586522D+02, .436589D+02, .325105D+02,
     +  .242434D+02, .181143D+02, .135642D+02, .101849D+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .766829D+01, .579400D+01, .439093D+01, .333799D+01,
     +  .254471D+01, .194502D+01, .148935D+01, .114335D+01,
     +  .876658D+00, .673412D+00, .515927D+00, .395033D+00,
     +  .301714D+00, .229727D+00, .174222D+00, .131512D+00,
     +  .987202D-01, .736411D-01, .545484D-01, .400992D-01,
     +  .292255D-01, .211069D-01, .150916D-01, .106707D-01,
     +  .746871D-02, .514928D-02, .350006D-02, .234406D-02,
     +  .154477D-02, .100144D-02, .637847D-03, .399570D-03,
     +  .246170D-03, .149761D-03, .903263D-04, .549139D-04,
     +  .338511D-04, .216532D-04, .144835D-04, .101972D-04,
     +  .742905D-05, .553226D-05, .408993D-05, .296110D-05,
     +  .204871D-05, .133394D-05, .792460D-06, .413284D-06,
     +  .174009D-06, .478201D-07, .382096D-08, .000000D+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .795871D+06, .607514D+06, .456503D+06, .342839D+06,
     +  .257352D+06, .193061D+06, .144757D+06, .108469D+06,
     +  .812327D+05, .607941D+05, .454716D+05, .339867D+05,
     +  .253870D+05, .189490D+05, .141345D+05, .105350D+05,
     +  .784682D+04, .583977D+04, .434303D+04, .322717D+04,
     +  .239633D+04, .177786D+04, .131808D+04, .976373D+03,
     +  .722755D+03, .534571D+03, .395251D+03, .290779D+03,
     +  .214772D+03, .158565D+03, .117057D+03, .864113D+02,
     +  .638050D+02, .471792D+02, .348946D+02, .258436D+02,
     +  .191765D+02, .142596D+02, .106318D+02, .794839D+01,
     +  .596321D+01, .448723D+01, .338714D+01, .256407D+01,
     +  .194615D+01, .147989D+01, .112831D+01, .859235D+00,
     +  .655599D+00, .498930D+00, .379504D+00, .287971D+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .217853D+00, .164168D+00, .123144D+00, .918652D-01,
     +  .681073D-01, .501448D-01, .366423D-01, .265499D-01,
     +  .190647D-01, .135554D-01, .953244D-02, .663725D-02,
     +  .455339D-02, .308103D-02, .205529D-02, .135029D-02,
     +  .873712D-03, .556470D-03, .349502D-03, .216741D-03,
     +  .133461D-03, .821138D-04, .513772D-04, .328995D-04,
     +  .219640D-04, .153178D-04, .111404D-04, .829349D-05,
     +  .623424D-05, .462059D-05, .333100D-05, .228967D-05,
     +  .147575D-05, .865586D-06, .443414D-06, .182019D-06,
     +  .484876D-07, .392647D-08, .000000D+00, .101812D+07,
     +  .774181D+06, .579129D+06, .432962D+06, .323515D+06,
     +  .241573D+06, .180284D+06, .134451D+06, .100210D+06,
     +  .746340D+05, .555506D+05, .413148D+05, .307066D+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .228038D+05, .169229D+05, .125480D+05, .929728D+04,
     +  .688258D+04, .509113D+04, .376253D+04, .277850D+04,
     +  .204992D+04, .151121D+04, .111304D+04, .819153D+03,
     +  .602306D+03, .442683D+03, .323683D+03, .237614D+03,
     +  .174342D+03, .127895D+03, .938113D+02, .688216D+02,
     +  .505568D+02, .371451D+02, .273264D+02, .201397D+02,
     +  .148738D+02, .110138D+02, .817721D+01, .609250D+01,
     +  .455284D+01, .341291D+01, .256578D+01, .193407D+01,
     +  .146066D+01, .110611D+01, .836636D+00, .634095D+00,
     +  .479358D+00, .362222D+00, .273072D+00, .205253D+00,
     +  .153688D+00, .114557D+00, .849268D-01, .625762D-01,
     +  .457935D-01, .332628D-01, .239602D-01, .171065D-01,
     +  .120954D-01, .845975D-02, .585995D-02, .400055D-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .269503D-02, .179102D-02, .117331D-02, .758019D-03,
     +  .482971D-03, .304283D-03, .190030D-03, .118456D-03,
     +  .742785D-04, .476786D-04, .314937D-04, .216983D-04,
     +  .155524D-04, .115214D-04, .866213D-05, .652011D-05,
     +  .481636D-05, .344450D-05, .234430D-05, .149158D-05,
     +  .861420D-06, .432518D-06, .172852D-06, .446304D-07,
     +  .366175D-08, .000000D+00, .128966D+07, .976940D+06,
     +  .727546D+06, .541475D+06, .402758D+06, .299365D+06,
     +  .222377D+06, .165065D+06, .122444D+06, .907567D+05,
     +  .672234D+05, .497514D+05, .367937D+05, .271874D+05,
     +  .200737D+05, .148080D+05, .109148D+05, .803761D+04,
     +  .591393D+04, .434712D+04, .319273D+04, .234255D+04,
     +  .171730D+04, .125768D+04, .920307D+03, .672751D+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .491554D+03, .357249D+03, .260674D+03, .190097D+03,
     +  .138590D+03, .101020D+03, .736406D+02, .537512D+02,
     +  .392360D+02, .286756D+02, .209944D+02, .154019D+02,
     +  .113283D+02, .835413D+01, .618227D+01, .458864D+01,
     +  .341643D+01, .255105D+01, .190997D+01, .143273D+01,
     +  .107770D+01, .809692D+00, .609610D+00, .457804D+00,
     +  .343674D+00, .257412D+00, .192241D+00, .143031D+00,
     +  .105942D+00, .780524D-01, .571583D-01, .415760D-01,
     +  .300197D-01, .214982D-01, .152614D-01, .107313D-01,
     +  .746556D-02, .514505D-02, .349582D-02, .234505D-02,
     +  .155291D-02, .101474D-02, .654819D-03, .417590D-03,
     +  .264063D-03, .166162D-03, .104874D-03, .669635D-04,
     +  .439740D-04, .297973D-04, .210198D-04, .153454D-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .114876D-04, .866828D-05, .650716D-05, .477698D-05,
     +  .338313D-05, .227606D-05, .142773D-05, .810838D-06,
     +  .398640D-06, .155035D-06, .388246D-07, .322686D-08,
     +  .000000D+00, .161700D+07, .122035D+07, .904825D+06,
     +  .670435D+06, .496449D+06, .367337D+06, .271621D+06,
     +  .200687D+06, .148172D+06, .109309D+06, .805781D+05,
     +  .593473D+05, .436760D+05, .321135D+05, .235925D+05,
     +  .173158D+05, .126980D+05, .930238D+04, .680869D+04,
     +  .497832D+04, .363670D+04, .265382D+04, .193480D+04,
     +  .140909D+04, .102529D+04, .745205D+03, .541347D+03,
     +  .391105D+03, .283689D+03, .205642D+03, .149014D+03,
     +  .107953D+03, .782055D+02, .567259D+02, .411447D+02,
     +  .298781D+02, .217334D+02, .158403D+02, .115745D+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .847949D+01, .623354D+01, .459600D+01, .339916D+01,
     +  .252127D+01, .187512D+01, .139723D+01, .104406D+01,
     +  .779219D+00, .582818D+00, .434815D+00, .324298D+00,
     +  .241338D+00, .179086D+00, .132403D+00, .974560D-01,
     +  .713566D-01, .519364D-01, .375512D-01, .269536D-01,
     +  .191911D-01, .135469D-01, .947394D-02, .655625D-02,
     +  .449601D-02, .304082D-02, .203162D-02, .134096D-02,
     +  .874326D-03, .563821D-03, .360080D-03, .228676D-03,
     +  .145061D-03, .927106D-04, .602219D-04, .403549D-04,
     +  .279241D-04, .200507D-04, .148186D-04, .111537D-04,
     +  .841550D-05, .628556D-05, .457805D-05, .320744D-05,
     +  .213108D-05, .131697D-05, .734970D-06, .353628D-06,
     +  .133832D-06, .325357D-07, .273896D-08, .000000D+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .200671D+07, .150895D+07, .111399D+07, .821838D+06,
     +  .605890D+06, .446328D+06, .328550D+06, .241649D+06,
     +  .177598D+06, .130410D+06, .956826D+05, .701383D+05,
     +  .513701D+05, .375876D+05, .274786D+05, .200680D+05,
     +  .146424D+05, .106723D+05, .777124D+04, .565256D+04,
     +  .410749D+04, .298139D+04, .216189D+04, .156588D+04,
     +  .113307D+04, .818921D+03, .591525D+03, .424871D+03,
     +  .306393D+03, .220797D+03, .159046D+03, .114529D+03,
     +  .824655D+02, .594499D+02, .428530D+02, .309240D+02,
     +  .223521D+02, .161877D+02, .117525D+02, .855447D+01,
     +  .624794D+01, .457666D+01, .336277D+01, .247798D+01,
     +  .183086D+01, .135531D+01, .100613D+01, .745993D+00,
     +  .554344D+00, .410889D+00, .304482D+00, .225147D+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .166014D+00, .121969D+00, .892191D-01, .649254D-01,
     +  .469701D-01, .337587D-01, .240900D-01, .170545D-01,
     +  .119719D-01, .832776D-02, .573350D-02, .391292D-02,
     +  .263482D-02, .175370D-02, .115410D-02, .751142D-03,
     +  .484288D-03, .309915D-03, .197783D-03, .126536D-03,
     +  .818881D-04, .540560D-04, .368735D-04, .259552D-04,
     +  .188845D-04, .140673D-04, .106097D-04, .798454D-05,
     +  .592464D-05, .427670D-05, .296223D-05, .194256D-05,
     +  .118213D-05, .647996D-06, .305039D-06, .112359D-06,
     +  .265444D-07, .226304D-08, .000000D+00, .246528D+07,
     +  .184720D+07, .135796D+07, .997566D+06, .732285D+06,
     +  .537096D+06, .393631D+06, .288233D+06, .210884D+06,
     +  .154149D+06, .112582D+06, .821429D+05, .598801D+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .436064D+05, .317255D+05, .230570D+05, .167405D+05,
     +  .121409D+05, .879604D+04, .636536D+04, .460158D+04,
     +  .332259D+04, .239656D+04, .172656D+04, .124257D+04,
     +  .893123D+03, .641540D+03, .458171D+03, .328532D+03,
     +  .235392D+03, .168574D+03, .120678D+03, .863768D+02,
     +  .618972D+02, .443466D+02, .318062D+02, .228479D+02,
     +  .164439D+02, .118638D+02, .858104D+01, .622761D+01,
     +  .453269D+01, .330913D+01, .242279D+01, .177855D+01,
     +  .130808D+01, .964820D+00, .710740D+00, .524759D+00,
     +  .386463D+00, .284560D+00, .209087D+00, .153206D+00,
     +  .111861D+00, .813223D-01, .588200D-01, .422990D-01,
     +  .302230D-01, .214427D-01, .150951D-01, .105388D-01,
     +  .729252D-02, .499567D-02, .339357D-02, .227553D-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .150923D-02, .990612D-03, .643853D-03, .415246D-03,
     +  .266425D-03, .170956D-03, .110345D-03, .722935D-04,
     +  .484409D-04, .335587D-04, .239499D-04, .175935D-04,
     +  .131665D-04, .992629D-05, .743825D-05, .547744D-05,
     +  .391577D-05, .268018D-05, .173402D-05, .103878D-05,
     +  .559141D-06, .257481D-06, .923330D-07, .212199D-07,
     +  .183187D-08, .000000D+00, .522637D+06, .418377D+06,
     +  .331966D+06, .263402D+06, .209000D+06, .165834D+06,
     +  .131584D+06, .104408D+06, .828447D+05, .657354D+05,
     +  .521598D+05, .413882D+05, .328413D+05, .260597D+05,
     +  .206787D+05, .164090D+05, .130212D+05, .103330D+05,
     +  .820003D+04, .650751D+04, .516451D+04, .409884D+04,
     +  .325321D+04, .258218D+04, .204969D+04, .162712D+04 /
        DATA (UPDI(I),I=6397,6448) /
     +  .129178D+04, .102230D+04, .811859D+03, .644822D+03,
     +  .512231D+03, .406980D+03, .323432D+03, .257291D+03,
     +  .204651D+03, .162892D+03, .129770D+03, .103503D+03,
     +  .826771D+02, .661634D+02, .530915D+02, .427291D+02,
     +  .345187D+02, .280115D+02, .228500D+02, .187500D+02,
     +  .154958D+02, .128776D+02, .107854D+02, .908125D+01,
     +  .769509D+01, .655165D+01, .559816D+01, .479410D+01,
     +  .410875D+01, .351898D+01, .300752D+01, .256149D+01,
     +  .217127D+01, .182960D+01, .153086D+01, .127055D+01,
     +  .104492D+01, .851532D+00, .685424D+00, .545067D+00,
     +  .427768D+00, .330929D+00, .252051D+00, .188741D+00,
     +  .138737D+00, .999302D-01, .703702D-01, .483091D-01,
     +  .323649D-01, .209675D-01, .131187D-01, .788755D-02 /
        DATA (UPDI(I),I=6449,6500) /
     +  .452906D-02, .246437D-02, .125799D-02, .595368D-03,
     +  .255233D-03, .973567D-04, .317391D-04, .835419D-05,
     +  .161376D-05, .191264D-06, .930341D-08, .513152D-10,
     +  .000000D+00, .118714D+07, .936845D+06, .731450D+06,
     +  .570958D+06, .445727D+06, .347880D+06, .271540D+06,
     +  .211897D+06, .165369D+06, .129023D+06, .100673D+06,
     +  .785305D+05, .612619D+05, .477766D+05, .372619D+05,
     +  .290525D+05, .226529D+05, .176576D+05, .137646D+05,
     +  .107265D+05, .835955D+04, .651286D+04, .507454D+04,
     +  .395276D+04, .307929D+04, .239823D+04, .186808D+04,
     +  .144983D+04, .112956D+04, .879979D+03, .685795D+03,
     +  .534511D+03, .416832D+03, .325411D+03, .254118D+03,
     +  .198623D+03, .155482D+03, .121901D+03, .957898D+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .754496D+02, .596389D+02, .473086D+02, .376976D+02,
     +  .301887D+02, .243156D+02, .197051D+02, .160877D+02,
     +  .132050D+02, .109232D+02, .908019D+01, .759416D+01,
     +  .637908D+01, .537586D+01, .453904D+01, .383464D+01,
     +  .323686D+01, .272634D+01, .228842D+01, .191187D+01,
     +  .158807D+01, .131004D+01, .107227D+01, .869784D+00,
     +  .699351D+00, .555489D+00, .436046D+00, .337871D+00,
     +  .258166D+00, .194263D+00, .143778D+00, .104492D+00,
     +  .744577D-01, .519082D-01, .353057D-01, .234584D-01,
     +  .150958D-01, .939865D-02, .564005D-02, .324435D-02,
     +  .177946D-02, .923065D-03, .450029D-03, .202827D-03,
     +  .840697D-04, .313762D-04, .103197D-04, .286411D-05,
     +  .609146D-06, .780581D-07, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .213151D+07, .166829D+07, .129030D+07, .997552D+06,
     +  .771216D+06, .595981D+06, .460551D+06, .355737D+06,
     +  .274765D+06, .212123D+06, .163753D+06, .126350D+06,
     +  .974822D+05, .751711D+05, .579609D+05, .446668D+05,
     +  .344182D+05, .265063D+05, .204109D+05, .157082D+05,
     +  .120876D+05, .929619D+04, .714875D+04, .549436D+04,
     +  .422256D+04, .324339D+04, .249131D+04, .190586D+04,
     +  .146370D+04, .112383D+04, .863119D+03, .662873D+03,
     +  .509369D+03, .391835D+03, .301540D+03, .232286D+03,
     +  .179255D+03, .138580D+03, .107420D+03, .834929D+02,
     +  .651565D+02, .510478D+02, .401933D+02, .318150D+02,
     +  .253370D+02, .203040D+02, .163939D+02, .133054D+02,
     +  .108816D+02, .894005D+01, .738761D+01, .612931D+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .510026D+01, .425090D+01, .354422D+01, .295217D+01,
     +  .245350D+01, .203205D+01, .167520D+01, .137323D+01,
     +  .111811D+01, .903511D+00, .723643D+00, .574682D+00,
     +  .450910D+00, .349753D+00, .267861D+00, .202369D+00,
     +  .150615D+00, .110307D+00, .793635D-01, .560228D-01,
     +  .387231D-01, .261369D-01, .172552D-01, .110516D-01,
     +  .686261D-02, .411980D-02, .237984D-02, .131803D-02,
     +  .695147D-03, .347965D-03, .163018D-03, .712933D-04,
     +  .285173D-04, .101820D-04, .307164D-05, .699376D-06,
     +  .929885D-07, .000000D+00, .000000D+00, .341006D+07,
     +  .265225D+07, .203655D+07, .156294D+07, .119931D+07,
     +  .919769D+06, .705271D+06, .540478D+06, .414113D+06,
     +  .317096D+06, .242757D+06, .185724D+06, .142057D+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .108582D+06, .829734D+05, .633590D+05, .483675D+05,
     +  .368956D+05, .281362D+05, .214399D+05, .163322D+05,
     +  .124315D+05, .945972D+04, .719283D+04, .546767D+04,
     +  .415303D+04, .315396D+04, .238466D+04, .181000D+04,
     +  .137323D+04, .104199D+04, .790531D+03, .600024D+03,
     +  .455909D+03, .346530D+03, .263669D+03, .200997D+03,
     +  .153522D+03, .117598D+03, .903473D+02, .697111D+02,
     +  .540161D+02, .420746D+02, .329548D+02, .259737D+02,
     +  .206004D+02, .164628D+02, .132217D+02, .106988D+02,
     +  .869393D+01, .710396D+01, .582639D+01, .479123D+01,
     +  .394549D+01, .324956D+01, .267350D+01, .219448D+01,
     +  .179511D+01, .146170D+01, .118364D+01, .952157D+00,
     +  .760325D+00, .601862D+00, .472541D+00, .366624D+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .281286D+00, .213153D+00, .159401D+00, .117479D+00,
     +  .852451D-01, .608005D-01, .425802D-01, .292267D-01,
     +  .196103D-01, .128879D-01, .823171D-02, .510875D-02,
     +  .307404D-02, .178616D-02, .999463D-03, .535345D-03,
     +  .273801D-03, .131893D-03, .596149D-04, .247079D-04,
     +  .911899D-05, .281810D-05, .648497D-06, .857337D-07,
     +  .000000D+00, .000000D+00, .508177D+07, .393137D+07,
     +  .300012D+07, .228802D+07, .174450D+07, .132921D+07,
     +  .101250D+07, .770718D+06, .586486D+06, .445965D+06,
     +  .338994D+06, .257482D+06, .195494D+06, .148308D+06,
     +  .112464D+06, .852104D+05, .645317D+05, .488276D+05,
     +  .369275D+05, .279017D+05, .210714D+05, .158981D+05,
     +  .119890D+05, .903259D+04, .680196D+04, .511712D+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .384833D+04, .288042D+04, .216422D+04, .162513D+04,
     +  .122027D+04, .916019D+03, .687838D+03, .517024D+03,
     +  .388729D+03, .292580D+03, .220629D+03, .166715D+03,
     +  .126353D+03, .960631D+02, .733634D+02, .562761D+02,
     +  .434026D+02, .336648D+02, .262776D+02, .206408D+02,
     +  .163358D+02, .129902D+02, .104063D+02, .836902D+01,
     +  .676628D+01, .548942D+01, .446417D+01, .363477D+01,
     +  .295945D+01, .240681D+01, .195275D+01, .157896D+01,
     +  .127095D+01, .101750D+01, .809358D+00, .639200D+00,
     +  .500517D+00, .388850D+00, .298595D+00, .226817D+00,
     +  .170233D+00, .126143D+00, .921651D-01, .663382D-01,
     +  .469662D-01, .326769D-01, .223057D-01, .149013D-01,
     +  .976488D-02, .623003D-02, .387044D-02, .233726D-02 /
        DATA (UPDI(I),I=6813,6864) /
     +  .136696D-02, .772438D-03, .419256D-03, .217975D-03,
     +  .107003D-03, .493092D-04, .207954D-04, .776824D-05,
     +  .240966D-05, .551532D-06, .718140D-07, .000000D+00,
     +  .000000D+00, .760683D+07, .585142D+07, .443599D+07,
     +  .336055D+07, .254484D+07, .192570D+07, .145656D+07,
     +  .110085D+07, .831617D+06, .627707D+06, .473553D+06,
     +  .356941D+06, .268896D+06, .202379D+06, .152225D+06,
     +  .114387D+06, .858996D+05, .644400D+05, .483086D+05,
     +  .361762D+05, .270716D+05, .202358D+05, .151154D+05,
     +  .112780D+05, .840881D+04, .626202D+04, .466085D+04,
     +  .345147D+04, .256550D+04, .190550D+04, .141492D+04,
     +  .105022D+04, .779608D+03, .579285D+03, .430481D+03,
     +  .320236D+03, .238668D+03, .178255D+03, .133541D+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .100371D+03, .757890D+02, .574906D+02, .438509D+02,
     +  .336416D+02, .259735D+02, .201788D+02, .157942D+02,
     +  .124178D+02, .983372D+01, .781522D+01, .624224D+01,
     +  .500175D+01, .401628D+01, .322823D+01, .259439D+01,
     +  .208244D+01, .166752D+01, .133081D+01, .105741D+01,
     +  .835787D+00, .656512D+00, .512159D+00, .396252D+00,
     +  .304300D+00, .231058D+00, .173637D+00, .128996D+00,
     +  .946740D-01, .685614D-01, .489535D-01, .344140D-01,
     +  .238024D-01, .161740D-01, .107720D-01, .705005D-02,
     +  .450160D-02, .280553D-02, .170387D-02, .100493D-02,
     +  .574086D-03, .315713D-03, .166511D-03, .829300D-04,
     +  .386887D-04, .164521D-04, .615698D-05, .189865D-05,
     +  .428917D-06, .548714D-07, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .109294D+08, .836256D+07, .630047D+07, .474312D+07,
     +  .356891D+07, .268318D+07, .201616D+07, .151364D+07,
     +  .113569D+07, .851324D+06, .637749D+06, .477286D+06,
     +  .356946D+06, .266671D+06, .199077D+06, .148452D+06,
     +  .110612D+06, .823218D+05, .612146D+05, .454639D+05,
     +  .337357D+05, .250014D+05, .185116D+05, .136889D+05,
     +  .101134D+05, .746127D+04, .550080D+04, .403357D+04,
     +  .296860D+04, .218281D+04, .160427D+04, .117844D+04,
     +  .865574D+03, .636344D+03, .467798D+03, .344240D+03,
     +  .253775D+03, .187488D+03, .138941D+03, .103310D+03,
     +  .771777D+02, .579262D+02, .437188D+02, .331894D+02,
     +  .253555D+02, .194904D+02, .150926D+02, .117364D+02,
     +  .919090D+01, .722094D+01, .570038D+01, .451330D+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .358023D+01, .284251D+01, .225618D+01, .178853D+01,
     +  .141445D+01, .111497D+01, .875145D+00, .683465D+00,
     +  .530587D+00, .409212D+00, .313101D+00, .237896D+00,
     +  .178795D+00, .133065D+00, .979608D-01, .712965D-01,
     +  .512422D-01, .363444D-01, .254072D-01, .174957D-01,
     +  .118526D-01, .788165D-02, .515897D-02, .330040D-02,
     +  .206475D-02, .126101D-02, .749167D-03, .431601D-03,
     +  .239513D-03, .127408D-03, .639061D-04, .299326D-04,
     +  .127261D-04, .473544D-05, .144353D-05, .320787D-06,
     +  .402101D-07, .000000D+00, .000000D+00, .151792D+08,
     +  .115562D+08, .865574D+07, .647768D+07, .484474D+07,
     +  .362021D+07, .270340D+07, .201686D+07, .150360D+07,
     +  .111982D+07, .833362D+06, .619516D+06, .460162D+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .341408D+06, .253075D+06, .187370D+06, .138591D+06,
     +  .102380D+06, .755541D+05, .556820D+05, .409931D+05,
     +  .301369D+05, .221317D+05, .162297D+05, .118884D+05,
     +  .869462D+04, .635335D+04, .461611D+04, .336607D+04,
     +  .245192D+04, .178485D+04, .129840D+04, .944289D+03,
     +  .687321D+03, .500178D+03, .364336D+03, .265847D+03,
     +  .194401D+03, .142592D+03, .104945D+03, .776033D+02,
     +  .576572D+02, .430761D+02, .323714D+02, .244793D+02,
     +  .186239D+02, .142721D+02, .109804D+02, .850626D+01,
     +  .660917D+01, .515879D+01, .403783D+01, .316594D+01,
     +  .248421D+01, .194863D+01, .152661D+01, .119322D+01,
     +  .929741D+00, .721478D+00, .557205D+00, .427901D+00,
     +  .326575D+00, .247363D+00, .186157D+00, .138644D+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .102313D+00, .747382D-01, .540152D-01, .385846D-01,
     +  .272257D-01, .189551D-01, .130147D-01, .880261D-02,
     +  .585165D-02, .383429D-02, .245887D-02, .154396D-02,
     +  .947358D-03, .565841D-03, .327747D-03, .182768D-03,
     +  .975554D-04, .489919D-04, .229011D-04, .968034D-05,
     +  .356513D-05, .107090D-05, .233706D-06, .286719D-07,
     +  .000000D+00, .000000D+00, .204883D+08, .155244D+08,
     +  .115633D+08, .860491D+07, .639894D+07, .475392D+07,
     +  .352913D+07, .261722D+07, .193936D+07, .143550D+07,
     +  .106162D+07, .784207D+06, .578736D+06, .426576D+06,
     +  .314101D+06, .230980D+06, .169670D+06, .124461D+06,
     +  .911925D+05, .667190D+05, .487542D+05, .355722D+05,
     +  .259219D+05, .188599D+05, .137042D+05, .994047D+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .720314D+04, .518842D+04, .375057D+04, .270790D+04,
     +  .195345D+04, .140808D+04, .101453D+04, .731519D+03,
     +  .527265D+03, .380378D+03, .274864D+03, .199043D+03,
     +  .144574D+03, .105368D+03, .771580D+02, .567691D+02,
     +  .419992D+02, .312536D+02, .234012D+02, .176262D+02,
     +  .133715D+02, .101814D+02, .780499D+01, .599953D+01,
     +  .463224D+01, .358596D+01, .278051D+01, .215753D+01,
     +  .167355D+01, .129662D+01, .100237D+01, .772632D+00,
     +  .593257D+00, .453500D+00, .344829D+00, .260688D+00,
     +  .195682D+00, .146022D+00, .107897D+00, .790479D-01,
     +  .573699D-01, .412276D-01, .293092D-01, .206015D-01,
     +  .143030D-01, .980329D-02, .662612D-02, .440647D-02,
     +  .289130D-02, .185826D-02, .117019D-02, .720280D-03 /
        DATA (UPDI(I),I=7177,7228) /
     +  .431533D-03, .250553D-03, .139898D-03, .746307D-04,
     +  .373704D-04, .173670D-04, .727470D-05, .264528D-05,
     +  .781897D-06, .167496D-06, .201159D-07, .000000D+00,
     +  .000000D+00, .269839D+08, .203541D+08, .150800D+08,
     +  .111615D+08, .825478D+07, .609878D+07, .450207D+07,
     +  .331978D+07, .244573D+07, .179973D+07, .132305D+07,
     +  .971428D+06, .712499D+06, .521900D+06, .381852D+06,
     +  .278994D+06, .203595D+06, .148351D+06, .107958D+06,
     +  .784395D+05, .569147D+05, .412285D+05, .298237D+05,
     +  .215369D+05, .155302D+05, .111773D+05, .803522D+04,
     +  .574039D+04, .411540D+04, .294642D+04, .210735D+04,
     +  .150584D+04, .107537D+04, .768470D+03, .548870D+03,
     +  .392339D+03, .280887D+03, .201517D+03, .145005D+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .104694D+03, .759464D+02, .553534D+02, .405657D+02,
     +  .299009D+02, .221743D+02, .165404D+02, .124251D+02,
     +  .936627D+01, .710767D+01, .540727D+01, .413157D+01,
     +  .316486D+01, .242815D+01, .186428D+01, .143094D+01,
     +  .109717D+01, .839544D+00, .640687D+00, .487193D+00,
     +  .368956D+00, .278047D+00, .208429D+00, .155212D+00,
     +  .114975D+00, .843834D-01, .614481D-01, .443610D-01,
     +  .317359D-01, .224793D-01, .157570D-01, .109192D-01,
     +  .747648D-02, .505252D-02, .336180D-02, .220833D-02,
     +  .142143D-02, .896564D-03, .552613D-03, .331345D-03,
     +  .192333D-03, .107214D-03, .569934D-04, .283754D-04,
     +  .130780D-04, .541820D-05, .194286D-05, .564806D-06,
     +  .118777D-06, .139737D-07, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .347836D+08, .261243D+08, .192561D+08, .141788D+08,
     +  .104313D+08, .766591D+07, .562840D+07, .412769D+07,
     +  .302408D+07, .221282D+07, .161745D+07, .118072D+07,
     +  .860909D+06, .626847D+06, .455852D+06, .331009D+06,
     +  .240035D+06, .173789D+06, .125648D+06, .906892D+05,
     +  .653595D+05, .470213D+05, .337761D+05, .242173D+05,
     +  .173360D+05, .123842D+05, .883554D+04, .626281D+04,
     +  .445464D+04, .316379D+04, .224436D+04, .159045D+04,
     +  .112621D+04, .797931D+03, .564964D+03, .400303D+03,
     +  .284049D+03, .201970D+03, .144027D+03, .103053D+03,
     +  .740798D+02, .535032D+02, .388518D+02, .283746D+02,
     +  .208472D+02, .154045D+02, .114623D+02, .855697D+01,
     +  .643040D+01, .484367D+01, .366417D+01, .277884D+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .211073D+01, .160451D+01, .121948D+01, .926023D+00,
     +  .701918D+00, .530772D+00, .400067D+00, .300434D+00,
     +  .224612D+00, .167121D+00, .123593D+00, .909784D-01,
     +  .663943D-01, .481079D-01, .345831D-01, .246540D-01,
     +  .174151D-01, .121826D-01, .843130D-02, .576908D-02,
     +  .389816D-02, .259435D-02, .170500D-02, .109793D-02,
     +  .692643D-03, .426747D-03, .255555D-03, .147974D-03,
     +  .821646D-04, .434313D-04, .214584D-04, .979337D-05,
     +  .400855D-05, .141658D-05, .404986D-06, .836350D-07,
     +  .964722D-08, .000000D+00, .000000D+00, .439908D+08,
     +  .329027D+08, .241328D+08, .176812D+08, .129422D+08,
     +  .946254D+07, .691143D+07, .504201D+07, .367422D+07,
     +  .267403D+07, .194383D+07, .141108D+07, .102305D+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .740637D+06, .535457D+06, .386510D+06, .278592D+06,
     +  .200469D+06, .144032D+06, .103300D+06, .739662D+05,
     +  .528631D+05, .377175D+05, .268585D+05, .190925D+05,
     +  .135417D+05, .959137D+04, .674761D+04, .476330D+04,
     +  .335707D+04, .236284D+04, .166111D+04, .116672D+04,
     +  .819867D+03, .575658D+03, .404446D+03, .284545D+03,
     +  .200587D+03, .141805D+03, .100581D+03, .716719D+02,
     +  .513099D+02, .369297D+02, .267308D+02, .194631D+02,
     +  .142511D+02, .105070D+02, .777083D+01, .578513D+01,
     +  .431644D+01, .323447D+01, .242981D+01, .182830D+01,
     +  .137693D+01, .103698D+01, .780437D+00, .586468D+00,
     +  .439797D+00, .328875D+00, .245127D+00, .181981D+00,
     +  .134525D+00, .988988D-01, .724145D-01, .525982D-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .379568D-01, .271929D-01, .193319D-01, .136264D-01,
     +  .951711D-02, .657941D-02, .449871D-02, .303840D-02,
     +  .202141D-02, .132788D-02, .854434D-03, .538350D-03,
     +  .331010D-03, .197629D-03, .113952D-03, .629209D-04,
     +  .330221D-04, .161705D-04, .730096D-05, .295061D-05,
     +  .102737D-05, .288874D-06, .586065D-07, .663441D-08,
     +  .000000D+00, .000000D+00, .546911D+08, .407429D+08,
     +  .297410D+08, .216852D+08, .157953D+08, .114916D+08,
     +  .835134D+07, .606154D+07, .439442D+07, .318150D+07,
     +  .230047D+07, .166101D+07, .119768D+07, .862261D+06,
     +  .619878D+06, .444893D+06, .318809D+06, .228055D+06,
     +  .162867D+06, .116094D+06, .826096D+05, .586665D+05,
     +  .415878D+05, .294197D+05, .207726D+05, .146323D+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .102916D+05, .718804D+04, .503744D+04, .352410D+04,
     +  .246175D+04, .171743D+04, .119687D+04, .834435D+03,
     +  .581189D+03, .405021D+03, .282612D+03, .197577D+03,
     +  .138513D+03, .974217D+02, .688346D+02, .488602D+02,
     +  .348658D+02, .250196D+02, .180589D+02, .131070D+02,
     +  .957844D+01, .702076D+01, .518012D+01, .383027D+01,
     +  .284450D+01, .211788D+01, .157960D+01, .117938D+01,
     +  .880739D+00, .657456D+00, .490188D+00, .364855D+00,
     +  .270912D+00, .200592D+00, .148010D+00, .108802D+00,
     +  .795846D-01, .580123D-01, .419724D-01, .301872D-01,
     +  .215661D-01, .152965D-01, .107621D-01, .750558D-02,
     +  .518266D-02, .353998D-02, .238844D-02, .158715D-02,
     +  .104111D-02, .668605D-03, .420178D-03, .257466D-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .153045D-03, .877560D-04, .481277D-04, .250522D-04,
     +  .121487D-04, .542322D-05, .216333D-05, .742120D-06,
     +  .205270D-06, .409284D-07, .455127D-08, .000000D+00,
     +  .000000D+00, .669481D+08, .496822D+08, .360989D+08,
     +  .261982D+08, .189923D+08, .137513D+08, .994506D+07,
     +  .718284D+07, .518135D+07, .373230D+07, .268490D+07,
     +  .192852D+07, .138323D+07, .990516D+06, .708205D+06,
     +  .505480D+06, .360191D+06, .256188D+06, .181895D+06,
     +  .128892D+06, .911654D+05, .643466D+05, .453298D+05,
     +  .318633D+05, .223522D+05, .156408D+05, .109269D+05,
     +  .757876D+04, .527416D+04, .366348D+04, .254057D+04,
     +  .175936D+04, .121689D+04, .841953D+03, .581892D+03,
     +  .402341D+03, .278521D+03, .193163D+03, .134328D+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .937124D+02, .656737D+02, .462341D+02, .327192D+02,
     +  .232839D+02, .166654D+02, .119935D+02, .869077D+01,
     +  .631574D+01, .462041D+01, .338734D+01, .249439D+01,
     +  .184178D+01, .136248D+01, .100919D+01, .747842D+00,
     +  .554122D+00, .410233D+00, .303309D+00, .223809D+00,
     +  .164757D+00, .120925D+00, .884644D-01, .644301D-01,
     +  .467877D-01, .337391D-01, .241962D-01, .172440D-01,
     +  .122054D-01, .857195D-02, .596854D-02, .411509D-02,
     +  .280640D-02, .189024D-02, .125354D-02, .820281D-03,
     +  .525195D-03, .328827D-03, .200573D-03, .118574D-03,
     +  .675463D-04, .367610D-04, .189659D-04, .910314D-05,
     +  .401646D-05, .158117D-05, .534422D-06, .145444D-06,
     +  .285118D-07, .311734D-08, .000000D+00, .000000D+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .732910D+05, .105777D+06, .809557D+05, .619684D+05,
     +  .474428D+05, .363295D+05, .278262D+05, .213192D+05,
     +  .163392D+05, .125273D+05, .960909D+04, .737452D+04,
     +  .566307D+04, .435191D+04, .334710D+04, .257677D+04,
     +  .198596D+04, .153259D+04, .118449D+04, .917037D+03,
     +  .711381D+03, .553099D+03, .431148D+03, .337074D+03,
     +  .264402D+03, .208173D+03, .164585D+03, .130304D+03,
     +  .104043D+03, .835379D+02, .674786D+02, .548601D+02,
     +  .449094D+02, .370528D+02, .307899D+02, .257904D+02,
     +  .217803D+02, .185473D+02, .159268D+02, .137897D+02,
     +  .120389D+02, .105930D+02, .939122D+01, .838491D+01,
     +  .753552D+01, .681248D+01, .619351D+01, .565320D+01,
     +  .518260D+01, .476340D+01, .438988D+01, .405245D+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .374475D+01, .346172D+01, .319939D+01, .295463D+01,
     +  .272504D+01, .250877D+01, .230445D+01, .211104D+01,
     +  .192780D+01, .175420D+01, .158987D+01, .143526D+01,
     +  .128859D+01, .115075D+01, .102165D+01, .901247D+00,
     +  .789488D+00, .686304D+00, .591604D+00, .505263D+00,
     +  .427072D+00, .356772D+00, .294716D+00, .239687D+00,
     +  .191803D+00, .150663D+00, .115834D+00, .868428D-01,
     +  .631899D-01, .443766D-01, .297510D-01, .188816D-01,
     +  .111310D-01, .593418D-02, .273533D-02, .100206D-02,
     +  .241459D-03, .208953D-04, .000000D+00, .157088D+06,
     +  .121961D+06, .934859D+05, .716619D+05, .549404D+05,
     +  .421241D+05, .323036D+05, .247760D+05, .190074D+05,
     +  .145851D+05, .111956D+05, .859664D+04, .660420D+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .507602D+04, .390406D+04, .300478D+04, .231477D+04,
     +  .178497D+04, .137815D+04, .106551D+04, .825188D+03,
     +  .640267D+03, .497906D+03, .388166D+03, .303506D+03,
     +  .238088D+03, .187485D+03, .147761D+03, .117412D+03,
     +  .937745D+02, .753265D+02, .608791D+02, .495327D+02,
     +  .406096D+02, .335303D+02, .279042D+02, .234148D+02,
     +  .198123D+02, .169078D+02, .145501D+02, .126285D+02,
     +  .110484D+02, .974109D+01, .865049D+01, .773357D+01,
     +  .695552D+01, .629164D+01, .571374D+01, .521198D+01,
     +  .476627D+01, .437050D+01, .401419D+01, .369062D+01,
     +  .339432D+01, .312107D+01, .286750D+01, .263106D+01,
     +  .240972D+01, .220198D+01, .200667D+01, .182292D+01,
     +  .165009D+01, .148764D+01, .133590D+01, .119298D+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .105963D+01, .935634D+00, .820830D+00, .715030D+00,
     +  .618054D+00, .529686D+00, .449705D+00, .377820D+00,
     +  .313654D+00, .257440D+00, .207974D+00, .165267D+00,
     +  .128881D+00, .983293D-01, .731248D-01, .527453D-01,
     +  .366985D-01, .243526D-01, .152830D-01, .889646D-02,
     +  .467515D-02, .211868D-02, .760409D-03, .179338D-03,
     +  .156633D-04, .000000D+00, .186818D+06, .145066D+06,
     +  .111209D+06, .852474D+05, .653506D+05, .500952D+05,
     +  .384046D+05, .294421D+05, .225745D+05, .173098D+05,
     +  .132759D+05, .101836D+05, .781420D+04, .599780D+04,
     +  .460592D+04, .353871D+04, .272074D+04, .209337D+04,
     +  .161231D+04, .124315D+04, .959893D+03, .742330D+03,
     +  .575211D+03, .446677D+03, .347782D+03, .271575D+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .212821D+03, .166848D+03, .131853D+03, .104702D+03,
     +  .836022D+02, .671492D+02, .542895D+02, .442245D+02,
     +  .362808D+02, .299997D+02, .250148D+02, .210350D+02,
     +  .178436D+02, .152658D+02, .131754D+02, .114642D+02,
     +  .100548D+02, .888343D+01, .790235D+01, .707257D+01,
     +  .636681D+01, .575423D+01, .522401D+01, .475439D+01,
     +  .433878D+01, .396590D+01, .362865D+01, .332114D+01,
     +  .303891D+01, .277834D+01, .253671D+01, .231182D+01,
     +  .210204D+01, .190605D+01, .172285D+01, .155167D+01,
     +  .139182D+01, .124351D+01, .110475D+01, .976157D+00,
     +  .857391D+00, .748173D+00, .648202D+00, .557195D+00,
     +  .474830D+00, .400801D+00, .334743D+00, .276187D+00,
     +  .225261D+00, .180780D+00, .142669D+00, .110452D+00 /
        DATA (UPDI(I),I=7905,7956) /
     +  .836234D-01, .616848D-01, .441045D-01, .303993D-01,
     +  .199638D-01, .123860D-01, .711701D-02, .368463D-02,
     +  .164034D-02, .576080D-03, .132759D-03, .117129D-04,
     +  .000000D+00, .227097D+06, .176176D+06, .134904D+06,
     +  .103282D+06, .790702D+05, .605242D+05, .463280D+05,
     +  .354569D+05, .271378D+05, .207690D+05, .158965D+05,
     +  .121671D+05, .931450D+04, .713155D+04, .546209D+04,
     +  .418464D+04, .320772D+04, .246014D+04, .188837D+04,
     +  .145072D+04, .111587D+04, .859425D+03, .663069D+03,
     +  .512541D+03, .397135D+03, .308533D+03, .240498D+03,
     +  .187480D+03, .147300D+03, .116265D+03, .922636D+02,
     +  .736395D+02, .591580D+02, .478826D+02, .390321D+02,
     +  .320714D+02, .265777D+02, .222151D+02, .187352D+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .159386D+02, .136821D+02, .118431D+02, .103349D+02,
     +  .908632D+01, .804436D+01, .716596D+01, .642119D+01,
     +  .577665D+01, .522044D+01, .472928D+01, .429603D+01,
     +  .390869D+01, .355972D+01, .324284D+01, .295335D+01,
     +  .268738D+01, .244203D+01, .221494D+01, .200431D+01,
     +  .180868D+01, .162694D+01, .145817D+01, .130154D+01,
     +  .115714D+01, .102288D+01, .899255D+00, .785807D+00,
     +  .682153D+00, .587888D+00, .502634D+00, .425979D+00,
     +  .357542D+00, .296894D+00, .243494D+00, .197377D+00,
     +  .157386D+00, .123374D+00, .948421D-01, .712717D-01,
     +  .521594D-01, .369767D-01, .252541D-01, .164180D-01,
     +  .100733D-01, .571556D-02, .291654D-02, .127627D-02,
     +  .439012D-03, .990067D-04, .882004D-05, .000000D+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .163573D+06, .216587D+06, .165499D+06, .126427D+06,
     +  .965691D+05, .737433D+05, .563076D+05, .429843D+05,
     +  .328116D+05, .250416D+05, .191115D+05, .145840D+05,
     +  .111300D+05, .849387D+04, .648351D+04, .494963D+04,
     +  .378018D+04, .288804D+04, .220794D+04, .168912D+04,
     +  .129357D+04, .991735D+03, .761505D+03, .585701D+03,
     +  .451473D+03, .348856D+03, .270417D+03, .209569D+03,
     +  .163677D+03, .128403D+03, .101264D+03, .803148D+02,
     +  .641125D+02, .515657D+02, .417718D+02, .341116D+02,
     +  .280991D+02, .233500D+02, .195820D+02, .165690D+02,
     +  .141494D+02, .121865D+02, .105832D+02, .926099D+01,
     +  .816146D+01, .723752D+01, .645653D+01, .578263D+01,
     +  .520281D+01, .469235D+01, .424354D+01, .384368D+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .348478D+01, .316022D+01, .286502D+01, .259509D+01,
     +  .234732D+01, .211919D+01, .190875D+01, .171440D+01,
     +  .153488D+01, .136916D+01, .121626D+01, .107613D+01,
     +  .946639D+00, .828127D+00, .720039D+00, .621892D+00,
     +  .533190D+00, .453472D+00, .382247D+00, .319068D+00,
     +  .263451D+00, .214800D+00, .173070D+00, .137135D+00,
     +  .106792D+00, .815286D-01, .608204D-01, .441665D-01,
     +  .310494D-01, .210162D-01, .135282D-01, .821006D-02,
     +  .460124D-02, .231495D-02, .996205D-03, .335897D-03,
     +  .742248D-04, .667439D-05, .000000D+00, .364247D+06,
     +  .281224D+06, .214146D+06, .163013D+06, .124062D+06,
     +  .943867D+05, .717950D+05, .545931D+05, .415055D+05,
     +  .315463D+05, .239737D+05, .182148D+05, .138385D+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .105122D+05, .798598D+04, .606681D+04, .460996D+04,
     +  .350364D+04, .266411D+04, .202675D+04, .154318D+04,
     +  .117606D+04, .897462D+03, .685870D+03, .525198D+03,
     +  .403064D+03, .310254D+03, .238692D+03, .185050D+03,
     +  .144084D+03, .112767D+03, .887538D+02, .703054D+02,
     +  .561174D+02, .451172D+02, .365726D+02, .299106D+02,
     +  .246835D+02, .205623D+02, .172871D+02, .146721D+02,
     +  .125620D+02, .108470D+02, .943917D+01, .827334D+01,
     +  .729757D+01, .647580D+01, .576928D+01, .516359D+01,
     +  .463237D+01, .416713D+01, .375440D+01, .338562D+01,
     +  .305379D+01, .275355D+01, .248055D+01, .223143D+01,
     +  .200348D+01, .179455D+01, .160286D+01, .142699D+01,
     +  .126576D+01, .111802D+01, .983571D+00, .860203D+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .748105D+00, .646602D+00, .555104D+00, .473016D+00,
     +  .399786D+00, .334846D+00, .277679D+00, .227747D+00,
     +  .184405D+00, .147526D+00, .116030D+00, .896595D-01,
     +  .678967D-01, .502205D-01, .361409D-01, .251622D-01,
     +  .168557D-01, .107275D-01, .642984D-02, .355371D-02,
     +  .175992D-02, .743609D-03, .245469D-03, .531422D-04,
     +  .482530D-05, .000000D+00, .475225D+06, .365620D+06,
     +  .277277D+06, .210196D+06, .159298D+06, .120675D+06,
     +  .913899D+05, .691841D+05, .523600D+05, .396124D+05,
     +  .299615D+05, .226546D+05, .171269D+05, .129448D+05,
     +  .978331D+04, .739309D+04, .558741D+04, .422302D+04,
     +  .319288D+04, .241486D+04, .182768D+04, .138430D+04,
     +  .104969D+04, .796999D+03, .606220D+03, .462057D+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .353175D+03, .269742D+03, .207599D+03, .160447D+03,
     +  .124637D+03, .973630D+02, .765490D+02, .606509D+02,
     +  .484073D+02, .389613D+02, .316447D+02, .259410D+02,
     +  .214717D+02, .179410D+02, .151374D+02, .128869D+02,
     +  .110664D+02, .957862D+01, .835151D+01, .732838D+01,
     +  .646981D+01, .573430D+01, .510598D+01, .455698D+01,
     +  .407804D+01, .365495D+01, .327861D+01, .294161D+01,
     +  .263825D+01, .236392D+01, .211502D+01, .188862D+01,
     +  .168240D+01, .149440D+01, .132303D+01, .116698D+01,
     +  .102493D+01, .896548D+00, .779553D+00, .673988D+00,
     +  .579073D+00, .494124D+00, .418459D+00, .351450D+00,
     +  .292465D+00, .240933D+00, .196269D+00, .157799D+00,
     +  .125328D+00, .978239D-01, .749929D-01, .563180D-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .412903D-01, .294369D-01, .202887D-01, .134441D-01,
     +  .845441D-02, .500090D-02, .272307D-02, .132574D-02,
     +  .549046D-03, .177029D-03, .374489D-04, .343843D-05,
     +  .000000D+00, .617585D+06, .473358D+06, .357410D+06,
     +  .269742D+06, .203505D+06, .153459D+06, .115680D+06,
     +  .871598D+05, .656489D+05, .494246D+05, .371983D+05,
     +  .279851D+05, .210484D+05, .158258D+05, .118971D+05,
     +  .894172D+04, .672039D+04, .505063D+04, .379653D+04,
     +  .285445D+04, .214731D+04, .161632D+04, .121786D+04,
     +  .918683D+03, .694137D+03, .525474D+03, .398870D+03,
     +  .302468D+03, .231122D+03, .177338D+03, .136757D+03,
     +  .106054D+03, .827790D+02, .651199D+02, .516097D+02,
     +  .412553D+02, .332862D+02, .271129D+02, .223041D+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .185270D+02, .155435D+02, .131605D+02, .112415D+02,
     +  .967990D+01, .839686D+01, .733105D+01, .643978D+01,
     +  .567894D+01, .503125D+01, .446744D+01, .397748D+01,
     +  .354647D+01, .316477D+01, .282461D+01, .251994D+01,
     +  .224591D+01, .199866D+01, .177509D+01, .157265D+01,
     +  .138926D+01, .122316D+01, .107288D+01, .936972D+00,
     +  .814958D+00, .704518D+00, .605549D+00, .517181D+00,
     +  .438645D+00, .369188D+00, .308119D+00, .254755D+00,
     +  .208481D+00, .168681D+00, .134662D+00, .106177D+00,
     +  .822466D-01, .625508D-01, .465827D-01, .338519D-01,
     +  .239077D-01, .163116D-01, .106914D-01, .664303D-02,
     +  .387766D-02, .208011D-02, .995518D-03, .404112D-03,
     +  .127292D-03, .263257D-04, .244424D-05, .000000D+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .796927D+06, .608458D+06, .457346D+06, .343591D+06,
     +  .258022D+06, .193660D+06, .145291D+06, .108945D+06,
     +  .816574D+05, .611728D+05, .458092D+05, .342875D+05,
     +  .256550D+05, .191878D+05, .143472D+05, .107243D+05,
     +  .801533D+04, .598971D+04, .447641D+04, .334578D+04,
     +  .250177D+04, .187156D+04, .140133D+04, .105031D+04,
     +  .788399D+03, .592848D+03, .446961D+03, .336571D+03,
     +  .255388D+03, .194582D+03, .148997D+03, .114734D+03,
     +  .889273D+02, .694765D+02, .546911D+02, .434321D+02,
     +  .348201D+02, .281893D+02, .230536D+02, .190418D+02,
     +  .158888D+02, .133823D+02, .113726D+02, .974380D+01,
     +  .841051D+01, .730688D+01, .638715D+01, .560469D+01,
     +  .494092D+01, .436523D+01, .386687D+01, .343029D+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .304537D+01, .270394D+01, .239966D+01, .212742D+01,
     +  .188314D+01, .166352D+01, .146583D+01, .128783D+01,
     +  .112762D+01, .983587D+00, .854163D+00, .738728D+00,
     +  .634937D+00, .542553D+00, .460627D+00, .388319D+00,
     +  .324818D+00, .269383D+00, .221291D+00, .179898D+00,
     +  .144565D+00, .114595D+00, .896982D-01, .689529D-01,
     +  .520233D-01, .384187D-01, .276724D-01, .193596D-01,
     +  .130750D-01, .847658D-02, .520375D-02, .299737D-02,
     +  .158399D-02, .745212D-03, .296534D-03, .912834D-04,
     +  .184725D-04, .173410D-05, .000000D+00, .101925D+07,
     +  .775193D+06, .580031D+06, .433767D+06, .324233D+06,
     +  .242213D+06, .180855D+06, .134960D+06, .100663D+06,
     +  .750383D+05, .559107D+05, .416356D+05, .309923D+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .230581D+05, .171492D+05, .127494D+05, .947633D+04,
     +  .704176D+04, .523260D+04, .388821D+04, .289012D+04,
     +  .214901D+04, .159914D+04, .119103D+04, .888313D+03,
     +  .663622D+03, .497010D+03, .371717D+03, .280148D+03,
     +  .211995D+03, .161222D+03, .123305D+03, .949273D+02,
     +  .736747D+02, .576204D+02, .454711D+02, .362335D+02,
     +  .291624D+02, .237156D+02, .194830D+02, .161723D+02,
     +  .135525D+02, .114604D+02, .977144D+01, .839381D+01,
     +  .725738D+01, .631346D+01, .551312D+01, .483650D+01,
     +  .425183D+01, .374762D+01, .330775D+01, .292160D+01,
     +  .258070D+01, .227838D+01, .200930D+01, .176916D+01,
     +  .155448D+01, .136237D+01, .119043D+01, .103661D+01,
     +  .899200D+00, .776498D+00, .667764D+00, .570637D+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .484759D+00, .409116D+00, .342811D+00, .284984D+00,
     +  .234858D+00, .191685D+00, .154797D+00, .123546D+00,
     +  .972403D-01, .755596D-01, .576408D-01, .431414D-01,
     +  .315923D-01, .225536D-01, .156295D-01, .104486D-01,
     +  .669981D-02, .406355D-02, .230958D-02, .120234D-02,
     +  .556059D-03, .216922D-03, .652822D-04, .129372D-04,
     +  .122776D-05, .000000D+00, .129087D+07, .978022D+06,
     +  .728511D+06, .542336D+06, .403526D+06, .300050D+06,
     +  .222987D+06, .165609D+06, .122928D+06, .911879D+05,
     +  .676073D+05, .500931D+05, .370977D+05, .274578D+05,
     +  .203142D+05, .150218D+05, .111048D+05, .820636D+04,
     +  .606377D+04, .448010D+04, .331070D+04, .244716D+04,
     +  .181003D+04, .133983D+04, .993055D+03, .737156D+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .548534D+03, .407547D+03, .305138D+03, .229386D+03,
     +  .173300D+03, .131675D+03, .100715D+03, .776714D+02,
     +  .603695D+02, .473543D+02, .375152D+02, .300256D+02,
     +  .242866D+02, .198492D+02, .163941D+02, .136716D+02,
     +  .115061D+02, .976425D+01, .834832D+01, .718416D+01,
     +  .622034D+01, .540582D+01, .471956D+01, .412870D+01,
     +  .362110D+01, .318009D+01, .279463D+01, .245591D+01,
     +  .215699D+01, .189231D+01, .165736D+01, .144850D+01,
     +  .126266D+01, .109732D+01, .950296D+00, .819768D+00,
     +  .703936D+00, .601943D+00, .511427D+00, .431920D+00,
     +  .362357D+00, .301793D+00, .249338D+00, .204185D+00,
     +  .165573D+00, .132822D+00, .105284D+00, .822779D-01,
     +  .634661D-01, .480445D-01, .356710D-01, .259018D-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .183265D-01, .125798D-01, .832413D-02, .527898D-02,
     +  .316316D-02, .177393D-02, .909714D-03, .413583D-03,
     +  .158191D-03, .465589D-04, .904287D-05, .867448D-06,
     +  .000000D+00, .161830D+07, .122150D+07, .905857D+06,
     +  .671355D+06, .497269D+06, .368067D+06, .272272D+06,
     +  .201266D+06, .148688D+06, .109768D+06, .809868D+05,
     +  .597108D+05, .439993D+05, .324008D+05, .238478D+05,
     +  .175425D+05, .128993D+05, .948104D+04, .696718D+04,
     +  .511883D+04, .376122D+04, .276411D+04, .203244D+04,
     +  .149548D+04, .110169D+04, .812749D+03, .601011D+03,
     +  .443685D+03, .330090D+03, .246568D+03, .185098D+03,
     +  .139755D+03, .106231D+03, .814279D+02, .629137D+02,
     +  .490667D+02, .386564D+02, .307744D+02, .247648D+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .201401D+02, .165547D+02, .137410D+02, .115112D+02,
     +  .972391D+01, .827580D+01, .708897D+01, .610950D+01,
     +  .528444D+01, .459162D+01, .399729D+01, .348864D+01,
     +  .304853D+01, .266552D+01, .233052D+01, .203631D+01,
     +  .177714D+01, .154830D+01, .134599D+01, .116701D+01,
     +  .100869D+01, .868768D+00, .745295D+00, .636400D+00,
     +  .541117D+00, .457099D+00, .383780D+00, .320056D+00,
     +  .264948D+00, .217544D+00, .177022D+00, .142617D+00,
     +  .113645D+00, .894659D-01, .694189D-01, .531548D-01,
     +  .399295D-01, .294078D-01, .211734D-01, .148472D-01,
     +  .100945D-01, .661129D-02, .414654D-02, .245453D-02,
     +  .135817D-02, .686097D-03, .306630D-03, .115006D-03,
     +  .331152D-04, .630839D-05, .611585D-06, .000000D+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .200810D+07, .151019D+07, .111510D+07, .822820D+06,
     +  .606765D+06, .447107D+06, .329244D+06, .242267D+06,
     +  .178148D+06, .130898D+06, .961172D+05, .705245D+05,
     +  .517134D+05, .378925D+05, .277493D+05, .203082D+05,
     +  .148555D+05, .108612D+05, .793866D+04, .580083D+04,
     +  .423874D+04, .309751D+04, .226456D+04, .165660D+04,
     +  .121319D+04, .889647D+03, .653901D+03, .479748D+03,
     +  .354735D+03, .263355D+03, .196493D+03, .147462D+03,
     +  .111421D+03, .849102D+02, .652322D+02, .505963D+02,
     +  .396509D+02, .314060D+02, .251494D+02, .203562D+02,
     +  .166554D+02, .137623D+02, .114775D+02, .965235D+01,
     +  .817814D+01, .697365D+01, .598268D+01, .515060D+01,
     +  .445423D+01, .385900D+01, .335152D+01, .291422D+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .253530D+01, .220540D+01, .191709D+01, .166439D+01,
     +  .144245D+01, .124732D+01, .107566D+01, .924708D+00,
     +  .792076D+00, .675747D+00, .573779D+00, .485114D+00,
     +  .407428D+00, .340074D+00, .281919D+00, .231962D+00,
     +  .189281D+00, .153048D+00, .122502D+00, .969654D-01,
     +  .758108D-01, .584036D-01, .443916D-01, .330897D-01,
     +  .241738D-01, .172574D-01, .119927D-01, .807584D-02,
     +  .523492D-02, .324699D-02, .189871D-02, .103657D-02,
     +  .515806D-03, .226618D-03, .833581D-04, .234905D-04,
     +  .439229D-05, .430296D-06, .000000D+00, .246676D+07,
     +  .184852D+07, .135914D+07, .998614D+06, .733218D+06,
     +  .537927D+06, .394370D+06, .288890D+06, .211469D+06,
     +  .154669D+06, .113043D+06, .825530D+05, .602442D+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .439296D+05, .320122D+05, .233112D+05, .169658D+05,
     +  .123404D+05, .897267D+04, .652162D+04, .473975D+04,
     +  .344467D+04, .250437D+04, .182169D+04, .132647D+04,
     +  .967069D+03, .706650D+03, .515355D+03, .378813D+03,
     +  .279571D+03, .207368D+03, .154721D+03, .116239D+03,
     +  .880898D+02, .673087D+02, .519344D+02, .404947D+02,
     +  .319191D+02, .254411D+02, .204991D+02, .166982D+02,
     +  .137376D+02, .114073D+02, .955165D+01, .805734D+01,
     +  .684008D+01, .584165D+01, .500594D+01, .430888D+01,
     +  .371519D+01, .321095D+01, .277823D+01, .240490D+01,
     +  .208136D+01, .179998D+01, .155461D+01, .134024D+01,
     +  .115279D+01, .988811D+00, .845444D+00, .720220D+00,
     +  .611047D+00, .515932D+00, .433738D+00, .362178D+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .300532D+00, .247654D+00, .202531D+00, .164241D+00,
     +  .131959D+00, .104934D+00, .825050D-01, .640610D-01,
     +  .489985D-01, .369685D-01, .273434D-01, .198142D-01,
     +  .140248D-01, .965857D-02, .644171D-02, .413266D-02,
     +  .253487D-02, .146424D-02, .788667D-03, .386575D-03,
     +  .166968D-03, .602410D-04, .166201D-04, .305245D-05,
     +  .302132D-06, .000000D+00, .733714D+05, .105520D+06,
     +  .807267D+05, .617642D+05, .472606D+05, .361671D+05,
     +  .276814D+05, .211902D+05, .162243D+05, .124250D+05,
     +  .951799D+04, .729346D+04, .559096D+04, .428780D+04,
     +  .329013D+04, .252618D+04, .194104D+04, .149275D+04,
     +  .114917D+04, .885747D+03, .683682D+03, .528598D+03,
     +  .409495D+03, .317954D+03, .247534D+03, .193304D+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .151492D+03, .118804D+03, .939312D+02, .746512D+02,
     +  .596715D+02, .480013D+02, .388805D+02, .317448D+02,
     +  .261084D+02, .216481D+02, .180985D+02, .152553D+02,
     +  .129613D+02, .110947D+02, .956477D+01, .829691D+01,
     +  .723654D+01, .634100D+01, .557743D+01, .492053D+01,
     +  .435267D+01, .385329D+01, .341668D+01, .302822D+01,
     +  .268456D+01, .237835D+01, .210485D+01, .186017D+01,
     +  .164108D+01, .144485D+01, .126913D+01, .111190D+01,
     +  .971385D+00, .846001D+00, .734326D+00, .635070D+00,
     +  .547060D+00, .469563D+00, .400801D+00, .340382D+00,
     +  .287477D+00, .241331D+00, .201251D+00, .166603D+00,
     +  .136808D+00, .111335D+00, .896870D-01, .714090D-01,
     +  .562434D-01, .435941D-01, .332380D-01, .248639D-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .181906D-01, .129635D-01, .895285D-02, .595589D-02,
     +  .377094D-02, .225216D-02, .124290D-02, .615714D-03,
     +  .260815D-03, .862487D-04, .181495D-04, .126405D-05,
     +  .000000D+00, .156781D+06, .121687D+06, .932417D+05,
     +  .714442D+05, .547463D+05, .419512D+05, .321496D+05,
     +  .246388D+05, .188852D+05, .144764D+05, .110989D+05,
     +  .851062D+04, .652774D+04, .500808D+04, .384373D+04,
     +  .295123D+04, .226727D+04, .174287D+04, .134085D+04,
     +  .103249D+04, .795984D+03, .614454D+03, .475110D+03,
     +  .368051D+03, .285771D+03, .222464D+03, .173732D+03,
     +  .135687D+03, .106797D+03, .844470D+02, .671312D+02,
     +  .536771D+02, .431983D+02, .350283D+02, .286024D+02,
     +  .235382D+02, .195285D+02, .163322D+02, .137684D+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .116938D+02, .100045D+02, .861335D+01, .745799D+01,
     +  .648880D+01, .566852D+01, .496777D+01, .436651D+01,
     +  .384144D+01, .338579D+01, .298319D+01, .262955D+01,
     +  .231658D+01, .203896D+01, .179226D+01, .157281D+01,
     +  .137751D+01, .120375D+01, .104925D+01, .912024D+00,
     +  .790329D+00, .682592D+00, .587425D+00, .503519D+00,
     +  .430075D+00, .365281D+00, .308678D+00, .259398D+00,
     +  .216661D+00, .179755D+00, .148036D+00, .120916D+00,
     +  .978672D-01, .784012D-01, .620624D-01, .485914D-01,
     +  .374286D-01, .283505D-01, .210622D-01, .152965D-01,
     +  .108166D-01, .740697D-02, .488285D-02, .306036D-02,
     +  .180748D-02, .986054D-03, .481967D-03, .200896D-03,
     +  .651618D-04, .134488D-04, .947843D-06, .000000D+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .186492D+06, .144775D+06, .110949D+06, .850162D+05,
     +  .651445D+05, .499117D+05, .382412D+05, .292966D+05,
     +  .224450D+05, .171947D+05, .131735D+05, .100926D+05,
     +  .773337D+04, .592603D+04, .454222D+04, .348222D+04,
     +  .267067D+04, .204901D+04, .157305D+04, .120841D+04,
     +  .929190D+03, .715212D+03, .551277D+03, .425571D+03,
     +  .329184D+03, .255199D+03, .198413D+03, .154203D+03,
     +  .120739D+03, .949367D+02, .750217D+02, .596070D+02,
     +  .476529D+02, .383731D+02, .311099D+02, .254138D+02,
     +  .209282D+02, .173716D+02, .145356D+02, .122542D+02,
     +  .104082D+02, .889745D+01, .765106D+01, .661229D+01,
     +  .573910D+01, .499809D+01, .436661D+01, .381878D+01,
     +  .334661D+01, .293213D+01, .257044D+01, .225239D+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .197208D+01, .172454D+01, .150571D+01, .131215D+01,
     +  .114096D+01, .989656D+00, .856060D+00, .738270D+00,
     +  .634584D+00, .543524D+00, .463675D+00, .394174D+00,
     +  .333191D+00, .280212D+00, .234337D+00, .194774D+00,
     +  .160795D+00, .131754D+00, .107062D+00, .861958D-01,
     +  .686784D-01, .540597D-01, .420806D-01, .322167D-01,
     +  .242472D-01, .178932D-01, .129027D-01, .905506D-02,
     +  .614997D-02, .401870D-02, .249432D-02, .145746D-02,
     +  .784573D-03, .377777D-03, .154713D-03, .491402D-04,
     +  .993045D-05, .709045D-06, .000000D+00, .226752D+06,
     +  .175867D+06, .134629D+06, .103037D+06, .788520D+05,
     +  .603299D+05, .461551D+05, .353031D+05, .270010D+05,
     +  .206474D+05, .157884D+05, .120711D+05, .922927D+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .705592D+04, .539502D+04, .412519D+04, .315506D+04,
     +  .241353D+04, .184713D+04, .141426D+04, .108366D+04,
     +  .830999D+03, .637996D+03, .490443D+03, .377674D+03,
     +  .291405D+03, .225435D+03, .174264D+03, .135687D+03,
     +  .106062D+03, .832986D+02, .657578D+02, .522201D+02,
     +  .417625D+02, .336200D+02, .272681D+02, .222937D+02,
     +  .183718D+02, .152628D+02, .127765D+02, .107770D+02,
     +  .915069D+01, .781733D+01, .671301D+01, .579062D+01,
     +  .501276D+01, .435409D+01, .378623D+01, .329990D+01,
     +  .287562D+01, .250766D+01, .218608D+01, .190435D+01,
     +  .165705D+01, .143970D+01, .124858D+01, .108051D+01,
     +  .932804D+00, .803112D+00, .689397D+00, .589844D+00,
     +  .502893D+00, .427043D+00, .361375D+00, .304056D+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .254523D+00, .211856D+00, .175254D+00, .143983D+00,
     +  .117401D+00, .949189D-01, .760264D-01, .602566D-01,
     +  .471699D-01, .365099D-01, .277859D-01, .207823D-01,
     +  .152359D-01, .109102D-01, .760023D-02, .512061D-02,
     +  .331739D-02, .203952D-02, .117932D-02, .627402D-03,
     +  .298082D-03, .120179D-03, .374828D-04, .744662D-05,
     +  .538724D-06, .000000D+00, .163673D+06, .216260D+06,
     +  .165208D+06, .126168D+06, .963385D+05, .735381D+05,
     +  .561251D+05, .428220D+05, .326673D+05, .249134D+05,
     +  .189977D+05, .144829D+05, .110403D+05, .841434D+04,
     +  .641302D+04, .488719D+04, .372490D+04, .283914D+04,
     +  .216471D+04, .165092D+04, .125985D+04, .961990D+03,
     +  .735284D+03, .562605D+03, .431143D+03, .330971D+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .254694D+03, .195780D+03, .151563D+03, .117762D+03,
     +  .919135D+02, .720930D+02, .568732D+02, .451773D+02,
     +  .361197D+02, .290923D+02, .236200D+02, .193298D+02,
     +  .159487D+02, .132605D+02, .111116D+02, .937402D+01,
     +  .795796D+01, .679216D+01, .582428D+01, .501291D+01,
     +  .433000D+01, .374471D+01, .324645D+01, .281431D+01,
     +  .244173D+01, .211800D+01, .183602D+01, .158991D+01,
     +  .137482D+01, .118674D+01, .102224D+01, .878466D+00,
     +  .752900D+00, .643386D+00, .548015D+00, .465152D+00,
     +  .393231D+00, .331283D+00, .277483D+00, .231228D+00,
     +  .191586D+00, .157752D+00, .128994D+00, .104674D+00,
     +  .842129D-01, .671111D-01, .529156D-01, .411999D-01,
     +  .317119D-01, .239937D-01, .178361D-01, .129918D-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .923976D-02, .638986D-02, .427131D-02, .274384D-02,
     +  .167122D-02, .956473D-03, .502996D-03, .235861D-03,
     +  .936517D-04, .287009D-04, .561016D-05, .411055D-06,
     +  .000000D+00, .363855D+06, .280875D+06, .213835D+06,
     +  .162736D+06, .123816D+06, .941677D+05, .716003D+05,
     +  .544201D+05, .413518D+05, .314099D+05, .238526D+05,
     +  .181073D+05, .137432D+05, .104278D+05, .791120D+04,
     +  .600063D+04, .455141D+04, .345188D+04, .261839D+04,
     +  .198638D+04, .150757D+04, .114467D+04, .869811D+03,
     +  .661532D+03, .503788D+03, .384239D+03, .293712D+03,
     +  .224190D+03, .172314D+03, .132899D+03, .102939D+03,
     +  .801119D+02, .626948D+02, .493992D+02, .391709D+02,
     +  .312898D+02, .251946D+02, .204497D+02, .167362D+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .138048D+02, .114779D+02, .960972D+01, .809787D+01,
     +  .686205D+01, .584319D+01, .499508D+01, .428620D+01,
     +  .368288D+01, .317283D+01, .273352D+01, .235735D+01,
     +  .203273D+01, .175188D+01, .150838D+01, .129699D+01,
     +  .111335D+01, .953764D+00, .815174D+00, .694899D+00,
     +  .590654D+00, .500431D+00, .422522D+00, .355301D+00,
     +  .297749D+00, .248064D+00, .205601D+00, .169427D+00,
     +  .138738D+00, .112811D+00, .910192D-01, .727987D-01,
     +  .576664D-01, .451883D-01, .349571D-01, .267284D-01,
     +  .200822D-01, .148194D-01, .107114D-01, .755570D-02,
     +  .517973D-02, .342978D-02, .218090D-02, .131344D-02,
     +  .742400D-03, .384952D-03, .177615D-03, .691957D-04,
     +  .207352D-04, .396291D-05, .293712D-06, .000000D+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .474806D+06, .365247D+06, .276945D+06, .209901D+06,
     +  .159036D+06, .120441D+06, .911826D+05, .690000D+05,
     +  .521965D+05, .394673D+05, .298328D+05, .225405D+05,
     +  .170258D+05, .128553D+05, .970409D+04, .732302D+04,
     +  .552547D+04, .416831D+04, .314458D+04, .237225D+04,
     +  .179012D+04, .135122D+04, .102057D+04, .771378D+03,
     +  .583695D+03, .442263D+03, .335791D+03, .254509D+03,
     +  .194224D+03, .148704D+03, .114321D+03, .882917D+02,
     +  .685597D+02, .535974D+02, .421632D+02, .334131D+02,
     +  .266913D+02, .214948D+02, .174554D+02, .142886D+02,
     +  .117918D+02, .980091D+01, .820047D+01, .690106D+01,
     +  .583686D+01, .495691D+01, .422627D+01, .360856D+01,
     +  .308978D+01, .264592D+01, .226834D+01, .194464D+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .166640D+01, .142673D+01, .121998D+01, .104151D+01,
     +  .887392D+00, .754379D+00, .639649D+00, .540816D+00,
     +  .455792D+00, .382812D+00, .320210D+00, .266927D+00,
     +  .221198D+00, .182347D+00, .149445D+00, .121698D+00,
     +  .983983D-01, .789335D-01, .627595D-01, .494124D-01,
     +  .384788D-01, .295731D-01, .224599D-01, .167562D-01,
     +  .122735D-01, .880205D-02, .615757D-02, .418408D-02,
     +  .274417D-02, .172710D-02, .102843D-02, .574105D-03,
     +  .293555D-03, .133316D-03, .509973D-04, .149689D-04,
     +  .280789D-05, .211289D-06, .000000D+00, .617139D+06,
     +  .472960D+06, .357057D+06, .269427D+06, .203225D+06,
     +  .153211D+06, .115459D+06, .869640D+05, .654752D+05,
     +  .492705D+05, .370618D+05, .278641D+05, .209413D+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .157310D+05, .118133D+05, .886762D+04, .665493D+04,
     +  .499285D+04, .374556D+04, .280951D+04, .210772D+04,
     +  .158148D+04, .118721D+04, .891739D+03, .670463D+03,
     +  .504681D+03, .380619D+03, .286482D+03, .217092D+03,
     +  .165023D+03, .125940D+03, .965445D+02, .744039D+02,
     +  .577260D+02, .450644D+02, .354399D+02, .280954D+02,
     +  .224555D+02, .181003D+02, .147087D+02, .120519D+02,
     +  .994718D+01, .826607D+01, .690992D+01, .580629D+01,
     +  .489953D+01, .415138D+01, .352287D+01, .299837D+01,
     +  .255247D+01, .217556D+01, .185448D+01, .158022D+01,
     +  .134546D+01, .114420D+01, .971545D+00, .823354D+00,
     +  .696229D+00, .587233D+00, .493898D+00, .414076D+00,
     +  .345962D+00, .287869D+00, .238709D+00, .196762D+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .161332D+00, .131503D+00, .106496D+00, .856213D-01,
     +  .682883D-01, .539745D-01, .422376D-01, .326859D-01,
     +  .249569D-01, .188265D-01, .139460D-01, .101393D-01,
     +  .721456D-02, .500517D-02, .337095D-02, .218979D-02,
     +  .136405D-02, .803082D-03, .442749D-03, .223249D-03,
     +  .997982D-04, .374917D-04, .107842D-04, .198725D-05,
     +  .151825D-06, .000000D+00, .796451D+06, .608034D+06,
     +  .456969D+06, .343256D+06, .257725D+06, .193396D+06,
     +  .145057D+06, .108737D+06, .814730D+05, .610094D+05,
     +  .456644D+05, .341594D+05, .255416D+05, .190875D+05,
     +  .142585D+05, .106460D+05, .794622D+04, .592874D+04,
     +  .442267D+04, .329844D+04, .246010D+04, .183491D+04,
     +  .136910D+04, .102200D+04, .763540D+03, .571027D+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .427817D+03, .319810D+03, .240685D+03, .181681D+03,
     +  .137668D+03, .104776D+03, .801599D+02, .617376D+02,
     +  .478420D+02, .373486D+02, .293927D+02, .233231D+02,
     +  .186659D+02, .150624D+02, .122571D+02, .100486D+02,
     +  .829543D+01, .688982D+01, .575284D+01, .482435D+01,
     +  .406291D+01, .342715D+01, .289982D+01, .245427D+01,
     +  .207997D+01, .176307D+01, .149403D+01, .126514D+01,
     +  .107009D+01, .903769D+00, .761864D+00, .640852D+00,
     +  .537704D+00, .449890D+00, .375224D+00, .311875D+00,
     +  .258151D+00, .212948D+00, .174597D+00, .142391D+00,
     +  .115433D+00, .929650D-01, .743212D-01, .589337D-01,
     +  .463047D-01, .360148D-01, .276954D-01, .210080D-01,
     +  .157405D-01, .115771D-01, .835423D-02, .589773D-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .405754D-02, .270846D-02, .174260D-02, .107432D-02,
     +  .625355D-03, .340485D-03, .169304D-03, .745007D-04,
     +  .274908D-04, .775192D-05, .140414D-05, .108898D-06,
     +  .000000D+00, .101874D+07, .774741D+06, .579630D+06,
     +  .433411D+06, .323916D+06, .241933D+06, .180606D+06,
     +  .134739D+06, .100468D+06, .748651D+05, .557574D+05,
     +  .415000D+05, .308723D+05, .229520D+05, .170556D+05,
     +  .126667D+05, .940342D+04, .697750D+04, .517599D+04,
     +  .383838D+04, .284628D+04, .211047D+04, .156529D+04,
     +  .116132D+04, .862233D+03, .640741D+03, .476948D+03,
     +  .354161D+03, .264754D+03, .198493D+03, .149371D+03,
     +  .112892D+03, .857617D+02, .655872D+02, .504657D+02,
     +  .391195D+02, .305710D+02, .240903D+02, .191484D+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .153481D+02, .124073D+02, .101060D+02, .828978D+01,
     +  .684220D+01, .567807D+01, .473293D+01, .396237D+01,
     +  .332276D+01, .279536D+01, .235241D+01, .198250D+01,
     +  .167118D+01, .140845D+01, .118625D+01, .998018D+00,
     +  .838446D+00, .703096D+00, .588340D+00, .491087D+00,
     +  .408763D+00, .339164D+00, .280447D+00, .230930D+00,
     +  .189499D+00, .154549D+00, .125365D+00, .101078D+00,
     +  .809534D-01, .643528D-01, .507339D-01, .396253D-01,
     +  .306313D-01, .234071D-01, .176384D-01, .131260D-01,
     +  .958527D-02, .686510D-02, .480822D-02, .328032D-02,
     +  .217013D-02, .138285D-02, .843728D-03, .485565D-03,
     +  .261087D-03, .128025D-03, .554587D-04, .201039D-04,
     +  .555936D-05, .990398D-06, .779586D-07, .000000D+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .129033D+07, .977542D+06, .728085D+06, .541958D+06,
     +  .403190D+06, .299752D+06, .222723D+06, .165375D+06,
     +  .122721D+06, .910045D+05, .674450D+05, .499496D+05,
     +  .369709D+05, .273458D+05, .202154D+05, .149346D+05,
     +  .110280D+05, .813867D+04, .600418D+04, .442769D+04,
     +  .326463D+04, .240669D+04, .177450D+04, .130866D+04,
     +  .965716D+03, .713186D+03, .527528D+03, .389176D+03,
     +  .289038D+03, .215272D+03, .160916D+03, .120799D+03,
     +  .911463D+02, .692325D+02, .529084D+02, .407357D+02,
     +  .316202D+02, .247518D+02, .195454D+02, .155653D+02,
     +  .125030D+02, .101205D+02, .825070D+01, .676881D+01,
     +  .558371D+01, .462694D+01, .385128D+01, .321108D+01,
     +  .268620D+01, .224792D+01, .188401D+01, .157952D+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .132404D+01, .110922D+01, .928297D+00, .775794D+00,
     +  .647178D+00, .538751D+00, .447379D+00, .370469D+00,
     +  .305811D+00, .251566D+00, .206072D+00, .168220D+00,
     +  .136468D+00, .110105D+00, .882903D-01, .703198D-01,
     +  .555832D-01, .435659D-01, .338240D-01, .259863D-01,
     +  .197319D-01, .147708D-01, .109171D-01, .791503D-02,
     +  .562622D-02, .390930D-02, .264466D-02, .173394D-02,
     +  .109427D-02, .660736D-03, .375936D-03, .199623D-03,
     +  .965311D-04, .411667D-04, .146627D-04, .397766D-05,
     +  .697329D-06, .557011D-07, .000000D+00, .161772D+07,
     +  .122099D+07, .905404D+06, .670953D+06, .496913D+06,
     +  .367751D+06, .271992D+06, .201018D+06, .148469D+06,
     +  .109574D+06, .808152D+05, .595591D+05, .438653D+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .322826D+05, .237435D+05, .174506D+05, .128184D+05,
     +  .940980D+04, .690451D+04, .506375D+04, .371284D+04,
     +  .272164D+04, .199518D+04, .146281D+04, .107305D+04,
     +  .787659D+03, .579037D+03, .424479D+03, .313267D+03,
     +  .231828D+03, .172173D+03, .128410D+03, .962553D+02,
     +  .726361D+02, .551465D+02, .421831D+02, .325326D+02,
     +  .253039D+02, .198557D+02, .157144D+02, .125457D+02,
     +  .100940D+02, .818015D+01, .667160D+01, .547164D+01,
     +  .450809D+01, .373117D+01, .309345D+01, .257350D+01,
     +  .214177D+01, .178531D+01, .148875D+01, .124132D+01,
     +  .103445D+01, .861193D+00, .715981D+00, .594201D+00,
     +  .492109D+00, .406554D+00, .334939D+00, .275065D+00,
     +  .225110D+00, .183444D+00, .148968D+00, .120210D+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .964667D-01, .769323D-01, .609328D-01, .478898D-01,
     +  .373173D-01, .287994D-01, .219897D-01, .165911D-01,
     +  .123373D-01, .905604D-02, .651847D-02, .459852D-02,
     +  .316978D-02, .212630D-02, .138156D-02, .863460D-03,
     +  .515956D-03, .290222D-03, .152189D-03, .725759D-04,
     +  .304720D-04, .106659D-04, .283941D-05, .490118D-06,
     +  .397213D-07, .000000D+00, .200749D+07, .150965D+07,
     +  .111462D+07, .822394D+06, .606387D+06, .446772D+06,
     +  .328948D+06, .242004D+06, .177916D+06, .130693D+06,
     +  .959359D+05, .703644D+05, .515720D+05, .377679D+05,
     +  .276395D+05, .202115D+05, .147703D+05, .107863D+05,
     +  .787281D+04, .574299D+04, .418797D+04, .305297D+04,
     +  .222551D+04, .162238D+04, .118322D+04, .863406D+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .630934D+03, .459688D+03, .337175D+03, .247978D+03,
     +  .183019D+03, .135642D+03, .101036D+03, .757650D+02,
     +  .571606D+02, .434509D+02, .333030D+02, .257448D+02,
     +  .200796D+02, .157968D+02, .125373D+02, .100285D+02,
     +  .808035D+01, .655269D+01, .534379D+01, .437811D+01,
     +  .360358D+01, .297119D+01, .245836D+01, .203487D+01,
     +  .168713D+01, .139942D+01, .116070D+01, .962221D+00,
     +  .796914D+00, .659129D+00, .544214D+00, .448407D+00,
     +  .368560D+00, .302087D+00, .246817D+00, .200955D+00,
     +  .162911D+00, .131604D+00, .105635D+00, .843143D-01,
     +  .668730D-01, .526703D-01, .411600D-01, .318858D-01,
     +  .244599D-01, .185608D-01, .139146D-01, .102781D-01,
     +  .749266D-02, .535415D-02, .374850D-02, .256321D-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .170486D-02, .109774D-02, .679433D-03, .401763D-03,
     +  .223415D-03, .115695D-03, .544113D-04, .224935D-04,
     +  .773846D-05, .202232D-05, .343887D-06, .282722D-07,
     +  .000000D+00, .246611D+07, .184794D+07, .135863D+07,
     +  .998162D+06, .732817D+06, .537572D+06, .394056D+06,
     +  .288612D+06, .211223D+06, .154452D+06, .112852D+06,
     +  .823840D+05, .600951D+05, .437982D+05, .318965D+05,
     +  .232093D+05, .168762D+05, .122616D+05, .890351D+04,
     +  .646092D+04, .468651D+04, .339800D+04, .246348D+04,
     +  .178589D+04, .129513D+04, .939649D+03, .682668D+03,
     +  .494422D+03, .360502D+03, .263549D+03, .193338D+03,
     +  .142424D+03, .105443D+03, .785920D+02, .589354D+02,
     +  .445316D+02, .339285D+02, .260743D+02, .202185D+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .158148D+02, .124803D+02, .992678D+01, .795374D+01,
     +  .641431D+01, .520216D+01, .423876D+01, .346998D+01,
     +  .284554D+01, .234181D+01, .192804D+01, .159012D+01,
     +  .131204D+01, .108256D+01, .892802D+00, .735618D+00,
     +  .605316D+00, .497234D+00, .407613D+00, .333325D+00,
     +  .271816D+00, .220950D+00, .178971D+00, .144336D+00,
     +  .115990D+00, .926071D-01, .735175D-01, .579900D-01,
     +  .454184D-01, .352900D-01, .271781D-01, .207230D-01,
     +  .156275D-01, .116405D-01, .854081D-02, .618319D-02,
     +  .438634D-02, .304755D-02, .206719D-02, .136327D-02,
     +  .869850D-03, .533155D-03, .311976D-03, .171506D-03,
     +  .877071D-04, .406803D-04, .165594D-04, .560042D-05,
     +  .143722D-05, .240886D-06, .200862D-07, .000000D+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
