
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileLandgramBoxAttributes.h
    \brief Definition of LandgramBox Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef LandgramBoxAttributes_H
#define LandgramBoxAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class LandgramBoxAttributes 
{
public:
//  --  constructor
    LandgramBoxAttributes();
    
//  --  destructor
    virtual ~LandgramBoxAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const LandgramBoxAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double width_;
	string top1_shading_;
	string top2_shading_;
	string bottom1_shading_;
	string bottom2_shading_;
	unique_ptr<Colour> top1_colour_;
	unique_ptr<Colour> top2_colour_;
	unique_ptr<Colour> bottom1_colour_;
	unique_ptr<Colour> bottom2_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const LandgramBoxAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

