
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CartesianTransformationAttributes.h
    \\brief Definition of CartesianTransformation Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "CartesianTransformationAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CartesianTransformationAttributes::CartesianTransformationAttributes():
	
	x_(MagTranslator<string, XCoordinate>().magics("subpage_x_axis_type")),
	y_(MagTranslator<string, YCoordinate>().magics("subpage_y_axis_type"))
	
{
}


CartesianTransformationAttributes::~CartesianTransformationAttributes()
{

}


void CartesianTransformationAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "subpage";
	
	
	setMember(prefix, "subpage_x_axis_type", x_, params);
	setMember(prefix, "subpage_y_axis_type", y_, params);
	
}

void CartesianTransformationAttributes::copy(const CartesianTransformationAttributes& other)
{
	x_ = unique_ptr<XCoordinate>(other.x_->clone());
	y_ = unique_ptr<YCoordinate>(other.y_->clone());
	
}


bool CartesianTransformationAttributes::accept(const string& node)
{

	if ( magCompare(node, "cartesian")  )
		return true;
	if ( acceptNode(node, x_) )
		return true;
	if ( acceptNode(node, y_) )
		return true;
	
	return false;
}

void CartesianTransformationAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "cartesian")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), x_, node);
		setMember(node.name(), y_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), x_, *elt);
		setMember(elt->name(), y_, *elt);
		
	}
}

void CartesianTransformationAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " x = " <<  *x_;
	out << " y = " <<  *y_;
	
	out << "]" << "\n";
}

void CartesianTransformationAttributes::toxml(ostream& out)  const
{
	out <<  "\"cartesian\"";
	out << ", \"subpage_x_axis_type\":";
	x_->toxml(out);
	out << ", \"subpage_y_axis_type\":";
	y_->toxml(out);
	
}

static MagicsParameter<string> subpage_x_axis_type("subpage_x_axis_type", "regular");
static MagicsParameter<string> subpage_y_axis_type("subpage_y_axis_type", "regular");
#include "Coordinate.h"
static SimpleObjectMaker<XRegularCoordinate , XCoordinate> x_regular_XRegularCoordinate("x_regular");
static SimpleObjectMaker<XRegularCoordinate , XCoordinate> regular_XRegularCoordinate("regular");
static SimpleObjectMaker<XDateCoordinate , XCoordinate> x_date_XDateCoordinate("x_date");
static SimpleObjectMaker<XDateCoordinate , XCoordinate> date_XDateCoordinate("date");
static SimpleObjectMaker<XHyperCoordinate , XCoordinate> x_hyper_XHyperCoordinate("x_hyper");
static SimpleObjectMaker<XHyperCoordinate , XCoordinate> geoline_XHyperCoordinate("geoline");
static SimpleObjectMaker<XLogarithmicCoordinate , XCoordinate> x_logarithmic_XLogarithmicCoordinate("x_logarithmic");
static SimpleObjectMaker<XLogarithmicCoordinate , XCoordinate> logarithmic_XLogarithmicCoordinate("logarithmic");
static SimpleObjectMaker<YRegularCoordinate , YCoordinate> y_regular_YRegularCoordinate("y_regular");
static SimpleObjectMaker<YRegularCoordinate , YCoordinate> regular_YRegularCoordinate("regular");
static SimpleObjectMaker<YDateCoordinate , YCoordinate> y_date_YDateCoordinate("y_date");
static SimpleObjectMaker<YDateCoordinate , YCoordinate> date_YDateCoordinate("date");
static SimpleObjectMaker<YHyperCoordinate , YCoordinate> y_hyper_YHyperCoordinate("y_hyper");
static SimpleObjectMaker<YHyperCoordinate , YCoordinate> geoline_YHyperCoordinate("geoline");
static SimpleObjectMaker<YLogarithmicCoordinate , YCoordinate> y_logarithmic_YLogarithmicCoordinate("y_logarithmic");
static SimpleObjectMaker<YLogarithmicCoordinate , YCoordinate> logarithmic_YLogarithmicCoordinate("logarithmic");
