
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file NetcdfDecoderAttributes.h
    \\brief Definition of NetcdfDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "NetcdfDecoderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



NetcdfDecoderWrapper::NetcdfDecoderWrapper(): netcdfdecoder_(new NetcdfDecoder())


{


	

}
NetcdfDecoderWrapper::NetcdfDecoderWrapper(NetcdfDecoder* netcdfdecoder): netcdfdecoder_(netcdfdecoder)
{

	
}

NetcdfDecoderWrapper::~NetcdfDecoderWrapper()
{

}

void NetcdfDecoderWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("NETCDF_METADATA") ) {
		string metadata_value = request("NETCDF_METADATA");
		netcdfdecoder_->metadata_ = metadata_value;
		}
	
	
		string interpretor_value = request.countValues("NETCDF_TYPE") ?  (string) request("NETCDF_TYPE") : "guess";
	MagLog::debug() << " NETCDF_TYPE set to " << interpretor_value << endl;
	NetcdfInterpretorWrapper* interpretor_wrapper = 0;
	try
	{
		interpretor_wrapper = SimpleFactory<NetcdfInterpretorWrapper>::create(interpretor_value);
	}
	 catch (NoFactoryException&) {
		if (MagicsGlobal::strict()) {
            throw;
        }
		MagLog::warning() << "[" << interpretor_value << "] is not a valid value for interpretor: reset to default -> [guess]" << endl;
		interpretor_wrapper = SimpleFactory<NetcdfInterpretorWrapper>::create("guess");
	}
	interpretor_wrapper->set(request);
	netcdfdecoder_->interpretor_ =  unique_ptr<NetcdfInterpretor>(interpretor_wrapper->object());
	delete interpretor_wrapper;
	
}

void NetcdfDecoderWrapper::print(ostream& out)  const
{
	out << "NetcdfDecoderWrapper[]";
}


#include "NetcdfGuessInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfGuessInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_guess ("guess");
static SimpleObjectMaker<NetcdfGuessInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_guess_wrapper ("guess");


#include "NetcdfMatrixInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfMatrixInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_matrix ("matrix");
static SimpleObjectMaker<NetcdfMatrixInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_matrix_wrapper ("matrix");


#include "NetcdfGeoMatrixInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfGeoMatrixInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_geomatrix ("geomatrix");
static SimpleObjectMaker<NetcdfGeoMatrixInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_geomatrix_wrapper ("geomatrix");


#include "NetcdfVectorInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfVectorInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_vector ("vector");
static SimpleObjectMaker<NetcdfVectorInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_vector_wrapper ("vector");


#include "NetcdfGeoVectorInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfGeoVectorInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_geovector ("geovector");
static SimpleObjectMaker<NetcdfGeoVectorInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_geovector_wrapper ("geovector");


#include "NetcdfGeoPolarMatrixInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfGeoPolarMatrixInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_geopolarmatrix ("geopolarmatrix");
static SimpleObjectMaker<NetcdfGeoPolarMatrixInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_geopolarmatrix_wrapper ("geopolarmatrix");


#include "NetcdfGeopointsInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfGeopointsInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_geopoint ("geopoint");
static SimpleObjectMaker<NetcdfGeopointsInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_geopoint_wrapper ("geopoint");


#include "NetcdfXYpointsInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfXYpointsInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_xypoint ("xypoint");
static SimpleObjectMaker<NetcdfXYpointsInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_xypoint_wrapper ("xypoint");


#include "NetcdfOrcaInterpretorWrapper.h"
static SimpleObjectMaker<NetcdfOrcaInterpretor, NetcdfInterpretor> NetcdfDecoder_netcdf_type_complex_matrix ("complex_matrix");
static SimpleObjectMaker<NetcdfOrcaInterpretorWrapper, NetcdfInterpretorWrapper> NetcdfDecoder_netcdf_type_complex_matrix_wrapper ("complex_matrix");



