use strict;
use warnings;
use Module::Build;



my $class = Module::Build->subclass(
				    class => "My::Builder",
				    code => q{

sub ACTION_ppd {
   my $self = shift;
   $self->SUPER::ACTION_ppd;

   open O, '>__temp__';
   open I, 'Xray-Absorption.ppd';
   while (<I>) {
     $_ =~ s{File-Spec}{PathTools};
     print O $_;
   };
   close I;
   close O;
   rename '__temp__', 'Xray-Absorption.ppd';
};
},
				   );



my $build = $class -> new(
	 module_name        => 'Xray::Absorption',
	 create_readme      => 1,
	 ##create_makefile_pl => 'traditional',
	 license            => 'perl',
	 dist_author        => 'Bruce Ravel <bravel AT bnl DOT gov>',
	 dist_abstract      => "Class methods for X-ray absorption data of the elements",
	 requires           => {
				'Chemistry::Elements'	  => 0,
				'File::Spec'		  => 0,
				'Math::Derivative'	  => 0,
				'Math::Spline'		  => 0,
				'Storable'		  => 0,
				'Readonly'		  => 0,
				'Statistics::Descriptive' => 0,
				#'Test::More'	      => 0,
			       },
	 PL_files           => {
				'data/chantler2st.PL'  => 'data/chantler.db',
				'data/dat2st.PL'       => 'data/mcmaster.db',
				'data/henke2st.PL'     => 'data/henke.db',
				'data/shalt2st.PL'     => 'data/shaltout.db',
				'data/cl2st.PL'        => 'data/cl.db',
				'data/elam2st.PL'      => 'data/elam.db',
				'data/hubbell_g2st.PL' => 'data/hubbell_g.db',

			       },
	 db_files          => {
			       'data/chantler.db'  => 'lib/Xray/Absorption/chantler.db',
			       'data/cl.db'        => 'lib/Xray/Absorption/cl.db',
			       'data/elam.db'      => 'lib/Xray/Absorption/elam.db',
			       'data/henke.db'     => 'lib/Xray/Absorption/henke.db',
			       'data/hubbell_g.db' => 'lib/Xray/Absorption/hubbell_g.db',
			       'data/mcmaster.db'  => 'lib/Xray/Absorption/mcmaster.db',
			       'data/shaltout.db'  => 'lib/Xray/Absorption/shaltout.db',
			      },
	 recommends         => {},
	 sign               => 0,
	);
$build->add_build_element('db');
$build->create_build_script;

