/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.metadata.scope.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.CommonLevelsUtil;
import org.jboss.metadata.spi.scope.ScopeLevel;
import org.jboss.test.metadata.AbstractMetaDataTest;

/**
 * CommonLevelsUnitTestCase.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 * @version $Revision: 71546 $
 */
public class CommonLevelsUnitTestCase extends AbstractMetaDataTest
{
   private ScopeLevel[] commonLevels = new ScopeLevel[]
   {
      CommonLevels.DOMAIN,
      CommonLevels.CLUSTER,
      CommonLevels.MACHINE,
      CommonLevels.NODE,
      CommonLevels.JVM,
      CommonLevels.SERVER,
      CommonLevels.SUBSYSTEM,
      CommonLevels.APPLICATION,
      CommonLevels.DEPLOYMENT,
      CommonLevels.CLASS,
      CommonLevels.INSTANCE,
      CommonLevels.JOINPOINT,
      CommonLevels.JOINPOINT_OVERRIDE,
      CommonLevels.THREAD,
      CommonLevels.WORK,
      CommonLevels.REQUEST,
   };

   public CommonLevelsUnitTestCase(String name)
   {
      super(name);
   }

   public void testCommonLevels() throws Exception
   {
      int lastLevel = 0;
      String lastName = "";
      for (ScopeLevel level : commonLevels)
      {
         assertTrue(level.getLevel() - lastLevel == 100);
         assertFalse(lastName.equals(level.getName()));
         
         lastLevel = level.getLevel();
         lastName = level.getName();
      }
      
      TreeSet<ScopeLevel> set = new TreeSet<ScopeLevel>();
      for (ScopeLevel level : commonLevels)
         set.add(level);
      
      assertTrue(commonLevels.length == set.size());
      int index = 0;
      for (ScopeLevel level : set)
         assertTrue(commonLevels[index++] == level);
   }

   public void testLevelsUtils() throws Exception
   {
      List<ScopeLevel> levels = Arrays.asList(commonLevels);

      assertEquals(levels, CommonLevelsUtil.getSubLevels(CommonLevels.DOMAIN));
      assertEmpty(CommonLevelsUtil.getExclusiveSubLevels(CommonLevels.REQUEST));
      assertEquals(CommonLevelsUtil.getExclusiveSubLevels(CommonLevels.WORK), Collections.singletonList(CommonLevels.REQUEST));

      List<ScopeLevel> instanceLevels = Arrays.asList(
            CommonLevels.INSTANCE,
            CommonLevels.JOINPOINT,
            CommonLevels.JOINPOINT_OVERRIDE,
            CommonLevels.THREAD,
            CommonLevels.WORK,
            CommonLevels.REQUEST
            );
      assertEquals(instanceLevels, CommonLevelsUtil.getSubLevels(CommonLevels.INSTANCE));

      List<ScopeLevel> subInstanceLevels = Arrays.asList(
            CommonLevels.JOINPOINT,
            CommonLevels.JOINPOINT_OVERRIDE,
            CommonLevels.THREAD,
            CommonLevels.WORK,
            CommonLevels.REQUEST
            );
      assertEquals(subInstanceLevels, CommonLevelsUtil.getExclusiveSubLevels(CommonLevels.INSTANCE));

      try
      {
         CommonLevelsUtil.getSubLevels(new ScopeLevel(7, "foobar"));
         fail("Should not be here");
      }
      catch (Exception e)
      {
         assertInstanceOf(e, IllegalArgumentException.class);
      }

      try
      {
         CommonLevelsUtil.getExclusiveSubLevels(new ScopeLevel(7, "foobar"));
         fail("Should not be here");
      }
      catch (Exception e)
      {
         assertInstanceOf(e, IllegalArgumentException.class);
      }
   }
}
