//==============================================================================
//  Lynkeos
//  $Id: main.m,v 1.5 2005/01/23 23:56:01 j-etienne Exp $
//  Created by Jean-Etienne LAMIAUD on Sat Oct 04 2003.
//------------------------------------------------------------------------------
//  Copyright (c) 2003-2004. Jean-Etienne LAMIAUD
//------------------------------------------------------------------------------
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------

// Special comments for Doxygen

/// \mainpage
/// \section Application structure
///    This application is structured around the NSDocument class
///
///    The classes are organized according to the model-view-controller
///    architecture (see module page). The \ref Controlers "controler" classes
///    use \ref Processing "processing" classes wich are grouped in another 
///    module.

/// \defgroup Controlers Controler classes
///
/// The controler classes manage the interactions between the view classes and 
/// the model classes

/// \defgroup Processing  Processing classes
///
/// The processing classes provides image processing functions to the controler
/// classes

/// \defgroup Models Model classes
///
/// The model classes represent data manipulated by the application

#include "processing_core.h"

#ifdef GNUSTEP
#else
#import <Cocoa/Cocoa.h>
#endif

int main(int argc, const char *argv[])
{
  ffmpegInit();
  initializeProcessing();

  return NSApplicationMain(argc, argv);
}
