local l = require "luxio"

local fd, r, errno

fd, errno = l.open("test-lock-file", l.bit.bor(l.O_CREAT, l.O_RDWR), tonumber("600", 8))
print("open: fd,errno:", fd, errno)
assert(fd >= 0)

t = {
   l_type = l.F_WRLCK,
   l_whence = l.SEEK_SET,
   l_start = 0,
   l_len = 4096
}

r, errno = l.fcntl(fd, l.F_SETLK, t)
print("fnctl: r,errno:", r, errno)
print("sleeping 10 seconds")
l.sleep(10)

l.unlink "test-lock-file"
