#!/bin/sh
#
# This script is copyright 2001 by A.L.Lambert.  It is distributed under the
# GNU public license.  If you don't know what this means, I suggest you point
# a web browser at www.gnu.org and find out.
#
# Usage: I use this script to monitor my logfiles on a regular basis, and e-mail
# me when events I've not previously defined as "OK" happen.  I am not going to 
# hold your hand too far in this, as I expect you to be able to code simple
# shell script and know a bit about what you're doing before you get here. :)
#
# YOU MUST CREATE /etc/lt_watch/logtool.conf BEFORE YOU RUN THIS SCRIPT!!!!!!
# The easiest way to do this is cp -rapfvd /etc/logtool /etc/lt_watch/
#
# SEASON THIS CONFIGURATION INFO TO SUIT YOUR SYSTEM BEFORE USING THIS SCRIPT!
logfiles="/var/log/maillog /var/log/messages /var/log/secure"
mailto="me@mydomain.ext someoneelse@someotherdomain.ext"
pagemail="mypager@mypagercompany.net"

# the code for these will most likely need to be edited for non-Linux systems
# If you don't know how to do such editing below, SET THESE ALL TO "NO"!!!!
tcpstats="yes"
logusers="yes"
lastlog="yes"
proclist="yes"

# we need a tempfile name
# see if we've got mktmp, and if we do, use it.
if [ -x `which mktemp` ] ; then
tnpfile=`mktemp -q /tmp/$0.XXXXXX`
	if [ $? -ne 0 ]; then
		# oops; we got it, but it's not working right; complain to user about it
		echo "$0: Can't create temp file, exiting..."
                exit 1
	fi
else 
# NOT INCREDIBLY SECURE!!! DO SOMETHING BETTER IF YOU WANT
tmpfile=/tmp/$$.$RANDOM.$$.logtool.check
fi


# touch the run file
touch /var/run/logtool.check

# for each logfile, see if there's anything new to report
for i in $logfiles ; do
retail $i | logtool -c /etc/logwatch/logtool.conf >> $tmpfile
done

# if we found anything, load it into a memory variable
found="`head $tmpfile`"

# if there wasn't nothing found, then we can bail out
if [ "$found" = "" ] ; then
rm -f $tmpfile /var/run/logtool.check
exit 0
else

# Houston, we might possibly have a problem... Let's e-mail someone about it, shall we?

# if the user wants TCP stats with their report
if [ "$tcpstats" = "yes" ; then
echo "
-----------------------------------------------------------------------------
Current TCP/IP status" >> $tmpfile
netstat -nap >> $tmpfile
fi

# if they want to know who's currently logged on and doing what
if [ "$logusers" = "yes" ] ; then
echo "
-----------------------------------------------------------------------------
Currently logged in users: " >> $tmpfile
w >> $tmpfile
fi

# if they want to know who's the last users logged on
if [ "$lastlog" = "yes" ] ; then
echo "
-----------------------------------------------------------------------------
Current last log: " >> $tmpfile
last >> $tmpfile
fi

# if they want to know the current proclist
if [ "$proclist" = "yes" ] ; then
echo "
-----------------------------------------------------------------------------
Current process list: " >> $tmpfile
ps auxfwwwwww >> $tmpfile
fi

# pump that tmpfile into the mail post-haste.
cat $tmpfile | mail -s "Logwatch report `date`" $mailto
rm -f $tmpfile /var/run/logtool.check

# and a quick pager message to make sure he knows to check...
if [ "$pagemail" -ne "" ] ; then
echo "Check your regular e-mail for unusual log activity" | mail -s "Log Activity" $pagemail
fi

fi # if found != "" end FI

exit 0

