program intrinsics_204
      use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
      real(dp) :: x(40)
      real(dp) :: expected(40)
      real(dp) :: expected_res(32)
      integer :: i
  
      real :: y(28)
      real :: expected_y(28)
  
      real(dp), parameter :: res(32) = bessel_y1([9.98600559790084e307_dp,9.98800479820072e307_dp,9.9900039985006e307_dp, &
      9.99200319880048e307_dp, 1036.462826483388272_dp, 1.7197292882018389_dp, & 
      10.2368267382872828_dp, 0.17197292882018389_dp, 152.67283628_dp, &
      632.92729728_dp, 1.2728272919_dp, 1.265228272919_dp, &
      29.82407037185126_dp, 35.2459016393_dp, 46.2634946_dp, 24.7740903638_dp, &
      15.8978408636372_dp, 8.801468212714914_dp, 8.798080767692923_dp, 8.791287884846061575_dp, &
      0.6635324560331525_dp, 0.6633115808685429_dp, 0.6630906573122884_dp, 0.6628696853957159_dp, &
      0.5042349934053336_dp, 0.5041796815747646_dp, 0.5041242821300232_dp, 0.50401322049655_dp, &
      499.19032387045183_dp, 499.2802878848461_dp, 499.3702518992403_dp, 499.5501799280288_dp])
  
      expected_res = [-1.1242697836494346E-156_dp, -3.6987410577069675E-155_dp, 6.6185432736853698E-155_dp, &
                  -7.9441122443324676E-155_dp, & 
            -1.2379145453411093E-002_dp, -0.27253834632671181_dp, 0.24932183511315256_dp, -3.8313116038851942_dp, &
            -2.9667345859170198E-002_dp, 2.4613344707389746E-002_dp, -0.56789241609783492_dp, -0.57335504482194688_dp, &
            0.10420535567671903_dp, 0.13391492370821437_dp, -7.8417916615948820E-003_dp, -6.8571787853437760E-002_dp, &
            0.16838460392882040_dp, 5.4736765729333475E-002_dp, 5.3856989331157942E-002_dp, 5.2089913683587979E-002_dp, &
            -1.1559813724346837_dp, -1.1563150553800137_dp, -1.1566489944373206_dp, -1.1569831898838661_dp, &
            -1.4609752198895190_dp, -1.4611112512331177_dp, -1.4612475261578066_dp, -1.4615208070815726_dp, &
            1.5957661062982142E-002_dp, 1.8761706846965608E-002_dp, 2.1413515766267922E-002_dp, 2.6176157352140857E-002_dp]
        
        do i = 1, size(res)
              print *, res(i)
              if (abs(res(i) - expected_res(i)) > 1e-5_dp) error stop
        end do
  
      x = [9.98600559790084e307_dp,9.98800479820072e307_dp,9.9900039985006e307_dp,9.99200319880048e307_dp, &
            1036.462826483388272_dp, 1.7197292882018389_dp, 10.2368267382872828_dp, 0.17197292882018389_dp, &
            152.67283628_dp, 632.92729728_dp, 1.2728272919_dp, 1.265228272919_dp, &
            3.229995504589554d-153, 1.9201212555874555d-153, 6.809537363878625d-155, 5.690181373063991d-154, &
            29.82407037185126_dp, 35.2459016393_dp, 46.2634946_dp, 24.7740903638_dp, &
            15.8978408636372_dp, 8.801468212714914_dp, 8.798080767692923_dp, 8.791287884846061575_dp, &
            0.6635324560331525_dp, 0.6633115808685429_dp, 0.6630906573122884_dp, 0.6628696853957159_dp, &
            0.5042349934053336_dp, 0.5041796815747646_dp, 0.5041242821300232_dp, 0.50401322049655_dp, &
            1.3994502099160337d-303, 1.199530179928029d-303, 9.99610149940024d-304, 5.9977008996401444d-304, &
            499.19032387045183_dp, 499.2802878848461_dp, 499.3702518992403_dp, 499.5501799280288_dp]
  
      expected = [-1.1242697836494346E-156_dp, -3.6987410577069675E-155_dp, 6.6185432736853698E-155_dp, &
            -7.9441122443324676E-155_dp, & 
            -1.2379145453411093E-002_dp, -0.27253834632671181_dp, 0.24932183511315256_dp, -3.8313116038851942_dp, &
            -2.9667345859170198E-002_dp, 2.4613344707389746E-002_dp, -0.56789241609783492_dp, -0.57335504482194688_dp, &
            -1.9709617906990824E+152_dp, -3.3155185929797410E+152_dp, -9.3489430830433235E+153_dp, -1.1188040075158112E+153_dp, &
            0.10420535567671903_dp, 0.13391492370821437_dp, -7.8417916615948820E-003_dp, -6.8571787853437760E-002_dp, &
            0.16838460392882040_dp, 5.4736765729333475E-002_dp, 5.3856989331157942E-002_dp, 5.2089913683587979E-002_dp, &
            -1.1559813724346837_dp, -1.1563150553800137_dp, -1.1566489944373206_dp, -1.1569831898838661_dp, &
            -1.4609752198895190_dp, -1.4611112512331177_dp, -1.4612475261578066_dp, -1.4615208070815726_dp, &
            -4.5490705411075559E+302_dp, -5.3072426439973200E+302_dp, -6.3686805541718252E+302_dp, -1.0614396800043461E+303_dp, &
            1.5957661062982142E-002_dp, 1.8761706846965608E-002_dp, 2.1413515766267922E-002_dp, 2.6176157352140857E-002_dp]
  
  
      do i = 1, size(x)
          print *, bessel_y1(x(i)), "i = ", i
          if (abs(bessel_y1(x(i)) - expected(i)) > 1e-12_dp) error stop
      end do
  
  
      y = [1036.462826483388272_sp, 1.7197292882018389_sp, 10.2368267382872828_sp, 0.17197292882018389_sp, &
            152.67283628_sp, 632.92729728_sp, 1.2728272919_sp, 1.2828272919_sp, &
            29.82407037185126_sp, 35.2459016393_sp, 46.2634946_sp, 24.7740903638_sp, &
            15.8978408636372_sp, 8.801468212714914_sp, 8.798080767692923_sp, 8.791287884846061575_sp, &
            0.6635324560331525_sp, 0.6633115808685429_sp, 0.6630906573122884_sp, 0.6628696853957159_sp, &
            0.5042349934053336_sp, 0.5041796815747646_sp, 0.5041242821300232_sp, 0.50401322049655_sp, &
            499.19032387045183_sp, 499.2802878848461_sp, 499.3702518992403_sp, 499.5501799280288_sp]
  
      expected_y = [-1.23779038E-02_sp, -0.272538334_sp, 0.249321833_sp, -3.83131123_sp, &
            -2.96673458E-02_sp, 2.46131476E-02_sp, -0.567892432_sp, -0.560734272_sp, &
            0.104205415_sp, 0.133914948_sp, -7.84158148E-03_sp, -6.85717091E-02_sp, &
            0.168384567_sp, 5.47366850E-02_sp, 5.38569130E-02_sp, 5.20897955E-02_sp, &
            -1.15598142_sp, -1.15631497_sp, -1.15664887_sp, -1.15698314_sp, &
            -1.46097517_sp, -1.46111119_sp, -1.46124744_sp, -1.46152067_sp, &
            1.59581173E-02_sp, 1.87612697E-02_sp, 2.14131586E-02_sp, 2.61759404E-02_sp ]
  
      do i = 1, size(y)
          print *, bessel_y1(y(i)), "i = ", i
          if (abs(bessel_y1(y(i)) - expected_y(i)) > 1e-6) error stop
      end do
  end program
  