#include "dns_charstring.h"

using namespace System::Text;

namespace ADNS {

	DNS_CHARSTRING::DNS_CHARSTRING()
	{
		charstr= gcnew array<Byte>(1);
		charstr[0] = 0;
	}

	DNS_CHARSTRING::DNS_CHARSTRING(String^ s)
	{
		ASCIIEncoding^ ae = gcnew ASCIIEncoding();
		array<Byte>^ tmp;

		if (s)
		{
			tmp = ae->GetBytes(s);
			if (tmp->Length > 255)
				return;

			charstr = gcnew array<Byte>(tmp->Length + 1);
			charstr[0] = (Byte)tmp->Length;
			tmp->CopyTo(charstr,1);
		}
	}

	array<Byte>^ DNS_CHARSTRING::GetCharacterString()
	{
		array<Byte>^ output = gcnew array<Byte>(charstr->Length);
		charstr->CopyTo(output,0);

		return output;
	}

	Void DNS_CHARSTRING::SetCharacterString(array<Byte>^ cs)
	{
		if (!cs)
			return;

		if (!charstr)
			charstr = gcnew array<Byte>(cs->Length);
		else
			charstr->Resize(charstr,cs->Length);

		cs->CopyTo(charstr,0);

		return;
	}

	String^ DNS_CHARSTRING::Print()
	{
		ASCIIEncoding^ ae = gcnew ASCIIEncoding();
		return ae->GetString(charstr,1,charstr->Length - 1);
	}

	DNS_CHARSTRING^ DNS_CHARSTRING::Clone()
	{
		DNS_CHARSTRING^ output = gcnew DNS_CHARSTRING();

		output->SetCharacterString(GetCharacterString());

		return output;
	}

	Void DNS_CHARSTRING::SetCharacterString(String^ s)
	{
		ASCIIEncoding^ ae = gcnew ASCIIEncoding();
		array<Byte>^ tmp;

		if (s)
		{
			tmp = ae->GetBytes(s);
			if (tmp->Length > 255)
				return;

			charstr = gcnew array<Byte>(tmp->Length + 1);
			charstr[0] = (Byte)tmp->Length;
			tmp->CopyTo(charstr,1);
		}
	}

	UInt32 DNS_CHARSTRING::Size()
	{
		return charstr->Length;
	}



}