package latexDraw.ui.dialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.*;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

import latexDraw.lang.LaTeXDrawLang;
import latexDraw.util.LaTeXDrawResources;


/** 
 * This class defines a frame containing the shortcuts of the program.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 09/18/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 * @since 1.9<br>
 */
public class ShortcutsFrame extends JFrame
{
	private static final long serialVersionUID = 1L;

	
	/**
	 * The constructor creates a frame containing a table with all the shortcuts.
	 */
	public ShortcutsFrame()
	{
		super(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.3")); //$NON-NLS-1$

		setIconImage(LaTeXDrawResources.latexdrawIcon.getImage());
		
		JTable table;
		final String[] titles = {LaTeXDrawLang.getString1_9("ShortcutsFrame.1"),  //$NON-NLS-1$
				LaTeXDrawLang.getString1_6("ParserMessagesFrame.0"),  //$NON-NLS-1$
				LaTeXDrawLang.getString1_9("ShortcutsFrame.3")};  //$NON-NLS-1$
		String catEdit	= LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.89"); //$NON-NLS-1$
		String catNav	= LaTeXDrawLang.getString1_9("ShortcutsFrame.4"); //$NON-NLS-1$
		String catTran	= LaTeXDrawLang.getString1_9("ShortcutsFrame.5"); //$NON-NLS-1$
		String catDraw	= LaTeXDrawLang.getString1_9("ShortcutsFrame.6"); //$NON-NLS-1$
		String catFile	= LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.88"); //$NON-NLS-1$
		String cathelp	= LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.93"); //$NON-NLS-1$
		String move = LaTeXDrawLang.getString1_9("ShortcutsFrame.7"); //$NON-NLS-1$
		JButton okB 	= new JButton(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.23")); //$NON-NLS-1$
		JPanel panel 	= new JPanel();
		Dimension dim 	= Toolkit.getDefaultToolkit().getScreenSize();
		
		String ctrl = KeyEvent.getKeyModifiersText(InputEvent.CTRL_MASK);
		String shift = KeyEvent.getKeyModifiersText(InputEvent.SHIFT_MASK);
		String leftClick = LaTeXDrawLang.getString1_9("ShortcutsFrame.8"); //$NON-NLS-1$
		final String st1 = LaTeXDrawLang.getString1_9("ShortcutsFrame.9"); //$NON-NLS-1$
		final String st2 = LaTeXDrawLang.getString1_9("ShortcutsFrame.10"); //$NON-NLS-1$
		final String st3 = LaTeXDrawLang.getString1_9("ShortcutsFrame.11"); //$NON-NLS-1$
		final String st4 = LaTeXDrawLang.getString1_9("ShortcutsFrame.12"); //$NON-NLS-1$
		final Object[][] data = 
		{
			{ctrl+"+C", LaTeXDrawResources.LABEL_COPY, catEdit},//$NON-NLS-1$
			{ctrl+"+V", LaTeXDrawResources.LABEL_PASTE, catEdit},//$NON-NLS-1$
			{ctrl+"+X", LaTeXDrawResources.LABEL_CUT, catEdit},//$NON-NLS-1$
			{ctrl+"+Z", LaTeXDrawResources.LABEL_UNDO, catEdit},//$NON-NLS-1$
			{ctrl+"+Y", LaTeXDrawResources.LABEL_REDO, catEdit},//$NON-NLS-1$
			{ctrl+"+N", LaTeXDrawResources.LABEL_NEW, catFile},//$NON-NLS-1$
			{ctrl+"+O", LaTeXDrawResources.LABEL_OPEN, catFile},//$NON-NLS-1$
			{ctrl+"+S", LaTeXDrawResources.LABEL_SAVE, catFile},//$NON-NLS-1$
			{ctrl+"+E", LaTeXDrawResources.LABEL_PRINT_CODE, catFile},//$NON-NLS-1$
			{ctrl+"+D", LaTeXDrawResources.LABEL_PRINT_DRAW, catFile},//$NON-NLS-1$
			{ctrl+"+W", LaTeXDrawResources.LABEL_QUIT, catFile},//$NON-NLS-1$
			{KeyEvent.getKeyText(KeyEvent.VK_F9), LaTeXDrawResources.LABEL_ZOOM_DEFAULT, catNav},
			{KeyEvent.getKeyText(KeyEvent.VK_ADD), LaTeXDrawResources.LABEL_ZOOM_IN, catNav},
			{KeyEvent.getKeyText(KeyEvent.VK_SUBTRACT), LaTeXDrawResources.LABEL_ZOOM_OUT, catNav},
			{'L', LaTeXDrawResources.LABEL_LINE, catDraw},
			{'J', LaTeXDrawResources.LABEL_JOINED_LINES, catDraw},
			{'P', LaTeXDrawResources.LABEL_POLY, catDraw},
			{'D', LaTeXDrawResources.LABEL_DOT, catDraw},
			{'R', LaTeXDrawResources.LABEL_RECT, catDraw},
			{'S', LaTeXDrawResources.LABEL_SQUARE, catDraw},
			{'H', LaTeXDrawResources.LABEL_RHOMBUS, catDraw},
			{'T', LaTeXDrawResources.LABEL_TRIANGLE, catDraw},
			{'E', LaTeXDrawResources.LABEL_ELLIPSE, catDraw},
			{'C', LaTeXDrawResources.LABEL_CIRCLE, catDraw},
			{'A', LaTeXDrawResources.LABEL_ARC,	catDraw},
			{'W', LaTeXDrawResources.LABEL_WEDGE, catDraw},
			{'O', LaTeXDrawResources.LABEL_CHORD, catDraw},
			{'B', LaTeXDrawResources.LABEL_BEZIER_CURVE, catDraw},
			{'G', LaTeXDrawResources.LABEL_GRID, catDraw},
			{'Z', LaTeXDrawResources.LABEL_AXES, catDraw},
			{'K', LaTeXDrawResources.LABEL_POINTS_AKIN, catDraw},
			{'X', LaTeXDrawResources.LABEL_TEXT, catDraw},
			{'F', LaTeXDrawResources.LABEL_SELECT_FIGURE, catDraw},
			{KeyEvent.getKeyText(KeyEvent.VK_DELETE), LaTeXDrawResources.LABEL_DELETE, catDraw},
			{KeyEvent.getKeyText(KeyEvent.VK_F1), LaTeXDrawResources.LABEL_HELP, cathelp},
			{KeyEvent.getKeyText(KeyEvent.VK_F2), LaTeXDrawLang.getString1_9("LaTeXDrawFrame.3"), cathelp}, //$NON-NLS-1$
			{KeyEvent.getKeyText(KeyEvent.VK_RIGHT), st1, catNav},
			{KeyEvent.getKeyText(KeyEvent.VK_LEFT), st2, catNav},
			{KeyEvent.getKeyText(KeyEvent.VK_UP), st3, catNav},
			{KeyEvent.getKeyText(KeyEvent.VK_DOWN), st4, catNav},
			{ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_RIGHT), st1+move, catNav},
			{ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_LEFT), st2+move, catNav},
			{ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_UP), st3+move, catNav},
			{ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_DOWN), st4+move, catNav},
			{shift+'+'+ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_RIGHT), LaTeXDrawLang.getString1_9("ShortcutsFrame.14"), catNav}, //$NON-NLS-1$
			{shift+'+'+ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_LEFT), LaTeXDrawLang.getString1_9("ShortcutsFrame.15"), catNav}, //$NON-NLS-1$
			{shift+'+'+ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_UP), LaTeXDrawLang.getString1_9("ShortcutsFrame.16"), catNav}, //$NON-NLS-1$
			{shift+'+'+ctrl+'+'+KeyEvent.getKeyText(KeyEvent.VK_DOWN), LaTeXDrawLang.getString1_9("ShortcutsFrame.17"), catNav}, //$NON-NLS-1$
			{shift+'+'+KeyEvent.getKeyText(KeyEvent.VK_RIGHT), LaTeXDrawLang.getString1_9("ShortcutsFrame.18"), catNav}, //$NON-NLS-1$
			{shift+'+'+KeyEvent.getKeyText(KeyEvent.VK_LEFT), LaTeXDrawLang.getString1_9("ShortcutsFrame.19"), catNav}, //$NON-NLS-1$
			{shift+'+'+KeyEvent.getKeyText(KeyEvent.VK_UP), LaTeXDrawLang.getString1_9("ShortcutsFrame.20"), catNav}, //$NON-NLS-1$
			{shift+'+'+KeyEvent.getKeyText(KeyEvent.VK_DOWN), LaTeXDrawLang.getString1_9("ShortcutsFrame.21"), catNav}, //$NON-NLS-1$
			{ctrl+"+U", LaTeXDrawLang.getString1_9("ShortcutsFrame.23"), catTran}, //$NON-NLS-1$ //$NON-NLS-2$
			{ctrl+"+A", LaTeXDrawLang.getString1_9("ShortcutsFrame.25"), catDraw}, //$NON-NLS-1$ //$NON-NLS-2$
			{ctrl+'+'+leftClick, LaTeXDrawLang.getString1_9("ShortcutsFrame.26"), catDraw}, //$NON-NLS-1$
			{shift+'+'+leftClick, LaTeXDrawLang.getString1_9("ShortcutsFrame.27"), catDraw}, //$NON-NLS-1$
			{KeyEvent.getKeyText(KeyEvent.VK_SPACE), 
				LaTeXDrawLang.getString1_9("ShortcutsFrame.28"), catDraw}, //$NON-NLS-1$
			{ctrl+'+'+LaTeXDrawLang.getString1_9("ShortcutsFrame.29"), LaTeXDrawLang.getString1_9("ShortcutsFrame.30"), catDraw} //$NON-NLS-1$ //$NON-NLS-2$
		};
		
        TableModel dataModel = new AbstractTableModel() 
        { 
			private static final long serialVersionUID = 1L;
			public int getColumnCount() { return titles.length; } 
            public int getRowCount() { return data.length;} 
            public Object getValueAt(int row, int col) {return data[row][col];} 
            
            @Override
			public String getColumnName(int column) {return titles[column];} 
            
            @Override
			public Class<? extends Object> getColumnClass(int c) {return getValueAt(0, c).getClass();} 
            
		    @Override
			public boolean isCellEditable(int row, int col) {return false;} 
		    
            @Override
			public void setValueAt(Object aValue, int row, int column) { data[row][column] = aValue; } 
         }; 
         
		table = new JTable(dataModel);
 		table.getTableHeader().setReorderingAllowed(false);
 		TableColumnModel colmodel = table.getColumnModel();

 		colmodel.getColumn(0).setPreferredWidth(30);
 		colmodel.getColumn(1).setPreferredWidth(200);
 		colmodel.getColumn(2).setPreferredWidth(40);
 		
 		JScrollPane scrollPane = new JScrollPane();
 		JViewport vp = scrollPane.getViewport(); 
	 	vp.add(table); 
	 	
		okB.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				setVisible(false);
			}
		});
		panel.add(okB);
		
		getContentPane().setLayout(new BorderLayout());
 		getContentPane().add(scrollPane, BorderLayout.CENTER);
 		getContentPane().add(panel, BorderLayout.SOUTH);
 		setSize(550, 500);
 		setLocation((dim.width-getWidth())/2, (dim.height-getHeight())/2);
	}
}
