/*
 * LaTeXDrawToolbar.java
 */
package latexDraw.ui.components;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.*;

import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.CodePanel;
import latexDraw.ui.DrawContainer;
import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.ui.listeners.MenusListener;
import latexDraw.util.LaTeXDrawResources;

/** 
 * This class defines a the toolbar of the program.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 
 * 09/22/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 * @since 2.0.0<br>
 */
public class LToolbar extends JToolBar
{
	private static final long	serialVersionUID	= 1L;

	protected JSpinner zoomField;
    protected JSpinner persoGridGapField;
    protected JCheckBox magneticCB;
    protected JSlider sliderDelimitor;
	/** This button allows to copy the generated code when the code panel is closed. */
    protected JButton copyCodeButton;
    protected JButton copyCodeSelButton;
    protected JToggleButton buttonImageLine;
	protected JToggleButton buttonImageDot;
	protected JToggleButton buttonImageRect;
	protected JToggleButton buttonImageSquare;
	protected JToggleButton buttonImageRhombus;
	protected JToggleButton buttonImageTriangle;
	protected JToggleButton buttonImageEllipse;
	protected JToggleButton buttonImageCircle;
	protected JToggleButton buttonImageSelect;
	protected JToggleButton buttonImageBorders;
	protected JToggleButton buttonImageWedge;
	protected JToggleButton buttonImageChord;
	protected JToggleButton buttonImageArc;
	protected JToggleButton buttonImagePoly;
	protected JToggleButton buttonImageText;
	protected JToggleButton buttonImagePointsAkin;
	protected JToggleButton buttonImageGrid;
	protected JToggleButton buttonImageAxes;
	protected JToggleButton buttonImageBezierCurve; 
	protected JToggleButton buttonImageClosedBezierCurve; 
	protected JToggleButton buttonImageJoinedLines; 
	protected JButton buttonImageDel;
	protected JButton buttonImageProperties;
	protected JButton buttonImageRedo;
	protected JButton buttonImageUndo;
	protected LaTeXDrawFrame parentFrame;
	protected JButton buttonPdfExport;
	
	
	
	public LToolbar(LaTeXDrawFrame parent)
	{
		super();
		
		if(parent==null)
			throw new IllegalArgumentException();
		
		parentFrame = parent;
		MenusListener ml = parentFrame.getMenuListener();
		
		setName(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.107"));	 //$NON-NLS-1$
		ButtonGroup drawButtonGroup = new ButtonGroup();
		JButton button;
		
		button = new JButton(LaTeXDrawResources.newIcon);		
		button.addActionListener(ml);
		button.setMargin(LaTeXDrawFrame.INSET_BUTTON);
		button.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.108")); //$NON-NLS-1$
		button.setActionCommand(LaTeXDrawResources.LABEL_NEW);
 		add(button);
 		
 		button = new JButton(LaTeXDrawResources.openIcon);		
 		button.addActionListener(ml);
		button.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		button.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.109")); //$NON-NLS-1$
 		button.setActionCommand(LaTeXDrawResources.LABEL_OPEN);
 		add(button);
 		
 		button = new JButton(LaTeXDrawResources.saveIcon);		
 		button.addActionListener(ml);
		button.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		button.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.110")); //$NON-NLS-1$
 		button.setActionCommand(LaTeXDrawResources.LABEL_SAVE);
 		add(button);
 		
 		buttonPdfExport = new JButton(LaTeXDrawResources.pdfIcon);		
 		buttonPdfExport.addActionListener(ml);
 		buttonPdfExport.setEnabled(false);
 		buttonPdfExport.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonPdfExport.setToolTipText("Export the drawing as a pdf document (the drawing is compiled using your latex distribution)");
 		buttonPdfExport.setActionCommand(LaTeXDrawResources.LABEL_EXPORT_PDF_LATEX);
 		add(buttonPdfExport);

 		addSeparator();
 		
 		SpinnerNumberModel model = new SpinnerNumberModel(DrawContainer.DEFAULT_ZOOM*100, DrawContainer.MIN_ZOOM*100, 
 										DrawContainer.MAX_ZOOM*100,DrawContainer.DEFAULT_ADD_ZOOM*100);
 		zoomField = new JSpinner(model);
 		zoomField.setMaximumSize(new Dimension(50, 28));
 		zoomField.setToolTipText(LaTeXDrawLang.getString1_9("ShortcutsFrame.30"));
 		zoomField.setName(LaTeXDrawResources.LABEL_ZOOM_CHANGE);
 		zoomField.addChangeListener(parentFrame);
 		
 		add(zoomField);
 		
 		button = new JButton(LaTeXDrawResources.zoomDefaultIcon);
 		button.addActionListener(ml);
		button.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		button.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.113")); //$NON-NLS-1$
 		button.setActionCommand(LaTeXDrawResources.LABEL_ZOOM_DEFAULT);
 		add(button);

 		addSeparator();
 		
 		ListJToggleButton listGrid = new ListJToggleButton(parentFrame, LaTeXDrawResources.displayGridIcon, ListJToggleButton.LOCATION_SOUTH);
 		listGrid.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.12")); //$NON-NLS-1$
 		
 		magneticCB = new JCheckBox(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.13")); //$NON-NLS-1$
 		magneticCB.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		magneticCB.setActionCommand(LaTeXDrawResources.LABEL_MAGNETIC_CB);
 		magneticCB.addActionListener(parentFrame);
 		magneticCB.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.14")); //$NON-NLS-1$
 		listGrid.addComponent(magneticCB);
 		listGrid.addSeparator();
 		
 		JLabel label = new JLabel(LaTeXDrawResources.loadImageIcon("/res/gridGap.png"));//$NON-NLS-1$
 		listGrid.addComponent(label);
 		
     	model = new SpinnerNumberModel(MagneticGrid.DEFAULT_PERSONAL_GRID_GAP, 2, 100000, 1);
     	persoGridGapField = new JSpinner(model);
     	persoGridGapField.setEditor(new JSpinner.NumberEditor(persoGridGapField, "0"));//$NON-NLS-1$
     	persoGridGapField.addChangeListener(parentFrame);
     	persoGridGapField.setName(LaTeXDrawResources.LABEL_PERSO_GRID_GAP_FIELD);
     	persoGridGapField.setPreferredSize(new Dimension(45,25));
     	persoGridGapField.setMaximumSize(new Dimension(45,25));
     	persoGridGapField.addChangeListener(parentFrame);
     	persoGridGapField.setEnabled(false);
     	persoGridGapField.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.15")); //$NON-NLS-1$
     	listGrid.addComponent(persoGridGapField);
     	listGrid.addSeparator();

 		add(listGrid);
 		
 		ListJToggleButton listDelimitor = new ListJToggleButton(parentFrame, LaTeXDrawResources.delimitorIcon, ListJToggleButton.LOCATION_SOUTH);
 		listDelimitor.setToolTipText(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.8"));  //$NON-NLS-1$
 		JPanel panelSliderDel = new JPanel();
 		JLabel sliderLabel = new JLabel(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.9"), SwingConstants.CENTER); //$NON-NLS-1$
 		panelSliderDel.setLayout(new BoxLayout(panelSliderDel, BoxLayout.PAGE_AXIS));
 		panelSliderDel.add(sliderLabel);
        sliderLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
 		sliderDelimitor = new JSlider(0, 255);
 		sliderDelimitor.setToolTipText(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.10")); //$NON-NLS-1$
 		sliderDelimitor.setName(LaTeXDrawResources.NAME_SLIDER_DELIMITOR);
 		sliderDelimitor.setMajorTickSpacing(50);
 		sliderDelimitor.setPaintTicks(true);
 		sliderDelimitor.setPaintLabels(true); 
 		sliderDelimitor.addChangeListener(parentFrame);
 		panelSliderDel.add(sliderDelimitor);
 		listDelimitor.addComponent(panelSliderDel);
 		listDelimitor.addSeparator();
 		
 		add(listDelimitor);
 		addSeparator();
 		
 		buttonImageUndo = new JButton(LaTeXDrawResources.undoIcon);
 		buttonImageUndo.addActionListener(ml);
 		buttonImageUndo.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageUndo.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.114")); //$NON-NLS-1$
 		buttonImageUndo.setActionCommand(LaTeXDrawResources.LABEL_UNDO);
 		add(buttonImageUndo);
 		
 		buttonImageRedo = new JButton(LaTeXDrawResources.redoIcon);
 		buttonImageRedo.addActionListener(ml);
 		buttonImageRedo.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageRedo.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.115")); //$NON-NLS-1$
 		buttonImageRedo.setActionCommand(LaTeXDrawResources.LABEL_REDO);
 		add(buttonImageRedo);
 		
 		addSeparator();
 		
 		ListJToggleButton ltb = new ListJToggleButton(parentFrame, LaTeXDrawResources.lineIcon, ListJToggleButton.LOCATION_SOUTH);
 		ltb.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.116"));  //$NON-NLS-1$
 		add(ltb);
 		
 		buttonImageLine = new JToggleButton(LaTeXDrawResources.lineIcon);
 		buttonImageLine.addActionListener(ml);
 		buttonImageLine.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageLine.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.116")); //$NON-NLS-1$
 		buttonImageLine.setActionCommand(LaTeXDrawResources.LABEL_LINE);
 		drawButtonGroup.add(buttonImageLine);
 		ltb.addComponent(buttonImageLine);
 	
 		buttonImageJoinedLines = new JToggleButton(LaTeXDrawResources.joinedLinesIcon);
 		buttonImageJoinedLines.addActionListener(ml);
 		buttonImageJoinedLines.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageJoinedLines.setToolTipText(LaTeXDrawLang.getString1_6("LaTeXDrawFrame.14"));  //$NON-NLS-1$
 		buttonImageJoinedLines.setActionCommand(LaTeXDrawResources.LABEL_JOINED_LINES);
 		drawButtonGroup.add(buttonImageJoinedLines);
 		ltb.addComponent(buttonImageJoinedLines);
 		ltb.addSeparator();
 		
 		buttonImageDot = new JToggleButton(LaTeXDrawResources.dotIcon);		
 		buttonImageDot.addActionListener(ml);
 		buttonImageDot.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageDot.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.117")); //$NON-NLS-1$
 		buttonImageDot.setActionCommand(LaTeXDrawResources.LABEL_DOT);
 		drawButtonGroup.add(buttonImageDot);
 		add(buttonImageDot);
				
 		ltb = new ListJToggleButton(parentFrame, LaTeXDrawResources.rectIcon, ListJToggleButton.LOCATION_SOUTH);
 		ltb.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.118")); //$NON-NLS-1$
 		add(ltb);
 		
 		buttonImageRect = new JToggleButton(LaTeXDrawResources.rectIcon);		
 		buttonImageRect.addActionListener(ml);
 		buttonImageRect.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageRect.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.119")); //$NON-NLS-1$
 		buttonImageRect.setActionCommand(LaTeXDrawResources.LABEL_RECT);
 		drawButtonGroup.add(buttonImageRect);
 		ltb.addComponent(buttonImageRect);

 		buttonImageSquare = new JToggleButton(LaTeXDrawResources.squareIcon);		
 		buttonImageSquare.addActionListener(ml);
 		buttonImageSquare.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageSquare.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.120")); //$NON-NLS-1$
 		buttonImageSquare.setActionCommand(LaTeXDrawResources.LABEL_SQUARE);
 		drawButtonGroup.add(buttonImageSquare);
 		ltb.addComponent(buttonImageSquare);
 		ltb.addSeparator();
 		
 		ltb = new ListJToggleButton(parentFrame, LaTeXDrawResources.polygonIcon, ListJToggleButton.LOCATION_SOUTH);
 		ltb.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.121")); //$NON-NLS-1$
 		add(ltb);
 		
 		buttonImagePoly = new JToggleButton(LaTeXDrawResources.polygonIcon);		
 		buttonImagePoly.addActionListener(ml);
 		buttonImagePoly.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImagePoly.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.121")); //$NON-NLS-1$
 		buttonImagePoly.setActionCommand(LaTeXDrawResources.LABEL_POLY);
 		drawButtonGroup.add(buttonImagePoly);
 		ltb.addComponent(buttonImagePoly);
 		
 		buttonImageRhombus = new JToggleButton(LaTeXDrawResources.rhombusIcon);		
 		buttonImageRhombus.addActionListener(ml);
 		buttonImageRhombus.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageRhombus.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.123")); //$NON-NLS-1$
 		buttonImageRhombus.setActionCommand(LaTeXDrawResources.LABEL_RHOMBUS);
 		drawButtonGroup.add(buttonImageRhombus);
 		ltb.addComponent(buttonImageRhombus);
 		
 		buttonImageTriangle = new JToggleButton(LaTeXDrawResources.triangleIcon);		
 		buttonImageTriangle.addActionListener(ml);
 		buttonImageTriangle.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageTriangle.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.124")); //$NON-NLS-1$
 		buttonImageTriangle.setActionCommand(LaTeXDrawResources.LABEL_TRIANGLE);
 		drawButtonGroup.add(buttonImageTriangle);
 		ltb.addComponent(buttonImageTriangle);
 		ltb.addSeparator();
 		
 		ltb = new ListJToggleButton(parentFrame, LaTeXDrawResources.ellipseIcon, ListJToggleButton.LOCATION_SOUTH);
 		ltb.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.125")); //$NON-NLS-1$
 		add(ltb);
 		
 		buttonImageEllipse = new JToggleButton(LaTeXDrawResources.ellipseIcon);		
 		buttonImageEllipse.addActionListener(ml);
 		buttonImageEllipse.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageEllipse.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.125")); //$NON-NLS-1$
 		buttonImageEllipse.setActionCommand(LaTeXDrawResources.LABEL_ELLIPSE);
 		drawButtonGroup.add(buttonImageEllipse);
 		ltb.addComponent(buttonImageEllipse);
 		
 		buttonImageCircle = new JToggleButton(LaTeXDrawResources.circleIcon);		
 		buttonImageCircle.addActionListener(ml);
 		buttonImageCircle.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageCircle.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.127")); //$NON-NLS-1$
 		buttonImageCircle.setActionCommand(LaTeXDrawResources.LABEL_CIRCLE);
 		drawButtonGroup.add(buttonImageCircle);
 		ltb.addComponent(buttonImageCircle);
 		ltb.addSeparator();

 		ltb = new ListJToggleButton(parentFrame, LaTeXDrawResources.arcIcon, ListJToggleButton.LOCATION_SOUTH);
 		ltb.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.128")); //$NON-NLS-1$
 		add(ltb);
 		
 		buttonImageArc = new JToggleButton(LaTeXDrawResources.arcIcon);
 		buttonImageArc.addActionListener(ml);
 		buttonImageArc.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageArc.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.128")); //$NON-NLS-1$
 		buttonImageArc.setActionCommand(LaTeXDrawResources.LABEL_ARC);
 		drawButtonGroup.add(buttonImageArc);
 		ltb.addComponent(buttonImageArc);
 		
 		buttonImageWedge = new JToggleButton(LaTeXDrawResources.wedgeIcon);
 		buttonImageWedge.addActionListener(ml);
 		buttonImageWedge.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageWedge.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.130")); //$NON-NLS-1$
 		buttonImageWedge.setActionCommand(LaTeXDrawResources.LABEL_WEDGE);
 		drawButtonGroup.add(buttonImageWedge);
 		ltb.addComponent(buttonImageWedge);
 		
 		buttonImageChord = new JToggleButton(LaTeXDrawResources.chordIcon);
 		buttonImageChord.addActionListener(ml);
 		buttonImageChord.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageChord.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.131")); //$NON-NLS-1$
 		buttonImageChord.setActionCommand(LaTeXDrawResources.LABEL_CHORD);
 		drawButtonGroup.add(buttonImageChord);
 		ltb.addComponent(buttonImageChord);
 		ltb.addSeparator();
 		
 		ltb = new ListJToggleButton(parentFrame, LaTeXDrawResources.closedBezierIcon, ListJToggleButton.LOCATION_SOUTH);
 		ltb.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.132")); //$NON-NLS-1$
 		add(ltb);
 
 		buttonImageClosedBezierCurve = new JToggleButton(LaTeXDrawResources.closedBezierIcon);
 		buttonImageClosedBezierCurve.addActionListener(ml);
 		buttonImageClosedBezierCurve.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageClosedBezierCurve.setToolTipText(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.11")); //$NON-NLS-1$
 		buttonImageClosedBezierCurve.setActionCommand(LaTeXDrawResources.LABEL_CLOSED_BEZIER_CURVE);
 		drawButtonGroup.add(buttonImageClosedBezierCurve);
 		ltb.addComponent(buttonImageClosedBezierCurve);
 		
 		buttonImageBezierCurve = new JToggleButton(LaTeXDrawResources.bezierCurveIcon);
 		buttonImageBezierCurve.addActionListener(ml);
 		buttonImageBezierCurve.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageBezierCurve.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.132")); //$NON-NLS-1$
 		buttonImageBezierCurve.setActionCommand(LaTeXDrawResources.LABEL_BEZIER_CURVE);
 		drawButtonGroup.add(buttonImageBezierCurve);
 		ltb.addComponent(buttonImageBezierCurve);
 		ltb.addSeparator();
 		
 		ltb = new ListJToggleButton(parentFrame, LaTeXDrawResources.gridIcon, ListJToggleButton.LOCATION_SOUTH);
 		ltb.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.16")); //$NON-NLS-1$
 		
 		buttonImageGrid = new JToggleButton(LaTeXDrawResources.gridIcon);
 		buttonImageGrid.addActionListener(ml);
 		buttonImageGrid.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageGrid.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.133")); //$NON-NLS-1$
 		buttonImageGrid.setActionCommand(LaTeXDrawResources.LABEL_GRID);
 		drawButtonGroup.add(buttonImageGrid);
 		ltb.addComponent(buttonImageGrid);
 		
 		buttonImageAxes = new JToggleButton(LaTeXDrawResources.axesIcon);
 		buttonImageAxes.addActionListener(ml);
 		buttonImageAxes.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageAxes.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.17")); //$NON-NLS-1$
 		buttonImageAxes.setActionCommand(LaTeXDrawResources.LABEL_AXES);
 		drawButtonGroup.add(buttonImageAxes);
 		ltb.addComponent(buttonImageAxes);
 		ltb.addSeparator();
 		add(ltb);
 		
 		buttonImagePointsAkin = new JToggleButton(LaTeXDrawResources.pointsAkinIcon);
 		buttonImagePointsAkin.addActionListener(ml);
 		buttonImagePointsAkin.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImagePointsAkin.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.7")); //$NON-NLS-1$
 		buttonImagePointsAkin.setActionCommand(LaTeXDrawResources.LABEL_POINTS_AKIN);
 		drawButtonGroup.add(buttonImagePointsAkin);
 		add(buttonImagePointsAkin);
 		
 		buttonImageText = new JToggleButton(LaTeXDrawResources.textIcon);
 		buttonImageText.addActionListener(ml);
 		buttonImageText.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageText.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.60")); //$NON-NLS-1$
 		buttonImageText.setActionCommand(LaTeXDrawResources.LABEL_TEXT);
 		drawButtonGroup.add(buttonImageText);
 		add(buttonImageText);
 		
 		addSeparator();
 		
 		buttonImageSelect = new JToggleButton(LaTeXDrawResources.selectIcon);		
 		buttonImageSelect.addActionListener(ml);
 		buttonImageSelect.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageSelect.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.136") + //$NON-NLS-1$
 				LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.137") + //$NON-NLS-1$
 				LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.138")); //$NON-NLS-1$
 		buttonImageSelect.setActionCommand(LaTeXDrawResources.LABEL_SELECT_FIGURE);
 		drawButtonGroup.add(buttonImageSelect);
		drawButtonGroup.setSelected(buttonImageSelect.getModel(), true);
 		add(buttonImageSelect);
 		
 		buttonImageDel = new JButton(LaTeXDrawResources.delIcon);		
 		buttonImageDel.addActionListener(ml);
 		buttonImageDel.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageDel.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.139")); //$NON-NLS-1$
 		buttonImageDel.setActionCommand(LaTeXDrawResources.LABEL_DELETE);
 		buttonImageDel.setEnabled(false);
 		add(buttonImageDel);
 		
 		addSeparator();
 		
 		buttonImageProperties = new JButton(LaTeXDrawResources.propertiesIcon);
 		buttonImageProperties.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.140")); //$NON-NLS-1$
 		buttonImageProperties.addActionListener(ml);
 		buttonImageProperties.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageProperties.setActionCommand(LaTeXDrawResources.LABEL_FIGURE_PROPERTIES);
 		buttonImageProperties.setEnabled(false);
        add(buttonImageProperties);
        
        addSeparator();

 		buttonImageBorders = new JToggleButton(LaTeXDrawResources.bordersIcon);		
 		buttonImageBorders.addActionListener(ml);
 		buttonImageBorders.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		buttonImageBorders.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.141") + //$NON-NLS-1$
 				LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.142") + //$NON-NLS-1$
 				LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.143") + //$NON-NLS-1$
 				LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.144")); //$NON-NLS-1$
 		buttonImageBorders.setActionCommand(LaTeXDrawResources.LABEL_DISPLAY_BORDERS);
 		add(buttonImageBorders);
 		
 		button = new JButton(LaTeXDrawResources.texEditorIcon);
 		button.addActionListener(parentFrame);
 		button.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		button.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.18")); //$NON-NLS-1$
 		button.setActionCommand(LaTeXDrawResources.LABEL_TEX_EDITOR);
 		add(button);
 		
 		copyCodeButton = new JButton(LaTeXDrawResources.copyIcon);
 		copyCodeButton.addActionListener(parentFrame.getCodePanel());
 		copyCodeButton.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		copyCodeButton.setToolTipText(CodePanel.LABEL_COPY_ALL);
 		copyCodeButton.setActionCommand(CodePanel.LABEL_COPY_ALL);
 		copyCodeButton.setVisible(!LaTeXDrawFrame.DEFAULT_DISPLAY_CODEPANEL);
 		add(copyCodeButton);
 		
 		copyCodeSelButton = new JButton(LaTeXDrawResources.copySelIcon);
 		copyCodeSelButton.addActionListener(parentFrame.getCodePanel());
 		copyCodeSelButton.setMargin(LaTeXDrawFrame.INSET_BUTTON);
 		copyCodeSelButton.setToolTipText(CodePanel.LABEL_COPY_SELECTED_FIG);
 		copyCodeSelButton.setActionCommand(CodePanel.LABEL_COPY_SELECTED_FIG);
 		add(copyCodeSelButton);
	}


	/**
	 * @return the persoGridGapField.
	 * @since 2.0.0
	 */
	public JSpinner getPersoGridGapField()
	{
		return persoGridGapField;
	}


	/**
	 * @return the magneticCB.
	 * @since 2.0.0
	 */
	public JCheckBox getMagneticCB()
	{
		return magneticCB;
	}


	/**
	 * @return the sliderDelimitor.
	 * @since 2.0.0
	 */
	public JSlider getSliderDelimitor()
	{
		return sliderDelimitor;
	}


	/**
	 * @return the copyCodeButton.
	 * @since 2.0.0
	 */
	public JButton getCopyCodeButton()
	{
		return copyCodeButton;
	}


	/**
	 * @return the copyCodeSelButton.
	 * @since 2.0.0
	 */
	public JButton getCopyCodeSelButton()
	{
		return copyCodeSelButton;
	}


	/**
	 * @return the buttonImageLine.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageLine()
	{
		return buttonImageLine;
	}


	/**
	 * @return the buttonImageDot.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageDot()
	{
		return buttonImageDot;
	}


	/**
	 * @return the buttonImageRect.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageRect()
	{
		return buttonImageRect;
	}


	/**
	 * @return the buttonImageSquare.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageSquare()
	{
		return buttonImageSquare;
	}


	/**
	 * @return the buttonImageRhombus.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageRhombus()
	{
		return buttonImageRhombus;
	}


	/**
	 * @return the buttonImageTriangle.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageTriangle()
	{
		return buttonImageTriangle;
	}


	/**
	 * @return the buttonImageEllipse.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageEllipse()
	{
		return buttonImageEllipse;
	}


	/**
	 * @return the buttonImageCircle.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageCircle()
	{
		return buttonImageCircle;
	}


	/**
	 * @return the buttonImageSelect.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageSelect()
	{
		return buttonImageSelect;
	}


	/**
	 * @return the buttonImageBorders.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageBorders()
	{
		return buttonImageBorders;
	}


	/**
	 * @return the buttonImageWedge.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageWedge()
	{
		return buttonImageWedge;
	}


	/**
	 * @return the buttonImageChord.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageChord()
	{
		return buttonImageChord;
	}


	/**
	 * @return the buttonImageArc.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageArc()
	{
		return buttonImageArc;
	}


	/**
	 * @return the buttonImagePoly.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImagePoly()
	{
		return buttonImagePoly;
	}


	/**
	 * @return the buttonImageText.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageText()
	{
		return buttonImageText;
	}


	/**
	 * @return the buttonImagePointsAkin.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImagePointsAkin()
	{
		return buttonImagePointsAkin;
	}


	/**
	 * @return the buttonImageGrid.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageGrid()
	{
		return buttonImageGrid;
	}


	/**
	 * @return the buttonImageAxes.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageAxes()
	{
		return buttonImageAxes;
	}


	/**
	 * @return the buttonImageBezierCurve.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageBezierCurve()
	{
		return buttonImageBezierCurve;
	}


	/**
	 * @return the buttonImageClosedBezierCurve.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageClosedBezierCurve()
	{
		return buttonImageClosedBezierCurve;
	}


	/**
	 * @return the buttonImageJoinedLines.
	 * @since 2.0.0
	 */
	public JToggleButton getButtonImageJoinedLines()
	{
		return buttonImageJoinedLines;
	}


	/**
	 * @return the buttonImageDel.
	 * @since 2.0.0
	 */
	public JButton getButtonImageDel()
	{
		return buttonImageDel;
	}


	/**
	 * @return the buttonImageProperties.
	 * @since 2.0.0
	 */
	public JButton getButtonImageProperties()
	{
		return buttonImageProperties;
	}


	/**
	 * @return the buttonImageRedo.
	 * @since 2.0.0
	 */
	public JButton getButtonImageRedo()
	{
		return buttonImageRedo;
	}


	/**
	 * @return the buttonImageUndo.
	 * @since 2.0.0
	 */
	public JButton getButtonImageUndo()
	{
		return buttonImageUndo;
	}


	/**
	 * @return the zoomField.
	 * @since 2.0.0
	 */
	public JSpinner getZoomField()
	{
		return zoomField;
	}


	public JButton getButtonPdfExport() {
		return buttonPdfExport;
	}
}
