package junit.test.svg;

import junit.framework.TestCase;
import latexDraw.parsers.svg.SVGDocument;
import latexDraw.parsers.svg.SVGNodeList;
import latexDraw.parsers.svg.elements.SVGElement;

import org.junit.Before;
import org.junit.Test;

/** 
 * This class contains tests for the SVGNodeList class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 03/29/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestSVGNodeList extends TestCase
{
	protected SVGNodeList list;
	protected SVGDocument doc;
	
	
	@Override
	@Before
	public void setUp()
	{
		doc  = new SVGDocument();
		list = new SVGNodeList();
	}
	
	
	@Test
	public void testSVGNodeList()
	{
		assertNotNull(list.getNodes());
	}
	
	
	@Test
	public void testGetLength()
	{
		list.getNodes().clear();
		assertEquals(0, list.getLength());
		list.getNodes().add((SVGElement)doc.createElement("elt"));
		assertEquals(1, list.getLength());
		list.getNodes().clear();
	}
	
	
	@Test
	public void testItem()
	{
		SVGElement elt = (SVGElement)doc.createElement("elt");
		
		list.getNodes().clear();
		assertNull(list.item(0));
		assertNull(list.item(-1));
		assertNull(list.item(1));
		list.getNodes().add(elt);
		assertNull(list.item(-1));
		assertNull(list.item(1));
		assertEquals(list.item(0), elt);
	}
	
	
	@Test
	public void testGetNodes()
	{
		assertNotNull(list.getNodes());
	}
}
