package junit.test.parser.svg.parsers;

import junit.framework.TestCase;
import latexDraw.parsers.svg.SVGLength;
import latexDraw.parsers.svg.parsers.UnitProcessor;

import org.junit.Test;

/** 
 * Tests the class UnitProcessor.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 10/24/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1<br>
 */
public class TestUnitProcessor extends TestCase
{
	@Test
	public void testToUserUnit()
	{
		try
		{
			UnitProcessor.toUserUnit(1, null);
			fail();
		}
		catch(IllegalArgumentException e){ /* */ }
		
		assertEquals(UnitProcessor.toUserUnit(1., SVGLength.LengthType.CM), 35.43307);
		assertEquals(UnitProcessor.toUserUnit(1., SVGLength.LengthType.MM), 3.543307);
		assertEquals(UnitProcessor.toUserUnit(1., SVGLength.LengthType.PT), 1.25);
		assertEquals(UnitProcessor.toUserUnit(1., SVGLength.LengthType.PC), 15.);
		assertEquals(UnitProcessor.toUserUnit(1., SVGLength.LengthType.IN), 90.);
	}
}
