/*
 * TestShape.java
 */

package junit.test;

import java.awt.Color;
import java.awt.Point;

import junit.framework.TestCase;
import latexDraw.figures.*;
import latexDraw.psTricks.PSTricksConstants;
import latexDraw.util.LaTeXDrawPoint2D;

import org.junit.Test;



/** 
 * This class contains tests to check the graphical library.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 12/18/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestShape extends TestCase
{
	protected static final DrawBorders drawBorders = new DrawBorders(false);
	
	
	
	@Test
	public void testFigure()
	{
		assertNotNull(Figure.createBordersPositionChoice());
		assertNotNull(Figure.createBordersPositionChoice());
	}
	
	

	@Test
	public void testRectangle() throws Exception
	{
		LaTeXDrawRectangle rec = new LaTeXDrawRectangle(false);
		Figure f;
		
		assertTrue(rec.canBeFilled());
		assertTrue(rec.canBeHatched());
		assertFalse(rec.canHaveArrow());
		assertTrue(rec.canHaveShadow());
		assertTrue(rec.isBordersMovable());
		assertTrue(rec.isCustomizable());
		assertTrue(rec.isDashableOrDotable());
		assertTrue(rec.isDoubleBoundaryable());
		assertTrue(rec.isThicknessable());
		assertTrue(rec.isResizable());
		
		f = (Figure)rec.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(rec, true, true));
		
		rec.updateNSEWDelimitors();
		rec.updateStyleOfDelimitors();
		rec.updateGravityCenter();
		rec.updateBorders();
		rec.updateShape();
		rec.updateBorders(new LaTeXDrawPoint2D());
		rec.shift(10, 10);
		
		try
		{
			rec.shift(new LaTeXDrawPoint2D(), null);
			fail();
		}catch(IllegalArgumentException e) { /* */}
		
		rec.addRotationAngle(10);
		rec.updateGravityCenter();
		rec.addRotationAngle(0.3);
		rec.updateShape();
		rec.updateStyleOfDelimitors();
		rec.updateNSEWDelimitors();
		
		rec.onClick(new Point(10,10));
		rec.isIn(new LaTeXDrawPoint2D());
		rec.isIn(rec.getGravityCenter());
		rec.isIn(new Point());
		
		f = (Figure)rec.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(rec, true, true));
		
		rec.setDotSep(2);
		rec.setCustomizable(false);
		rec.setDoubleSep(2);
		rec.setFirstPoint(3, 3);
		rec.updateShape();
		rec.setGradientMidPoint(0.3);
		rec.setFrameArc(0.2);
		rec.setGradientAngle(0.5);
		rec.setDoubleColor(Color.red);
		rec.setGradientStartColor(Color.yellow);
		rec.setGradientEndColor(Color.blue);
		rec.setHasDoubleBoundary(true);
		
		f = (Figure)rec.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(rec, true, true));
		
		rec.setHasShadow(true);
		
		f = (Figure)rec.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(rec, true, true));
		
		rec.setHatchingAngle(3);
		rec.setHatchingColor(Color.gray);
		rec.setHatchingSep(4);
		rec.setHatchingStyle(PSTricksConstants.TOKEN_FILL_HLINES);
		f = (Figure)rec.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(rec, true, true));
		
		rec.setHatchingStyle(PSTricksConstants.TOKEN_FILL_GRADIENT);
		f = (Figure)rec.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(rec, true, true));
		
		assertEquals(rec.getWidth(), rec.getTheSEPoint().x-rec.getTheNWPoint().x, 0.005);
		assertEquals(rec.getHeight(), rec.getTheSEPoint().y-rec.getTheNWPoint().y, 0.005);
		
		rec.updateShape();
		rec.onRelease();
		rec.onDelimitorRelease();
		rec.onDragged(new Point(), new Point());
		rec.createNonRotatedShape2D();
		rec.createShadowShape();
		rec.createShape2D();
		rec.updateShape();
		assertNotNull(rec.getCodePSTricks(drawBorders, Figure.PPC));
	}
	
	
	
	
	@Test
	public void testJoinedLines() throws Exception
	{
		JoinedLines jl = new JoinedLines(new LaTeXDrawPoint2D(), new LaTeXDrawPoint2D(3,3), false);
		Figure f;
		
		assertTrue(jl.canBeFilled());
		assertTrue(jl.canBeHatched());
		assertTrue(jl.canHaveArrow());
		assertTrue(jl.canHaveShadow());
		assertFalse(jl.isBordersMovable());
		assertTrue(jl.isCustomizable());
		assertTrue(jl.isDashableOrDotable());
		assertTrue(jl.isDoubleBoundaryable());
		assertTrue(jl.isThicknessable());
		assertTrue(jl.isResizable());
		
		f = (Figure)jl.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(jl, true, true));
		
		jl.updateBorders();
		jl.updateShape();
		jl.updateGravityCenter();
		
		jl.addPoint(new LaTeXDrawPoint2D());
		jl.addPoint(new LaTeXDrawPoint2D(3,3));
		jl.addPoint(new LaTeXDrawPoint2D(1,3));
		
		jl.updateBorders();
		jl.updateShape();
		jl.updateGravityCenter();
		
		f = (Figure)jl.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(jl, true, true));
		
		jl.updateStyleOfDelimitors();
		jl.updateGravityCenter();
		jl.updateBorders();
		jl.updateShape();
		jl.updateBorders(new LaTeXDrawPoint2D());
		jl.shift(10, 10);
		
		try
		{
			jl.shift(new LaTeXDrawPoint2D(), null);
			fail();
		}catch(IllegalArgumentException e) { /* */}
		
		jl.addRotationAngle(10);
		jl.updateGravityCenter();
		jl.addRotationAngle(0.3);
		jl.updateShape();
		jl.updateStyleOfDelimitors();
		
		jl.onClick(new Point(10,10));
		jl.isIn(new LaTeXDrawPoint2D());
		jl.isIn(jl.getGravityCenter());
		jl.isIn(new Point());
		
		f = (Figure)jl.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(jl, true, true));
		
		jl.setDotSep(2);
		jl.setCustomizable(false);
		jl.setDoubleSep(2);
		jl.setFirstPoint(3, 3);
		jl.updateShape();
		jl.setGradientMidPoint(0.3);
		jl.setGradientAngle(0.5);
		jl.setDoubleColor(Color.red);
		jl.setGradientStartColor(Color.yellow);
		jl.setGradientEndColor(Color.blue);
		jl.setHasDoubleBoundary(true);
		
		f = (Figure)jl.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(jl, true, true));
		
		jl.setHasShadow(true);
		
		f = (Figure)jl.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(jl, true, true));
		
		jl.setHatchingAngle(3);
		jl.setHatchingColor(Color.gray);
		jl.setHatchingSep(4);
		jl.setHatchingStyle(PSTricksConstants.TOKEN_FILL_HLINES);
		f = (Figure)jl.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(jl, true, true));
		
		jl.setHatchingStyle(PSTricksConstants.TOKEN_FILL_GRADIENT);
		f = (Figure)jl.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(jl, true, true));
		
		jl.updateShape();
		jl.onRelease();
		jl.onDelimitorRelease();
		jl.onDragged(new Point(), new Point());
		jl.createNonRotatedShape2D();
		jl.createShadowShape();
		jl.createShape2D();
		
		jl.removePointAt(-1);
		jl.updateBorders();
		jl.updateShape();
		
		jl.removePointAt(0);
		jl.updateBorders();
		jl.updateShape();
		
		jl.removePointAt(0);
		jl.updateBorders();
		jl.updateShape();
		
		jl.setArrow1Style(PSTricksConstants.LRBRACKET_STYLE);
		jl.setArrow2Style(PSTricksConstants.LARROW_STYLE);
		jl.shift(20, 10);
		jl.updateShape();
		jl.updateBorders();
		assertNotNull(jl.getCodePSTricks(drawBorders, Figure.PPC));
	}
	
	
	
	
	@Test
	public void testLine() throws Exception
	{
		Line line = new Line(false);
		Figure f;
		
		assertFalse(line.canBeFilled());
		assertFalse(line.canBeHatched());
		assertTrue(line.canHaveArrow());
		assertTrue(line.canHaveShadow());
		assertFalse(line.isBordersMovable());
		assertTrue(line.isCustomizable());
		assertTrue(line.isDashableOrDotable());
		assertTrue(line.isDoubleBoundaryable());
		assertTrue(line.isThicknessable());
		assertTrue(line.isResizable());
		
		f = (Figure)line.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(line, true, true));
		
		line.updateStyleOfDelimitors();
		line.updateGravityCenter();
		line.updateShape();
		line.shift(10, 10);
		
		try
		{
			line.shift(new LaTeXDrawPoint2D(), null);
			fail();
		}catch(IllegalArgumentException e) { /* */}
		
		line.addRotationAngle(10);
		line.updateGravityCenter();
		line.addRotationAngle(0.3);
		line.updateShape();
		line.updateStyleOfDelimitors();
		
		line.onClick(new Point(10,10));
		line.isIn(new LaTeXDrawPoint2D());
		line.isIn(line.getGravityCenter());
		line.isIn(new Point());
		
		f = (Figure)line.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(line, true, true));
		
		line.setDotSep(2);
		line.setCustomizable(false);
		line.setFirstPoint(3, 3);
		line.updateShape();
		line.setHasDoubleBoundary(true);
		
		f = (Figure)line.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(line, true, true));
		
		line.setHasShadow(true);
		
		f = (Figure)line.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(line, true, true));
		
		line.updateShape();
		line.onRelease();
		line.onDelimitorRelease();
		line.onDragged(new Point(), new Point());
		line.createNonRotatedShape2D();
		line.createShadowShape();
		line.createShape2D();
		line.updateShape();
		
		line.setArrow1Style(PSTricksConstants.LRBRACKET_STYLE);
		line.setArrow2Style(PSTricksConstants.LARROW_STYLE);
		line.shift(20, 10);
		line.updateAandB();
		line.updateShape();
		assertNotNull(line.getCodePSTricks(drawBorders, Figure.PPC));
	}
	
	
	
	
	
	@Test
	public void testPolygon() throws Exception
	{
		LaTeXDrawPolygon pol = new LaTeXDrawPolygon(false);
		Figure f;
		
		assertTrue(pol.canBeFilled());
		assertTrue(pol.canBeHatched());
		assertFalse(pol.canHaveArrow());
		assertTrue(pol.canHaveShadow());
		assertFalse(pol.isBordersMovable());
		assertTrue(pol.isCustomizable());
		assertTrue(pol.isDashableOrDotable());
		assertTrue(pol.isDoubleBoundaryable());
		assertTrue(pol.isThicknessable());
		assertTrue(pol.isResizable());
		
		f = (Figure)pol.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(pol, true, true));
		
		pol.updateBorders();
		pol.updateShape();
		pol.updateGravityCenter();
		
		pol.addPoint(new LaTeXDrawPoint2D());
		pol.addPoint(new LaTeXDrawPoint2D(3,3));
		pol.addPoint(new LaTeXDrawPoint2D(1,3));
		
		pol.updateBorders();
		pol.updateShape();
		pol.updateGravityCenter();
		
		f = (Figure)pol.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(pol, true, true));
		
		pol.updateStyleOfDelimitors();
		pol.updateGravityCenter();
		pol.updateBorders();
		pol.updateShape();
		pol.updateBorders(new LaTeXDrawPoint2D());
		pol.shift(10, 10);
		
		try
		{
			pol.shift(new LaTeXDrawPoint2D(), null);
			fail();
		}catch(IllegalArgumentException e) { /* */}
		
		pol.addRotationAngle(10);
		pol.updateGravityCenter();
		pol.addRotationAngle(0.3);
		pol.updateShape();
		pol.updateStyleOfDelimitors();
		
		pol.onClick(new Point(10,10));
		pol.isIn(new LaTeXDrawPoint2D());
		pol.isIn(pol.getGravityCenter());
		pol.isIn(new Point());
		
		f = (Figure)pol.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(pol, true, true));
		
		pol.setDotSep(2);
		pol.setCustomizable(false);
		pol.setDoubleSep(2);
		pol.setFirstPoint(3, 3);
		pol.updateShape();
		pol.setGradientMidPoint(0.3);
		pol.setGradientAngle(0.5);
		pol.setDoubleColor(Color.red);
		pol.setGradientStartColor(Color.yellow);
		pol.setGradientEndColor(Color.blue);
		pol.setHasDoubleBoundary(true);
		
		f = (Figure)pol.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(pol, true, true));
		
		pol.setHasShadow(true);
		
		f = (Figure)pol.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(pol, true, true));
		
		pol.setHatchingAngle(3);
		pol.setHatchingColor(Color.gray);
		pol.setHatchingSep(4);
		pol.setHatchingStyle(PSTricksConstants.TOKEN_FILL_HLINES);
		f = (Figure)pol.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(pol, true, true));
		
		pol.setHatchingStyle(PSTricksConstants.TOKEN_FILL_GRADIENT);
		f = (Figure)pol.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(pol, true, true));
		
		pol.updateShape();
		pol.onRelease();
		pol.onDelimitorRelease();
		pol.onDragged(new Point(), new Point());
		pol.createNonRotatedShape2D();
		pol.createShadowShape();
		pol.createShape2D();
		
		pol.removePointAt(-1);
		pol.updateBorders();
		pol.updateShape();
		assertNotNull(pol.getCodePSTricks(drawBorders, Figure.PPC));
		
		pol.removePointAt(0);
		pol.updateBorders();
		pol.updateShape();
		
		pol.removePointAt(0);
		pol.updateBorders();
		pol.updateShape();
		assertNull(pol.getCodePSTricks(drawBorders, Figure.PPC));
	}
	
	
	
	@Test
	public void testDot() throws Exception
	{
		Dot d = new Dot(new LaTeXDrawPoint2D(68,-876), true);
		Figure f;
		
		assertFalse(d.canBeFilled());
		assertFalse(d.canBeHatched());
		assertFalse(d.canHaveArrow());
		assertFalse(d.canHaveShadow());
		assertFalse(d.isBordersMovable());
		assertTrue(d.isCustomizable());
		assertFalse(d.isDashableOrDotable());
		assertFalse(d.isDoubleBoundaryable());
		assertFalse(d.isThicknessable());
		assertFalse(d.isResizable());
		
		f = (Figure)d.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(d, true, true));
		
		d.updateStyleOfDelimitors();
		d.shift(10, 10);
		d.updateShape();
		
		try
		{
			d.shift(new LaTeXDrawPoint2D(), null);
			fail();
		}catch(IllegalArgumentException e) { /* */}
		
		d.setRotationAngle(0.4);
		d.updateShape();
		
		d.onClick(new Point(10,10));
		d.isIn(new LaTeXDrawPoint2D());
		d.isIn(d.getGravityCenter());
		d.isIn(new Point());
		
		f = (Figure)d.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(d, true, true));
		
		d.onRelease();
		d.onDelimitorRelease();
		d.onDragged(new Point(), new Point());
		d.createNonRotatedShape2D();
		d.createShadowShape();
		d.createShape2D();
		d.updateShape();
		assertNotNull(d.getCodePSTricks(drawBorders, Figure.PPC));
	}
	
	
	
	
	
	@Test
	public void testAkinPoints() throws Exception
	{
		AkinPoints ak = new AkinPoints(new LaTeXDrawPoint2D(12,76), true);
		Figure f;
		
		assertTrue(ak.canBeFilled());
		assertTrue(ak.canBeHatched());
		assertFalse(ak.canHaveArrow());
		assertTrue(ak.canHaveShadow());
		assertFalse(ak.isBordersMovable());
		assertTrue(ak.isCustomizable());
		assertTrue(ak.isDashableOrDotable());
		assertFalse(ak.isDoubleBoundaryable());
		assertTrue(ak.isThicknessable());
		assertTrue(ak.isResizable());
		
		f = (Figure)ak.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(ak, true, true));
		
		ak.updateBorders();
		ak.updateShape();
		ak.updateGravityCenter();
		
		ak.addPoint(new LaTeXDrawPoint2D());
		ak.addPoint(new LaTeXDrawPoint2D(3,3));
		ak.addPoint(new LaTeXDrawPoint2D(1,3));
		
		ak.updateBorders();
		ak.updateShape();
		ak.updateGravityCenter();
		
		f = (Figure)ak.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(ak, true, true));
		
		ak.updateStyleOfDelimitors();
		ak.updateGravityCenter();
		ak.updateBorders();
		ak.updateShape();
		ak.updateBorders(new LaTeXDrawPoint2D());
		ak.shift(10, 10);
		
		try
		{
			ak.shift(new LaTeXDrawPoint2D(), null);
			fail();
		}catch(IllegalArgumentException e) { /* */}
		
		ak.addRotationAngle(10);
		ak.updateGravityCenter();
		ak.addRotationAngle(0.3);
		ak.updateShape();
		ak.updateStyleOfDelimitors();
		
		ak.onClick(new Point(10,10));
		ak.isIn(new LaTeXDrawPoint2D());
		ak.isIn(ak.getGravityCenter());
		ak.isIn(new Point());
		
		f = (Figure)ak.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(ak, true, true));
		
		ak.setDotSep(2);
		ak.setCustomizable(false);
		ak.setDoubleSep(2);
		ak.setFirstPoint(3, 3);
		ak.updateShape();
		ak.setGradientMidPoint(0.3);
		ak.setGradientAngle(0.5);
		ak.setDoubleColor(Color.red);
		ak.setGradientStartColor(Color.yellow);
		ak.setGradientEndColor(Color.blue);
		ak.setHasDoubleBoundary(true);
		
		f = (Figure)ak.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(ak, true, true));
		
		ak.setHasShadow(true);
		ak.setType(AkinPoints.TYPE_LINES);
		ak.setInterval(30);
		
		f = (Figure)ak.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(ak, true, true));
		
		ak.setHatchingAngle(3);
		ak.setHatchingColor(Color.gray);
		ak.setHatchingSep(4);
		ak.setHatchingStyle(PSTricksConstants.TOKEN_FILL_HLINES);
		f = (Figure)ak.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(ak, true, true));
		
		ak.setHatchingStyle(PSTricksConstants.TOKEN_FILL_GRADIENT);
		f = (Figure)ak.clone();
		assertNotNull(f);
		assertTrue(f.isParametersEquals(ak, true, true));
		
		ak.updateShape();
		ak.onRelease();
		ak.onDelimitorRelease();
		ak.onDragged(new Point(), new Point());
		ak.createNonRotatedShape2D();
		ak.createShadowShape();
		ak.createShape2D();
		
		ak.removePointAt(-1);
		ak.updateBorders();
		ak.updateShape();
		assertNotNull(ak.getCodePSTricks(drawBorders, Figure.PPC));
		
		ak.removePointAt(0);
		ak.updateBorders();
		ak.updateShape();
		
		ak.removePointAt(0);
		ak.updateBorders();
		ak.updateShape();
		assertNull(ak.getCodePSTricks(drawBorders, Figure.PPC));
	}
}




