/*
 * DviPsColorsTest.java
 */

package junit.test;


import java.awt.Color;

import junit.framework.TestCase;
import latexDraw.psTricks.DviPsColors;

import org.junit.Test;



/** 
 * This class contains tests for the {@link DviPsColors} class.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 06/20/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestDviPsColors extends TestCase
{

	@Test
	public void testGetColorName()
	{
		Color c2 = new Color(218, 29, 78);
		String nameColour = "testColour";

		assertNull(DviPsColors.getColourName(null));
		DviPsColors.addUserColour(c2, nameColour);
		assertEquals(nameColour, DviPsColors.getColourName(c2));
		
		assertEquals(DviPsColors.N_APRICOT, DviPsColors.getColourName(DviPsColors.APRICOT));
		assertEquals(DviPsColors.N_AQUAMARINE, DviPsColors.getColourName(DviPsColors.AQUAMARINE));
		assertEquals(DviPsColors.N_BITTERSWEET, DviPsColors.getColourName(DviPsColors.BITTERSWEET));
		assertEquals(DviPsColors.N_BLUEGREEN, DviPsColors.getColourName(DviPsColors.BLUEGREEN));
		assertEquals(DviPsColors.N_BLUEVIOLET, DviPsColors.getColourName(DviPsColors.BLUEVIOLET));
		assertEquals(DviPsColors.N_BRICKRED, DviPsColors.getColourName(DviPsColors.BRICKRED));
		assertEquals(DviPsColors.N_BURNT_ORANGE, DviPsColors.getColourName(DviPsColors.BURNT_ORANGE));
		assertEquals(DviPsColors.N_CADETBLUE, DviPsColors.getColourName(DviPsColors.CADETBLUE));
		assertEquals(DviPsColors.N_CARNATIONPINK, DviPsColors.getColourName(DviPsColors.CARNATIONPINK));
		assertEquals(DviPsColors.N_CERULEAN, DviPsColors.getColourName(DviPsColors.CERULEAN));
		assertEquals(DviPsColors.N_CORNFLOWERBLUE, DviPsColors.getColourName(DviPsColors.CORNFLOWERBLUE));
		assertEquals(DviPsColors.N_DANDELION, DviPsColors.getColourName(DviPsColors.DANDELION));
		assertEquals(DviPsColors.N_DARK_GRAY, DviPsColors.getColourName(Color.DARK_GRAY));
		assertEquals(DviPsColors.N_DARKORCHID, DviPsColors.getColourName(DviPsColors.DARKORCHID));
		assertEquals(DviPsColors.N_EMERALD, DviPsColors.getColourName(DviPsColors.EMERALD));
		assertEquals(DviPsColors.N_FORESTGREEN, DviPsColors.getColourName(DviPsColors.FORESTGREEN));
		assertEquals(DviPsColors.N_FUSHIA, DviPsColors.getColourName(DviPsColors.FUSHIA));
		assertEquals(DviPsColors.N_GOLDEN_ROD, DviPsColors.getColourName(DviPsColors.GOLDEN_ROD));
		assertEquals(DviPsColors.N_GREEN_YELLOW, DviPsColors.getColourName(DviPsColors.GREEN_YELLOW));
		assertEquals(DviPsColors.N_JUNGLEGREEN, DviPsColors.getColourName(DviPsColors.JUNGLEGREEN));
		assertEquals(DviPsColors.N_LAVENDER, DviPsColors.getColourName(DviPsColors.LAVENDER));
		assertEquals(DviPsColors.N_LIGHT_GRAY, DviPsColors.getColourName(Color.LIGHT_GRAY));
		assertEquals(DviPsColors.N_LIMEGREEN, DviPsColors.getColourName(DviPsColors.LIMEGREEN));
		assertEquals(DviPsColors.N_MAHOGANY, DviPsColors.getColourName(DviPsColors.MAHOGANY));
		assertEquals(DviPsColors.N_MAROON, DviPsColors.getColourName(DviPsColors.MAROON));
		assertEquals(DviPsColors.N_MELON, DviPsColors.getColourName(DviPsColors.MELON));
		assertEquals(DviPsColors.N_MIDNIGHTBLUE, DviPsColors.getColourName(DviPsColors.MIDNIGHTBLUE));
		assertEquals(DviPsColors.N_MULBERRY, DviPsColors.getColourName(DviPsColors.MULBERRY));
		assertEquals(DviPsColors.N_NAVYBLUE, DviPsColors.getColourName(DviPsColors.NAVYBLUE));
		assertEquals(DviPsColors.N_OLIVEGREEN, DviPsColors.getColourName(DviPsColors.OLIVEGREEN));
		assertEquals(DviPsColors.N_ORANGERED, DviPsColors.getColourName(DviPsColors.ORANGERED));
		assertEquals(DviPsColors.N_ORCHID, DviPsColors.getColourName(DviPsColors.ORCHID));
		assertEquals(DviPsColors.N_PEACH, DviPsColors.getColourName(DviPsColors.PEACH));
		assertEquals(DviPsColors.N_PERIWINKLE, DviPsColors.getColourName(DviPsColors.PERIWINKLE));
		assertEquals(DviPsColors.N_PINEGREEN, DviPsColors.getColourName(DviPsColors.PINEGREEN));
		assertEquals(DviPsColors.N_PINK, DviPsColors.getColourName(DviPsColors.PINK));
		assertEquals(DviPsColors.N_PLUM, DviPsColors.getColourName(DviPsColors.PLUM));
		assertEquals(DviPsColors.N_PROCESSBLUE, DviPsColors.getColourName(DviPsColors.PROCESSBLUE));
		assertEquals(DviPsColors.N_RAWSIENNA, DviPsColors.getColourName(DviPsColors.RAWSIENNA));
		assertEquals(DviPsColors.N_RED_ORANGE, DviPsColors.getColourName(DviPsColors.RED_ORANGE));
		assertEquals(DviPsColors.N_REDVIOLET, DviPsColors.getColourName(DviPsColors.REDVIOLET));
		assertEquals(DviPsColors.N_RHODAMINE, DviPsColors.getColourName(DviPsColors.RHODAMINE));
		assertEquals(DviPsColors.N_ROYALBLUE, DviPsColors.getColourName(DviPsColors.ROYALBLUE));
		assertEquals(DviPsColors.N_ROYALPURPLE, DviPsColors.getColourName(DviPsColors.ROYALPURPLE));
		assertEquals(DviPsColors.N_RUBINERED, DviPsColors.getColourName(DviPsColors.RUBINERED));
		assertEquals(DviPsColors.N_SALMON, DviPsColors.getColourName(DviPsColors.SALMON));
		assertEquals(DviPsColors.N_SEAGREEN, DviPsColors.getColourName(DviPsColors.SEAGREEN));
		assertEquals(DviPsColors.N_SEPIA, DviPsColors.getColourName(DviPsColors.SEPIA));
		assertEquals(DviPsColors.N_SKYBLUE, DviPsColors.getColourName(DviPsColors.SKYBLUE));
		assertEquals(DviPsColors.N_SPRINGGREEN, DviPsColors.getColourName(DviPsColors.SPRINGGREEN));
		assertEquals(DviPsColors.N_TAN, DviPsColors.getColourName(DviPsColors.TAN));
		assertEquals(DviPsColors.N_TEALBLUE, DviPsColors.getColourName(DviPsColors.TEALBLUE));
		assertEquals(DviPsColors.N_THISTLE, DviPsColors.getColourName(DviPsColors.THISTLE));
		assertEquals(DviPsColors.N_TURQUOISE, DviPsColors.getColourName(DviPsColors.TURQUOISE));
		assertEquals(DviPsColors.N_VIOLETRED, DviPsColors.getColourName(DviPsColors.VIOLETRED));
		assertEquals(DviPsColors.N_WILDSTRAWBERRY, DviPsColors.getColourName(DviPsColors.WILDSTRAWBERRY));
		assertEquals(DviPsColors.N_YELLOW_ORANGE, DviPsColors.getColourName(DviPsColors.YELLOW_ORANGE));
		assertEquals(DviPsColors.N_YELLOWGREEN, DviPsColors.getColourName(DviPsColors.YELLOWGREEN));
	}





	@Test
	public void testGetColor()
	{
		Color c2 = new Color(218, 29, 78);
		String nameColour = "testColour";
		
		assertEquals(c2, DviPsColors.getColour(nameColour));
		
		assertEquals(DviPsColors.APRICOT, DviPsColors.getColour(DviPsColors.N_APRICOT));
		assertEquals(DviPsColors.AQUAMARINE, DviPsColors.getColour(DviPsColors.N_AQUAMARINE));
		assertEquals(DviPsColors.BITTERSWEET, DviPsColors.getColour(DviPsColors.N_BITTERSWEET));
		assertEquals(DviPsColors.BLUEGREEN, DviPsColors.getColour(DviPsColors.N_BLUEGREEN));
		assertEquals(DviPsColors.BLUEVIOLET, DviPsColors.getColour(DviPsColors.N_BLUEVIOLET));
		assertEquals(DviPsColors.BRICKRED, DviPsColors.getColour(DviPsColors.N_BRICKRED));
		assertEquals(DviPsColors.BURNT_ORANGE, DviPsColors.getColour(DviPsColors.N_BURNT_ORANGE));
		assertEquals(DviPsColors.CADETBLUE, DviPsColors.getColour(DviPsColors.N_CADETBLUE));
		assertEquals(DviPsColors.CARNATIONPINK, DviPsColors.getColour(DviPsColors.N_CARNATIONPINK));
		assertEquals(DviPsColors.CERULEAN, DviPsColors.getColour(DviPsColors.N_CERULEAN));
		assertEquals(DviPsColors.CORNFLOWERBLUE, DviPsColors.getColour(DviPsColors.N_CORNFLOWERBLUE));
		assertEquals(DviPsColors.DANDELION, DviPsColors.getColour(DviPsColors.N_DANDELION));
		assertEquals(Color.DARK_GRAY, DviPsColors.getColour(DviPsColors.N_DARK_GRAY));
		assertEquals(DviPsColors.DARKORCHID, DviPsColors.getColour(DviPsColors.N_DARKORCHID));
		assertEquals(DviPsColors.EMERALD, DviPsColors.getColour(DviPsColors.N_EMERALD));
		assertEquals(DviPsColors.FORESTGREEN, DviPsColors.getColour(DviPsColors.N_FORESTGREEN));
		assertEquals(DviPsColors.FUSHIA, DviPsColors.getColour(DviPsColors.N_FUSHIA));
		assertEquals(DviPsColors.GOLDEN_ROD, DviPsColors.getColour(DviPsColors.N_GOLDEN_ROD));
		assertEquals(DviPsColors.GREEN_YELLOW, DviPsColors.getColour(DviPsColors.N_GREEN_YELLOW));
		assertEquals(DviPsColors.JUNGLEGREEN, DviPsColors.getColour(DviPsColors.N_JUNGLEGREEN));
		assertEquals(DviPsColors.LAVENDER, DviPsColors.getColour(DviPsColors.N_LAVENDER));
		assertEquals(Color.LIGHT_GRAY, DviPsColors.getColour(DviPsColors.N_LIGHT_GRAY));
		assertEquals(DviPsColors.LIMEGREEN, DviPsColors.getColour(DviPsColors.N_LIMEGREEN));
		assertEquals(DviPsColors.MAHOGANY, DviPsColors.getColour(DviPsColors.N_MAHOGANY));
		assertEquals(DviPsColors.MAROON, DviPsColors.getColour(DviPsColors.N_MAROON));
		assertEquals(DviPsColors.MELON, DviPsColors.getColour(DviPsColors.N_MELON));
		assertEquals(DviPsColors.MIDNIGHTBLUE, DviPsColors.getColour(DviPsColors.N_MIDNIGHTBLUE));
		assertEquals(DviPsColors.MULBERRY, DviPsColors.getColour(DviPsColors.N_MULBERRY));
		assertEquals(DviPsColors.NAVYBLUE, DviPsColors.getColour(DviPsColors.N_NAVYBLUE));
		assertEquals(DviPsColors.OLIVEGREEN, DviPsColors.getColour(DviPsColors.N_OLIVEGREEN));
		assertEquals(DviPsColors.ORANGERED, DviPsColors.getColour(DviPsColors.N_ORANGERED));
		assertEquals(DviPsColors.ORCHID, DviPsColors.getColour(DviPsColors.N_ORCHID));
		assertEquals(DviPsColors.PEACH, DviPsColors.getColour(DviPsColors.N_PEACH));
		assertEquals(DviPsColors.PERIWINKLE, DviPsColors.getColour(DviPsColors.N_PERIWINKLE));
		assertEquals(DviPsColors.PINEGREEN, DviPsColors.getColour(DviPsColors.N_PINEGREEN));
		assertEquals(DviPsColors.PINK, DviPsColors.getColour(DviPsColors.N_PINK));
		assertEquals(DviPsColors.PLUM, DviPsColors.getColour(DviPsColors.N_PLUM));
		assertEquals(DviPsColors.PROCESSBLUE, DviPsColors.getColour(DviPsColors.N_PROCESSBLUE));
		assertEquals(DviPsColors.RAWSIENNA, DviPsColors.getColour(DviPsColors.N_RAWSIENNA));
		assertEquals(DviPsColors.RED_ORANGE, DviPsColors.getColour(DviPsColors.N_RED_ORANGE));
		assertEquals(DviPsColors.REDVIOLET, DviPsColors.getColour(DviPsColors.N_REDVIOLET));
		assertEquals(DviPsColors.RHODAMINE, DviPsColors.getColour(DviPsColors.N_RHODAMINE));
		assertEquals(DviPsColors.ROYALBLUE, DviPsColors.getColour(DviPsColors.N_ROYALBLUE));
		assertEquals(DviPsColors.ROYALPURPLE, DviPsColors.getColour(DviPsColors.N_ROYALPURPLE));
		assertEquals(DviPsColors.RUBINERED, DviPsColors.getColour(DviPsColors.N_RUBINERED));
		assertEquals(DviPsColors.SALMON, DviPsColors.getColour(DviPsColors.N_SALMON));
		assertEquals(DviPsColors.SEAGREEN, DviPsColors.getColour(DviPsColors.N_SEAGREEN));
		assertEquals(DviPsColors.SEPIA, DviPsColors.getColour(DviPsColors.N_SEPIA));
		assertEquals(DviPsColors.SKYBLUE, DviPsColors.getColour(DviPsColors.N_SKYBLUE));
		assertEquals(DviPsColors.SPRINGGREEN, DviPsColors.getColour(DviPsColors.N_SPRINGGREEN));
		assertEquals(DviPsColors.TAN, DviPsColors.getColour(DviPsColors.N_TAN));
		assertEquals(DviPsColors.TEALBLUE, DviPsColors.getColour(DviPsColors.N_TEALBLUE));
		assertEquals(DviPsColors.THISTLE, DviPsColors.getColour(DviPsColors.N_THISTLE));
		assertEquals(DviPsColors.TURQUOISE, DviPsColors.getColour(DviPsColors.N_TURQUOISE));
		assertEquals(DviPsColors.VIOLETRED, DviPsColors.getColour(DviPsColors.N_VIOLETRED));
		assertEquals(DviPsColors.WILDSTRAWBERRY, DviPsColors.getColour(DviPsColors.N_WILDSTRAWBERRY));
		assertEquals(DviPsColors.YELLOW_ORANGE, DviPsColors.getColour(DviPsColors.N_YELLOW_ORANGE));
		assertEquals(DviPsColors.YELLOWGREEN, DviPsColors.getColour(DviPsColors.N_YELLOWGREEN));
	}





	@Test
	public void testAddUserColor()
	{
		Color c2 = new Color(218, 29, 78);
		String nameColour = "testColour";
		
		DviPsColors.addUserColour(c2, nameColour);
		assertEquals(nameColour, DviPsColors.getColourName(c2));
	}





	@Test
	public void testGetUserColorsCode()
	{
		Color c = new Color(230, 65, 78);
		String nameColour = "testColour2";
		
		DviPsColors.addUserColour(c, nameColour);
		
		assertNotNull(DviPsColors.getUserColoursCode(null));
		assertNotNull(DviPsColors.getUserColoursCode("coucou"));
	}





	@Test
	public void testGetUserColorCode()
	{
		Color c = new Color(30, 65, 78);
		String nameColour = "testColour3";
		
		assertNull(DviPsColors.getUsercolourCode(-1));
		assertNull(DviPsColors.getUsercolourCode(10000000));
		
		DviPsColors.addUserColour(c, nameColour);
		
		assertNotNull(DviPsColors.getUsercolourCode(0));
	}

	
	
	@Test
	public void testCMYK2RGB()
	{
		try
		{
			DviPsColors.CMYK2RGB(-1, 0.5, 0.5, 0.5);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.CMYK2RGB(2, 0.5, 0.5, 0.5);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.CMYK2RGB(0.5, -1, 0.5, 0.5);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.CMYK2RGB(0.5, 2, 0.5, 0.5);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.CMYK2RGB(0.5, 0.5, -1, 0.5);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.CMYK2RGB(0.5, 0.5, 2, 0.5);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.CMYK2RGB(0.5, 0.5, 0.5, -1);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.CMYK2RGB(0.5, 0.5, 0.5, 2);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		assertEquals(new Color(51, 92, 71), DviPsColors.CMYK2RGB(0.5, 0.1, 0.3, 0.6));
	}
	
	
	
	@Test
	public void testGray2RBG()
	{
		try
		{
			DviPsColors.gray2RBG(-10);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		try
		{
			DviPsColors.gray2RBG(300);
			fail();
		}catch(IllegalArgumentException e) { /* Good. */ }
		
		assertEquals(new Color(255, 255, 255), DviPsColors.gray2RBG(1));
	}
}
