/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.intentions;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/intentions")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class IntentionTestGenerated extends AbstractIntentionTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInIntentions() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
    }

    @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddAnnotationUseSiteTarget extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddAnnotationUseSiteTarget() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hasAnnotationArgs.kt")
        public void testHasAnnotationArgs() throws Exception {
            runTest("idea/testData/intentions/addAnnotationUseSiteTarget/hasAnnotationArgs.kt");
        }

        @TestMetadata("hasTarget1.kt")
        public void testHasTarget1() throws Exception {
            runTest("idea/testData/intentions/addAnnotationUseSiteTarget/hasTarget1.kt");
        }

        @TestMetadata("hasTarget2.kt")
        public void testHasTarget2() throws Exception {
            runTest("idea/testData/intentions/addAnnotationUseSiteTarget/hasTarget2.kt");
        }

        @TestMetadata("hasTarget3.kt")
        public void testHasTarget3() throws Exception {
            runTest("idea/testData/intentions/addAnnotationUseSiteTarget/hasTarget3.kt");
        }

        @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/constructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constructor extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/constructor"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("parameter.kt")
            public void testParameter() throws Exception {
                runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/parameter.kt");
            }

            @TestMetadata("secondary.kt")
            public void testSecondary() throws Exception {
                runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/secondary.kt");
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Val extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInVal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/val/setparam.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Var extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInVar() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/constructor/var/setparam.kt");
                }
            }
        }

        @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/extension")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Extension extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInExtension() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/extension"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Function extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFunction() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/function/setparam.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/extension/property/setparam.kt");
                }
            }
        }

        @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/property"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/local.kt");
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Delegate extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDelegate() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/delegate/setparam.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/property/val")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Val extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInVal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/property/val"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/val/setparam.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ValNoBacking extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInValNoBacking() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/valNoBacking/setparam.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/property/var")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Var extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInVar() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/property/var"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/var/setparam.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class VarNoBacking extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInVarNoBacking() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("delegate.kt")
                public void testDelegate() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/delegate.kt");
                }

                @TestMetadata("field.kt")
                public void testField() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/field.kt");
                }

                @TestMetadata("file.kt")
                public void testFile() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/file.kt");
                }

                @TestMetadata("get.kt")
                public void testGet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/get.kt");
                }

                @TestMetadata("param.kt")
                public void testParam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/param.kt");
                }

                @TestMetadata("property.kt")
                public void testProperty() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/property.kt");
                }

                @TestMetadata("receiver.kt")
                public void testReceiver() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/receiver.kt");
                }

                @TestMetadata("set.kt")
                public void testSet() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/set.kt");
                }

                @TestMetadata("setparam.kt")
                public void testSetparam() throws Exception {
                    runTest("idea/testData/intentions/addAnnotationUseSiteTarget/property/varNoBacking/setparam.kt");
                }
            }
        }
    }

    @TestMetadata("idea/testData/intentions/addBraces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddBraces extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addBracesForDoWhile.kt")
        public void testAddBracesForDoWhile() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForDoWhile.kt");
        }

        @TestMetadata("addBracesForElse.kt")
        public void testAddBracesForElse() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForElse.kt");
        }

        @TestMetadata("addBracesForElseWithCommentInsideIf.kt")
        public void testAddBracesForElseWithCommentInsideIf() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForElseWithCommentInsideIf.kt");
        }

        @TestMetadata("addBracesForElseWithCommentInsideWhen.kt")
        public void testAddBracesForElseWithCommentInsideWhen() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForElseWithCommentInsideWhen.kt");
        }

        @TestMetadata("addBracesForFor.kt")
        public void testAddBracesForFor() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForFor.kt");
        }

        @TestMetadata("addBracesForIf.kt")
        public void testAddBracesForIf() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForIf.kt");
        }

        @TestMetadata("addBracesForIfWithIndent.kt")
        public void testAddBracesForIfWithIndent() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForIfWithIndent.kt");
        }

        @TestMetadata("addBracesForIfWithIndent2.kt")
        public void testAddBracesForIfWithIndent2() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForIfWithIndent2.kt");
        }

        @TestMetadata("addBracesForIfWithIndent3.kt")
        public void testAddBracesForIfWithIndent3() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForIfWithIndent3.kt");
        }

        @TestMetadata("addBracesForIfWithNoSpace.kt")
        public void testAddBracesForIfWithNoSpace() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForIfWithNoSpace.kt");
        }

        @TestMetadata("addBracesForIfWithSemicolon.kt")
        public void testAddBracesForIfWithSemicolon() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForIfWithSemicolon.kt");
        }

        @TestMetadata("addBracesForIfWithSemicolonAndExpression.kt")
        public void testAddBracesForIfWithSemicolonAndExpression() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForIfWithSemicolonAndExpression.kt");
        }

        @TestMetadata("addBracesForSingleLineIfWithCommentBeneath.kt")
        public void testAddBracesForSingleLineIfWithCommentBeneath() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForSingleLineIfWithCommentBeneath.kt");
        }

        @TestMetadata("addBracesForSingleLineIfWithCommentBeneath2.kt")
        public void testAddBracesForSingleLineIfWithCommentBeneath2() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForSingleLineIfWithCommentBeneath2.kt");
        }

        @TestMetadata("addBracesForSingleLineIfWithCommentBeneath3.kt")
        public void testAddBracesForSingleLineIfWithCommentBeneath3() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForSingleLineIfWithCommentBeneath3.kt");
        }

        @TestMetadata("addBracesForWhile.kt")
        public void testAddBracesForWhile() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesForWhile.kt");
        }

        @TestMetadata("addBracesWithBraces.kt")
        public void testAddBracesWithBraces() throws Exception {
            runTest("idea/testData/intentions/addBraces/addBracesWithBraces.kt");
        }

        public void testAllFilesPresentInAddBraces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addBraces"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doWhileWithComment.kt")
        public void testDoWhileWithComment() throws Exception {
            runTest("idea/testData/intentions/addBraces/doWhileWithComment.kt");
        }

        @TestMetadata("elseWithComment.kt")
        public void testElseWithComment() throws Exception {
            runTest("idea/testData/intentions/addBraces/elseWithComment.kt");
        }

        @TestMetadata("forWithComment.kt")
        public void testForWithComment() throws Exception {
            runTest("idea/testData/intentions/addBraces/forWithComment.kt");
        }

        @TestMetadata("ifElseWithComment.kt")
        public void testIfElseWithComment() throws Exception {
            runTest("idea/testData/intentions/addBraces/ifElseWithComment.kt");
        }

        @TestMetadata("ifWithComment.kt")
        public void testIfWithComment() throws Exception {
            runTest("idea/testData/intentions/addBraces/ifWithComment.kt");
        }

        @TestMetadata("notInsideElseIfBlock.kt")
        public void testNotInsideElseIfBlock() throws Exception {
            runTest("idea/testData/intentions/addBraces/notInsideElseIfBlock.kt");
        }

        @TestMetadata("whenHasBraces.kt")
        public void testWhenHasBraces() throws Exception {
            runTest("idea/testData/intentions/addBraces/whenHasBraces.kt");
        }

        @TestMetadata("whenSimple.kt")
        public void testWhenSimple() throws Exception {
            runTest("idea/testData/intentions/addBraces/whenSimple.kt");
        }

        @TestMetadata("whenWithComment.kt")
        public void testWhenWithComment() throws Exception {
            runTest("idea/testData/intentions/addBraces/whenWithComment.kt");
        }

        @TestMetadata("whileWithComment.kt")
        public void testWhileWithComment() throws Exception {
            runTest("idea/testData/intentions/addBraces/whileWithComment.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addConstModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddConstModifier extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddConstModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addConstModifier"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicableToConst.kt")
        public void testInapplicableToConst() throws Exception {
            runTest("idea/testData/intentions/addConstModifier/inapplicableToConst.kt");
        }

        @TestMetadata("inapplicableToOverride.kt")
        public void testInapplicableToOverride() throws Exception {
            runTest("idea/testData/intentions/addConstModifier/inapplicableToOverride.kt");
        }

        @TestMetadata("removeJvmField.kt")
        public void testRemoveJvmField() throws Exception {
            runTest("idea/testData/intentions/addConstModifier/removeJvmField.kt");
        }

        @TestMetadata("removeJvmStatic.kt")
        public void testRemoveJvmStatic() throws Exception {
            runTest("idea/testData/intentions/addConstModifier/removeJvmStatic.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/addConstModifier/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addForLoopIndices")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddForLoopIndices extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddForLoopIndices() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addForLoopIndices"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("explicitParamType.kt")
        public void testExplicitParamType() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/explicitParamType.kt");
        }

        @TestMetadata("inapplicableDestructuringDeclaration.kt")
        public void testInapplicableDestructuringDeclaration() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/inapplicableDestructuringDeclaration.kt");
        }

        @TestMetadata("inapplicableExistingIndices.kt")
        public void testInapplicableExistingIndices() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/inapplicableExistingIndices.kt");
        }

        @TestMetadata("inapplicableInBody.kt")
        public void testInapplicableInBody() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/inapplicableInBody.kt");
        }

        @TestMetadata("inapplicableOnMap.kt")
        public void testInapplicableOnMap() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/inapplicableOnMap.kt");
        }

        @TestMetadata("inapplicableOverridenFunction.kt")
        public void testInapplicableOverridenFunction() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/inapplicableOverridenFunction.kt");
        }

        @TestMetadata("inapplicableUnresolved.kt")
        public void testInapplicableUnresolved() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/inapplicableUnresolved.kt");
        }

        @TestMetadata("intArray.kt")
        public void testIntArray() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/intArray.kt");
        }

        @TestMetadata("iterable.kt")
        public void testIterable() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/iterable.kt");
        }

        @TestMetadata("noBody.kt")
        public void testNoBody() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/noBody.kt");
        }

        @TestMetadata("objectArray.kt")
        public void testObjectArray() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/objectArray.kt");
        }

        @TestMetadata("sequence.kt")
        public void testSequence() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/sequence.kt");
        }

        @TestMetadata("simpleIntList.kt")
        public void testSimpleIntList() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/simpleIntList.kt");
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("idea/testData/intentions/addForLoopIndices/string.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addJvmOverloads")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddJvmOverloads extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddJvmOverloads() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addJvmOverloads"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyHasAnnotation.kt")
        public void testAlreadyHasAnnotation() throws Exception {
            runTest("idea/testData/intentions/addJvmOverloads/alreadyHasAnnotation.kt");
        }

        @TestMetadata("method.kt")
        public void testMethod() throws Exception {
            runTest("idea/testData/intentions/addJvmOverloads/method.kt");
        }

        @TestMetadata("noDefaultParams.kt")
        public void testNoDefaultParams() throws Exception {
            runTest("idea/testData/intentions/addJvmOverloads/noDefaultParams.kt");
        }

        @TestMetadata("primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/addJvmOverloads/primaryConstructor.kt");
        }

        @TestMetadata("primaryConstructorOneWithDefault.kt")
        public void testPrimaryConstructorOneWithDefault() throws Exception {
            runTest("idea/testData/intentions/addJvmOverloads/primaryConstructorOneWithDefault.kt");
        }

        @TestMetadata("primaryConstructorWithConstructorKeyword.kt")
        public void testPrimaryConstructorWithConstructorKeyword() throws Exception {
            runTest("idea/testData/intentions/addJvmOverloads/primaryConstructorWithConstructorKeyword.kt");
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/addJvmOverloads/secondaryConstructor.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addJvmStatic")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddJvmStatic extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractVal.kt")
        public void testAbstractVal() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/abstractVal.kt");
        }

        public void testAllFilesPresentInAddJvmStatic() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addJvmStatic"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constVal.kt")
        public void testConstVal() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/constVal.kt");
        }

        @TestMetadata("funInAnonymousObject.kt")
        public void testFunInAnonymousObject() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/funInAnonymousObject.kt");
        }

        @TestMetadata("funInClass.kt")
        public void testFunInClass() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/funInClass.kt");
        }

        @TestMetadata("funWithJvmStatic.kt")
        public void testFunWithJvmStatic() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/funWithJvmStatic.kt");
        }

        @TestMetadata("openVal.kt")
        public void testOpenVal() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/openVal.kt");
        }

        @TestMetadata("overrideVal.kt")
        public void testOverrideVal() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/overrideVal.kt");
        }

        @TestMetadata("topLevelFun.kt")
        public void testTopLevelFun() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/topLevelFun.kt");
        }

        @TestMetadata("topLevelVal.kt")
        public void testTopLevelVal() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/topLevelVal.kt");
        }

        @TestMetadata("valInAnonymousObject.kt")
        public void testValInAnonymousObject() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/valInAnonymousObject.kt");
        }

        @TestMetadata("valInClass.kt")
        public void testValInClass() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/valInClass.kt");
        }

        @TestMetadata("valWithJvmField.kt")
        public void testValWithJvmField() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/valWithJvmField.kt");
        }

        @TestMetadata("valWithJvmStatic.kt")
        public void testValWithJvmStatic() throws Exception {
            runTest("idea/testData/intentions/addJvmStatic/valWithJvmStatic.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addLabeledReturnInLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddLabeledReturnInLambda extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddLabeledReturnInLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addLabeledReturnInLambda"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("insideParenthesis.kt")
        public void testInsideParenthesis() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/insideParenthesis.kt");
        }

        @TestMetadata("labeledLambda.kt")
        public void testLabeledLambda() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/labeledLambda.kt");
        }

        @TestMetadata("loop.kt")
        public void testLoop() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/loop.kt");
        }

        @TestMetadata("multipleBlocks.kt")
        public void testMultipleBlocks() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/multipleBlocks.kt");
        }

        @TestMetadata("multipleHighOrderFun.kt")
        public void testMultipleHighOrderFun() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/multipleHighOrderFun.kt");
        }

        @TestMetadata("multipleHighOrderFun2.kt")
        public void testMultipleHighOrderFun2() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/multipleHighOrderFun2.kt");
        }

        @TestMetadata("normal.kt")
        public void testNormal() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/normal.kt");
        }

        @TestMetadata("notLast.kt")
        public void testNotLast() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/notLast.kt");
        }

        @TestMetadata("returnStatement.kt")
        public void testReturnStatement() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/returnStatement.kt");
        }

        @TestMetadata("suspend.kt")
        public void testSuspend() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/suspend.kt");
        }

        @TestMetadata("unit.kt")
        public void testUnit() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/unit.kt");
        }

        @TestMetadata("withLabeledReturn.kt")
        public void testWithLabeledReturn() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/withLabeledReturn.kt");
        }

        @TestMetadata("withReturn.kt")
        public void testWithReturn() throws Exception {
            runTest("idea/testData/intentions/addLabeledReturnInLambda/withReturn.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addMissingDestructuring")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddMissingDestructuring extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddMissingDestructuring() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addMissingDestructuring"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notAvailable.kt")
        public void testNotAvailable() throws Exception {
            runTest("idea/testData/intentions/addMissingDestructuring/notAvailable.kt");
        }

        @TestMetadata("sameName.kt")
        public void testSameName() throws Exception {
            runTest("idea/testData/intentions/addMissingDestructuring/sameName.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/addMissingDestructuring/simple.kt");
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            runTest("idea/testData/intentions/addMissingDestructuring/var.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addNameToArgument")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddNameToArgument extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddNameToArgument() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addNameToArgument"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyNamed.kt")
        public void testAlreadyNamed() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/alreadyNamed.kt");
        }

        @TestMetadata("ambiguousCall.kt")
        public void testAmbiguousCall() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/ambiguousCall.kt");
        }

        @TestMetadata("beforeOtherNamed.kt")
        public void testBeforeOtherNamed() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/beforeOtherNamed.kt");
        }

        @TestMetadata("functionLiteralArgument.kt")
        public void testFunctionLiteralArgument() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/functionLiteralArgument.kt");
        }

        @TestMetadata("genericCall.kt")
        public void testGenericCall() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/genericCall.kt");
        }

        @TestMetadata("incompleteCall.kt")
        public void testIncompleteCall() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/incompleteCall.kt");
        }

        @TestMetadata("javaMethod.kt")
        public void testJavaMethod() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/javaMethod.kt");
        }

        @TestMetadata("kt11679.kt")
        public void testKt11679() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/kt11679.kt");
        }

        @TestMetadata("notInsideIndices.kt")
        public void testNotInsideIndices() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/notInsideIndices.kt");
        }

        @TestMetadata("notInsideNestedArgumentList.kt")
        public void testNotInsideNestedArgumentList() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/notInsideNestedArgumentList.kt");
        }

        @TestMetadata("notInsideNestedArgumentList2.kt")
        public void testNotInsideNestedArgumentList2() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/notInsideNestedArgumentList2.kt");
        }

        @TestMetadata("notLast.kt")
        public void testNotLast() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/notLast.kt");
        }

        @TestMetadata("notResolved.kt")
        public void testNotResolved() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/notResolved.kt");
        }

        @TestMetadata("rangeForLambda1.kt")
        public void testRangeForLambda1() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/rangeForLambda1.kt");
        }

        @TestMetadata("rangeForLambda2.kt")
        public void testRangeForLambda2() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/rangeForLambda2.kt");
        }

        @TestMetadata("rangeForLambda3.kt")
        public void testRangeForLambda3() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/rangeForLambda3.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/simple.kt");
        }

        @TestMetadata("superClassConstructor.kt")
        public void testSuperClassConstructor() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/superClassConstructor.kt");
        }

        @TestMetadata("vararg1.kt")
        public void testVararg1() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/vararg1.kt");
        }

        @TestMetadata("vararg2.kt")
        public void testVararg2() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/vararg2.kt");
        }

        @TestMetadata("vararg3.kt")
        public void testVararg3() throws Exception {
            runTest("idea/testData/intentions/addNameToArgument/vararg3.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addNamesToCallArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddNamesToCallArguments extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddNamesToCallArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addNamesToCallArguments"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("allNamed.kt")
        public void testAllNamed() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/allNamed.kt");
        }

        @TestMetadata("ambiguousCall.kt")
        public void testAmbiguousCall() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/ambiguousCall.kt");
        }

        @TestMetadata("genericCall.kt")
        public void testGenericCall() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/genericCall.kt");
        }

        @TestMetadata("incompleteCall.kt")
        public void testIncompleteCall() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/incompleteCall.kt");
        }

        @TestMetadata("javaMethod.kt")
        public void testJavaMethod() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/javaMethod.kt");
        }

        @TestMetadata("notOnCallee.kt")
        public void testNotOnCallee() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/notOnCallee.kt");
        }

        @TestMetadata("notResolved.kt")
        public void testNotResolved() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/notResolved.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/simple.kt");
        }

        @TestMetadata("superClassConstructor.kt")
        public void testSuperClassConstructor() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/superClassConstructor.kt");
        }

        @TestMetadata("trailingLambda.kt")
        public void testTrailingLambda() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/trailingLambda.kt");
        }

        @TestMetadata("varargMultiple.kt")
        public void testVarargMultiple() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/varargMultiple.kt");
        }

        @TestMetadata("varargSingle.kt")
        public void testVarargSingle() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/varargSingle.kt");
        }

        @TestMetadata("varargSingleWithSpread.kt")
        public void testVarargSingleWithSpread() throws Exception {
            runTest("idea/testData/intentions/addNamesToCallArguments/varargSingleWithSpread.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addOpenModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddOpenModifier extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractClass.kt")
        public void testAbstractClass() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/abstractClass.kt");
        }

        @TestMetadata("abstractFunction.kt")
        public void testAbstractFunction() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/abstractFunction.kt");
        }

        public void testAllFilesPresentInAddOpenModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addOpenModifier"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyOpen.kt")
        public void testAlreadyOpen() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/alreadyOpen.kt");
        }

        @TestMetadata("destructuringDeclaration.kt")
        public void testDestructuringDeclaration() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/destructuringDeclaration.kt");
        }

        @TestMetadata("enumClass.kt")
        public void testEnumClass() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/enumClass.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/function.kt");
        }

        @TestMetadata("interface.kt")
        public void testInterface() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/interface.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/localFunction.kt");
        }

        @TestMetadata("localProperty.kt")
        public void testLocalProperty() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/localProperty.kt");
        }

        @TestMetadata("notOpen.kt")
        public void testNotOpen() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/notOpen.kt");
        }

        @TestMetadata("parameter.kt")
        public void testParameter() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/parameter.kt");
        }

        @TestMetadata("private.kt")
        public void testPrivate() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/private.kt");
        }

        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/property.kt");
        }

        @TestMetadata("sealedClass.kt")
        public void testSealedClass() throws Exception {
            runTest("idea/testData/intentions/addOpenModifier/sealedClass.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addOperatorModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddOperatorModifier extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddOperatorModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addOperatorModifier"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("containsBool.kt")
        public void testContainsBool() throws Exception {
            runTest("idea/testData/intentions/addOperatorModifier/containsBool.kt");
        }

        @TestMetadata("containsInt.kt")
        public void testContainsInt() throws Exception {
            runTest("idea/testData/intentions/addOperatorModifier/containsInt.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("idea/testData/intentions/addOperatorModifier/extension.kt");
        }

        @TestMetadata("forOverride.kt")
        public void testForOverride() throws Exception {
            runTest("idea/testData/intentions/addOperatorModifier/forOverride.kt");
        }

        @TestMetadata("overridden.kt")
        public void testOverridden() throws Exception {
            runTest("idea/testData/intentions/addOperatorModifier/overridden.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/addOperatorModifier/simple.kt");
        }

        @TestMetadata("toplevel.kt")
        public void testToplevel() throws Exception {
            runTest("idea/testData/intentions/addOperatorModifier/toplevel.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addPropertyAccessors")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddPropertyAccessors extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddPropertyAccessors() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addPropertyAccessors"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/addPropertyAccessors/both")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Both extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("abstract.kt")
            public void testAbstract() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/abstract.kt");
            }

            public void testAllFilesPresentInBoth() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addPropertyAccessors/both"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/delegate.kt");
            }

            @TestMetadata("hasAccessor.kt")
            public void testHasAccessor() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/hasAccessor.kt");
            }

            @TestMetadata("hasGetter.kt")
            public void testHasGetter() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/hasGetter.kt");
            }

            @TestMetadata("hasSetter.kt")
            public void testHasSetter() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/hasSetter.kt");
            }

            @TestMetadata("jvmField.kt")
            public void testJvmField() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/jvmField.kt");
            }

            @TestMetadata("lateinit.kt")
            public void testLateinit() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/lateinit.kt");
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/local.kt");
            }

            @TestMetadata("noType.kt")
            public void testNoType() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/noType.kt");
            }

            @TestMetadata("top.kt")
            public void testTop() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/top.kt");
            }

            @TestMetadata("val.kt")
            public void testVal() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/val.kt");
            }

            @TestMetadata("var.kt")
            public void testVar() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/both/var.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/addPropertyAccessors/getter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Getter extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("abstract.kt")
            public void testAbstract() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/abstract.kt");
            }

            public void testAllFilesPresentInGetter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addPropertyAccessors/getter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/delegate.kt");
            }

            @TestMetadata("hasAccessor.kt")
            public void testHasAccessor() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/hasAccessor.kt");
            }

            @TestMetadata("hasGetter.kt")
            public void testHasGetter() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/hasGetter.kt");
            }

            @TestMetadata("hasSetter.kt")
            public void testHasSetter() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/hasSetter.kt");
            }

            @TestMetadata("header.kt")
            public void testHeader() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/header.kt");
            }

            @TestMetadata("jvmField.kt")
            public void testJvmField() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/jvmField.kt");
            }

            @TestMetadata("lateinit.kt")
            public void testLateinit() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/lateinit.kt");
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/local.kt");
            }

            @TestMetadata("noType.kt")
            public void testNoType() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/noType.kt");
            }

            @TestMetadata("top.kt")
            public void testTop() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/top.kt");
            }

            @TestMetadata("val.kt")
            public void testVal() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/val.kt");
            }

            @TestMetadata("var.kt")
            public void testVar() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/getter/var.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/addPropertyAccessors/setter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Setter extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("abstract.kt")
            public void testAbstract() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/abstract.kt");
            }

            public void testAllFilesPresentInSetter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addPropertyAccessors/setter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("delegate.kt")
            public void testDelegate() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/delegate.kt");
            }

            @TestMetadata("hasAccessor.kt")
            public void testHasAccessor() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/hasAccessor.kt");
            }

            @TestMetadata("hasGetter.kt")
            public void testHasGetter() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/hasGetter.kt");
            }

            @TestMetadata("hasSetter.kt")
            public void testHasSetter() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/hasSetter.kt");
            }

            @TestMetadata("jvmField.kt")
            public void testJvmField() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/jvmField.kt");
            }

            @TestMetadata("lateinit.kt")
            public void testLateinit() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/lateinit.kt");
            }

            @TestMetadata("local.kt")
            public void testLocal() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/local.kt");
            }

            @TestMetadata("noType.kt")
            public void testNoType() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/noType.kt");
            }

            @TestMetadata("top.kt")
            public void testTop() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/top.kt");
            }

            @TestMetadata("val.kt")
            public void testVal() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/val.kt");
            }

            @TestMetadata("var.kt")
            public void testVar() throws Exception {
                runTest("idea/testData/intentions/addPropertyAccessors/setter/var.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/addThrowsAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddThrowsAnnotation extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddThrowsAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addThrowsAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fqName.kt")
        public void testFqName() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/fqName.kt");
        }

        @TestMetadata("fqName2.kt")
        public void testFqName2() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/fqName2.kt");
        }

        @TestMetadata("functionCall.kt")
        public void testFunctionCall() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/functionCall.kt");
        }

        @TestMetadata("hasThrowsWithDifferentClassArgument.kt")
        public void testHasThrowsWithDifferentClassArgument() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithDifferentClassArgument.kt");
        }

        @TestMetadata("hasThrowsWithDifferentClassArgument2.kt")
        public void testHasThrowsWithDifferentClassArgument2() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithDifferentClassArgument2.kt");
        }

        @TestMetadata("hasThrowsWithDifferentClassArgument3.kt")
        public void testHasThrowsWithDifferentClassArgument3() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithDifferentClassArgument3.kt");
        }

        @TestMetadata("hasThrowsWithDifferentClassArgument4.kt")
        public void testHasThrowsWithDifferentClassArgument4() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithDifferentClassArgument4.kt");
        }

        @TestMetadata("hasThrowsWithDifferentClassArgument5.kt")
        public void testHasThrowsWithDifferentClassArgument5() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithDifferentClassArgument5.kt");
        }

        @TestMetadata("hasThrowsWithEmptyArgument.kt")
        public void testHasThrowsWithEmptyArgument() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithEmptyArgument.kt");
        }

        @TestMetadata("hasThrowsWithNoArgument.kt")
        public void testHasThrowsWithNoArgument() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithNoArgument.kt");
        }

        @TestMetadata("hasThrowsWithSameClassArgument.kt")
        public void testHasThrowsWithSameClassArgument() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithSameClassArgument.kt");
        }

        @TestMetadata("hasThrowsWithSameClassArgument2.kt")
        public void testHasThrowsWithSameClassArgument2() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithSameClassArgument2.kt");
        }

        @TestMetadata("hasThrowsWithSameClassArgument3.kt")
        public void testHasThrowsWithSameClassArgument3() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithSameClassArgument3.kt");
        }

        @TestMetadata("hasThrowsWithSameClassArgument4.kt")
        public void testHasThrowsWithSameClassArgument4() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/hasThrowsWithSameClassArgument4.kt");
        }

        @TestMetadata("if.kt")
        public void testIf() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/if.kt");
        }

        @TestMetadata("inConstructor.kt")
        public void testInConstructor() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inConstructor.kt");
        }

        @TestMetadata("inFunction.kt")
        public void testInFunction() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inFunction.kt");
        }

        @TestMetadata("inGetter.kt")
        public void testInGetter() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inGetter.kt");
        }

        @TestMetadata("inGetter2.kt")
        public void testInGetter2() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inGetter2.kt");
        }

        @TestMetadata("inInit.kt")
        public void testInInit() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inInit.kt");
        }

        @TestMetadata("inLambda.kt")
        public void testInLambda() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inLambda.kt");
        }

        @TestMetadata("inSetter.kt")
        public void testInSetter() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inSetter.kt");
        }

        @TestMetadata("inSetter2.kt")
        public void testInSetter2() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/inSetter2.kt");
        }

        @TestMetadata("js.kt")
        public void testJs() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/js.kt");
        }

        @TestMetadata("localException.kt")
        public void testLocalException() throws Exception {
            runTest("idea/testData/intentions/addThrowsAnnotation/localException.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addValOrVar")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddValOrVar extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addVal.kt")
        public void testAddVal() throws Exception {
            runTest("idea/testData/intentions/addValOrVar/addVal.kt");
        }

        public void testAllFilesPresentInAddValOrVar() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addValOrVar"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("idea/testData/intentions/addValOrVar/dataClass.kt");
        }

        @TestMetadata("funParameter.kt")
        public void testFunParameter() throws Exception {
            runTest("idea/testData/intentions/addValOrVar/funParameter.kt");
        }

        @TestMetadata("hasVal.kt")
        public void testHasVal() throws Exception {
            runTest("idea/testData/intentions/addValOrVar/hasVal.kt");
        }

        @TestMetadata("hasVar.kt")
        public void testHasVar() throws Exception {
            runTest("idea/testData/intentions/addValOrVar/hasVar.kt");
        }

        @TestMetadata("outOfRange.kt")
        public void testOutOfRange() throws Exception {
            runTest("idea/testData/intentions/addValOrVar/outOfRange.kt");
        }

        @TestMetadata("secondaryConstructorParameter.kt")
        public void testSecondaryConstructorParameter() throws Exception {
            runTest("idea/testData/intentions/addValOrVar/secondaryConstructorParameter.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/addWhenRemainingBranches")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddWhenRemainingBranches extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddWhenRemainingBranches() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/addWhenRemainingBranches"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("noElse.kt")
        public void testNoElse() throws Exception {
            runTest("idea/testData/intentions/addWhenRemainingBranches/noElse.kt");
        }

        @TestMetadata("noRemainingBranches.kt")
        public void testNoRemainingBranches() throws Exception {
            runTest("idea/testData/intentions/addWhenRemainingBranches/noRemainingBranches.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/addWhenRemainingBranches/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/anonymousFunctionToLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AnonymousFunctionToLambda extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAnonymousFunctionToLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/anonymousFunctionToLambda"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callMultiline.kt")
        public void testCallMultiline() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/callMultiline.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/constructor.kt");
        }

        @TestMetadata("emptyBody.kt")
        public void testEmptyBody() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/emptyBody.kt");
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/expressionBody.kt");
        }

        @TestMetadata("fullParam.kt")
        public void testFullParam() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/fullParam.kt");
        }

        @TestMetadata("moveOut.kt")
        public void testMoveOut() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/moveOut.kt");
        }

        @TestMetadata("noSpaceAfterFunctionLeftBrace.kt")
        public void testNoSpaceAfterFunctionLeftBrace() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/noSpaceAfterFunctionLeftBrace.kt");
        }

        @TestMetadata("paramName.kt")
        public void testParamName() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/paramName.kt");
        }

        @TestMetadata("replaceReturnWithExpression.kt")
        public void testReplaceReturnWithExpression() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/replaceReturnWithExpression.kt");
        }

        @TestMetadata("replaceReturnWithLabel.kt")
        public void testReplaceReturnWithLabel() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/replaceReturnWithLabel.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/anonymousFunctionToLambda/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/branched")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Branched extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInBranched() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/branched/doubleBangToIfThen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DoubleBangToIfThen extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDoubleBangToIfThen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/doubleBangToIfThen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/callExpression.kt");
            }

            @TestMetadata("callExpressionParens.kt")
            public void testCallExpressionParens() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/callExpressionParens.kt");
            }

            @TestMetadata("exceptionTextEscapesQuotes.kt")
            public void testExceptionTextEscapesQuotes() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/exceptionTextEscapesQuotes.kt");
            }

            @TestMetadata("exceptionTextHandlesMultiline.kt")
            public void testExceptionTextHandlesMultiline() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/exceptionTextHandlesMultiline.kt");
            }

            @TestMetadata("localVal.kt")
            public void testLocalVal() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/localVal.kt");
            }

            @TestMetadata("localVar.kt")
            public void testLocalVar() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/localVar.kt");
            }

            @TestMetadata("simpleNameExpressionInParens.kt")
            public void testSimpleNameExpressionInParens() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/simpleNameExpressionInParens.kt");
            }

            @TestMetadata("topLevelVal.kt")
            public void testTopLevelVal() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/topLevelVal.kt");
            }

            @TestMetadata("topLevelValCustomGetter.kt")
            public void testTopLevelValCustomGetter() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/topLevelValCustomGetter.kt");
            }

            @TestMetadata("topLevelVar.kt")
            public void testTopLevelVar() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/topLevelVar.kt");
            }

            @TestMetadata("topLevelVarCustomGetter.kt")
            public void testTopLevelVarCustomGetter() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/topLevelVarCustomGetter.kt");
            }

            @TestMetadata("usedInAssignment.kt")
            public void testUsedInAssignment() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/usedInAssignment.kt");
            }

            @TestMetadata("withAnnotation.kt")
            public void testWithAnnotation() throws Exception {
                runTest("idea/testData/intentions/branched/doubleBangToIfThen/withAnnotation.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/branched/elvisToIfThen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ElvisToIfThen extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInElvisToIfThen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/elvisToIfThen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/callExpression.kt");
            }

            @TestMetadata("callExpressionParens.kt")
            public void testCallExpressionParens() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/callExpressionParens.kt");
            }

            @TestMetadata("elvisAsExpression.kt")
            public void testElvisAsExpression() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/elvisAsExpression.kt");
            }

            @TestMetadata("fakeSafeCast.kt")
            public void testFakeSafeCast() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/fakeSafeCast.kt");
            }

            @TestMetadata("localValLhs.kt")
            public void testLocalValLhs() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/localValLhs.kt");
            }

            @TestMetadata("localVarLhs.kt")
            public void testLocalVarLhs() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/localVarLhs.kt");
            }

            @TestMetadata("longSafeCast.kt")
            public void testLongSafeCast() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/longSafeCast.kt");
            }

            @TestMetadata("safeCast.kt")
            public void testSafeCast() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/safeCast.kt");
            }

            @TestMetadata("safeCastUnstable.kt")
            public void testSafeCastUnstable() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/safeCastUnstable.kt");
            }

            @TestMetadata("simpleNameExpression.kt")
            public void testSimpleNameExpression() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/simpleNameExpression.kt");
            }

            @TestMetadata("simpleNameExpressionInParens.kt")
            public void testSimpleNameExpressionInParens() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/simpleNameExpressionInParens.kt");
            }

            @TestMetadata("simpleSafeCast.kt")
            public void testSimpleSafeCast() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/simpleSafeCast.kt");
            }

            @TestMetadata("topLevelVal.kt")
            public void testTopLevelVal() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/topLevelVal.kt");
            }

            @TestMetadata("topLevelValCustomGetter.kt")
            public void testTopLevelValCustomGetter() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/topLevelValCustomGetter.kt");
            }

            @TestMetadata("topLevelVar.kt")
            public void testTopLevelVar() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/topLevelVar.kt");
            }

            @TestMetadata("topLevelVarCustomGetter.kt")
            public void testTopLevelVarCustomGetter() throws Exception {
                runTest("idea/testData/intentions/branched/elvisToIfThen/topLevelVarCustomGetter.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/branched/folding")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Folding extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFolding() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IfToReturnAsymmetrically extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInIfToReturnAsymmetrically() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    runTest("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically/simpleIf.kt");
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    runTest("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically/simpleIfWithBlocks.kt");
                }

                @TestMetadata("simpleIfWithComments.kt")
                public void testSimpleIfWithComments() throws Exception {
                    runTest("idea/testData/intentions/branched/folding/ifToReturnAsymmetrically/simpleIfWithComments.kt");
                }
            }
        }

        @TestMetadata("idea/testData/intentions/branched/ifThenToDoubleBang")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IfThenToDoubleBang extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("acceptableEmptyElseBlockForStatement.kt")
            public void testAcceptableEmptyElseBlockForStatement() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableEmptyElseBlockForStatement.kt");
            }

            @TestMetadata("acceptableEmptyThenBlockForStatement.kt")
            public void testAcceptableEmptyThenBlockForStatement() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableEmptyThenBlockForStatement.kt");
            }

            @TestMetadata("acceptableWithoutElseBlockForStatementWithFun.kt")
            public void testAcceptableWithoutElseBlockForStatementWithFun() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableWithoutElseBlockForStatementWithFun.kt");
            }

            @TestMetadata("acceptableWithoutElseBlockForStatementWithVal.kt")
            public void testAcceptableWithoutElseBlockForStatementWithVal() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/acceptableWithoutElseBlockForStatementWithVal.kt");
            }

            public void testAllFilesPresentInIfThenToDoubleBang() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifThenToDoubleBang"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("applicableForLocalStableVar.kt")
            public void testApplicableForLocalStableVar() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/applicableForLocalStableVar.kt");
            }

            @TestMetadata("blockHasMoreThanOneStatement.kt")
            public void testBlockHasMoreThanOneStatement() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/blockHasMoreThanOneStatement.kt");
            }

            @TestMetadata("blockUsesDifferentVar.kt")
            public void testBlockUsesDifferentVar() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/blockUsesDifferentVar.kt");
            }

            @TestMetadata("conditionComparesNullWithNull.kt")
            public void testConditionComparesNullWithNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/conditionComparesNullWithNull.kt");
            }

            @TestMetadata("conditionInvalidBinaryExp.kt")
            public void testConditionInvalidBinaryExp() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/conditionInvalidBinaryExp.kt");
            }

            @TestMetadata("conditionNotBinaryExpr.kt")
            public void testConditionNotBinaryExpr() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/conditionNotBinaryExpr.kt");
            }

            @TestMetadata("doesNotinlineValueIfUsedMoreThanOnce.kt")
            public void testDoesNotinlineValueIfUsedMoreThanOnce() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/doesNotinlineValueIfUsedMoreThanOnce.kt");
            }

            @TestMetadata("doesNotinlineValueOutsideOfScope.kt")
            public void testDoesNotinlineValueOutsideOfScope() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/doesNotinlineValueOutsideOfScope.kt");
            }

            @TestMetadata("emptyCondition.kt")
            public void testEmptyCondition() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/emptyCondition.kt");
            }

            @TestMetadata("emptyElseBlock.kt")
            public void testEmptyElseBlock() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/emptyElseBlock.kt");
            }

            @TestMetadata("emptyThenBlock.kt")
            public void testEmptyThenBlock() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/emptyThenBlock.kt");
            }

            @TestMetadata("ifAndElseBothInBlocks.kt")
            public void testIfAndElseBothInBlocks() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/ifAndElseBothInBlocks.kt");
            }

            @TestMetadata("ifAndElseNotInBlocks.kt")
            public void testIfAndElseNotInBlocks() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/ifAndElseNotInBlocks.kt");
            }

            @TestMetadata("ifAsExpression.kt")
            public void testIfAsExpression() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/ifAsExpression.kt");
            }

            @TestMetadata("lhsEqualsNull.kt")
            public void testLhsEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/lhsEqualsNull.kt");
            }

            @TestMetadata("lhsNotEqualsNull.kt")
            public void testLhsNotEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/lhsNotEqualsNull.kt");
            }

            @TestMetadata("missingElseClause.kt")
            public void testMissingElseClause() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/missingElseClause.kt");
            }

            @TestMetadata("missingThenClause.kt")
            public void testMissingThenClause() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/missingThenClause.kt");
            }

            @TestMetadata("noCondition.kt")
            public void testNoCondition() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/noCondition.kt");
            }

            @TestMetadata("noNullInCondition.kt")
            public void testNoNullInCondition() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/noNullInCondition.kt");
            }

            @TestMetadata("notApplicableForFunction.kt")
            public void testNotApplicableForFunction() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/notApplicableForFunction.kt");
            }

            @TestMetadata("notApplicableForLocalUnstableVar.kt")
            public void testNotApplicableForLocalUnstableVar() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/notApplicableForLocalUnstableVar.kt");
            }

            @TestMetadata("nullBranchAlsoNull.kt")
            public void testNullBranchAlsoNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/nullBranchAlsoNull.kt");
            }

            @TestMetadata("otherBlockHasMoreThanOneStatement.kt")
            public void testOtherBlockHasMoreThanOneStatement() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/otherBlockHasMoreThanOneStatement.kt");
            }

            @TestMetadata("rhsEqualsNull.kt")
            public void testRhsEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/rhsEqualsNull.kt");
            }

            @TestMetadata("rhsNotEqualsNull.kt")
            public void testRhsNotEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/rhsNotEqualsNull.kt");
            }

            @TestMetadata("thenAndElseBothNull.kt")
            public void testThenAndElseBothNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/thenAndElseBothNull.kt");
            }

            @TestMetadata("this.kt")
            public void testThis() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/this.kt");
            }

            @TestMetadata("throwByFqName.kt")
            public void testThrowByFqName() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/throwByFqName.kt");
            }

            @TestMetadata("unacceptableEmptyElseBlockForExpression.kt")
            public void testUnacceptableEmptyElseBlockForExpression() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/unacceptableEmptyElseBlockForExpression.kt");
            }

            @TestMetadata("unacceptableEmptyThenBlockForExpression.kt")
            public void testUnacceptableEmptyThenBlockForExpression() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/unacceptableEmptyThenBlockForExpression.kt");
            }

            @TestMetadata("willNotInlineClassProperty.kt")
            public void testWillNotInlineClassProperty() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToDoubleBang/willNotInlineClassProperty.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/branched/ifThenToElvis")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IfThenToElvis extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInIfThenToElvis() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifThenToElvis"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("applicableForLocalStableVar.kt")
            public void testApplicableForLocalStableVar() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/applicableForLocalStableVar.kt");
            }

            @TestMetadata("blockHasMoreThanOneStatement.kt")
            public void testBlockHasMoreThanOneStatement() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/blockHasMoreThanOneStatement.kt");
            }

            @TestMetadata("blockUsesDifferentVar.kt")
            public void testBlockUsesDifferentVar() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/blockUsesDifferentVar.kt");
            }

            @TestMetadata("comparisonInElse.kt")
            public void testComparisonInElse() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/comparisonInElse.kt");
            }

            @TestMetadata("conditionComparesNullWithNull.kt")
            public void testConditionComparesNullWithNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/conditionComparesNullWithNull.kt");
            }

            @TestMetadata("conditionInvalidBinaryExp.kt")
            public void testConditionInvalidBinaryExp() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/conditionInvalidBinaryExp.kt");
            }

            @TestMetadata("conditionNotBinaryExpr.kt")
            public void testConditionNotBinaryExpr() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/conditionNotBinaryExpr.kt");
            }

            @TestMetadata("doesNotInlineVariableInMultiDeclaration.kt")
            public void testDoesNotInlineVariableInMultiDeclaration() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/doesNotInlineVariableInMultiDeclaration.kt");
            }

            @TestMetadata("doesNotinlineValueIfUsedMoreThanOnce.kt")
            public void testDoesNotinlineValueIfUsedMoreThanOnce() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/doesNotinlineValueIfUsedMoreThanOnce.kt");
            }

            @TestMetadata("doesNotinlineValueOutsideOfScope.kt")
            public void testDoesNotinlineValueOutsideOfScope() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/doesNotinlineValueOutsideOfScope.kt");
            }

            @TestMetadata("emptyCondition.kt")
            public void testEmptyCondition() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/emptyCondition.kt");
            }

            @TestMetadata("emptyElseBlock.kt")
            public void testEmptyElseBlock() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/emptyElseBlock.kt");
            }

            @TestMetadata("emptyThenBlock.kt")
            public void testEmptyThenBlock() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/emptyThenBlock.kt");
            }

            @TestMetadata("extensionFunctionInClass.kt")
            public void testExtensionFunctionInClass() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/extensionFunctionInClass.kt");
            }

            @TestMetadata("ifAndElseBothInBlocks.kt")
            public void testIfAndElseBothInBlocks() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/ifAndElseBothInBlocks.kt");
            }

            @TestMetadata("ifAndElseNotInBlocks.kt")
            public void testIfAndElseNotInBlocks() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/ifAndElseNotInBlocks.kt");
            }

            @TestMetadata("ifAsExpression.kt")
            public void testIfAsExpression() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/ifAsExpression.kt");
            }

            @TestMetadata("ifAsPartOfExpression.kt")
            public void testIfAsPartOfExpression() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/ifAsPartOfExpression.kt");
            }

            @TestMetadata("ifToElvisSwallowComments.kt")
            public void testIfToElvisSwallowComments() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/ifToElvisSwallowComments.kt");
            }

            @TestMetadata("implicitReceiver.kt")
            public void testImplicitReceiver() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/implicitReceiver.kt");
            }

            @TestMetadata("isCheck.kt")
            public void testIsCheck() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/isCheck.kt");
            }

            @TestMetadata("isCheckForNullableType.kt")
            public void testIsCheckForNullableType() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/isCheckForNullableType.kt");
            }

            @TestMetadata("isCheckForUnrelatedType.kt")
            public void testIsCheckForUnrelatedType() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/isCheckForUnrelatedType.kt");
            }

            @TestMetadata("isCheckWithSelector.kt")
            public void testIsCheckWithSelector() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/isCheckWithSelector.kt");
            }

            @TestMetadata("isCheckWithSelectorChain.kt")
            public void testIsCheckWithSelectorChain() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/isCheckWithSelectorChain.kt");
            }

            @TestMetadata("kt19666.kt")
            public void testKt19666() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/kt19666.kt");
            }

            @TestMetadata("lhsEqualsNull.kt")
            public void testLhsEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/lhsEqualsNull.kt");
            }

            @TestMetadata("lhsNotEqualsNull.kt")
            public void testLhsNotEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/lhsNotEqualsNull.kt");
            }

            @TestMetadata("missingElseClause.kt")
            public void testMissingElseClause() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/missingElseClause.kt");
            }

            @TestMetadata("missingThenClause.kt")
            public void testMissingThenClause() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/missingThenClause.kt");
            }

            @TestMetadata("noCondition.kt")
            public void testNoCondition() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/noCondition.kt");
            }

            @TestMetadata("noNullInCondition.kt")
            public void testNoNullInCondition() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/noNullInCondition.kt");
            }

            @TestMetadata("notApplicableForFunction.kt")
            public void testNotApplicableForFunction() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/notApplicableForFunction.kt");
            }

            @TestMetadata("notApplicableForLocalUnstableVar.kt")
            public void testNotApplicableForLocalUnstableVar() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/notApplicableForLocalUnstableVar.kt");
            }

            @TestMetadata("notApplicableForSimpleKotlinNPE.kt")
            public void testNotApplicableForSimpleKotlinNPE() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/notApplicableForSimpleKotlinNPE.kt");
            }

            @TestMetadata("notApplicableForSimpleNPE.kt")
            public void testNotApplicableForSimpleNPE() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/notApplicableForSimpleNPE.kt");
            }

            @TestMetadata("notIsCheck.kt")
            public void testNotIsCheck() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/notIsCheck.kt");
            }

            @TestMetadata("nullBranchAlsoNull.kt")
            public void testNullBranchAlsoNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/nullBranchAlsoNull.kt");
            }

            @TestMetadata("nullCheckWithSelector.kt")
            public void testNullCheckWithSelector() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/nullCheckWithSelector.kt");
            }

            @TestMetadata("nullCheckWithSelectorCall.kt")
            public void testNullCheckWithSelectorCall() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/nullCheckWithSelectorCall.kt");
            }

            @TestMetadata("nullCheckWithSelectorCallChain.kt")
            public void testNullCheckWithSelectorCallChain() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/nullCheckWithSelectorCallChain.kt");
            }

            @TestMetadata("nullableResultWithImplicitReceiver.kt")
            public void testNullableResultWithImplicitReceiver() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/nullableResultWithImplicitReceiver.kt");
            }

            @TestMetadata("nullableThen.kt")
            public void testNullableThen() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/nullableThen.kt");
            }

            @TestMetadata("otherBlockHasMoreThanOneStatement.kt")
            public void testOtherBlockHasMoreThanOneStatement() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/otherBlockHasMoreThanOneStatement.kt");
            }

            @TestMetadata("replaceWithLet.kt")
            public void testReplaceWithLet() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/replaceWithLet.kt");
            }

            @TestMetadata("replaceWithLetAndRenameIt.kt")
            public void testReplaceWithLetAndRenameIt() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/replaceWithLetAndRenameIt.kt");
            }

            @TestMetadata("replaceWithLetInMember.kt")
            public void testReplaceWithLetInMember() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/replaceWithLetInMember.kt");
            }

            @TestMetadata("replaceWithLetInMemberWithIs.kt")
            public void testReplaceWithLetInMemberWithIs() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/replaceWithLetInMemberWithIs.kt");
            }

            @TestMetadata("rhsEqualsNull.kt")
            public void testRhsEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/rhsEqualsNull.kt");
            }

            @TestMetadata("rhsNotEqualsNull.kt")
            public void testRhsNotEqualsNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/rhsNotEqualsNull.kt");
            }

            @TestMetadata("thenAndElseBothNull.kt")
            public void testThenAndElseBothNull() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/thenAndElseBothNull.kt");
            }

            @TestMetadata("throwsNPEwithArgument.kt")
            public void testThrowsNPEwithArgument() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/throwsNPEwithArgument.kt");
            }

            @TestMetadata("unitResult.kt")
            public void testUnitResult() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/unitResult.kt");
            }

            @TestMetadata("willNotInlineClassProperty.kt")
            public void testWillNotInlineClassProperty() throws Exception {
                runTest("idea/testData/intentions/branched/ifThenToElvis/willNotInlineClassProperty.kt");
            }

            @TestMetadata("idea/testData/intentions/branched/ifThenToElvis/inspectionData")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InspectionData extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInspectionData() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifThenToElvis/inspectionData"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }
            }
        }

        @TestMetadata("idea/testData/intentions/branched/ifWhen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IfWhen extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInIfWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifWhen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/ifWhen/ifToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class IfToWhen extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInIfToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifWhen/ifToWhen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("combinedIf.kt")
                public void testCombinedIf() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/combinedIf.kt");
                }

                @TestMetadata("comment.kt")
                public void testComment() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/comment.kt");
                }

                @TestMetadata("ifElseSwallowComments.kt")
                public void testIfElseSwallowComments() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifElseSwallowComments.kt");
                }

                @TestMetadata("ifElseSwallowReturnComment.kt")
                public void testIfElseSwallowReturnComment() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifElseSwallowReturnComment.kt");
                }

                @TestMetadata("ifElseSwallowTail.kt")
                public void testIfElseSwallowTail() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifElseSwallowTail.kt");
                }

                @TestMetadata("ifThenReturn.kt")
                public void testIfThenReturn() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifThenReturn.kt");
                }

                @TestMetadata("ifWithEqualityTests.kt")
                public void testIfWithEqualityTests() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithEqualityTests.kt");
                }

                @TestMetadata("ifWithIs.kt")
                public void testIfWithIs() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithIs.kt");
                }

                @TestMetadata("ifWithMultiConditions.kt")
                public void testIfWithMultiConditions() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithMultiConditions.kt");
                }

                @TestMetadata("ifWithNegativeIs.kt")
                public void testIfWithNegativeIs() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithNegativeIs.kt");
                }

                @TestMetadata("ifWithNegativeRangeTests.kt")
                public void testIfWithNegativeRangeTests() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithNegativeRangeTests.kt");
                }

                @TestMetadata("ifWithRangeTests.kt")
                public void testIfWithRangeTests() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithRangeTests.kt");
                }

                @TestMetadata("ifWithRangeTestsAndMultiConditions.kt")
                public void testIfWithRangeTestsAndMultiConditions() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithRangeTestsAndMultiConditions.kt");
                }

                @TestMetadata("ifWithRangeTestsAndUnparenthesizedMultiConditions.kt")
                public void testIfWithRangeTestsAndUnparenthesizedMultiConditions() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithRangeTestsAndUnparenthesizedMultiConditions.kt");
                }

                @TestMetadata("ifWithoutElse.kt")
                public void testIfWithoutElse() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/ifWithoutElse.kt");
                }

                @TestMetadata("lambdaExpression.kt")
                public void testLambdaExpression() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/lambdaExpression.kt");
                }

                @TestMetadata("lambdaExpression2.kt")
                public void testLambdaExpression2() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/lambdaExpression2.kt");
                }

                @TestMetadata("multipleIfFake.kt")
                public void testMultipleIfFake() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfFake.kt");
                }

                @TestMetadata("multipleIfWithLongBranches.kt")
                public void testMultipleIfWithLongBranches() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfWithLongBranches.kt");
                }

                @TestMetadata("multipleIfWithReturns.kt")
                public void testMultipleIfWithReturns() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfWithReturns.kt");
                }

                @TestMetadata("multipleIfWithSingleReturns.kt")
                public void testMultipleIfWithSingleReturns() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/multipleIfWithSingleReturns.kt");
                }

                @TestMetadata("onElseIf.kt")
                public void testOnElseIf() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/onElseIf.kt");
                }

                @TestMetadata("onElseIf2.kt")
                public void testOnElseIf2() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/onElseIf2.kt");
                }

                @TestMetadata("onElseIf3.kt")
                public void testOnElseIf3() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/onElseIf3.kt");
                }

                @TestMetadata("secondIfNoThen.kt")
                public void testSecondIfNoThen() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/secondIfNoThen.kt");
                }

                @TestMetadata("whenWithMultipleConditionTypes.kt")
                public void testWhenWithMultipleConditionTypes() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/whenWithMultipleConditionTypes.kt");
                }

                @TestMetadata("withAnnotation.kt")
                public void testWithAnnotation() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withAnnotation.kt");
                }

                @TestMetadata("withInternalLoop.kt")
                public void testWithInternalLoop() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withInternalLoop.kt");
                }

                @TestMetadata("withInternalLoopOnly.kt")
                public void testWithInternalLoopOnly() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withInternalLoopOnly.kt");
                }

                @TestMetadata("withLoop.kt")
                public void testWithLoop() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withLoop.kt");
                }

                @TestMetadata("withLoopDeep.kt")
                public void testWithLoopDeep() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withLoopDeep.kt");
                }

                @TestMetadata("withLoopDeepAndComments.kt")
                public void testWithLoopDeepAndComments() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withLoopDeepAndComments.kt");
                }

                @TestMetadata("withLoopExistingLabel.kt")
                public void testWithLoopExistingLabel() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withLoopExistingLabel.kt");
                }

                @TestMetadata("withLoopNoJumps.kt")
                public void testWithLoopNoJumps() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withLoopNoJumps.kt");
                }

                @TestMetadata("withLoopOriginal.kt")
                public void testWithLoopOriginal() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withLoopOriginal.kt");
                }

                @TestMetadata("withLoopThen.kt")
                public void testWithLoopThen() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/ifToWhen/withLoopThen.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/ifWhen/whenToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WhenToIf extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInWhenToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/ifWhen/whenToIf"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("comment.kt")
                public void testComment() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/comment.kt");
                }

                @TestMetadata("kt12040.kt")
                public void testKt12040() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/kt12040.kt");
                }

                @TestMetadata("kt13884.kt")
                public void testKt13884() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/kt13884.kt");
                }

                @TestMetadata("whenWithDotQualifiedExpression.kt")
                public void testWhenWithDotQualifiedExpression() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithDotQualifiedExpression.kt");
                }

                @TestMetadata("whenWithEqualityTests.kt")
                public void testWhenWithEqualityTests() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithEqualityTests.kt");
                }

                @TestMetadata("whenWithIf.kt")
                public void testWhenWithIf() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithIf.kt");
                }

                @TestMetadata("whenWithMultiConditions.kt")
                public void testWhenWithMultiConditions() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithMultiConditions.kt");
                }

                @TestMetadata("whenWithMultipleConditionTypes.kt")
                public void testWhenWithMultipleConditionTypes() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithMultipleConditionTypes.kt");
                }

                @TestMetadata("whenWithNegativePatterns.kt")
                public void testWhenWithNegativePatterns() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithNegativePatterns.kt");
                }

                @TestMetadata("whenWithNegativeRangeTests.kt")
                public void testWhenWithNegativeRangeTests() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithNegativeRangeTests.kt");
                }

                @TestMetadata("whenWithPatterns.kt")
                public void testWhenWithPatterns() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithPatterns.kt");
                }

                @TestMetadata("whenWithRangeTests.kt")
                public void testWhenWithRangeTests() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithRangeTests.kt");
                }

                @TestMetadata("whenWithRangeTestsAndMultiConditions.kt")
                public void testWhenWithRangeTestsAndMultiConditions() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithRangeTestsAndMultiConditions.kt");
                }

                @TestMetadata("whenWithoutElse.kt")
                public void testWhenWithoutElse() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithoutElse.kt");
                }

                @TestMetadata("whenWithoutSubject.kt")
                public void testWhenWithoutSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/whenWithoutSubject.kt");
                }

                @TestMetadata("wrongIsAndInNoEnd.kt")
                public void testWrongIsAndInNoEnd() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/wrongIsAndInNoEnd.kt");
                }

                @TestMetadata("wrongIsAndInNoSubject.kt")
                public void testWrongIsAndInNoSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/ifWhen/whenToIf/wrongIsAndInNoSubject.kt");
                }
            }
        }

        @TestMetadata("idea/testData/intentions/branched/safeAccessToIfThen")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SafeAccessToIfThen extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSafeAccessToIfThen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/safeAccessToIfThen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignment.kt")
            public void testAssignment() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/assignment.kt");
            }

            @TestMetadata("assignment2.kt")
            public void testAssignment2() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/assignment2.kt");
            }

            @TestMetadata("assignment3.kt")
            public void testAssignment3() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/assignment3.kt");
            }

            @TestMetadata("binaryExpressionLhs.kt")
            public void testBinaryExpressionLhs() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/binaryExpressionLhs.kt");
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/callExpression.kt");
            }

            @TestMetadata("callExpressionParens.kt")
            public void testCallExpressionParens() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/callExpressionParens.kt");
            }

            @TestMetadata("customGetterAsReceiver.kt")
            public void testCustomGetterAsReceiver() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/customGetterAsReceiver.kt");
            }

            @TestMetadata("equality.kt")
            public void testEquality() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/equality.kt");
            }

            @TestMetadata("let.kt")
            public void testLet() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/let.kt");
            }

            @TestMetadata("let2.kt")
            public void testLet2() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/let2.kt");
            }

            @TestMetadata("let3.kt")
            public void testLet3() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/let3.kt");
            }

            @TestMetadata("letNotRedundant.kt")
            public void testLetNotRedundant() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/letNotRedundant.kt");
            }

            @TestMetadata("letTopLevelVar.kt")
            public void testLetTopLevelVar() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/letTopLevelVar.kt");
            }

            @TestMetadata("localValAsReceiver.kt")
            public void testLocalValAsReceiver() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/localValAsReceiver.kt");
            }

            @TestMetadata("localValLhs.kt")
            public void testLocalValLhs() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/localValLhs.kt");
            }

            @TestMetadata("localVarLhs.kt")
            public void testLocalVarLhs() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/localVarLhs.kt");
            }

            @TestMetadata("resultAssignedToLocalVal.kt")
            public void testResultAssignedToLocalVal() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/resultAssignedToLocalVal.kt");
            }

            @TestMetadata("safeAccessAsFunctionArgument.kt")
            public void testSafeAccessAsFunctionArgument() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/safeAccessAsFunctionArgument.kt");
            }

            @TestMetadata("simpleNameExpression.kt")
            public void testSimpleNameExpression() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/simpleNameExpression.kt");
            }

            @TestMetadata("simpleNameExpressionInParens.kt")
            public void testSimpleNameExpressionInParens() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/simpleNameExpressionInParens.kt");
            }

            @TestMetadata("simplePropertyAsReceiver.kt")
            public void testSimplePropertyAsReceiver() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/simplePropertyAsReceiver.kt");
            }

            @TestMetadata("simplePropertyAsReceiver2.kt")
            public void testSimplePropertyAsReceiver2() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/simplePropertyAsReceiver2.kt");
            }

            @TestMetadata("simplePropertyAsReceiver3.kt")
            public void testSimplePropertyAsReceiver3() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/simplePropertyAsReceiver3.kt");
            }

            @TestMetadata("topLevelVal.kt")
            public void testTopLevelVal() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/topLevelVal.kt");
            }

            @TestMetadata("topLevelValCustomGetter.kt")
            public void testTopLevelValCustomGetter() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/topLevelValCustomGetter.kt");
            }

            @TestMetadata("topLevelVar.kt")
            public void testTopLevelVar() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/topLevelVar.kt");
            }

            @TestMetadata("topLevelVarCustomGetter.kt")
            public void testTopLevelVarCustomGetter() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/topLevelVarCustomGetter.kt");
            }

            @TestMetadata("usedAsFunctionRhs.kt")
            public void testUsedAsFunctionRhs() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/usedAsFunctionRhs.kt");
            }

            @TestMetadata("usedAsResultOfCheckedIf.kt")
            public void testUsedAsResultOfCheckedIf() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/usedAsResultOfCheckedIf.kt");
            }

            @TestMetadata("usedAsReturnValue.kt")
            public void testUsedAsReturnValue() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/usedAsReturnValue.kt");
            }

            @TestMetadata("usedInUncheckedIfExpression.kt")
            public void testUsedInUncheckedIfExpression() throws Exception {
                runTest("idea/testData/intentions/branched/safeAccessToIfThen/usedInUncheckedIfExpression.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/branched/unfolding")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Unfolding extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInUnfolding() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/assignmentToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AssignmentToIf extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAssignmentToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/assignmentToIf"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerIfTransformed.kt")
                public void testInnerIfTransformed() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToIf/innerIfTransformed.kt");
                }

                @TestMetadata("nestedIfs.kt")
                public void testNestedIfs() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToIf/nestedIfs.kt");
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIf.kt");
                }

                @TestMetadata("simpleIfWithAugmentedAssignment.kt")
                public void testSimpleIfWithAugmentedAssignment() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithAugmentedAssignment.kt");
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithBlocks.kt");
                }

                @TestMetadata("simpleIfWithComplexAssignmentLHS.kt")
                public void testSimpleIfWithComplexAssignmentLHS() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithComplexAssignmentLHS.kt");
                }

                @TestMetadata("simpleIfWithoutAssignment.kt")
                public void testSimpleIfWithoutAssignment() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToIf/simpleIfWithoutAssignment.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/assignmentToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AssignmentToWhen extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAssignmentToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/assignmentToWhen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerWhenTransformed.kt")
                public void testInnerWhenTransformed() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToWhen/innerWhenTransformed.kt");
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToWhen/simpleWhen.kt");
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToWhen/simpleWhenWithBlocks.kt");
                }

                @TestMetadata("simpleWhenWithComplexAssignmentLHS.kt")
                public void testSimpleWhenWithComplexAssignmentLHS() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/assignmentToWhen/simpleWhenWithComplexAssignmentLHS.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/propertyToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PropertyToIf extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPropertyToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/propertyToIf"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("nestedIfs.kt")
                public void testNestedIfs() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/nestedIfs.kt");
                }

                @TestMetadata("nestedIfs2.kt")
                public void testNestedIfs2() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/nestedIfs2.kt");
                }

                @TestMetadata("nonLocalProperty.kt")
                public void testNonLocalProperty() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/nonLocalProperty.kt");
                }

                @TestMetadata("nonLocalProperty2.kt")
                public void testNonLocalProperty2() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/nonLocalProperty2.kt");
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIf.kt");
                }

                @TestMetadata("simpleIf2.kt")
                public void testSimpleIf2() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIf2.kt");
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIfWithBlocks.kt");
                }

                @TestMetadata("simpleIfWithBlocks2.kt")
                public void testSimpleIfWithBlocks2() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIfWithBlocks2.kt");
                }

                @TestMetadata("simpleIfWithType.kt")
                public void testSimpleIfWithType() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToIf/simpleIfWithType.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/propertyToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PropertyToWhen extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPropertyToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/propertyToWhen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("nonLocalProperty.kt")
                public void testNonLocalProperty() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToWhen/nonLocalProperty.kt");
                }

                @TestMetadata("nonLocalProperty2.kt")
                public void testNonLocalProperty2() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToWhen/nonLocalProperty2.kt");
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhen.kt");
                }

                @TestMetadata("simpleWhen2.kt")
                public void testSimpleWhen2() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhen2.kt");
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhenWithBlocks.kt");
                }

                @TestMetadata("simpleWhenWithBlocks2.kt")
                public void testSimpleWhenWithBlocks2() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhenWithBlocks2.kt");
                }

                @TestMetadata("simpleWhenWithType.kt")
                public void testSimpleWhenWithType() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/propertyToWhen/simpleWhenWithType.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/returnToIf")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReturnToIf extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReturnToIf() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/returnToIf"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("ifWithBreak.kt")
                public void testIfWithBreak() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/ifWithBreak.kt");
                }

                @TestMetadata("ifWithContinue.kt")
                public void testIfWithContinue() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/ifWithContinue.kt");
                }

                @TestMetadata("ifWithInnerReturn.kt")
                public void testIfWithInnerReturn() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/ifWithInnerReturn.kt");
                }

                @TestMetadata("ifWithNothing.kt")
                public void testIfWithNothing() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/ifWithNothing.kt");
                }

                @TestMetadata("ifWithThrow.kt")
                public void testIfWithThrow() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/ifWithThrow.kt");
                }

                @TestMetadata("innerIfTransformed.kt")
                public void testInnerIfTransformed() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/innerIfTransformed.kt");
                }

                @TestMetadata("labeledReturn.kt")
                public void testLabeledReturn() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/labeledReturn.kt");
                }

                @TestMetadata("simpleIf.kt")
                public void testSimpleIf() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/simpleIf.kt");
                }

                @TestMetadata("simpleIfWithBlocks.kt")
                public void testSimpleIfWithBlocks() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToIf/simpleIfWithBlocks.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/unfolding/returnToWhen")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReturnToWhen extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReturnToWhen() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/unfolding/returnToWhen"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("innerWhenTransformed.kt")
                public void testInnerWhenTransformed() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/innerWhenTransformed.kt");
                }

                @TestMetadata("labeledReturn.kt")
                public void testLabeledReturn() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/labeledReturn.kt");
                }

                @TestMetadata("simpleWhen.kt")
                public void testSimpleWhen() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/simpleWhen.kt");
                }

                @TestMetadata("simpleWhenWithBlocks.kt")
                public void testSimpleWhenWithBlocks() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/simpleWhenWithBlocks.kt");
                }

                @TestMetadata("whenWithBreak.kt")
                public void testWhenWithBreak() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/whenWithBreak.kt");
                }

                @TestMetadata("whenWithContinue.kt")
                public void testWhenWithContinue() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/whenWithContinue.kt");
                }

                @TestMetadata("whenWithInnerReturn.kt")
                public void testWhenWithInnerReturn() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/whenWithInnerReturn.kt");
                }

                @TestMetadata("whenWithNothing.kt")
                public void testWhenWithNothing() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/whenWithNothing.kt");
                }

                @TestMetadata("whenWithThrow.kt")
                public void testWhenWithThrow() throws Exception {
                    runTest("idea/testData/intentions/branched/unfolding/returnToWhen/whenWithThrow.kt");
                }
            }
        }

        @TestMetadata("idea/testData/intentions/branched/when")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/intentions/branched/when/eliminateSubject")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class EliminateSubject extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInEliminateSubject() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when/eliminateSubject"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("lineBreaksAndComments.kt")
                public void testLineBreaksAndComments() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/lineBreaksAndComments.kt");
                }

                @TestMetadata("whenWithEqualityTests.kt")
                public void testWhenWithEqualityTests() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithEqualityTests.kt");
                }

                @TestMetadata("whenWithMultipleConditionTypes.kt")
                public void testWhenWithMultipleConditionTypes() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithMultipleConditionTypes.kt");
                }

                @TestMetadata("whenWithNegativePatterns.kt")
                public void testWhenWithNegativePatterns() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithNegativePatterns.kt");
                }

                @TestMetadata("whenWithNegativeRangeTests.kt")
                public void testWhenWithNegativeRangeTests() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithNegativeRangeTests.kt");
                }

                @TestMetadata("whenWithPatterns.kt")
                public void testWhenWithPatterns() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithPatterns.kt");
                }

                @TestMetadata("whenWithRangeTests.kt")
                public void testWhenWithRangeTests() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithRangeTests.kt");
                }

                @TestMetadata("whenWithRangeTestsAndMultiConditions.kt")
                public void testWhenWithRangeTestsAndMultiConditions() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithRangeTestsAndMultiConditions.kt");
                }

                @TestMetadata("whenWithoutSubject.kt")
                public void testWhenWithoutSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/when/eliminateSubject/whenWithoutSubject.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/when/flatten")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Flatten extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFlatten() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when/flatten"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("flattenWithSubject.kt")
                public void testFlattenWithSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/when/flatten/flattenWithSubject.kt");
                }

                @TestMetadata("flattenWithUnmatchedSubjects.kt")
                public void testFlattenWithUnmatchedSubjects() throws Exception {
                    runTest("idea/testData/intentions/branched/when/flatten/flattenWithUnmatchedSubjects.kt");
                }

                @TestMetadata("flattenWithoutSubject.kt")
                public void testFlattenWithoutSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/when/flatten/flattenWithoutSubject.kt");
                }
            }

            @TestMetadata("idea/testData/intentions/branched/when/merge")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Merge extends AbstractIntentionTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInMerge() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/branched/when/merge"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
                }

                @TestMetadata("hasCommentBetweenWhen.kt")
                public void testHasCommentBetweenWhen() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/hasCommentBetweenWhen.kt");
                }

                @TestMetadata("hasSemicolonBetweenWhen.kt")
                public void testHasSemicolonBetweenWhen() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/hasSemicolonBetweenWhen.kt");
                }

                @TestMetadata("mergeBlockWithBlock.kt")
                public void testMergeBlockWithBlock() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeBlockWithBlock.kt");
                }

                @TestMetadata("mergeBlockWithSingle.kt")
                public void testMergeBlockWithSingle() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeBlockWithSingle.kt");
                }

                @TestMetadata("mergeWithConflictingDeclarations.kt")
                public void testMergeWithConflictingDeclarations() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithConflictingDeclarations.kt");
                }

                @TestMetadata("mergeWithDeclarations.kt")
                public void testMergeWithDeclarations() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithDeclarations.kt");
                }

                @TestMetadata("mergeWithReturnAfter.kt")
                public void testMergeWithReturnAfter() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithReturnAfter.kt");
                }

                @TestMetadata("mergeWithReturnBefore.kt")
                public void testMergeWithReturnBefore() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithReturnBefore.kt");
                }

                @TestMetadata("mergeWithSubject.kt")
                public void testMergeWithSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithSubject.kt");
                }

                @TestMetadata("mergeWithUnmatchedConditions1.kt")
                public void testMergeWithUnmatchedConditions1() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions1.kt");
                }

                @TestMetadata("mergeWithUnmatchedConditions2.kt")
                public void testMergeWithUnmatchedConditions2() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions2.kt");
                }

                @TestMetadata("mergeWithUnmatchedConditions3.kt")
                public void testMergeWithUnmatchedConditions3() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions3.kt");
                }

                @TestMetadata("mergeWithUnmatchedConditions4.kt")
                public void testMergeWithUnmatchedConditions4() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions4.kt");
                }

                @TestMetadata("mergeWithUnmatchedConditions5.kt")
                public void testMergeWithUnmatchedConditions5() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions5.kt");
                }

                @TestMetadata("mergeWithUnmatchedConditions6.kt")
                public void testMergeWithUnmatchedConditions6() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions6.kt");
                }

                @TestMetadata("mergeWithUnmatchedConditions7.kt")
                public void testMergeWithUnmatchedConditions7() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedConditions7.kt");
                }

                @TestMetadata("mergeWithUnmatchedSubjects1.kt")
                public void testMergeWithUnmatchedSubjects1() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedSubjects1.kt");
                }

                @TestMetadata("mergeWithUnmatchedSubjects2.kt")
                public void testMergeWithUnmatchedSubjects2() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithUnmatchedSubjects2.kt");
                }

                @TestMetadata("mergeWithVarSubject.kt")
                public void testMergeWithVarSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithVarSubject.kt");
                }

                @TestMetadata("mergeWithoutSubject.kt")
                public void testMergeWithoutSubject() throws Exception {
                    runTest("idea/testData/intentions/branched/when/merge/mergeWithoutSubject.kt");
                }
            }
        }
    }

    @TestMetadata("idea/testData/intentions/changeVisibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeVisibility extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInChangeVisibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/internal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Internal extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInternal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/internal"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("hasJvmFieldInInterface.kt")
            public void testHasJvmFieldInInterface() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/internal/hasJvmFieldInInterface.kt");
            }

            @TestMetadata("notForAnnotationClassPrimaryConstructor.kt")
            public void testNotForAnnotationClassPrimaryConstructor() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/internal/notForAnnotationClassPrimaryConstructor.kt");
            }

            @TestMetadata("propertySetter.kt")
            public void testPropertySetter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/internal/propertySetter.kt");
            }

            @TestMetadata("propertySetterForPrivateProperty.kt")
            public void testPropertySetterForPrivateProperty() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/internal/propertySetterForPrivateProperty.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/internal/simple.kt");
            }

            @TestMetadata("valParameter.kt")
            public void testValParameter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/internal/valParameter.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/private")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Private extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("actual.kt")
            public void testActual() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/actual.kt");
            }

            @TestMetadata("actual2.kt")
            public void testActual2() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/actual2.kt");
            }

            public void testAllFilesPresentInPrivate() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/private"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotated.kt")
            public void testAnnotated() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/annotated.kt");
            }

            @TestMetadata("expect.kt")
            public void testExpect() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/expect.kt");
            }

            @TestMetadata("expect2.kt")
            public void testExpect2() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/expect2.kt");
            }

            @TestMetadata("hasModifier1.kt")
            public void testHasModifier1() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/hasModifier1.kt");
            }

            @TestMetadata("hasModifier2.kt")
            public void testHasModifier2() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/hasModifier2.kt");
            }

            @TestMetadata("hasModifier3.kt")
            public void testHasModifier3() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/hasModifier3.kt");
            }

            @TestMetadata("hasModifier4.kt")
            public void testHasModifier4() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/hasModifier4.kt");
            }

            @TestMetadata("inAnnotation.kt")
            public void testInAnnotation() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/inAnnotation.kt");
            }

            @TestMetadata("interface.kt")
            public void testInterface() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/interface.kt");
            }

            @TestMetadata("jvmField.kt")
            public void testJvmField() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/jvmField.kt");
            }

            @TestMetadata("noModifierListAnnotation.kt")
            public void testNoModifierListAnnotation() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListAnnotation.kt");
            }

            @TestMetadata("noModifierListClass.kt")
            public void testNoModifierListClass() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListClass.kt");
            }

            @TestMetadata("noModifierListConst.kt")
            public void testNoModifierListConst() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListConst.kt");
            }

            @TestMetadata("noModifierListFun.kt")
            public void testNoModifierListFun() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListFun.kt");
            }

            @TestMetadata("noModifierListInterface.kt")
            public void testNoModifierListInterface() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListInterface.kt");
            }

            @TestMetadata("noModifierListObject.kt")
            public void testNoModifierListObject() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListObject.kt");
            }

            @TestMetadata("noModifierListPrimaryConstructor.kt")
            public void testNoModifierListPrimaryConstructor() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListPrimaryConstructor.kt");
            }

            @TestMetadata("noModifierListSealed.kt")
            public void testNoModifierListSealed() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListSealed.kt");
            }

            @TestMetadata("noModifierListSecondaryConstructor.kt")
            public void testNoModifierListSecondaryConstructor() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListSecondaryConstructor.kt");
            }

            @TestMetadata("noModifierListVal.kt")
            public void testNoModifierListVal() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListVal.kt");
            }

            @TestMetadata("noModifierListValParam.kt")
            public void testNoModifierListValParam() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierListValParam.kt");
            }

            @TestMetadata("noModifierTypeAlias.kt")
            public void testNoModifierTypeAlias() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/noModifierTypeAlias.kt");
            }

            @TestMetadata("notForAbstract.kt")
            public void testNotForAbstract() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/notForAbstract.kt");
            }

            @TestMetadata("notForAnnotationClassPrimaryConstructor.kt")
            public void testNotForAnnotationClassPrimaryConstructor() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/notForAnnotationClassPrimaryConstructor.kt");
            }

            @TestMetadata("notForLocal.kt")
            public void testNotForLocal() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/notForLocal.kt");
            }

            @TestMetadata("notForParameter.kt")
            public void testNotForParameter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/notForParameter.kt");
            }

            @TestMetadata("onAnnotation.kt")
            public void testOnAnnotation() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/onAnnotation.kt");
            }

            @TestMetadata("onAnnotationParameter.kt")
            public void testOnAnnotationParameter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/onAnnotationParameter.kt");
            }

            @TestMetadata("propertyGetter.kt")
            public void testPropertyGetter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/propertyGetter.kt");
            }

            @TestMetadata("propertySetter.kt")
            public void testPropertySetter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/propertySetter.kt");
            }

            @TestMetadata("propertySetterForInternalProperty.kt")
            public void testPropertySetterForInternalProperty() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/propertySetterForInternalProperty.kt");
            }

            @TestMetadata("propertySetterForPrivateProperty.kt")
            public void testPropertySetterForPrivateProperty() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/propertySetterForPrivateProperty.kt");
            }

            @TestMetadata("propertySetterForProtectedProperty.kt")
            public void testPropertySetterForProtectedProperty() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/propertySetterForProtectedProperty.kt");
            }

            @TestMetadata("propertySetterInLocalClass.kt")
            public void testPropertySetterInLocalClass() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/propertySetterInLocalClass.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/simple.kt");
            }

            @TestMetadata("withAnnotations.kt")
            public void testWithAnnotations() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/private/withAnnotations.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/protected")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Protected extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInProtected() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/protected"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("caretAfter.kt")
            public void testCaretAfter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/caretAfter.kt");
            }

            @TestMetadata("constructorParameter.kt")
            public void testConstructorParameter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/constructorParameter.kt");
            }

            @TestMetadata("noModifier.kt")
            public void testNoModifier() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/noModifier.kt");
            }

            @TestMetadata("notForNonValParameter.kt")
            public void testNotForNonValParameter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/notForNonValParameter.kt");
            }

            @TestMetadata("notForObjectMember.kt")
            public void testNotForObjectMember() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/notForObjectMember.kt");
            }

            @TestMetadata("notForOverride.kt")
            public void testNotForOverride() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/notForOverride.kt");
            }

            @TestMetadata("notForTopLevel.kt")
            public void testNotForTopLevel() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/notForTopLevel.kt");
            }

            @TestMetadata("propertySetter.kt")
            public void testPropertySetter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/propertySetter.kt");
            }

            @TestMetadata("propertySetterForPrivateProperty.kt")
            public void testPropertySetterForPrivateProperty() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/propertySetterForPrivateProperty.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/protected/simple.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/changeVisibility/public")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Public extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPublic() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/changeVisibility/public"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("alreadyPublic.kt")
            public void testAlreadyPublic() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/alreadyPublic.kt");
            }

            @TestMetadata("destructuringPropertyException.kt")
            public void testDestructuringPropertyException() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/destructuringPropertyException.kt");
            }

            @TestMetadata("primaryConstructor.kt")
            public void testPrimaryConstructor() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/primaryConstructor.kt");
            }

            @TestMetadata("primaryConstructorPublicByDefault.kt")
            public void testPrimaryConstructorPublicByDefault() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/primaryConstructorPublicByDefault.kt");
            }

            @TestMetadata("propertyPrivateSetter.kt")
            public void testPropertyPrivateSetter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/propertyPrivateSetter.kt");
            }

            @TestMetadata("propertyPrivateSetterForPrivateProperty.kt")
            public void testPropertyPrivateSetterForPrivateProperty() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/propertyPrivateSetterForPrivateProperty.kt");
            }

            @TestMetadata("propertySetter.kt")
            public void testPropertySetter() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/propertySetter.kt");
            }

            @TestMetadata("propertySetterForPrivateProperty.kt")
            public void testPropertySetterForPrivateProperty() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/propertySetterForPrivateProperty.kt");
            }

            @TestMetadata("publicByDefault.kt")
            public void testPublicByDefault() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/publicByDefault.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/simple.kt");
            }

            @TestMetadata("typeAlias.kt")
            public void testTypeAlias() throws Exception {
                runTest("idea/testData/intentions/changeVisibility/public/typeAlias.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/chop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Chop extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInChop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/chop"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/chop/argumentList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArgumentList extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInArgumentList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/chop/argumentList"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("threeArgs.kt")
            public void testThreeArgs() throws Exception {
                runTest("idea/testData/intentions/chop/argumentList/threeArgs.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/chop/parameterList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParameterList extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInParameterList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/chop/parameterList"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("hasAllLineBreaks.kt")
            public void testHasAllLineBreaks() throws Exception {
                runTest("idea/testData/intentions/chop/parameterList/hasAllLineBreaks.kt");
            }

            @TestMetadata("hasSomeLineBreaks1.kt")
            public void testHasSomeLineBreaks1() throws Exception {
                runTest("idea/testData/intentions/chop/parameterList/hasSomeLineBreaks1.kt");
            }

            @TestMetadata("hasSomeLineBreaks2.kt")
            public void testHasSomeLineBreaks2() throws Exception {
                runTest("idea/testData/intentions/chop/parameterList/hasSomeLineBreaks2.kt");
            }

            @TestMetadata("oneParameter.kt")
            public void testOneParameter() throws Exception {
                runTest("idea/testData/intentions/chop/parameterList/oneParameter.kt");
            }

            @TestMetadata("threeParameters.kt")
            public void testThreeParameters() throws Exception {
                runTest("idea/testData/intentions/chop/parameterList/threeParameters.kt");
            }

            @TestMetadata("twoParameters.kt")
            public void testTwoParameters() throws Exception {
                runTest("idea/testData/intentions/chop/parameterList/twoParameters.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/conventionNameCalls")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConventionNameCalls extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConventionNameCalls() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceCallWithUnaryOperator extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReplaceCallWithUnaryOperator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("complexPlus.kt")
            public void testComplexPlus() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/complexPlus.kt");
            }

            @TestMetadata("dec.kt")
            public void testDec() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/dec.kt");
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/extensionFunction.kt");
            }

            @TestMetadata("functionLiteralArgument.kt")
            public void testFunctionLiteralArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/functionLiteralArgument.kt");
            }

            @TestMetadata("inc.kt")
            public void testInc() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/inc.kt");
            }

            @TestMetadata("minusSanityTest.kt")
            public void testMinusSanityTest() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/minusSanityTest.kt");
            }

            @TestMetadata("namedValueArgument.kt")
            public void testNamedValueArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/namedValueArgument.kt");
            }

            @TestMetadata("notSanityTest.kt")
            public void testNotSanityTest() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/notSanityTest.kt");
            }

            @TestMetadata("plusPlus.kt")
            public void testPlusPlus() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/plusPlus.kt");
            }

            @TestMetadata("plusSanityTest.kt")
            public void testPlusSanityTest() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/plusSanityTest.kt");
            }

            @TestMetadata("qualifier.kt")
            public void testQualifier() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/qualifier.kt");
            }

            @TestMetadata("super.kt")
            public void testSuper() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/super.kt");
            }

            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/typeArguments.kt");
            }

            @TestMetadata("unacceptableVararg.kt")
            public void testUnacceptableVararg() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/unacceptableVararg.kt");
            }

            @TestMetadata("valueArgument.kt")
            public void testValueArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceCallWithUnaryOperator/valueArgument.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceContains")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceContains extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReplaceContains() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceContains"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("containsFromJava.kt")
            public void testContainsFromJava() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/containsFromJava.kt");
            }

            @TestMetadata("containsInExpression.kt")
            public void testContainsInExpression() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/containsInExpression.kt");
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/extensionFunction.kt");
            }

            @TestMetadata("functionLiteralArgument.kt")
            public void testFunctionLiteralArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgument.kt");
            }

            @TestMetadata("functionLiteralArgumentAfterSemicolon.kt")
            public void testFunctionLiteralArgumentAfterSemicolon() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgumentAfterSemicolon.kt");
            }

            @TestMetadata("functionLiteralArgumentAtStartOfBlock.kt")
            public void testFunctionLiteralArgumentAtStartOfBlock() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgumentAtStartOfBlock.kt");
            }

            @TestMetadata("functionLiteralArgumentInExpression.kt")
            public void testFunctionLiteralArgumentInExpression() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/functionLiteralArgumentInExpression.kt");
            }

            @TestMetadata("invalidArgument.kt")
            public void testInvalidArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/invalidArgument.kt");
            }

            @TestMetadata("missingArgument.kt")
            public void testMissingArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/missingArgument.kt");
            }

            @TestMetadata("missingDefaultArgument.kt")
            public void testMissingDefaultArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/missingDefaultArgument.kt");
            }

            @TestMetadata("multipleArguments.kt")
            public void testMultipleArguments() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/multipleArguments.kt");
            }

            @TestMetadata("notContains.kt")
            public void testNotContains() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/notContains.kt");
            }

            @TestMetadata("qualifier.kt")
            public void testQualifier() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/qualifier.kt");
            }

            @TestMetadata("simpleArgument.kt")
            public void testSimpleArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/simpleArgument.kt");
            }

            @TestMetadata("simpleStringLiteral.kt")
            public void testSimpleStringLiteral() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/simpleStringLiteral.kt");
            }

            @TestMetadata("super.kt")
            public void testSuper() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/super.kt");
            }

            @TestMetadata("twoArgsContainsFromJava.kt")
            public void testTwoArgsContainsFromJava() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/twoArgsContainsFromJava.kt");
            }

            @TestMetadata("typeArguments.kt")
            public void testTypeArguments() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/typeArguments.kt");
            }

            @TestMetadata("unacceptableVararg1.kt")
            public void testUnacceptableVararg1() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/unacceptableVararg1.kt");
            }

            @TestMetadata("unacceptableVararg2.kt")
            public void testUnacceptableVararg2() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/unacceptableVararg2.kt");
            }

            @TestMetadata("withoutOperatorModifier.kt")
            public void testWithoutOperatorModifier() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceContains/withoutOperatorModifier.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/conventionNameCalls/replaceInvoke")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceInvoke extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReplaceInvoke() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/conventionNameCalls/replaceInvoke"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("expressionReceiver.kt")
            public void testExpressionReceiver() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/expressionReceiver.kt");
            }

            @TestMetadata("extensionFunction.kt")
            public void testExtensionFunction() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/extensionFunction.kt");
            }

            @TestMetadata("functionLiteralInvoke.kt")
            public void testFunctionLiteralInvoke() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/functionLiteralInvoke.kt");
            }

            @TestMetadata("invokeInExpression.kt")
            public void testInvokeInExpression() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/invokeInExpression.kt");
            }

            @TestMetadata("namedArgumentInvoke.kt")
            public void testNamedArgumentInvoke() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/namedArgumentInvoke.kt");
            }

            @TestMetadata("noArgumentInvoke.kt")
            public void testNoArgumentInvoke() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/noArgumentInvoke.kt");
            }

            @TestMetadata("typeAndValueArgument.kt")
            public void testTypeAndValueArgument() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/typeAndValueArgument.kt");
            }

            @TestMetadata("typeArgumentAndFunctionLiteral.kt")
            public void testTypeArgumentAndFunctionLiteral() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/typeArgumentAndFunctionLiteral.kt");
            }

            @TestMetadata("valueAndFunctionLiteralInvoke.kt")
            public void testValueAndFunctionLiteralInvoke() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/valueAndFunctionLiteralInvoke.kt");
            }

            @TestMetadata("valueArgumentInvoke.kt")
            public void testValueArgumentInvoke() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/valueArgumentInvoke.kt");
            }

            @TestMetadata("varargInvoke.kt")
            public void testVarargInvoke() throws Exception {
                runTest("idea/testData/intentions/conventionNameCalls/replaceInvoke/varargInvoke.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/convertArrayParameterToVararg")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertArrayParameterToVararg extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertArrayParameterToVararg() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertArrayParameterToVararg"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayGenericType.kt")
        public void testArrayGenericType() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/arrayGenericType.kt");
        }

        @TestMetadata("arrayInt.kt")
        public void testArrayInt() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/arrayInt.kt");
        }

        @TestMetadata("arrayString.kt")
        public void testArrayString() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/arrayString.kt");
        }

        @TestMetadata("inConstructor.kt")
        public void testInConstructor() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/inConstructor.kt");
        }

        @TestMetadata("inLambda.kt")
        public void testInLambda() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/inLambda.kt");
        }

        @TestMetadata("intArray.kt")
        public void testIntArray() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/intArray.kt");
        }

        @TestMetadata("longArray.kt")
        public void testLongArray() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/longArray.kt");
        }

        @TestMetadata("starProjection.kt")
        public void testStarProjection() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/starProjection.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/vararg.kt");
        }

        @TestMetadata("withContravariant.kt")
        public void testWithContravariant() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/withContravariant.kt");
        }

        @TestMetadata("withCovariance.kt")
        public void testWithCovariance() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/withCovariance.kt");
        }

        @TestMetadata("withDefaultValue.kt")
        public void testWithDefaultValue() throws Exception {
            runTest("idea/testData/intentions/convertArrayParameterToVararg/withDefaultValue.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertAssertToIf")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertAssertToIf extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertAssertToIf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertAssertToIf"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assertErrorOverloaded.kt")
        public void testAssertErrorOverloaded() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/assertErrorOverloaded.kt");
        }

        @TestMetadata("booleanCondition.kt")
        public void testBooleanCondition() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/booleanCondition.kt");
        }

        @TestMetadata("booleanConditionSimplified.kt")
        public void testBooleanConditionSimplified() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/booleanConditionSimplified.kt");
        }

        @TestMetadata("booleanConditionSimplified2.kt")
        public void testBooleanConditionSimplified2() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/booleanConditionSimplified2.kt");
        }

        @TestMetadata("booleanConditionWithVariables.kt")
        public void testBooleanConditionWithVariables() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/booleanConditionWithVariables.kt");
        }

        @TestMetadata("doNotShortenReferenceInsideMessage.kt")
        public void testDoNotShortenReferenceInsideMessage() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/doNotShortenReferenceInsideMessage.kt");
        }

        @TestMetadata("dotQualifiedCall.kt")
        public void testDotQualifiedCall() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/dotQualifiedCall.kt");
        }

        @TestMetadata("functionCallCondition.kt")
        public void testFunctionCallCondition() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/functionCallCondition.kt");
        }

        @TestMetadata("functionMessageInsideParentheses.kt")
        public void testFunctionMessageInsideParentheses() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/functionMessageInsideParentheses.kt");
        }

        @TestMetadata("inapplicableAssertOverloaded.kt")
        public void testInapplicableAssertOverloaded() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/inapplicableAssertOverloaded.kt");
        }

        @TestMetadata("inapplicableAssertOverloadedWithPackage.kt")
        public void testInapplicableAssertOverloadedWithPackage() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/inapplicableAssertOverloadedWithPackage.kt");
        }

        @TestMetadata("inapplicableNoCondition.kt")
        public void testInapplicableNoCondition() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/inapplicableNoCondition.kt");
        }

        @TestMetadata("lambdaMessageInsideParentheses.kt")
        public void testLambdaMessageInsideParentheses() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/lambdaMessageInsideParentheses.kt");
        }

        @TestMetadata("lambdaMessageOutsideParentheses.kt")
        public void testLambdaMessageOutsideParentheses() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/lambdaMessageOutsideParentheses.kt");
        }

        @TestMetadata("lambdaMultiStatementMessageInsideParentheses.kt")
        public void testLambdaMultiStatementMessageInsideParentheses() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/lambdaMultiStatementMessageInsideParentheses.kt");
        }

        @TestMetadata("lambdaMultiStatementMessageOutsideParentheses.kt")
        public void testLambdaMultiStatementMessageOutsideParentheses() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/lambdaMultiStatementMessageOutsideParentheses.kt");
        }

        @TestMetadata("lambdaVariable.kt")
        public void testLambdaVariable() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/lambdaVariable.kt");
        }

        @TestMetadata("noMessage.kt")
        public void testNoMessage() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/noMessage.kt");
        }

        @TestMetadata("parenthesizedCondition.kt")
        public void testParenthesizedCondition() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/parenthesizedCondition.kt");
        }

        @TestMetadata("simpleConvert.kt")
        public void testSimpleConvert() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/simpleConvert.kt");
        }

        @TestMetadata("stringVariable.kt")
        public void testStringVariable() throws Exception {
            runTest("idea/testData/intentions/convertAssertToIf/stringVariable.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertBinaryExpressionWithDemorgansLaw extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertBinaryExpressionWithDemorgansLaw() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexNegation1.kt")
        public void testComplexNegation1() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/complexNegation1.kt");
        }

        @TestMetadata("complexNegation2.kt")
        public void testComplexNegation2() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/complexNegation2.kt");
        }

        @TestMetadata("conjunctionNegation1.kt")
        public void testConjunctionNegation1() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/conjunctionNegation1.kt");
        }

        @TestMetadata("conjunctionNegation2.kt")
        public void testConjunctionNegation2() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/conjunctionNegation2.kt");
        }

        @TestMetadata("disjunctionNegation1.kt")
        public void testDisjunctionNegation1() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/disjunctionNegation1.kt");
        }

        @TestMetadata("disjunctionNegation2.kt")
        public void testDisjunctionNegation2() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/disjunctionNegation2.kt");
        }

        @TestMetadata("dontAddRedundantParenthesis.kt")
        public void testDontAddRedundantParenthesis() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/dontAddRedundantParenthesis.kt");
        }

        @TestMetadata("doubleNegation.kt")
        public void testDoubleNegation() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/doubleNegation.kt");
        }

        @TestMetadata("inapplicableOperator.kt")
        public void testInapplicableOperator() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/inapplicableOperator.kt");
        }

        @TestMetadata("inapplicableTriple.kt")
        public void testInapplicableTriple() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/inapplicableTriple.kt");
        }

        @TestMetadata("longMixedExpression.kt")
        public void testLongMixedExpression() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/longMixedExpression.kt");
        }

        @TestMetadata("mixedExpression.kt")
        public void testMixedExpression() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/mixedExpression.kt");
        }

        @TestMetadata("noNegationPrefix1.kt")
        public void testNoNegationPrefix1() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/noNegationPrefix1.kt");
        }

        @TestMetadata("noNegationPrefix2.kt")
        public void testNoNegationPrefix2() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/noNegationPrefix2.kt");
        }

        @TestMetadata("noNegationPrefix3.kt")
        public void testNoNegationPrefix3() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/noNegationPrefix3.kt");
        }

        @TestMetadata("noNegationPrefix4.kt")
        public void testNoNegationPrefix4() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/noNegationPrefix4.kt");
        }

        @TestMetadata("nonstandardPrefixOperator.kt")
        public void testNonstandardPrefixOperator() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/nonstandardPrefixOperator.kt");
        }

        @TestMetadata("retainedParens.kt")
        public void testRetainedParens() throws Exception {
            runTest("idea/testData/intentions/convertBinaryExpressionWithDemorgansLaw/retainedParens.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertBlockCommentToLineComment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertBlockCommentToLineComment extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("afterStatement.kt")
        public void testAfterStatement() throws Exception {
            runTest("idea/testData/intentions/convertBlockCommentToLineComment/afterStatement.kt");
        }

        public void testAllFilesPresentInConvertBlockCommentToLineComment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertBlockCommentToLineComment"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("beforeStatement.kt")
        public void testBeforeStatement() throws Exception {
            runTest("idea/testData/intentions/convertBlockCommentToLineComment/beforeStatement.kt");
        }

        @TestMetadata("blankLine.kt")
        public void testBlankLine() throws Exception {
            runTest("idea/testData/intentions/convertBlockCommentToLineComment/blankLine.kt");
        }

        @TestMetadata("docComment.kt")
        public void testDocComment() throws Exception {
            runTest("idea/testData/intentions/convertBlockCommentToLineComment/docComment.kt");
        }

        @TestMetadata("endOflineComment.kt")
        public void testEndOflineComment() throws Exception {
            runTest("idea/testData/intentions/convertBlockCommentToLineComment/endOflineComment.kt");
        }

        @TestMetadata("newLinesBetweenCommentAndDeclaration.kt")
        public void testNewLinesBetweenCommentAndDeclaration() throws Exception {
            runTest("idea/testData/intentions/convertBlockCommentToLineComment/newLinesBetweenCommentAndDeclaration.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertBlockCommentToLineComment/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertCamelCaseTestFunctionToSpaced extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertCamelCaseTestFunctionToSpaced() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("letters.kt")
        public void testLetters() throws Exception {
            runTest("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/letters.kt");
        }

        @TestMetadata("nonFunction.kt")
        public void testNonFunction() throws Exception {
            runTest("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/nonFunction.kt");
        }

        @TestMetadata("nonLetters.kt")
        public void testNonLetters() throws Exception {
            runTest("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/nonLetters.kt");
        }

        @TestMetadata("notAtIdentifier.kt")
        public void testNotAtIdentifier() throws Exception {
            runTest("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/notAtIdentifier.kt");
        }

        @TestMetadata("notTestFunction.kt")
        public void testNotTestFunction() throws Exception {
            runTest("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/notTestFunction.kt");
        }

        @TestMetadata("snake.kt")
        public void testSnake() throws Exception {
            runTest("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/snake.kt");
        }

        @TestMetadata("unchanged.kt")
        public void testUnchanged() throws Exception {
            runTest("idea/testData/intentions/convertCamelCaseTestFunctionToSpaced/unchanged.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertClassToSealedClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertClassToSealedClass extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/abstract.kt");
        }

        public void testAllFilesPresentInConvertClassToSealedClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertClassToSealedClass"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("noConstructor.kt")
        public void testNoConstructor() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/noConstructor.kt");
        }

        @TestMetadata("notOpenAndAbstract.kt")
        public void testNotOpenAndAbstract() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/notOpenAndAbstract.kt");
        }

        @TestMetadata("notPrivatePrimaryConstructor.kt")
        public void testNotPrivatePrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/notPrivatePrimaryConstructor.kt");
        }

        @TestMetadata("notPrivateSecondaryConstructor.kt")
        public void testNotPrivateSecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/notPrivateSecondaryConstructor.kt");
        }

        @TestMetadata("onlySecondaryConstructor.kt")
        public void testOnlySecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/onlySecondaryConstructor.kt");
        }

        @TestMetadata("primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/primaryConstructor.kt");
        }

        @TestMetadata("primaryConstructorWithAnnotation.kt")
        public void testPrimaryConstructorWithAnnotation() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/primaryConstructorWithAnnotation.kt");
        }

        @TestMetadata("primaryConstructorWithValueParameter.kt")
        public void testPrimaryConstructorWithValueParameter() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/primaryConstructorWithValueParameter.kt");
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/secondaryConstructor.kt");
        }

        @TestMetadata("secondaryConstructorWithAnnotation.kt")
        public void testSecondaryConstructorWithAnnotation() throws Exception {
            runTest("idea/testData/intentions/convertClassToSealedClass/secondaryConstructorWithAnnotation.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertEnumToSealedClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertEnumToSealedClass extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertEnumToSealedClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertEnumToSealedClass"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("entriesAndMembers.kt")
        public void testEntriesAndMembers() throws Exception {
            runTest("idea/testData/intentions/convertEnumToSealedClass/entriesAndMembers.kt");
        }

        @TestMetadata("entriesOnly.kt")
        public void testEntriesOnly() throws Exception {
            runTest("idea/testData/intentions/convertEnumToSealedClass/entriesOnly.kt");
        }

        @TestMetadata("membersOnly.kt")
        public void testMembersOnly() throws Exception {
            runTest("idea/testData/intentions/convertEnumToSealedClass/membersOnly.kt");
        }

        @TestMetadata("notEnum.kt")
        public void testNotEnum() throws Exception {
            runTest("idea/testData/intentions/convertEnumToSealedClass/notEnum.kt");
        }

        @TestMetadata("outOfRange.kt")
        public void testOutOfRange() throws Exception {
            runTest("idea/testData/intentions/convertEnumToSealedClass/outOfRange.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertForEachToForLoop")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertForEachToForLoop extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertForEachToForLoop() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertForEachToForLoop"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexReceiver.kt")
        public void testComplexReceiver() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/complexReceiver.kt");
        }

        @TestMetadata("explicitFunctionLiteral.kt")
        public void testExplicitFunctionLiteral() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/explicitFunctionLiteral.kt");
        }

        @TestMetadata("extraArguments.kt")
        public void testExtraArguments() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/extraArguments.kt");
        }

        @TestMetadata("implicitFunctionLiteralParameter.kt")
        public void testImplicitFunctionLiteralParameter() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/implicitFunctionLiteralParameter.kt");
        }

        @TestMetadata("infixCall.kt")
        public void testInfixCall() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/infixCall.kt");
        }

        @TestMetadata("infixCallNotAvailable.kt")
        public void testInfixCallNotAvailable() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/infixCallNotAvailable.kt");
        }

        @TestMetadata("keepComments.kt")
        public void testKeepComments() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/keepComments.kt");
        }

        @TestMetadata("parenthesizedExpression.kt")
        public void testParenthesizedExpression() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/parenthesizedExpression.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/simple.kt");
        }

        @TestMetadata("simpleCharSequence.kt")
        public void testSimpleCharSequence() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/simpleCharSequence.kt");
        }

        @TestMetadata("simpleSequence.kt")
        public void testSimpleSequence() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/simpleSequence.kt");
        }

        @TestMetadata("typeArgumentPresent.kt")
        public void testTypeArgumentPresent() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/typeArgumentPresent.kt");
        }

        @TestMetadata("userDefined.kt")
        public void testUserDefined() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/userDefined.kt");
        }

        @TestMetadata("withNestedReturn.kt")
        public void testWithNestedReturn() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/withNestedReturn.kt");
        }

        @TestMetadata("withReturn.kt")
        public void testWithReturn() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/withReturn.kt");
        }

        @TestMetadata("zeroArguments.kt")
        public void testZeroArguments() throws Exception {
            runTest("idea/testData/intentions/convertForEachToForLoop/zeroArguments.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertFunctionToProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertFunctionToProperty extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addExplicitAnonymousType.kt")
        public void testAddExplicitAnonymousType() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/addExplicitAnonymousType.kt");
        }

        @TestMetadata("addExplicitLocalType.kt")
        public void testAddExplicitLocalType() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/addExplicitLocalType.kt");
        }

        @TestMetadata("addExplicitType.kt")
        public void testAddExplicitType() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/addExplicitType.kt");
        }

        public void testAllFilesPresentInConvertFunctionToProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertFunctionToProperty"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationLineBreak.kt")
        public void testAnnotationLineBreak() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/annotationLineBreak.kt");
        }

        @TestMetadata("blockBody.kt")
        public void testBlockBody() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/blockBody.kt");
        }

        @TestMetadata("comments.kt")
        public void testComments() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/comments.kt");
        }

        @TestMetadata("existingPropertyConflict.kt")
        public void testExistingPropertyConflict() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/existingPropertyConflict.kt");
        }

        @TestMetadata("existingPropertyJavaConflict.kt")
        public void testExistingPropertyJavaConflict() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/existingPropertyJavaConflict.kt");
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/expressionBody.kt");
        }

        @TestMetadata("extraArgumentsConflict.kt")
        public void testExtraArgumentsConflict() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/extraArgumentsConflict.kt");
        }

        @TestMetadata("funWithParameters.kt")
        public void testFunWithParameters() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/funWithParameters.kt");
        }

        @TestMetadata("invoke.kt")
        public void testInvoke() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/invoke.kt");
        }

        @TestMetadata("iterator.kt")
        public void testIterator() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/iterator.kt");
        }

        @TestMetadata("javaUsages.kt")
        public void testJavaUsages() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/javaUsages.kt");
        }

        @TestMetadata("javaUsagesGet.kt")
        public void testJavaUsagesGet() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/javaUsagesGet.kt");
        }

        @TestMetadata("javaUsagesIs.kt")
        public void testJavaUsagesIs() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/javaUsagesIs.kt");
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/localFun.kt");
        }

        @TestMetadata("noExplicitType.kt")
        public void testNoExplicitType() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/noExplicitType.kt");
        }

        @TestMetadata("nothingFun.kt")
        public void testNothingFun() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/nothingFun.kt");
        }

        @TestMetadata("otherRefs.kt")
        public void testOtherRefs() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/otherRefs.kt");
        }

        @TestMetadata("otherRefsGet.kt")
        public void testOtherRefsGet() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/otherRefsGet.kt");
        }

        @TestMetadata("otherRefsIs.kt")
        public void testOtherRefsIs() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/otherRefsIs.kt");
        }

        @TestMetadata("overrides.kt")
        public void testOverrides() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/overrides.kt");
        }

        @TestMetadata("recursiveFunction.kt")
        public void testRecursiveFunction() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/recursiveFunction.kt");
        }

        @TestMetadata("typeArgumentsConflict.kt")
        public void testTypeArgumentsConflict() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/typeArgumentsConflict.kt");
        }

        @TestMetadata("unaryOp.kt")
        public void testUnaryOp() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/unaryOp.kt");
        }

        @TestMetadata("unchangedElements.kt")
        public void testUnchangedElements() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/unchangedElements.kt");
        }

        @TestMetadata("unitFun.kt")
        public void testUnitFun() throws Exception {
            runTest("idea/testData/intentions/convertFunctionToProperty/unitFun.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertFunctionTypeParameterToReceiver")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertFunctionTypeParameterToReceiver extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertFunctionTypeParameterToReceiver() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertFunctionTypeParameterToReceiver"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyHasReceiver.kt")
        public void testAlreadyHasReceiver() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/alreadyHasReceiver.kt");
        }

        @TestMetadata("cantReplaceWithThis.kt")
        public void testCantReplaceWithThis() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/cantReplaceWithThis.kt");
        }

        @TestMetadata("firstParameter.kt")
        public void testFirstParameter() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/firstParameter.kt");
        }

        @TestMetadata("firstParameterPrimaryConstructor.kt")
        public void testFirstParameterPrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/firstParameterPrimaryConstructor.kt");
        }

        @TestMetadata("firstParameterSecondaryConstructor.kt")
        public void testFirstParameterSecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/firstParameterSecondaryConstructor.kt");
        }

        @TestMetadata("firstParameterWithJavaUsages.kt")
        public void testFirstParameterWithJavaUsages() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/firstParameterWithJavaUsages.kt");
        }

        @TestMetadata("nonFirstParameter.kt")
        public void testNonFirstParameter() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/nonFirstParameter.kt");
        }

        @TestMetadata("nonFirstParameterCallableReferenceUsage.kt")
        public void testNonFirstParameterCallableReferenceUsage() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/nonFirstParameterCallableReferenceUsage.kt");
        }

        @TestMetadata("nonFirstParameterPrimaryConstructor.kt")
        public void testNonFirstParameterPrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/nonFirstParameterPrimaryConstructor.kt");
        }

        @TestMetadata("nonFirstParameterSecondaryConstructor.kt")
        public void testNonFirstParameterSecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/nonFirstParameterSecondaryConstructor.kt");
        }

        @TestMetadata("nonFirstParameterSuperDelegationCall.kt")
        public void testNonFirstParameterSuperDelegationCall() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/nonFirstParameterSuperDelegationCall.kt");
        }

        @TestMetadata("nonFirstParameterThisDelegationCall.kt")
        public void testNonFirstParameterThisDelegationCall() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/nonFirstParameterThisDelegationCall.kt");
        }

        @TestMetadata("nonFirstParameterWithJavaUsages.kt")
        public void testNonFirstParameterWithJavaUsages() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/nonFirstParameterWithJavaUsages.kt");
        }

        @TestMetadata("notInFunctionParameter.kt")
        public void testNotInFunctionParameter() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/notInFunctionParameter.kt");
        }

        @TestMetadata("notOnFunctionTypeParameter.kt")
        public void testNotOnFunctionTypeParameter() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/notOnFunctionTypeParameter.kt");
        }

        @TestMetadata("overrides.kt")
        public void testOverrides() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/overrides.kt");
        }

        @TestMetadata("singleExplicitParameter.kt")
        public void testSingleExplicitParameter() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeParameterToReceiver/singleExplicitParameter.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertFunctionTypeReceiverToParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertFunctionTypeReceiverToParameter extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertFunctionTypeReceiverToParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertFunctionTypeReceiverToParameter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeReceiverToParameter/function.kt");
        }

        @TestMetadata("notInFunctionParameter.kt")
        public void testNotInFunctionParameter() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeReceiverToParameter/notInFunctionParameter.kt");
        }

        @TestMetadata("notOnReceiver.kt")
        public void testNotOnReceiver() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeReceiverToParameter/notOnReceiver.kt");
        }

        @TestMetadata("onlyLambdaArgument.kt")
        public void testOnlyLambdaArgument() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeReceiverToParameter/onlyLambdaArgument.kt");
        }

        @TestMetadata("parameterlessFunction.kt")
        public void testParameterlessFunction() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeReceiverToParameter/parameterlessFunction.kt");
        }

        @TestMetadata("primaryConstructor.kt")
        public void testPrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeReceiverToParameter/primaryConstructor.kt");
        }

        @TestMetadata("secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/convertFunctionTypeReceiverToParameter/secondaryConstructor.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertIfWithThrowToAssert")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertIfWithThrowToAssert extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertIfWithThrowToAssert() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertIfWithThrowToAssert"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assertOverloaded.kt")
        public void testAssertOverloaded() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/assertOverloaded.kt");
        }

        @TestMetadata("assertOverloaded2.kt")
        public void testAssertOverloaded2() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/assertOverloaded2.kt");
        }

        @TestMetadata("booleanCondition.kt")
        public void testBooleanCondition() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/booleanCondition.kt");
        }

        @TestMetadata("dotQualifiedThrow.kt")
        public void testDotQualifiedThrow() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/dotQualifiedThrow.kt");
        }

        @TestMetadata("inapplicableAssertionErrorOverloaded.kt")
        public void testInapplicableAssertionErrorOverloaded() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableAssertionErrorOverloaded.kt");
        }

        @TestMetadata("inapplicableCauseSent.kt")
        public void testInapplicableCauseSent() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableCauseSent.kt");
        }

        @TestMetadata("inapplicableHasElse.kt")
        public void testInapplicableHasElse() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableHasElse.kt");
        }

        @TestMetadata("inapplicableMoreThanSingleExpression.kt")
        public void testInapplicableMoreThanSingleExpression() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableMoreThanSingleExpression.kt");
        }

        @TestMetadata("inapplicableMoreThanSingleExpression2.kt")
        public void testInapplicableMoreThanSingleExpression2() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/inapplicableMoreThanSingleExpression2.kt");
        }

        @TestMetadata("noMessageSent.kt")
        public void testNoMessageSent() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/noMessageSent.kt");
        }

        @TestMetadata("nullSent.kt")
        public void testNullSent() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/nullSent.kt");
        }

        @TestMetadata("simpleConvert.kt")
        public void testSimpleConvert() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/simpleConvert.kt");
        }

        @TestMetadata("simplifiedCondition.kt")
        public void testSimplifiedCondition() throws Exception {
            runTest("idea/testData/intentions/convertIfWithThrowToAssert/simplifiedCondition.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertLambdaToReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertLambdaToReference extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertLambdaToReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertLambdaToReference"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentWithReceiver.kt")
        public void testArgumentWithReceiver() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/argumentWithReceiver.kt");
        }

        @TestMetadata("classReference.kt")
        public void testClassReference() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/classReference.kt");
        }

        @TestMetadata("classReference2.kt")
        public void testClassReference2() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/classReference2.kt");
        }

        @TestMetadata("companion.kt")
        public void testCompanion() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/companion.kt");
        }

        @TestMetadata("companion2.kt")
        public void testCompanion2() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/companion2.kt");
        }

        @TestMetadata("companion3.kt")
        public void testCompanion3() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/companion3.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/constructor.kt");
        }

        @TestMetadata("conversion.kt")
        public void testConversion() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/conversion.kt");
        }

        @TestMetadata("defaultArgument.kt")
        public void testDefaultArgument() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultArgument.kt");
        }

        @TestMetadata("defaultBeforeLambda.kt")
        public void testDefaultBeforeLambda() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultBeforeLambda.kt");
        }

        @TestMetadata("defaultConstructor.kt")
        public void testDefaultConstructor() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultConstructor.kt");
        }

        @TestMetadata("defaultNamed.kt")
        public void testDefaultNamed() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultNamed.kt");
        }

        @TestMetadata("defaultNamed2.kt")
        public void testDefaultNamed2() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultNamed2.kt");
        }

        @TestMetadata("defaultNamed3.kt")
        public void testDefaultNamed3() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultNamed3.kt");
        }

        @TestMetadata("defaultOverridden.kt")
        public void testDefaultOverridden() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultOverridden.kt");
        }

        @TestMetadata("defaultUnnamed.kt")
        public void testDefaultUnnamed() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultUnnamed.kt");
        }

        @TestMetadata("defaultUnnamed2.kt")
        public void testDefaultUnnamed2() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultUnnamed2.kt");
        }

        @TestMetadata("defaultUnnamed3.kt")
        public void testDefaultUnnamed3() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/defaultUnnamed3.kt");
        }

        @TestMetadata("doubleChained.kt")
        public void testDoubleChained() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/doubleChained.kt");
        }

        @TestMetadata("emptyBrackets.kt")
        public void testEmptyBrackets() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/emptyBrackets.kt");
        }

        @TestMetadata("erasedReceiver.kt")
        public void testErasedReceiver() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/erasedReceiver.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/extension.kt");
        }

        @TestMetadata("extensionOuterScope.kt")
        public void testExtensionOuterScope() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/extensionOuterScope.kt");
        }

        @TestMetadata("extensionProperty.kt")
        public void testExtensionProperty() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/extensionProperty.kt");
        }

        @TestMetadata("fqNameForReceiver.kt")
        public void testFqNameForReceiver() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/fqNameForReceiver.kt");
        }

        @TestMetadata("generic.kt")
        public void testGeneric() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/generic.kt");
        }

        @TestMetadata("globalProperty.kt")
        public void testGlobalProperty() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/globalProperty.kt");
        }

        @TestMetadata("globalPropertyNoArgs.kt")
        public void testGlobalPropertyNoArgs() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/globalPropertyNoArgs.kt");
        }

        @TestMetadata("goodNamedOrder.kt")
        public void testGoodNamedOrder() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/goodNamedOrder.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/inner.kt");
        }

        @TestMetadata("mapTo.kt")
        public void testMapTo() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/mapTo.kt");
        }

        @TestMetadata("mapToFqName.kt")
        public void testMapToFqName() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/mapToFqName.kt");
        }

        @TestMetadata("member.kt")
        public void testMember() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/member.kt");
        }

        @TestMetadata("memberExplicit.kt")
        public void testMemberExplicit() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberExplicit.kt");
        }

        @TestMetadata("memberExtension.kt")
        public void testMemberExtension() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberExtension.kt");
        }

        @TestMetadata("memberExternalParameter.kt")
        public void testMemberExternalParameter() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberExternalParameter.kt");
        }

        @TestMetadata("memberInLambdaArgument.kt")
        public void testMemberInLambdaArgument() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberInLambdaArgument.kt");
        }

        @TestMetadata("memberInScopeFunction.kt")
        public void testMemberInScopeFunction() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberInScopeFunction.kt");
        }

        @TestMetadata("memberInScopeFunction2.kt")
        public void testMemberInScopeFunction2() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberInScopeFunction2.kt");
        }

        @TestMetadata("memberOuterScope.kt")
        public void testMemberOuterScope() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberOuterScope.kt");
        }

        @TestMetadata("memberViaThis.kt")
        public void testMemberViaThis() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/memberViaThis.kt");
        }

        @TestMetadata("name.kt")
        public void testName() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/name.kt");
        }

        @TestMetadata("nestedLambda.kt")
        public void testNestedLambda() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/nestedLambda.kt");
        }

        @TestMetadata("nestedLambdaWithReceiver.kt")
        public void testNestedLambdaWithReceiver() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/nestedLambdaWithReceiver.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/nullable.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/object.kt");
        }

        @TestMetadata("platformType.kt")
        public void testPlatformType() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/platformType.kt");
        }

        @TestMetadata("receiverParameter.kt")
        public void testReceiverParameter() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/receiverParameter.kt");
        }

        @TestMetadata("receiverParameterReversed.kt")
        public void testReceiverParameterReversed() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/receiverParameterReversed.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/simple.kt");
        }

        @TestMetadata("suspendFun.kt")
        public void testSuspendFun() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/suspendFun.kt");
        }

        @TestMetadata("syntheticProperty.kt")
        public void testSyntheticProperty() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/syntheticProperty.kt");
        }

        @TestMetadata("threeParameters.kt")
        public void testThreeParameters() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/threeParameters.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/toString.kt");
        }

        @TestMetadata("typeAlias.kt")
        public void testTypeAlias() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/typeAlias.kt");
        }

        @TestMetadata("typeAliasGenericInstance.kt")
        public void testTypeAliasGenericInstance() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/typeAliasGenericInstance.kt");
        }

        @TestMetadata("typeFromJava.kt")
        public void testTypeFromJava() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/typeFromJava.kt");
        }

        @TestMetadata("typeFromJavaFlexibleRecursive.kt")
        public void testTypeFromJavaFlexibleRecursive() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/typeFromJavaFlexibleRecursive.kt");
        }

        @TestMetadata("unit.kt")
        public void testUnit() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/unit.kt");
        }

        @TestMetadata("unwrap.kt")
        public void testUnwrap() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/unwrap.kt");
        }

        @TestMetadata("varargFunction.kt")
        public void testVarargFunction() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/varargFunction.kt");
        }

        @TestMetadata("varargFunction2.kt")
        public void testVarargFunction2() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/varargFunction2.kt");
        }

        @TestMetadata("wrongNamedOrder.kt")
        public void testWrongNamedOrder() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/wrongNamedOrder.kt");
        }

        @TestMetadata("wrongParameterNumber.kt")
        public void testWrongParameterNumber() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/wrongParameterNumber.kt");
        }

        @TestMetadata("wrongParameterOrder.kt")
        public void testWrongParameterOrder() throws Exception {
            runTest("idea/testData/intentions/convertLambdaToReference/wrongParameterOrder.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertLateinitPropertyToNullable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertLateinitPropertyToNullable extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertLateinitPropertyToNullable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertLateinitPropertyToNullable"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("initializer.kt")
        public void testInitializer() throws Exception {
            runTest("idea/testData/intentions/convertLateinitPropertyToNullable/initializer.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("idea/testData/intentions/convertLateinitPropertyToNullable/nullable.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertLateinitPropertyToNullable/simple.kt");
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            runTest("idea/testData/intentions/convertLateinitPropertyToNullable/val.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertLineCommentToBlockComment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertLineCommentToBlockComment extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("afterStatement.kt")
        public void testAfterStatement() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/afterStatement.kt");
        }

        public void testAllFilesPresentInConvertLineCommentToBlockComment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertLineCommentToBlockComment"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("blankLine.kt")
        public void testBlankLine() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/blankLine.kt");
        }

        @TestMetadata("blockComment.kt")
        public void testBlockComment() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/blockComment.kt");
        }

        @TestMetadata("includeBlockComment.kt")
        public void testIncludeBlockComment() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/includeBlockComment.kt");
        }

        @TestMetadata("includeBlockComment2.kt")
        public void testIncludeBlockComment2() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/includeBlockComment2.kt");
        }

        @TestMetadata("newLinesBetweenCommentAndDeclaration.kt")
        public void testNewLinesBetweenCommentAndDeclaration() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/newLinesBetweenCommentAndDeclaration.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/simple.kt");
        }

        @TestMetadata("simple2.kt")
        public void testSimple2() throws Exception {
            runTest("idea/testData/intentions/convertLineCommentToBlockComment/simple2.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertNegatedBooleanSequence")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertNegatedBooleanSequence extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertNegatedBooleanSequence() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertNegatedBooleanSequence"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexNegatedSequence.kt")
        public void testComplexNegatedSequence() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/complexNegatedSequence.kt");
        }

        @TestMetadata("conjunctionOfThreeNegations.kt")
        public void testConjunctionOfThreeNegations() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/conjunctionOfThreeNegations.kt");
        }

        @TestMetadata("conjunctionOfTwoNegations.kt")
        public void testConjunctionOfTwoNegations() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/conjunctionOfTwoNegations.kt");
        }

        @TestMetadata("disjunctionOfTwoNegations.kt")
        public void testDisjunctionOfTwoNegations() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/disjunctionOfTwoNegations.kt");
        }

        @TestMetadata("doubleParenthesizedExpression.kt")
        public void testDoubleParenthesizedExpression() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/doubleParenthesizedExpression.kt");
        }

        @TestMetadata("inapplicableMixedOperators.kt")
        public void testInapplicableMixedOperators() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/inapplicableMixedOperators.kt");
        }

        @TestMetadata("inapplicableMixedSequence.kt")
        public void testInapplicableMixedSequence() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/inapplicableMixedSequence.kt");
        }

        @TestMetadata("inapplicableSingleExpression.kt")
        public void testInapplicableSingleExpression() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/inapplicableSingleExpression.kt");
        }

        @TestMetadata("negatedFunction.kt")
        public void testNegatedFunction() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/negatedFunction.kt");
        }

        @TestMetadata("parenthesizedConjunctionOfTwoNegations.kt")
        public void testParenthesizedConjunctionOfTwoNegations() throws Exception {
            runTest("idea/testData/intentions/convertNegatedBooleanSequence/parenthesizedConjunctionOfTwoNegations.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertNullablePropertyToLateinit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertNullablePropertyToLateinit extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/abstract.kt");
        }

        public void testAllFilesPresentInConvertNullablePropertyToLateinit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertNullablePropertyToLateinit"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("delegate.kt")
        public void testDelegate() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/delegate.kt");
        }

        @TestMetadata("extension.kt")
        public void testExtension() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/extension.kt");
        }

        @TestMetadata("getter.kt")
        public void testGetter() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/getter.kt");
        }

        @TestMetadata("inlineClass.kt")
        public void testInlineClass() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/inlineClass.kt");
        }

        @TestMetadata("int.kt")
        public void testInt() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/int.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/local.kt");
        }

        @TestMetadata("localLegacy.kt")
        public void testLocalLegacy() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/localLegacy.kt");
        }

        @TestMetadata("nonNullInitializer.kt")
        public void testNonNullInitializer() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/nonNullInitializer.kt");
        }

        @TestMetadata("nonNullable.kt")
        public void testNonNullable() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/nonNullable.kt");
        }

        @TestMetadata("nullableUpperBound.kt")
        public void testNullableUpperBound() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/nullableUpperBound.kt");
        }

        @TestMetadata("setter.kt")
        public void testSetter() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/setter.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/simple.kt");
        }

        @TestMetadata("topLevel.kt")
        public void testTopLevel() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/topLevel.kt");
        }

        @TestMetadata("topLevelLegacy.kt")
        public void testTopLevelLegacy() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/topLevelLegacy.kt");
        }

        @TestMetadata("unsignedInt.kt")
        public void testUnsignedInt() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/unsignedInt.kt");
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            runTest("idea/testData/intentions/convertNullablePropertyToLateinit/val.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertObjectLiteralToClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertObjectLiteralToClass extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertObjectLiteralToClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertObjectLiteralToClass"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            runTest("idea/testData/intentions/convertObjectLiteralToClass/inClass.kt");
        }

        @TestMetadata("inClassHasMethodReference.kt")
        public void testInClassHasMethodReference() throws Exception {
            runTest("idea/testData/intentions/convertObjectLiteralToClass/inClassHasMethodReference.kt");
        }

        @TestMetadata("inClassHasPropertyReference.kt")
        public void testInClassHasPropertyReference() throws Exception {
            runTest("idea/testData/intentions/convertObjectLiteralToClass/inClassHasPropertyReference.kt");
        }

        @TestMetadata("inFunction.kt")
        public void testInFunction() throws Exception {
            runTest("idea/testData/intentions/convertObjectLiteralToClass/inFunction.kt");
        }

        @TestMetadata("objectLiteralNoCapture.kt")
        public void testObjectLiteralNoCapture() throws Exception {
            runTest("idea/testData/intentions/convertObjectLiteralToClass/objectLiteralNoCapture.kt");
        }

        @TestMetadata("objectLiteralNoSupers.kt")
        public void testObjectLiteralNoSupers() throws Exception {
            runTest("idea/testData/intentions/convertObjectLiteralToClass/objectLiteralNoSupers.kt");
        }

        @TestMetadata("objectLiteralWithCapture.kt")
        public void testObjectLiteralWithCapture() throws Exception {
            runTest("idea/testData/intentions/convertObjectLiteralToClass/objectLiteralWithCapture.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertParameterToReceiver")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertParameterToReceiver extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertParameterToReceiver() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertParameterToReceiver"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("classParameter.kt")
        public void testClassParameter() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/classParameter.kt");
        }

        @TestMetadata("companionAsReceiver.kt")
        public void testCompanionAsReceiver() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/companionAsReceiver.kt");
        }

        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/functionExpression.kt");
        }

        @TestMetadata("functionExpressionWithThisConflict.kt")
        public void testFunctionExpressionWithThisConflict() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/functionExpressionWithThisConflict.kt");
        }

        @TestMetadata("hasVararg.kt")
        public void testHasVararg() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/hasVararg.kt");
        }

        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/lambdaParameter.kt");
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/localFun.kt");
        }

        @TestMetadata("localObject.kt")
        public void testLocalObject() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/localObject.kt");
        }

        @TestMetadata("localObjectWithFunctionNameConflict.kt")
        public void testLocalObjectWithFunctionNameConflict() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/localObjectWithFunctionNameConflict.kt");
        }

        @TestMetadata("memberFun.kt")
        public void testMemberFun() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/memberFun.kt");
        }

        @TestMetadata("noParameterUnderCaret.kt")
        public void testNoParameterUnderCaret() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/noParameterUnderCaret.kt");
        }

        @TestMetadata("topLevelFun.kt")
        public void testTopLevelFun() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/topLevelFun.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/vararg.kt");
        }

        @TestMetadata("withExtensionReceiver.kt")
        public void testWithExtensionReceiver() throws Exception {
            runTest("idea/testData/intentions/convertParameterToReceiver/withExtensionReceiver.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertPrimaryConstructorToSecondary")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPrimaryConstructorToSecondary extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertPrimaryConstructorToSecondary() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertPrimaryConstructorToSecondary"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotatedConstructor.kt")
        public void testAnnotatedConstructor() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/annotatedConstructor.kt");
        }

        @TestMetadata("annotatedParam.kt")
        public void testAnnotatedParam() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/annotatedParam.kt");
        }

        @TestMetadata("annotatedProperty.kt")
        public void testAnnotatedProperty() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/annotatedProperty.kt");
        }

        @TestMetadata("annotationClass.kt")
        public void testAnnotationClass() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/annotationClass.kt");
        }

        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/dataClass.kt");
        }

        @TestMetadata("defaultValueChain.kt")
        public void testDefaultValueChain() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/defaultValueChain.kt");
        }

        @TestMetadata("delegation.kt")
        public void testDelegation() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/delegation.kt");
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/enum.kt");
        }

        @TestMetadata("enumWIthFunction.kt")
        public void testEnumWIthFunction() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/enumWIthFunction.kt");
        }

        @TestMetadata("enumWithParams.kt")
        public void testEnumWithParams() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/enumWithParams.kt");
        }

        @TestMetadata("enumWithoutEntries.kt")
        public void testEnumWithoutEntries() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/enumWithoutEntries.kt");
        }

        @TestMetadata("enumWithoutSemicolon.kt")
        public void testEnumWithoutSemicolon() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/enumWithoutSemicolon.kt");
        }

        @TestMetadata("errorType.kt")
        public void testErrorType() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/errorType.kt");
        }

        @TestMetadata("genericParamWithDefaultValue.kt")
        public void testGenericParamWithDefaultValue() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/genericParamWithDefaultValue.kt");
        }

        @TestMetadata("independentProperty.kt")
        public void testIndependentProperty() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/independentProperty.kt");
        }

        @TestMetadata("independentProperty2.kt")
        public void testIndependentProperty2() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/independentProperty2.kt");
        }

        @TestMetadata("independentProperty3.kt")
        public void testIndependentProperty3() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/independentProperty3.kt");
        }

        @TestMetadata("initAndParams.kt")
        public void testInitAndParams() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/initAndParams.kt");
        }

        @TestMetadata("initWithoutAssignments.kt")
        public void testInitWithoutAssignments() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/initWithoutAssignments.kt");
        }

        @TestMetadata("noArgName.kt")
        public void testNoArgName() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/noArgName.kt");
        }

        @TestMetadata("noArgNameVal.kt")
        public void testNoArgNameVal() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/noArgNameVal.kt");
        }

        @TestMetadata("noArgType.kt")
        public void testNoArgType() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/noArgType.kt");
        }

        @TestMetadata("paramsAndProperties.kt")
        public void testParamsAndProperties() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/paramsAndProperties.kt");
        }

        @TestMetadata("protectedConstructor.kt")
        public void testProtectedConstructor() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/protectedConstructor.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/simple.kt");
        }

        @TestMetadata("useParam.kt")
        public void testUseParam() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/useParam.kt");
        }

        @TestMetadata("useParamChain.kt")
        public void testUseParamChain() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/useParamChain.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/vararg.kt");
        }

        @TestMetadata("varargVal.kt")
        public void testVarargVal() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/varargVal.kt");
        }

        @TestMetadata("withBaseClass.kt")
        public void testWithBaseClass() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/withBaseClass.kt");
        }

        @TestMetadata("withComments.kt")
        public void testWithComments() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/withComments.kt");
        }

        @TestMetadata("withMultipleInheritance.kt")
        public void testWithMultipleInheritance() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/withMultipleInheritance.kt");
        }

        @TestMetadata("withProperties.kt")
        public void testWithProperties() throws Exception {
            runTest("idea/testData/intentions/convertPrimaryConstructorToSecondary/withProperties.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertPropertyGetterToInitializer")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPropertyGetterToInitializer extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertPropertyGetterToInitializer() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertPropertyGetterToInitializer"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("block.kt")
        public void testBlock() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/block.kt");
        }

        @TestMetadata("extentionProperty.kt")
        public void testExtentionProperty() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/extentionProperty.kt");
        }

        @TestMetadata("hasComment.kt")
        public void testHasComment() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/hasComment.kt");
        }

        @TestMetadata("hasComment2.kt")
        public void testHasComment2() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/hasComment2.kt");
        }

        @TestMetadata("hasComment3.kt")
        public void testHasComment3() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/hasComment3.kt");
        }

        @TestMetadata("hasInitializer.kt")
        public void testHasInitializer() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/hasInitializer.kt");
        }

        @TestMetadata("inInterface.kt")
        public void testInInterface() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/inInterface.kt");
        }

        @TestMetadata("multiStatementBlock.kt")
        public void testMultiStatementBlock() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/multiStatementBlock.kt");
        }

        @TestMetadata("run.kt")
        public void testRun() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/run.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertPropertyGetterToInitializer/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertPropertyInitializerToGetter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPropertyInitializerToGetter extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertPropertyInitializerToGetter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertPropertyInitializerToGetter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("errorType.kt")
        public void testErrorType() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/errorType.kt");
        }

        @TestMetadata("inapplicableIfExtensionProperty.kt")
        public void testInapplicableIfExtensionProperty() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfExtensionProperty.kt");
        }

        @TestMetadata("inapplicableIfLocalVariableInFun.kt")
        public void testInapplicableIfLocalVariableInFun() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfLocalVariableInFun.kt");
        }

        @TestMetadata("inapplicableIfLocalVariableInInitBlock.kt")
        public void testInapplicableIfLocalVariableInInitBlock() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfLocalVariableInInitBlock.kt");
        }

        @TestMetadata("inapplicableIfNoInitializer.kt")
        public void testInapplicableIfNoInitializer() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/inapplicableIfNoInitializer.kt");
        }

        @TestMetadata("jvmField.kt")
        public void testJvmField() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/jvmField.kt");
        }

        @TestMetadata("notInLambda.kt")
        public void testNotInLambda() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/notInLambda.kt");
        }

        @TestMetadata("propertyWithInitializerWithSetter.kt")
        public void testPropertyWithInitializerWithSetter() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/propertyWithInitializerWithSetter.kt");
        }

        @TestMetadata("propertyWithInitializerWithoutAccessors.kt")
        public void testPropertyWithInitializerWithoutAccessors() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/propertyWithInitializerWithoutAccessors.kt");
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/semicolon.kt");
        }

        @TestMetadata("topLevelDeclaration.kt")
        public void testTopLevelDeclaration() throws Exception {
            runTest("idea/testData/intentions/convertPropertyInitializerToGetter/topLevelDeclaration.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertPropertyToFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPropertyToFunction extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("accessorCallGroovy.kt")
        public void testAccessorCallGroovy() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/accessorCallGroovy.kt");
        }

        public void testAllFilesPresentInConvertPropertyToFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertPropertyToFunction"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("blockBody.kt")
        public void testBlockBody() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/blockBody.kt");
        }

        @TestMetadata("delegatingProperty.kt")
        public void testDelegatingProperty() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/delegatingProperty.kt");
        }

        @TestMetadata("existingFunConflict.kt")
        public void testExistingFunConflict() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/existingFunConflict.kt");
        }

        @TestMetadata("existingFunJavaConflict.kt")
        public void testExistingFunJavaConflict() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/existingFunJavaConflict.kt");
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/expressionBody.kt");
        }

        @TestMetadata("initializer.kt")
        public void testInitializer() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/initializer.kt");
        }

        @TestMetadata("initializerWithGetter.kt")
        public void testInitializerWithGetter() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/initializerWithGetter.kt");
        }

        @TestMetadata("javaUsageAsField.kt")
        public void testJavaUsageAsField() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/javaUsageAsField.kt");
        }

        @TestMetadata("javaUsages.kt")
        public void testJavaUsages() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/javaUsages.kt");
        }

        @TestMetadata("jvmField.kt")
        public void testJvmField() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/jvmField.kt");
        }

        @TestMetadata("otherRefs.kt")
        public void testOtherRefs() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/otherRefs.kt");
        }

        @TestMetadata("overrides.kt")
        public void testOverrides() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/overrides.kt");
        }

        @TestMetadata("propertyCallGroovy.kt")
        public void testPropertyCallGroovy() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/propertyCallGroovy.kt");
        }

        @TestMetadata("recursiveAccessor.kt")
        public void testRecursiveAccessor() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/recursiveAccessor.kt");
        }

        @TestMetadata("unchangedElements.kt")
        public void testUnchangedElements() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/unchangedElements.kt");
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            runTest("idea/testData/intentions/convertPropertyToFunction/var.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertRangeCheckToTwoComparisons")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertRangeCheckToTwoComparisons extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertRangeCheckToTwoComparisons() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertRangeCheckToTwoComparisons"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/double.kt");
        }

        @TestMetadata("forLoop.kt")
        public void testForLoop() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/forLoop.kt");
        }

        @TestMetadata("insideForLoop.kt")
        public void testInsideForLoop() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/insideForLoop.kt");
        }

        @TestMetadata("insideForLoop2.kt")
        public void testInsideForLoop2() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/insideForLoop2.kt");
        }

        @TestMetadata("int.kt")
        public void testInt() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/int.kt");
        }

        @TestMetadata("nonConstants.kt")
        public void testNonConstants() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/nonConstants.kt");
        }

        @TestMetadata("otherOp.kt")
        public void testOtherOp() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/otherOp.kt");
        }

        @TestMetadata("withSideEffects.kt")
        public void testWithSideEffects() throws Exception {
            runTest("idea/testData/intentions/convertRangeCheckToTwoComparisons/withSideEffects.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertReceiverToParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertReceiverToParameter extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertReceiverToParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertReceiverToParameter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("autoSuggestedName.kt")
        public void testAutoSuggestedName() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/autoSuggestedName.kt");
        }

        @TestMetadata("functionExpression.kt")
        public void testFunctionExpression() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/functionExpression.kt");
        }

        @TestMetadata("genericReceiver.kt")
        public void testGenericReceiver() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/genericReceiver.kt");
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/localFun.kt");
        }

        @TestMetadata("memberFun.kt")
        public void testMemberFun() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/memberFun.kt");
        }

        @TestMetadata("noReceiverUnderCaret.kt")
        public void testNoReceiverUnderCaret() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/noReceiverUnderCaret.kt");
        }

        @TestMetadata("notExtension.kt")
        public void testNotExtension() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/notExtension.kt");
        }

        @TestMetadata("replaceThis.kt")
        public void testReplaceThis() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/replaceThis.kt");
        }

        @TestMetadata("topLevelFun.kt")
        public void testTopLevelFun() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/topLevelFun.kt");
        }

        @TestMetadata("validOverload.kt")
        public void testValidOverload() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/validOverload.kt");
        }

        @TestMetadata("varargs.kt")
        public void testVarargs() throws Exception {
            runTest("idea/testData/intentions/convertReceiverToParameter/varargs.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertReferenceToLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertReferenceToLambda extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertReferenceToLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertReferenceToLambda"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("apply.kt")
        public void testApply() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/apply.kt");
        }

        @TestMetadata("boundReference.kt")
        public void testBoundReference() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/boundReference.kt");
        }

        @TestMetadata("companion.kt")
        public void testCompanion() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/companion.kt");
        }

        @TestMetadata("companionNoImport.kt")
        public void testCompanionNoImport() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/companionNoImport.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/constructor.kt");
        }

        @TestMetadata("conversion.kt")
        public void testConversion() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/conversion.kt");
        }

        @TestMetadata("extensionFunctionalType.kt")
        public void testExtensionFunctionalType() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/extensionFunctionalType.kt");
        }

        @TestMetadata("extensionProperty.kt")
        public void testExtensionProperty() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/extensionProperty.kt");
        }

        @TestMetadata("fqNameForReceiver.kt")
        public void testFqNameForReceiver() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/fqNameForReceiver.kt");
        }

        @TestMetadata("if1.kt")
        public void testIf1() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/if1.kt");
        }

        @TestMetadata("if2.kt")
        public void testIf2() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/if2.kt");
        }

        @TestMetadata("if3.kt")
        public void testIf3() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/if3.kt");
        }

        @TestMetadata("if4.kt")
        public void testIf4() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/if4.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/inner.kt");
        }

        @TestMetadata("itClash.kt")
        public void testItClash() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/itClash.kt");
        }

        @TestMetadata("kfunction.kt")
        public void testKfunction() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/kfunction.kt");
        }

        @TestMetadata("kproperty.kt")
        public void testKproperty() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/kproperty.kt");
        }

        @TestMetadata("kproperty0.kt")
        public void testKproperty0() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/kproperty0.kt");
        }

        @TestMetadata("length.kt")
        public void testLength() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/length.kt");
        }

        @TestMetadata("member.kt")
        public void testMember() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/member.kt");
        }

        @TestMetadata("name.kt")
        public void testName() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/name.kt");
        }

        @TestMetadata("nestedLambdaWithReceiver.kt")
        public void testNestedLambdaWithReceiver() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/nestedLambdaWithReceiver.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/nullable.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/object.kt");
        }

        @TestMetadata("receiverParameter.kt")
        public void testReceiverParameter() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/receiverParameter.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/simple.kt");
        }

        @TestMetadata("static.kt")
        public void testStatic() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/static.kt");
        }

        @TestMetadata("staticTwoParameters.kt")
        public void testStaticTwoParameters() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/staticTwoParameters.kt");
        }

        @TestMetadata("threeParameters.kt")
        public void testThreeParameters() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/threeParameters.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/toString.kt");
        }

        @TestMetadata("unwrap.kt")
        public void testUnwrap() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/unwrap.kt");
        }

        @TestMetadata("when1.kt")
        public void testWhen1() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/when1.kt");
        }

        @TestMetadata("when2.kt")
        public void testWhen2() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/when2.kt");
        }

        @TestMetadata("when3.kt")
        public void testWhen3() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/when3.kt");
        }

        @TestMetadata("when4.kt")
        public void testWhen4() throws Exception {
            runTest("idea/testData/intentions/convertReferenceToLambda/when4.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertSealedClassToEnum")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertSealedClassToEnum extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertSealedClassToEnum() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertSealedClassToEnum"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dropDefaultConstructorCall.kt")
        public void testDropDefaultConstructorCall() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/dropDefaultConstructorCall.kt");
        }

        @TestMetadata("inheritorsWithMultipleSupertypes.kt")
        public void testInheritorsWithMultipleSupertypes() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/inheritorsWithMultipleSupertypes.kt");
        }

        @TestMetadata("instancesAndMembers.kt")
        public void testInstancesAndMembers() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/instancesAndMembers.kt");
        }

        @TestMetadata("instancesOnly.kt")
        public void testInstancesOnly() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/instancesOnly.kt");
        }

        @TestMetadata("membersOnly.kt")
        public void testMembersOnly() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/membersOnly.kt");
        }

        @TestMetadata("nonNestedInheritors.kt")
        public void testNonNestedInheritors() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/nonNestedInheritors.kt");
        }

        @TestMetadata("notSealedClass.kt")
        public void testNotSealedClass() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/notSealedClass.kt");
        }

        @TestMetadata("outOfRange.kt")
        public void testOutOfRange() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/outOfRange.kt");
        }

        @TestMetadata("withNonObjectInheritors.kt")
        public void testWithNonObjectInheritors() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/withNonObjectInheritors.kt");
        }

        @TestMetadata("withSuperclass.kt")
        public void testWithSuperclass() throws Exception {
            runTest("idea/testData/intentions/convertSealedClassToEnum/withSuperclass.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertSecondaryConstructorToPrimary")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertSecondaryConstructorToPrimary extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertSecondaryConstructorToPrimary() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertSecondaryConstructorToPrimary"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("defaultValueChain.kt")
        public void testDefaultValueChain() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/defaultValueChain.kt");
        }

        @TestMetadata("init.kt")
        public void testInit() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/init.kt");
        }

        @TestMetadata("initAndParams.kt")
        public void testInitAndParams() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/initAndParams.kt");
        }

        @TestMetadata("nonReachable.kt")
        public void testNonReachable() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/nonReachable.kt");
        }

        @TestMetadata("nonReachableLoop.kt")
        public void testNonReachableLoop() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/nonReachableLoop.kt");
        }

        @TestMetadata("propertyWithGetter.kt")
        public void testPropertyWithGetter() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/propertyWithGetter.kt");
        }

        @TestMetadata("propertyWithSetter.kt")
        public void testPropertyWithSetter() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/propertyWithSetter.kt");
        }

        @TestMetadata("protectedConstructor.kt")
        public void testProtectedConstructor() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/protectedConstructor.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/simple.kt");
        }

        @TestMetadata("useParam.kt")
        public void testUseParam() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/useParam.kt");
        }

        @TestMetadata("varArg.kt")
        public void testVarArg() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/varArg.kt");
        }

        @TestMetadata("varargVal.kt")
        public void testVarargVal() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/varargVal.kt");
        }

        @TestMetadata("withBaseAliasImplicit.kt")
        public void testWithBaseAliasImplicit() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withBaseAliasImplicit.kt");
        }

        @TestMetadata("withBaseClass.kt")
        public void testWithBaseClass() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withBaseClass.kt");
        }

        @TestMetadata("withBaseClassImplicit.kt")
        public void testWithBaseClassImplicit() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withBaseClassImplicit.kt");
        }

        @TestMetadata("withBaseClassNoArgs.kt")
        public void testWithBaseClassNoArgs() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withBaseClassNoArgs.kt");
        }

        @TestMetadata("withComments.kt")
        public void testWithComments() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withComments.kt");
        }

        @TestMetadata("withComposedModifiers.kt")
        public void testWithComposedModifiers() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withComposedModifiers.kt");
        }

        @TestMetadata("withDelegation.kt")
        public void testWithDelegation() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withDelegation.kt");
        }

        @TestMetadata("withDifferentTypeProperty.kt")
        public void testWithDifferentTypeProperty() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withDifferentTypeProperty.kt");
        }

        @TestMetadata("withInterfaceAlias.kt")
        public void testWithInterfaceAlias() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withInterfaceAlias.kt");
        }

        @TestMetadata("withModifiers.kt")
        public void testWithModifiers() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withModifiers.kt");
        }

        @TestMetadata("withParameters.kt")
        public void testWithParameters() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withParameters.kt");
        }

        @TestMetadata("withPrimary.kt")
        public void testWithPrimary() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withPrimary.kt");
        }

        @TestMetadata("withProperties.kt")
        public void testWithProperties() throws Exception {
            runTest("idea/testData/intentions/convertSecondaryConstructorToPrimary/withProperties.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertSnakeCaseTestFunctionToSpaced")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertSnakeCaseTestFunctionToSpaced extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertSnakeCaseTestFunctionToSpaced() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertSnakeCaseTestFunctionToSpaced"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("camel.kt")
        public void testCamel() throws Exception {
            runTest("idea/testData/intentions/convertSnakeCaseTestFunctionToSpaced/camel.kt");
        }

        @TestMetadata("snake.kt")
        public void testSnake() throws Exception {
            runTest("idea/testData/intentions/convertSnakeCaseTestFunctionToSpaced/snake.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertToBlockBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToBlockBody extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addSpace.kt")
        public void testAddSpace() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/addSpace.kt");
        }

        public void testAllFilesPresentInConvertToBlockBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToBlockBody"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotatedExpr.kt")
        public void testAnnotatedExpr() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/annotatedExpr.kt");
        }

        @TestMetadata("explicitlyNonUnitFun.kt")
        public void testExplicitlyNonUnitFun() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/explicitlyNonUnitFun.kt");
        }

        @TestMetadata("explicitlyTypedFunWithUnresolvedExpression.kt")
        public void testExplicitlyTypedFunWithUnresolvedExpression() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/explicitlyTypedFunWithUnresolvedExpression.kt");
        }

        @TestMetadata("explicitlyTypedFunWithUnresolvedType.kt")
        public void testExplicitlyTypedFunWithUnresolvedType() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/explicitlyTypedFunWithUnresolvedType.kt");
        }

        @TestMetadata("explicitlyUnitFun.kt")
        public void testExplicitlyUnitFun() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/explicitlyUnitFun.kt");
        }

        @TestMetadata("explicitlyUnitFunWithUnresolvedExpression.kt")
        public void testExplicitlyUnitFunWithUnresolvedExpression() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/explicitlyUnitFunWithUnresolvedExpression.kt");
        }

        @TestMetadata("funWithCustomUnitClass.kt")
        public void testFunWithCustomUnitClass() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/funWithCustomUnitClass.kt");
        }

        @TestMetadata("funWithThrow.kt")
        public void testFunWithThrow() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/funWithThrow.kt");
        }

        @TestMetadata("funWithUnit.kt")
        public void testFunWithUnit() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/funWithUnit.kt");
        }

        @TestMetadata("getter.kt")
        public void testGetter() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/getter.kt");
        }

        @TestMetadata("getterTypeInferred.kt")
        public void testGetterTypeInferred() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/getterTypeInferred.kt");
        }

        @TestMetadata("getterWithThrow.kt")
        public void testGetterWithThrow() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/getterWithThrow.kt");
        }

        @TestMetadata("ifWhenUnit.kt")
        public void testIfWhenUnit() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/ifWhenUnit.kt");
        }

        @TestMetadata("implicitlyNonUnitFun.kt")
        public void testImplicitlyNonUnitFun() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/implicitlyNonUnitFun.kt");
        }

        @TestMetadata("implicitlyTypedFunWithUnresolvedType.kt")
        public void testImplicitlyTypedFunWithUnresolvedType() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/implicitlyTypedFunWithUnresolvedType.kt");
        }

        @TestMetadata("implicitlyUnitFun.kt")
        public void testImplicitlyUnitFun() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/implicitlyUnitFun.kt");
        }

        @TestMetadata("labeledExpr.kt")
        public void testLabeledExpr() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/labeledExpr.kt");
        }

        @TestMetadata("nothingFun.kt")
        public void testNothingFun() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/nothingFun.kt");
        }

        @TestMetadata("setter.kt")
        public void testSetter() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/setter.kt");
        }

        @TestMetadata("valueIsAnonymousObject.kt")
        public void testValueIsAnonymousObject() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject.kt");
        }

        @TestMetadata("valueIsAnonymousObject2.kt")
        public void testValueIsAnonymousObject2() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject2.kt");
        }

        @TestMetadata("valueIsAnonymousObject3.kt")
        public void testValueIsAnonymousObject3() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject3.kt");
        }

        @TestMetadata("valueIsAnonymousObject4.kt")
        public void testValueIsAnonymousObject4() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/valueIsAnonymousObject4.kt");
        }

        @TestMetadata("whenUnit.kt")
        public void testWhenUnit() throws Exception {
            runTest("idea/testData/intentions/convertToBlockBody/whenUnit.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertToConcatenatedString")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToConcatenatedString extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertToConcatenatedString() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToConcatenatedString"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("embeddedIf.kt")
        public void testEmbeddedIf() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/embeddedIf.kt");
        }

        @TestMetadata("embeddedIfBraces.kt")
        public void testEmbeddedIfBraces() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/embeddedIfBraces.kt");
        }

        @TestMetadata("emptyBraces.kt")
        public void testEmptyBraces() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/emptyBraces.kt");
        }

        @TestMetadata("handlesEscapeString.kt")
        public void testHandlesEscapeString() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/handlesEscapeString.kt");
        }

        @TestMetadata("interpolate2StringConstants.kt")
        public void testInterpolate2StringConstants() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolate2StringConstants.kt");
        }

        @TestMetadata("interpolate3.kt")
        public void testInterpolate3() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolate3.kt");
        }

        @TestMetadata("interpolateChar.kt")
        public void testInterpolateChar() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolateChar.kt");
        }

        @TestMetadata("interpolateConstants.kt")
        public void testInterpolateConstants() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolateConstants.kt");
        }

        @TestMetadata("interpolateMapAccess.kt")
        public void testInterpolateMapAccess() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolateMapAccess.kt");
        }

        @TestMetadata("interpolateMethodInvoke.kt")
        public void testInterpolateMethodInvoke() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolateMethodInvoke.kt");
        }

        @TestMetadata("interpolateSimpleWithBraces.kt")
        public void testInterpolateSimpleWithBraces() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolateSimpleWithBraces.kt");
        }

        @TestMetadata("interpolateStringWithFloat.kt")
        public void testInterpolateStringWithFloat() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolateStringWithFloat.kt");
        }

        @TestMetadata("interpolateStringWithInt.kt")
        public void testInterpolateStringWithInt() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/interpolateStringWithInt.kt");
        }

        @TestMetadata("lastExprIsNamedExpression.kt")
        public void testLastExprIsNamedExpression() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/lastExprIsNamedExpression.kt");
        }

        @TestMetadata("multilineString.kt")
        public void testMultilineString() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/multilineString.kt");
        }

        @TestMetadata("multilineWhenExpr.kt")
        public void testMultilineWhenExpr() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/multilineWhenExpr.kt");
        }

        @TestMetadata("namedExprBetweenConstants.kt")
        public void testNamedExprBetweenConstants() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/namedExprBetweenConstants.kt");
        }

        @TestMetadata("notApplicableForErrorElement.kt")
        public void testNotApplicableForErrorElement() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/notApplicableForErrorElement.kt");
        }

        @TestMetadata("notApplicableForSimple.kt")
        public void testNotApplicableForSimple() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/notApplicableForSimple.kt");
        }

        @TestMetadata("notAvailableForDollarSignLiteral.kt")
        public void testNotAvailableForDollarSignLiteral() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/notAvailableForDollarSignLiteral.kt");
        }

        @TestMetadata("singleVar.kt")
        public void testSingleVar() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/singleVar.kt");
        }

        @TestMetadata("startsWithInt.kt")
        public void testStartsWithInt() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/startsWithInt.kt");
        }

        @TestMetadata("startsWithStringExpression.kt")
        public void testStartsWithStringExpression() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/startsWithStringExpression.kt");
        }

        @TestMetadata("tricky.kt")
        public void testTricky() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/tricky.kt");
        }

        @TestMetadata("withAndWithoutBraces.kt")
        public void testWithAndWithoutBraces() throws Exception {
            runTest("idea/testData/intentions/convertToConcatenatedString/withAndWithoutBraces.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertToForEachFunctionCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToForEachFunctionCall extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertToForEachFunctionCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToForEachFunctionCall"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("binaryExpressionLoopRange.kt")
        public void testBinaryExpressionLoopRange() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/binaryExpressionLoopRange.kt");
        }

        @TestMetadata("blockBodyExpression.kt")
        public void testBlockBodyExpression() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/blockBodyExpression.kt");
        }

        @TestMetadata("blockCommentOnly.kt")
        public void testBlockCommentOnly() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/blockCommentOnly.kt");
        }

        @TestMetadata("commentsInBody.kt")
        public void testCommentsInBody() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/commentsInBody.kt");
        }

        @TestMetadata("commentsInBody2.kt")
        public void testCommentsInBody2() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/commentsInBody2.kt");
        }

        @TestMetadata("commentsOutsideBody.kt")
        public void testCommentsOutsideBody() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/commentsOutsideBody.kt");
        }

        @TestMetadata("continueToReturnWithLabel.kt")
        public void testContinueToReturnWithLabel() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/continueToReturnWithLabel.kt");
        }

        @TestMetadata("continueToReturnWithoutLabel.kt")
        public void testContinueToReturnWithoutLabel() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/continueToReturnWithoutLabel.kt");
        }

        @TestMetadata("emptyBody.kt")
        public void testEmptyBody() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/emptyBody.kt");
        }

        @TestMetadata("endOfLineComment1.kt")
        public void testEndOfLineComment1() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/endOfLineComment1.kt");
        }

        @TestMetadata("endOfLineComment2.kt")
        public void testEndOfLineComment2() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/endOfLineComment2.kt");
        }

        @TestMetadata("endOfLineComment3.kt")
        public void testEndOfLineComment3() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/endOfLineComment3.kt");
        }

        @TestMetadata("iterativeElementTypeSpecified.kt")
        public void testIterativeElementTypeSpecified() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/iterativeElementTypeSpecified.kt");
        }

        @TestMetadata("noCurlyBraces.kt")
        public void testNoCurlyBraces() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/noCurlyBraces.kt");
        }

        @TestMetadata("noStatements.kt")
        public void testNoStatements() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/noStatements.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/simple.kt");
        }

        @TestMetadata("typeAnnotatedWithNonBlockBody.kt")
        public void testTypeAnnotatedWithNonBlockBody() throws Exception {
            runTest("idea/testData/intentions/convertToForEachFunctionCall/typeAnnotatedWithNonBlockBody.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertToRawStringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToRawStringTemplate extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertToRawStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToRawStringTemplate"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/intentions/convertToRawStringTemplate/basic.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertToScope")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToScope extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertToScope() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToScope"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/convertToScope/convertToAlso")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertToAlso extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConvertToAlso() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToScope/convertToAlso"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/callExpression.kt");
            }

            @TestMetadata("callExpression2.kt")
            public void testCallExpression2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/callExpression2.kt");
            }

            @TestMetadata("callExpression3.kt")
            public void testCallExpression3() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/callExpression3.kt");
            }

            @TestMetadata("callExpression4.kt")
            public void testCallExpression4() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/callExpression4.kt");
            }

            @TestMetadata("callExpression5.kt")
            public void testCallExpression5() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/callExpression5.kt");
            }

            @TestMetadata("itParameter.kt")
            public void testItParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/itParameter.kt");
            }

            @TestMetadata("itParameter2.kt")
            public void testItParameter2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/itParameter2.kt");
            }

            @TestMetadata("methodChain.kt")
            public void testMethodChain() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/methodChain.kt");
            }

            @TestMetadata("methodChainWithItParameter.kt")
            public void testMethodChainWithItParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/methodChainWithItParameter.kt");
            }

            @TestMetadata("methodChainWithThisParameter.kt")
            public void testMethodChainWithThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/methodChainWithThisParameter.kt");
            }

            @TestMetadata("normal.kt")
            public void testNormal() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/normal.kt");
            }

            @TestMetadata("normal2.kt")
            public void testNormal2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/normal2.kt");
            }

            @TestMetadata("normal3.kt")
            public void testNormal3() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/normal3.kt");
            }

            @TestMetadata("onProperty.kt")
            public void testOnProperty() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/onProperty.kt");
            }

            @TestMetadata("singleCall.kt")
            public void testSingleCall() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/singleCall.kt");
            }

            @TestMetadata("untilItParameter.kt")
            public void testUntilItParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/untilItParameter.kt");
            }

            @TestMetadata("var.kt")
            public void testVar() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/var.kt");
            }

            @TestMetadata("withCommentAndSpaces.kt")
            public void testWithCommentAndSpaces() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToAlso/withCommentAndSpaces.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/convertToScope/convertToApply")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertToApply extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConvertToApply() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToScope/convertToApply"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/callExpression.kt");
            }

            @TestMetadata("callExpression2.kt")
            public void testCallExpression2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/callExpression2.kt");
            }

            @TestMetadata("callExpression3.kt")
            public void testCallExpression3() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/callExpression3.kt");
            }

            @TestMetadata("callExpression4.kt")
            public void testCallExpression4() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/callExpression4.kt");
            }

            @TestMetadata("callExpression5.kt")
            public void testCallExpression5() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/callExpression5.kt");
            }

            @TestMetadata("methodChain.kt")
            public void testMethodChain() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/methodChain.kt");
            }

            @TestMetadata("methodChainWithItParameter.kt")
            public void testMethodChainWithItParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/methodChainWithItParameter.kt");
            }

            @TestMetadata("methodChainWithThisParameter.kt")
            public void testMethodChainWithThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/methodChainWithThisParameter.kt");
            }

            @TestMetadata("normal.kt")
            public void testNormal() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/normal.kt");
            }

            @TestMetadata("normal2.kt")
            public void testNormal2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/normal2.kt");
            }

            @TestMetadata("normal3.kt")
            public void testNormal3() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/normal3.kt");
            }

            @TestMetadata("onProperty.kt")
            public void testOnProperty() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/onProperty.kt");
            }

            @TestMetadata("singleCall.kt")
            public void testSingleCall() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/singleCall.kt");
            }

            @TestMetadata("thisParameter.kt")
            public void testThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/thisParameter.kt");
            }

            @TestMetadata("thisParameter2.kt")
            public void testThisParameter2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/thisParameter2.kt");
            }

            @TestMetadata("untilThisParameter.kt")
            public void testUntilThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/untilThisParameter.kt");
            }

            @TestMetadata("var.kt")
            public void testVar() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/var.kt");
            }

            @TestMetadata("withCommentAndSpaces.kt")
            public void testWithCommentAndSpaces() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToApply/withCommentAndSpaces.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/convertToScope/convertToRun")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertToRun extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConvertToRun() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToScope/convertToRun"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/callExpression.kt");
            }

            @TestMetadata("callExpression2.kt")
            public void testCallExpression2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/callExpression2.kt");
            }

            @TestMetadata("itReceiver.kt")
            public void testItReceiver() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/itReceiver.kt");
            }

            @TestMetadata("javaMethod.kt")
            public void testJavaMethod() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/javaMethod.kt");
            }

            @TestMetadata("javaStaticMethod.kt")
            public void testJavaStaticMethod() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/javaStaticMethod.kt");
            }

            @TestMetadata("methodChain.kt")
            public void testMethodChain() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/methodChain.kt");
            }

            @TestMetadata("methodChainWithItParameter.kt")
            public void testMethodChainWithItParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/methodChainWithItParameter.kt");
            }

            @TestMetadata("methodChainWithThisParameter.kt")
            public void testMethodChainWithThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/methodChainWithThisParameter.kt");
            }

            @TestMetadata("normal.kt")
            public void testNormal() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/normal.kt");
            }

            @TestMetadata("normal2.kt")
            public void testNormal2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/normal2.kt");
            }

            @TestMetadata("normal3.kt")
            public void testNormal3() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/normal3.kt");
            }

            @TestMetadata("normal4.kt")
            public void testNormal4() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/normal4.kt");
            }

            @TestMetadata("onProperty.kt")
            public void testOnProperty() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/onProperty.kt");
            }

            @TestMetadata("singleCall.kt")
            public void testSingleCall() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/singleCall.kt");
            }

            @TestMetadata("thisParameter.kt")
            public void testThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/thisParameter.kt");
            }

            @TestMetadata("thisReceiver.kt")
            public void testThisReceiver() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/thisReceiver.kt");
            }

            @TestMetadata("untilThisParameter.kt")
            public void testUntilThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/untilThisParameter.kt");
            }

            @TestMetadata("withCommentAndSpaces.kt")
            public void testWithCommentAndSpaces() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToRun/withCommentAndSpaces.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/convertToScope/convertToWith")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertToWith extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConvertToWith() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToScope/convertToWith"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callExpression.kt")
            public void testCallExpression() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/callExpression.kt");
            }

            @TestMetadata("callExpression2.kt")
            public void testCallExpression2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/callExpression2.kt");
            }

            @TestMetadata("itReceiver.kt")
            public void testItReceiver() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/itReceiver.kt");
            }

            @TestMetadata("javaMethod.kt")
            public void testJavaMethod() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/javaMethod.kt");
            }

            @TestMetadata("javaStaticMethod.kt")
            public void testJavaStaticMethod() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/javaStaticMethod.kt");
            }

            @TestMetadata("methodChain.kt")
            public void testMethodChain() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/methodChain.kt");
            }

            @TestMetadata("methodChainWithItParameter.kt")
            public void testMethodChainWithItParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/methodChainWithItParameter.kt");
            }

            @TestMetadata("methodChainWithThisParameter.kt")
            public void testMethodChainWithThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/methodChainWithThisParameter.kt");
            }

            @TestMetadata("normal.kt")
            public void testNormal() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/normal.kt");
            }

            @TestMetadata("normal2.kt")
            public void testNormal2() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/normal2.kt");
            }

            @TestMetadata("normal3.kt")
            public void testNormal3() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/normal3.kt");
            }

            @TestMetadata("normal4.kt")
            public void testNormal4() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/normal4.kt");
            }

            @TestMetadata("onProperty.kt")
            public void testOnProperty() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/onProperty.kt");
            }

            @TestMetadata("singleCall.kt")
            public void testSingleCall() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/singleCall.kt");
            }

            @TestMetadata("thisParameter.kt")
            public void testThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/thisParameter.kt");
            }

            @TestMetadata("thisReceiver.kt")
            public void testThisReceiver() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/thisReceiver.kt");
            }

            @TestMetadata("untilThisParameter.kt")
            public void testUntilThisParameter() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/untilThisParameter.kt");
            }

            @TestMetadata("withCommentAndSpaces.kt")
            public void testWithCommentAndSpaces() throws Exception {
                runTest("idea/testData/intentions/convertToScope/convertToWith/withCommentAndSpaces.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/convertToStringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToStringTemplate extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertToStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToStringTemplate"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("backslashNMultilineString.kt")
        public void testBackslashNMultilineString() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/backslashNMultilineString.kt");
        }

        @TestMetadata("combineEmptyStrings.kt")
        public void testCombineEmptyStrings() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/combineEmptyStrings.kt");
        }

        @TestMetadata("combinesNonStringsAsStrings.kt")
        public void testCombinesNonStringsAsStrings() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/combinesNonStringsAsStrings.kt");
        }

        @TestMetadata("combinesNonStringsAsStrings2.kt")
        public void testCombinesNonStringsAsStrings2() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/combinesNonStringsAsStrings2.kt");
        }

        @TestMetadata("comment.kt")
        public void testComment() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/comment.kt");
        }

        @TestMetadata("consecutiveNewlines.kt")
        public void testConsecutiveNewlines() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/consecutiveNewlines.kt");
        }

        @TestMetadata("doesNotCorruptExistingTemplate.kt")
        public void testDoesNotCorruptExistingTemplate() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/doesNotCorruptExistingTemplate.kt");
        }

        @TestMetadata("doesNotCorruptExistingTemplateWithBraces.kt")
        public void testDoesNotCorruptExistingTemplateWithBraces() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/doesNotCorruptExistingTemplateWithBraces.kt");
        }

        @TestMetadata("dollarSignChar.kt")
        public void testDollarSignChar() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/dollarSignChar.kt");
        }

        @TestMetadata("endOfLineComment.kt")
        public void testEndOfLineComment() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/endOfLineComment.kt");
        }

        @TestMetadata("escapedQuote.kt")
        public void testEscapedQuote() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/escapedQuote.kt");
        }

        @TestMetadata("escapedQuote2.kt")
        public void testEscapedQuote2() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/escapedQuote2.kt");
        }

        @TestMetadata("insertBracesForSimpleNamedExpression.kt")
        public void testInsertBracesForSimpleNamedExpression() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/insertBracesForSimpleNamedExpression.kt");
        }

        @TestMetadata("interpolate2StringConstants.kt")
        public void testInterpolate2StringConstants() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolate2StringConstants.kt");
        }

        @TestMetadata("interpolate2Vals.kt")
        public void testInterpolate2Vals() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolate2Vals.kt");
        }

        @TestMetadata("interpolate3Left.kt")
        public void testInterpolate3Left() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolate3Left.kt");
        }

        @TestMetadata("interpolate3Right.kt")
        public void testInterpolate3Right() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolate3Right.kt");
        }

        @TestMetadata("interpolateChar.kt")
        public void testInterpolateChar() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolateChar.kt");
        }

        @TestMetadata("interpolateDollarSign.kt")
        public void testInterpolateDollarSign() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolateDollarSign.kt");
        }

        @TestMetadata("interpolateMapAccess.kt")
        public void testInterpolateMapAccess() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolateMapAccess.kt");
        }

        @TestMetadata("interpolateMethodInvoke.kt")
        public void testInterpolateMethodInvoke() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolateMethodInvoke.kt");
        }

        @TestMetadata("interpolateMultiline.kt")
        public void testInterpolateMultiline() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolateMultiline.kt");
        }

        @TestMetadata("interpolateStringWithFloat.kt")
        public void testInterpolateStringWithFloat() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolateStringWithFloat.kt");
        }

        @TestMetadata("interpolateStringWithInt.kt")
        public void testInterpolateStringWithInt() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/interpolateStringWithInt.kt");
        }

        @TestMetadata("invalidChar.kt")
        public void testInvalidChar() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/invalidChar.kt");
        }

        @TestMetadata("kt11295.kt")
        public void testKt11295() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/kt11295.kt");
        }

        @TestMetadata("longTemplatePlusStringLiteral.kt")
        public void testLongTemplatePlusStringLiteral() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/longTemplatePlusStringLiteral.kt");
        }

        @TestMetadata("multilineString.kt")
        public void testMultilineString() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/multilineString.kt");
        }

        @TestMetadata("newLine.kt")
        public void testNewLine() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/newLine.kt");
        }

        @TestMetadata("noBracesForLastSimpleExpression.kt")
        public void testNoBracesForLastSimpleExpression() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/noBracesForLastSimpleExpression.kt");
        }

        @TestMetadata("noBracesSimpleFollowedByDot.kt")
        public void testNoBracesSimpleFollowedByDot() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/noBracesSimpleFollowedByDot.kt");
        }

        @TestMetadata("notApplicableForErrorElement.kt")
        public void testNotApplicableForErrorElement() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/notApplicableForErrorElement.kt");
        }

        @TestMetadata("numberLiterals.kt")
        public void testNumberLiterals() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/numberLiterals.kt");
        }

        @TestMetadata("onMultipleLines.kt")
        public void testOnMultipleLines() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/onMultipleLines.kt");
        }

        @TestMetadata("onlyForConcat.kt")
        public void testOnlyForConcat() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/onlyForConcat.kt");
        }

        @TestMetadata("onlyForStrings.kt")
        public void testOnlyForStrings() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/onlyForStrings.kt");
        }

        @TestMetadata("requiresPlusOperator.kt")
        public void testRequiresPlusOperator() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/requiresPlusOperator.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/simple.kt");
        }

        @TestMetadata("specialCharsInCharLiteral.kt")
        public void testSpecialCharsInCharLiteral() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/specialCharsInCharLiteral.kt");
        }

        @TestMetadata("stringPlusStringLiteral.kt")
        public void testStringPlusStringLiteral() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/stringPlusStringLiteral.kt");
        }

        @TestMetadata("templatePlusStringLiteral.kt")
        public void testTemplatePlusStringLiteral() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/templatePlusStringLiteral.kt");
        }

        @TestMetadata("this.kt")
        public void testThis() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/this.kt");
        }

        @TestMetadata("this2.kt")
        public void testThis2() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/this2.kt");
        }

        @TestMetadata("this3.kt")
        public void testThis3() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/this3.kt");
        }

        @TestMetadata("toString.kt")
        public void testToString() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/toString.kt");
        }

        @TestMetadata("tricky.kt")
        public void testTricky() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/tricky.kt");
        }

        @TestMetadata("unescapeSingleQuote.kt")
        public void testUnescapeSingleQuote() throws Exception {
            runTest("idea/testData/intentions/convertToStringTemplate/unescapeSingleQuote.kt");
        }

        @TestMetadata("idea/testData/intentions/convertToStringTemplate/inspectionData")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InspectionData extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInspectionData() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertToStringTemplate/inspectionData"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/convertTrimIndentToTrimMargin")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertTrimIndentToTrimMargin extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertTrimIndentToTrimMargin() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertTrimIndentToTrimMargin"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("differentIndent.kt")
        public void testDifferentIndent() throws Exception {
            runTest("idea/testData/intentions/convertTrimIndentToTrimMargin/differentIndent.kt");
        }

        @TestMetadata("notBlankFirst.kt")
        public void testNotBlankFirst() throws Exception {
            runTest("idea/testData/intentions/convertTrimIndentToTrimMargin/notBlankFirst.kt");
        }

        @TestMetadata("notBlankLast.kt")
        public void testNotBlankLast() throws Exception {
            runTest("idea/testData/intentions/convertTrimIndentToTrimMargin/notBlankLast.kt");
        }

        @TestMetadata("notRawString.kt")
        public void testNotRawString() throws Exception {
            runTest("idea/testData/intentions/convertTrimIndentToTrimMargin/notRawString.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertTrimIndentToTrimMargin/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertTrimMarginToTrimIndent")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertTrimMarginToTrimIndent extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertTrimMarginToTrimIndent() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertTrimMarginToTrimIndent"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("differentIndent.kt")
        public void testDifferentIndent() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/differentIndent.kt");
        }

        @TestMetadata("escapedMarginPrefixArgument.kt")
        public void testEscapedMarginPrefixArgument() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/escapedMarginPrefixArgument.kt");
        }

        @TestMetadata("noMarginPrefix.kt")
        public void testNoMarginPrefix() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/noMarginPrefix.kt");
        }

        @TestMetadata("notBlankFirst.kt")
        public void testNotBlankFirst() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/notBlankFirst.kt");
        }

        @TestMetadata("notBlankLast.kt")
        public void testNotBlankLast() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/notBlankLast.kt");
        }

        @TestMetadata("notRawString.kt")
        public void testNotRawString() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/notRawString.kt");
        }

        @TestMetadata("referenceMarginPrefixArgument.kt")
        public void testReferenceMarginPrefixArgument() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/referenceMarginPrefixArgument.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/simple.kt");
        }

        @TestMetadata("simple2.kt")
        public void testSimple2() throws Exception {
            runTest("idea/testData/intentions/convertTrimMarginToTrimIndent/simple2.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertTryFinallyToUseCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertTryFinallyToUseCall extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertTryFinallyToUseCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertTryFinallyToUseCall"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("catch.kt")
        public void testCatch() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/catch.kt");
        }

        @TestMetadata("example.kt")
        public void testExample() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/example.kt");
        }

        @TestMetadata("implicitReceiver.kt")
        public void testImplicitReceiver() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/implicitReceiver.kt");
        }

        @TestMetadata("notClose.kt")
        public void testNotClose() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/notClose.kt");
        }

        @TestMetadata("notOnlyClose.kt")
        public void testNotOnlyClose() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/notOnlyClose.kt");
        }

        @TestMetadata("parameter.kt")
        public void testParameter() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/parameter.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/safeCall.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/simple.kt");
        }

        @TestMetadata("this.kt")
        public void testThis() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/this.kt");
        }

        @TestMetadata("thisLabeled.kt")
        public void testThisLabeled() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/thisLabeled.kt");
        }

        @TestMetadata("triple.kt")
        public void testTriple() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/triple.kt");
        }

        @TestMetadata("wrongCaret.kt")
        public void testWrongCaret() throws Exception {
            runTest("idea/testData/intentions/convertTryFinallyToUseCall/wrongCaret.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertTwoComparisonsToRangeCheck")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertTwoComparisonsToRangeCheck extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertTwoComparisonsToRangeCheck() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertTwoComparisonsToRangeCheck"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/char.kt");
        }

        @TestMetadata("charInclusive.kt")
        public void testCharInclusive() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/charInclusive.kt");
        }

        @TestMetadata("charInt.kt")
        public void testCharInt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/charInt.kt");
        }

        @TestMetadata("compareToComparableSameType.kt")
        public void testCompareToComparableSameType() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/compareToComparableSameType.kt");
        }

        @TestMetadata("compareToDifferentTypes.kt")
        public void testCompareToDifferentTypes() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/compareToDifferentTypes.kt");
        }

        @TestMetadata("compareToSameType.kt")
        public void testCompareToSameType() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/compareToSameType.kt");
        }

        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/double.kt");
        }

        @TestMetadata("doubleToInt1.kt")
        public void testDoubleToInt1() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/doubleToInt1.kt");
        }

        @TestMetadata("doubleToInt2.kt")
        public void testDoubleToInt2() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/doubleToInt2.kt");
        }

        @TestMetadata("flipped.kt")
        public void testFlipped() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/flipped.kt");
        }

        @TestMetadata("flippedSideEffect.kt")
        public void testFlippedSideEffect() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/flippedSideEffect.kt");
        }

        @TestMetadata("gtDouble.kt")
        public void testGtDouble() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gtDouble.kt");
        }

        @TestMetadata("gtDouble2.kt")
        public void testGtDouble2() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gtDouble2.kt");
        }

        @TestMetadata("gteqgt.kt")
        public void testGteqgt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gteqgt.kt");
        }

        @TestMetadata("gteqgteq.kt")
        public void testGteqgteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gteqgteq.kt");
        }

        @TestMetadata("gteqlt.kt")
        public void testGteqlt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gteqlt.kt");
        }

        @TestMetadata("gteqlteq.kt")
        public void testGteqlteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gteqlteq.kt");
        }

        @TestMetadata("gtgt.kt")
        public void testGtgt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gtgt.kt");
        }

        @TestMetadata("gtgteq.kt")
        public void testGtgteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gtgteq.kt");
        }

        @TestMetadata("gtlt.kt")
        public void testGtlt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gtlt.kt");
        }

        @TestMetadata("gtlteq.kt")
        public void testGtlteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/gtlteq.kt");
        }

        @TestMetadata("lteqgt.kt")
        public void testLteqgt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/lteqgt.kt");
        }

        @TestMetadata("lteqgteq.kt")
        public void testLteqgteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/lteqgteq.kt");
        }

        @TestMetadata("lteqlt.kt")
        public void testLteqlt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/lteqlt.kt");
        }

        @TestMetadata("lteqlteq.kt")
        public void testLteqlteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/lteqlteq.kt");
        }

        @TestMetadata("ltgt.kt")
        public void testLtgt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/ltgt.kt");
        }

        @TestMetadata("ltgteq.kt")
        public void testLtgteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/ltgteq.kt");
        }

        @TestMetadata("ltlt.kt")
        public void testLtlt() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/ltlt.kt");
        }

        @TestMetadata("ltlteq.kt")
        public void testLtlteq() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/ltlteq.kt");
        }

        @TestMetadata("nonConstants.kt")
        public void testNonConstants() throws Exception {
            runTest("idea/testData/intentions/convertTwoComparisonsToRangeCheck/nonConstants.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertUnsafeCastCallToUnsafeCast")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertUnsafeCastCallToUnsafeCast extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertUnsafeCastCallToUnsafeCast() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertUnsafeCastCallToUnsafeCast"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            runTest("idea/testData/intentions/convertUnsafeCastCallToUnsafeCast/call.kt");
        }

        @TestMetadata("safeCall.kt")
        public void testSafeCall() throws Exception {
            runTest("idea/testData/intentions/convertUnsafeCastCallToUnsafeCast/safeCall.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertUnsafeCastToUnsafeCastCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertUnsafeCastToUnsafeCastCall extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertUnsafeCastToUnsafeCastCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertUnsafeCastToUnsafeCastCall"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("cast.kt")
        public void testCast() throws Exception {
            runTest("idea/testData/intentions/convertUnsafeCastToUnsafeCastCall/cast.kt");
        }

        @TestMetadata("safeCast.kt")
        public void testSafeCast() throws Exception {
            runTest("idea/testData/intentions/convertUnsafeCastToUnsafeCastCall/safeCast.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/convertVarargParameterToArray")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertVarargParameterToArray extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertVarargParameterToArray() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/convertVarargParameterToArray"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("genericType.kt")
        public void testGenericType() throws Exception {
            runTest("idea/testData/intentions/convertVarargParameterToArray/genericType.kt");
        }

        @TestMetadata("inConstructor.kt")
        public void testInConstructor() throws Exception {
            runTest("idea/testData/intentions/convertVarargParameterToArray/inConstructor.kt");
        }

        @TestMetadata("int.kt")
        public void testInt() throws Exception {
            runTest("idea/testData/intentions/convertVarargParameterToArray/int.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("idea/testData/intentions/convertVarargParameterToArray/long.kt");
        }

        @TestMetadata("noVararg.kt")
        public void testNoVararg() throws Exception {
            runTest("idea/testData/intentions/convertVarargParameterToArray/noVararg.kt");
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("idea/testData/intentions/convertVarargParameterToArray/string.kt");
        }

        @TestMetadata("withDefaultValue.kt")
        public void testWithDefaultValue() throws Exception {
            runTest("idea/testData/intentions/convertVarargParameterToArray/withDefaultValue.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/copyConcatenatedStringToClipboard")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CopyConcatenatedStringToClipboard extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCopyConcatenatedStringToClipboard() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/copyConcatenatedStringToClipboard"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constants.kt")
        public void testConstants() throws Exception {
            runTest("idea/testData/intentions/copyConcatenatedStringToClipboard/constants.kt");
        }

        @TestMetadata("numbers.kt")
        public void testNumbers() throws Exception {
            runTest("idea/testData/intentions/copyConcatenatedStringToClipboard/numbers.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/copyConcatenatedStringToClipboard/simple.kt");
        }

        @TestMetadata("simpleString.kt")
        public void testSimpleString() throws Exception {
            runTest("idea/testData/intentions/copyConcatenatedStringToClipboard/simpleString.kt");
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("idea/testData/intentions/copyConcatenatedStringToClipboard/variables.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/declarations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Declarations extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDeclarations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/declarations"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/declarations/convertMemberToExtension")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertMemberToExtension extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("abstract.kt")
            public void testAbstract() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/abstract.kt");
            }

            @TestMetadata("abstractProperty.kt")
            public void testAbstractProperty() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/abstractProperty.kt");
            }

            public void testAllFilesPresentInConvertMemberToExtension() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/declarations/convertMemberToExtension"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("explicitUnit.kt")
            public void testExplicitUnit() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/explicitUnit.kt");
            }

            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/extension.kt");
            }

            @TestMetadata("final.kt")
            public void testFinal() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/final.kt");
            }

            @TestMetadata("funcitonNoName.kt")
            public void testFuncitonNoName() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/funcitonNoName.kt");
            }

            @TestMetadata("functionType.kt")
            public void testFunctionType() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/functionType.kt");
            }

            @TestMetadata("genericClass.kt")
            public void testGenericClass() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/genericClass.kt");
            }

            @TestMetadata("genericFun.kt")
            public void testGenericFun() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/genericFun.kt");
            }

            @TestMetadata("genericFunInGenericClass.kt")
            public void testGenericFunInGenericClass() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/genericFunInGenericClass.kt");
            }

            @TestMetadata("genericFunInGenericClassWithUpperBounds.kt")
            public void testGenericFunInGenericClassWithUpperBounds() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/genericFunInGenericClassWithUpperBounds.kt");
            }

            @TestMetadata("genericFunParamAfterName.kt")
            public void testGenericFunParamAfterName() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/genericFunParamAfterName.kt");
            }

            @TestMetadata("inFunctionBody.kt")
            public void testInFunctionBody() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/inFunctionBody.kt");
            }

            @TestMetadata("inObject.kt")
            public void testInObject() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/inObject.kt");
            }

            @TestMetadata("internal.kt")
            public void testInternal() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/internal.kt");
            }

            @TestMetadata("KDoc.kt")
            public void testKDoc() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/KDoc.kt");
            }

            @TestMetadata("localFunction.kt")
            public void testLocalFunction() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/localFunction.kt");
            }

            @TestMetadata("nonBlockBodyNoType.kt")
            public void testNonBlockBodyNoType() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/nonBlockBodyNoType.kt");
            }

            @TestMetadata("nonBlockBodyWithType.kt")
            public void testNonBlockBodyWithType() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/nonBlockBodyWithType.kt");
            }

            @TestMetadata("open.kt")
            public void testOpen() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/open.kt");
            }

            @TestMetadata("outsideFunction.kt")
            public void testOutsideFunction() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/outsideFunction.kt");
            }

            @TestMetadata("override.kt")
            public void testOverride() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/override.kt");
            }

            @TestMetadata("private.kt")
            public void testPrivate() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/private.kt");
            }

            @TestMetadata("privateInInternalClass.kt")
            public void testPrivateInInternalClass() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/privateInInternalClass.kt");
            }

            @TestMetadata("protected.kt")
            public void testProtected() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/protected.kt");
            }

            @TestMetadata("public.kt")
            public void testPublic() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/public.kt");
            }

            @TestMetadata("publicInInternalClass.kt")
            public void testPublicInInternalClass() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/publicInInternalClass.kt");
            }

            @TestMetadata("publicInPrivateClass.kt")
            public void testPublicInPrivateClass() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/publicInPrivateClass.kt");
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/secondaryConstructor.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/simple.kt");
            }

            @TestMetadata("topLevelFunction.kt")
            public void testTopLevelFunction() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/topLevelFunction.kt");
            }

            @TestMetadata("typeFqName.kt")
            public void testTypeFqName() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/typeFqName.kt");
            }

            @TestMetadata("unknownType.kt")
            public void testUnknownType() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/unknownType.kt");
            }

            @TestMetadata("valWithDefaultGetter.kt")
            public void testValWithDefaultGetter() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/valWithDefaultGetter.kt");
            }

            @TestMetadata("valWithGetter.kt")
            public void testValWithGetter() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/valWithGetter.kt");
            }

            @TestMetadata("valWithGetterBlockBody.kt")
            public void testValWithGetterBlockBody() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/valWithGetterBlockBody.kt");
            }

            @TestMetadata("varWithDefaultGetterAndSetter.kt")
            public void testVarWithDefaultGetterAndSetter() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/varWithDefaultGetterAndSetter.kt");
            }

            @TestMetadata("varWithDefaultSetter.kt")
            public void testVarWithDefaultSetter() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/varWithDefaultSetter.kt");
            }

            @TestMetadata("varWithGetter.kt")
            public void testVarWithGetter() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/varWithGetter.kt");
            }

            @TestMetadata("varWithGetterAndSetter.kt")
            public void testVarWithGetterAndSetter() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/varWithGetterAndSetter.kt");
            }

            @TestMetadata("varWithSetter.kt")
            public void testVarWithSetter() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/varWithSetter.kt");
            }

            @TestMetadata("withType.kt")
            public void testWithType() throws Exception {
                runTest("idea/testData/intentions/declarations/convertMemberToExtension/withType.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/declarations/split")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Split extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSplit() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/declarations/split"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anonymousFunction.kt")
            public void testAnonymousFunction() throws Exception {
                runTest("idea/testData/intentions/declarations/split/anonymousFunction.kt");
            }

            @TestMetadata("longInit.kt")
            public void testLongInit() throws Exception {
                runTest("idea/testData/intentions/declarations/split/longInit.kt");
            }

            @TestMetadata("longInit2.kt")
            public void testLongInit2() throws Exception {
                runTest("idea/testData/intentions/declarations/split/longInit2.kt");
            }

            @TestMetadata("noInitializer.kt")
            public void testNoInitializer() throws Exception {
                runTest("idea/testData/intentions/declarations/split/noInitializer.kt");
            }

            @TestMetadata("noInitializer2.kt")
            public void testNoInitializer2() throws Exception {
                runTest("idea/testData/intentions/declarations/split/noInitializer2.kt");
            }

            @TestMetadata("nonLocalProperty.kt")
            public void testNonLocalProperty() throws Exception {
                runTest("idea/testData/intentions/declarations/split/nonLocalProperty.kt");
            }

            @TestMetadata("nonLocalProperty2.kt")
            public void testNonLocalProperty2() throws Exception {
                runTest("idea/testData/intentions/declarations/split/nonLocalProperty2.kt");
            }

            @TestMetadata("simpleInit.kt")
            public void testSimpleInit() throws Exception {
                runTest("idea/testData/intentions/declarations/split/simpleInit.kt");
            }

            @TestMetadata("simpleInit2.kt")
            public void testSimpleInit2() throws Exception {
                runTest("idea/testData/intentions/declarations/split/simpleInit2.kt");
            }

            @TestMetadata("simpleInitWithErrorType.kt")
            public void testSimpleInitWithErrorType() throws Exception {
                runTest("idea/testData/intentions/declarations/split/simpleInitWithErrorType.kt");
            }

            @TestMetadata("simpleInitWithErrorType2.kt")
            public void testSimpleInitWithErrorType2() throws Exception {
                runTest("idea/testData/intentions/declarations/split/simpleInitWithErrorType2.kt");
            }

            @TestMetadata("simpleInitWithType.kt")
            public void testSimpleInitWithType() throws Exception {
                runTest("idea/testData/intentions/declarations/split/simpleInitWithType.kt");
            }

            @TestMetadata("simpleInitWithType2.kt")
            public void testSimpleInitWithType2() throws Exception {
                runTest("idea/testData/intentions/declarations/split/simpleInitWithType2.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/destructuringInLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringInLambda extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDestructuringInLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/destructuringInLambda"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("caret.kt")
        public void testCaret() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/caret.kt");
        }

        @TestMetadata("dependentLocal.kt")
        public void testDependentLocal() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/dependentLocal.kt");
        }

        @TestMetadata("firstProperties.kt")
        public void testFirstProperties() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/firstProperties.kt");
        }

        @TestMetadata("fold.kt")
        public void testFold() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/fold.kt");
        }

        @TestMetadata("invisible.kt")
        public void testInvisible() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/invisible.kt");
        }

        @TestMetadata("last.kt")
        public void testLast() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/last.kt");
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/list.kt");
        }

        @TestMetadata("mapIndexedExceptFirst.kt")
        public void testMapIndexedExceptFirst() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/mapIndexedExceptFirst.kt");
        }

        @TestMetadata("mapIndexedLast.kt")
        public void testMapIndexedLast() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/mapIndexedLast.kt");
        }

        @TestMetadata("noIt.kt")
        public void testNoIt() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/noIt.kt");
        }

        @TestMetadata("noItVariables.kt")
        public void testNoItVariables() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/noItVariables.kt");
        }

        @TestMetadata("noItWithDestructuring.kt")
        public void testNoItWithDestructuring() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/noItWithDestructuring.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/nullable.kt");
        }

        @TestMetadata("pair.kt")
        public void testPair() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/pair.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/simple.kt");
        }

        @TestMetadata("twoOfThree.kt")
        public void testTwoOfThree() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/twoOfThree.kt");
        }

        @TestMetadata("variables.kt")
        public void testVariables() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/variables.kt");
        }

        @TestMetadata("visible.kt")
        public void testVisible() throws Exception {
            runTest("idea/testData/intentions/destructuringInLambda/visible.kt");
        }

        @TestMetadata("idea/testData/intentions/destructuringInLambda/inspectionData")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InspectionData extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInspectionData() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/destructuringInLambda/inspectionData"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/destructuringVariables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DestructuringVariables extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDestructuringVariables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/destructuringVariables"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("caret.kt")
        public void testCaret() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/caret.kt");
        }

        @TestMetadata("changingVar.kt")
        public void testChangingVar() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/changingVar.kt");
        }

        @TestMetadata("classProperty.kt")
        public void testClassProperty() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/classProperty.kt");
        }

        @TestMetadata("noInitializer.kt")
        public void testNoInitializer() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/noInitializer.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/simple.kt");
        }

        @TestMetadata("toplevel.kt")
        public void testToplevel() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/toplevel.kt");
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/var.kt");
        }

        @TestMetadata("withModifiers.kt")
        public void testWithModifiers() throws Exception {
            runTest("idea/testData/intentions/destructuringVariables/withModifiers.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/foldInitializerAndIfToElvis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FoldInitializerAndIfToElvis extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFoldInitializerAndIfToElvis() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/foldInitializerAndIfToElvis"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("Break.kt")
        public void testBreak() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/Break.kt");
        }

        @TestMetadata("CommentInBlock.kt")
        public void testCommentInBlock() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/CommentInBlock.kt");
        }

        @TestMetadata("Comments.kt")
        public void testComments() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/Comments.kt");
        }

        @TestMetadata("Comments2.kt")
        public void testComments2() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/Comments2.kt");
        }

        @TestMetadata("Continue.kt")
        public void testContinue() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/Continue.kt");
        }

        @TestMetadata("ExplicitValType.kt")
        public void testExplicitValType() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/ExplicitValType.kt");
        }

        @TestMetadata("ExplicitVarType.kt")
        public void testExplicitVarType() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/ExplicitVarType.kt");
        }

        @TestMetadata("IfNotNull.kt")
        public void testIfNotNull() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/IfNotNull.kt");
        }

        @TestMetadata("ifStatementPriority.kt")
        public void testIfStatementPriority() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/ifStatementPriority.kt");
        }

        @TestMetadata("IsSameType.kt")
        public void testIsSameType() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/IsSameType.kt");
        }

        @TestMetadata("IsSideTypeFake.kt")
        public void testIsSideTypeFake() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/IsSideTypeFake.kt");
        }

        @TestMetadata("IsSubType.kt")
        public void testIsSubType() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/IsSubType.kt");
        }

        @TestMetadata("IsSuperTypeFake.kt")
        public void testIsSuperTypeFake() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/IsSuperTypeFake.kt");
        }

        @TestMetadata("MultiStatementBlock.kt")
        public void testMultiStatementBlock() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/MultiStatementBlock.kt");
        }

        @TestMetadata("NotExit.kt")
        public void testNotExit() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/NotExit.kt");
        }

        @TestMetadata("NotIs.kt")
        public void testNotIs() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/NotIs.kt");
        }

        @TestMetadata("NotIsNullableType.kt")
        public void testNotIsNullableType() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/NotIsNullableType.kt");
        }

        @TestMetadata("OtherVar1.kt")
        public void testOtherVar1() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/OtherVar1.kt");
        }

        @TestMetadata("OtherVar2.kt")
        public void testOtherVar2() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/OtherVar2.kt");
        }

        @TestMetadata("Return.kt")
        public void testReturn() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/Return.kt");
        }

        @TestMetadata("ThrowInBlock.kt")
        public void testThrowInBlock() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/ThrowInBlock.kt");
        }

        @TestMetadata("UsedInside.kt")
        public void testUsedInside() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/UsedInside.kt");
        }

        @TestMetadata("UsedInsideInTemplate.kt")
        public void testUsedInsideInTemplate() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/UsedInsideInTemplate.kt");
        }

        @TestMetadata("Var.kt")
        public void testVar() throws Exception {
            runTest("idea/testData/intentions/foldInitializerAndIfToElvis/Var.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/implementAbstractMember")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImplementAbstractMember extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInImplementAbstractMember() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAbstractMember"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/implementAbstractMember/function")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Function extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAbstractMember/function"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumClass.kt")
            public void testEnumClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/enumClass.kt");
            }

            @TestMetadata("enumClassWithSemicolon.kt")
            public void testEnumClassWithSemicolon() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/enumClassWithSemicolon.kt");
            }

            @TestMetadata("enumClassWithSemicolonAndMembers.kt")
            public void testEnumClassWithSemicolonAndMembers() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/enumClassWithSemicolonAndMembers.kt");
            }

            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/enumEntries.kt");
            }

            @TestMetadata("enumEntriesWithArgs.kt")
            public void testEnumEntriesWithArgs() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/enumEntriesWithArgs.kt");
            }

            @TestMetadata("implementAll.kt")
            public void testImplementAll() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/implementAll.kt");
            }

            @TestMetadata("inFinalClass.kt")
            public void testInFinalClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/inFinalClass.kt");
            }

            @TestMetadata("inObject.kt")
            public void testInObject() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/inObject.kt");
            }

            @TestMetadata("noDirectOverridesNeeded.kt")
            public void testNoDirectOverridesNeeded() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/noDirectOverridesNeeded.kt");
            }

            @TestMetadata("noInheritors.kt")
            public void testNoInheritors() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/noInheritors.kt");
            }

            @TestMetadata("notAbstractInClass.kt")
            public void testNotAbstractInClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/notAbstractInClass.kt");
            }

            @TestMetadata("notAbstractInInterface.kt")
            public void testNotAbstractInInterface() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/notAbstractInInterface.kt");
            }

            @TestMetadata("notAbstractNoBodyInClass.kt")
            public void testNotAbstractNoBodyInClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/function/notAbstractNoBodyInClass.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/implementAbstractMember/property")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Property extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInProperty() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAbstractMember/property"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumClass.kt")
            public void testEnumClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/enumClass.kt");
            }

            @TestMetadata("enumClassWithSemicolon.kt")
            public void testEnumClassWithSemicolon() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/enumClassWithSemicolon.kt");
            }

            @TestMetadata("enumClassWithSemicolonAndMembers.kt")
            public void testEnumClassWithSemicolonAndMembers() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/enumClassWithSemicolonAndMembers.kt");
            }

            @TestMetadata("enumEntries.kt")
            public void testEnumEntries() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/enumEntries.kt");
            }

            @TestMetadata("enumEntriesWithArgs.kt")
            public void testEnumEntriesWithArgs() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/enumEntriesWithArgs.kt");
            }

            @TestMetadata("implementAll.kt")
            public void testImplementAll() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/implementAll.kt");
            }

            @TestMetadata("inFinalClass.kt")
            public void testInFinalClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/inFinalClass.kt");
            }

            @TestMetadata("inObject.kt")
            public void testInObject() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/inObject.kt");
            }

            @TestMetadata("noDirectOverridesNeeded.kt")
            public void testNoDirectOverridesNeeded() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/noDirectOverridesNeeded.kt");
            }

            @TestMetadata("noInheritors.kt")
            public void testNoInheritors() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/noInheritors.kt");
            }

            @TestMetadata("notAbstractInClass.kt")
            public void testNotAbstractInClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/notAbstractInClass.kt");
            }

            @TestMetadata("notAbstractNoBodyInClass.kt")
            public void testNotAbstractNoBodyInClass() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/notAbstractNoBodyInClass.kt");
            }

            @TestMetadata("notAbstractWithGetterInInterface.kt")
            public void testNotAbstractWithGetterInInterface() throws Exception {
                runTest("idea/testData/intentions/implementAbstractMember/property/notAbstractWithGetterInInterface.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/implementAsConstructorParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImplementAsConstructorParameter extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInImplementAsConstructorParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/implementAsConstructorParameter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("enumClass.kt")
        public void testEnumClass() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/enumClass.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/function.kt");
        }

        @TestMetadata("implementAll.kt")
        public void testImplementAll() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/implementAll.kt");
        }

        @TestMetadata("inEnumClass.kt")
        public void testInEnumClass() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/inEnumClass.kt");
        }

        @TestMetadata("inFinalClass.kt")
        public void testInFinalClass() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/inFinalClass.kt");
        }

        @TestMetadata("inObject.kt")
        public void testInObject() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/inObject.kt");
        }

        @TestMetadata("noDirectOverridesNeeded.kt")
        public void testNoDirectOverridesNeeded() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/noDirectOverridesNeeded.kt");
        }

        @TestMetadata("noInheritors.kt")
        public void testNoInheritors() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/noInheritors.kt");
        }

        @TestMetadata("notAbstractInClass.kt")
        public void testNotAbstractInClass() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/notAbstractInClass.kt");
        }

        @TestMetadata("notAbstractNoBodyInClass.kt")
        public void testNotAbstractNoBodyInClass() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/notAbstractNoBodyInClass.kt");
        }

        @TestMetadata("notAbstractWithGetterInInterface.kt")
        public void testNotAbstractWithGetterInInterface() throws Exception {
            runTest("idea/testData/intentions/implementAsConstructorParameter/notAbstractWithGetterInInterface.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/importAllMembers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImportAllMembers extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInImportAllMembers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/importAllMembers"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AlreadyImported.kt")
        public void testAlreadyImported() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/AlreadyImported.kt");
        }

        @TestMetadata("AlreadyImportedWithStar.kt")
        public void testAlreadyImportedWithStar() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/AlreadyImportedWithStar.kt");
        }

        @TestMetadata("AmbiguousCalls.kt")
        public void testAmbiguousCalls() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/AmbiguousCalls.kt");
        }

        @TestMetadata("EnumMembers.kt")
        public void testEnumMembers() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/EnumMembers.kt");
        }

        @TestMetadata("ImportAllMembersInImport.kt")
        public void testImportAllMembersInImport() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/ImportAllMembersInImport.kt");
        }

        @TestMetadata("NotFromCompanionObject.kt")
        public void testNotFromCompanionObject() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/NotFromCompanionObject.kt");
        }

        @TestMetadata("NotFromObject.kt")
        public void testNotFromObject() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/NotFromObject.kt");
        }

        @TestMetadata("QualifiedName.kt")
        public void testQualifiedName() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/QualifiedName.kt");
        }

        @TestMetadata("QualifiedName2.kt")
        public void testQualifiedName2() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/QualifiedName2.kt");
        }

        @TestMetadata("RemoveSingleImports.kt")
        public void testRemoveSingleImports() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/RemoveSingleImports.kt");
        }

        @TestMetadata("StaticJavaMembers.kt")
        public void testStaticJavaMembers() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/StaticJavaMembers.kt");
        }

        @TestMetadata("TypeReference.kt")
        public void testTypeReference() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/TypeReference.kt");
        }

        @TestMetadata("TypeReference2.kt")
        public void testTypeReference2() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/TypeReference2.kt");
        }

        @TestMetadata("UnresolvedMember.kt")
        public void testUnresolvedMember() throws Exception {
            runTest("idea/testData/intentions/importAllMembers/UnresolvedMember.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/importMember")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ImportMember extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInImportMember() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/importMember"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("EnumMember.kt")
        public void testEnumMember() throws Exception {
            runTest("idea/testData/intentions/importMember/EnumMember.kt");
        }

        @TestMetadata("FqReference.kt")
        public void testFqReference() throws Exception {
            runTest("idea/testData/intentions/importMember/FqReference.kt");
        }

        @TestMetadata("FqReferenceCall.kt")
        public void testFqReferenceCall() throws Exception {
            runTest("idea/testData/intentions/importMember/FqReferenceCall.kt");
        }

        @TestMetadata("FqReferenceForNestedMember.kt")
        public void testFqReferenceForNestedMember() throws Exception {
            runTest("idea/testData/intentions/importMember/FqReferenceForNestedMember.kt");
        }

        @TestMetadata("FqReferenceForNestedMember2.kt")
        public void testFqReferenceForNestedMember2() throws Exception {
            runTest("idea/testData/intentions/importMember/FqReferenceForNestedMember2.kt");
        }

        @TestMetadata("FromCompanionObject.kt")
        public void testFromCompanionObject() throws Exception {
            runTest("idea/testData/intentions/importMember/FromCompanionObject.kt");
        }

        @TestMetadata("ImportMemberInImport.kt")
        public void testImportMemberInImport() throws Exception {
            runTest("idea/testData/intentions/importMember/ImportMemberInImport.kt");
        }

        @TestMetadata("ImportMemberInMiddleOfImport.kt")
        public void testImportMemberInMiddleOfImport() throws Exception {
            runTest("idea/testData/intentions/importMember/ImportMemberInMiddleOfImport.kt");
        }

        @TestMetadata("NestedClass1.kt")
        public void testNestedClass1() throws Exception {
            runTest("idea/testData/intentions/importMember/NestedClass1.kt");
        }

        @TestMetadata("NestedClass2.kt")
        public void testNestedClass2() throws Exception {
            runTest("idea/testData/intentions/importMember/NestedClass2.kt");
        }

        @TestMetadata("NoTarget.kt")
        public void testNoTarget() throws Exception {
            runTest("idea/testData/intentions/importMember/NoTarget.kt");
        }

        @TestMetadata("NotApplicablePackage.kt")
        public void testNotApplicablePackage() throws Exception {
            runTest("idea/testData/intentions/importMember/NotApplicablePackage.kt");
        }

        @TestMetadata("NotForQualifier.kt")
        public void testNotForQualifier() throws Exception {
            runTest("idea/testData/intentions/importMember/NotForQualifier.kt");
        }

        @TestMetadata("ObjectMethod.kt")
        public void testObjectMethod() throws Exception {
            runTest("idea/testData/intentions/importMember/ObjectMethod.kt");
        }

        @TestMetadata("StaticJavaField.kt")
        public void testStaticJavaField() throws Exception {
            runTest("idea/testData/intentions/importMember/StaticJavaField.kt");
        }

        @TestMetadata("StaticJavaMethod.kt")
        public void testStaticJavaMethod() throws Exception {
            runTest("idea/testData/intentions/importMember/StaticJavaMethod.kt");
        }

        @TestMetadata("TopLevelFun.kt")
        public void testTopLevelFun() throws Exception {
            runTest("idea/testData/intentions/importMember/TopLevelFun.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/indentRawString")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IndentRawString extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIndentRawString() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/indentRawString"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hasIndent.kt")
        public void testHasIndent() throws Exception {
            runTest("idea/testData/intentions/indentRawString/hasIndent.kt");
        }

        @TestMetadata("notRawString.kt")
        public void testNotRawString() throws Exception {
            runTest("idea/testData/intentions/indentRawString/notRawString.kt");
        }

        @TestMetadata("receiver.kt")
        public void testReceiver() throws Exception {
            runTest("idea/testData/intentions/indentRawString/receiver.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/indentRawString/simple.kt");
        }

        @TestMetadata("singleLine.kt")
        public void testSingleLine() throws Exception {
            runTest("idea/testData/intentions/indentRawString/singleLine.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/infixCallToOrdinary")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InfixCallToOrdinary extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInfixCallToOrdinary() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/infixCallToOrdinary"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("functionCallAfterInfixCall.kt")
        public void testFunctionCallAfterInfixCall() throws Exception {
            runTest("idea/testData/intentions/infixCallToOrdinary/functionCallAfterInfixCall.kt");
        }

        @TestMetadata("functionLiteralArgument.kt")
        public void testFunctionLiteralArgument() throws Exception {
            runTest("idea/testData/intentions/infixCallToOrdinary/functionLiteralArgument.kt");
        }

        @TestMetadata("nonApplicableBinaryOperation.kt")
        public void testNonApplicableBinaryOperation() throws Exception {
            runTest("idea/testData/intentions/infixCallToOrdinary/nonApplicableBinaryOperation.kt");
        }

        @TestMetadata("nullAssertedCall.kt")
        public void testNullAssertedCall() throws Exception {
            runTest("idea/testData/intentions/infixCallToOrdinary/nullAssertedCall.kt");
        }

        @TestMetadata("parenthesesAroundRightHandArgument.kt")
        public void testParenthesesAroundRightHandArgument() throws Exception {
            runTest("idea/testData/intentions/infixCallToOrdinary/parenthesesAroundRightHandArgument.kt");
        }

        @TestMetadata("simpleInfixFunctionCall.kt")
        public void testSimpleInfixFunctionCall() throws Exception {
            runTest("idea/testData/intentions/infixCallToOrdinary/simpleInfixFunctionCall.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/insertCurlyBracesToTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InsertCurlyBracesToTemplate extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInsertCurlyBracesToTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/insertCurlyBracesToTemplate"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("dontInsertBrackets1.kt")
        public void testDontInsertBrackets1() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/dontInsertBrackets1.kt");
        }

        @TestMetadata("insertBrackets1.kt")
        public void testInsertBrackets1() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets1.kt");
        }

        @TestMetadata("insertBrackets2.kt")
        public void testInsertBrackets2() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets2.kt");
        }

        @TestMetadata("insertBrackets3.kt")
        public void testInsertBrackets3() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets3.kt");
        }

        @TestMetadata("insertBrackets4.kt")
        public void testInsertBrackets4() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets4.kt");
        }

        @TestMetadata("insertBrackets5.kt")
        public void testInsertBrackets5() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/insertBrackets5.kt");
        }

        @TestMetadata("insertBracketsEnd.kt")
        public void testInsertBracketsEnd() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/insertBracketsEnd.kt");
        }

        @TestMetadata("insertBracketsMiddle.kt")
        public void testInsertBracketsMiddle() throws Exception {
            runTest("idea/testData/intentions/insertCurlyBracesToTemplate/insertBracketsMiddle.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/insertExplicitTypeArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InsertExplicitTypeArguments extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInsertExplicitTypeArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/insertExplicitTypeArguments"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicableAlreadyTyped.kt")
        public void testInapplicableAlreadyTyped() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/inapplicableAlreadyTyped.kt");
        }

        @TestMetadata("inapplicableNotGeneric.kt")
        public void testInapplicableNotGeneric() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/inapplicableNotGeneric.kt");
        }

        @TestMetadata("inapplicableNotInCallable.kt")
        public void testInapplicableNotInCallable() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/inapplicableNotInCallable.kt");
        }

        @TestMetadata("inapplicableNotInCallable2.kt")
        public void testInapplicableNotInCallable2() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/inapplicableNotInCallable2.kt");
        }

        @TestMetadata("inapplicableTypeNotInferred.kt")
        public void testInapplicableTypeNotInferred() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/inapplicableTypeNotInferred.kt");
        }

        @TestMetadata("insertImportForArg.kt")
        public void testInsertImportForArg() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertImportForArg.kt");
        }

        @TestMetadata("insertManyTypes.kt")
        public void testInsertManyTypes() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertManyTypes.kt");
        }

        @TestMetadata("insertManyTypesInDifferentOrder.kt")
        public void testInsertManyTypesInDifferentOrder() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertManyTypesInDifferentOrder.kt");
        }

        @TestMetadata("insertMultipleSomeWithClashingName.kt")
        public void testInsertMultipleSomeWithClashingName() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertMultipleSomeWithClashingName.kt");
        }

        @TestMetadata("insertTwoTypesFun.kt")
        public void testInsertTwoTypesFun() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTwoTypesFun.kt");
        }

        @TestMetadata("insertTypeAny.kt")
        public void testInsertTypeAny() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTypeAny.kt");
        }

        @TestMetadata("insertTypeThatIsAFunction.kt")
        public void testInsertTypeThatIsAFunction() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTypeThatIsAFunction.kt");
        }

        @TestMetadata("insertTypeThatIsATypeArg.kt")
        public void testInsertTypeThatIsATypeArg() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTypeThatIsATypeArg.kt");
        }

        @TestMetadata("insertTypeWithClashingName.kt")
        public void testInsertTypeWithClashingName() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithClashingName.kt");
        }

        @TestMetadata("insertTypeWithLambda.kt")
        public void testInsertTypeWithLambda() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithLambda.kt");
        }

        @TestMetadata("insertTypeWithTypeArguments.kt")
        public void testInsertTypeWithTypeArguments() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithTypeArguments.kt");
        }

        @TestMetadata("insertTypeWithVarargs.kt")
        public void testInsertTypeWithVarargs() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/insertTypeWithVarargs.kt");
        }

        @TestMetadata("notApplicableGenericType.kt")
        public void testNotApplicableGenericType() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/notApplicableGenericType.kt");
        }

        @TestMetadata("simpleInsertTypeClass.kt")
        public void testSimpleInsertTypeClass() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/simpleInsertTypeClass.kt");
        }

        @TestMetadata("simpleInsertTypeFun.kt")
        public void testSimpleInsertTypeFun() throws Exception {
            runTest("idea/testData/intentions/insertExplicitTypeArguments/simpleInsertTypeFun.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/introduceBackingProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceBackingProperty extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIntroduceBackingProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/introduceBackingProperty"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("backingFieldRef.kt")
        public void testBackingFieldRef() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/backingFieldRef.kt");
        }

        @TestMetadata("const.kt")
        public void testConst() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/const.kt");
        }

        @TestMetadata("expectClass.kt")
        public void testExpectClass() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/expectClass.kt");
        }

        @TestMetadata("inapplicableAbstractProperty.kt")
        public void testInapplicableAbstractProperty() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/inapplicableAbstractProperty.kt");
        }

        @TestMetadata("inapplicableNoBackingField.kt")
        public void testInapplicableNoBackingField() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/inapplicableNoBackingField.kt");
        }

        @TestMetadata("jvmField.kt")
        public void testJvmField() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/jvmField.kt");
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/semicolon.kt");
        }

        @TestMetadata("simpleVal.kt")
        public void testSimpleVal() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/simpleVal.kt");
        }

        @TestMetadata("simpleValWithType.kt")
        public void testSimpleValWithType() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/simpleValWithType.kt");
        }

        @TestMetadata("simpleVar.kt")
        public void testSimpleVar() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/simpleVar.kt");
        }

        @TestMetadata("valWithAccessor.kt")
        public void testValWithAccessor() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/valWithAccessor.kt");
        }

        @TestMetadata("varWithAccessor.kt")
        public void testVarWithAccessor() throws Exception {
            runTest("idea/testData/intentions/introduceBackingProperty/varWithAccessor.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/introduceImportAlias")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceImportAlias extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addImport.kt")
        public void testAddImport() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/addImport.kt");
        }

        @TestMetadata("addImportHasOtherAlias.kt")
        public void testAddImportHasOtherAlias() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/addImportHasOtherAlias.kt");
        }

        @TestMetadata("addImportWithDefaultClass.kt")
        public void testAddImportWithDefaultClass() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/addImportWithDefaultClass.kt");
        }

        @TestMetadata("addImportWithDefaultClassAndFunction.kt")
        public void testAddImportWithDefaultClassAndFunction() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/addImportWithDefaultClassAndFunction.kt");
        }

        @TestMetadata("addImportWithDefaultClassCompanion.kt")
        public void testAddImportWithDefaultClassCompanion() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/addImportWithDefaultClassCompanion.kt");
        }

        @TestMetadata("addImportWithDefaultClassCompanion2.kt")
        public void testAddImportWithDefaultClassCompanion2() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/addImportWithDefaultClassCompanion2.kt");
        }

        public void testAllFilesPresentInIntroduceImportAlias() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/introduceImportAlias"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyImportAlias.kt")
        public void testAlreadyImportAlias() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/alreadyImportAlias.kt");
        }

        @TestMetadata("class.kt")
        public void testClass() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/class.kt");
        }

        @TestMetadata("classWithConstructor.kt")
        public void testClassWithConstructor() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/classWithConstructor.kt");
        }

        @TestMetadata("conflictLocalName.kt")
        public void testConflictLocalName() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/conflictLocalName.kt");
        }

        @TestMetadata("conflictLocalName2.kt")
        public void testConflictLocalName2() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/conflictLocalName2.kt");
        }

        @TestMetadata("conflictPackage.kt")
        public void testConflictPackage() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/conflictPackage.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/function.kt");
        }

        @TestMetadata("middleImport.kt")
        public void testMiddleImport() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/middleImport.kt");
        }

        @TestMetadata("notApplicableAlias.kt")
        public void testNotApplicableAlias() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/notApplicableAlias.kt");
        }

        @TestMetadata("notApplicableLocalClass.kt")
        public void testNotApplicableLocalClass() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/notApplicableLocalClass.kt");
        }

        @TestMetadata("notApplicableLocalVariable.kt")
        public void testNotApplicableLocalVariable() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/notApplicableLocalVariable.kt");
        }

        @TestMetadata("notApplicablePackage.kt")
        public void testNotApplicablePackage() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/notApplicablePackage.kt");
        }

        @TestMetadata("notApplicableStar.kt")
        public void testNotApplicableStar() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/notApplicableStar.kt");
        }

        @TestMetadata("notApplicableSuper.kt")
        public void testNotApplicableSuper() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/notApplicableSuper.kt");
        }

        @TestMetadata("notApplicableThis.kt")
        public void testNotApplicableThis() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/notApplicableThis.kt");
        }

        @TestMetadata("onImport.kt")
        public void testOnImport() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/onImport.kt");
        }

        @TestMetadata("userType.kt")
        public void testUserType() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/userType.kt");
        }

        @TestMetadata("userTypeInner.kt")
        public void testUserTypeInner() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/userTypeInner.kt");
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/variable.kt");
        }

        @TestMetadata("withReceiver.kt")
        public void testWithReceiver() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/withReceiver.kt");
        }

        @TestMetadata("withReceiver2.kt")
        public void testWithReceiver2() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/withReceiver2.kt");
        }

        @TestMetadata("withReceiver3.kt")
        public void testWithReceiver3() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/withReceiver3.kt");
        }

        @TestMetadata("withReceiver4.kt")
        public void testWithReceiver4() throws Exception {
            runTest("idea/testData/intentions/introduceImportAlias/withReceiver4.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/introduceVariable")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IntroduceVariable extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("afterExpression.kt")
        public void testAfterExpression() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/afterExpression.kt");
        }

        public void testAllFilesPresentInIntroduceVariable() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/introduceVariable"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("atExpressionEnd.kt")
        public void testAtExpressionEnd() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/atExpressionEnd.kt");
        }

        @TestMetadata("atExpressionStart.kt")
        public void testAtExpressionStart() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/atExpressionStart.kt");
        }

        @TestMetadata("atNestedExpression.kt")
        public void testAtNestedExpression() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/atNestedExpression.kt");
        }

        @TestMetadata("beforeExpression.kt")
        public void testBeforeExpression() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/beforeExpression.kt");
        }

        @TestMetadata("noType.kt")
        public void testNoType() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/noType.kt");
        }

        @TestMetadata("nothingType.kt")
        public void testNothingType() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/nothingType.kt");
        }

        @TestMetadata("unitType.kt")
        public void testUnitType() throws Exception {
            runTest("idea/testData/intentions/introduceVariable/unitType.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/invertIfCondition")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InvertIfCondition extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addSurroundingBlock_preserveComments.kt")
        public void testAddSurroundingBlock_preserveComments() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/addSurroundingBlock_preserveComments.kt");
        }

        public void testAllFilesPresentInInvertIfCondition() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/invertIfCondition"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignedToValue.kt")
        public void testAssignedToValue() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/assignedToValue.kt");
        }

        @TestMetadata("binaryExpression.kt")
        public void testBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/binaryExpression.kt");
        }

        @TestMetadata("booleanLiteral.kt")
        public void testBooleanLiteral() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/booleanLiteral.kt");
        }

        @TestMetadata("branchingIfStatements.kt")
        public void testBranchingIfStatements() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/branchingIfStatements.kt");
        }

        @TestMetadata("endOfLineCommentBug.kt")
        public void testEndOfLineCommentBug() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/endOfLineCommentBug.kt");
        }

        @TestMetadata("forLoopWithMultipleExpressions.kt")
        public void testForLoopWithMultipleExpressions() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/forLoopWithMultipleExpressions.kt");
        }

        @TestMetadata("functionWithReturnExpression.kt")
        public void testFunctionWithReturnExpression() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/functionWithReturnExpression.kt");
        }

        @TestMetadata("ifExpressionInsideForLoop.kt")
        public void testIfExpressionInsideForLoop() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifExpressionInsideForLoop.kt");
        }

        @TestMetadata("ifExpressionWithReturn.kt")
        public void testIfExpressionWithReturn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifExpressionWithReturn.kt");
        }

        @TestMetadata("ifThenReturn.kt")
        public void testIfThenReturn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifThenReturn.kt");
        }

        @TestMetadata("ifThenReturn2.kt")
        public void testIfThenReturn2() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifThenReturn2.kt");
        }

        @TestMetadata("ifThenReturn3.kt")
        public void testIfThenReturn3() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifThenReturn3.kt");
        }

        @TestMetadata("ifThenReturn4.kt")
        public void testIfThenReturn4() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifThenReturn4.kt");
        }

        @TestMetadata("ifWithBothBranchesReturn.kt")
        public void testIfWithBothBranchesReturn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifWithBothBranchesReturn.kt");
        }

        @TestMetadata("ifWithBothBranchesSetter.kt")
        public void testIfWithBothBranchesSetter() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/ifWithBothBranchesSetter.kt");
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/in.kt");
        }

        @TestMetadata("invertableOperator.kt")
        public void testInvertableOperator() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/invertableOperator.kt");
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/is.kt");
        }

        @TestMetadata("lambdaNonLocalAndLocalReturn.kt")
        public void testLambdaNonLocalAndLocalReturn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lambdaNonLocalAndLocalReturn.kt");
        }

        @TestMetadata("lambdaNonLocalReturn.kt")
        public void testLambdaNonLocalReturn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lambdaNonLocalReturn.kt");
        }

        @TestMetadata("lastStatement1.kt")
        public void testLastStatement1() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatement1.kt");
        }

        @TestMetadata("lastStatement2.kt")
        public void testLastStatement2() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatement2.kt");
        }

        @TestMetadata("lastStatement3.kt")
        public void testLastStatement3() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatement3.kt");
        }

        @TestMetadata("lastStatementBeforeBreak.kt")
        public void testLastStatementBeforeBreak() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatementBeforeBreak.kt");
        }

        @TestMetadata("lastStatementBeforeContinue.kt")
        public void testLastStatementBeforeContinue() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatementBeforeContinue.kt");
        }

        @TestMetadata("lastStatementBeforeReturn.kt")
        public void testLastStatementBeforeReturn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatementBeforeReturn.kt");
        }

        @TestMetadata("lastStatementInLambda.kt")
        public void testLastStatementInLambda() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatementInLambda.kt");
        }

        @TestMetadata("lastStatementInLoop.kt")
        public void testLastStatementInLoop() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatementInLoop.kt");
        }

        @TestMetadata("lastStatementInLoop2.kt")
        public void testLastStatementInLoop2() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatementInLoop2.kt");
        }

        @TestMetadata("lastStatementNonUnitMethod.kt")
        public void testLastStatementNonUnitMethod() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/lastStatementNonUnitMethod.kt");
        }

        @TestMetadata("negatedExpression.kt")
        public void testNegatedExpression() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/negatedExpression.kt");
        }

        @TestMetadata("nestedIfWithReturn.kt")
        public void testNestedIfWithReturn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/nestedIfWithReturn.kt");
        }

        @TestMetadata("notBlock.kt")
        public void testNotBlock() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/notBlock.kt");
        }

        @TestMetadata("notBlock2.kt")
        public void testNotBlock2() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/notBlock2.kt");
        }

        @TestMetadata("notBlock3.kt")
        public void testNotBlock3() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/notBlock3.kt");
        }

        @TestMetadata("notIn.kt")
        public void testNotIn() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/notIn.kt");
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/notIs.kt");
        }

        @TestMetadata("returnIfExpression.kt")
        public void testReturnIfExpression() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/returnIfExpression.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/simple.kt");
        }

        @TestMetadata("valueAndReturnBranches.kt")
        public void testValueAndReturnBranches() throws Exception {
            runTest("idea/testData/intentions/invertIfCondition/valueAndReturnBranches.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/iterateExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IterateExpression extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIterateExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/iterateExpression"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("collectionIteratorWithComponents.kt")
        public void testCollectionIteratorWithComponents() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/collectionIteratorWithComponents.kt");
        }

        @TestMetadata("dataClassCollectionIterator.kt")
        public void testDataClassCollectionIterator() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/dataClassCollectionIterator.kt");
        }

        @TestMetadata("extensionIterator.kt")
        public void testExtensionIterator() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/extensionIterator.kt");
        }

        @TestMetadata("extensionIteratorWithPartialSubstitution1.kt")
        public void testExtensionIteratorWithPartialSubstitution1() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/extensionIteratorWithPartialSubstitution1.kt");
        }

        @TestMetadata("extensionIteratorWithPartialSubstitution2.kt")
        public void testExtensionIteratorWithPartialSubstitution2() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/extensionIteratorWithPartialSubstitution2.kt");
        }

        @TestMetadata("functionCall.kt")
        public void testFunctionCall() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/functionCall.kt");
        }

        @TestMetadata("mapIterator.kt")
        public void testMapIterator() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/mapIterator.kt");
        }

        @TestMetadata("nameSuggestion.kt")
        public void testNameSuggestion() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/nameSuggestion.kt");
        }

        @TestMetadata("noNameConflict.kt")
        public void testNoNameConflict() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/noNameConflict.kt");
        }

        @TestMetadata("nonOperatorIterator.kt")
        public void testNonOperatorIterator() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/nonOperatorIterator.kt");
        }

        @TestMetadata("nonOperatotExtensionIterator.kt")
        public void testNonOperatotExtensionIterator() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/nonOperatotExtensionIterator.kt");
        }

        @TestMetadata("nothing.kt")
        public void testNothing() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/nothing.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/iterateExpression/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/iterationOverMap")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IterationOverMap extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIterationOverMap() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/iterationOverMap"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AlreadyDestructing.kt")
        public void testAlreadyDestructing() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/AlreadyDestructing.kt");
        }

        @TestMetadata("CaretOffset.kt")
        public void testCaretOffset() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/CaretOffset.kt");
        }

        @TestMetadata("DataClass.kt")
        public void testDataClass() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClass.kt");
        }

        @TestMetadata("DataClassDependentLocal.kt")
        public void testDataClassDependentLocal() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassDependentLocal.kt");
        }

        @TestMetadata("DataClassFirstNPropertiesUsed.kt")
        public void testDataClassFirstNPropertiesUsed() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassFirstNPropertiesUsed.kt");
        }

        @TestMetadata("DataClassFirstVariable.kt")
        public void testDataClassFirstVariable() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassFirstVariable.kt");
        }

        @TestMetadata("DataClassLast.kt")
        public void testDataClassLast() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassLast.kt");
        }

        @TestMetadata("DataClassNameConflict.kt")
        public void testDataClassNameConflict() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassNameConflict.kt");
        }

        @TestMetadata("DataClassNoVariablesInside.kt")
        public void testDataClassNoVariablesInside() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassNoVariablesInside.kt");
        }

        @TestMetadata("DataClassNoVariablesMultiUsages.kt")
        public void testDataClassNoVariablesMultiUsages() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassNoVariablesMultiUsages.kt");
        }

        @TestMetadata("DataClassNotAllPropertiesUsed.kt")
        public void testDataClassNotAllPropertiesUsed() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassNotAllPropertiesUsed.kt");
        }

        @TestMetadata("DataClassNullable.kt")
        public void testDataClassNullable() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassNullable.kt");
        }

        @TestMetadata("DataClassParametersOrder.kt")
        public void testDataClassParametersOrder() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassParametersOrder.kt");
        }

        @TestMetadata("DataClassPropertyBetweenUsages.kt")
        public void testDataClassPropertyBetweenUsages() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassPropertyBetweenUsages.kt");
        }

        @TestMetadata("DataClassSecondVariable.kt")
        public void testDataClassSecondVariable() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassSecondVariable.kt");
        }

        @TestMetadata("DataClassTwoDifferentLocals.kt")
        public void testDataClassTwoDifferentLocals() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassTwoDifferentLocals.kt");
        }

        @TestMetadata("DataClassUnused.kt")
        public void testDataClassUnused() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassUnused.kt");
        }

        @TestMetadata("DataClassWithAssignmentInside.kt")
        public void testDataClassWithAssignmentInside() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithAssignmentInside.kt");
        }

        @TestMetadata("DataClassWithDestructuring.kt")
        public void testDataClassWithDestructuring() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithDestructuring.kt");
        }

        @TestMetadata("DataClassWithDestructuringConflict.kt")
        public void testDataClassWithDestructuringConflict() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithDestructuringConflict.kt");
        }

        @TestMetadata("DataClassWithDestructuringFakeConflict.kt")
        public void testDataClassWithDestructuringFakeConflict() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithDestructuringFakeConflict.kt");
        }

        @TestMetadata("DataClassWithDestructuringPartial.kt")
        public void testDataClassWithDestructuringPartial() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithDestructuringPartial.kt");
        }

        @TestMetadata("DataClassWithExternalUsage.kt")
        public void testDataClassWithExternalUsage() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithExternalUsage.kt");
        }

        @TestMetadata("DataClassWithIncrementInside.kt")
        public void testDataClassWithIncrementInside() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithIncrementInside.kt");
        }

        @TestMetadata("DataClassWithLocalPropertyModified.kt")
        public void testDataClassWithLocalPropertyModified() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/DataClassWithLocalPropertyModified.kt");
        }

        @TestMetadata("EntriesCallIsMissing.kt")
        public void testEntriesCallIsMissing() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/EntriesCallIsMissing.kt");
        }

        @TestMetadata("FakeEntries.kt")
        public void testFakeEntries() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/FakeEntries.kt");
        }

        @TestMetadata("Getters.kt")
        public void testGetters() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/Getters.kt");
        }

        @TestMetadata("KeyOnly.kt")
        public void testKeyOnly() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/KeyOnly.kt");
        }

        @TestMetadata("KeyOnlyWithDestructuring.kt")
        public void testKeyOnlyWithDestructuring() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/KeyOnlyWithDestructuring.kt");
        }

        @TestMetadata("KeyValueWithDestructuring.kt")
        public void testKeyValueWithDestructuring() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/KeyValueWithDestructuring.kt");
        }

        @TestMetadata("MapNoProperties.kt")
        public void testMapNoProperties() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/MapNoProperties.kt");
        }

        @TestMetadata("NoKeyOrValue.kt")
        public void testNoKeyOrValue() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/NoKeyOrValue.kt");
        }

        @TestMetadata("OnlyKeyUsed.kt")
        public void testOnlyKeyUsed() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/OnlyKeyUsed.kt");
        }

        @TestMetadata("OtherUsages.kt")
        public void testOtherUsages() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/OtherUsages.kt");
        }

        @TestMetadata("OtherUsages2.kt")
        public void testOtherUsages2() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/OtherUsages2.kt");
        }

        @TestMetadata("PropertiesNames.kt")
        public void testPropertiesNames() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/PropertiesNames.kt");
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/Simple.kt");
        }

        @TestMetadata("SomeQualifiedExpressionInRange.kt")
        public void testSomeQualifiedExpressionInRange() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/SomeQualifiedExpressionInRange.kt");
        }

        @TestMetadata("ValueOnly.kt")
        public void testValueOnly() throws Exception {
            runTest("idea/testData/intentions/iterationOverMap/ValueOnly.kt");
        }

        @TestMetadata("idea/testData/intentions/iterationOverMap/inspectionData")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InspectionData extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInspectionData() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/iterationOverMap/inspectionData"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/joinArgumentList")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JoinArgumentList extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJoinArgumentList() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/joinArgumentList"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hasLineBreakBeforeFirstArg.kt")
        public void testHasLineBreakBeforeFirstArg() throws Exception {
            runTest("idea/testData/intentions/joinArgumentList/hasLineBreakBeforeFirstArg.kt");
        }

        @TestMetadata("hasLineBreaks.kt")
        public void testHasLineBreaks() throws Exception {
            runTest("idea/testData/intentions/joinArgumentList/hasLineBreaks.kt");
        }

        @TestMetadata("noArg.kt")
        public void testNoArg() throws Exception {
            runTest("idea/testData/intentions/joinArgumentList/noArg.kt");
        }

        @TestMetadata("noLineBreak.kt")
        public void testNoLineBreak() throws Exception {
            runTest("idea/testData/intentions/joinArgumentList/noLineBreak.kt");
        }

        @TestMetadata("oneArg.kt")
        public void testOneArg() throws Exception {
            runTest("idea/testData/intentions/joinArgumentList/oneArg.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/joinDeclarationAndAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JoinDeclarationAndAssignment extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJoinDeclarationAndAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/joinDeclarationAndAssignment"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignmentForFlexible.kt")
        public void testAssignmentForFlexible() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/assignmentForFlexible.kt");
        }

        @TestMetadata("assignmentForSmartCast.kt")
        public void testAssignmentForSmartCast() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/assignmentForSmartCast.kt");
        }

        @TestMetadata("assignmentInIf.kt")
        public void testAssignmentInIf() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/assignmentInIf.kt");
        }

        @TestMetadata("cannotRemoveType.kt")
        public void testCannotRemoveType() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/cannotRemoveType.kt");
        }

        @TestMetadata("cannotRemoveType2.kt")
        public void testCannotRemoveType2() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/cannotRemoveType2.kt");
        }

        @TestMetadata("capturedInitialization.kt")
        public void testCapturedInitialization() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/capturedInitialization.kt");
        }

        @TestMetadata("caretOnHeadComment.kt")
        public void testCaretOnHeadComment() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/caretOnHeadComment.kt");
        }

        @TestMetadata("caretOnTailComment.kt")
        public void testCaretOnTailComment() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/caretOnTailComment.kt");
        }

        @TestMetadata("comment.kt")
        public void testComment() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/comment.kt");
        }

        @TestMetadata("correctConditionalAssignment.kt")
        public void testCorrectConditionalAssignment() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/correctConditionalAssignment.kt");
        }

        @TestMetadata("deleteInitBlock.kt")
        public void testDeleteInitBlock() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/deleteInitBlock.kt");
        }

        @TestMetadata("hasLateinit.kt")
        public void testHasLateinit() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/hasLateinit.kt");
        }

        @TestMetadata("incorrectConditionalAssignment.kt")
        public void testIncorrectConditionalAssignment() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/incorrectConditionalAssignment.kt");
        }

        @TestMetadata("multipleConstructors.kt")
        public void testMultipleConstructors() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/multipleConstructors.kt");
        }

        @TestMetadata("multipleConstructorsWithThis.kt")
        public void testMultipleConstructorsWithThis() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/multipleConstructorsWithThis.kt");
        }

        @TestMetadata("notFirstInitLine.kt")
        public void testNotFirstInitLine() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/notFirstInitLine.kt");
        }

        @TestMetadata("notFirstSecondaryConstructorLine.kt")
        public void testNotFirstSecondaryConstructorLine() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/notFirstSecondaryConstructorLine.kt");
        }

        @TestMetadata("propertyReassignment.kt")
        public void testPropertyReassignment() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/propertyReassignment.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/simple.kt");
        }

        @TestMetadata("simpleLocal.kt")
        public void testSimpleLocal() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/simpleLocal.kt");
        }

        @TestMetadata("singleConstructor.kt")
        public void testSingleConstructor() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/singleConstructor.kt");
        }

        @TestMetadata("usedLocal.kt")
        public void testUsedLocal() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/usedLocal.kt");
        }

        @TestMetadata("usedLocal2.kt")
        public void testUsedLocal2() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/usedLocal2.kt");
        }

        @TestMetadata("varReassignment.kt")
        public void testVarReassignment() throws Exception {
            runTest("idea/testData/intentions/joinDeclarationAndAssignment/varReassignment.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/joinParameterList")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class JoinParameterList extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInJoinParameterList() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/joinParameterList"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hasLineBreakBeforeFirstParam.kt")
        public void testHasLineBreakBeforeFirstParam() throws Exception {
            runTest("idea/testData/intentions/joinParameterList/hasLineBreakBeforeFirstParam.kt");
        }

        @TestMetadata("hasLineBreaks.kt")
        public void testHasLineBreaks() throws Exception {
            runTest("idea/testData/intentions/joinParameterList/hasLineBreaks.kt");
        }

        @TestMetadata("noLineBreak.kt")
        public void testNoLineBreak() throws Exception {
            runTest("idea/testData/intentions/joinParameterList/noLineBreak.kt");
        }

        @TestMetadata("noParam.kt")
        public void testNoParam() throws Exception {
            runTest("idea/testData/intentions/joinParameterList/noParam.kt");
        }

        @TestMetadata("oneParam.kt")
        public void testOneParam() throws Exception {
            runTest("idea/testData/intentions/joinParameterList/oneParam.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/lambdaToAnonymousFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LambdaToAnonymousFunction extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLambdaToAnonymousFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/lambdaToAnonymousFunction"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argument.kt")
        public void testArgument() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/argument.kt");
        }

        @TestMetadata("destructuringParameter.kt")
        public void testDestructuringParameter() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/destructuringParameter.kt");
        }

        @TestMetadata("explicitParameterName.kt")
        public void testExplicitParameterName() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/explicitParameterName.kt");
        }

        @TestMetadata("extention1.kt")
        public void testExtention1() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/extention1.kt");
        }

        @TestMetadata("extention2.kt")
        public void testExtention2() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/extention2.kt");
        }

        @TestMetadata("fullyQualified.kt")
        public void testFullyQualified() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/fullyQualified.kt");
        }

        @TestMetadata("hasComment.kt")
        public void testHasComment() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/hasComment.kt");
        }

        @TestMetadata("hasReturn1.kt")
        public void testHasReturn1() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/hasReturn1.kt");
        }

        @TestMetadata("hasReturn2.kt")
        public void testHasReturn2() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/hasReturn2.kt");
        }

        @TestMetadata("hasReturn3.kt")
        public void testHasReturn3() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/hasReturn3.kt");
        }

        @TestMetadata("hasReturn4.kt")
        public void testHasReturn4() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/hasReturn4.kt");
        }

        @TestMetadata("hasSomeStatements.kt")
        public void testHasSomeStatements() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/hasSomeStatements.kt");
        }

        @TestMetadata("implicitParameterName.kt")
        public void testImplicitParameterName() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/implicitParameterName.kt");
        }

        @TestMetadata("inInlineFunction.kt")
        public void testInInlineFunction() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/inInlineFunction.kt");
        }

        @TestMetadata("incorrectOffset.kt")
        public void testIncorrectOffset() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/incorrectOffset.kt");
        }

        @TestMetadata("namedArgument.kt")
        public void testNamedArgument() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/namedArgument.kt");
        }

        @TestMetadata("noParameter.kt")
        public void testNoParameter() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/noParameter.kt");
        }

        @TestMetadata("returnUnit.kt")
        public void testReturnUnit() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/returnUnit.kt");
        }

        @TestMetadata("underscoreParameter.kt")
        public void testUnderscoreParameter() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/underscoreParameter.kt");
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/variable.kt");
        }

        @TestMetadata("withPackage.kt")
        public void testWithPackage() throws Exception {
            runTest("idea/testData/intentions/lambdaToAnonymousFunction/withPackage.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/loopToCallChain")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LoopToCallChain extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLoopToCallChain() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/array.kt");
        }

        @TestMetadata("asSequenceOnly.kt")
        public void testAsSequenceOnly() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/asSequenceOnly.kt");
        }

        @TestMetadata("customTypeWithIterator.kt")
        public void testCustomTypeWithIterator() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/customTypeWithIterator.kt");
        }

        @TestMetadata("embeddedBreak1.kt")
        public void testEmbeddedBreak1() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/embeddedBreak1.kt");
        }

        @TestMetadata("embeddedBreak2.kt")
        public void testEmbeddedBreak2() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/embeddedBreak2.kt");
        }

        @TestMetadata("embeddedContinue.kt")
        public void testEmbeddedContinue() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/embeddedContinue.kt");
        }

        @TestMetadata("intArray.kt")
        public void testIntArray() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/intArray.kt");
        }

        @TestMetadata("itAlreadyUsed.kt")
        public void testItAlreadyUsed() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/itAlreadyUsed.kt");
        }

        @TestMetadata("KT14191.kt")
        public void testKT14191() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/KT14191.kt");
        }

        @TestMetadata("lastOrNull_ifAssign.kt")
        public void testLastOrNull_ifAssign() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/lastOrNull_ifAssign.kt");
        }

        @TestMetadata("moveInitializationsCloserToLoop.kt")
        public void testMoveInitializationsCloserToLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/moveInitializationsCloserToLoop.kt");
        }

        @TestMetadata("range.kt")
        public void testRange() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/range.kt");
        }

        @TestMetadata("twoInitializationsBeforeLoop.kt")
        public void testTwoInitializationsBeforeLoop() throws Exception {
            runTest("idea/testData/intentions/loopToCallChain/twoInitializationsBeforeLoop.kt");
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/any")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Any extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAny() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/any"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("anyNotNull.kt")
            public void testAnyNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/anyNotNull.kt");
            }

            @TestMetadata("ifAssign.kt")
            public void testIfAssign() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifAssign.kt");
            }

            @TestMetadata("ifAssign_moveDeclaration.kt")
            public void testIfAssign_moveDeclaration() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_moveDeclaration.kt");
            }

            @TestMetadata("ifAssign_moveInitialization.kt")
            public void testIfAssign_moveInitialization() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_moveInitialization.kt");
            }

            @TestMetadata("ifAssign_noBreak.kt")
            public void testIfAssign_noBreak() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_noBreak.kt");
            }

            @TestMetadata("ifAssign_nonBooleanResult.kt")
            public void testIfAssign_nonBooleanResult() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_nonBooleanResult.kt");
            }

            @TestMetadata("ifAssign_nonBooleanResult2.kt")
            public void testIfAssign_nonBooleanResult2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifAssign_nonBooleanResult2.kt");
            }

            @TestMetadata("ifReturn.kt")
            public void testIfReturn() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifReturn.kt");
            }

            @TestMetadata("ifReturn_nonBooleanResult.kt")
            public void testIfReturn_nonBooleanResult() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/ifReturn_nonBooleanResult.kt");
            }

            @TestMetadata("indexNeeded.kt")
            public void testIndexNeeded() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/indexNeeded.kt");
            }

            @TestMetadata("KT13998.kt")
            public void testKT13998() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/KT13998.kt");
            }

            @TestMetadata("KT13998_1.kt")
            public void testKT13998_1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/KT13998_1.kt");
            }

            @TestMetadata("kt17730.kt")
            public void testKt17730() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/kt17730.kt");
            }

            @TestMetadata("kt17730_1.kt")
            public void testKt17730_1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/kt17730_1.kt");
            }

            @TestMetadata("none.kt")
            public void testNone() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/none.kt");
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/any/return.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/contains")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Contains extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("1.kt")
            public void test1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/contains/1.kt");
            }

            @TestMetadata("2.kt")
            public void test2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/contains/2.kt");
            }

            @TestMetadata("3.kt")
            public void test3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/contains/3.kt");
            }

            @TestMetadata("4.kt")
            public void test4() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/contains/4.kt");
            }

            public void testAllFilesPresentInContains() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/contains"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/count")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Count extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("1.kt")
            public void test1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/1.kt");
            }

            @TestMetadata("2.kt")
            public void test2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/2.kt");
            }

            public void testAllFilesPresentInCount() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/count"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("countIsInstance.kt")
            public void testCountIsInstance() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/countIsInstance.kt");
            }

            @TestMetadata("countNotNull.kt")
            public void testCountNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/countNotNull.kt");
            }

            @TestMetadata("countSomethingAndNotNull.kt")
            public void testCountSomethingAndNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/countSomethingAndNotNull.kt");
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/long.kt");
            }

            @TestMetadata("nonConstantInitial.kt")
            public void testNonConstantInitial() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/nonConstantInitial.kt");
            }

            @TestMetadata("nonZeroInitial.kt")
            public void testNonZeroInitial() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/nonZeroInitial.kt");
            }

            @TestMetadata("prefix.kt")
            public void testPrefix() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/prefix.kt");
            }

            @TestMetadata("variableUsedBefore.kt")
            public void testVariableUsedBefore() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/count/variableUsedBefore.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/filter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Filter extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFilter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/filter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assign.kt")
            public void testAssign() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assign.kt");
            }

            @TestMetadata("assign2.kt")
            public void testAssign2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assign2.kt");
            }

            @TestMetadata("assignFilterIndexed.kt")
            public void testAssignFilterIndexed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assignFilterIndexed.kt");
            }

            @TestMetadata("assignFilterNotNull.kt")
            public void testAssignFilterNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assignFilterNotNull.kt");
            }

            @TestMetadata("assign_ArrayListRequired.kt")
            public void testAssign_ArrayListRequired() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired.kt");
            }

            @TestMetadata("assign_ArrayListRequired2.kt")
            public void testAssign_ArrayListRequired2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired2.kt");
            }

            @TestMetadata("assign_ArrayListRequired3.kt")
            public void testAssign_ArrayListRequired3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assign_ArrayListRequired3.kt");
            }

            @TestMetadata("assign_MutableListRequired.kt")
            public void testAssign_MutableListRequired() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assign_MutableListRequired.kt");
            }

            @TestMetadata("assign_breakAndContinue.kt")
            public void testAssign_breakAndContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/assign_breakAndContinue.kt");
            }

            @TestMetadata("cannotSplitOutFilterIsInstance.kt")
            public void testCannotSplitOutFilterIsInstance() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/cannotSplitOutFilterIsInstance.kt");
            }

            @TestMetadata("doNotSplitOutFilterIsInstance.kt")
            public void testDoNotSplitOutFilterIsInstance() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/doNotSplitOutFilterIsInstance.kt");
            }

            @TestMetadata("doNotSplitOutFilterNotNull.kt")
            public void testDoNotSplitOutFilterNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/doNotSplitOutFilterNotNull.kt");
            }

            @TestMetadata("filterIndexed.kt")
            public void testFilterIndexed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed.kt");
            }

            @TestMetadata("filterIndexed2.kt")
            public void testFilterIndexed2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed2.kt");
            }

            @TestMetadata("filterIndexedAndFlatMapWithContinue.kt")
            public void testFilterIndexedAndFlatMapWithContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexedAndFlatMapWithContinue.kt");
            }

            @TestMetadata("filterIndexedTo.kt")
            public void testFilterIndexedTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexedTo.kt");
            }

            @TestMetadata("filterIndexedTo2.kt")
            public void testFilterIndexedTo2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexedTo2.kt");
            }

            @TestMetadata("filterIndexed_indexChangedTwice.kt")
            public void testFilterIndexed_indexChangedTwice() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexChangedTwice.kt");
            }

            @TestMetadata("filterIndexed_indexStartNotZero.kt")
            public void testFilterIndexed_indexStartNotZero() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexStartNotZero.kt");
            }

            @TestMetadata("filterIndexed_indexUsedAfter.kt")
            public void testFilterIndexed_indexUsedAfter() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexUsedAfter.kt");
            }

            @TestMetadata("filterIndexed_indexUsedEarlierInLoop.kt")
            public void testFilterIndexed_indexUsedEarlierInLoop() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_indexUsedEarlierInLoop.kt");
            }

            @TestMetadata("filterIndexed_merge1.kt")
            public void testFilterIndexed_merge1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge1.kt");
            }

            @TestMetadata("filterIndexed_merge2.kt")
            public void testFilterIndexed_merge2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge2.kt");
            }

            @TestMetadata("filterIndexed_merge3.kt")
            public void testFilterIndexed_merge3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge3.kt");
            }

            @TestMetadata("filterIndexed_merge4.kt")
            public void testFilterIndexed_merge4() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_merge4.kt");
            }

            @TestMetadata("filterIndexed_twoIndices.kt")
            public void testFilterIndexed_twoIndices() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_twoIndices.kt");
            }

            @TestMetadata("filterIndexed_twoIndicesUsed.kt")
            public void testFilterIndexed_twoIndicesUsed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIndexed_twoIndicesUsed.kt");
            }

            @TestMetadata("filterIsInstance.kt")
            public void testFilterIsInstance() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIsInstance.kt");
            }

            @TestMetadata("filterIsInstanceTo.kt")
            public void testFilterIsInstanceTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIsInstanceTo.kt");
            }

            @TestMetadata("filterIsInstance_ifContinue.kt")
            public void testFilterIsInstance_ifContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterIsInstance_ifContinue.kt");
            }

            @TestMetadata("filterNotNull.kt")
            public void testFilterNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNull.kt");
            }

            @TestMetadata("filterNotNullTo.kt")
            public void testFilterNotNullTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNullTo.kt");
            }

            @TestMetadata("filterNotNullTo2.kt")
            public void testFilterNotNullTo2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNullTo2.kt");
            }

            @TestMetadata("filterNotNull_ifContinue.kt")
            public void testFilterNotNull_ifContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterNotNull_ifContinue.kt");
            }

            @TestMetadata("filterNotTo.kt")
            public void testFilterNotTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterNotTo.kt");
            }

            @TestMetadata("filterNot_ifContinue.kt")
            public void testFilterNot_ifContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterNot_ifContinue.kt");
            }

            @TestMetadata("filterTo.kt")
            public void testFilterTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterTo.kt");
            }

            @TestMetadata("filterTo2.kt")
            public void testFilterTo2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/filterTo2.kt");
            }

            @TestMetadata("glueTogetherFilterNotNull.kt")
            public void testGlueTogetherFilterNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/glueTogetherFilterNotNull.kt");
            }

            @TestMetadata("ifContinue.kt")
            public void testIfContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/ifContinue.kt");
            }

            @TestMetadata("ifContinue2.kt")
            public void testIfContinue2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/ifContinue2.kt");
            }

            @TestMetadata("ifContinueInBlock.kt")
            public void testIfContinueInBlock() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/ifContinueInBlock.kt");
            }

            @TestMetadata("ifContinueWithLabel.kt")
            public void testIfContinueWithLabel() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/ifContinueWithLabel.kt");
            }

            @TestMetadata("ifElse.kt")
            public void testIfElse() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/ifElse.kt");
            }

            @TestMetadata("inputVarNotUsed.kt")
            public void testInputVarNotUsed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/inputVarNotUsed.kt");
            }

            @TestMetadata("inputVariableNotUsed.kt")
            public void testInputVariableNotUsed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/inputVariableNotUsed.kt");
            }

            @TestMetadata("mergeMultiple.kt")
            public void testMergeMultiple() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/mergeMultiple.kt");
            }

            @TestMetadata("splitOutFilterIsInstance.kt")
            public void testSplitOutFilterIsInstance() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/splitOutFilterIsInstance.kt");
            }

            @TestMetadata("splitOutFilterNotNull.kt")
            public void testSplitOutFilterNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/splitOutFilterNotNull.kt");
            }

            @TestMetadata("splitOutFilterNotNull2.kt")
            public void testSplitOutFilterNotNull2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/filter/splitOutFilterNotNull2.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/firstOrNull")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FirstOrNull extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFirstOrNull() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/firstOrNull"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignmentInitialization.kt")
            public void testAssignmentInitialization() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/assignmentInitialization.kt");
            }

            @TestMetadata("cannotUseLet.kt")
            public void testCannotUseLet() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/cannotUseLet.kt");
            }

            @TestMetadata("ifAssign.kt")
            public void testIfAssign() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign.kt");
            }

            @TestMetadata("ifAssign_breakWithLabel.kt")
            public void testIfAssign_breakWithLabel() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_breakWithLabel.kt");
            }

            @TestMetadata("ifAssign_cannotBeVal.kt")
            public void testIfAssign_cannotBeVal() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_cannotBeVal.kt");
            }

            @TestMetadata("ifAssign_preserveComments.kt")
            public void testIfAssign_preserveComments() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_preserveComments.kt");
            }

            @TestMetadata("ifAssign_variableUsedBefore.kt")
            public void testIfAssign_variableUsedBefore() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifAssign_variableUsedBefore.kt");
            }

            @TestMetadata("ifReturn.kt")
            public void testIfReturn() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/ifReturn.kt");
            }

            @TestMetadata("KT14292.kt")
            public void testKT14292() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/KT14292.kt");
            }

            @TestMetadata("let.kt")
            public void testLet() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/let.kt");
            }

            @TestMetadata("let2.kt")
            public void testLet2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/let2.kt");
            }

            @TestMetadata("letOrNotNull.kt")
            public void testLetOrNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/letOrNotNull.kt");
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/return.kt");
            }

            @TestMetadata("returnExpression.kt")
            public void testReturnExpression() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnExpression.kt");
            }

            @TestMetadata("returnExpressionOrNotNull.kt")
            public void testReturnExpressionOrNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnExpressionOrNotNull.kt");
            }

            @TestMetadata("returnNotNullIfNone.kt")
            public void testReturnNotNullIfNone() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnNotNullIfNone.kt");
            }

            @TestMetadata("returnNotNullIfNone2.kt")
            public void testReturnNotNullIfNone2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/returnNotNullIfNone2.kt");
            }

            @TestMetadata("return_comment.kt")
            public void testReturn_comment() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/return_comment.kt");
            }

            @TestMetadata("safeDotExpression.kt")
            public void testSafeDotExpression() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/safeDotExpression.kt");
            }

            @TestMetadata("withMergedFilter.kt")
            public void testWithMergedFilter() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/firstOrNull/withMergedFilter.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/flatMap")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FlatMap extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFlatMap() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/flatMap"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("break.kt")
            public void testBreak() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/break.kt");
            }

            @TestMetadata("continue.kt")
            public void testContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/continue.kt");
            }

            @TestMetadata("flatMapTo.kt")
            public void testFlatMapTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo.kt");
            }

            @TestMetadata("flatMapTo2.kt")
            public void testFlatMapTo2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo2.kt");
            }

            @TestMetadata("flatMapTo3.kt")
            public void testFlatMapTo3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/flatMapTo3.kt");
            }

            @TestMetadata("indexUsed.kt")
            public void testIndexUsed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/indexUsed.kt");
            }

            @TestMetadata("inputVarStillNeeded.kt")
            public void testInputVarStillNeeded() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/inputVarStillNeeded.kt");
            }

            @TestMetadata("notIterable.kt")
            public void testNotIterable() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/notIterable.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/simple.kt");
            }

            @TestMetadata("wrongBreak.kt")
            public void testWrongBreak() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/wrongBreak.kt");
            }

            @TestMetadata("wrongContinue.kt")
            public void testWrongContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/flatMap/wrongContinue.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/forEach")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForEach extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForEach() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/forEach"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("indexed.kt")
            public void testIndexed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/forEach/indexed.kt");
            }

            @TestMetadata("indexed_nothingElse.kt")
            public void testIndexed_nothingElse() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/forEach/indexed_nothingElse.kt");
            }

            @TestMetadata("KT14341.kt")
            public void testKT14341() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/forEach/KT14341.kt");
            }

            @TestMetadata("KT21083.kt")
            public void testKT21083() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/forEach/KT21083.kt");
            }

            @TestMetadata("notAvailable.kt")
            public void testNotAvailable() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/forEach/notAvailable.kt");
            }

            @TestMetadata("notIndexed.kt")
            public void testNotIndexed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/forEach/notIndexed.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/forEach/simple.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/indexOf")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IndexOf extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInIndexOf() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/indexOf"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("indexOf.kt")
            public void testIndexOf() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOf.kt");
            }

            @TestMetadata("indexOfFirst_ifAssign.kt")
            public void testIndexOfFirst_ifAssign() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_ifAssign.kt");
            }

            @TestMetadata("indexOfFirst_ifReturn.kt")
            public void testIndexOfFirst_ifReturn() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_ifReturn.kt");
            }

            @TestMetadata("indexOfFirst_mustBeNoIndexInCondition.kt")
            public void testIndexOfFirst_mustBeNoIndexInCondition() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfFirst_mustBeNoIndexInCondition.kt");
            }

            @TestMetadata("indexOfLast_ifAssign.kt")
            public void testIndexOfLast_ifAssign() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/indexOf/indexOfLast_ifAssign.kt");
            }

            @TestMetadata("KT14303.kt")
            public void testKT14303() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/indexOf/KT14303.kt");
            }

            @TestMetadata("lastIndexOf.kt")
            public void testLastIndexOf() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/indexOf/lastIndexOf.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/introduceIndex")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class IntroduceIndex extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInIntroduceIndex() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/introduceIndex"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("indexPlusPlusInsideExpression.kt")
            public void testIndexPlusPlusInsideExpression() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression.kt");
            }

            @TestMetadata("indexPlusPlusInsideExpression_indexUsedAfterIncrement.kt")
            public void testIndexPlusPlusInsideExpression_indexUsedAfterIncrement() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedAfterIncrement.kt");
            }

            @TestMetadata("indexPlusPlusInsideExpression_indexUsedBeforeIncrement.kt")
            public void testIndexPlusPlusInsideExpression_indexUsedBeforeIncrement() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedBeforeIncrement.kt");
            }

            @TestMetadata("indexPlusPlusInsideExpression_indexUsedBeforeIncrement2.kt")
            public void testIndexPlusPlusInsideExpression_indexUsedBeforeIncrement2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusInsideExpression_indexUsedBeforeIncrement2.kt");
            }

            @TestMetadata("indexPlusPlusIsNotLastStatement.kt")
            public void testIndexPlusPlusIsNotLastStatement() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusIsNotLastStatement.kt");
            }

            @TestMetadata("indexPlusPlusIsNotLastStatement_indexUsedAfterIncrement.kt")
            public void testIndexPlusPlusIsNotLastStatement_indexUsedAfterIncrement() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexPlusPlusIsNotLastStatement_indexUsedAfterIncrement.kt");
            }

            @TestMetadata("indexWithNestedLoop.kt")
            public void testIndexWithNestedLoop() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/indexWithNestedLoop.kt");
            }

            @TestMetadata("prefixIndexPlusPlusInsideExpression.kt")
            public void testPrefixIndexPlusPlusInsideExpression() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/introduceIndex/prefixIndexPlusPlusInsideExpression.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/map")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Map extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMap() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/map"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignMap.kt")
            public void testAssignMap() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/assignMap.kt");
            }

            @TestMetadata("assignMap2.kt")
            public void testAssignMap2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/assignMap2.kt");
            }

            @TestMetadata("KT18816.kt")
            public void testKT18816() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/KT18816.kt");
            }

            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/map.kt");
            }

            @TestMetadata("mapAndFilterIndexed.kt")
            public void testMapAndFilterIndexed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapAndFilterIndexed.kt");
            }

            @TestMetadata("mapIndexed.kt")
            public void testMapIndexed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexed.kt");
            }

            @TestMetadata("mapIndexedNotNull.kt")
            public void testMapIndexedNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNull.kt");
            }

            @TestMetadata("mapIndexedNotNullTo.kt")
            public void testMapIndexedNotNullTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNullTo.kt");
            }

            @TestMetadata("mapIndexedNotNullTo_elvisContinue.kt")
            public void testMapIndexedNotNullTo_elvisContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNullTo_elvisContinue.kt");
            }

            @TestMetadata("mapIndexedNotNull_elvisContinue.kt")
            public void testMapIndexedNotNull_elvisContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedNotNull_elvisContinue.kt");
            }

            @TestMetadata("mapIndexedTo.kt")
            public void testMapIndexedTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexedTo.kt");
            }

            @TestMetadata("mapIndexed_afterFilter.kt")
            public void testMapIndexed_afterFilter() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexed_afterFilter.kt");
            }

            @TestMetadata("mapIndexed_twice.kt")
            public void testMapIndexed_twice() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapIndexed_twice.kt");
            }

            @TestMetadata("mapNotNull.kt")
            public void testMapNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull.kt");
            }

            @TestMetadata("mapNotNullTo.kt")
            public void testMapNotNullTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapNotNullTo.kt");
            }

            @TestMetadata("mapNotNullTo_elvisContinue.kt")
            public void testMapNotNullTo_elvisContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapNotNullTo_elvisContinue.kt");
            }

            @TestMetadata("mapNotNull_elvisContinue.kt")
            public void testMapNotNull_elvisContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull_elvisContinue.kt");
            }

            @TestMetadata("mapNotNull_nestedLoopElvisContinue.kt")
            public void testMapNotNull_nestedLoopElvisContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull_nestedLoopElvisContinue.kt");
            }

            @TestMetadata("mapNotNull_wrongElvisContinue.kt")
            public void testMapNotNull_wrongElvisContinue() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapNotNull_wrongElvisContinue.kt");
            }

            @TestMetadata("mapTo.kt")
            public void testMapTo() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapTo.kt");
            }

            @TestMetadata("mapTo2.kt")
            public void testMapTo2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapTo2.kt");
            }

            @TestMetadata("mapTo3.kt")
            public void testMapTo3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapTo3.kt");
            }

            @TestMetadata("mapTo4.kt")
            public void testMapTo4() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapTo4.kt");
            }

            @TestMetadata("mapTo_inputVarNotUsed.kt")
            public void testMapTo_inputVarNotUsed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapTo_inputVarNotUsed.kt");
            }

            @TestMetadata("mapUsesOldIndexAfterFilter.kt")
            public void testMapUsesOldIndexAfterFilter() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapUsesOldIndexAfterFilter.kt");
            }

            @TestMetadata("mapVar.kt")
            public void testMapVar() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/mapVar.kt");
            }

            @TestMetadata("map_var.kt")
            public void testMap_var() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/map_var.kt");
            }

            @TestMetadata("map_variableStillNeeded.kt")
            public void testMap_variableStillNeeded() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/map/map_variableStillNeeded.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/maxMin")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MaxMin extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMaxMin() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/maxMin"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("KT14210.kt")
            public void testKT14210() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/KT14210.kt");
            }

            @TestMetadata("max1.kt")
            public void testMax1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/max1.kt");
            }

            @TestMetadata("max2.kt")
            public void testMax2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/max2.kt");
            }

            @TestMetadata("max3.kt")
            public void testMax3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/max3.kt");
            }

            @TestMetadata("max4.kt")
            public void testMax4() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/max4.kt");
            }

            @TestMetadata("max5.kt")
            public void testMax5() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/max5.kt");
            }

            @TestMetadata("max6.kt")
            public void testMax6() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/max6.kt");
            }

            @TestMetadata("max7.kt")
            public void testMax7() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/max7.kt");
            }

            @TestMetadata("min1.kt")
            public void testMin1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/min1.kt");
            }

            @TestMetadata("min2.kt")
            public void testMin2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/min2.kt");
            }

            @TestMetadata("min3.kt")
            public void testMin3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/min3.kt");
            }

            @TestMetadata("min4.kt")
            public void testMin4() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/min4.kt");
            }

            @TestMetadata("min5.kt")
            public void testMin5() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/maxMin/min5.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/smartCasts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SmartCasts extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSmartCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/smartCasts"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("errorOutsideLoop.kt")
            public void testErrorOutsideLoop() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/errorOutsideLoop.kt");
            }

            @TestMetadata("smartCastNotBroken.kt")
            public void testSmartCastNotBroken() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken.kt");
            }

            @TestMetadata("smartCastNotBroken2.kt")
            public void testSmartCastNotBroken2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken2.kt");
            }

            @TestMetadata("smartCastNotBroken3.kt")
            public void testSmartCastNotBroken3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken3.kt");
            }

            @TestMetadata("smartCastNotBroken4.kt")
            public void testSmartCastNotBroken4() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken4.kt");
            }

            @TestMetadata("smartCastNotBroken5.kt")
            public void testSmartCastNotBroken5() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotBroken5.kt");
            }

            @TestMetadata("smartCastNotNullRequired.kt")
            public void testSmartCastNotNullRequired() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotNullRequired.kt");
            }

            @TestMetadata("smartCastNotRequired.kt")
            public void testSmartCastNotRequired() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastNotRequired.kt");
            }

            @TestMetadata("smartCastRequired.kt")
            public void testSmartCastRequired() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired.kt");
            }

            @TestMetadata("smartCastRequired2.kt")
            public void testSmartCastRequired2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired2.kt");
            }

            @TestMetadata("smartCastRequired3.kt")
            public void testSmartCastRequired3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired3.kt");
            }

            @TestMetadata("smartCastRequired4.kt")
            public void testSmartCastRequired4() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired4.kt");
            }

            @TestMetadata("smartCastRequired5.kt")
            public void testSmartCastRequired5() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired5.kt");
            }

            @TestMetadata("smartCastRequired6.kt")
            public void testSmartCastRequired6() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastRequired6.kt");
            }

            @TestMetadata("smartCastThisRequired.kt")
            public void testSmartCastThisRequired() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/smartCasts/smartCastThisRequired.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/sum")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Sum extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSum() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/sum"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("bytes.kt")
            public void testBytes() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/bytes.kt");
            }

            @TestMetadata("doubles.kt")
            public void testDoubles() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/doubles.kt");
            }

            @TestMetadata("floats.kt")
            public void testFloats() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/floats.kt");
            }

            @TestMetadata("floatsIntoDouble.kt")
            public void testFloatsIntoDouble() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/floatsIntoDouble.kt");
            }

            @TestMetadata("indexUsed.kt")
            public void testIndexUsed() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/indexUsed.kt");
            }

            @TestMetadata("indexUsed2.kt")
            public void testIndexUsed2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/indexUsed2.kt");
            }

            @TestMetadata("ints.kt")
            public void testInts() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/ints.kt");
            }

            @TestMetadata("longs.kt")
            public void testLongs() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/longs.kt");
            }

            @TestMetadata("nonNumbers.kt")
            public void testNonNumbers() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/nonNumbers.kt");
            }

            @TestMetadata("nonZeroInitial.kt")
            public void testNonZeroInitial() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/nonZeroInitial.kt");
            }

            @TestMetadata("short.kt")
            public void testShort() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/short.kt");
            }

            @TestMetadata("smartCast.kt")
            public void testSmartCast() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/smartCast.kt");
            }

            @TestMetadata("smartCastNotNull.kt")
            public void testSmartCastNotNull() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/smartCastNotNull.kt");
            }

            @TestMetadata("sumByDouble.kt")
            public void testSumByDouble() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/sumByDouble.kt");
            }

            @TestMetadata("sumByInts.kt")
            public void testSumByInts() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/sumByInts.kt");
            }

            @TestMetadata("sumByIntsIntoLong.kt")
            public void testSumByIntsIntoLong() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/sumByIntsIntoLong.kt");
            }

            @TestMetadata("sumByShorts.kt")
            public void testSumByShorts() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/sum/sumByShorts.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/takeWhile")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TakeWhile extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTakeWhile() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/takeWhile"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ifElse1.kt")
            public void testIfElse1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/takeWhile/ifElse1.kt");
            }

            @TestMetadata("ifElse2.kt")
            public void testIfElse2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/takeWhile/ifElse2.kt");
            }

            @TestMetadata("nestedLoop.kt")
            public void testNestedLoop() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/takeWhile/nestedLoop.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/takeWhile/simple.kt");
            }

            @TestMetadata("wrongBreak.kt")
            public void testWrongBreak() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/takeWhile/wrongBreak.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/loopToCallChain/toCollection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ToCollection extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("addAfterLoop.kt")
            public void testAddAfterLoop() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/addAfterLoop.kt");
            }

            @TestMetadata("addToCollection.kt")
            public void testAddToCollection() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/addToCollection.kt");
            }

            public void testAllFilesPresentInToCollection() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/loopToCallChain/toCollection"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("badReceiver1.kt")
            public void testBadReceiver1() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/badReceiver1.kt");
            }

            @TestMetadata("badReceiver2.kt")
            public void testBadReceiver2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/badReceiver2.kt");
            }

            @TestMetadata("explicitValType.kt")
            public void testExplicitValType() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/explicitValType.kt");
            }

            @TestMetadata("goodReceiver.kt")
            public void testGoodReceiver() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/goodReceiver.kt");
            }

            @TestMetadata("KT18881.kt")
            public void testKT18881() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/KT18881.kt");
            }

            @TestMetadata("resultCollectionUsedInsideLoop.kt")
            public void testResultCollectionUsedInsideLoop() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/resultCollectionUsedInsideLoop.kt");
            }

            @TestMetadata("toList.kt")
            public void testToList() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toList.kt");
            }

            @TestMetadata("toList2.kt")
            public void testToList2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toList2.kt");
            }

            @TestMetadata("toList3.kt")
            public void testToList3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toList3.kt");
            }

            @TestMetadata("toMutableSet.kt")
            public void testToMutableSet() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet.kt");
            }

            @TestMetadata("toMutableSet2.kt")
            public void testToMutableSet2() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet2.kt");
            }

            @TestMetadata("toMutableSet3.kt")
            public void testToMutableSet3() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toMutableSet3.kt");
            }

            @TestMetadata("toSet.kt")
            public void testToSet() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toSet.kt");
            }

            @TestMetadata("toSetWithMap.kt")
            public void testToSetWithMap() throws Exception {
                runTest("idea/testData/intentions/loopToCallChain/toCollection/toSetWithMap.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/mergeIfs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MergeIfs extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMergeIfs() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/mergeIfs"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("comments.kt")
        public void testComments() throws Exception {
            runTest("idea/testData/intentions/mergeIfs/comments.kt");
        }

        @TestMetadata("else1.kt")
        public void testElse1() throws Exception {
            runTest("idea/testData/intentions/mergeIfs/else1.kt");
        }

        @TestMetadata("else2.kt")
        public void testElse2() throws Exception {
            runTest("idea/testData/intentions/mergeIfs/else2.kt");
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("idea/testData/intentions/mergeIfs/expression.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/mergeIfs/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/moveDeclarationToSeparateFile")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveDeclarationToSeparateFile extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMoveDeclarationToSeparateFile() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveDeclarationToSeparateFile"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("extendSealed.kt")
        public void testExtendSealed() throws Exception {
            runTest("idea/testData/intentions/moveDeclarationToSeparateFile/extendSealed.kt");
        }

        @TestMetadata("sealed.kt")
        public void testSealed() throws Exception {
            runTest("idea/testData/intentions/moveDeclarationToSeparateFile/sealed.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/moveLambdaInsideParentheses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveLambdaInsideParentheses extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMoveLambdaInsideParentheses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveLambdaInsideParentheses"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicable1.kt")
        public void testInapplicable1() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/inapplicable1.kt");
        }

        @TestMetadata("inapplicable2.kt")
        public void testInapplicable2() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/inapplicable2.kt");
        }

        @TestMetadata("moveLabeledLambda1.kt")
        public void testMoveLabeledLambda1() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLabeledLambda1.kt");
        }

        @TestMetadata("moveLabeledLambda2.kt")
        public void testMoveLabeledLambda2() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLabeledLambda2.kt");
        }

        @TestMetadata("moveLambda1.kt")
        public void testMoveLambda1() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda1.kt");
        }

        @TestMetadata("moveLambda10.kt")
        public void testMoveLambda10() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda10.kt");
        }

        @TestMetadata("moveLambda11.kt")
        public void testMoveLambda11() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda11.kt");
        }

        @TestMetadata("moveLambda12.kt")
        public void testMoveLambda12() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda12.kt");
        }

        @TestMetadata("moveLambda13.kt")
        public void testMoveLambda13() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda13.kt");
        }

        @TestMetadata("moveLambda14.kt")
        public void testMoveLambda14() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda14.kt");
        }

        @TestMetadata("moveLambda2.kt")
        public void testMoveLambda2() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda2.kt");
        }

        @TestMetadata("moveLambda3.kt")
        public void testMoveLambda3() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda3.kt");
        }

        @TestMetadata("moveLambda4.kt")
        public void testMoveLambda4() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda4.kt");
        }

        @TestMetadata("moveLambda5.kt")
        public void testMoveLambda5() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda5.kt");
        }

        @TestMetadata("moveLambda6.kt")
        public void testMoveLambda6() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda6.kt");
        }

        @TestMetadata("moveLambda7.kt")
        public void testMoveLambda7() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda7.kt");
        }

        @TestMetadata("moveLambda8.kt")
        public void testMoveLambda8() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda8.kt");
        }

        @TestMetadata("moveLambda9.kt")
        public void testMoveLambda9() throws Exception {
            runTest("idea/testData/intentions/moveLambdaInsideParentheses/moveLambda9.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/moveMemberToTopLevel")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveMemberToTopLevel extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractFunction.kt")
        public void testAbstractFunction() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/abstractFunction.kt");
        }

        @TestMetadata("abstractProperty.kt")
        public void testAbstractProperty() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/abstractProperty.kt");
        }

        public void testAllFilesPresentInMoveMemberToTopLevel() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveMemberToTopLevel"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/function.kt");
        }

        @TestMetadata("functionInCompanion.kt")
        public void testFunctionInCompanion() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/functionInCompanion.kt");
        }

        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/property.kt");
        }

        @TestMetadata("propertyInCompanion.kt")
        public void testPropertyInCompanion() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/propertyInCompanion.kt");
        }

        @TestMetadata("redeclarationConflict.kt")
        public void testRedeclarationConflict() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/redeclarationConflict.kt");
        }

        @TestMetadata("redeclarationConflictWithPackage.kt")
        public void testRedeclarationConflictWithPackage() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/redeclarationConflictWithPackage.kt");
        }

        @TestMetadata("redeclarationPropertyConflict.kt")
        public void testRedeclarationPropertyConflict() throws Exception {
            runTest("idea/testData/intentions/moveMemberToTopLevel/redeclarationPropertyConflict.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/moveOutOfCompanion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveOutOfCompanion extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMoveOutOfCompanion() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveOutOfCompanion"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("companionAsImplicitReceiver.kt")
        public void testCompanionAsImplicitReceiver() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/companionAsImplicitReceiver.kt");
        }

        @TestMetadata("hasJvmFieldInInterface.kt")
        public void testHasJvmFieldInInterface() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/hasJvmFieldInInterface.kt");
        }

        @TestMetadata("moveAndDropCompanion.kt")
        public void testMoveAndDropCompanion() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/moveAndDropCompanion.kt");
        }

        @TestMetadata("moveFunction.kt")
        public void testMoveFunction() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/moveFunction.kt");
        }

        @TestMetadata("moveFunctionWithExternalRefs.kt")
        public void testMoveFunctionWithExternalRefs() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/moveFunctionWithExternalRefs.kt");
        }

        @TestMetadata("moveProperty.kt")
        public void testMoveProperty() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/moveProperty.kt");
        }

        @TestMetadata("movePropertyWithExternalRefs.kt")
        public void testMovePropertyWithExternalRefs() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/movePropertyWithExternalRefs.kt");
        }

        @TestMetadata("notCompanion1.kt")
        public void testNotCompanion1() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/notCompanion1.kt");
        }

        @TestMetadata("notCompanion2.kt")
        public void testNotCompanion2() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/notCompanion2.kt");
        }

        @TestMetadata("redeclarationConflict.kt")
        public void testRedeclarationConflict() throws Exception {
            runTest("idea/testData/intentions/moveOutOfCompanion/redeclarationConflict.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/movePropertyToClassBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MovePropertyToClassBody extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMovePropertyToClassBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/movePropertyToClassBody"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationWithUseSite.kt")
        public void testAnnotationWithUseSite() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/annotationWithUseSite.kt");
        }

        @TestMetadata("location1.kt")
        public void testLocation1() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/location1.kt");
        }

        @TestMetadata("location2.kt")
        public void testLocation2() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/location2.kt");
        }

        @TestMetadata("parameterAnnotation.kt")
        public void testParameterAnnotation() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/parameterAnnotation.kt");
        }

        @TestMetadata("propertyAnnotation.kt")
        public void testPropertyAnnotation() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/propertyAnnotation.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/simple.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/vararg.kt");
        }

        @TestMetadata("varargWithAnnotation.kt")
        public void testVarargWithAnnotation() throws Exception {
            runTest("idea/testData/intentions/movePropertyToClassBody/varargWithAnnotation.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/movePropertyToConstructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MovePropertyToConstructor extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMovePropertyToConstructor() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/movePropertyToConstructor"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationTarget.kt")
        public void testAnnotationTarget() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/annotationTarget.kt");
        }

        @TestMetadata("annotationWithUseSite.kt")
        public void testAnnotationWithUseSite() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/annotationWithUseSite.kt");
        }

        @TestMetadata("declaredInInterface.kt")
        public void testDeclaredInInterface() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/declaredInInterface.kt");
        }

        @TestMetadata("delegated.kt")
        public void testDelegated() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/delegated.kt");
        }

        @TestMetadata("expectClass.kt")
        public void testExpectClass() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/expectClass.kt");
        }

        @TestMetadata("functionReference.kt")
        public void testFunctionReference() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/functionReference.kt");
        }

        @TestMetadata("getter.kt")
        public void testGetter() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/getter.kt");
        }

        @TestMetadata("javaAnnotation.kt")
        public void testJavaAnnotation() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/javaAnnotation.kt");
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/lambda.kt");
        }

        @TestMetadata("lambdaWithoutParameters.kt")
        public void testLambdaWithoutParameters() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/lambdaWithoutParameters.kt");
        }

        @TestMetadata("lateinit.kt")
        public void testLateinit() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/lateinit.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/local.kt");
        }

        @TestMetadata("map.kt")
        public void testMap() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/map.kt");
        }

        @TestMetadata("methodReference.kt")
        public void testMethodReference() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/methodReference.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/simple.kt");
        }

        @TestMetadata("simpleAnnotation.kt")
        public void testSimpleAnnotation() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/simpleAnnotation.kt");
        }

        @TestMetadata("withoutMatchingParameter.kt")
        public void testWithoutMatchingParameter() throws Exception {
            runTest("idea/testData/intentions/movePropertyToConstructor/withoutMatchingParameter.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/moveToCompanion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveToCompanion extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractFunction.kt")
        public void testAbstractFunction() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/abstractFunction.kt");
        }

        @TestMetadata("abstractProperty.kt")
        public void testAbstractProperty() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/abstractProperty.kt");
        }

        public void testAllFilesPresentInMoveToCompanion() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/moveToCompanion"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doNotQualifyThisLabel.kt")
        public void testDoNotQualifyThisLabel() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/doNotQualifyThisLabel.kt");
        }

        @TestMetadata("dropFinal.kt")
        public void testDropFinal() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/dropFinal.kt");
        }

        @TestMetadata("dropOpen.kt")
        public void testDropOpen() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/dropOpen.kt");
        }

        @TestMetadata("enumEntry.kt")
        public void testEnumEntry() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/enumEntry.kt");
        }

        @TestMetadata("expectClass.kt")
        public void testExpectClass() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/expectClass.kt");
        }

        @TestMetadata("functionWithOverride.kt")
        public void testFunctionWithOverride() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/functionWithOverride.kt");
        }

        @TestMetadata("functionWithoutBody.kt")
        public void testFunctionWithoutBody() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/functionWithoutBody.kt");
        }

        @TestMetadata("genericFunction.kt")
        public void testGenericFunction() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/genericFunction.kt");
        }

        @TestMetadata("genericProperty.kt")
        public void testGenericProperty() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/genericProperty.kt");
        }

        @TestMetadata("implicitDispatchReceiver.kt")
        public void testImplicitDispatchReceiver() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/implicitDispatchReceiver.kt");
        }

        @TestMetadata("inInnerClass.kt")
        public void testInInnerClass() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/inInnerClass.kt");
        }

        @TestMetadata("inLocalClass.kt")
        public void testInLocalClass() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/inLocalClass.kt");
        }

        @TestMetadata("inObject.kt")
        public void testInObject() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/inObject.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/localFunction.kt");
        }

        @TestMetadata("overriddenFunction.kt")
        public void testOverriddenFunction() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/overriddenFunction.kt");
        }

        @TestMetadata("overriddenProperty.kt")
        public void testOverriddenProperty() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/overriddenProperty.kt");
        }

        @TestMetadata("propertyUsingClassInstance.kt")
        public void testPropertyUsingClassInstance() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/propertyUsingClassInstance.kt");
        }

        @TestMetadata("propertyWithOverride.kt")
        public void testPropertyWithOverride() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/propertyWithOverride.kt");
        }

        @TestMetadata("redeclarationConflict.kt")
        public void testRedeclarationConflict() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/redeclarationConflict.kt");
        }

        @TestMetadata("topLevelFunction.kt")
        public void testTopLevelFunction() throws Exception {
            runTest("idea/testData/intentions/moveToCompanion/topLevelFunction.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/nullableBooleanEqualityCheckToElvis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NullableBooleanEqualityCheckToElvis extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInNullableBooleanEqualityCheckToElvis() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/nullableBooleanEqualityCheckToElvis"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("eqFalse.kt")
        public void testEqFalse() throws Exception {
            runTest("idea/testData/intentions/nullableBooleanEqualityCheckToElvis/eqFalse.kt");
        }

        @TestMetadata("eqTrue.kt")
        public void testEqTrue() throws Exception {
            runTest("idea/testData/intentions/nullableBooleanEqualityCheckToElvis/eqTrue.kt");
        }

        @TestMetadata("flexible.kt")
        public void testFlexible() throws Exception {
            runTest("idea/testData/intentions/nullableBooleanEqualityCheckToElvis/flexible.kt");
        }

        @TestMetadata("notEqFalse.kt")
        public void testNotEqFalse() throws Exception {
            runTest("idea/testData/intentions/nullableBooleanEqualityCheckToElvis/notEqFalse.kt");
        }

        @TestMetadata("notEqTrue.kt")
        public void testNotEqTrue() throws Exception {
            runTest("idea/testData/intentions/nullableBooleanEqualityCheckToElvis/notEqTrue.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/objectLiteralToLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ObjectLiteralToLambda extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInObjectLiteralToLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/objectLiteralToLambda"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("EmptyBody.kt")
        public void testEmptyBody() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/EmptyBody.kt");
        }

        @TestMetadata("ExplicitThis.kt")
        public void testExplicitThis() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ExplicitThis.kt");
        }

        @TestMetadata("ExpressionBody.kt")
        public void testExpressionBody() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ExpressionBody.kt");
        }

        @TestMetadata("HasData.kt")
        public void testHasData() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/HasData.kt");
        }

        @TestMetadata("ImplicitThis.kt")
        public void testImplicitThis() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ImplicitThis.kt");
        }

        @TestMetadata("MultipleBases.kt")
        public void testMultipleBases() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/MultipleBases.kt");
        }

        @TestMetadata("MultipleParameters.kt")
        public void testMultipleParameters() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/MultipleParameters.kt");
        }

        @TestMetadata("NoSamAdapterNeeded.kt")
        public void testNoSamAdapterNeeded() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/NoSamAdapterNeeded.kt");
        }

        @TestMetadata("NotInRange1.kt")
        public void testNotInRange1() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/NotInRange1.kt");
        }

        @TestMetadata("NotInRange2.kt")
        public void testNotInRange2() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/NotInRange2.kt");
        }

        @TestMetadata("NotJavaSAM.kt")
        public void testNotJavaSAM() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/NotJavaSAM.kt");
        }

        @TestMetadata("ParametersNotUsed.kt")
        public void testParametersNotUsed() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ParametersNotUsed.kt");
        }

        @TestMetadata("ParametersNotUsedMoreThanOne.kt")
        public void testParametersNotUsedMoreThanOne() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ParametersNotUsedMoreThanOne.kt");
        }

        @TestMetadata("QualifiedReturn.kt")
        public void testQualifiedReturn() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/QualifiedReturn.kt");
        }

        @TestMetadata("Recursive.kt")
        public void testRecursive() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/Recursive.kt");
        }

        @TestMetadata("ReturnNoValue.kt")
        public void testReturnNoValue() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ReturnNoValue.kt");
        }

        @TestMetadata("ReturnNotLast.kt")
        public void testReturnNotLast() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ReturnNotLast.kt");
        }

        @TestMetadata("ReturnsInIf.kt")
        public void testReturnsInIf() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ReturnsInIf.kt");
        }

        @TestMetadata("ReturnsInWhen.kt")
        public void testReturnsInWhen() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ReturnsInWhen.kt");
        }

        @TestMetadata("SamAdapterNeededBecauseOfLabeledReturn.kt")
        public void testSamAdapterNeededBecauseOfLabeledReturn() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/SamAdapterNeededBecauseOfLabeledReturn.kt");
        }

        @TestMetadata("ShortGenericArgument.kt")
        public void testShortGenericArgument() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ShortGenericArgument.kt");
        }

        @TestMetadata("Simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/Simple.kt");
        }

        @TestMetadata("SingleReturn.kt")
        public void testSingleReturn() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/SingleReturn.kt");
        }

        @TestMetadata("StatementAndReturn.kt")
        public void testStatementAndReturn() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/StatementAndReturn.kt");
        }

        @TestMetadata("ThisReference.kt")
        public void testThisReference() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/ThisReference.kt");
        }

        @TestMetadata("TwoFunctions.kt")
        public void testTwoFunctions() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/TwoFunctions.kt");
        }

        @TestMetadata("WithComment.kt")
        public void testWithComment() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/WithComment.kt");
        }

        @TestMetadata("WithCommentAfterExpression.kt")
        public void testWithCommentAfterExpression() throws Exception {
            runTest("idea/testData/intentions/objectLiteralToLambda/WithCommentAfterExpression.kt");
        }

        @TestMetadata("idea/testData/intentions/objectLiteralToLambda/inspectionData")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InspectionData extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInspectionData() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/objectLiteralToLambda/inspectionData"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/operatorToFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class OperatorToFunction extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInOperatorToFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/operatorToFunction"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayAccessMultipleIndex.kt")
        public void testArrayAccessMultipleIndex() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/arrayAccessMultipleIndex.kt");
        }

        @TestMetadata("arrayAccessOneIndex.kt")
        public void testArrayAccessOneIndex() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/arrayAccessOneIndex.kt");
        }

        @TestMetadata("arrayAssignmentMultipleIndex.kt")
        public void testArrayAssignmentMultipleIndex() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/arrayAssignmentMultipleIndex.kt");
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/assignment.kt");
        }

        @TestMetadata("binarayNotEqNullable.kt")
        public void testBinarayNotEqNullable() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binarayNotEqNullable.kt");
        }

        @TestMetadata("binaryEqEqNonNullable.kt")
        public void testBinaryEqEqNonNullable() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryEqEqNonNullable.kt");
        }

        @TestMetadata("binaryEqEqNotNullInLeftSide.kt")
        public void testBinaryEqEqNotNullInLeftSide() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryEqEqNotNullInLeftSide.kt");
        }

        @TestMetadata("binaryEqEqNotNullInRightSide.kt")
        public void testBinaryEqEqNotNullInRightSide() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryEqEqNotNullInRightSide.kt");
        }

        @TestMetadata("binaryEqEqNullInLeftSide.kt")
        public void testBinaryEqEqNullInLeftSide() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryEqEqNullInLeftSide.kt");
        }

        @TestMetadata("binaryEqEqNullInRightSide.kt")
        public void testBinaryEqEqNullInRightSide() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryEqEqNullInRightSide.kt");
        }

        @TestMetadata("binaryEqEqNullable.kt")
        public void testBinaryEqEqNullable() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryEqEqNullable.kt");
        }

        @TestMetadata("binaryNotEqNonNullable.kt")
        public void testBinaryNotEqNonNullable() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryNotEqNonNullable.kt");
        }

        @TestMetadata("binaryNotIn.kt")
        public void testBinaryNotIn() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryNotIn.kt");
        }

        @TestMetadata("binaryPlus.kt")
        public void testBinaryPlus() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryPlus.kt");
        }

        @TestMetadata("binaryPlusEquals.kt")
        public void testBinaryPlusEquals() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryPlusEquals.kt");
        }

        @TestMetadata("binaryPlusEqualsNotResolved.kt")
        public void testBinaryPlusEqualsNotResolved() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryPlusEqualsNotResolved.kt");
        }

        @TestMetadata("binaryRangeTo.kt")
        public void testBinaryRangeTo() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/binaryRangeTo.kt");
        }

        @TestMetadata("compoundAssignment.kt")
        public void testCompoundAssignment() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/compoundAssignment.kt");
        }

        @TestMetadata("compoundAssignment2.kt")
        public void testCompoundAssignment2() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/compoundAssignment2.kt");
        }

        @TestMetadata("functionCallMultipleArgument.kt")
        public void testFunctionCallMultipleArgument() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/functionCallMultipleArgument.kt");
        }

        @TestMetadata("functionCallWithMultipleArgumentsAndSingleLambda.kt")
        public void testFunctionCallWithMultipleArgumentsAndSingleLambda() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/functionCallWithMultipleArgumentsAndSingleLambda.kt");
        }

        @TestMetadata("functionCallWithSingleLambda.kt")
        public void testFunctionCallWithSingleLambda() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/functionCallWithSingleLambda.kt");
        }

        @TestMetadata("inRightSideOfAssignment.kt")
        public void testInRightSideOfAssignment() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/inRightSideOfAssignment.kt");
        }

        @TestMetadata("keepComments.kt")
        public void testKeepComments() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/keepComments.kt");
        }

        @TestMetadata("notApplicableAssignment.kt")
        public void testNotApplicableAssignment() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicableAssignment.kt");
        }

        @TestMetadata("notApplicableCallWithInvokeMethod.kt")
        public void testNotApplicableCallWithInvokeMethod() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicableCallWithInvokeMethod.kt");
        }

        @TestMetadata("notApplicableFunctionCallWithCallableReference.kt")
        public void testNotApplicableFunctionCallWithCallableReference() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicableFunctionCallWithCallableReference.kt");
        }

        @TestMetadata("notApplicableNewClassObject.kt")
        public void testNotApplicableNewClassObject() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicableNewClassObject.kt");
        }

        @TestMetadata("notApplicablePostfixPlusPlusInIfExpression.kt")
        public void testNotApplicablePostfixPlusPlusInIfExpression() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicablePostfixPlusPlusInIfExpression.kt");
        }

        @TestMetadata("notApplicablePostfixPlusPlusInNestedIfExpression.kt")
        public void testNotApplicablePostfixPlusPlusInNestedIfExpression() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicablePostfixPlusPlusInNestedIfExpression.kt");
        }

        @TestMetadata("notApplicablePostfixPlusPlusInProperty.kt")
        public void testNotApplicablePostfixPlusPlusInProperty() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicablePostfixPlusPlusInProperty.kt");
        }

        @TestMetadata("notApplicablePostfixPlusPlusInWhenExpression.kt")
        public void testNotApplicablePostfixPlusPlusInWhenExpression() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/notApplicablePostfixPlusPlusInWhenExpression.kt");
        }

        @TestMetadata("pluPlus.kt")
        public void testPluPlus() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/pluPlus.kt");
        }

        @TestMetadata("postfixMinusMinus.kt")
        public void testPostfixMinusMinus() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/postfixMinusMinus.kt");
        }

        @TestMetadata("postfixPlusPlusInIfExpression.kt")
        public void testPostfixPlusPlusInIfExpression() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/postfixPlusPlusInIfExpression.kt");
        }

        @TestMetadata("postfixPlusPlusInLoop.kt")
        public void testPostfixPlusPlusInLoop() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/postfixPlusPlusInLoop.kt");
        }

        @TestMetadata("postfixPlusPlusInWhenExpression.kt")
        public void testPostfixPlusPlusInWhenExpression() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/postfixPlusPlusInWhenExpression.kt");
        }

        @TestMetadata("prefixPlus.kt")
        public void testPrefixPlus() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/prefixPlus.kt");
        }

        @TestMetadata("prefixPlusPlus.kt")
        public void testPrefixPlusPlus() throws Exception {
            runTest("idea/testData/intentions/operatorToFunction/prefixPlusPlus.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/reconstructTypeInCastOrIs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReconstructTypeInCastOrIs extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReconstructTypeInCastOrIs() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/reconstructTypeInCastOrIs"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("completeGenericType.kt")
        public void testCompleteGenericType() throws Exception {
            runTest("idea/testData/intentions/reconstructTypeInCastOrIs/completeGenericType.kt");
        }

        @TestMetadata("completeType.kt")
        public void testCompleteType() throws Exception {
            runTest("idea/testData/intentions/reconstructTypeInCastOrIs/completeType.kt");
        }

        @TestMetadata("errorType.kt")
        public void testErrorType() throws Exception {
            runTest("idea/testData/intentions/reconstructTypeInCastOrIs/errorType.kt");
        }

        @TestMetadata("reconstructableType.kt")
        public void testReconstructableType() throws Exception {
            runTest("idea/testData/intentions/reconstructTypeInCastOrIs/reconstructableType.kt");
        }

        @TestMetadata("typeInDeclaration.kt")
        public void testTypeInDeclaration() throws Exception {
            runTest("idea/testData/intentions/reconstructTypeInCastOrIs/typeInDeclaration.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeArgumentName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveArgumentName extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveArgumentName() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeArgumentName"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("namedArgumentBefore.kt")
        public void testNamedArgumentBefore() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/namedArgumentBefore.kt");
        }

        @TestMetadata("noExpression.kt")
        public void testNoExpression() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/noExpression.kt");
        }

        @TestMetadata("notInPosition.kt")
        public void testNotInPosition() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/notInPosition.kt");
        }

        @TestMetadata("notInRange.kt")
        public void testNotInRange() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/notInRange.kt");
        }

        @TestMetadata("notNamed.kt")
        public void testNotNamed() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/notNamed.kt");
        }

        @TestMetadata("notResolved.kt")
        public void testNotResolved() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/notResolved.kt");
        }

        @TestMetadata("range.kt")
        public void testRange() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/range.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/simple.kt");
        }

        @TestMetadata("star.kt")
        public void testStar() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/star.kt");
        }

        @TestMetadata("superClassConstructor.kt")
        public void testSuperClassConstructor() throws Exception {
            runTest("idea/testData/intentions/removeArgumentName/superClassConstructor.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeBraces")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveBraces extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveBraces() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeBraces"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doWhile.kt")
        public void testDoWhile() throws Exception {
            runTest("idea/testData/intentions/removeBraces/doWhile.kt");
        }

        @TestMetadata("doWhileWithTwoStatements.kt")
        public void testDoWhileWithTwoStatements() throws Exception {
            runTest("idea/testData/intentions/removeBraces/doWhileWithTwoStatements.kt");
        }

        @TestMetadata("else.kt")
        public void testElse() throws Exception {
            runTest("idea/testData/intentions/removeBraces/else.kt");
        }

        @TestMetadata("elseInDotQualifiedExpression.kt")
        public void testElseInDotQualifiedExpression() throws Exception {
            runTest("idea/testData/intentions/removeBraces/elseInDotQualifiedExpression.kt");
        }

        @TestMetadata("elseInPlusAssignExpression.kt")
        public void testElseInPlusAssignExpression() throws Exception {
            runTest("idea/testData/intentions/removeBraces/elseInPlusAssignExpression.kt");
        }

        @TestMetadata("for.kt")
        public void testFor() throws Exception {
            runTest("idea/testData/intentions/removeBraces/for.kt");
        }

        @TestMetadata("forWithLocalVariable.kt")
        public void testForWithLocalVariable() throws Exception {
            runTest("idea/testData/intentions/removeBraces/forWithLocalVariable.kt");
        }

        @TestMetadata("if.kt")
        public void testIf() throws Exception {
            runTest("idea/testData/intentions/removeBraces/if.kt");
        }

        @TestMetadata("ifInDotQualifiedExpression.kt")
        public void testIfInDotQualifiedExpression() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInDotQualifiedExpression.kt");
        }

        @TestMetadata("ifInsideIf.kt")
        public void testIfInsideIf() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInsideIf.kt");
        }

        @TestMetadata("ifInsideIf2.kt")
        public void testIfInsideIf2() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInsideIf2.kt");
        }

        @TestMetadata("ifInsideIf3.kt")
        public void testIfInsideIf3() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInsideIf3.kt");
        }

        @TestMetadata("ifInsideIf4.kt")
        public void testIfInsideIf4() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInsideIf4.kt");
        }

        @TestMetadata("ifInsideIf5.kt")
        public void testIfInsideIf5() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInsideIf5.kt");
        }

        @TestMetadata("ifInsideIf6.kt")
        public void testIfInsideIf6() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInsideIf6.kt");
        }

        @TestMetadata("ifInsideIf7.kt")
        public void testIfInsideIf7() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifInsideIf7.kt");
        }

        @TestMetadata("ifWithComment.kt")
        public void testIfWithComment() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifWithComment.kt");
        }

        @TestMetadata("ifWithNoStatement.kt")
        public void testIfWithNoStatement() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifWithNoStatement.kt");
        }

        @TestMetadata("ifWithSemicolon.kt")
        public void testIfWithSemicolon() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifWithSemicolon.kt");
        }

        @TestMetadata("ifWithTwoStatements.kt")
        public void testIfWithTwoStatements() throws Exception {
            runTest("idea/testData/intentions/removeBraces/ifWithTwoStatements.kt");
        }

        @TestMetadata("removeBracesFromIfWithCommentedCode.kt")
        public void testRemoveBracesFromIfWithCommentedCode() throws Exception {
            runTest("idea/testData/intentions/removeBraces/removeBracesFromIfWithCommentedCode.kt");
        }

        @TestMetadata("whenInDotQualifiedExpression.kt")
        public void testWhenInDotQualifiedExpression() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whenInDotQualifiedExpression.kt");
        }

        @TestMetadata("whenLambda.kt")
        public void testWhenLambda() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whenLambda.kt");
        }

        @TestMetadata("whenMultiple.kt")
        public void testWhenMultiple() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whenMultiple.kt");
        }

        @TestMetadata("whenNoBraces.kt")
        public void testWhenNoBraces() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whenNoBraces.kt");
        }

        @TestMetadata("whenSimple.kt")
        public void testWhenSimple() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whenSimple.kt");
        }

        @TestMetadata("whenSimpleOutsideBlock.kt")
        public void testWhenSimpleOutsideBlock() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whenSimpleOutsideBlock.kt");
        }

        @TestMetadata("whenStatement.kt")
        public void testWhenStatement() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whenStatement.kt");
        }

        @TestMetadata("while.kt")
        public void testWhile() throws Exception {
            runTest("idea/testData/intentions/removeBraces/while.kt");
        }

        @TestMetadata("whileOutsideBlock.kt")
        public void testWhileOutsideBlock() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whileOutsideBlock.kt");
        }

        @TestMetadata("whileWithTwoStatements.kt")
        public void testWhileWithTwoStatements() throws Exception {
            runTest("idea/testData/intentions/removeBraces/whileWithTwoStatements.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeConstructorKeyword")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveConstructorKeyword extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractClass.kt")
        public void testAbstractClass() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/abstractClass.kt");
        }

        public void testAllFilesPresentInRemoveConstructorKeyword() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeConstructorKeyword"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotatedParam.kt")
        public void testAnnotatedParam() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/annotatedParam.kt");
        }

        @TestMetadata("annotationClass.kt")
        public void testAnnotationClass() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/annotationClass.kt");
        }

        @TestMetadata("comments.kt")
        public void testComments() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/comments.kt");
        }

        @TestMetadata("dataClass.kt")
        public void testDataClass() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/dataClass.kt");
        }

        @TestMetadata("inParameters.kt")
        public void testInParameters() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/inParameters.kt");
        }

        @TestMetadata("varargVal.kt")
        public void testVarargVal() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/varargVal.kt");
        }

        @TestMetadata("withProperties.kt")
        public void testWithProperties() throws Exception {
            runTest("idea/testData/intentions/removeConstructorKeyword/withProperties.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeCurlyBracesFromTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveCurlyBracesFromTemplate extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveCurlyBracesFromTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeCurlyBracesFromTemplate"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("necessaryBrackets1.kt")
        public void testNecessaryBrackets1() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets1.kt");
        }

        @TestMetadata("necessaryBrackets2.kt")
        public void testNecessaryBrackets2() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets2.kt");
        }

        @TestMetadata("necessaryBrackets3.kt")
        public void testNecessaryBrackets3() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets3.kt");
        }

        @TestMetadata("necessaryBrackets4.kt")
        public void testNecessaryBrackets4() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets4.kt");
        }

        @TestMetadata("necessaryBrackets5.kt")
        public void testNecessaryBrackets5() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets5.kt");
        }

        @TestMetadata("necessaryBrackets6.kt")
        public void testNecessaryBrackets6() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/necessaryBrackets6.kt");
        }

        @TestMetadata("unnecessaryBrackets1.kt")
        public void testUnnecessaryBrackets1() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets1.kt");
        }

        @TestMetadata("unnecessaryBrackets2.kt")
        public void testUnnecessaryBrackets2() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets2.kt");
        }

        @TestMetadata("unnecessaryBrackets3.kt")
        public void testUnnecessaryBrackets3() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets3.kt");
        }

        @TestMetadata("unnecessaryBrackets4.kt")
        public void testUnnecessaryBrackets4() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets4.kt");
        }

        @TestMetadata("unnecessaryBrackets5.kt")
        public void testUnnecessaryBrackets5() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets5.kt");
        }

        @TestMetadata("unnecessaryBrackets6.kt")
        public void testUnnecessaryBrackets6() throws Exception {
            runTest("idea/testData/intentions/removeCurlyBracesFromTemplate/unnecessaryBrackets6.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptyClassBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptyClassBody extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveEmptyClassBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptyClassBody"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousInterfaceObject.kt")
        public void testAnonymousInterfaceObject() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/anonymousInterfaceObject.kt");
        }

        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/anonymousObject.kt");
        }

        @TestMetadata("companionBeforeFun.kt")
        public void testCompanionBeforeFun() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/companionBeforeFun.kt");
        }

        @TestMetadata("companionBeforeInit.kt")
        public void testCompanionBeforeInit() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/companionBeforeInit.kt");
        }

        @TestMetadata("companionBeforePrivateFun.kt")
        public void testCompanionBeforePrivateFun() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/companionBeforePrivateFun.kt");
        }

        @TestMetadata("companionBeforeVal.kt")
        public void testCompanionBeforeVal() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/companionBeforeVal.kt");
        }

        @TestMetadata("companionInLast.kt")
        public void testCompanionInLast() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/companionInLast.kt");
        }

        @TestMetadata("companionWithName.kt")
        public void testCompanionWithName() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/companionWithName.kt");
        }

        @TestMetadata("companionWithSemicolon.kt")
        public void testCompanionWithSemicolon() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/companionWithSemicolon.kt");
        }

        @TestMetadata("emptyClass.kt")
        public void testEmptyClass() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/emptyClass.kt");
        }

        @TestMetadata("emptyDataClass.kt")
        public void testEmptyDataClass() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/emptyDataClass.kt");
        }

        @TestMetadata("emptyInterface.kt")
        public void testEmptyInterface() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/emptyInterface.kt");
        }

        @TestMetadata("innerClass.kt")
        public void testInnerClass() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/innerClass.kt");
        }

        @TestMetadata("nestedAnonymous.kt")
        public void testNestedAnonymous() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/nestedAnonymous.kt");
        }

        @TestMetadata("nestedClassFollowedByFunction.kt")
        public void testNestedClassFollowedByFunction() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/nestedClassFollowedByFunction.kt");
        }

        @TestMetadata("nestedClassFollowedByMember.kt")
        public void testNestedClassFollowedByMember() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/nestedClassFollowedByMember.kt");
        }

        @TestMetadata("nestedClassFollowedBySecondaryConstructor.kt")
        public void testNestedClassFollowedBySecondaryConstructor() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/nestedClassFollowedBySecondaryConstructor.kt");
        }

        @TestMetadata("nestedClassFollowedBySecondaryConstructor2.kt")
        public void testNestedClassFollowedBySecondaryConstructor2() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/nestedClassFollowedBySecondaryConstructor2.kt");
        }

        @TestMetadata("noneEmptyClass.kt")
        public void testNoneEmptyClass() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/noneEmptyClass.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("idea/testData/intentions/removeEmptyClassBody/object.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptyParenthesesFromLambdaCall extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("afterLambda.kt")
        public void testAfterLambda() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/afterLambda.kt");
        }

        @TestMetadata("afterLambda2.kt")
        public void testAfterLambda2() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/afterLambda2.kt");
        }

        @TestMetadata("afterLambda3.kt")
        public void testAfterLambda3() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/afterLambda3.kt");
        }

        @TestMetadata("afterLambda4.kt")
        public void testAfterLambda4() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/afterLambda4.kt");
        }

        @TestMetadata("afterLambda5.kt")
        public void testAfterLambda5() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/afterLambda5.kt");
        }

        @TestMetadata("afterLambda6.kt")
        public void testAfterLambda6() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/afterLambda6.kt");
        }

        public void testAllFilesPresentInRemoveEmptyParenthesesFromLambdaCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nextLine.kt")
        public void testNextLine() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/nextLine.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/removeEmptyParenthesesFromLambdaCall/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptyPrimaryConstructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptyPrimaryConstructor extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveEmptyPrimaryConstructor() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptyPrimaryConstructor"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotation.kt")
        public void testAnnotation() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/annotation.kt");
        }

        @TestMetadata("expectClassExplicitConstructor.kt")
        public void testExpectClassExplicitConstructor() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/expectClassExplicitConstructor.kt");
        }

        @TestMetadata("expectClassPrimaryConstructor.kt")
        public void testExpectClassPrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/expectClassPrimaryConstructor.kt");
        }

        @TestMetadata("keyword.kt")
        public void testKeyword() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/keyword.kt");
        }

        @TestMetadata("modifier.kt")
        public void testModifier() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/modifier.kt");
        }

        @TestMetadata("nestedExpectClassPrimaryConstructor.kt")
        public void testNestedExpectClassPrimaryConstructor() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/nestedExpectClassPrimaryConstructor.kt");
        }

        @TestMetadata("secondary.kt")
        public void testSecondary() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/secondary.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/removeEmptyPrimaryConstructor/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeEmptySecondaryConstructorBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveEmptySecondaryConstructorBody extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveEmptySecondaryConstructorBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeEmptySecondaryConstructorBody"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("comment.kt")
        public void testComment() throws Exception {
            runTest("idea/testData/intentions/removeEmptySecondaryConstructorBody/comment.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/removeEmptySecondaryConstructorBody/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeExplicitLambdaParameterTypes")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitLambdaParameterTypes extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveExplicitLambdaParameterTypes() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitLambdaParameterTypes"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("invalidCursorPosition.kt")
        public void testInvalidCursorPosition() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/invalidCursorPosition.kt");
        }

        @TestMetadata("lambdaWithLambdaAsParam.kt")
        public void testLambdaWithLambdaAsParam() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/lambdaWithLambdaAsParam.kt");
        }

        @TestMetadata("multipleExplicitParams.kt")
        public void testMultipleExplicitParams() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/multipleExplicitParams.kt");
        }

        @TestMetadata("paramTypeDeclared.kt")
        public void testParamTypeDeclared() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/paramTypeDeclared.kt");
        }

        @TestMetadata("singleExplicitParam.kt")
        public void testSingleExplicitParam() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/singleExplicitParam.kt");
        }

        @TestMetadata("typesAlreadyImplicit.kt")
        public void testTypesAlreadyImplicit() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/typesAlreadyImplicit.kt");
        }

        @TestMetadata("withDestructuring.kt")
        public void testWithDestructuring() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/withDestructuring.kt");
        }

        @TestMetadata("withDestructuringAndSimple.kt")
        public void testWithDestructuringAndSimple() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/withDestructuringAndSimple.kt");
        }

        @TestMetadata("withDestructuringInMiddle.kt")
        public void testWithDestructuringInMiddle() throws Exception {
            runTest("idea/testData/intentions/removeExplicitLambdaParameterTypes/withDestructuringInMiddle.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeExplicitSuperQualifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitSuperQualifier extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveExplicitSuperQualifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitSuperQualifier"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("AmbiguousSuperMethod.kt")
        public void testAmbiguousSuperMethod() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/AmbiguousSuperMethod.kt");
        }

        @TestMetadata("AmbiguousSuperProperty.kt")
        public void testAmbiguousSuperProperty() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/AmbiguousSuperProperty.kt");
        }

        @TestMetadata("DataFlowInfoUsed.kt")
        public void testDataFlowInfoUsed() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/DataFlowInfoUsed.kt");
        }

        @TestMetadata("IncompleteCall.kt")
        public void testIncompleteCall() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/IncompleteCall.kt");
        }

        @TestMetadata("IncompleteCallAmbiguous.kt")
        public void testIncompleteCallAmbiguous() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/IncompleteCallAmbiguous.kt");
        }

        @TestMetadata("SingleSuper.kt")
        public void testSingleSuper() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/SingleSuper.kt");
        }

        @TestMetadata("SuperWithLabel.kt")
        public void testSuperWithLabel() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/SuperWithLabel.kt");
        }

        @TestMetadata("UnambiguousSuperMethod.kt")
        public void testUnambiguousSuperMethod() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/UnambiguousSuperMethod.kt");
        }

        @TestMetadata("UnambiguousSuperProperty.kt")
        public void testUnambiguousSuperProperty() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/UnambiguousSuperProperty.kt");
        }

        @TestMetadata("WrongOffset1.kt")
        public void testWrongOffset1() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/WrongOffset1.kt");
        }

        @TestMetadata("WrongOffset2.kt")
        public void testWrongOffset2() throws Exception {
            runTest("idea/testData/intentions/removeExplicitSuperQualifier/WrongOffset2.kt");
        }

        @TestMetadata("idea/testData/intentions/removeExplicitSuperQualifier/inspectionData")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InspectionData extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInspectionData() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitSuperQualifier/inspectionData"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/removeExplicitType")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitType extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveExplicitType() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitType"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousFunctionInitializer.kt")
        public void testAnonymousFunctionInitializer() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/anonymousFunctionInitializer.kt");
        }

        @TestMetadata("anonymousFunctionInitializer2.kt")
        public void testAnonymousFunctionInitializer2() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/anonymousFunctionInitializer2.kt");
        }

        @TestMetadata("anonymousFunctionInitializer3.kt")
        public void testAnonymousFunctionInitializer3() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/anonymousFunctionInitializer3.kt");
        }

        @TestMetadata("extensionFunction.kt")
        public void testExtensionFunction() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/extensionFunction.kt");
        }

        @TestMetadata("funNoBody.kt")
        public void testFunNoBody() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/funNoBody.kt");
        }

        @TestMetadata("funWithBody.kt")
        public void testFunWithBody() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/funWithBody.kt");
        }

        @TestMetadata("hasAnnotation.kt")
        public void testHasAnnotation() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/hasAnnotation.kt");
        }

        @TestMetadata("lambdaExpressionBody.kt")
        public void testLambdaExpressionBody() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/lambdaExpressionBody.kt");
        }

        @TestMetadata("lambdaInitializer.kt")
        public void testLambdaInitializer() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/lambdaInitializer.kt");
        }

        @TestMetadata("lambdaInitializer2.kt")
        public void testLambdaInitializer2() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/lambdaInitializer2.kt");
        }

        @TestMetadata("lambdaInitializer3.kt")
        public void testLambdaInitializer3() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/lambdaInitializer3.kt");
        }

        @TestMetadata("lambdaInitializer4.kt")
        public void testLambdaInitializer4() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/lambdaInitializer4.kt");
        }

        @TestMetadata("lambdaInitializer5.kt")
        public void testLambdaInitializer5() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/lambdaInitializer5.kt");
        }

        @TestMetadata("needTypeArgument.kt")
        public void testNeedTypeArgument() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/needTypeArgument.kt");
        }

        @TestMetadata("needTypeArgument2.kt")
        public void testNeedTypeArgument2() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/needTypeArgument2.kt");
        }

        @TestMetadata("notOnParameterOfFunctionType.kt")
        public void testNotOnParameterOfFunctionType() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/notOnParameterOfFunctionType.kt");
        }

        @TestMetadata("notOnSetterParameter.kt")
        public void testNotOnSetterParameter() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/notOnSetterParameter.kt");
        }

        @TestMetadata("onOverride.kt")
        public void testOnOverride() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/onOverride.kt");
        }

        @TestMetadata("onOverrideInTrait.kt")
        public void testOnOverrideInTrait() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/onOverrideInTrait.kt");
        }

        @TestMetadata("onSetterParameter.kt")
        public void testOnSetterParameter() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/onSetterParameter.kt");
        }

        @TestMetadata("onType.kt")
        public void testOnType() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/onType.kt");
        }

        @TestMetadata("propertyTypeFromGetter.kt")
        public void testPropertyTypeFromGetter() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/propertyTypeFromGetter.kt");
        }

        @TestMetadata("removeUnresolvedType.kt")
        public void testRemoveUnresolvedType() throws Exception {
            runTest("idea/testData/intentions/removeExplicitType/removeUnresolvedType.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeExplicitTypeArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveExplicitTypeArguments extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveExplicitTypeArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitTypeArguments"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("blockValue.kt")
        public void testBlockValue() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/blockValue.kt");
        }

        @TestMetadata("defaultParamValue.kt")
        public void testDefaultParamValue() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/defaultParamValue.kt");
        }

        @TestMetadata("fourLiterals.kt")
        public void testFourLiterals() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/fourLiterals.kt");
        }

        @TestMetadata("functionBodyIsCallWithUnnecessaryTypeArgs.kt")
        public void testFunctionBodyIsCallWithUnnecessaryTypeArgs() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/functionBodyIsCallWithUnnecessaryTypeArgs.kt");
        }

        @TestMetadata("getterBody.kt")
        public void testGetterBody() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/getterBody.kt");
        }

        @TestMetadata("inapplicableTypeThatIsAFunItCannotBeInferred.kt")
        public void testInapplicableTypeThatIsAFunItCannotBeInferred() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/inapplicableTypeThatIsAFunItCannotBeInferred.kt");
        }

        @TestMetadata("insideDeepOtherCall.kt")
        public void testInsideDeepOtherCall() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/insideDeepOtherCall.kt");
        }

        @TestMetadata("insideGenericCall.kt")
        public void testInsideGenericCall() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/insideGenericCall.kt");
        }

        @TestMetadata("insideOtherCall.kt")
        public void testInsideOtherCall() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/insideOtherCall.kt");
        }

        @TestMetadata("lambdaType.kt")
        public void testLambdaType() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/lambdaType.kt");
        }

        @TestMetadata("lambdaValue.kt")
        public void testLambdaValue() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/lambdaValue.kt");
        }

        @TestMetadata("literalAny.kt")
        public void testLiteralAny() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/literalAny.kt");
        }

        @TestMetadata("literalString.kt")
        public void testLiteralString() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/literalString.kt");
        }

        @TestMetadata("literalStringWithClass.kt")
        public void testLiteralStringWithClass() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/literalStringWithClass.kt");
        }

        @TestMetadata("literalsWhenTypeArgHasTypeArg.kt")
        public void testLiteralsWhenTypeArgHasTypeArg() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/literalsWhenTypeArgHasTypeArg.kt");
        }

        @TestMetadata("mapGet.kt")
        public void testMapGet() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/mapGet.kt");
        }

        @TestMetadata("nestedCall-KT-5028.kt")
        public void testNestedCall_KT_5028() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/nestedCall-KT-5028.kt");
        }

        @TestMetadata("notApplicableNotEnoughtInfo.kt")
        public void testNotApplicableNotEnoughtInfo() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/notApplicableNotEnoughtInfo.kt");
        }

        @TestMetadata("notApplicableSupertypeOfInferred.kt")
        public void testNotApplicableSupertypeOfInferred() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/notApplicableSupertypeOfInferred.kt");
        }

        @TestMetadata("notApplicableSupertypeOfInferredClass.kt")
        public void testNotApplicableSupertypeOfInferredClass() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/notApplicableSupertypeOfInferredClass.kt");
        }

        @TestMetadata("platforrmType1.kt")
        public void testPlatforrmType1() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/platforrmType1.kt");
        }

        @TestMetadata("platforrmType2.kt")
        public void testPlatforrmType2() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/platforrmType2.kt");
        }

        @TestMetadata("propertyInitializerIsCallWithUnnecessaryTypeArgs.kt")
        public void testPropertyInitializerIsCallWithUnnecessaryTypeArgs() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/propertyInitializerIsCallWithUnnecessaryTypeArgs.kt");
        }

        @TestMetadata("qualified.kt")
        public void testQualified() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/qualified.kt");
        }

        @TestMetadata("returnCallWithUnnecessaryTypeArgs.kt")
        public void testReturnCallWithUnnecessaryTypeArgs() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/returnCallWithUnnecessaryTypeArgs.kt");
        }

        @TestMetadata("twoArguments.kt")
        public void testTwoArguments() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/twoArguments.kt");
        }

        @TestMetadata("twoLiteralValues.kt")
        public void testTwoLiteralValues() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/twoLiteralValues.kt");
        }

        @TestMetadata("variableString.kt")
        public void testVariableString() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/variableString.kt");
        }

        @TestMetadata("variableString2.kt")
        public void testVariableString2() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/variableString2.kt");
        }

        @TestMetadata("variableStringFartherScope.kt")
        public void testVariableStringFartherScope() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/variableStringFartherScope.kt");
        }

        @TestMetadata("variablesAndLiterals.kt")
        public void testVariablesAndLiterals() throws Exception {
            runTest("idea/testData/intentions/removeExplicitTypeArguments/variablesAndLiterals.kt");
        }

        @TestMetadata("idea/testData/intentions/removeExplicitTypeArguments/inspectionData")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InspectionData extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInspectionData() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeExplicitTypeArguments/inspectionData"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/intentions/removeForLoopIndices")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveForLoopIndices extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveForLoopIndices() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeForLoopIndices"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inapplicableForLoop.kt")
        public void testInapplicableForLoop() throws Exception {
            runTest("idea/testData/intentions/removeForLoopIndices/inapplicableForLoop.kt");
        }

        @TestMetadata("inapplicableIndexUse.kt")
        public void testInapplicableIndexUse() throws Exception {
            runTest("idea/testData/intentions/removeForLoopIndices/inapplicableIndexUse.kt");
        }

        @TestMetadata("inapplicableOverridenFunction.kt")
        public void testInapplicableOverridenFunction() throws Exception {
            runTest("idea/testData/intentions/removeForLoopIndices/inapplicableOverridenFunction.kt");
        }

        @TestMetadata("loopWithType.kt")
        public void testLoopWithType() throws Exception {
            runTest("idea/testData/intentions/removeForLoopIndices/loopWithType.kt");
        }

        @TestMetadata("simpleLoopWithIndices.kt")
        public void testSimpleLoopWithIndices() throws Exception {
            runTest("idea/testData/intentions/removeForLoopIndices/simpleLoopWithIndices.kt");
        }

        @TestMetadata("simpleLoopWithIndicesOverCharSequence.kt")
        public void testSimpleLoopWithIndicesOverCharSequence() throws Exception {
            runTest("idea/testData/intentions/removeForLoopIndices/simpleLoopWithIndicesOverCharSequence.kt");
        }

        @TestMetadata("simpleLoopWithIndicesOverSequence.kt")
        public void testSimpleLoopWithIndicesOverSequence() throws Exception {
            runTest("idea/testData/intentions/removeForLoopIndices/simpleLoopWithIndicesOverSequence.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeLabeledReturnInLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveLabeledReturnInLambda extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveLabeledReturnInLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeLabeledReturnInLambda"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("labeledLambda.kt")
        public void testLabeledLambda() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/labeledLambda.kt");
        }

        @TestMetadata("multipleBlocks.kt")
        public void testMultipleBlocks() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/multipleBlocks.kt");
        }

        @TestMetadata("normal.kt")
        public void testNormal() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/normal.kt");
        }

        @TestMetadata("notInsideLabeled.kt")
        public void testNotInsideLabeled() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/notInsideLabeled.kt");
        }

        @TestMetadata("notLabeled.kt")
        public void testNotLabeled() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/notLabeled.kt");
        }

        @TestMetadata("notLastLine.kt")
        public void testNotLastLine() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/notLastLine.kt");
        }

        @TestMetadata("outerLambda.kt")
        public void testOuterLambda() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/outerLambda.kt");
        }

        @TestMetadata("unit.kt")
        public void testUnit() throws Exception {
            runTest("idea/testData/intentions/removeLabeledReturnInLambda/unit.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeRedundantCallsOfConversionMethods")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveRedundantCallsOfConversionMethods extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveRedundantCallsOfConversionMethods() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeRedundantCallsOfConversionMethods"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("booleanToInt.kt")
        public void testBooleanToInt() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/booleanToInt.kt");
        }

        @TestMetadata("byte.kt")
        public void testByte() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/byte.kt");
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/char.kt");
        }

        @TestMetadata("double.kt")
        public void testDouble() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/double.kt");
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/float.kt");
        }

        @TestMetadata("int.kt")
        public void testInt() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/int.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/long.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/nullable.kt");
        }

        @TestMetadata("nullable2.kt")
        public void testNullable2() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/nullable2.kt");
        }

        @TestMetadata("safeString.kt")
        public void testSafeString() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/safeString.kt");
        }

        @TestMetadata("safeString2.kt")
        public void testSafeString2() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/safeString2.kt");
        }

        @TestMetadata("short.kt")
        public void testShort() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/short.kt");
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/string.kt");
        }

        @TestMetadata("toOtherType.kt")
        public void testToOtherType() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/toOtherType.kt");
        }

        @TestMetadata("variable.kt")
        public void testVariable() throws Exception {
            runTest("idea/testData/intentions/removeRedundantCallsOfConversionMethods/variable.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeSingleExpressionStringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveSingleExpressionStringTemplate extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveSingleExpressionStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeSingleExpressionStringTemplate"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyString.kt")
        public void testEmptyString() throws Exception {
            runTest("idea/testData/intentions/removeSingleExpressionStringTemplate/emptyString.kt");
        }

        @TestMetadata("justString.kt")
        public void testJustString() throws Exception {
            runTest("idea/testData/intentions/removeSingleExpressionStringTemplate/justString.kt");
        }

        @TestMetadata("multipleStringTemplate.kt")
        public void testMultipleStringTemplate() throws Exception {
            runTest("idea/testData/intentions/removeSingleExpressionStringTemplate/multipleStringTemplate.kt");
        }

        @TestMetadata("singleExpressionStringTemplate.kt")
        public void testSingleExpressionStringTemplate() throws Exception {
            runTest("idea/testData/intentions/removeSingleExpressionStringTemplate/singleExpressionStringTemplate.kt");
        }

        @TestMetadata("singleExpressionStringTemplateWithMethodCall.kt")
        public void testSingleExpressionStringTemplateWithMethodCall() throws Exception {
            runTest("idea/testData/intentions/removeSingleExpressionStringTemplate/singleExpressionStringTemplateWithMethodCall.kt");
        }

        @TestMetadata("singleExpressionStringTemplateWithNonStringType.kt")
        public void testSingleExpressionStringTemplateWithNonStringType() throws Exception {
            runTest("idea/testData/intentions/removeSingleExpressionStringTemplate/singleExpressionStringTemplateWithNonStringType.kt");
        }

        @TestMetadata("stringTemplateWithText.kt")
        public void testStringTemplateWithText() throws Exception {
            runTest("idea/testData/intentions/removeSingleExpressionStringTemplate/stringTemplateWithText.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/removeUnnecessaryParentheses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveUnnecessaryParentheses extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveUnnecessaryParentheses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/removeUnnecessaryParentheses"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callInsideCallWithLambdaOnly.kt")
        public void testCallInsideCallWithLambdaOnly() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/callInsideCallWithLambdaOnly.kt");
        }

        @TestMetadata("elvisRhs.kt")
        public void testElvisRhs() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/elvisRhs.kt");
        }

        @TestMetadata("elvisRhsEmptyReturn.kt")
        public void testElvisRhsEmptyReturn() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/elvisRhsEmptyReturn.kt");
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/lambda.kt");
        }

        @TestMetadata("lambda2.kt")
        public void testLambda2() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/lambda2.kt");
        }

        @TestMetadata("lambda3.kt")
        public void testLambda3() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/lambda3.kt");
        }

        @TestMetadata("necessaryParentheses1.kt")
        public void testNecessaryParentheses1() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses1.kt");
        }

        @TestMetadata("necessaryParentheses2.kt")
        public void testNecessaryParentheses2() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses2.kt");
        }

        @TestMetadata("necessaryParentheses3.kt")
        public void testNecessaryParentheses3() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses3.kt");
        }

        @TestMetadata("necessaryParentheses4.kt")
        public void testNecessaryParentheses4() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses4.kt");
        }

        @TestMetadata("necessaryParentheses5.kt")
        public void testNecessaryParentheses5() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/necessaryParentheses5.kt");
        }

        @TestMetadata("unnecessaryParentheses1.kt")
        public void testUnnecessaryParentheses1() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses1.kt");
        }

        @TestMetadata("unnecessaryParentheses2.kt")
        public void testUnnecessaryParentheses2() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses2.kt");
        }

        @TestMetadata("unnecessaryParentheses3.kt")
        public void testUnnecessaryParentheses3() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses3.kt");
        }

        @TestMetadata("unnecessaryParentheses4.kt")
        public void testUnnecessaryParentheses4() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses4.kt");
        }

        @TestMetadata("unnecessaryParentheses5.kt")
        public void testUnnecessaryParentheses5() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses5.kt");
        }

        @TestMetadata("unnecessaryParentheses6.kt")
        public void testUnnecessaryParentheses6() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses6.kt");
        }

        @TestMetadata("unnecessaryParentheses7.kt")
        public void testUnnecessaryParentheses7() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses7.kt");
        }

        @TestMetadata("unnecessaryParentheses8.kt")
        public void testUnnecessaryParentheses8() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParentheses8.kt");
        }

        @TestMetadata("unnecessaryParenthesesWithComment.kt")
        public void testUnnecessaryParenthesesWithComment() throws Exception {
            runTest("idea/testData/intentions/removeUnnecessaryParentheses/unnecessaryParenthesesWithComment.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceAddWithPlusAssign")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceAddWithPlusAssign extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("add.kt")
        public void testAdd() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/add.kt");
        }

        @TestMetadata("addAll.kt")
        public void testAddAll() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/addAll.kt");
        }

        @TestMetadata("addAllAtIndex.kt")
        public void testAddAllAtIndex() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/addAllAtIndex.kt");
        }

        @TestMetadata("addAllToVar.kt")
        public void testAddAllToVar() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/addAllToVar.kt");
        }

        @TestMetadata("addAtIndex.kt")
        public void testAddAtIndex() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/addAtIndex.kt");
        }

        @TestMetadata("addGeneric.kt")
        public void testAddGeneric() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/addGeneric.kt");
        }

        @TestMetadata("addToVar.kt")
        public void testAddToVar() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/addToVar.kt");
        }

        public void testAllFilesPresentInReplaceAddWithPlusAssign() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceAddWithPlusAssign"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nonCollection.kt")
        public void testNonCollection() throws Exception {
            runTest("idea/testData/intentions/replaceAddWithPlusAssign/nonCollection.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceExplicitFunctionLiteralParamWithIt extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceExplicitFunctionLiteralParamWithIt() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("applicable_cursofOverParamInInnerLiteral.kt")
        public void testApplicable_cursofOverParamInInnerLiteral() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_cursofOverParamInInnerLiteral.kt");
        }

        @TestMetadata("applicable_cursorOverParameterDeclaration.kt")
        public void testApplicable_cursorOverParameterDeclaration() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_cursorOverParameterDeclaration.kt");
        }

        @TestMetadata("applicable_cursorOverParameterUse.kt")
        public void testApplicable_cursorOverParameterUse() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_cursorOverParameterUse.kt");
        }

        @TestMetadata("applicable_formatsProperly.kt")
        public void testApplicable_formatsProperly() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_formatsProperly.kt");
        }

        @TestMetadata("applicable_nestedLiteralsNoUseInside.kt")
        public void testApplicable_nestedLiteralsNoUseInside() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/applicable_nestedLiteralsNoUseInside.kt");
        }

        @TestMetadata("notApplicable_alreadyUsesImplicitIt.kt")
        public void testNotApplicable_alreadyUsesImplicitIt() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_alreadyUsesImplicitIt.kt");
        }

        @TestMetadata("notApplicable_hasDestructuringDeclaration.kt")
        public void testNotApplicable_hasDestructuringDeclaration() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_hasDestructuringDeclaration.kt");
        }

        @TestMetadata("notApplicable_hasMultipleParameters.kt")
        public void testNotApplicable_hasMultipleParameters() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_hasMultipleParameters.kt");
        }

        @TestMetadata("notApplicable_itFromOuterLambda.kt")
        public void testNotApplicable_itFromOuterLambda() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_itFromOuterLambda.kt");
        }

        @TestMetadata("notApplicable_nestedLiterals.kt")
        public void testNotApplicable_nestedLiterals() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_nestedLiterals.kt");
        }

        @TestMetadata("notApplicable_nestedLiteralsNoIt.kt")
        public void testNotApplicable_nestedLiteralsNoIt() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_nestedLiteralsNoIt.kt");
        }

        @TestMetadata("notApplicable_notFunctionLiteralParameter.kt")
        public void testNotApplicable_notFunctionLiteralParameter() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_notFunctionLiteralParameter.kt");
        }

        @TestMetadata("notApplicable_parameterHasExplicitType.kt")
        public void testNotApplicable_parameterHasExplicitType() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_parameterHasExplicitType.kt");
        }

        @TestMetadata("notApplicable_wrongPosition.kt")
        public void testNotApplicable_wrongPosition() throws Exception {
            runTest("idea/testData/intentions/replaceExplicitFunctionLiteralParamWithIt/notApplicable_wrongPosition.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceItWithExplicitFunctionLiteralParam extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceItWithExplicitFunctionLiteralParam() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("applicable.kt")
        public void testApplicable() throws Exception {
            runTest("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/applicable.kt");
        }

        @TestMetadata("applicable_nestedFunctionLiterals.kt")
        public void testApplicable_nestedFunctionLiterals() throws Exception {
            runTest("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/applicable_nestedFunctionLiterals.kt");
        }

        @TestMetadata("applicable_nestedFunctionWithIt.kt")
        public void testApplicable_nestedFunctionWithIt() throws Exception {
            runTest("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/applicable_nestedFunctionWithIt.kt");
        }

        @TestMetadata("notApplicable_localVariableIt.kt")
        public void testNotApplicable_localVariableIt() throws Exception {
            runTest("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/notApplicable_localVariableIt.kt");
        }

        @TestMetadata("notApplicable_parameterExplicitlyNamedIt.kt")
        public void testNotApplicable_parameterExplicitlyNamedIt() throws Exception {
            runTest("idea/testData/intentions/replaceItWithExplicitFunctionLiteralParam/notApplicable_parameterExplicitlyNamedIt.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceMathMaxWithCoerceAtLeast extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceMathMaxWithCoerceAtLeast() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("customMaxMethod.kt")
        public void testCustomMaxMethod() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/customMaxMethod.kt");
        }

        @TestMetadata("doubles.kt")
        public void testDoubles() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/doubles.kt");
        }

        @TestMetadata("KT-19232-1.kt")
        public void testKT_19232_1() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/KT-19232-1.kt");
        }

        @TestMetadata("KT-19232-2.kt")
        public void testKT_19232_2() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/KT-19232-2.kt");
        }

        @TestMetadata("maxInMax.kt")
        public void testMaxInMax() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/maxInMax.kt");
        }

        @TestMetadata("moreThan2ValueArg.kt")
        public void testMoreThan2ValueArg() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/moreThan2ValueArg.kt");
        }

        @TestMetadata("noImport.kt")
        public void testNoImport() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/noImport.kt");
        }

        @TestMetadata("oneValueArg.kt")
        public void testOneValueArg() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/oneValueArg.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/replaceMathMaxWithCoerceAtLeast/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceMathMinWithCoerceAtMost")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceMathMinWithCoerceAtMost extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceMathMinWithCoerceAtMost() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceMathMinWithCoerceAtMost"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("customMinMethod.kt")
        public void testCustomMinMethod() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/customMinMethod.kt");
        }

        @TestMetadata("doubles.kt")
        public void testDoubles() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/doubles.kt");
        }

        @TestMetadata("KT-19232-1.kt")
        public void testKT_19232_1() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/KT-19232-1.kt");
        }

        @TestMetadata("KT-19232-2.kt")
        public void testKT_19232_2() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/KT-19232-2.kt");
        }

        @TestMetadata("moreThan2ValueArg.kt")
        public void testMoreThan2ValueArg() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/moreThan2ValueArg.kt");
        }

        @TestMetadata("noImport.kt")
        public void testNoImport() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/noImport.kt");
        }

        @TestMetadata("oneValueArg.kt")
        public void testOneValueArg() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/oneValueArg.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/replaceMathMinWithCoerceAtMost/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSingleLineLetIntention")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSingleLineLetIntention extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSingleLineLetIntention() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSingleLineLetIntention"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/assignment.kt");
        }

        @TestMetadata("binarySafeCall.kt")
        public void testBinarySafeCall() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/binarySafeCall.kt");
        }

        @TestMetadata("comparisons.kt")
        public void testComparisons() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/comparisons.kt");
        }

        @TestMetadata("destructuringDeclaration.kt")
        public void testDestructuringDeclaration() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/destructuringDeclaration.kt");
        }

        @TestMetadata("destructuringDeclaration2.kt")
        public void testDestructuringDeclaration2() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/destructuringDeclaration2.kt");
        }

        @TestMetadata("destructuringDeclaration3.kt")
        public void testDestructuringDeclaration3() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/destructuringDeclaration3.kt");
        }

        @TestMetadata("destructuringDeclaration4.kt")
        public void testDestructuringDeclaration4() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/destructuringDeclaration4.kt");
        }

        @TestMetadata("destructuringDeclaration5.kt")
        public void testDestructuringDeclaration5() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/destructuringDeclaration5.kt");
        }

        @TestMetadata("dotWithComparison.kt")
        public void testDotWithComparison() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/dotWithComparison.kt");
        }

        @TestMetadata("functionCall1.kt")
        public void testFunctionCall1() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCall1.kt");
        }

        @TestMetadata("functionCall2.kt")
        public void testFunctionCall2() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCall2.kt");
        }

        @TestMetadata("functionCall3.kt")
        public void testFunctionCall3() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCall3.kt");
        }

        @TestMetadata("functionCall4.kt")
        public void testFunctionCall4() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCall4.kt");
        }

        @TestMetadata("functionCall5.kt")
        public void testFunctionCall5() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCall5.kt");
        }

        @TestMetadata("functionCall6.kt")
        public void testFunctionCall6() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCall6.kt");
        }

        @TestMetadata("functionCall7.kt")
        public void testFunctionCall7() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCall7.kt");
        }

        @TestMetadata("functionCallInExtension.kt")
        public void testFunctionCallInExtension() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCallInExtension.kt");
        }

        @TestMetadata("functionCallOnSafeCall.kt")
        public void testFunctionCallOnSafeCall() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/functionCallOnSafeCall.kt");
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/in.kt");
        }

        @TestMetadata("inWithMultipleParam.kt")
        public void testInWithMultipleParam() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/inWithMultipleParam.kt");
        }

        @TestMetadata("inWithRange.kt")
        public void testInWithRange() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/inWithRange.kt");
        }

        @TestMetadata("inWithRangeMultipleParam.kt")
        public void testInWithRangeMultipleParam() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/inWithRangeMultipleParam.kt");
        }

        @TestMetadata("lambdaWithBinaryExpression.kt")
        public void testLambdaWithBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/lambdaWithBinaryExpression.kt");
        }

        @TestMetadata("lambdaWithBinaryExpression2.kt")
        public void testLambdaWithBinaryExpression2() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/lambdaWithBinaryExpression2.kt");
        }

        @TestMetadata("let.kt")
        public void testLet() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/let.kt");
        }

        @TestMetadata("letMultipleLines.kt")
        public void testLetMultipleLines() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letMultipleLines.kt");
        }

        @TestMetadata("letNoSafeCall.kt")
        public void testLetNoSafeCall() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letNoSafeCall.kt");
        }

        @TestMetadata("letNotUseParameterReceiver.kt")
        public void testLetNotUseParameterReceiver() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letNotUseParameterReceiver.kt");
        }

        @TestMetadata("letNotUseReceiver.kt")
        public void testLetNotUseReceiver() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letNotUseReceiver.kt");
        }

        @TestMetadata("letUseIt.kt")
        public void testLetUseIt() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseIt.kt");
        }

        @TestMetadata("letUseItAsParamWithBinaryExpression.kt")
        public void testLetUseItAsParamWithBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseItAsParamWithBinaryExpression.kt");
        }

        @TestMetadata("letUseItWithBinaryExpression.kt")
        public void testLetUseItWithBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithBinaryExpression.kt");
        }

        @TestMetadata("letUseItWithBinaryExpression2.kt")
        public void testLetUseItWithBinaryExpression2() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithBinaryExpression2.kt");
        }

        @TestMetadata("letUseItWithMultipleMethodCall1.kt")
        public void testLetUseItWithMultipleMethodCall1() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithMultipleMethodCall1.kt");
        }

        @TestMetadata("letUseItWithMultipleMethodCall2.kt")
        public void testLetUseItWithMultipleMethodCall2() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithMultipleMethodCall2.kt");
        }

        @TestMetadata("letUseItWithMultipleMethodCall3.kt")
        public void testLetUseItWithMultipleMethodCall3() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseItWithMultipleMethodCall3.kt");
        }

        @TestMetadata("letUseParameter.kt")
        public void testLetUseParameter() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letUseParameter.kt");
        }

        @TestMetadata("letWithBinaryExpression.kt")
        public void testLetWithBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letWithBinaryExpression.kt");
        }

        @TestMetadata("letWithMethodCall.kt")
        public void testLetWithMethodCall() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letWithMethodCall.kt");
        }

        @TestMetadata("letWithMultipleMethodCall.kt")
        public void testLetWithMultipleMethodCall() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letWithMultipleMethodCall.kt");
        }

        @TestMetadata("letWithParameter.kt")
        public void testLetWithParameter() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letWithParameter.kt");
        }

        @TestMetadata("letWithSimpleBinaryExpression.kt")
        public void testLetWithSimpleBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letWithSimpleBinaryExpression.kt");
        }

        @TestMetadata("letWithThisBinaryExpression.kt")
        public void testLetWithThisBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letWithThisBinaryExpression.kt");
        }

        @TestMetadata("letWithThisShortBinaryExpression.kt")
        public void testLetWithThisShortBinaryExpression() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/letWithThisShortBinaryExpression.kt");
        }

        @TestMetadata("multipleReceiver.kt")
        public void testMultipleReceiver() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/multipleReceiver.kt");
        }

        @TestMetadata("multipleReceiver2.kt")
        public void testMultipleReceiver2() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/multipleReceiver2.kt");
        }

        @TestMetadata("multipleReceiver3.kt")
        public void testMultipleReceiver3() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/multipleReceiver3.kt");
        }

        @TestMetadata("multipleUsages.kt")
        public void testMultipleUsages() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/multipleUsages.kt");
        }

        @TestMetadata("plusNullable.kt")
        public void testPlusNullable() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/plusNullable.kt");
        }

        @TestMetadata("receiverWithLambda.kt")
        public void testReceiverWithLambda() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/receiverWithLambda.kt");
        }

        @TestMetadata("receiverWithLambda2.kt")
        public void testReceiverWithLambda2() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/receiverWithLambda2.kt");
        }

        @TestMetadata("sameLets.kt")
        public void testSameLets() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/sameLets.kt");
        }

        @TestMetadata("smartCastInBody.kt")
        public void testSmartCastInBody() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/smartCastInBody.kt");
        }

        @TestMetadata("this.kt")
        public void testThis() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/this.kt");
        }

        @TestMetadata("thisShort.kt")
        public void testThisShort() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/thisShort.kt");
        }

        @TestMetadata("typeChecks.kt")
        public void testTypeChecks() throws Exception {
            runTest("idea/testData/intentions/replaceSingleLineLetIntention/typeChecks.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSizeCheckWithIsNotEmpty extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSizeCheckWithIsNotEmpty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/array.kt");
        }

        @TestMetadata("array2.kt")
        public void testArray2() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/array2.kt");
        }

        @TestMetadata("collection.kt")
        public void testCollection() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/collection.kt");
        }

        @TestMetadata("gt.kt")
        public void testGt() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/gt.kt");
        }

        @TestMetadata("gteq.kt")
        public void testGteq() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/gteq.kt");
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/list.kt");
        }

        @TestMetadata("list2.kt")
        public void testList2() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/list2.kt");
        }

        @TestMetadata("lt.kt")
        public void testLt() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/lt.kt");
        }

        @TestMetadata("lteq.kt")
        public void testLteq() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/lteq.kt");
        }

        @TestMetadata("map.kt")
        public void testMap() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/map.kt");
        }

        @TestMetadata("oppositeSign.kt")
        public void testOppositeSign() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/oppositeSign.kt");
        }

        @TestMetadata("oppositeSign2.kt")
        public void testOppositeSign2() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/oppositeSign2.kt");
        }

        @TestMetadata("primitiveArray.kt")
        public void testPrimitiveArray() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/primitiveArray.kt");
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/set.kt");
        }

        @TestMetadata("sizeCheck.kt")
        public void testSizeCheck() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/sizeCheck.kt");
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/string.kt");
        }

        @TestMetadata("string2.kt")
        public void testString2() throws Exception {
            runTest("idea/testData/intentions/replaceSizeCheckWithIsNotEmpty/string2.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSizeZeroCheckWithIsEmpty extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSizeZeroCheckWithIsEmpty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/array.kt");
        }

        @TestMetadata("array2.kt")
        public void testArray2() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/array2.kt");
        }

        @TestMetadata("gt.kt")
        public void testGt() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/gt.kt");
        }

        @TestMetadata("gteq.kt")
        public void testGteq() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/gteq.kt");
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/list.kt");
        }

        @TestMetadata("list2.kt")
        public void testList2() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/list2.kt");
        }

        @TestMetadata("lt.kt")
        public void testLt() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/lt.kt");
        }

        @TestMetadata("lteq.kt")
        public void testLteq() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/lteq.kt");
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/set.kt");
        }

        @TestMetadata("sizeCheck.kt")
        public void testSizeCheck() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/sizeCheck.kt");
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/string.kt");
        }

        @TestMetadata("string2.kt")
        public void testString2() throws Exception {
            runTest("idea/testData/intentions/replaceSizeZeroCheckWithIsEmpty/string2.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithDropLast")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithDropLast extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSubstringWithDropLast() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithDropLast"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("immutableProperty.kt")
        public void testImmutableProperty() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithDropLast/immutableProperty.kt");
        }

        @TestMetadata("methodCallReceiver.kt")
        public void testMethodCallReceiver() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithDropLast/methodCallReceiver.kt");
        }

        @TestMetadata("nonZeroFirstArgument.kt")
        public void testNonZeroFirstArgument() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithDropLast/nonZeroFirstArgument.kt");
        }

        @TestMetadata("replaceWithDropLast.kt")
        public void testReplaceWithDropLast() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithDropLast/replaceWithDropLast.kt");
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithDropLast/semicolon.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithIndexingOperation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithIndexingOperation extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSubstringWithIndexingOperation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithIndexingOperation"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("oneFirstTwoSecondArgument.kt")
        public void testOneFirstTwoSecondArgument() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithIndexingOperation/oneFirstTwoSecondArgument.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithIndexingOperation/simple.kt");
        }

        @TestMetadata("zeroFirstTenSecondArgument.kt")
        public void testZeroFirstTenSecondArgument() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithIndexingOperation/zeroFirstTenSecondArgument.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithSubstringAfter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithSubstringAfter extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSubstringWithSubstringAfter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithSubstringAfter"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("immutableProperty.kt")
        public void testImmutableProperty() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringAfter/immutableProperty.kt");
        }

        @TestMetadata("methodCallReceiver.kt")
        public void testMethodCallReceiver() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringAfter/methodCallReceiver.kt");
        }

        @TestMetadata("replaceWithSubstringAfter.kt")
        public void testReplaceWithSubstringAfter() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringAfter/replaceWithSubstringAfter.kt");
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringAfter/semicolon.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithSubstringBefore")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithSubstringBefore extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSubstringWithSubstringBefore() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithSubstringBefore"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("immutableProperty.kt")
        public void testImmutableProperty() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringBefore/immutableProperty.kt");
        }

        @TestMetadata("methodCallReceiver.kt")
        public void testMethodCallReceiver() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringBefore/methodCallReceiver.kt");
        }

        @TestMetadata("nonZeroFirstArgument.kt")
        public void testNonZeroFirstArgument() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringBefore/nonZeroFirstArgument.kt");
        }

        @TestMetadata("replaceWithSubstringBefore.kt")
        public void testReplaceWithSubstringBefore() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringBefore/replaceWithSubstringBefore.kt");
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithSubstringBefore/semicolon.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceSubstringWithTake")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceSubstringWithTake extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceSubstringWithTake() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceSubstringWithTake"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constantAsFirstArgument.kt")
        public void testConstantAsFirstArgument() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithTake/constantAsFirstArgument.kt");
        }

        @TestMetadata("expressionAsFirstArgument.kt")
        public void testExpressionAsFirstArgument() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithTake/expressionAsFirstArgument.kt");
        }

        @TestMetadata("nonZeroFirstArgument.kt")
        public void testNonZeroFirstArgument() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithTake/nonZeroFirstArgument.kt");
        }

        @TestMetadata("replaceWithTake.kt")
        public void testReplaceWithTake() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithTake/replaceWithTake.kt");
        }

        @TestMetadata("semicolon.kt")
        public void testSemicolon() throws Exception {
            runTest("idea/testData/intentions/replaceSubstringWithTake/semicolon.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceUnderscoreWithParameterName")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceUnderscoreWithParameterName extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceUnderscoreWithParameterName() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceUnderscoreWithParameterName"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymous.kt")
        public void testAnonymous() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/anonymous.kt");
        }

        @TestMetadata("conflict.kt")
        public void testConflict() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/conflict.kt");
        }

        @TestMetadata("destructuringDeclaration.kt")
        public void testDestructuringDeclaration() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/destructuringDeclaration.kt");
        }

        @TestMetadata("for.kt")
        public void testFor() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/for.kt");
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/lambda.kt");
        }

        @TestMetadata("lambdaConflict.kt")
        public void testLambdaConflict() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/lambdaConflict.kt");
        }

        @TestMetadata("lambdaNoNames.kt")
        public void testLambdaNoNames() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/lambdaNoNames.kt");
        }

        @TestMetadata("map.kt")
        public void testMap() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/map.kt");
        }

        @TestMetadata("triple.kt")
        public void testTriple() throws Exception {
            runTest("idea/testData/intentions/replaceUnderscoreWithParameterName/triple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceUntilWithRangeTo")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceUntilWithRangeTo extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceUntilWithRangeTo() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceUntilWithRangeTo"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/replaceUntilWithRangeTo/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/replaceWithOrdinaryAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceWithOrdinaryAssignment extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceWithOrdinaryAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/replaceWithOrdinaryAssignment"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("complexRightExpression.kt")
        public void testComplexRightExpression() throws Exception {
            runTest("idea/testData/intentions/replaceWithOrdinaryAssignment/complexRightExpression.kt");
        }

        @TestMetadata("nonAssignmentExpression.kt")
        public void testNonAssignmentExpression() throws Exception {
            runTest("idea/testData/intentions/replaceWithOrdinaryAssignment/nonAssignmentExpression.kt");
        }

        @TestMetadata("nonAugmentedAssign.kt")
        public void testNonAugmentedAssign() throws Exception {
            runTest("idea/testData/intentions/replaceWithOrdinaryAssignment/nonAugmentedAssign.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/replaceWithOrdinaryAssignment/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/samConversionToAnonymousObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SamConversionToAnonymousObject extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSamConversionToAnonymousObject() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/samConversionToAnonymousObject"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("labeledReturn.kt")
        public void testLabeledReturn() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/labeledReturn.kt");
        }

        @TestMetadata("notJavaInterface.kt")
        public void testNotJavaInterface() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/notJavaInterface.kt");
        }

        @TestMetadata("notSam.kt")
        public void testNotSam() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/notSam.kt");
        }

        @TestMetadata("parameterError.kt")
        public void testParameterError() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/parameterError.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/simple.kt");
        }

        @TestMetadata("simple2.kt")
        public void testSimple2() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/simple2.kt");
        }

        @TestMetadata("simple3.kt")
        public void testSimple3() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/simple3.kt");
        }

        @TestMetadata("usedSameFunction.kt")
        public void testUsedSameFunction() throws Exception {
            runTest("idea/testData/intentions/samConversionToAnonymousObject/usedSameFunction.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/simplifyBooleanWithConstants")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SimplifyBooleanWithConstants extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSimplifyBooleanWithConstants() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/simplifyBooleanWithConstants"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assert.kt")
        public void testAssert() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/assert.kt");
        }

        @TestMetadata("deeplyParenthesized.kt")
        public void testDeeplyParenthesized() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/deeplyParenthesized.kt");
        }

        @TestMetadata("equalsConjunction.kt")
        public void testEqualsConjunction() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/equalsConjunction.kt");
        }

        @TestMetadata("equalsDisjunction.kt")
        public void testEqualsDisjunction() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/equalsDisjunction.kt");
        }

        @TestMetadata("equalsFalse.kt")
        public void testEqualsFalse() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/equalsFalse.kt");
        }

        @TestMetadata("equalsTrue.kt")
        public void testEqualsTrue() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/equalsTrue.kt");
        }

        @TestMetadata("equalsTrueOrFalse.kt")
        public void testEqualsTrueOrFalse() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/equalsTrueOrFalse.kt");
        }

        @TestMetadata("flexibleBoolean.kt")
        public void testFlexibleBoolean() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/flexibleBoolean.kt");
        }

        @TestMetadata("inapplicableNoConstants.kt")
        public void testInapplicableNoConstants() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableNoConstants.kt");
        }

        @TestMetadata("inapplicableNotBinary.kt")
        public void testInapplicableNotBinary() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableNotBinary.kt");
        }

        @TestMetadata("inapplicableUsesVals.kt")
        public void testInapplicableUsesVals() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableUsesVals.kt");
        }

        @TestMetadata("inapplicableUsesVals2.kt")
        public void testInapplicableUsesVals2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableUsesVals2.kt");
        }

        @TestMetadata("inapplicableUsesVals3.kt")
        public void testInapplicableUsesVals3() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/inapplicableUsesVals3.kt");
        }

        @TestMetadata("notEqualsFalse.kt")
        public void testNotEqualsFalse() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/notEqualsFalse.kt");
        }

        @TestMetadata("notEqualsTrue.kt")
        public void testNotEqualsTrue() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/notEqualsTrue.kt");
        }

        @TestMetadata("notReduceableBinary.kt")
        public void testNotReduceableBinary() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/notReduceableBinary.kt");
        }

        @TestMetadata("notReduceableBinary2.kt")
        public void testNotReduceableBinary2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/notReduceableBinary2.kt");
        }

        @TestMetadata("nullableBoolean.kt")
        public void testNullableBoolean() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/nullableBoolean.kt");
        }

        @TestMetadata("nullableComplex.kt")
        public void testNullableComplex() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/nullableComplex.kt");
        }

        @TestMetadata("nullableComplex2.kt")
        public void testNullableComplex2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/nullableComplex2.kt");
        }

        @TestMetadata("reduceableBinary.kt")
        public void testReduceableBinary() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinary.kt");
        }

        @TestMetadata("reduceableBinary2.kt")
        public void testReduceableBinary2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinary2.kt");
        }

        @TestMetadata("reduceableBinary3.kt")
        public void testReduceableBinary3() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinary3.kt");
        }

        @TestMetadata("reduceableBinaryWithParenthese.kt")
        public void testReduceableBinaryWithParenthese() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/reduceableBinaryWithParenthese.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simple.kt");
        }

        @TestMetadata("simpleWithMoreBinaries.kt")
        public void testSimpleWithMoreBinaries() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinaries.kt");
        }

        @TestMetadata("simpleWithMoreBinaries2.kt")
        public void testSimpleWithMoreBinaries2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinaries2.kt");
        }

        @TestMetadata("simpleWithMoreBinaries3.kt")
        public void testSimpleWithMoreBinaries3() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinaries3.kt");
        }

        @TestMetadata("simpleWithMoreBinariesAndParentheses.kt")
        public void testSimpleWithMoreBinariesAndParentheses() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinariesAndParentheses.kt");
        }

        @TestMetadata("simpleWithMoreBinariesAndParentheses2.kt")
        public void testSimpleWithMoreBinariesAndParentheses2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinariesAndParentheses2.kt");
        }

        @TestMetadata("simpleWithMoreBinariesAndParentheses3.kt")
        public void testSimpleWithMoreBinariesAndParentheses3() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithMoreBinariesAndParentheses3.kt");
        }

        @TestMetadata("simpleWithNonsensical2.kt")
        public void testSimpleWithNonsensical2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithNonsensical2.kt");
        }

        @TestMetadata("simpleWithParentheses.kt")
        public void testSimpleWithParentheses() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithParentheses.kt");
        }

        @TestMetadata("simpleWithParentheses2.kt")
        public void testSimpleWithParentheses2() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/simpleWithParentheses2.kt");
        }

        @TestMetadata("withAnnotation.kt")
        public void testWithAnnotation() throws Exception {
            runTest("idea/testData/intentions/simplifyBooleanWithConstants/withAnnotation.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/specifyExplicitLambdaSignature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecifyExplicitLambdaSignature extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSpecifyExplicitLambdaSignature() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/specifyExplicitLambdaSignature"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymous.kt")
        public void testAnonymous() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/anonymous.kt");
        }

        @TestMetadata("coercionToUnit.kt")
        public void testCoercionToUnit() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/coercionToUnit.kt");
        }

        @TestMetadata("cursorOnRightBrace.kt")
        public void testCursorOnRightBrace() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/cursorOnRightBrace.kt");
        }

        @TestMetadata("delegate.kt")
        public void testDelegate() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/delegate.kt");
        }

        @TestMetadata("destructuring.kt")
        public void testDestructuring() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/destructuring.kt");
        }

        @TestMetadata("emptyParamListWithBrackets.kt")
        public void testEmptyParamListWithBrackets() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithBrackets.kt");
        }

        @TestMetadata("emptyParamListWithIt.kt")
        public void testEmptyParamListWithIt() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithIt.kt");
        }

        @TestMetadata("emptyParamListWithWhiteSpace.kt")
        public void testEmptyParamListWithWhiteSpace() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithWhiteSpace.kt");
        }

        @TestMetadata("emptyParamListWithoutItWithArrow.kt")
        public void testEmptyParamListWithoutItWithArrow() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/emptyParamListWithoutItWithArrow.kt");
        }

        @TestMetadata("lambdaWithLambdaAsParam.kt")
        public void testLambdaWithLambdaAsParam() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/lambdaWithLambdaAsParam.kt");
        }

        @TestMetadata("manyNewlines.kt")
        public void testManyNewlines() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/manyNewlines.kt");
        }

        @TestMetadata("multipleParam.kt")
        public void testMultipleParam() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/multipleParam.kt");
        }

        @TestMetadata("noParameters.kt")
        public void testNoParameters() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/noParameters.kt");
        }

        @TestMetadata("shortenReferencesForParams.kt")
        public void testShortenReferencesForParams() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/shortenReferencesForParams.kt");
        }

        @TestMetadata("singleParam.kt")
        public void testSingleParam() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/singleParam.kt");
        }

        @TestMetadata("typesAlreadyExplicit.kt")
        public void testTypesAlreadyExplicit() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/typesAlreadyExplicit.kt");
        }

        @TestMetadata("typesNotInferable.kt")
        public void testTypesNotInferable() throws Exception {
            runTest("idea/testData/intentions/specifyExplicitLambdaSignature/typesNotInferable.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/specifyTypeExplicitly")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecifyTypeExplicitly extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSpecifyTypeExplicitly() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/specifyTypeExplicitly"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObject.kt")
        public void testAnonymousObject() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/anonymousObject.kt");
        }

        @TestMetadata("badCaretPosition.kt")
        public void testBadCaretPosition() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/badCaretPosition.kt");
        }

        @TestMetadata("classNameClashing.kt")
        public void testClassNameClashing() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/classNameClashing.kt");
        }

        @TestMetadata("constructor.kt")
        public void testConstructor() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/constructor.kt");
        }

        @TestMetadata("destructuringInLambda.kt")
        public void testDestructuringInLambda() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/destructuringInLambda.kt");
        }

        @TestMetadata("enumType.kt")
        public void testEnumType() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/enumType.kt");
        }

        @TestMetadata("forAsExpression.kt")
        public void testForAsExpression() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/forAsExpression.kt");
        }

        @TestMetadata("functionType.kt")
        public void testFunctionType() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/functionType.kt");
        }

        @TestMetadata("genericClass.kt")
        public void testGenericClass() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/genericClass.kt");
        }

        @TestMetadata("genericClassWithTypeParameters.kt")
        public void testGenericClassWithTypeParameters() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/genericClassWithTypeParameters.kt");
        }

        @TestMetadata("genericClassWithTypeParameters2.kt")
        public void testGenericClassWithTypeParameters2() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/genericClassWithTypeParameters2.kt");
        }

        @TestMetadata("genericFunction.kt")
        public void testGenericFunction() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/genericFunction.kt");
        }

        @TestMetadata("innerTypeParameter.kt")
        public void testInnerTypeParameter() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/innerTypeParameter.kt");
        }

        @TestMetadata("innerTypeParameter2.kt")
        public void testInnerTypeParameter2() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/innerTypeParameter2.kt");
        }

        @TestMetadata("lambdaParam.kt")
        public void testLambdaParam() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/lambdaParam.kt");
        }

        @TestMetadata("localClass.kt")
        public void testLocalClass() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/localClass.kt");
        }

        @TestMetadata("localClassInSecondTypeParameter.kt")
        public void testLocalClassInSecondTypeParameter() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/localClassInSecondTypeParameter.kt");
        }

        @TestMetadata("localClassInSecondTypeParameter2.kt")
        public void testLocalClassInSecondTypeParameter2() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/localClassInSecondTypeParameter2.kt");
        }

        @TestMetadata("localClassInSecondTypeParameter3.kt")
        public void testLocalClassInSecondTypeParameter3() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/localClassInSecondTypeParameter3.kt");
        }

        @TestMetadata("localClassInTypeParameter.kt")
        public void testLocalClassInTypeParameter() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/localClassInTypeParameter.kt");
        }

        @TestMetadata("loopParameter.kt")
        public void testLoopParameter() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/loopParameter.kt");
        }

        @TestMetadata("outClass.kt")
        public void testOutClass() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/outClass.kt");
        }

        @TestMetadata("outClass2.kt")
        public void testOutClass2() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/outClass2.kt");
        }

        @TestMetadata("outClass3.kt")
        public void testOutClass3() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/outClass3.kt");
        }

        @TestMetadata("overriddenAsNull.kt")
        public void testOverriddenAsNull() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/overriddenAsNull.kt");
        }

        @TestMetadata("overrideNotNullFunction.kt")
        public void testOverrideNotNullFunction() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/overrideNotNullFunction.kt");
        }

        @TestMetadata("overrideNotNullProperty.kt")
        public void testOverrideNotNullProperty() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/overrideNotNullProperty.kt");
        }

        @TestMetadata("overrideNullableFunction.kt")
        public void testOverrideNullableFunction() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/overrideNullableFunction.kt");
        }

        @TestMetadata("overrideNullableProperty.kt")
        public void testOverrideNullableProperty() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/overrideNullableProperty.kt");
        }

        @TestMetadata("propertyTypeFromGetter.kt")
        public void testPropertyTypeFromGetter() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/propertyTypeFromGetter.kt");
        }

        @TestMetadata("publicMember.kt")
        public void testPublicMember() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/publicMember.kt");
        }

        @TestMetadata("stringRedefined.kt")
        public void testStringRedefined() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/stringRedefined.kt");
        }

        @TestMetadata("typeAlreadyProvided.kt")
        public void testTypeAlreadyProvided() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/typeAlreadyProvided.kt");
        }

        @TestMetadata("unitType.kt")
        public void testUnitType() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitly/unitType.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecifyTypeExplicitlyInDestructuringAssignment extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSpecifyTypeExplicitlyInDestructuringAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment/in.kt");
        }

        @TestMetadata("lambda.kt")
        public void testLambda() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment/lambda.kt");
        }

        @TestMetadata("lambdaHasSignature.kt")
        public void testLambdaHasSignature() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment/lambdaHasSignature.kt");
        }

        @TestMetadata("variableHasAllTypes.kt")
        public void testVariableHasAllTypes() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment/variableHasAllTypes.kt");
        }

        @TestMetadata("variableHasNoTypes.kt")
        public void testVariableHasNoTypes() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment/variableHasNoTypes.kt");
        }

        @TestMetadata("variableHasTypes.kt")
        public void testVariableHasTypes() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment/variableHasTypes.kt");
        }

        @TestMetadata("variableHasUnderscore.kt")
        public void testVariableHasUnderscore() throws Exception {
            runTest("idea/testData/intentions/specifyTypeExplicitlyInDestructuringAssignment/variableHasUnderscore.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/splitIf")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SplitIf extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSplitIf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/splitIf"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("and.kt")
        public void testAnd() throws Exception {
            runTest("idea/testData/intentions/splitIf/and.kt");
        }

        @TestMetadata("caretOnIf.kt")
        public void testCaretOnIf() throws Exception {
            runTest("idea/testData/intentions/splitIf/caretOnIf.kt");
        }

        @TestMetadata("ifAndOr.kt")
        public void testIfAndOr() throws Exception {
            runTest("idea/testData/intentions/splitIf/ifAndOr.kt");
        }

        @TestMetadata("ifAndOrWithBraces.kt")
        public void testIfAndOrWithBraces() throws Exception {
            runTest("idea/testData/intentions/splitIf/ifAndOrWithBraces.kt");
        }

        @TestMetadata("ifAndWithBraces.kt")
        public void testIfAndWithBraces() throws Exception {
            runTest("idea/testData/intentions/splitIf/ifAndWithBraces.kt");
        }

        @TestMetadata("ifOrReturn.kt")
        public void testIfOrReturn() throws Exception {
            runTest("idea/testData/intentions/splitIf/ifOrReturn.kt");
        }

        @TestMetadata("ifWithElse.kt")
        public void testIfWithElse() throws Exception {
            runTest("idea/testData/intentions/splitIf/ifWithElse.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("idea/testData/intentions/splitIf/localFunction.kt");
        }

        @TestMetadata("nestedIf.kt")
        public void testNestedIf() throws Exception {
            runTest("idea/testData/intentions/splitIf/nestedIf.kt");
        }

        @TestMetadata("nestedIfNotApplicable.kt")
        public void testNestedIfNotApplicable() throws Exception {
            runTest("idea/testData/intentions/splitIf/nestedIfNotApplicable.kt");
        }

        @TestMetadata("nestedIfOutside.kt")
        public void testNestedIfOutside() throws Exception {
            runTest("idea/testData/intentions/splitIf/nestedIfOutside.kt");
        }

        @TestMetadata("nestedInside.kt")
        public void testNestedInside() throws Exception {
            runTest("idea/testData/intentions/splitIf/nestedInside.kt");
        }

        @TestMetadata("notIf.kt")
        public void testNotIf() throws Exception {
            runTest("idea/testData/intentions/splitIf/notIf.kt");
        }

        @TestMetadata("onIfWithOr.kt")
        public void testOnIfWithOr() throws Exception {
            runTest("idea/testData/intentions/splitIf/onIfWithOr.kt");
        }

        @TestMetadata("operatorAsFunctionParam.kt")
        public void testOperatorAsFunctionParam() throws Exception {
            runTest("idea/testData/intentions/splitIf/operatorAsFunctionParam.kt");
        }

        @TestMetadata("operatorOutsideIf.kt")
        public void testOperatorOutsideIf() throws Exception {
            runTest("idea/testData/intentions/splitIf/operatorOutsideIf.kt");
        }

        @TestMetadata("orAnd.kt")
        public void testOrAnd() throws Exception {
            runTest("idea/testData/intentions/splitIf/orAnd.kt");
        }

        @TestMetadata("orWithBraces.kt")
        public void testOrWithBraces() throws Exception {
            runTest("idea/testData/intentions/splitIf/orWithBraces.kt");
        }

        @TestMetadata("twoOperatorsFirst.kt")
        public void testTwoOperatorsFirst() throws Exception {
            runTest("idea/testData/intentions/splitIf/twoOperatorsFirst.kt");
        }

        @TestMetadata("twoOperatorsSecond.kt")
        public void testTwoOperatorsSecond() throws Exception {
            runTest("idea/testData/intentions/splitIf/twoOperatorsSecond.kt");
        }

        @TestMetadata("withNotOperator.kt")
        public void testWithNotOperator() throws Exception {
            runTest("idea/testData/intentions/splitIf/withNotOperator.kt");
        }

        @TestMetadata("withNotOperatorGood.kt")
        public void testWithNotOperatorGood() throws Exception {
            runTest("idea/testData/intentions/splitIf/withNotOperatorGood.kt");
        }

        @TestMetadata("withOR.kt")
        public void testWithOR() throws Exception {
            runTest("idea/testData/intentions/splitIf/withOR.kt");
        }

        @TestMetadata("withORElse.kt")
        public void testWithORElse() throws Exception {
            runTest("idea/testData/intentions/splitIf/withORElse.kt");
        }

        @TestMetadata("wrongCaretLocation.kt")
        public void testWrongCaretLocation() throws Exception {
            runTest("idea/testData/intentions/splitIf/wrongCaretLocation.kt");
        }

        @TestMetadata("idea/testData/intentions/splitIf/keepComments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KeepComments extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInKeepComments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/splitIf/keepComments"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ifOrReturn.kt")
            public void testIfOrReturn() throws Exception {
                runTest("idea/testData/intentions/splitIf/keepComments/ifOrReturn.kt");
            }

            @TestMetadata("twoOperators.kt")
            public void testTwoOperators() throws Exception {
                runTest("idea/testData/intentions/splitIf/keepComments/twoOperators.kt");
            }

            @TestMetadata("withAnd.kt")
            public void testWithAnd() throws Exception {
                runTest("idea/testData/intentions/splitIf/keepComments/withAnd.kt");
            }

            @TestMetadata("withOR.kt")
            public void testWithOR() throws Exception {
                runTest("idea/testData/intentions/splitIf/keepComments/withOR.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/swapBinaryExpression")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SwapBinaryExpression extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSwapBinaryExpression() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/swapBinaryExpression"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/assignment.kt");
        }

        @TestMetadata("conjunction.kt")
        public void testConjunction() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/conjunction.kt");
        }

        @TestMetadata("conjunctionLiteral.kt")
        public void testConjunctionLiteral() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/conjunctionLiteral.kt");
        }

        @TestMetadata("disjunction.kt")
        public void testDisjunction() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/disjunction.kt");
        }

        @TestMetadata("disjunctionLiteral.kt")
        public void testDisjunctionLiteral() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/disjunctionLiteral.kt");
        }

        @TestMetadata("divide.kt")
        public void testDivide() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/divide.kt");
        }

        @TestMetadata("divideAssign.kt")
        public void testDivideAssign() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/divideAssign.kt");
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/equals.kt");
        }

        @TestMetadata("greaterThan.kt")
        public void testGreaterThan() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/greaterThan.kt");
        }

        @TestMetadata("greaterThanEquals.kt")
        public void testGreaterThanEquals() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/greaterThanEquals.kt");
        }

        @TestMetadata("identityEquals.kt")
        public void testIdentityEquals() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/identityEquals.kt");
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/in.kt");
        }

        @TestMetadata("infixFunction.kt")
        public void testInfixFunction() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/infixFunction.kt");
        }

        @TestMetadata("is.kt")
        public void testIs() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/is.kt");
        }

        @TestMetadata("lessThan.kt")
        public void testLessThan() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/lessThan.kt");
        }

        @TestMetadata("lessThanEquals.kt")
        public void testLessThanEquals() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/lessThanEquals.kt");
        }

        @TestMetadata("minus.kt")
        public void testMinus() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/minus.kt");
        }

        @TestMetadata("minusAssign.kt")
        public void testMinusAssign() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/minusAssign.kt");
        }

        @TestMetadata("multipleOperands.kt")
        public void testMultipleOperands() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multipleOperands.kt");
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence.kt")
        public void testMultipleOperandsWithDifferentPrecedence() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence.kt");
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence2.kt")
        public void testMultipleOperandsWithDifferentPrecedence2() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence2.kt");
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence3.kt")
        public void testMultipleOperandsWithDifferentPrecedence3() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence3.kt");
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence4.kt")
        public void testMultipleOperandsWithDifferentPrecedence4() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence4.kt");
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence5.kt")
        public void testMultipleOperandsWithDifferentPrecedence5() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence5.kt");
        }

        @TestMetadata("multipleOperandsWithDifferentPrecedence6.kt")
        public void testMultipleOperandsWithDifferentPrecedence6() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multipleOperandsWithDifferentPrecedence6.kt");
        }

        @TestMetadata("multiply.kt")
        public void testMultiply() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multiply.kt");
        }

        @TestMetadata("multiplyAssign.kt")
        public void testMultiplyAssign() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/multiplyAssign.kt");
        }

        @TestMetadata("nonBinaryExpr.kt")
        public void testNonBinaryExpr() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/nonBinaryExpr.kt");
        }

        @TestMetadata("notEquals.kt")
        public void testNotEquals() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/notEquals.kt");
        }

        @TestMetadata("notIdentityEquals.kt")
        public void testNotIdentityEquals() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/notIdentityEquals.kt");
        }

        @TestMetadata("notIn.kt")
        public void testNotIn() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/notIn.kt");
        }

        @TestMetadata("notIs.kt")
        public void testNotIs() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/notIs.kt");
        }

        @TestMetadata("nullOperand.kt")
        public void testNullOperand() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/nullOperand.kt");
        }

        @TestMetadata("plus.kt")
        public void testPlus() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/plus.kt");
        }

        @TestMetadata("plusAssign.kt")
        public void testPlusAssign() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/plusAssign.kt");
        }

        @TestMetadata("plusInt.kt")
        public void testPlusInt() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/plusInt.kt");
        }

        @TestMetadata("plusMinus.kt")
        public void testPlusMinus() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/plusMinus.kt");
        }

        @TestMetadata("rangeTo.kt")
        public void testRangeTo() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/rangeTo.kt");
        }

        @TestMetadata("remainder.kt")
        public void testRemainder() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/remainder.kt");
        }

        @TestMetadata("remainderAssign.kt")
        public void testRemainderAssign() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/remainderAssign.kt");
        }

        @TestMetadata("times.kt")
        public void testTimes() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/times.kt");
        }

        @TestMetadata("timesAssign.kt")
        public void testTimesAssign() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/timesAssign.kt");
        }

        @TestMetadata("xor.kt")
        public void testXor() throws Exception {
            runTest("idea/testData/intentions/swapBinaryExpression/xor.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/swapStringEqualsIgnoreCase")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SwapStringEqualsIgnoreCase extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSwapStringEqualsIgnoreCase() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/swapStringEqualsIgnoreCase"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("equals.kt")
        public void testEquals() throws Exception {
            runTest("idea/testData/intentions/swapStringEqualsIgnoreCase/equals.kt");
        }

        @TestMetadata("equalsIgnoreCase.kt")
        public void testEqualsIgnoreCase() throws Exception {
            runTest("idea/testData/intentions/swapStringEqualsIgnoreCase/equalsIgnoreCase.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/toInfixCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToInfixCall extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInToInfixCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/toInfixCall"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("binaryExpressionArgument.kt")
        public void testBinaryExpressionArgument() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/binaryExpressionArgument.kt");
        }

        @TestMetadata("caretInsideCalleeExpr.kt")
        public void testCaretInsideCalleeExpr() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/caretInsideCalleeExpr.kt");
        }

        @TestMetadata("caretInsideReceiverExpr.kt")
        public void testCaretInsideReceiverExpr() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/caretInsideReceiverExpr.kt");
        }

        @TestMetadata("doubleFunctionCall.kt")
        public void testDoubleFunctionCall() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/doubleFunctionCall.kt");
        }

        @TestMetadata("doubleFunctionCallWithoutParentheses.kt")
        public void testDoubleFunctionCallWithoutParentheses() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/doubleFunctionCallWithoutParentheses.kt");
        }

        @TestMetadata("functionLiteralArgument.kt")
        public void testFunctionLiteralArgument() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/functionLiteralArgument.kt");
        }

        @TestMetadata("functionSafeCall.kt")
        public void testFunctionSafeCall() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/functionSafeCall.kt");
        }

        @TestMetadata("inapplicableCaretPosition.kt")
        public void testInapplicableCaretPosition() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/inapplicableCaretPosition.kt");
        }

        @TestMetadata("multipleArguments.kt")
        public void testMultipleArguments() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/multipleArguments.kt");
        }

        @TestMetadata("namedArgument.kt")
        public void testNamedArgument() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/namedArgument.kt");
        }

        @TestMetadata("noExplicitReceiver.kt")
        public void testNoExplicitReceiver() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/noExplicitReceiver.kt");
        }

        @TestMetadata("notInfix.kt")
        public void testNotInfix() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/notInfix.kt");
        }

        @TestMetadata("nullAssertedReceiver.kt")
        public void testNullAssertedReceiver() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/nullAssertedReceiver.kt");
        }

        @TestMetadata("packageFunctionCall.kt")
        public void testPackageFunctionCall() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/packageFunctionCall.kt");
        }

        @TestMetadata("propertyAccess.kt")
        public void testPropertyAccess() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/propertyAccess.kt");
        }

        @TestMetadata("secondParameterLabeled.kt")
        public void testSecondParameterLabeled() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/secondParameterLabeled.kt");
        }

        @TestMetadata("simpleArgumentAndFunctionLiteralArgument.kt")
        public void testSimpleArgumentAndFunctionLiteralArgument() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/simpleArgumentAndFunctionLiteralArgument.kt");
        }

        @TestMetadata("simpleMethodCall.kt")
        public void testSimpleMethodCall() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/simpleMethodCall.kt");
        }

        @TestMetadata("singlePackageFunctionCall.kt")
        public void testSinglePackageFunctionCall() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/singlePackageFunctionCall.kt");
        }

        @TestMetadata("zeroArguments.kt")
        public void testZeroArguments() throws Exception {
            runTest("idea/testData/intentions/toInfixCall/zeroArguments.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/toOrdinaryStringLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToOrdinaryStringLiteral extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInToOrdinaryStringLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/toOrdinaryStringLiteral"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("caret1.kt")
        public void testCaret1() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret1.kt");
        }

        @TestMetadata("caret2.kt")
        public void testCaret2() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret2.kt");
        }

        @TestMetadata("caret3.kt")
        public void testCaret3() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret3.kt");
        }

        @TestMetadata("caret4.kt")
        public void testCaret4() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret4.kt");
        }

        @TestMetadata("caret5.kt")
        public void testCaret5() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret5.kt");
        }

        @TestMetadata("caret6.kt")
        public void testCaret6() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret6.kt");
        }

        @TestMetadata("caret7.kt")
        public void testCaret7() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret7.kt");
        }

        @TestMetadata("caret8.kt")
        public void testCaret8() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret8.kt");
        }

        @TestMetadata("caret9.kt")
        public void testCaret9() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/caret9.kt");
        }

        @TestMetadata("lineBreakInExpression.kt")
        public void testLineBreakInExpression() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/lineBreakInExpression.kt");
        }

        @TestMetadata("quotesAndSlashes.kt")
        public void testQuotesAndSlashes() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/quotesAndSlashes.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/toOrdinaryStringLiteral/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/toRawStringLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToRawStringLiteral extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("3quotes.kt")
        public void test3quotes() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/3quotes.kt");
        }

        public void testAllFilesPresentInToRawStringLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/toRawStringLiteral"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyRaw.kt")
        public void testAlreadyRaw() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/alreadyRaw.kt");
        }

        @TestMetadata("caret1.kt")
        public void testCaret1() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/caret1.kt");
        }

        @TestMetadata("caret2.kt")
        public void testCaret2() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/caret2.kt");
        }

        @TestMetadata("caret3.kt")
        public void testCaret3() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/caret3.kt");
        }

        @TestMetadata("caret4.kt")
        public void testCaret4() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/caret4.kt");
        }

        @TestMetadata("caret5.kt")
        public void testCaret5() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/caret5.kt");
        }

        @TestMetadata("dollar.kt")
        public void testDollar() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/dollar.kt");
        }

        @TestMetadata("dollar2.kt")
        public void testDollar2() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/dollar2.kt");
        }

        @TestMetadata("quotesAndSlashes.kt")
        public void testQuotesAndSlashes() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/quotesAndSlashes.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/simple.kt");
        }

        @TestMetadata("specialChar.kt")
        public void testSpecialChar() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/specialChar.kt");
        }

        @TestMetadata("tabCharacter.kt")
        public void testTabCharacter() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/tabCharacter.kt");
        }

        @TestMetadata("trailingSpace.kt")
        public void testTrailingSpace() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/trailingSpace.kt");
        }

        @TestMetadata("trailingSpace2.kt")
        public void testTrailingSpace2() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/trailingSpace2.kt");
        }

        @TestMetadata("trailingSpace3.kt")
        public void testTrailingSpace3() throws Exception {
            runTest("idea/testData/intentions/toRawStringLiteral/trailingSpace3.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/underscoresInNumericLiteral")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnderscoresInNumericLiteral extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnderscoresInNumericLiteral() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/underscoresInNumericLiteral"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AddUnderscores extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAddUnderscores() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("binaries.kt")
            public void testBinaries() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/binaries.kt");
            }

            @TestMetadata("double.kt")
            public void testDouble() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/double.kt");
            }

            @TestMetadata("float.kt")
            public void testFloat() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/float.kt");
            }

            @TestMetadata("hexadecimals.kt")
            public void testHexadecimals() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/hexadecimals.kt");
            }

            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/int.kt");
            }

            @TestMetadata("int2.kt")
            public void testInt2() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/int2.kt");
            }

            @TestMetadata("long.kt")
            public void testLong() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/long.kt");
            }

            @TestMetadata("uInt.kt")
            public void testUInt() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/addUnderscores/uInt.kt");
            }
        }

        @TestMetadata("idea/testData/intentions/underscoresInNumericLiteral/removeUnderscores")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RemoveUnderscores extends AbstractIntentionTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRemoveUnderscores() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/underscoresInNumericLiteral/removeUnderscores"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
            }

            @TestMetadata("int.kt")
            public void testInt() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/removeUnderscores/int.kt");
            }

            @TestMetadata("noUnderscores.kt")
            public void testNoUnderscores() throws Exception {
                runTest("idea/testData/intentions/underscoresInNumericLiteral/removeUnderscores/noUnderscores.kt");
            }
        }
    }

    @TestMetadata("idea/testData/intentions/usePropertyAccessSyntax")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UsePropertyAccessSyntax extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("accessThroughKotlinClassInstance.kt")
        public void testAccessThroughKotlinClassInstance() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/accessThroughKotlinClassInstance.kt");
        }

        @TestMetadata("accessThroughKotlinClassInstanceWithOverride.kt")
        public void testAccessThroughKotlinClassInstanceWithOverride() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/accessThroughKotlinClassInstanceWithOverride.kt");
        }

        public void testAllFilesPresentInUsePropertyAccessSyntax() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/usePropertyAccessSyntax"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conflict1.kt")
        public void testConflict1() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/conflict1.kt");
        }

        @TestMetadata("conflict2.kt")
        public void testConflict2() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/conflict2.kt");
        }

        @TestMetadata("genericClassMethod.kt")
        public void testGenericClassMethod() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/genericClassMethod.kt");
        }

        @TestMetadata("get.kt")
        public void testGet() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/get.kt");
        }

        @TestMetadata("getImplicitReceiver.kt")
        public void testGetImplicitReceiver() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/getImplicitReceiver.kt");
        }

        @TestMetadata("getReservedWord1.kt")
        public void testGetReservedWord1() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/getReservedWord1.kt");
        }

        @TestMetadata("getReservedWord2.kt")
        public void testGetReservedWord2() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/getReservedWord2.kt");
        }

        @TestMetadata("getSafeCall.kt")
        public void testGetSafeCall() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/getSafeCall.kt");
        }

        @TestMetadata("isGet.kt")
        public void testIsGet() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/isGet.kt");
        }

        @TestMetadata("isSet.kt")
        public void testIsSet() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/isSet.kt");
        }

        @TestMetadata("nonVoidSetter1.kt")
        public void testNonVoidSetter1() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/nonVoidSetter1.kt");
        }

        @TestMetadata("nonVoidSetter2.kt")
        public void testNonVoidSetter2() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/nonVoidSetter2.kt");
        }

        @TestMetadata("propertyTypeIsMoreSpecific1.kt")
        public void testPropertyTypeIsMoreSpecific1() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/propertyTypeIsMoreSpecific1.kt");
        }

        @TestMetadata("propertyTypeIsMoreSpecific2.kt")
        public void testPropertyTypeIsMoreSpecific2() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/propertyTypeIsMoreSpecific2.kt");
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/set.kt");
        }

        @TestMetadata("setAsExpressionBody.kt")
        public void testSetAsExpressionBody() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/setAsExpressionBody.kt");
        }

        @TestMetadata("setAsExpressionBodyProperty.kt")
        public void testSetAsExpressionBodyProperty() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/setAsExpressionBodyProperty.kt");
        }

        @TestMetadata("setAsExpressionBodyUnqualified.kt")
        public void testSetAsExpressionBodyUnqualified() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/setAsExpressionBodyUnqualified.kt");
        }

        @TestMetadata("setImplicitReceiver.kt")
        public void testSetImplicitReceiver() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/setImplicitReceiver.kt");
        }

        @TestMetadata("setReservedWord1.kt")
        public void testSetReservedWord1() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/setReservedWord1.kt");
        }

        @TestMetadata("setReservedWord2.kt")
        public void testSetReservedWord2() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/setReservedWord2.kt");
        }

        @TestMetadata("setSafeCall.kt")
        public void testSetSafeCall() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/setSafeCall.kt");
        }

        @TestMetadata("smartCast.kt")
        public void testSmartCast() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/smartCast.kt");
        }

        @TestMetadata("superCall.kt")
        public void testSuperCall() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/superCall.kt");
        }

        @TestMetadata("suppressedByAtomicIntegerList.kt")
        public void testSuppressedByAtomicIntegerList() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/suppressedByAtomicIntegerList.kt");
        }

        @TestMetadata("suppressedByAtomicLongList.kt")
        public void testSuppressedByAtomicLongList() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/suppressedByAtomicLongList.kt");
        }

        @TestMetadata("suppressedByNotPropertyList.kt")
        public void testSuppressedByNotPropertyList() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/suppressedByNotPropertyList.kt");
        }

        @TestMetadata("typeParameterReceiver.kt")
        public void testTypeParameterReceiver() throws Exception {
            runTest("idea/testData/intentions/usePropertyAccessSyntax/typeParameterReceiver.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/useWithIndex")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UseWithIndex extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUseWithIndex() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/useWithIndex"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("alreadyWithIndex.kt")
        public void testAlreadyWithIndex() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/alreadyWithIndex.kt");
        }

        @TestMetadata("customTypeWithIterator.kt")
        public void testCustomTypeWithIterator() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/customTypeWithIterator.kt");
        }

        @TestMetadata("destructuringDeclaration.kt")
        public void testDestructuringDeclaration() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/destructuringDeclaration.kt");
        }

        @TestMetadata("indexIncrementTwice.kt")
        public void testIndexIncrementTwice() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/indexIncrementTwice.kt");
        }

        @TestMetadata("indexPlusPlusInsideExpression.kt")
        public void testIndexPlusPlusInsideExpression() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/indexPlusPlusInsideExpression.kt");
        }

        @TestMetadata("indexUsedAfterLoop.kt")
        public void testIndexUsedAfterLoop() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/indexUsedAfterLoop.kt");
        }

        @TestMetadata("prefixPlusPlusInsideExpression.kt")
        public void testPrefixPlusPlusInsideExpression() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/prefixPlusPlusInsideExpression.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/useWithIndex/simple.kt");
        }
    }

    @TestMetadata("idea/testData/intentions/valToObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ValToObject extends AbstractIntentionTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInValToObject() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/intentions/valToObject"), Pattern.compile("^([\\w\\-_]+)\\.(kt|kts)$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotations.kt")
        public void testAnnotations() throws Exception {
            runTest("idea/testData/intentions/valToObject/annotations.kt");
        }

        @TestMetadata("callableReference.kt")
        public void testCallableReference() throws Exception {
            runTest("idea/testData/intentions/valToObject/callableReference.kt");
        }

        @TestMetadata("expected.kt")
        public void testExpected() throws Exception {
            runTest("idea/testData/intentions/valToObject/expected.kt");
        }

        @TestMetadata("getter.kt")
        public void testGetter() throws Exception {
            runTest("idea/testData/intentions/valToObject/getter.kt");
        }

        @TestMetadata("nonTopLevel.kt")
        public void testNonTopLevel() throws Exception {
            runTest("idea/testData/intentions/valToObject/nonTopLevel.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/intentions/valToObject/simple.kt");
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            runTest("idea/testData/intentions/valToObject/var.kt");
        }

        @TestMetadata("withJavaUsage.kt")
        public void testWithJavaUsage() throws Exception {
            runTest("idea/testData/intentions/valToObject/withJavaUsage.kt");
        }
    }
}
