/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef FILE_MANAGER_SERVER_H
#define FILE_MANAGER_SERVER_H

#include <QWidget>
#include <QQueue>
#include <QTcpSocket>
#include <QApplication>
#include "auth/auth_server.h"
#include "../../../commons/constants.h"
#include "../../../commons/logger.h"

class FileManagerServer : public QObject
{
    Q_OBJECT

public:
    FileManagerServer(auth_server *file_tcp_server, QObject *parent);    
    QMap<int,QString>* file_queue_list;

public slots:
    int send_document(QString name, QString path, int client_nbr);
    void received_stream_files_slot(QString message, int client_nbr);

signals:
    void tell_client_transfer_state(int state, int client_nbr);

private:
    auth_server *tcp_server;
    QString slash;
    Logger *m_logger;
};

#endif
