
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQProgressBar.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QProgressBar>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionProgressBar>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QProgressBar

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QProgressBar::staticMetaObject);
}


// QFlags<Qt::AlignmentFlag> QProgressBar::alignment()


static void _init_f_alignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_alignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QProgressBar *)cls)->alignment ());
}


// QString QProgressBar::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QProgressBar *)cls)->format ());
}


// bool QProgressBar::invertedAppearance()


static void _init_f_invertedAppearance_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_invertedAppearance_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProgressBar *)cls)->invertedAppearance ());
}


// bool QProgressBar::isTextVisible()


static void _init_f_isTextVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTextVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProgressBar *)cls)->isTextVisible ());
}


// int QProgressBar::maximum()


static void _init_f_maximum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QProgressBar *)cls)->maximum ());
}


// int QProgressBar::minimum()


static void _init_f_minimum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimum_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QProgressBar *)cls)->minimum ());
}


// QSize QProgressBar::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QProgressBar *)cls)->minimumSizeHint ());
}


// Qt::Orientation QProgressBar::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::Orientation>::target_type > ((qt_gsi::Converter<Qt::Orientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::Orientation>(((QProgressBar *)cls)->orientation ()));
}


// void QProgressBar::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->reset ();
}


// void QProgressBar::resetFormat()


static void _init_f_resetFormat_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetFormat_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->resetFormat ();
}


// void QProgressBar::setAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setAlignment (arg1);
}


// void QProgressBar::setFormat(const QString &format)


static void _init_f_setFormat_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setFormat (arg1);
}


// void QProgressBar::setInvertedAppearance(bool invert)


static void _init_f_setInvertedAppearance_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("invert");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInvertedAppearance_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setInvertedAppearance (arg1);
}


// void QProgressBar::setMaximum(int maximum)


static void _init_f_setMaximum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maximum");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximum_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setMaximum (arg1);
}


// void QProgressBar::setMinimum(int minimum)


static void _init_f_setMinimum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minimum");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimum_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setMinimum (arg1);
}


// void QProgressBar::setOrientation(Qt::Orientation)


static void _init_f_setOrientation_1913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_1913 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::Orientation>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref());
}


// void QProgressBar::setRange(int minimum, int maximum)


static void _init_f_setRange_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minimum");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("maximum");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRange_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setRange (arg1, arg2);
}


// void QProgressBar::setTextDirection(QProgressBar::Direction textDirection)


static void _init_f_setTextDirection_2692 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("textDirection");
  decl->add_arg<const qt_gsi::Converter<QProgressBar::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextDirection_2692 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QProgressBar::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QProgressBar::Direction>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setTextDirection (qt_gsi::QtToCppAdaptor<QProgressBar::Direction>(arg1).cref());
}


// void QProgressBar::setTextVisible(bool visible)


static void _init_f_setTextVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setTextVisible (arg1);
}


// void QProgressBar::setValue(int value)


static void _init_f_setValue_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setValue_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar *)cls)->setValue (arg1);
}


// QSize QProgressBar::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QProgressBar *)cls)->sizeHint ());
}


// QString QProgressBar::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QProgressBar *)cls)->text ());
}


// QProgressBar::Direction QProgressBar::textDirection()


static void _init_f_textDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProgressBar::Direction>::target_type > ();
}

static void _call_f_textDirection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProgressBar::Direction>::target_type > ((qt_gsi::Converter<QProgressBar::Direction>::target_type)qt_gsi::CppToQtAdaptor<QProgressBar::Direction>(((QProgressBar *)cls)->textDirection ()));
}


// int QProgressBar::value()


static void _init_f_value_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_value_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QProgressBar *)cls)->value ());
}


// static QString QProgressBar::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QProgressBar::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QProgressBar () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":alignment", "@brief Method QFlags<Qt::AlignmentFlag> QProgressBar::alignment()\n", true, &_init_f_alignment_c0, &_call_f_alignment_c0);
  methods += new qt_gsi::GenericMethod (":format", "@brief Method QString QProgressBar::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod (":invertedAppearance", "@brief Method bool QProgressBar::invertedAppearance()\n", true, &_init_f_invertedAppearance_c0, &_call_f_invertedAppearance_c0);
  methods += new qt_gsi::GenericMethod ("isTextVisible?|:textVisible", "@brief Method bool QProgressBar::isTextVisible()\n", true, &_init_f_isTextVisible_c0, &_call_f_isTextVisible_c0);
  methods += new qt_gsi::GenericMethod (":maximum", "@brief Method int QProgressBar::maximum()\n", true, &_init_f_maximum_c0, &_call_f_maximum_c0);
  methods += new qt_gsi::GenericMethod (":minimum", "@brief Method int QProgressBar::minimum()\n", true, &_init_f_minimum_c0, &_call_f_minimum_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QProgressBar::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod (":orientation", "@brief Method Qt::Orientation QProgressBar::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QProgressBar::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("resetFormat", "@brief Method void QProgressBar::resetFormat()\n", false, &_init_f_resetFormat_0, &_call_f_resetFormat_0);
  methods += new qt_gsi::GenericMethod ("setAlignment|alignment=", "@brief Method void QProgressBar::setAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setAlignment_2750, &_call_f_setAlignment_2750);
  methods += new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QProgressBar::setFormat(const QString &format)\n", false, &_init_f_setFormat_2025, &_call_f_setFormat_2025);
  methods += new qt_gsi::GenericMethod ("setInvertedAppearance|invertedAppearance=", "@brief Method void QProgressBar::setInvertedAppearance(bool invert)\n", false, &_init_f_setInvertedAppearance_864, &_call_f_setInvertedAppearance_864);
  methods += new qt_gsi::GenericMethod ("setMaximum|maximum=", "@brief Method void QProgressBar::setMaximum(int maximum)\n", false, &_init_f_setMaximum_767, &_call_f_setMaximum_767);
  methods += new qt_gsi::GenericMethod ("setMinimum|minimum=", "@brief Method void QProgressBar::setMinimum(int minimum)\n", false, &_init_f_setMinimum_767, &_call_f_setMinimum_767);
  methods += new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QProgressBar::setOrientation(Qt::Orientation)\n", false, &_init_f_setOrientation_1913, &_call_f_setOrientation_1913);
  methods += new qt_gsi::GenericMethod ("setRange", "@brief Method void QProgressBar::setRange(int minimum, int maximum)\n", false, &_init_f_setRange_1426, &_call_f_setRange_1426);
  methods += new qt_gsi::GenericMethod ("setTextDirection|textDirection=", "@brief Method void QProgressBar::setTextDirection(QProgressBar::Direction textDirection)\n", false, &_init_f_setTextDirection_2692, &_call_f_setTextDirection_2692);
  methods += new qt_gsi::GenericMethod ("setTextVisible|textVisible=", "@brief Method void QProgressBar::setTextVisible(bool visible)\n", false, &_init_f_setTextVisible_864, &_call_f_setTextVisible_864);
  methods += new qt_gsi::GenericMethod ("setValue|value=", "@brief Method void QProgressBar::setValue(int value)\n", false, &_init_f_setValue_767, &_call_f_setValue_767);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QProgressBar::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":text", "@brief Method QString QProgressBar::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
  methods += new qt_gsi::GenericMethod (":textDirection", "@brief Method QProgressBar::Direction QProgressBar::textDirection()\n", true, &_init_f_textDirection_c0, &_call_f_textDirection_c0);
  methods += new qt_gsi::GenericMethod (":value", "@brief Method int QProgressBar::value()\n", true, &_init_f_value_c0, &_call_f_value_c0);
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QProgressBar::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QProgressBar::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QProgressBar::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("valueChanged(int)", "valueChanged", gsi::arg("value"), "@brief Signal declaration for QProgressBar::valueChanged(int value)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QProgressBar::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QProgressBar::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QProgressBar::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QProgressBar::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QProgressBar> decl_QProgressBar (qtdecl_QWidget (), "QtWidgets", "QProgressBar_Native",
  methods_QProgressBar (),
  "@hide\n@alias QProgressBar");

GSI_QTWIDGETS_PUBLIC gsi::Class<QProgressBar> &qtdecl_QProgressBar () { return decl_QProgressBar; }

}


class QProgressBar_Adaptor : public QProgressBar, public qt_gsi::QtObjectBase
{
public:

  virtual ~QProgressBar_Adaptor();

  //  [adaptor ctor] QProgressBar::QProgressBar(QWidget *parent)
  QProgressBar_Adaptor() : QProgressBar()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QProgressBar::QProgressBar(QWidget *parent)
  QProgressBar_Adaptor(QWidget *parent) : QProgressBar(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QProgressBar::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QProgressBar_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QProgressBar::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QProgressBar::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QProgressBar_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QProgressBar::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QProgressBar::focusNextChild()
  bool fp_QProgressBar_focusNextChild_0 () {
    return QProgressBar::focusNextChild();
  }

  //  [expose] bool QProgressBar::focusPreviousChild()
  bool fp_QProgressBar_focusPreviousChild_0 () {
    return QProgressBar::focusPreviousChild();
  }

  //  [expose] bool QProgressBar::isSignalConnected(const QMetaMethod &signal)
  bool fp_QProgressBar_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QProgressBar::isSignalConnected(signal);
  }

  //  [expose] int QProgressBar::receivers(const char *signal)
  int fp_QProgressBar_receivers_c1731 (const char *signal) const {
    return QProgressBar::receivers(signal);
  }

  //  [expose] QObject *QProgressBar::sender()
  QObject * fp_QProgressBar_sender_c0 () const {
    return QProgressBar::sender();
  }

  //  [expose] int QProgressBar::senderSignalIndex()
  int fp_QProgressBar_senderSignalIndex_c0 () const {
    return QProgressBar::senderSignalIndex();
  }

  //  [expose] void QProgressBar::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QProgressBar_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QProgressBar::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [emitter impl] void QProgressBar::customContextMenuRequested(const QPoint &pos)
  void emitter_QProgressBar_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QProgressBar::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QProgressBar::destroyed(QObject *)
  void emitter_QProgressBar_destroyed_1302(QObject *arg1)
  {
    emit QProgressBar::destroyed(arg1);
  }

  //  [adaptor impl] bool QProgressBar::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QProgressBar::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QProgressBar_Adaptor, bool, QObject *, QEvent *>(&QProgressBar_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QProgressBar::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QProgressBar::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QProgressBar::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QProgressBar_Adaptor, bool>(&QProgressBar_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QProgressBar::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QProgressBar::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QProgressBar::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QProgressBar_Adaptor, int, int>(&QProgressBar_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QProgressBar::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QProgressBar::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QProgressBar::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QProgressBar_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QProgressBar_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QProgressBar::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QProgressBar::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QProgressBar::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QProgressBar_Adaptor, QSize>(&QProgressBar_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QProgressBar::minimumSizeHint();
    }
  }

  //  [emitter impl] void QProgressBar::objectNameChanged(const QString &objectName)
  void emitter_QProgressBar_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QProgressBar::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QProgressBar::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QProgressBar::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QProgressBar_Adaptor, QPaintEngine *>(&QProgressBar_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QProgressBar::paintEngine();
    }
  }

  //  [adaptor impl] void QProgressBar::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QProgressBar::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QProgressBar_Adaptor, bool>(&QProgressBar_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QProgressBar::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QProgressBar::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QProgressBar::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QProgressBar_Adaptor, QSize>(&QProgressBar_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QProgressBar::sizeHint();
    }
  }

  //  [adaptor impl] QString QProgressBar::text()
  QString cbs_text_c0_0() const
  {
    return QProgressBar::text();
  }

  virtual QString text() const
  {
    if (cb_text_c0_0.can_issue()) {
      return cb_text_c0_0.issue<QProgressBar_Adaptor, QString>(&QProgressBar_Adaptor::cbs_text_c0_0);
    } else {
      return QProgressBar::text();
    }
  }

  //  [emitter impl] void QProgressBar::valueChanged(int value)
  void emitter_QProgressBar_valueChanged_767(int value)
  {
    emit QProgressBar::valueChanged(value);
  }

  //  [emitter impl] void QProgressBar::windowIconChanged(const QIcon &icon)
  void emitter_QProgressBar_windowIconChanged_1787(const QIcon &icon)
  {
    emit QProgressBar::windowIconChanged(icon);
  }

  //  [emitter impl] void QProgressBar::windowIconTextChanged(const QString &iconText)
  void emitter_QProgressBar_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QProgressBar::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QProgressBar::windowTitleChanged(const QString &title)
  void emitter_QProgressBar_windowTitleChanged_2025(const QString &title)
  {
    emit QProgressBar::windowTitleChanged(title);
  }

  //  [adaptor impl] void QProgressBar::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QProgressBar::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QProgressBar_Adaptor, QActionEvent *>(&QProgressBar_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QProgressBar::actionEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QProgressBar::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QProgressBar_Adaptor, QEvent *>(&QProgressBar_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QProgressBar::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QProgressBar::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QProgressBar::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QProgressBar_Adaptor, QChildEvent *>(&QProgressBar_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QProgressBar::childEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QProgressBar::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QProgressBar_Adaptor, QCloseEvent *>(&QProgressBar_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QProgressBar::closeEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QProgressBar::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QProgressBar_Adaptor, QContextMenuEvent *>(&QProgressBar_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QProgressBar::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QProgressBar::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QProgressBar_Adaptor, QEvent *>(&QProgressBar_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QProgressBar::customEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QProgressBar::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QProgressBar_Adaptor, const QMetaMethod &>(&QProgressBar_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QProgressBar::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QProgressBar::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QProgressBar::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QProgressBar_Adaptor, QDragEnterEvent *>(&QProgressBar_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QProgressBar::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QProgressBar::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QProgressBar_Adaptor, QDragLeaveEvent *>(&QProgressBar_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QProgressBar::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QProgressBar::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QProgressBar_Adaptor, QDragMoveEvent *>(&QProgressBar_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QProgressBar::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QProgressBar::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QProgressBar_Adaptor, QDropEvent *>(&QProgressBar_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QProgressBar::dropEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QProgressBar::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QProgressBar_Adaptor, QEnterEvent *>(&QProgressBar_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QProgressBar::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QProgressBar::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QProgressBar::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QProgressBar_Adaptor, bool, QEvent *>(&QProgressBar_Adaptor::cbs_event_1217_0, e);
    } else {
      return QProgressBar::event(e);
    }
  }

  //  [adaptor impl] void QProgressBar::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QProgressBar::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QProgressBar_Adaptor, QFocusEvent *>(&QProgressBar_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QProgressBar::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QProgressBar::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QProgressBar::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QProgressBar_Adaptor, bool, bool>(&QProgressBar_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QProgressBar::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QProgressBar::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QProgressBar::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QProgressBar_Adaptor, QFocusEvent *>(&QProgressBar_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QProgressBar::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QProgressBar::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QProgressBar_Adaptor, QHideEvent *>(&QProgressBar_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QProgressBar::hideEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QProgressBar::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QProgressBar_Adaptor, QPainter *>(&QProgressBar_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QProgressBar::initPainter(painter);
    }
  }

  //  [adaptor impl] void QProgressBar::initStyleOption(QStyleOptionProgressBar *option)
  void cbs_initStyleOption_c2995_0(QStyleOptionProgressBar *option) const
  {
    QProgressBar::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionProgressBar *option) const
  {
    if (cb_initStyleOption_c2995_0.can_issue()) {
      cb_initStyleOption_c2995_0.issue<QProgressBar_Adaptor, QStyleOptionProgressBar *>(&QProgressBar_Adaptor::cbs_initStyleOption_c2995_0, option);
    } else {
      QProgressBar::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QProgressBar::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QProgressBar::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QProgressBar_Adaptor, QInputMethodEvent *>(&QProgressBar_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QProgressBar::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QProgressBar::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QProgressBar::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QProgressBar_Adaptor, QKeyEvent *>(&QProgressBar_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QProgressBar::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QProgressBar::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QProgressBar_Adaptor, QKeyEvent *>(&QProgressBar_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QProgressBar::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QProgressBar::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QProgressBar_Adaptor, QEvent *>(&QProgressBar_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QProgressBar::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QProgressBar::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QProgressBar::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QProgressBar_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QProgressBar_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QProgressBar::metric(arg1);
    }
  }

  //  [adaptor impl] void QProgressBar::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QProgressBar::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QProgressBar_Adaptor, QMouseEvent *>(&QProgressBar_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QProgressBar::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QProgressBar::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QProgressBar_Adaptor, QMouseEvent *>(&QProgressBar_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QProgressBar::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QProgressBar::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QProgressBar_Adaptor, QMouseEvent *>(&QProgressBar_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QProgressBar::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QProgressBar::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QProgressBar_Adaptor, QMouseEvent *>(&QProgressBar_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QProgressBar::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QProgressBar::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QProgressBar_Adaptor, QMoveEvent *>(&QProgressBar_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QProgressBar::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QProgressBar::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QProgressBar::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QProgressBar_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QProgressBar_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QProgressBar::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QProgressBar::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QProgressBar::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QProgressBar_Adaptor, QPaintEvent *>(&QProgressBar_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QProgressBar::paintEvent(arg1);
    }
  }

  //  [adaptor impl] QPaintDevice *QProgressBar::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QProgressBar::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QProgressBar_Adaptor, QPaintDevice *, QPoint *>(&QProgressBar_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QProgressBar::redirected(offset);
    }
  }

  //  [adaptor impl] void QProgressBar::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QProgressBar::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QProgressBar_Adaptor, QResizeEvent *>(&QProgressBar_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QProgressBar::resizeEvent(event);
    }
  }

  //  [adaptor impl] QPainter *QProgressBar::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QProgressBar::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QProgressBar_Adaptor, QPainter *>(&QProgressBar_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QProgressBar::sharedPainter();
    }
  }

  //  [adaptor impl] void QProgressBar::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QProgressBar::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QProgressBar_Adaptor, QShowEvent *>(&QProgressBar_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QProgressBar::showEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QProgressBar::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QProgressBar_Adaptor, QTabletEvent *>(&QProgressBar_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QProgressBar::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QProgressBar::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QProgressBar_Adaptor, QTimerEvent *>(&QProgressBar_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QProgressBar::timerEvent(event);
    }
  }

  //  [adaptor impl] void QProgressBar::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QProgressBar::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QProgressBar_Adaptor, QWheelEvent *>(&QProgressBar_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QProgressBar::wheelEvent(event);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_text_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c2995_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QProgressBar_Adaptor::~QProgressBar_Adaptor() { }

//  Constructor QProgressBar::QProgressBar(QWidget *parent) (adaptor class)

static void _init_ctor_QProgressBar_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QProgressBar_Adaptor> ();
}

static void _call_ctor_QProgressBar_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QProgressBar_Adaptor *> (new QProgressBar_Adaptor (arg1));
}


// void QProgressBar::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QProgressBar::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QProgressBar::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QProgressBar::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QProgressBar::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QProgressBar::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->fp_QProgressBar_create_2208 (arg1, arg2, arg3);
}


// emitter void QProgressBar::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QProgressBar_Adaptor *)cls)->emitter_QProgressBar_customContextMenuRequested_1916 (arg1);
}


// void QProgressBar::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QProgressBar::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->fp_QProgressBar_destroy_1620 (arg1, arg2);
}


// emitter void QProgressBar::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QProgressBar_Adaptor *)cls)->emitter_QProgressBar_destroyed_1302 (arg1);
}


// void QProgressBar::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QProgressBar::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QProgressBar::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QProgressBar::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QProgressBar::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QProgressBar::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QProgressBar::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QProgressBar::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QProgressBar::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QProgressBar::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->fp_QProgressBar_focusNextChild_0 ());
}


// bool QProgressBar::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QProgressBar::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QProgressBar::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->fp_QProgressBar_focusPreviousChild_0 ());
}


// bool QProgressBar::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QProgressBar::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QProgressBar_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QProgressBar::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QProgressBar::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QProgressBar::initStyleOption(QStyleOptionProgressBar *option)

static void _init_cbs_initStyleOption_c2995_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionProgressBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c2995_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionProgressBar *arg1 = args.read<QStyleOptionProgressBar * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_initStyleOption_c2995_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c2995_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_initStyleOption_c2995_0 = cb;
}


// void QProgressBar::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QProgressBar::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QProgressBar_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QProgressBar::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->fp_QProgressBar_isSignalConnected_c2394 (arg1));
}


// void QProgressBar::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QProgressBar::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QProgressBar::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QProgressBar::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QProgressBar_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QProgressBar::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QProgressBar_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QProgressBar::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QProgressBar::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QProgressBar::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QProgressBar::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QProgressBar::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QProgressBar::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QProgressBar_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QProgressBar::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QProgressBar_Adaptor *)cls)->emitter_QProgressBar_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QProgressBar::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QProgressBar_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QProgressBar::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QProgressBar::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QProgressBar_Adaptor *)cls)->fp_QProgressBar_receivers_c1731 (arg1));
}


// QPaintDevice *QProgressBar::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QProgressBar_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QProgressBar::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QProgressBar::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QProgressBar_Adaptor *)cls)->fp_QProgressBar_sender_c0 ());
}


// exposed int QProgressBar::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QProgressBar_Adaptor *)cls)->fp_QProgressBar_senderSignalIndex_c0 ());
}


// void QProgressBar::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QProgressBar::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QProgressBar_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QProgressBar::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QProgressBar::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QProgressBar_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QProgressBar::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// QString QProgressBar::text()

static void _init_cbs_text_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_text_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QProgressBar_Adaptor *)cls)->cbs_text_c0_0 ());
}

static void _set_callback_cbs_text_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_text_c0_0 = cb;
}


// void QProgressBar::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QProgressBar::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->fp_QProgressBar_updateMicroFocus_2420 (arg1);
}


// emitter void QProgressBar::valueChanged(int value)

static void _init_emitter_valueChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_valueChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QProgressBar_Adaptor *)cls)->emitter_QProgressBar_valueChanged_767 (arg1);
}


// void QProgressBar::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProgressBar_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QProgressBar_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QProgressBar::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QProgressBar_Adaptor *)cls)->emitter_QProgressBar_windowIconChanged_1787 (arg1);
}


// emitter void QProgressBar::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QProgressBar_Adaptor *)cls)->emitter_QProgressBar_windowIconTextChanged_2025 (arg1);
}


// emitter void QProgressBar::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QProgressBar_Adaptor *)cls)->emitter_QProgressBar_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QProgressBar> &qtdecl_QProgressBar ();

static gsi::Methods methods_QProgressBar_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QProgressBar::QProgressBar(QWidget *parent)\nThis method creates an object of class QProgressBar.", &_init_ctor_QProgressBar_Adaptor_1315, &_call_ctor_QProgressBar_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QProgressBar::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QProgressBar::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QProgressBar::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QProgressBar::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QProgressBar::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QProgressBar::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QProgressBar::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QProgressBar::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QProgressBar::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QProgressBar::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QProgressBar::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QProgressBar::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QProgressBar::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QProgressBar::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QProgressBar::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QProgressBar::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QProgressBar::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QProgressBar::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QProgressBar::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QProgressBar::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QProgressBar::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QProgressBar::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QProgressBar::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QProgressBar::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QProgressBar::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QProgressBar::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QProgressBar::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QProgressBar::initStyleOption(QStyleOptionProgressBar *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c2995_0, &_call_cbs_initStyleOption_c2995_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c2995_0, &_call_cbs_initStyleOption_c2995_0, &_set_callback_cbs_initStyleOption_c2995_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QProgressBar::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QProgressBar::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QProgressBar::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QProgressBar::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QProgressBar::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QProgressBar::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QProgressBar::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QProgressBar::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QProgressBar::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QProgressBar::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QProgressBar::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QProgressBar::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QProgressBar::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QProgressBar::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QProgressBar::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QProgressBar::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QProgressBar::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QProgressBar::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QProgressBar::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QProgressBar::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QProgressBar::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QProgressBar::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QProgressBar::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QProgressBar::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QProgressBar::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QProgressBar::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QProgressBar::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("text", "@brief Virtual method QString QProgressBar::text()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_text_c0_0, &_call_cbs_text_c0_0);
  methods += new qt_gsi::GenericMethod ("text", "@hide", true, &_init_cbs_text_c0_0, &_call_cbs_text_c0_0, &_set_callback_cbs_text_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QProgressBar::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QProgressBar::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("emit_valueChanged", "@brief Emitter for signal void QProgressBar::valueChanged(int value)\nCall this method to emit this signal.", false, &_init_emitter_valueChanged_767, &_call_emitter_valueChanged_767);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QProgressBar::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QProgressBar::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QProgressBar::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QProgressBar::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QProgressBar_Adaptor> decl_QProgressBar_Adaptor (qtdecl_QProgressBar (), "QtWidgets", "QProgressBar",
  methods_QProgressBar_Adaptor (),
  "@qt\n@brief Binding of QProgressBar");

}


//  Implementation of the enum wrapper class for QProgressBar::Direction
namespace qt_gsi
{

static gsi::Enum<QProgressBar::Direction> decl_QProgressBar_Direction_Enum ("QtWidgets", "QProgressBar_Direction",
    gsi::enum_const ("TopToBottom", QProgressBar::TopToBottom, "@brief Enum constant QProgressBar::TopToBottom") +
    gsi::enum_const ("BottomToTop", QProgressBar::BottomToTop, "@brief Enum constant QProgressBar::BottomToTop"),
  "@qt\n@brief This class represents the QProgressBar::Direction enum");

static gsi::QFlagsClass<QProgressBar::Direction > decl_QProgressBar_Direction_Enums ("QtWidgets", "QProgressBar_QFlags_Direction",
  "@qt\n@brief This class represents the QFlags<QProgressBar::Direction> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QProgressBar> inject_QProgressBar_Direction_Enum_in_parent (decl_QProgressBar_Direction_Enum.defs ());
static gsi::ClassExt<QProgressBar> decl_QProgressBar_Direction_Enum_as_child (decl_QProgressBar_Direction_Enum, "Direction");
static gsi::ClassExt<QProgressBar> decl_QProgressBar_Direction_Enums_as_child (decl_QProgressBar_Direction_Enums, "QFlags_Direction");

}

