
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQScreen.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QScreen>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QSize>
#include <QSizeF>
#include <QThread>
#include <QTimerEvent>
#include <QTransform>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QScreen

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QScreen::staticMetaObject);
}


// int QScreen::angleBetween(Qt::ScreenOrientation a, Qt::ScreenOrientation b)


static void _init_f_angleBetween_c4934 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("b");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_angleBetween_c4934 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  ret.write<int > ((int)((QScreen *)cls)->angleBetween (qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg1).cref(), qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg2).cref()));
}


// QRect QScreen::availableGeometry()


static void _init_f_availableGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_availableGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QScreen *)cls)->availableGeometry ());
}


// QSize QScreen::availableSize()


static void _init_f_availableSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_availableSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QScreen *)cls)->availableSize ());
}


// QRect QScreen::availableVirtualGeometry()


static void _init_f_availableVirtualGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_availableVirtualGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QScreen *)cls)->availableVirtualGeometry ());
}


// QSize QScreen::availableVirtualSize()


static void _init_f_availableVirtualSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_availableVirtualSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QScreen *)cls)->availableVirtualSize ());
}


// int QScreen::depth()


static void _init_f_depth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_depth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QScreen *)cls)->depth ());
}


// double QScreen::devicePixelRatio()


static void _init_f_devicePixelRatio_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_devicePixelRatio_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->devicePixelRatio ());
}


// QRect QScreen::geometry()


static void _init_f_geometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_geometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QScreen *)cls)->geometry ());
}


// QPixmap QScreen::grabWindow(WId window, int x, int y, int w, int h)


static void _init_f_grabWindow_3332 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("window", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y", true, "0");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "-1");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("h", true, "-1");
  decl->add_arg<int > (argspec_4);
  decl->set_return<QPixmap > ();
}

static void _call_f_grabWindow_3332 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  int arg5 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QPixmap > ((QPixmap)((QScreen *)cls)->grabWindow (qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), arg2, arg3, arg4, arg5));
}


// bool QScreen::isLandscape(Qt::ScreenOrientation orientation)


static void _init_f_isLandscape_c2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isLandscape_c2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QScreen *)cls)->isLandscape (qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg1).cref()));
}


// bool QScreen::isPortrait(Qt::ScreenOrientation orientation)


static void _init_f_isPortrait_c2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isPortrait_c2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QScreen *)cls)->isPortrait (qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg1).cref()));
}


// double QScreen::logicalDotsPerInch()


static void _init_f_logicalDotsPerInch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_logicalDotsPerInch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->logicalDotsPerInch ());
}


// double QScreen::logicalDotsPerInchX()


static void _init_f_logicalDotsPerInchX_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_logicalDotsPerInchX_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->logicalDotsPerInchX ());
}


// double QScreen::logicalDotsPerInchY()


static void _init_f_logicalDotsPerInchY_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_logicalDotsPerInchY_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->logicalDotsPerInchY ());
}


// QString QScreen::manufacturer()


static void _init_f_manufacturer_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_manufacturer_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QScreen *)cls)->manufacturer ());
}


// QRect QScreen::mapBetween(Qt::ScreenOrientation a, Qt::ScreenOrientation b, const QRect &rect)


static void _init_f_mapBetween_c6618 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("b");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_f_mapBetween_c6618 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)((QScreen *)cls)->mapBetween (qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg1).cref(), qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg2).cref(), arg3));
}


// QString QScreen::model()


static void _init_f_model_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_model_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QScreen *)cls)->model ());
}


// QString QScreen::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QScreen *)cls)->name ());
}


// Qt::ScreenOrientation QScreen::nativeOrientation()


static void _init_f_nativeOrientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ();
}

static void _call_f_nativeOrientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ((qt_gsi::Converter<Qt::ScreenOrientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::ScreenOrientation>(((QScreen *)cls)->nativeOrientation ()));
}


// Qt::ScreenOrientation QScreen::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ((qt_gsi::Converter<Qt::ScreenOrientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::ScreenOrientation>(((QScreen *)cls)->orientation ()));
}


// double QScreen::physicalDotsPerInch()


static void _init_f_physicalDotsPerInch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_physicalDotsPerInch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->physicalDotsPerInch ());
}


// double QScreen::physicalDotsPerInchX()


static void _init_f_physicalDotsPerInchX_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_physicalDotsPerInchX_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->physicalDotsPerInchX ());
}


// double QScreen::physicalDotsPerInchY()


static void _init_f_physicalDotsPerInchY_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_physicalDotsPerInchY_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->physicalDotsPerInchY ());
}


// QSizeF QScreen::physicalSize()


static void _init_f_physicalSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_physicalSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QScreen *)cls)->physicalSize ());
}


// Qt::ScreenOrientation QScreen::primaryOrientation()


static void _init_f_primaryOrientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ();
}

static void _call_f_primaryOrientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::ScreenOrientation>::target_type > ((qt_gsi::Converter<Qt::ScreenOrientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::ScreenOrientation>(((QScreen *)cls)->primaryOrientation ()));
}


// double QScreen::refreshRate()


static void _init_f_refreshRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_refreshRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QScreen *)cls)->refreshRate ());
}


// QString QScreen::serialNumber()


static void _init_f_serialNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_serialNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QScreen *)cls)->serialNumber ());
}


// QSize QScreen::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QScreen *)cls)->size ());
}


// QTransform QScreen::transformBetween(Qt::ScreenOrientation a, Qt::ScreenOrientation b, const QRect &target)


static void _init_f_transformBetween_c6618 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("b");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("target");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<QTransform > ();
}

static void _call_f_transformBetween_c6618 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  const QRect &arg3 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QTransform > ((QTransform)((QScreen *)cls)->transformBetween (qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg1).cref(), qt_gsi::QtToCppAdaptor<Qt::ScreenOrientation>(arg2).cref(), arg3));
}


// QRect QScreen::virtualGeometry()


static void _init_f_virtualGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_virtualGeometry_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QScreen *)cls)->virtualGeometry ());
}


// QScreen *QScreen::virtualSiblingAt(QPoint point)


static void _init_f_virtualSiblingAt_1039 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<QPoint > (argspec_0);
  decl->set_return<QScreen * > ();
}

static void _call_f_virtualSiblingAt_1039 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint arg1 = gsi::arg_reader<QPoint >() (args, heap);
  ret.write<QScreen * > ((QScreen *)((QScreen *)cls)->virtualSiblingAt (arg1));
}


// QList<QScreen *> QScreen::virtualSiblings()


static void _init_f_virtualSiblings_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QScreen *> > ();
}

static void _call_f_virtualSiblings_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QScreen *> > ((QList<QScreen *>)((QScreen *)cls)->virtualSiblings ());
}


// QSize QScreen::virtualSize()


static void _init_f_virtualSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_virtualSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QScreen *)cls)->virtualSize ());
}


// static QString QScreen::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QScreen::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QScreen () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("angleBetween", "@brief Method int QScreen::angleBetween(Qt::ScreenOrientation a, Qt::ScreenOrientation b)\n", true, &_init_f_angleBetween_c4934, &_call_f_angleBetween_c4934);
  methods += new qt_gsi::GenericMethod (":availableGeometry", "@brief Method QRect QScreen::availableGeometry()\n", true, &_init_f_availableGeometry_c0, &_call_f_availableGeometry_c0);
  methods += new qt_gsi::GenericMethod (":availableSize", "@brief Method QSize QScreen::availableSize()\n", true, &_init_f_availableSize_c0, &_call_f_availableSize_c0);
  methods += new qt_gsi::GenericMethod (":availableVirtualGeometry", "@brief Method QRect QScreen::availableVirtualGeometry()\n", true, &_init_f_availableVirtualGeometry_c0, &_call_f_availableVirtualGeometry_c0);
  methods += new qt_gsi::GenericMethod (":availableVirtualSize", "@brief Method QSize QScreen::availableVirtualSize()\n", true, &_init_f_availableVirtualSize_c0, &_call_f_availableVirtualSize_c0);
  methods += new qt_gsi::GenericMethod (":depth", "@brief Method int QScreen::depth()\n", true, &_init_f_depth_c0, &_call_f_depth_c0);
  methods += new qt_gsi::GenericMethod (":devicePixelRatio", "@brief Method double QScreen::devicePixelRatio()\n", true, &_init_f_devicePixelRatio_c0, &_call_f_devicePixelRatio_c0);
  methods += new qt_gsi::GenericMethod (":geometry", "@brief Method QRect QScreen::geometry()\n", true, &_init_f_geometry_c0, &_call_f_geometry_c0);
  methods += new qt_gsi::GenericMethod ("grabWindow", "@brief Method QPixmap QScreen::grabWindow(WId window, int x, int y, int w, int h)\n", false, &_init_f_grabWindow_3332, &_call_f_grabWindow_3332);
  methods += new qt_gsi::GenericMethod ("isLandscape?", "@brief Method bool QScreen::isLandscape(Qt::ScreenOrientation orientation)\n", true, &_init_f_isLandscape_c2521, &_call_f_isLandscape_c2521);
  methods += new qt_gsi::GenericMethod ("isPortrait?", "@brief Method bool QScreen::isPortrait(Qt::ScreenOrientation orientation)\n", true, &_init_f_isPortrait_c2521, &_call_f_isPortrait_c2521);
  methods += new qt_gsi::GenericMethod (":logicalDotsPerInch", "@brief Method double QScreen::logicalDotsPerInch()\n", true, &_init_f_logicalDotsPerInch_c0, &_call_f_logicalDotsPerInch_c0);
  methods += new qt_gsi::GenericMethod (":logicalDotsPerInchX", "@brief Method double QScreen::logicalDotsPerInchX()\n", true, &_init_f_logicalDotsPerInchX_c0, &_call_f_logicalDotsPerInchX_c0);
  methods += new qt_gsi::GenericMethod (":logicalDotsPerInchY", "@brief Method double QScreen::logicalDotsPerInchY()\n", true, &_init_f_logicalDotsPerInchY_c0, &_call_f_logicalDotsPerInchY_c0);
  methods += new qt_gsi::GenericMethod (":manufacturer", "@brief Method QString QScreen::manufacturer()\n", true, &_init_f_manufacturer_c0, &_call_f_manufacturer_c0);
  methods += new qt_gsi::GenericMethod ("mapBetween", "@brief Method QRect QScreen::mapBetween(Qt::ScreenOrientation a, Qt::ScreenOrientation b, const QRect &rect)\n", true, &_init_f_mapBetween_c6618, &_call_f_mapBetween_c6618);
  methods += new qt_gsi::GenericMethod (":model", "@brief Method QString QScreen::model()\n", true, &_init_f_model_c0, &_call_f_model_c0);
  methods += new qt_gsi::GenericMethod (":name", "@brief Method QString QScreen::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod (":nativeOrientation", "@brief Method Qt::ScreenOrientation QScreen::nativeOrientation()\n", true, &_init_f_nativeOrientation_c0, &_call_f_nativeOrientation_c0);
  methods += new qt_gsi::GenericMethod (":orientation", "@brief Method Qt::ScreenOrientation QScreen::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
  methods += new qt_gsi::GenericMethod (":physicalDotsPerInch", "@brief Method double QScreen::physicalDotsPerInch()\n", true, &_init_f_physicalDotsPerInch_c0, &_call_f_physicalDotsPerInch_c0);
  methods += new qt_gsi::GenericMethod (":physicalDotsPerInchX", "@brief Method double QScreen::physicalDotsPerInchX()\n", true, &_init_f_physicalDotsPerInchX_c0, &_call_f_physicalDotsPerInchX_c0);
  methods += new qt_gsi::GenericMethod (":physicalDotsPerInchY", "@brief Method double QScreen::physicalDotsPerInchY()\n", true, &_init_f_physicalDotsPerInchY_c0, &_call_f_physicalDotsPerInchY_c0);
  methods += new qt_gsi::GenericMethod (":physicalSize", "@brief Method QSizeF QScreen::physicalSize()\n", true, &_init_f_physicalSize_c0, &_call_f_physicalSize_c0);
  methods += new qt_gsi::GenericMethod (":primaryOrientation", "@brief Method Qt::ScreenOrientation QScreen::primaryOrientation()\n", true, &_init_f_primaryOrientation_c0, &_call_f_primaryOrientation_c0);
  methods += new qt_gsi::GenericMethod (":refreshRate", "@brief Method double QScreen::refreshRate()\n", true, &_init_f_refreshRate_c0, &_call_f_refreshRate_c0);
  methods += new qt_gsi::GenericMethod (":serialNumber", "@brief Method QString QScreen::serialNumber()\n", true, &_init_f_serialNumber_c0, &_call_f_serialNumber_c0);
  methods += new qt_gsi::GenericMethod (":size", "@brief Method QSize QScreen::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod ("transformBetween", "@brief Method QTransform QScreen::transformBetween(Qt::ScreenOrientation a, Qt::ScreenOrientation b, const QRect &target)\n", true, &_init_f_transformBetween_c6618, &_call_f_transformBetween_c6618);
  methods += new qt_gsi::GenericMethod (":virtualGeometry", "@brief Method QRect QScreen::virtualGeometry()\n", true, &_init_f_virtualGeometry_c0, &_call_f_virtualGeometry_c0);
  methods += new qt_gsi::GenericMethod ("virtualSiblingAt", "@brief Method QScreen *QScreen::virtualSiblingAt(QPoint point)\n", false, &_init_f_virtualSiblingAt_1039, &_call_f_virtualSiblingAt_1039);
  methods += new qt_gsi::GenericMethod ("virtualSiblings", "@brief Method QList<QScreen *> QScreen::virtualSiblings()\n", true, &_init_f_virtualSiblings_c0, &_call_f_virtualSiblings_c0);
  methods += new qt_gsi::GenericMethod (":virtualSize", "@brief Method QSize QScreen::virtualSize()\n", true, &_init_f_virtualSize_c0, &_call_f_virtualSize_c0);
  methods += gsi::qt_signal<const QRect & > ("availableGeometryChanged(const QRect &)", "availableGeometryChanged", gsi::arg("geometry"), "@brief Signal declaration for QScreen::availableGeometryChanged(const QRect &geometry)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QScreen::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRect & > ("geometryChanged(const QRect &)", "geometryChanged", gsi::arg("geometry"), "@brief Signal declaration for QScreen::geometryChanged(const QRect &geometry)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("logicalDotsPerInchChanged(double)", "logicalDotsPerInchChanged", gsi::arg("dpi"), "@brief Signal declaration for QScreen::logicalDotsPerInchChanged(double dpi)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QScreen::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > ("orientationChanged(Qt::ScreenOrientation)", "orientationChanged", gsi::arg("orientation"), "@brief Signal declaration for QScreen::orientationChanged(Qt::ScreenOrientation orientation)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("physicalDotsPerInchChanged(double)", "physicalDotsPerInchChanged", gsi::arg("dpi"), "@brief Signal declaration for QScreen::physicalDotsPerInchChanged(double dpi)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSizeF & > ("physicalSizeChanged(const QSizeF &)", "physicalSizeChanged", gsi::arg("size"), "@brief Signal declaration for QScreen::physicalSizeChanged(const QSizeF &size)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > ("primaryOrientationChanged(Qt::ScreenOrientation)", "primaryOrientationChanged", gsi::arg("orientation"), "@brief Signal declaration for QScreen::primaryOrientationChanged(Qt::ScreenOrientation orientation)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("refreshRateChanged(double)", "refreshRateChanged", gsi::arg("refreshRate"), "@brief Signal declaration for QScreen::refreshRateChanged(double refreshRate)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QRect & > ("virtualGeometryChanged(const QRect &)", "virtualGeometryChanged", gsi::arg("rect"), "@brief Signal declaration for QScreen::virtualGeometryChanged(const QRect &rect)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QScreen::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QScreen> decl_QScreen (qtdecl_QObject (), "QtGui", "QScreen_Native",
  methods_QScreen (),
  "@hide\n@alias QScreen");

GSI_QTGUI_PUBLIC gsi::Class<QScreen> &qtdecl_QScreen () { return decl_QScreen; }

}


class QScreen_Adaptor : public QScreen, public qt_gsi::QtObjectBase
{
public:

  virtual ~QScreen_Adaptor();

  //  [expose] bool QScreen::isSignalConnected(const QMetaMethod &signal)
  bool fp_QScreen_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QScreen::isSignalConnected(signal);
  }

  //  [expose] int QScreen::receivers(const char *signal)
  int fp_QScreen_receivers_c1731 (const char *signal) const {
    return QScreen::receivers(signal);
  }

  //  [expose] void *QScreen::resolveInterface(const char *name, int revision)
  void * fp_QScreen_resolveInterface_c2390 (const char *name, int revision) const {
    return QScreen::resolveInterface(name, revision);
  }

  //  [expose] QObject *QScreen::sender()
  QObject * fp_QScreen_sender_c0 () const {
    return QScreen::sender();
  }

  //  [expose] int QScreen::senderSignalIndex()
  int fp_QScreen_senderSignalIndex_c0 () const {
    return QScreen::senderSignalIndex();
  }

  //  [emitter impl] void QScreen::availableGeometryChanged(const QRect &geometry)
  void emitter_QScreen_availableGeometryChanged_1792(const QRect &geometry)
  {
    emit QScreen::availableGeometryChanged(geometry);
  }

  //  [emitter impl] void QScreen::destroyed(QObject *)
  void emitter_QScreen_destroyed_1302(QObject *arg1)
  {
    emit QScreen::destroyed(arg1);
  }

  //  [adaptor impl] bool QScreen::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QScreen::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QScreen_Adaptor, bool, QEvent *>(&QScreen_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QScreen::event(_event);
    }
  }

  //  [adaptor impl] bool QScreen::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QScreen::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QScreen_Adaptor, bool, QObject *, QEvent *>(&QScreen_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QScreen::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QScreen::geometryChanged(const QRect &geometry)
  void emitter_QScreen_geometryChanged_1792(const QRect &geometry)
  {
    emit QScreen::geometryChanged(geometry);
  }

  //  [emitter impl] void QScreen::logicalDotsPerInchChanged(double dpi)
  void emitter_QScreen_logicalDotsPerInchChanged_1071(double dpi)
  {
    emit QScreen::logicalDotsPerInchChanged(dpi);
  }

  //  [emitter impl] void QScreen::objectNameChanged(const QString &objectName)
  void emitter_QScreen_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QScreen::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QScreen::orientationChanged(Qt::ScreenOrientation orientation)
  void emitter_QScreen_orientationChanged_2521(Qt::ScreenOrientation orientation)
  {
    emit QScreen::orientationChanged(orientation);
  }

  //  [emitter impl] void QScreen::physicalDotsPerInchChanged(double dpi)
  void emitter_QScreen_physicalDotsPerInchChanged_1071(double dpi)
  {
    emit QScreen::physicalDotsPerInchChanged(dpi);
  }

  //  [emitter impl] void QScreen::physicalSizeChanged(const QSizeF &size)
  void emitter_QScreen_physicalSizeChanged_1875(const QSizeF &size)
  {
    emit QScreen::physicalSizeChanged(size);
  }

  //  [emitter impl] void QScreen::primaryOrientationChanged(Qt::ScreenOrientation orientation)
  void emitter_QScreen_primaryOrientationChanged_2521(Qt::ScreenOrientation orientation)
  {
    emit QScreen::primaryOrientationChanged(orientation);
  }

  //  [emitter impl] void QScreen::refreshRateChanged(double refreshRate)
  void emitter_QScreen_refreshRateChanged_1071(double refreshRate)
  {
    emit QScreen::refreshRateChanged(refreshRate);
  }

  //  [emitter impl] void QScreen::virtualGeometryChanged(const QRect &rect)
  void emitter_QScreen_virtualGeometryChanged_1792(const QRect &rect)
  {
    emit QScreen::virtualGeometryChanged(rect);
  }

  //  [adaptor impl] void QScreen::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QScreen::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QScreen_Adaptor, QChildEvent *>(&QScreen_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QScreen::childEvent(event);
    }
  }

  //  [adaptor impl] void QScreen::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QScreen::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QScreen_Adaptor, QEvent *>(&QScreen_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QScreen::customEvent(event);
    }
  }

  //  [adaptor impl] void QScreen::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QScreen::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QScreen_Adaptor, const QMetaMethod &>(&QScreen_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QScreen::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QScreen::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QScreen::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QScreen_Adaptor, QTimerEvent *>(&QScreen_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QScreen::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QScreen_Adaptor::~QScreen_Adaptor() { }

// emitter void QScreen::availableGeometryChanged(const QRect &geometry)

static void _init_emitter_availableGeometryChanged_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("geometry");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_availableGeometryChanged_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_availableGeometryChanged_1792 (arg1);
}


// void QScreen::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScreen_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QScreen_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QScreen::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScreen_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScreen_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QScreen::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_destroyed_1302 (arg1);
}


// void QScreen::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScreen_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QScreen_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QScreen::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QScreen_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QScreen_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QScreen::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QScreen_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QScreen_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QScreen::geometryChanged(const QRect &geometry)

static void _init_emitter_geometryChanged_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("geometry");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_geometryChanged_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_geometryChanged_1792 (arg1);
}


// exposed bool QScreen::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QScreen_Adaptor *)cls)->fp_QScreen_isSignalConnected_c2394 (arg1));
}


// emitter void QScreen::logicalDotsPerInchChanged(double dpi)

static void _init_emitter_logicalDotsPerInchChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dpi");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_logicalDotsPerInchChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_logicalDotsPerInchChanged_1071 (arg1);
}


// emitter void QScreen::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_objectNameChanged_4567 (arg1);
}


// emitter void QScreen::orientationChanged(Qt::ScreenOrientation orientation)

static void _init_emitter_orientationChanged_2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_orientationChanged_2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_orientationChanged_2521 (arg1);
}


// emitter void QScreen::physicalDotsPerInchChanged(double dpi)

static void _init_emitter_physicalDotsPerInchChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dpi");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_physicalDotsPerInchChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_physicalDotsPerInchChanged_1071 (arg1);
}


// emitter void QScreen::physicalSizeChanged(const QSizeF &size)

static void _init_emitter_physicalSizeChanged_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_physicalSizeChanged_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_physicalSizeChanged_1875 (arg1);
}


// emitter void QScreen::primaryOrientationChanged(Qt::ScreenOrientation orientation)

static void _init_emitter_primaryOrientationChanged_2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_primaryOrientationChanged_2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_primaryOrientationChanged_2521 (arg1);
}


// exposed int QScreen::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QScreen_Adaptor *)cls)->fp_QScreen_receivers_c1731 (arg1));
}


// emitter void QScreen::refreshRateChanged(double refreshRate)

static void _init_emitter_refreshRateChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("refreshRate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_refreshRateChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_refreshRateChanged_1071 (arg1);
}


// exposed void *QScreen::resolveInterface(const char *name, int revision)

static void _init_fp_resolveInterface_c2390 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("revision");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_fp_resolveInterface_c2390 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<void * > ((void *)((QScreen_Adaptor *)cls)->fp_QScreen_resolveInterface_c2390 (arg1, arg2));
}


// exposed QObject *QScreen::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QScreen_Adaptor *)cls)->fp_QScreen_sender_c0 ());
}


// exposed int QScreen::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QScreen_Adaptor *)cls)->fp_QScreen_senderSignalIndex_c0 ());
}


// void QScreen::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QScreen_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QScreen_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QScreen::virtualGeometryChanged(const QRect &rect)

static void _init_emitter_virtualGeometryChanged_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_virtualGeometryChanged_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ((QScreen_Adaptor *)cls)->emitter_QScreen_virtualGeometryChanged_1792 (arg1);
}


namespace gsi
{

gsi::Class<QScreen> &qtdecl_QScreen ();

static gsi::Methods methods_QScreen_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("emit_availableGeometryChanged", "@brief Emitter for signal void QScreen::availableGeometryChanged(const QRect &geometry)\nCall this method to emit this signal.", false, &_init_emitter_availableGeometryChanged_1792, &_call_emitter_availableGeometryChanged_1792);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QScreen::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QScreen::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QScreen::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QScreen::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QScreen::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QScreen::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_geometryChanged", "@brief Emitter for signal void QScreen::geometryChanged(const QRect &geometry)\nCall this method to emit this signal.", false, &_init_emitter_geometryChanged_1792, &_call_emitter_geometryChanged_1792);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QScreen::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_logicalDotsPerInchChanged", "@brief Emitter for signal void QScreen::logicalDotsPerInchChanged(double dpi)\nCall this method to emit this signal.", false, &_init_emitter_logicalDotsPerInchChanged_1071, &_call_emitter_logicalDotsPerInchChanged_1071);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QScreen::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_orientationChanged", "@brief Emitter for signal void QScreen::orientationChanged(Qt::ScreenOrientation orientation)\nCall this method to emit this signal.", false, &_init_emitter_orientationChanged_2521, &_call_emitter_orientationChanged_2521);
  methods += new qt_gsi::GenericMethod ("emit_physicalDotsPerInchChanged", "@brief Emitter for signal void QScreen::physicalDotsPerInchChanged(double dpi)\nCall this method to emit this signal.", false, &_init_emitter_physicalDotsPerInchChanged_1071, &_call_emitter_physicalDotsPerInchChanged_1071);
  methods += new qt_gsi::GenericMethod ("emit_physicalSizeChanged", "@brief Emitter for signal void QScreen::physicalSizeChanged(const QSizeF &size)\nCall this method to emit this signal.", false, &_init_emitter_physicalSizeChanged_1875, &_call_emitter_physicalSizeChanged_1875);
  methods += new qt_gsi::GenericMethod ("emit_primaryOrientationChanged", "@brief Emitter for signal void QScreen::primaryOrientationChanged(Qt::ScreenOrientation orientation)\nCall this method to emit this signal.", false, &_init_emitter_primaryOrientationChanged_2521, &_call_emitter_primaryOrientationChanged_2521);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QScreen::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_refreshRateChanged", "@brief Emitter for signal void QScreen::refreshRateChanged(double refreshRate)\nCall this method to emit this signal.", false, &_init_emitter_refreshRateChanged_1071, &_call_emitter_refreshRateChanged_1071);
  methods += new qt_gsi::GenericMethod ("*resolveInterface", "@brief Method void *QScreen::resolveInterface(const char *name, int revision)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_resolveInterface_c2390, &_call_fp_resolveInterface_c2390);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QScreen::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QScreen::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QScreen::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_virtualGeometryChanged", "@brief Emitter for signal void QScreen::virtualGeometryChanged(const QRect &rect)\nCall this method to emit this signal.", false, &_init_emitter_virtualGeometryChanged_1792, &_call_emitter_virtualGeometryChanged_1792);
  return methods;
}

gsi::Class<QScreen_Adaptor> decl_QScreen_Adaptor (qtdecl_QScreen (), "QtGui", "QScreen",
  methods_QScreen_Adaptor (),
  "@qt\n@brief Binding of QScreen");

}

