/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "widgetresolution.h"
#include "widgetplaque.h"
#include "widgetoperation.h"
#include <QtGui>

//Dfinition du widget contenant le module de rsolution
WidgetResolution::WidgetResolution( QWidget *parent ) : QWidget( parent) {
	//layout vertical pour les lments du widget
	QVBoxLayout *vbox_Layout = new QVBoxLayout( this );
	
	vbox_Layout->setSpacing(0);
	vbox_Layout->setMargin(0);
	
	//dfinitions des pixmaps pour les icnes
	QPixmap *pixEgal = new QPixmap( QString(":/images/grand_egal.png") );
	QPixmap *pixGomme = new QPixmap( QString(":/images/gomme.png") );
	QPixmap *pixReinit = new QPixmap( QString(":/images/reinit.png") );
	
	//boutons des oprations disposs sur une ligne
	QWidget *hbox_oper = new QWidget( this );
	QHBoxLayout *hbox_oper_Layout = new QHBoxLayout( hbox_oper );
	hbox_oper_Layout->setSpacing(0);
	hbox_oper_Layout->setMargin(0);
	
	//les 4 oprations lmentaires
	hbox_oper_Layout->addStretch( 1 );
	int i;
	for(i=0; i<4; i++) {
		WidgetOperation *op = new WidgetOperation( this, 300+i, WidgetOperation::Plus+i, true);
		connect( op, SIGNAL(valeur(int,int)), this, SLOT(gestionPlaque(int,int)) );
		hbox_oper_Layout->addWidget( op );
	}
	hbox_oper_Layout->addStretch( 1 );
	
	//boutons de nettoyage des calculs
	QWidget *hbox_nett = new QWidget( this );
	QHBoxLayout *hbox_nett_Layout = new QHBoxLayout( hbox_nett );
	hbox_nett_Layout->setSpacing(0);
	hbox_nett_Layout->setMargin(0);
	
	QPushButton *pbGomme = new QPushButton( "", hbox_nett);
	pbGomme->setFlat( true );
	pbGomme->setFixedSize( 32, 32 );
	pbGomme->setIcon( *pixGomme );
	pbGomme->setIconSize( QSize(28,28) );
	connect( pbGomme, SIGNAL(clicked()), this, SLOT(gomme()) );
	
	QPushButton *pbReinit = new QPushButton( "", hbox_nett);
	pbReinit->setFlat( true );
	pbReinit->setFixedSize( 32, 32 );
	pbReinit->setIcon( *pixReinit );
	pbReinit->setIconSize( QSize(28,28) );
	connect( pbReinit, SIGNAL(clicked()), this, SLOT(init()) );
	
	hbox_nett_Layout->addStretch( 1 );
	hbox_nett_Layout->addWidget( pbGomme );
	hbox_nett_Layout->addWidget( pbReinit );
	hbox_nett_Layout->addStretch( 1 );
	
	//grille de rsolution des calculs
	QWidget *grilleCalcul = new QWidget( this );
	QGridLayout *grilleCalculLayout = new QGridLayout( grilleCalcul );
	int j;
	
	int plaqueId=100; //identifiant unique de chaque plaque de la grille
	for(i=0; i<tirage::nb_plaques-1; i++) {
		for(j=0; j<3; j++) {
			WidgetPlaque *plaque = new WidgetPlaque(grilleCalcul, plaqueId, 2);
			plaqueId++;
			grilleCalculLayout->addWidget(plaque , i, j*2, 1, 1, Qt::AlignTop);
			connect(this, SIGNAL(changePlaque(int, int)), plaque, SLOT(displayRefresh(int, int)) );
			connect(this, SIGNAL(changeEtat(int, int)), plaque, SLOT(updateEtat(int, int)) );
			connect(this, SIGNAL(non_Cliquable(int)), plaque, SLOT(nonCliquable(int)) );
			if(j==2) {
				connect( plaque, SIGNAL(valeur(int,int)), this, SLOT(gestionPlaque(int,int)) );
			}
		}
		
		WidgetOperation *operation = new WidgetOperation( grilleCalcul, 400+i, 0, false);
		connect(this, SIGNAL(changePlaque(int, int)), operation, SLOT(changeOperation(int, int)) );
		grilleCalculLayout->addWidget(operation, i, 1);
		
		QLabel *labelEgal = new QLabel( grilleCalcul );
		labelEgal->setPixmap( *pixEgal );
		labelEgal->setFixedSize( 32, 32 );
		labelEgal->setAlignment( Qt::AlignHCenter );
		grilleCalculLayout->addWidget(labelEgal , i, 3);
	}
	
	//ordre des trois principaux lments du widget de rsolution
	vbox_Layout->addWidget(hbox_oper);
	vbox_Layout->addWidget(grilleCalcul);
	vbox_Layout->addWidget(hbox_nett);
	
	//initialisation de la position
	position=100;
	x=1; y=1;
	total.assign(7,0);
	a.assign(7,0);
	b.assign(7,0);
	c.assign(7,0);

	//initialisation du vecteur des antcdents
	antecedents.assign(115,-1);
	
	//par dfaut, le module de rsolution est bloqu
}

//une plaque ou une opration de valeur val a t clique
//pour ne pas confondre plaque et opration, les oprations ont pour valeur 501, 502, 503 et 504
void WidgetResolution::gestionPlaque(int numW, int val) {
	if(bloque) return;
	if(val>=501 && val <=504) {
		//clic sur une opration
		if(y==2) {
			emit changePlaque(399+x, val-500);
			b[x]=val-500;
			y++;
		} else
		if(y==3) {
			//une plaque est attendue, on modifie l'opration de la ligne en cours
			emit changePlaque(399+x, val-500);
			b[x]=val-500;
		} else
		if(y==1 && x>1) {
			//convention : on utilise automatiquement le rsultat de la ligne prcdente
			a[x]=total[x-1];
			position--;
			emit changeEtat(position, 3);
			position++;
			emit changePlaque(position, total[x-1]);
			emit changeEtat(position, 3);
			antecedents[position]=position-1;
			position++;
			emit changePlaque(399+x, val-500);
			b[x]=val-500;
			y += 2;
		}
	} else  {
		//calcul du rsultat de ligne et vrification d'opration autorise
		//cette vrification est ncessaire avant de changer la plaque
		if(y==3) {
			c[x]=val;
			if(b[x]==WidgetOperation::Plus) {
				total[x] = a[x] + c[x];
			} else
			if(b[x]==WidgetOperation::Moins) {
				total[x] = a[x] - c[x];
				if(total[x]<=0) { //opration interdite
					emit changeEtat(numW, 0);
					return;
				}
			} else
			if(b[x]==WidgetOperation::Fois) {
				total[x] = a[x] * c[x];
			} else
			if(b[x]==WidgetOperation::Divise) {
				total[x] = a[x] / c[x];
				if(a[x]%c[x] != 0){ //opration interdite
					emit changeEtat(numW, 0);
					return;
				}
			}
		}
		
		//changement de la plaque en cours
		if(y==1 || y==3) {
			antecedents[position]=numW;
			//on change la plaque en cours de la grille
			emit changePlaque(position, val);
			emit changeEtat(position, 3);
			position++;
			if(position==115) position=100;
			if(y==1) a[x]=val;
			//if(y==3) c=val; //note : dj effectu ci-dessus
		} else
		if(y==2) {
			//une opration est attendue donc on change la plaque prcdente
			emit changeEtat(antecedents[position-1], 0);	//on dgrise l'antcdent de l'ancienne plaque
			antecedents[position-1]=numW;
			emit changePlaque(position-1, val);
			a[x]=val;
		}
		
		//incrmentation de y et changement de la plaque de fin de ligne
		if(y==1) {
			y++;
		} else
		if(y==3) {
			emit changePlaque(position, total[x]);
			emit changeEtat(position, 0);
			y=1; x++;
			position++;
		}
		
		//le bon compte est trouv
		if(total[x-1]==cible.first || total[x-1]==cible.second){
			changeEtat(position-1, 2);
			emit la_victoire();
		}
	}
}

//efface toutes les plaques
void WidgetResolution::init() {
	int i;
	
	//efface les plaques normales
	for(i=0; i<15; i++) {
		emit changePlaque(100+i, 0);
		emit changeEtat(100+i, 4);
		antecedents[100+i]=-1;
	}
	
	//efface les plaques d'opration
	for(i=0; i<5; i++) {
		emit changePlaque(400+i, 0);
	}
	
	//rend blanches et cliquables les plaques du tirage
	for(int i=0;i<6;i++){
		emit changeEtat(i,0);
	}
	
	//remet tous les compteurs de position  leurs valeurs initiales
	position=100;
	x=1; y=1;
	total.assign(7,0);
	a.assign(7,0);
	b.assign(7,0);
	c.assign(7,0);
}

void WidgetResolution::gomme() {
	if(bloque) return;
	if(y==1) {
		if(position==100) return; //rien  faire
		//on efface le rsultat de la ligne prcdente et la plaque prcdente
		position--;
		emit changePlaque(position, 0);
		emit changeEtat(position, 4);
		position--;
		emit changeEtat(antecedents[position], 0);
		antecedents[position]=-1;
		emit changePlaque(position, 0);
		emit changeEtat(position, 4);
		y=3;
		x--;
	} else
	if(y==2) {
		//on est en attente d'une plaque d'opration
		//on efface donc la plaque normale prcdente
		position--;
		y--;
		emit changeEtat(antecedents[position], 0);
		antecedents[position]=-1;
		emit changePlaque(position, 0);
		emit changeEtat(position, 4);
	} else
	if(y==3) {
		//on efface la plaque d'opration
		emit changePlaque(399+x, 0);
		y--;
	}
}

//fonction pour bloquer/dbloquer le module de rsolution
void WidgetResolution::bloque_le_module(bool blocage){
	if(blocage){
		bloque=true;
	} else {
		bloque=false;
	}
	//bloque les ventuelles plaques blanches du tableau de rsolution
	for(int i=0; i<15; i++) {
		emit non_Cliquable(100+i);
	}
}
