/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2007-2014 Jean-Pierre Charras, jp.charras at wanadoo.fr
 * Copyright (C) 1992-2016 KiCad Developers, see AUTHORS.txt for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

/**
 * @file pcbnew/hotkeys.h
 * Pcbnew hotkeys
 */
#ifndef _PCBNEW_HOTKEYS_H
#define _PCBNEW_HOTKEYS_H

#include <hotkeys_basic.h>

// List of hot keys id.
// see also enum common_hotkey_id_commnand in hotkeys_basic.h
// for shared hotkeys id
enum hotkey_id_commnand {
    HK_DELETE = HK_COMMON_END,
    HK_BACK_SPACE,
    HK_ROTATE_ITEM,
    HK_ROTATE_ITEM_CLOCKWISE,
    HK_FLIP_ITEM,
    HK_COPY_ITEM,
    HK_MOVE_ITEM,
    HK_MOVE_ITEM_EXACT,
    HK_POSITION_RELATIVE,
    HK_DRAG_ITEM,
    HK_GET_AND_MOVE_FOOTPRINT,
    HK_LOCK_UNLOCK_FOOTPRINT,
    HK_ADD_NEW_TRACK,
    HK_ROUTE_DIFF_PAIR,
    HK_ROUTE_TUNE_SINGLE,
    HK_ROUTE_TUNE_DIFF_PAIR,
    HK_ROUTE_TUNE_SKEW,
    HK_ROUTE_TUNE_SETTINGS,
    HK_ROUTE_TUNE_INCREASE_SPACING,
    HK_ROUTE_TUNE_DECREASE_SPACING,
    HK_ROUTE_TUNE_INCREASE_AMP,
    HK_ROUTE_TUNE_DECREASE_AMP,
    HK_ADD_THROUGH_VIA,
    HK_SEL_LAYER_AND_ADD_THROUGH_VIA,
    HK_ADD_BLIND_BURIED_VIA,
    HK_SEL_LAYER_AND_ADD_BLIND_BURIED_VIA,
    HK_ADD_MICROVIA,
    HK_SWITCH_TRACK_POSTURE,
    HK_DRAG_TRACK_KEEP_SLOPE,
    HK_SWITCH_UNITS,
    HK_SWITCH_TRACK_DISPLAY_MODE,
    HK_3D_VIEWER,
    HK_FIND_ITEM,
    HK_EDIT_ITEM,
    HK_EDIT_MODULE_WITH_MODEDIT,
    HK_DUPLICATE_ITEM,
    HK_DUPLICATE_ITEM_AND_INCREMENT,
    HK_CREATE_ARRAY,
    HK_PLACE_ITEM,
    HK_SWITCH_TRACK_WIDTH_TO_NEXT,
    HK_SWITCH_TRACK_WIDTH_TO_PREVIOUS,
    HK_SWITCH_GRID_TO_FASTGRID1,
    HK_SWITCH_GRID_TO_FASTGRID2,
    HK_SWITCH_GRID_TO_NEXT,
    HK_SWITCH_GRID_TO_PREVIOUS,
    HK_SWITCH_LAYER_TO_COPPER,
    HK_SWITCH_LAYER_TO_COMPONENT,
    HK_SWITCH_LAYER_TO_NEXT,
    HK_SWITCH_LAYER_TO_PREVIOUS,
    HK_SWITCH_LAYER_TO_INNER1,
    HK_SWITCH_LAYER_TO_INNER2,
    HK_SWITCH_LAYER_TO_INNER3,
    HK_SWITCH_LAYER_TO_INNER4,
    HK_SWITCH_LAYER_TO_INNER5,
    HK_SWITCH_LAYER_TO_INNER6,
    HK_SWITCH_LAYER_TO_INNER7,
    HK_SWITCH_LAYER_TO_INNER8,
    HK_SWITCH_LAYER_TO_INNER9,
    HK_SWITCH_LAYER_TO_INNER10,
    HK_SWITCH_LAYER_TO_INNER11,
    HK_SWITCH_LAYER_TO_INNER12,
    HK_SWITCH_LAYER_TO_INNER13,
    HK_SWITCH_LAYER_TO_INNER14,
    HK_ADD_MODULE,
    HK_ADD_LINE,
    HK_ADD_POLYGON,
    HK_ADD_CIRCLE,
    HK_ADD_ARC,
    HK_ADD_TEXT,
    HK_ADD_DIMENSION,
    HK_ADD_ZONE,
    HK_ADD_FREE_VIA,
    HK_ADD_KEEPOUT,
    HK_ADD_CUTOUT,
    HK_ADD_SIMILAR_ZONE,
    HK_ADD_DXF,
    HK_ADD_ANCHOR,
    HK_INC_LINE_WIDTH,
    HK_DEC_LINE_WIDTH,
    HK_SWITCH_HIGHCONTRAST_MODE,
    HK_HIGHCONTRAST_INC,
    HK_HIGHCONTRAST_DEC,
    HK_CANVAS_LEGACY,
    HK_CANVAS_OPENGL,
    HK_CANVAS_CAIRO,
    HK_LEFT_CLICK,
    HK_LEFT_DCLICK,
    HK_ZONE_FILL_OR_REFILL,
    HK_ZONE_REMOVE_FILLED,
    HK_INC_LAYER_ALPHA,
    HK_DEC_LAYER_ALPHA,
    HK_SEL_TRIVIAL_CONNECTION,
    HK_SEL_COPPER_CONNECTION,
    HK_ROUTING_OPTIONS,
    HK_CUSTOM_TRACK_WIDTH,
    HK_DP_DIMENSIONS,
    HK_VIA_SIZE_INC,
    HK_VIA_SIZE_DEC,
    HK_HIGHLIGHT_NET_SELECTION,
    HK_INSERT_CORNER
};

// Full list of hotkey descriptors for board editor and footprint editor
extern struct EDA_HOTKEY_CONFIG g_Pcbnew_Editor_Hotkeys_Descr[];

// List of hotkey descriptors for the board editor only
extern struct EDA_HOTKEY_CONFIG g_Board_Editor_Hotkeys_Descr[];

// List of hotkey descriptors for the footprint editor only
extern struct EDA_HOTKEY_CONFIG g_Module_Editor_Hotkeys_Descr[];

// List of hotkey descriptors for the footprint editor only
extern struct EDA_HOTKEY_CONFIG g_Module_Viewer_Hotkeys_Descr[];

// List of common hotkey descriptors
// used in hotkeys_board_editor.cpp and hotkeys_module_editor.cpp
extern EDA_HOTKEY* common_Hotkey_List[];

// List of hotkey descriptors for pcbnew
// used in hotkeys_board_editor.cpp
extern EDA_HOTKEY* board_edit_Hotkey_List[];

// List of hotkey descriptors for the module editor
// used in hotkeys_module_editor.cpp
extern EDA_HOTKEY* module_edit_Hotkey_List[];


#endif /* _PCBNEW_HOTKEYS_H_ */
