/*
 * File    : FillInBlanksOptionsPanel.java
 * Created : 25-jun-2003 17:48
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.activities.text;

import edu.xtec.util.Options;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 1.0
 */
public class FillInBlanksCheckPanel extends javax.swing.JPanel {
    
    Options options;
    BasicEvaluatorPanel basicPanel;
    ComplexEvaluatorPanel complexPanel;    
    CheckOptionsPanel optionsPanel;
    
    /** Creates new form FillInBlanksOptionsPanel */
    public FillInBlanksCheckPanel(Options options) {
        this.options=options;
        initComponents();
        optionsPanel=(CheckOptionsPanel)m_optionsPanel;
        basicPanel=(BasicEvaluatorPanel)m_basicPanel;
        complexPanel=(ComplexEvaluatorPanel)m_complexPanel;    
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        m_optionsPanel = new CheckOptionsPanel(options);
        m_basicPanel = new BasicEvaluatorPanel(options);
        progressPanel = new javax.swing.JPanel();
        autoJumpChk = new javax.swing.JCheckBox();
        forceOkChk = new javax.swing.JCheckBox();
        m_complexPanel = new ComplexEvaluatorPanel(options);

        setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(m_optionsPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(m_basicPanel, gridBagConstraints);

        progressPanel.setLayout(new java.awt.GridBagLayout());

        progressPanel.setBorder(new javax.swing.border.TitledBorder(options.getMsg("edit_text_act_checkProgress")));
        autoJumpChk.setText(options.getMsg("edit_text_act_checkAutoJump"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        progressPanel.add(autoJumpChk, gridBagConstraints);

        forceOkChk.setText(options.getMsg("edit_text_act_checkForceOk"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        progressPanel.add(forceOkChk, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(progressPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(m_complexPanel, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    public void setOptions(FillInBlanks fib){
        autoJumpChk.setSelected(fib.autoJump);
        forceOkChk.setSelected(fib.forceOkToAdvance);
        optionsPanel.setOptions(fib);
        if(fib.ev instanceof BasicEvaluator)
            basicPanel.setEvaluator((BasicEvaluator)fib.ev);
        if(fib.ev instanceof ComplexEvaluator)
            complexPanel.setEvaluator((ComplexEvaluator)fib.ev);        
    }
    
    public void collectData(FillInBlanks fib){
        fib.autoJump=autoJumpChk.isSelected();
        fib.forceOkToAdvance=forceOkChk.isSelected();
        optionsPanel.collectData(fib);
        if(fib.ev instanceof BasicEvaluator)
            basicPanel.collectData((BasicEvaluator)fib.ev);
        if(fib.ev instanceof ComplexEvaluator)
            complexPanel.collectData((ComplexEvaluator)fib.ev);
    }    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel m_basicPanel;
    private javax.swing.JCheckBox autoJumpChk;
    private javax.swing.JCheckBox forceOkChk;
    private javax.swing.JPanel m_complexPanel;
    private javax.swing.JPanel m_optionsPanel;
    private javax.swing.JPanel progressPanel;
    // End of variables declaration//GEN-END:variables
    
}
