# CHRTAB -- Table of strokes for the printable ASCII characters.  Each
# character is encoded as a series of strokes.  Each stroke is ex-
# pressed by a single integer containing the following bitfields:
#
#       2                   1
#       0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1
#                 | | | |         | |         |
#                 | | | +---------+ +---------+
#                 | | |      |           |
#                 | | |      X           Y
#                 | | |
#                 | | +-- pen up/down
#                 | +---- begin paint (not used at present)
#                 +------ end paint (not used at present)
#
#----------------------------------------------------------------------------

# Define the database.

short   chridx[97]	# character index in chrtab
short   chrwid[97]	# character width table
short   chrtab[3363]	# stroke data to draw the characters

# Index into CHRTAB of each printable character (starting with SP)

data    (chridx(i), i=001,005) /    1,    3,   32,   49,   58/
data    (chridx(i), i=006,010) /  110,  140,  207,  228,  253/
data    (chridx(i), i=011,015) /  278,  309,  322,  343,  350/
data    (chridx(i), i=016,020) /  365,  372,  418,  438,  494/
data    (chridx(i), i=021,025) /  563,  583,  632,  696,  733/
data    (chridx(i), i=026,030) /  803,  867,  896,  931,  935/
data    (chridx(i), i=031,035) /  948,  952,  999, 1052, 1077/
data    (chridx(i), i=036,040) / 1139, 1174, 1223, 1281, 1330/
data    (chridx(i), i=041,045) / 1381, 1436, 1463, 1500, 1547/
data    (chridx(i), i=046,050) / 1583, 1626, 1653, 1703, 1748/
data    (chridx(i), i=051,055) / 1818, 1881, 1923, 1962, 1997/
data    (chridx(i), i=056,060) / 2021, 2060, 2097, 2131, 2160/
data    (chridx(i), i=061,065) / 2169, 2172, 2181, 2190, 2193/
data    (chridx(i), i=066,070) / 2214, 2263, 2303, 2335, 2378/
data    (chridx(i), i=071,075) / 2415, 2447, 2527, 2575, 2606/
data    (chridx(i), i=076,080) / 2640, 2682, 2704, 2778, 2826/
data    (chridx(i), i=081,085) / 2868, 2916, 2961, 2994, 3033/
data    (chridx(i), i=086,090) / 3052, 3086, 3108, 3140, 3173/
data    (chridx(i), i=091,095) / 3204, 3233, 3271, 3274, 3312/
data    (chridx(i), i=096,096) / 3335/


# Width data.

data    (chrwid(i), i=001,005) /   21,   16,   23,   26,   25/
data    (chrwid(i), i=006,010) /   29,   31,   16,   19,   19/
data    (chrwid(i), i=011,015) /   21,   30,   16,   30,   16/
data    (chrwid(i), i=016,020) /   28,   25,   25,   25,   25/
data    (chrwid(i), i=021,025) /   25,   25,   25,   25,   25/
data    (chrwid(i), i=026,030) /   25,   16,   16,   29,   30/
data    (chrwid(i), i=031,035) /   29,   24,   32,   25,   27/
data    (chrwid(i), i=036,040) /   26,   27,   26,   25,   28/
data    (chrwid(i), i=041,045) /   29,   17,   21,   27,   23/
data    (chrwid(i), i=046,050) /   31,   29,   27,   27,   27/
data    (chrwid(i), i=051,055) /   27,   25,   25,   29,   25/
data    (chrwid(i), i=056,060) /   29,   25,   27,   25,   19/
data    (chrwid(i), i=061,065) /   19,   19,   21,   21,   16/
data    (chrwid(i), i=066,070) /   25,   26,   24,   26,   24/
data    (chrwid(i), i=071,075) /   19,   24,   28,   17,   18/
data    (chrwid(i), i=076,080) /   27,   17,   32,   28,   25/
data    (chrwid(i), i=081,085) /   26,   25,   22,   22,   20/
data    (chrwid(i), i=086,090) /   28,   23,   29,   25,   24/
data    (chrwid(i), i=091,095) /   23,   19,   13,   19,   29/
data    (chrwid(i), i=096,096) /   19/


# Stroke data.

data    (chrtab(i), i=0001,0005) /    35,     0,   220,  4251,  4249/
data    (chrtab(i), i=0006,0010) /  4305,   220,  4302,  4366,   220/
data    (chrtab(i), i=0011,0015) /  4380,  4366,   284,  4443,  4441/
data    (chrtab(i), i=0016,0020) /  4369,   202,  4233,  4232,  4295/
data    (chrtab(i), i=0021,0025) /  4359,  4424,  4425,  4362,  4298/
data    (chrtab(i), i=0026,0030) /   201,  4296,  4360,  4361,  4297/
data    (chrtab(i), i=0031,0035) /     0,   220,  4251,  4245,   219/
data    (chrtab(i), i=0036,0040) /  4245,   220,  4379,  4245,   796/
data    (chrtab(i), i=0041,0045) /  4827,  4821,   795,  4821,   796/
data    (chrtab(i), i=0046,0050) /  4955,  4821,     0,   604,  4224/
data    (chrtab(i), i=0051,0055) /   988,  4608,   145,  5137,    75/
data    (chrtab(i), i=0056,0060) /  5067,     0,   416,  4483,   672/
data    (chrtab(i), i=0061,0065) /  4739,   919,  5016,  4952,  4950/
data    (chrtab(i), i=0066,0070) /  5078,  5080,  5018,  4955,  4764/
data    (chrtab(i), i=0071,0075) /  4508,  4315,  4185,  4182,  4244/
data    (chrtab(i), i=0076,0080) /  4434,  4816,  4943,  5005,  5002/
data    (chrtab(i), i=0081,0085) /  4936,   150,  4308,  4435,  4817/
data    (chrtab(i), i=0086,0090) /  4944,  5006,   219,  4249,  4247/
data    (chrtab(i), i=0091,0095) /  4309,  4436,  4818,  5008,  5070/
data    (chrtab(i), i=0096,0100) /  5067,  5001,  4936,  4743,  4487/
data    (chrtab(i), i=0101,0105) /  4296,  4233,  4171,  4173,  4301/
data    (chrtab(i), i=0106,0110) /  4299,  4235,  4236,     0,  1244/
data    (chrtab(i), i=0111,0115) /  4167,   412,  4634,  4632,  4566/
data    (chrtab(i), i=0116,0120) /  4437,  4309,  4183,  4185,  4251/
data    (chrtab(i), i=0121,0125) /  4380,  4508,  4635,  4826,  5018/
data    (chrtab(i), i=0126,0130) /  5211,  5340,   974,  4941,  4875/
data    (chrtab(i), i=0131,0135) /  4873,  4999,  5127,  5256,  5322/
data    (chrtab(i), i=0136,0140) /  5324,  5198,  5070,     0,  1299/
data    (chrtab(i), i=0141,0145) /  5396,  5332,  5330,  5458,  5460/
data    (chrtab(i), i=0146,0150) /  5397,  5333,  5268,  5202,  5069/
data    (chrtab(i), i=0151,0155) /  4938,  4808,  4679,  4423,  4296/
data    (chrtab(i), i=0156,0160) /  4234,  4237,  4303,  4691,  4821/
data    (chrtab(i), i=0161,0165) /  4887,  4889,  4827,  4700,  4571/
data    (chrtab(i), i=0166,0170) /  4505,  4502,  4563,  4688,  4939/
data    (chrtab(i), i=0171,0175) /  5128,  5255,  5383,  5449,  5450/
data    (chrtab(i), i=0176,0180) /   264,  4298,  4301,  4367,  4432/
data    (chrtab(i), i=0181,0185) /   725,  4889,   791,  4827,   475/
data    (chrtab(i), i=0186,0190) /  4503,   468,  4689,  4940,  5129/
data    (chrtab(i), i=0191,0195) /  5256,   455,  4424,  4362,  4365/
data    (chrtab(i), i=0196,0200) /  4431,  4691,   409,  4565,  4753/
data    (chrtab(i), i=0201,0205) /  5004,  5193,  5320,  5384,  5449/
data    (chrtab(i), i=0206,0210) /     0,   346,  4377,  4313,  4250/
data    (chrtab(i), i=0211,0215) /  4251,  4316,  4380,  4443,  4440/
data    (chrtab(i), i=0216,0220) /  4374,  4245,   219,  4314,  4378/
data    (chrtab(i), i=0221,0225) /  4379,  4315,   281,  4440,   346/
data    (chrtab(i), i=0226,0230) /  4374,     0,   544,  4510,  4379/
data    (chrtab(i), i=0231,0235) /  4247,  4178,  4174,  4233,  4357/
data    (chrtab(i), i=0236,0240) /  4482,  4608,   282,  4311,  4243/
data    (chrtab(i), i=0241,0245) /  4237,  4297,  4358,   414,  4444/
data    (chrtab(i), i=0246,0250) /  4377,  4307,  4301,  4359,  4420/
data    (chrtab(i), i=0251,0255) /  4482,     0,   160,  4382,  4507/
data    (chrtab(i), i=0256,0260) /  4631,  4690,  4686,  4617,  4485/
data    (chrtab(i), i=0261,0265) /  4354,  4224,   410,  4567,  4627/
data    (chrtab(i), i=0266,0270) /  4621,  4553,  4486,   286,  4444/
data    (chrtab(i), i=0271,0275) /  4505,  4563,  4557,  4487,  4420/
data    (chrtab(i), i=0276,0280) /  4354,     0,   412,  4443,  4561/
data    (chrtab(i), i=0281,0285) /  4496,   412,  4496,   412,  4571/
data    (chrtab(i), i=0286,0290) /  4433,  4496,    89,  4249,  4755/
data    (chrtab(i), i=0291,0295) /  4819,    89,  4819,    89,  4184/
data    (chrtab(i), i=0296,0300) /  4820,  4819,   729,  4761,  4243/
data    (chrtab(i), i=0301,0305) /  4179,   729,  4179,   729,  4824/
data    (chrtab(i), i=0306,0310) /  4180,  4179,     0,   665,  4744/
data    (chrtab(i), i=0311,0315) /  4808,   665,  4825,  4808,   145/
data    (chrtab(i), i=0316,0320) /  5329,  5328,   145,  4240,  5328/
data    (chrtab(i), i=0321,0325) /     0,   328,  4359,  4295,  4232/
data    (chrtab(i), i=0326,0330) /  4233,  4298,  4362,  4425,  4422/
data    (chrtab(i), i=0331,0335) /  4356,  4227,   201,  4296,  4360/
data    (chrtab(i), i=0336,0340) /  4361,  4297,   263,  4422,   328/
data    (chrtab(i), i=0341,0345) /  4356,     0,   145,  5329,  5328/
data    (chrtab(i), i=0346,0350) /   145,  4240,  5328,     0,   202/
data    (chrtab(i), i=0351,0355) /  4233,  4232,  4295,  4359,  4424/
data    (chrtab(i), i=0356,0360) /  4425,  4362,  4298,   201,  4296/
data    (chrtab(i), i=0361,0365) /  4360,  4361,  4297,     0,  1184/
data    (chrtab(i), i=0366,0370) /  4096,  4160,  1184,  5344,  4160/
data    (chrtab(i), i=0371,0375) /     0,   476,  4379,  4248,  4179/
data    (chrtab(i), i=0376,0380) /  4176,  4235,  4360,  4551,  4679/
data    (chrtab(i), i=0381,0385) /  4872,  5003,  5072,  5075,  5016/
data    (chrtab(i), i=0386,0390) /  4891,  4700,  4572,   282,  4312/
data    (chrtab(i), i=0391,0395) /  4244,  4239,  4299,  4361,   777/
data    (chrtab(i), i=0396,0400) /  4939,  5007,  5012,  4952,  4890/
data    (chrtab(i), i=0401,0405) /   476,  4443,  4377,  4308,  4303/
data    (chrtab(i), i=0406,0410) /  4362,  4424,  4551,   583,  4808/
data    (chrtab(i), i=0411,0415) /  4874,  4943,  4948,  4889,  4827/
data    (chrtab(i), i=0416,0420) /  4700,     0,   474,  4551,   538/
data    (chrtab(i), i=0421,0425) /  4616,   604,  4679,   604,  4505/
data    (chrtab(i), i=0426,0430) /  4376,   199,  4935,   456,  4423/
data    (chrtab(i), i=0431,0435) /   457,  4487,   585,  4743,   584/
data    (chrtab(i), i=0436,0440) /  4807,     0,   152,  4247,  4311/
data    (chrtab(i), i=0441,0445) /  4312,  4248,   153,  4313,  4376/
data    (chrtab(i), i=0446,0450) /  4375,  4310,  4246,  4183,  4184/
data    (chrtab(i), i=0451,0455) /  4250,  4315,  4508,  4764,  4955/
data    (chrtab(i), i=0456,0460) /  5018,  5080,  5078,  5012,  4818/
data    (chrtab(i), i=0461,0465) /  4496,  4367,  4237,  4170,  4167/
data    (chrtab(i), i=0466,0470) /   858,  5016,  5014,  4948,   668/
data    (chrtab(i), i=0471,0475) /  4891,  4952,  4950,  4884,  4754/
data    (chrtab(i), i=0476,0480) /  4496,    73,  4234,  4362,  4681/
data    (chrtab(i), i=0481,0485) /  4937,  5066,   266,  4680,  4936/
data    (chrtab(i), i=0486,0490) /  5001,   266,  4679,  4935,  5000/
data    (chrtab(i), i=0491,0495) /  5066,  5068,     0,   152,  4247/
data    (chrtab(i), i=0496,0500) /  4311,  4312,  4248,   153,  4313/
data    (chrtab(i), i=0501,0505) /  4376,  4375,  4310,  4246,  4183/
data    (chrtab(i), i=0506,0510) /  4184,  4250,  4315,  4508,  4764/
data    (chrtab(i), i=0511,0515) /  4955,  5017,  5014,  4948,  4755/
data    (chrtab(i), i=0516,0520) /   795,  4953,  4950,  4884,   604/
data    (chrtab(i), i=0521,0525) /  4827,  4889,  4886,  4820,  4691/
data    (chrtab(i), i=0526,0530) /   467,  4755,  4882,  5008,  5070/
data    (chrtab(i), i=0531,0535) /  5067,  5001,  4936,  4743,  4487/
data    (chrtab(i), i=0536,0540) /  4296,  4233,  4171,  4172,  4237/
data    (chrtab(i), i=0541,0545) /  4301,  4364,  4363,  4298,  4234/
data    (chrtab(i), i=0546,0550) /   848,  5006,  5003,  4937,   595/
data    (chrtab(i), i=0551,0555) /  4818,  4881,  4942,  4939,  4872/
data    (chrtab(i), i=0556,0560) /  4743,   140,  4235,  4299,  4300/
data    (chrtab(i), i=0561,0565) /  4236,     0,   601,  4679,   666/
data    (chrtab(i), i=0566,0570) /  4744,   732,  4807,   732,  4109/
data    (chrtab(i), i=0571,0575) /  5133,   391,  4999,   584,  4551/
data    (chrtab(i), i=0576,0580) /   585,  4615,   713,  4871,   712/
data    (chrtab(i), i=0581,0585) /  4935,     0,   220,  4178,  4308/
data    (chrtab(i), i=0586,0590) /  4501,  4693,  4884,  5010,  5071/
data    (chrtab(i), i=0591,0595) /  5069,  5002,  4872,  4679,  4487/
data    (chrtab(i), i=0596,0600) /  4296,  4233,  4171,  4172,  4237/
data    (chrtab(i), i=0601,0605) /  4301,  4364,  4363,  4298,  4234/
data    (chrtab(i), i=0606,0610) /   850,  5008,  5004,  4938,   597/
data    (chrtab(i), i=0611,0615) /  4820,  4883,  4944,  4940,  4873/
data    (chrtab(i), i=0616,0620) /  4808,  4679,   140,  4235,  4299/
data    (chrtab(i), i=0621,0625) /  4300,  4236,   220,  4956,   219/
data    (chrtab(i), i=0626,0630) /  4827,   218,  4570,  4827,  4956/
data    (chrtab(i), i=0631,0635) /     0,   793,  4888,  4952,  4953/
data    (chrtab(i), i=0636,0640) /  4889,   858,  4890,  4825,  4824/
data    (chrtab(i), i=0641,0645) /  4887,  4951,  5016,  5017,  4955/
data    (chrtab(i), i=0646,0650) /  4828,  4636,  4443,  4313,  4247/
data    (chrtab(i), i=0651,0655) /  4179,  4173,  4234,  4360,  4551/
data    (chrtab(i), i=0656,0660) /  4679,  4872,  5002,  5069,  5070/
data    (chrtab(i), i=0661,0665) /  5009,  4883,  4692,  4564,  4435/
data    (chrtab(i), i=0666,0670) /  4370,  4304,   281,  4311,  4243/
data    (chrtab(i), i=0671,0675) /  4237,  4298,  4361,   842,  5004/
data    (chrtab(i), i=0676,0680) /  5007,  4945,   540,  4507,  4442/
data    (chrtab(i), i=0681,0685) /  4376,  4308,  4301,  4362,  4424/
data    (chrtab(i), i=0686,0690) /  4551,   583,  4808,  4873,  4940/
data    (chrtab(i), i=0691,0695) /  4943,  4882,  4819,  4692,     0/
data    (chrtab(i), i=0696,0700) /    92,  4182,   988,  5081,  5014/
data    (chrtab(i), i=0701,0705) /  4753,  4687,  4619,  4615,   592/
data    (chrtab(i), i=0706,0710) /  4622,  4555,  4551,   918,  4689/
data    (chrtab(i), i=0711,0715) /  4558,  4491,  4487,  4615,    88/
data    (chrtab(i), i=0716,0720) /  4250,  4380,  4508,  4825,  4953/
data    (chrtab(i), i=0721,0725) /  5018,  5084,   218,  4379,  4507/
data    (chrtab(i), i=0726,0730) /  4634,    88,  4249,  4378,  4506/
data    (chrtab(i), i=0731,0735) /  4825,     0,   412,  4315,  4249/
data    (chrtab(i), i=0736,0740) /  4246,  4308,  4499,  4755,  4948/
data    (chrtab(i), i=0741,0745) /  5014,  5017,  4955,  4764,  4508/
data    (chrtab(i), i=0746,0750) /   283,  4313,  4310,  4372,   788/
data    (chrtab(i), i=0751,0755) /  4950,  4953,  4891,   412,  4443/
data    (chrtab(i), i=0756,0760) /  4377,  4374,  4436,  4499,   659/
data    (chrtab(i), i=0761,0765) /  4820,  4886,  4889,  4827,  4764/
data    (chrtab(i), i=0766,0770) /   403,  4306,  4241,  4175,  4171/
data    (chrtab(i), i=0771,0775) /  4233,  4296,  4487,  4743,  4936/
data    (chrtab(i), i=0776,0780) /  5001,  5067,  5071,  5009,  4946/
data    (chrtab(i), i=0781,0785) /  4755,   209,  4239,  4235,  4297/
data    (chrtab(i), i=0786,0790) /   841,  5003,  5007,  4945,   403/
data    (chrtab(i), i=0791,0795) /  4370,  4303,  4299,  4360,  4487/
data    (chrtab(i), i=0796,0800) /   647,  4872,  4939,  4943,  4882/
data    (chrtab(i), i=0801,0805) /  4755,     0,   203,  4298,  4362/
data    (chrtab(i), i=0806,0810) /  4363,  4299,   851,  4881,  4816/
data    (chrtab(i), i=0811,0815) /  4687,  4559,  4368,  4242,  4181/
data    (chrtab(i), i=0816,0820) /  4182,  4249,  4379,  4572,  4700/
data    (chrtab(i), i=0821,0825) /  4891,  5017,  5078,  5072,  5004/
data    (chrtab(i), i=0826,0830) /  4938,  4808,  4615,  4423,  4296/
data    (chrtab(i), i=0831,0835) /  4234,  4235,  4300,  4364,  4427/
data    (chrtab(i), i=0836,0840) /  4426,  4361,  4297,   210,  4244/
data    (chrtab(i), i=0841,0845) /  4247,  4313,   794,  4953,  5014/
data    (chrtab(i), i=0846,0850) /  5008,  4940,  4874,   463,  4432/
data    (chrtab(i), i=0851,0855) /  4369,  4308,  4311,  4378,  4443/
data    (chrtab(i), i=0856,0860) /  4572,   604,  4827,  4889,  4950/
data    (chrtab(i), i=0861,0865) /  4943,  4875,  4809,  4744,  4615/
data    (chrtab(i), i=0866,0870) /     0,   213,  4244,  4243,  4306/
data    (chrtab(i), i=0871,0875) /  4370,  4435,  4436,  4373,  4309/
data    (chrtab(i), i=0876,0880) /   212,  4307,  4371,  4372,  4308/
data    (chrtab(i), i=0881,0885) /   202,  4233,  4232,  4295,  4359/
data    (chrtab(i), i=0886,0890) /  4424,  4425,  4362,  4298,   201/
data    (chrtab(i), i=0891,0895) /  4296,  4360,  4361,  4297,     0/
data    (chrtab(i), i=0896,0900) /   213,  4244,  4243,  4306,  4370/
data    (chrtab(i), i=0901,0905) /  4435,  4436,  4373,  4309,   212/
data    (chrtab(i), i=0906,0910) /  4307,  4371,  4372,  4308,   328/
data    (chrtab(i), i=0911,0915) /  4359,  4295,  4232,  4233,  4298/
data    (chrtab(i), i=0916,0920) /  4362,  4425,  4422,  4356,  4227/
data    (chrtab(i), i=0921,0925) /   201,  4296,  4360,  4361,  4297/
data    (chrtab(i), i=0926,0930) /   263,  4422,   328,  4356,     0/
data    (chrtab(i), i=0931,0935) /  1177,  4240,  5255,     0,   149/
data    (chrtab(i), i=0936,0940) /  5333,  5332,   149,  4244,  5332/
data    (chrtab(i), i=0941,0945) /   141,  5325,  5324,   141,  4236/
data    (chrtab(i), i=0946,0950) /  5324,     0,   153,  5264,  4231/
data    (chrtab(i), i=0951,0955) /     0,   151,  4248,  4312,  4310/
data    (chrtab(i), i=0956,0960) /  4182,  4184,  4250,  4315,  4444/
data    (chrtab(i), i=0961,0965) /  4700,  4891,  4954,  5016,  5014/
data    (chrtab(i), i=0966,0970) /  4948,  4883,  4625,   794,  4953/
data    (chrtab(i), i=0971,0975) /  4949,  4884,   604,  4827,  4889/
data    (chrtab(i), i=0976,0980) /  4885,  4819,  4754,   465,  4558/
data    (chrtab(i), i=0981,0985) /  4622,  4625,  4561,   458,  4489/
data    (chrtab(i), i=0986,0990) /  4488,  4551,  4615,  4680,  4681/
data    (chrtab(i), i=0991,0995) /  4618,  4554,   457,  4552,  4616/
data    (chrtab(i), i=0996,1000) /  4617,  4553,     0,  1044,  5078/
data    (chrtab(i), i=1001,1005) /  4951,  4759,  4630,  4565,  4498/
data    (chrtab(i), i=1006,1010) /  4495,  4557,  4684,  4876,  5005/
data    (chrtab(i), i=1011,1015) /  5071,   663,  4629,  4562,  4559/
data    (chrtab(i), i=1016,1020) /  4621,  4684,  1047,  5071,  5069/
data    (chrtab(i), i=1021,1025) /  5196,  5324,  5454,  5521,  5523/
data    (chrtab(i), i=1026,1030) /  5462,  5400,  5274,  5147,  4956/
data    (chrtab(i), i=1031,1035) /  4764,  4571,  4442,  4312,  4246/
data    (chrtab(i), i=1036,1040) /  4179,  4176,  4237,  4299,  4425/
data    (chrtab(i), i=1041,1045) /  4552,  4743,  4935,  5128,  5257/
data    (chrtab(i), i=1046,1050) /  5322,  1111,  5135,  5133,  5196/
data    (chrtab(i), i=1051,1055) /     0,   540,  4168,   473,  4935/
data    (chrtab(i), i=1056,1060) /   537,  4999,   540,  5063,   205/
data    (chrtab(i), i=1061,1065) /  4877,     7,  4423,   647,  5191/
data    (chrtab(i), i=1066,1070) /    72,  4103,    72,  4295,   840/
data    (chrtab(i), i=1071,1075) /  4807,   841,  4871,   905,  5127/
data    (chrtab(i), i=1076,1080) /     0,   220,  4295,   283,  4360/
data    (chrtab(i), i=1081,1085) /   348,  4423,    28,  4892,  5083/
data    (chrtab(i), i=1086,1090) /  5146,  5208,  5206,  5140,  5075/
data    (chrtab(i), i=1091,1095) /  4882,   986,  5144,  5142,  5076/
data    (chrtab(i), i=1096,1100) /   796,  5019,  5081,  5077,  5011/
data    (chrtab(i), i=1101,1105) /  4882,   338,  4882,  5073,  5136/
data    (chrtab(i), i=1106,1110) /  5198,  5195,  5129,  5064,  4871/
data    (chrtab(i), i=1111,1115) /  4103,   976,  5134,  5131,  5065/
data    (chrtab(i), i=1116,1120) /   786,  5009,  5071,  5066,  5000/
data    (chrtab(i), i=1121,1125) /  4871,    92,  4315,   156,  4314/
data    (chrtab(i), i=1126,1130) /   412,  4442,   476,  4443,   200/
data    (chrtab(i), i=1131,1135) /  4167,   201,  4231,   329,  4487/
data    (chrtab(i), i=1136,1140) /   328,  4551,     0,   985,  5148/
data    (chrtab(i), i=1141,1145) /  5142,  5081,  4955,  4828,  4636/
data    (chrtab(i), i=1146,1150) /  4443,  4313,  4247,  4180,  4175/
data    (chrtab(i), i=1151,1155) /  4236,  4298,  4424,  4615,  4807/
data    (chrtab(i), i=1156,1160) /  4936,  5066,  5132,   281,  4311/
data    (chrtab(i), i=1161,1165) /  4244,  4239,  4300,  4362,   540/
data    (chrtab(i), i=1166,1170) /  4507,  4376,  4308,  4303,  4363/
data    (chrtab(i), i=1171,1175) /  4488,  4615,     0,   220,  4295/
data    (chrtab(i), i=1176,1180) /   283,  4360,   348,  4423,    28/
data    (chrtab(i), i=1181,1185) /  4764,  4955,  5081,  5143,  5204/
data    (chrtab(i), i=1186,1190) /  5199,  5132,  5066,  4936,  4743/
data    (chrtab(i), i=1191,1195) /  4103,   921,  5079,  5140,  5135/
data    (chrtab(i), i=1196,1200) /  5068,  5002,   668,  4891,  5016/
data    (chrtab(i), i=1201,1205) /  5076,  5071,  5003,  4872,  4743/
data    (chrtab(i), i=1206,1210) /    92,  4315,   156,  4314,   412/
data    (chrtab(i), i=1211,1215) /  4442,   476,  4443,   200,  4167/
data    (chrtab(i), i=1216,1220) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=1221,1225) /  4551,     0,   220,  4295,   283/
data    (chrtab(i), i=1226,1230) /  4360,   348,  4423,    28,  5148/
data    (chrtab(i), i=1231,1235) /  5142,   338,  4818,   726,  4814/
data    (chrtab(i), i=1236,1240) /     7,  5127,  5133,    92,  4315/
data    (chrtab(i), i=1241,1245) /   156,  4314,   412,  4442,   476/
data    (chrtab(i), i=1246,1250) /  4443,   732,  5147,   860,  5146/
data    (chrtab(i), i=1251,1255) /   924,  5145,   988,  5142,   726/
data    (chrtab(i), i=1256,1260) /  4754,  4814,   724,  4690,  4816/
data    (chrtab(i), i=1261,1265) /   723,  4562,  4817,   200,  4167/
data    (chrtab(i), i=1266,1270) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=1271,1275) /  4551,   711,  5128,   839,  5129/
data    (chrtab(i), i=1276,1280) /   903,  5130,   967,  5133,     0/
data    (chrtab(i), i=1281,1285) /   220,  4295,   283,  4360,   348/
data    (chrtab(i), i=1286,1290) /  4423,    28,  5148,  5142,   338/
data    (chrtab(i), i=1291,1295) /  4818,   726,  4814,     7,  4615/
data    (chrtab(i), i=1296,1300) /    92,  4315,   156,  4314,   412/
data    (chrtab(i), i=1301,1305) /  4442,   476,  4443,   732,  5147/
data    (chrtab(i), i=1306,1310) /   860,  5146,   924,  5145,   988/
data    (chrtab(i), i=1311,1315) /  5142,   726,  4754,  4814,   724/
data    (chrtab(i), i=1316,1320) /  4690,  4816,   723,  4562,  4817/
data    (chrtab(i), i=1321,1325) /   200,  4167,   201,  4231,   329/
data    (chrtab(i), i=1326,1330) /  4487,   328,  4551,     0,   985/
data    (chrtab(i), i=1331,1335) /  5148,  5142,  5081,  4955,  4828/
data    (chrtab(i), i=1336,1340) /  4636,  4443,  4313,  4247,  4180/
data    (chrtab(i), i=1341,1345) /  4175,  4236,  4298,  4424,  4615/
data    (chrtab(i), i=1346,1350) /  4807,  4936,  5064,  5127,  5135/
data    (chrtab(i), i=1351,1355) /   281,  4311,  4244,  4239,  4300/
data    (chrtab(i), i=1356,1360) /  4362,   540,  4507,  4376,  4308/
data    (chrtab(i), i=1361,1365) /  4303,  4363,  4488,  4615,   974/
data    (chrtab(i), i=1366,1370) /  5065,   911,  5001,  4936,   719/
data    (chrtab(i), i=1371,1375) /  5327,   783,  5006,   847,  5005/
data    (chrtab(i), i=1376,1380) /  1103,  5133,  1167,  5134,     0/
data    (chrtab(i), i=1381,1385) /   220,  4295,   283,  4360,   348/
data    (chrtab(i), i=1386,1390) /  4423,   988,  5063,  1051,  5128/
data    (chrtab(i), i=1391,1395) /  1116,  5191,    28,  4636,   796/
data    (chrtab(i), i=1396,1400) /  5404,   338,  5074,     7,  4615/
data    (chrtab(i), i=1401,1405) /   775,  5383,    92,  4315,   156/
data    (chrtab(i), i=1406,1410) /  4314,   412,  4442,   476,  4443/
data    (chrtab(i), i=1411,1415) /   860,  5083,   924,  5082,  1180/
data    (chrtab(i), i=1416,1420) /  5210,  1244,  5211,   200,  4167/
data    (chrtab(i), i=1421,1425) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=1426,1430) /  4551,   968,  4935,   969,  4999/
data    (chrtab(i), i=1431,1435) /  1097,  5255,  1096,  5319,     0/
data    (chrtab(i), i=1436,1440) /   220,  4295,   283,  4360,   348/
data    (chrtab(i), i=1441,1445) /  4423,    28,  4636,     7,  4615/
data    (chrtab(i), i=1446,1450) /    92,  4315,   156,  4314,   412/
data    (chrtab(i), i=1451,1455) /  4442,   476,  4443,   200,  4167/
data    (chrtab(i), i=1456,1460) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=1461,1465) /  4551,     0,   476,  4555,  4488/
data    (chrtab(i), i=1466,1470) /  4423,   539,  4619,  4552,   604/
data    (chrtab(i), i=1471,1475) /  4683,  4616,  4423,  4295,  4168/
data    (chrtab(i), i=1476,1480) /  4106,  4108,  4173,  4237,  4300/
data    (chrtab(i), i=1481,1485) /  4299,  4234,  4170,    76,  4171/
data    (chrtab(i), i=1486,1490) /  4235,  4236,  4172,   284,  4892/
data    (chrtab(i), i=1491,1495) /   348,  4571,   412,  4570,   668/
data    (chrtab(i), i=1496,1500) /  4698,   732,  4699,     0,   220/
data    (chrtab(i), i=1501,1505) /  4295,   283,  4360,   348,  4423/
data    (chrtab(i), i=1506,1510) /  1051,  4432,   530,  5063,   594/
data    (chrtab(i), i=1511,1515) /  5127,   596,  5191,    28,  4636/
data    (chrtab(i), i=1516,1520) /   860,  5340,     7,  4615,   775/
data    (chrtab(i), i=1521,1525) /  5319,    92,  4315,   156,  4314/
data    (chrtab(i), i=1526,1530) /   412,  4442,   476,  4443,   988/
data    (chrtab(i), i=1531,1535) /  5147,  1180,  5147,   200,  4167/
data    (chrtab(i), i=1536,1540) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=1541,1545) /  4551,   969,  4935,   969,  5255/
data    (chrtab(i), i=1546,1550) /     0,   220,  4295,   283,  4360/
data    (chrtab(i), i=1551,1555) /   348,  4423,    28,  4636,     7/
data    (chrtab(i), i=1556,1560) /  5063,  5069,    92,  4315,   156/
data    (chrtab(i), i=1561,1565) /  4314,   412,  4442,   476,  4443/
data    (chrtab(i), i=1566,1570) /   200,  4167,   201,  4231,   329/
data    (chrtab(i), i=1571,1575) /  4487,   328,  4551,   647,  5064/
data    (chrtab(i), i=1576,1580) /   775,  5065,   839,  5066,   903/
data    (chrtab(i), i=1581,1585) /  5069,     0,   220,  4296,   220/
data    (chrtab(i), i=1586,1590) /  4743,   284,  4746,   348,  4810/
data    (chrtab(i), i=1591,1595) /  1116,  4743,  1116,  5191,  1179/
data    (chrtab(i), i=1596,1600) /  5256,  1244,  5319,    28,  4444/
data    (chrtab(i), i=1601,1605) /  1116,  5532,     7,  4487,   903/
data    (chrtab(i), i=1606,1610) /  5511,    92,  4315,  1308,  5338/
data    (chrtab(i), i=1611,1615) /  1372,  5339,   200,  4167,   200/
data    (chrtab(i), i=1616,1620) /  4423,  1096,  5063,  1097,  5127/
data    (chrtab(i), i=1621,1625) /  1225,  5383,  1224,  5447,     0/
data    (chrtab(i), i=1626,1630) /   220,  4296,   220,  5191,   284/
data    (chrtab(i), i=1631,1635) /  5130,   348,  5194,  1115,  5191/
data    (chrtab(i), i=1636,1640) /    28,  4444,   924,  5404,     7/
data    (chrtab(i), i=1641,1645) /  4487,    92,  4315,   988,  5211/
data    (chrtab(i), i=1646,1650) /  1244,  5211,   200,  4167,   200/
data    (chrtab(i), i=1651,1655) /  4423,     0,   540,  4443,  4313/
data    (chrtab(i), i=1656,1660) /  4247,  4179,  4176,  4236,  4298/
data    (chrtab(i), i=1661,1665) /  4424,  4615,  4743,  4936,  5066/
data    (chrtab(i), i=1666,1670) /  5132,  5200,  5203,  5143,  5081/
data    (chrtab(i), i=1671,1675) /  4955,  4764,  4636,   281,  4311/
data    (chrtab(i), i=1676,1680) /  4244,  4239,  4300,  4362,   906/
data    (chrtab(i), i=1681,1685) /  5068,  5135,  5140,  5079,  5017/
data    (chrtab(i), i=1686,1690) /   540,  4507,  4376,  4308,  4303/
data    (chrtab(i), i=1691,1695) /  4363,  4488,  4615,   647,  4872/
data    (chrtab(i), i=1696,1700) /  5003,  5071,  5076,  5016,  4891/
data    (chrtab(i), i=1701,1705) /  4764,     0,   220,  4295,   283/
data    (chrtab(i), i=1706,1710) /  4360,   348,  4423,    28,  4892/
data    (chrtab(i), i=1711,1715) /  5083,  5146,  5208,  5205,  5139/
data    (chrtab(i), i=1716,1720) /  5074,  4881,  4433,   986,  5144/
data    (chrtab(i), i=1721,1725) /  5141,  5075,   796,  5019,  5081/
data    (chrtab(i), i=1726,1730) /  5076,  5010,  4881,     7,  4615/
data    (chrtab(i), i=1731,1735) /    92,  4315,   156,  4314,   412/
data    (chrtab(i), i=1736,1740) /  4442,   476,  4443,   200,  4167/
data    (chrtab(i), i=1741,1745) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=1746,1750) /  4551,     0,   540,  4443,  4313/
data    (chrtab(i), i=1751,1755) /  4247,  4179,  4176,  4236,  4298/
data    (chrtab(i), i=1756,1760) /  4424,  4615,  4743,  4936,  5066/
data    (chrtab(i), i=1761,1765) /  5132,  5200,  5203,  5143,  5081/
data    (chrtab(i), i=1766,1770) /  4955,  4764,  4636,   281,  4311/
data    (chrtab(i), i=1771,1775) /  4244,  4239,  4300,  4362,   906/
data    (chrtab(i), i=1776,1780) /  5068,  5135,  5140,  5079,  5017/
data    (chrtab(i), i=1781,1785) /   540,  4507,  4376,  4308,  4303/
data    (chrtab(i), i=1786,1790) /  4363,  4488,  4615,   647,  4872/
data    (chrtab(i), i=1791,1795) /  5003,  5071,  5076,  5016,  4891/
data    (chrtab(i), i=1796,1800) /  4764,   330,  4492,  4621,  4685/
data    (chrtab(i), i=1801,1805) /  4812,  4874,  4932,  4994,  5122/
data    (chrtab(i), i=1806,1810) /  5188,  5190,   838,  4996,  5059/
data    (chrtab(i), i=1811,1815) /  5123,   778,  4997,  5060,  5124/
data    (chrtab(i), i=1816,1820) /  5189,     0,   220,  4295,   283/
data    (chrtab(i), i=1821,1825) /  4360,   348,  4423,    28,  4892/
data    (chrtab(i), i=1826,1830) /  5083,  5146,  5208,  5206,  5140/
data    (chrtab(i), i=1831,1835) /  5075,  4882,  4434,   986,  5144/
data    (chrtab(i), i=1836,1840) /  5142,  5076,   796,  5019,  5081/
data    (chrtab(i), i=1841,1845) /  5077,  5011,  4882,   594,  4817/
data    (chrtab(i), i=1846,1850) /  4879,  5001,  5063,  5191,  5257/
data    (chrtab(i), i=1851,1855) /  5259,   907,  5065,  5128,  5192/
data    (chrtab(i), i=1856,1860) /   721,  4880,  5066,  5129,  5193/
data    (chrtab(i), i=1861,1865) /  5258,     7,  4615,    92,  4315/
data    (chrtab(i), i=1866,1870) /   156,  4314,   412,  4442,   476/
data    (chrtab(i), i=1871,1875) /  4443,   200,  4167,   201,  4231/
data    (chrtab(i), i=1876,1880) /   329,  4487,   328,  4551,     0/
data    (chrtab(i), i=1881,1885) /   921,  5084,  5078,  5017,  4891/
data    (chrtab(i), i=1886,1890) /  4700,  4508,  4315,  4185,  4182/
data    (chrtab(i), i=1891,1895) /  4244,  4434,  4816,  4943,  5005/
data    (chrtab(i), i=1896,1900) /  5002,  4936,   150,  4308,  4435/
data    (chrtab(i), i=1901,1905) /  4817,  4944,  5006,   219,  4249/
data    (chrtab(i), i=1906,1910) /  4247,  4309,  4436,  4818,  5008/
data    (chrtab(i), i=1911,1915) /  5070,  5067,  5001,  4936,  4743/
data    (chrtab(i), i=1916,1920) /  4551,  4360,  4234,  4173,  4167/
data    (chrtab(i), i=1921,1925) /  4234,     0,    28,  4118,   476/
data    (chrtab(i), i=1926,1930) /  4551,   539,  4616,   604,  4679/
data    (chrtab(i), i=1931,1935) /  1052,  5142,    28,  5148,   263/
data    (chrtab(i), i=1936,1940) /  4871,    92,  4118,   156,  4121/
data    (chrtab(i), i=1941,1945) /   220,  4122,   348,  4123,   732/
data    (chrtab(i), i=1946,1950) /  5147,   860,  5146,   924,  5145/
data    (chrtab(i), i=1951,1955) /   988,  5142,   456,  4423,   457/
data    (chrtab(i), i=1956,1960) /  4487,   585,  4743,   584,  4807/
data    (chrtab(i), i=1961,1965) /     0,   220,  4301,  4362,  4488/
data    (chrtab(i), i=1966,1970) /  4679,  4807,  5000,  5130,  5197/
data    (chrtab(i), i=1971,1975) /  5211,   283,  4364,  4426,   348/
data    (chrtab(i), i=1976,1980) /  4428,  4489,  4552,  4679,    28/
data    (chrtab(i), i=1981,1985) /  4636,   924,  5404,    92,  4315/
data    (chrtab(i), i=1986,1990) /   156,  4314,   412,  4442,   476/
data    (chrtab(i), i=1991,1995) /  4443,   988,  5211,  1244,  5211/
data    (chrtab(i), i=1996,2000) /     0,    92,  4615,   156,  4618/
data    (chrtab(i), i=2001,2005) /  4615,   220,  4682,   987,  4615/
data    (chrtab(i), i=2006,2010) /    28,  4508,   732,  5212,    28/
data    (chrtab(i), i=2011,2015) /  4250,   284,  4314,   348,  4315/
data    (chrtab(i), i=2016,2020) /   860,  5083,  1052,  5083,     0/
data    (chrtab(i), i=2021,2025) /   156,  4487,   220,  4492,  4487/
data    (chrtab(i), i=2026,2030) /   284,  4556,   668,  4556,  4487/
data    (chrtab(i), i=2031,2035) /   668,  4999,   732,  5004,  4999/
data    (chrtab(i), i=2036,2040) /   796,  5068,  1179,  5068,  4999/
data    (chrtab(i), i=2041,2045) /    28,  4572,   668,  4892,   988/
data    (chrtab(i), i=2046,2050) /  5468,    28,  4315,    92,  4314/
data    (chrtab(i), i=2051,2055) /   348,  4378,   412,  4379,  1052/
data    (chrtab(i), i=2056,2060) /  5275,  1308,  5275,     0,    92/
data    (chrtab(i), i=2061,2065) /  4935,   156,  4999,   220,  5063/
data    (chrtab(i), i=2066,2070) /   923,  4232,    28,  4508,   732/
data    (chrtab(i), i=2071,2075) /  5212,     7,  4423,   647,  5191/
data    (chrtab(i), i=2076,2080) /    28,  4314,   284,  4314,   348/
data    (chrtab(i), i=2081,2085) /  4315,   796,  5019,  1052,  5019/
data    (chrtab(i), i=2086,2090) /   136,  4103,   136,  4359,   840/
data    (chrtab(i), i=2091,2095) /  4807,   841,  4871,   841,  5127/
data    (chrtab(i), i=2096,2100) /     0,    92,  4625,  4615,   156/
data    (chrtab(i), i=2101,2105) /  4689,  4680,   220,  4753,  4743/
data    (chrtab(i), i=2106,2110) /  1051,  4753,    28,  4508,   860/
data    (chrtab(i), i=2111,2115) /  5340,   327,  4935,    28,  4251/
data    (chrtab(i), i=2116,2120) /   348,  4315,   924,  5147,  1180/
data    (chrtab(i), i=2121,2125) /  5147,   520,  4487,   521,  4551/
data    (chrtab(i), i=2126,2130) /   649,  4807,   648,  4871,     0/
data    (chrtab(i), i=2131,2135) /   988,  4188,  4182,   860,  4167/
data    (chrtab(i), i=2136,2140) /   924,  4231,   988,  4295,    71/
data    (chrtab(i), i=2141,2145) /  5063,  5069,   156,  4182,   220/
data    (chrtab(i), i=2146,2150) /  4185,   284,  4186,   412,  4187/
data    (chrtab(i), i=2151,2155) /   647,  5064,   775,  5065,   839/
data    (chrtab(i), i=2156,2160) /  5066,   903,  5069,     0,   160/
data    (chrtab(i), i=2161,2165) /  4224,   224,  4288,   160,  4704/
data    (chrtab(i), i=2166,2170) /   128,  4672,     0,    28,  4868/
data    (chrtab(i), i=2171,2175) /     0,   480,  4544,   544,  4608/
data    (chrtab(i), i=2176,2180) /    96,  4640,    64,  4608,     0/
data    (chrtab(i), i=2181,2185) /   278,  4505,  4630,    83,  4504/
data    (chrtab(i), i=2186,2190) /  4819,   408,  4487,     0,     5/
data    (chrtab(i), i=2191,2195) /  4997,     0,   348,  4315,  4249/
data    (chrtab(i), i=2196,2200) /  4246,  4309,  4373,  4438,  4439/
data    (chrtab(i), i=2201,2205) /  4376,  4312,  4247,   215,  4310/
data    (chrtab(i), i=2206,2210) /  4374,  4375,  4311,   219,  4247/
data    (chrtab(i), i=2211,2215) /   153,  4312,     0,   210,  4307/
data    (chrtab(i), i=2216,2220) /  4371,  4369,  4241,  4243,  4308/
data    (chrtab(i), i=2221,2225) /  4437,  4693,  4820,  4883,  4945/
data    (chrtab(i), i=2226,2230) /  4938,  5000,  5063,   723,  4881/
data    (chrtab(i), i=2231,2235) /  4874,  4936,   597,  4756,  4818/
data    (chrtab(i), i=2236,2240) /  4810,  4872,  5063,  5127,   720/
data    (chrtab(i), i=2241,2245) /  4751,  4430,  4237,  4171,  4170/
data    (chrtab(i), i=2246,2250) /  4232,  4423,  4615,  4744,  4810/
data    (chrtab(i), i=2251,2255) /   205,  4235,  4234,  4296,   655/
data    (chrtab(i), i=2256,2260) /  4494,  4365,  4299,  4298,  4360/
data    (chrtab(i), i=2261,2265) /  4423,     0,   220,  4295,  4360/
data    (chrtab(i), i=2266,2270) /  4488,   283,  4361,    28,  4444/
data    (chrtab(i), i=2271,2275) /  4424,   338,  4500,  4629,  4757/
data    (chrtab(i), i=2276,2280) /  4948,  5074,  5135,  5133,  5066/
data    (chrtab(i), i=2281,2285) /  4936,  4743,  4615,  4488,  4426/
data    (chrtab(i), i=2286,2290) /   914,  5072,  5068,  5002,   661/
data    (chrtab(i), i=2291,2295) /  4884,  4947,  5008,  5004,  4937/
data    (chrtab(i), i=2296,2300) /  4872,  4743,    92,  4315,   156/
data    (chrtab(i), i=2301,2305) /  4314,     0,   849,  4946,  4882/
data    (chrtab(i), i=2306,2310) /  4880,  5008,  5010,  4884,  4757/
data    (chrtab(i), i=2311,2315) /  4565,  4372,  4242,  4175,  4173/
data    (chrtab(i), i=2316,2320) /  4234,  4360,  4551,  4679,  4872/
data    (chrtab(i), i=2321,2325) /  5002,   210,  4240,  4236,  4298/
data    (chrtab(i), i=2326,2330) /   469,  4436,  4371,  4304,  4300/
data    (chrtab(i), i=2331,2335) /  4361,  4424,  4551,     0,   796/
data    (chrtab(i), i=2336,2340) /  4871,  5191,   859,  4936,   604/
data    (chrtab(i), i=2341,2345) /  5020,  4999,   786,  4820,  4693/
data    (chrtab(i), i=2346,2350) /  4565,  4372,  4242,  4175,  4173/
data    (chrtab(i), i=2351,2355) /  4234,  4360,  4551,  4679,  4808/
data    (chrtab(i), i=2356,2360) /  4874,   210,  4240,  4236,  4298/
data    (chrtab(i), i=2361,2365) /   469,  4436,  4371,  4304,  4300/
data    (chrtab(i), i=2366,2370) /  4361,  4424,  4551,   668,  4891/
data    (chrtab(i), i=2371,2375) /   732,  4890,   905,  5063,   904/
data    (chrtab(i), i=2376,2380) /  5127,     0,   207,  5007,  5009/
data    (chrtab(i), i=2381,2385) /  4947,  4884,  4693,  4565,  4372/
data    (chrtab(i), i=2386,2390) /  4242,  4175,  4173,  4234,  4360/
data    (chrtab(i), i=2391,2395) /  4551,  4679,  4872,  5002,   848/
data    (chrtab(i), i=2396,2400) /  4945,  4883,   210,  4240,  4236/
data    (chrtab(i), i=2401,2405) /  4298,   783,  4882,  4820,  4693/
data    (chrtab(i), i=2406,2410) /   469,  4436,  4371,  4304,  4300/
data    (chrtab(i), i=2411,2415) /  4361,  4424,  4551,     0,   666/
data    (chrtab(i), i=2416,2420) /  4763,  4699,  4697,  4825,  4827/
data    (chrtab(i), i=2421,2425) /  4764,  4572,  4443,  4378,  4311/
data    (chrtab(i), i=2426,2430) /  4295,   346,  4375,  4360,   476/
data    (chrtab(i), i=2431,2435) /  4507,  4441,  4423,    21,  4693/
data    (chrtab(i), i=2436,2440) /     7,  4615,   200,  4167,   201/
data    (chrtab(i), i=2441,2445) /  4231,   329,  4487,   328,  4551/
data    (chrtab(i), i=2446,2450) /     0,   852,  5011,  5076,  5013/
data    (chrtab(i), i=2451,2455) /  4949,  4820,  4755,   405,  4372/
data    (chrtab(i), i=2456,2460) /  4307,  4241,  4239,  4301,  4364/
data    (chrtab(i), i=2461,2465) /  4491,  4619,  4748,  4813,  4879/
data    (chrtab(i), i=2466,2470) /  4881,  4819,  4756,  4629,  4501/
data    (chrtab(i), i=2471,2475) /   275,  4305,  4303,  4365,   653/
data    (chrtab(i), i=2476,2480) /  4815,  4817,  4755,   405,  4436/
data    (chrtab(i), i=2481,2485) /  4370,  4366,  4428,  4491,   523/
data    (chrtab(i), i=2486,2490) /  4684,  4750,  4754,  4692,  4629/
data    (chrtab(i), i=2491,2495) /   205,  4236,  4170,  4169,  4231/
data    (chrtab(i), i=2496,2500) /  4294,  4485,  4741,  4932,  4995/
data    (chrtab(i), i=2501,2505) /   199,  4486,  4742,  4933,    73/
data    (chrtab(i), i=2506,2510) /  4232,  4423,  4743,  4934,  4996/
data    (chrtab(i), i=2511,2515) /  4995,  4929,  4736,  4352,  4161/
data    (chrtab(i), i=2516,2520) /  4099,  4100,  4166,  4359,   256/
data    (chrtab(i), i=2521,2525) /  4225,  4163,  4164,  4230,  4359/
data    (chrtab(i), i=2526,2530) /     0,   220,  4295,   283,  4360/
data    (chrtab(i), i=2531,2535) /    28,  4444,  4423,   337,  4499/
data    (chrtab(i), i=2536,2540) /  4564,  4693,  4885,  5012,  5075/
data    (chrtab(i), i=2541,2545) /  5136,  5127,   915,  5072,  5064/
data    (chrtab(i), i=2546,2550) /   789,  4948,  5009,  4999,     7/
data    (chrtab(i), i=2551,2555) /  4615,   711,  5319,    92,  4315/
data    (chrtab(i), i=2556,2560) /   156,  4314,   200,  4167,   201/
data    (chrtab(i), i=2561,2565) /  4231,   329,  4487,   328,  4551/
data    (chrtab(i), i=2566,2570) /   904,  4871,   905,  4935,  1033/
data    (chrtab(i), i=2571,2575) /  5191,  1032,  5255,     0,   220/
data    (chrtab(i), i=2576,2580) /  4314,  4442,  4444,  4316,   284/
data    (chrtab(i), i=2581,2585) /  4378,   219,  4443,   213,  4295/
data    (chrtab(i), i=2586,2590) /   276,  4360,    21,  4437,  4423/
data    (chrtab(i), i=2591,2595) /     7,  4615,    85,  4308,   149/
data    (chrtab(i), i=2596,2600) /  4307,   200,  4167,   201,  4231/
data    (chrtab(i), i=2601,2605) /   329,  4487,   328,  4551,     0/
data    (chrtab(i), i=2606,2610) /   348,  4442,  4570,  4572,  4444/
data    (chrtab(i), i=2611,2615) /   412,  4506,   347,  4571,   341/
data    (chrtab(i), i=2616,2620) /  4420,  4353,  4288,   404,  4485/
data    (chrtab(i), i=2621,2625) /  4418,   149,  4565,  4549,  4482/
data    (chrtab(i), i=2626,2630) /  4417,  4288,  4096,  4097,  4099/
data    (chrtab(i), i=2631,2635) /  4163,  4161,  4097,  4098,   213/
data    (chrtab(i), i=2636,2640) /  4436,   277,  4435,     0,   220/
data    (chrtab(i), i=2641,2645) /  4295,   283,  4360,    28,  4444/
data    (chrtab(i), i=2646,2650) /  4423,   916,  4427,   591,  5127/
data    (chrtab(i), i=2651,2655) /   590,  5063,   526,  4999,   725/
data    (chrtab(i), i=2656,2660) /  5269,     7,  4615,   711,  5255/
data    (chrtab(i), i=2661,2665) /    92,  4315,   156,  4314,   789/
data    (chrtab(i), i=2666,2670) /  5012,  1109,  5012,   200,  4167/
data    (chrtab(i), i=2671,2675) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=2676,2680) /  4551,   905,  4871,   841,  5191/
data    (chrtab(i), i=2681,2685) /     0,   220,  4295,   283,  4360/
data    (chrtab(i), i=2686,2690) /    28,  4444,  4423,     7,  4615/
data    (chrtab(i), i=2691,2695) /    92,  4315,   156,  4314,   200/
data    (chrtab(i), i=2696,2700) /  4167,   201,  4231,   329,  4487/
data    (chrtab(i), i=2701,2705) /   328,  4551,     0,   213,  4295/
data    (chrtab(i), i=2706,2710) /   276,  4360,    21,  4437,  4423/
data    (chrtab(i), i=2711,2715) /   337,  4499,  4564,  4693,  4885/
data    (chrtab(i), i=2716,2720) /  5012,  5075,  5136,  5127,   915/
data    (chrtab(i), i=2721,2725) /  5072,  5064,   789,  4948,  5009/
data    (chrtab(i), i=2726,2730) /  4999,  1041,  5203,  5268,  5397/
data    (chrtab(i), i=2731,2735) /  5589,  5716,  5779,  5840,  5831/
data    (chrtab(i), i=2736,2740) /  1619,  5776,  5768,  1493,  5652/
data    (chrtab(i), i=2741,2745) /  5713,  5703,     7,  4615,   711/
data    (chrtab(i), i=2746,2750) /  5319,  1415,  6023,    85,  4308/
data    (chrtab(i), i=2751,2755) /   149,  4307,   200,  4167,   201/
data    (chrtab(i), i=2756,2760) /  4231,   329,  4487,   328,  4551/
data    (chrtab(i), i=2761,2765) /   904,  4871,   905,  4935,  1033/
data    (chrtab(i), i=2766,2770) /  5191,  1032,  5255,  1608,  5575/
data    (chrtab(i), i=2771,2775) /  1609,  5639,  1737,  5895,  1736/
data    (chrtab(i), i=2776,2780) /  5959,     0,   213,  4295,   276/
data    (chrtab(i), i=2781,2785) /  4360,    21,  4437,  4423,   337/
data    (chrtab(i), i=2786,2790) /  4499,  4564,  4693,  4885,  5012/
data    (chrtab(i), i=2791,2795) /  5075,  5136,  5127,   915,  5072/
data    (chrtab(i), i=2796,2800) /  5064,   789,  4948,  5009,  4999/
data    (chrtab(i), i=2801,2805) /     7,  4615,   711,  5319,    85/
data    (chrtab(i), i=2806,2810) /  4308,   149,  4307,   200,  4167/
data    (chrtab(i), i=2811,2815) /   201,  4231,   329,  4487,   328/
data    (chrtab(i), i=2816,2820) /  4551,   904,  4871,   905,  4935/
data    (chrtab(i), i=2821,2825) /  1033,  5191,  1032,  5255,     0/
data    (chrtab(i), i=2826,2830) /   469,  4372,  4242,  4175,  4173/
data    (chrtab(i), i=2831,2835) /  4234,  4360,  4551,  4679,  4872/
data    (chrtab(i), i=2836,2840) /  5002,  5069,  5071,  5010,  4884/
data    (chrtab(i), i=2841,2845) /  4693,  4565,   210,  4240,  4236/
data    (chrtab(i), i=2846,2850) /  4298,   842,  5004,  5008,  4946/
data    (chrtab(i), i=2851,2855) /   469,  4436,  4371,  4304,  4300/
data    (chrtab(i), i=2856,2860) /  4361,  4424,  4551,   583,  4808/
data    (chrtab(i), i=2861,2865) /  4873,  4940,  4944,  4883,  4820/
data    (chrtab(i), i=2866,2870) /  4693,     0,   213,  4288,   276/
data    (chrtab(i), i=2871,2875) /  4353,    21,  4437,  4416,   338/
data    (chrtab(i), i=2876,2880) /  4500,  4629,  4757,  4948,  5074/
data    (chrtab(i), i=2881,2885) /  5135,  5133,  5066,  4936,  4743/
data    (chrtab(i), i=2886,2890) /  4615,  4488,  4426,   914,  5072/
data    (chrtab(i), i=2891,2895) /  5068,  5002,   661,  4884,  4947/
data    (chrtab(i), i=2896,2900) /  5008,  5004,  4937,  4872,  4743/
data    (chrtab(i), i=2901,2905) /     0,  4608,    85,  4308,   149/
data    (chrtab(i), i=2906,2910) /  4307,   193,  4160,   194,  4224/
data    (chrtab(i), i=2911,2915) /   322,  4480,   321,  4544,     0/
data    (chrtab(i), i=2916,2920) /   788,  4864,   851,  4929,   724/
data    (chrtab(i), i=2921,2925) /  4948,  5013,  4992,   786,  4820/
data    (chrtab(i), i=2926,2930) /  4693,  4565,  4372,  4242,  4175/
data    (chrtab(i), i=2931,2935) /  4173,  4234,  4360,  4551,  4679/
data    (chrtab(i), i=2936,2940) /  4808,  4874,   210,  4240,  4236/
data    (chrtab(i), i=2941,2945) /  4298,   469,  4436,  4371,  4304/
data    (chrtab(i), i=2946,2950) /  4300,  4361,  4424,  4551,   576/
data    (chrtab(i), i=2951,2955) /  5184,   769,  4736,   770,  4800/
data    (chrtab(i), i=2956,2960) /   898,  5056,   897,  5120,     0/
data    (chrtab(i), i=2961,2965) /   213,  4295,   276,  4360,    21/
data    (chrtab(i), i=2966,2970) /  4437,  4423,   787,  4884,  4820/
data    (chrtab(i), i=2971,2975) /  4818,  4946,  4948,  4885,  4757/
data    (chrtab(i), i=2976,2980) /  4628,  4498,  4431,     7,  4615/
data    (chrtab(i), i=2981,2985) /    85,  4308,   149,  4307,   200/
data    (chrtab(i), i=2986,2990) /  4167,   201,  4231,   329,  4487/
data    (chrtab(i), i=2991,2995) /   328,  4551,     0,   723,  4885/
data    (chrtab(i), i=2996,3000) /  4881,  4819,  4756,  4629,  4373/
data    (chrtab(i), i=3001,3005) /  4244,  4179,  4177,  4239,  4366/
data    (chrtab(i), i=3006,3010) /  4685,  4812,  4873,   148,  4177/
data    (chrtab(i), i=3011,3015) /   144,  4367,  4686,  4813,   780/
data    (chrtab(i), i=3016,3020) /  4808,    83,  4241,  4368,  4687/
data    (chrtab(i), i=3021,3025) /  4814,  4876,  4873,  4808,  4679/
data    (chrtab(i), i=3026,3030) /  4423,  4296,  4233,  4171,  4167/
data    (chrtab(i), i=3031,3035) /  4233,     0,   218,  4300,  4361/
data    (chrtab(i), i=3036,3040) /  4424,  4551,  4679,  4808,  4874/
data    (chrtab(i), i=3041,3045) /   282,  4363,  4425,   218,  4444/
data    (chrtab(i), i=3046,3050) /  4427,  4488,  4551,    21,  4693/
data    (chrtab(i), i=3051,3055) /     0,   213,  4300,  4361,  4424/
data    (chrtab(i), i=3056,3060) /  4551,  4743,  4872,  4937,  5003/
data    (chrtab(i), i=3061,3065) /   276,  4363,  4425,    21,  4437/
data    (chrtab(i), i=3066,3070) /  4427,  4488,  4551,   917,  4999/
data    (chrtab(i), i=3071,3075) /  5319,   980,  5064,   725,  5141/
data    (chrtab(i), i=3076,3080) /  5127,    85,  4308,   149,  4307/
data    (chrtab(i), i=3081,3085) /  1033,  5191,  1032,  5255,     0/
data    (chrtab(i), i=3086,3090) /    85,  4551,   149,  4553,   213/
data    (chrtab(i), i=3091,3095) /  4617,   852,  4617,  4551,    21/
data    (chrtab(i), i=3096,3100) /  4501,   597,  5077,    21,  4307/
data    (chrtab(i), i=3101,3105) /   341,  4308,   725,  4948,   917/
data    (chrtab(i), i=3106,3110) /  4948,     0,   149,  4487,   213/
data    (chrtab(i), i=3111,3115) /  4490,   277,  4554,   661,  4554/
data    (chrtab(i), i=3116,3120) /  4487,   661,  4999,   725,  5002/
data    (chrtab(i), i=3121,3125) /   661,  4885,  5066,  1172,  5066/
data    (chrtab(i), i=3126,3130) /  4999,    21,  4565,   981,  5461/
data    (chrtab(i), i=3131,3135) /    21,  4308,   405,  4372,  1045/
data    (chrtab(i), i=3136,3140) /  5268,  1301,  5268,     0,   149/
data    (chrtab(i), i=3141,3145) /  4871,   213,  4935,   277,  4999/
data    (chrtab(i), i=3146,3150) /   852,  4296,    21,  4565,   661/
data    (chrtab(i), i=3151,3155) /  5141,     7,  4487,   583,  5127/
data    (chrtab(i), i=3156,3160) /    85,  4308,   405,  4372,   725/
data    (chrtab(i), i=3161,3165) /  4948,   981,  4948,   200,  4167/
data    (chrtab(i), i=3166,3170) /   200,  4423,   776,  4743,   840/
data    (chrtab(i), i=3171,3175) /  5063,     0,   149,  4615,   213/
data    (chrtab(i), i=3176,3180) /  4617,   277,  4681,   916,  4681/
data    (chrtab(i), i=3181,3185) /  4483,  4353,  4224,  4096,  4097/
data    (chrtab(i), i=3186,3190) /  4099,  4163,  4161,  4097,  4098/
data    (chrtab(i), i=3191,3195) /    21,  4565,   661,  5141,    85/
data    (chrtab(i), i=3196,3200) /  4371,   405,  4372,   789,  5012/
data    (chrtab(i), i=3201,3205) /   981,  5012,     0,   725,  4167/
data    (chrtab(i), i=3206,3210) /   789,  4231,   853,  4295,   853/
data    (chrtab(i), i=3211,3215) /  4181,  4177,    71,  4935,  4939/
data    (chrtab(i), i=3216,3220) /   149,  4177,   213,  4178,   277/
data    (chrtab(i), i=3221,3225) /  4179,   405,  4180,   519,  4936/
data    (chrtab(i), i=3226,3230) /   647,  4937,   711,  4938,   775/
data    (chrtab(i), i=3231,3235) /  4939,     0,   480,  4447,  4382/
data    (chrtab(i), i=3236,3240) /  4316,  4314,  4376,  4439,  4501/
data    (chrtab(i), i=3241,3245) /  4499,  4369,   351,  4381,  4379/
data    (chrtab(i), i=3246,3250) /  4441,  4504,  4566,  4564,  4498/
data    (chrtab(i), i=3251,3255) /  4240,  4494,  4556,  4554,  4488/
data    (chrtab(i), i=3256,3260) /  4423,  4357,  4355,  4417,   271/
data    (chrtab(i), i=3261,3265) /  4493,  4491,  4425,  4360,  4294/
data    (chrtab(i), i=3266,3270) /  4292,  4354,  4417,  4544,     0/
data    (chrtab(i), i=3271,3275) /   160,  4224,     0,   224,  4447/
data    (chrtab(i), i=3276,3280) /  4510,  4572,  4570,  4504,  4439/
data    (chrtab(i), i=3281,3285) /  4373,  4371,  4497,   351,  4509/
data    (chrtab(i), i=3286,3290) /  4507,  4441,  4376,  4310,  4308/
data    (chrtab(i), i=3291,3295) /  4370,  4624,  4366,  4300,  4298/
data    (chrtab(i), i=3296,3300) /  4360,  4423,  4485,  4483,  4417/
data    (chrtab(i), i=3301,3305) /   399,  4365,  4363,  4425,  4488/
data    (chrtab(i), i=3306,3310) /  4550,  4548,  4482,  4417,  4288/
data    (chrtab(i), i=3311,3315) /     0,    77,  4175,  4242,  4371/
data    (chrtab(i), i=3316,3320) /  4499,  4626,  4879,  5006,  5134/
data    (chrtab(i), i=3321,3325) /  5263,  5329,    79,  4241,  4370/
data    (chrtab(i), i=3326,3330) /  4498,  4625,  4878,  5005,  5133/
data    (chrtab(i), i=3331,3335) /  5262,  5329,  5331,     0,   284/
data    (chrtab(i), i=3336,3340) /  4251,  4185,  4183,  4245,  4372/
data    (chrtab(i), i=3341,3345) /  4500,  4629,  4695,  4697,  4635/
data    (chrtab(i), i=3346,3350) /  4508,  4380,   284,  4185,  4245/
data    (chrtab(i), i=3351,3355) /  4500,  4695,  4635,  4380,   412/
data    (chrtab(i), i=3356,3360) /  4251,  4183,  4372,  4629,  4697/
data    (chrtab(i), i=3361,3362) /  4508,     0/
