/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli ATM-MIB
 *
 * Derived from ATM-MIB:
 *   This is the MIB Module for ATM and AAL5-related
 *   objects for managing ATM interfaces, ATM virtual
 *   links, ATM cross-connects, AAL5 entities, and
 *   and AAL5 connections.
 *
 * Revision 1998-10-19 12:00:
 *   The initial revision of this module was published
 *   as RFC 1695. Key revisions include:
 *   o  Textual Conventions and OBJECT IDENTITIES have
 *      been moved to a separate MIB module.
 *   o  Applicability of objects to PVCs, SVCs and Soft
 *      PVCs has been clarified.
 *   o  DEFVAL clauses have been added.
 *   o  The relationship of ifIndex values with different
 *      layers and sublayers related to ATM has been
 *      clarified.
 *   o  atmTrafficQosClass has been deprecated
 *      and replaced with atmServiceCategory.
 *   o  atmInterfaceCurrentMaxVpiBits and
 *      atmInterfaceCurrentMaxVciBits have been added with
 *      a description on their relationship with other
 *      objects.
 *   o  atmInterfaceAddressType and atmInterfaceAdminAddress
 *      have been deprecated and replaced by
 *      atmInterfaceSubscrAddress.
 *   o  atmInterfaceTCAlarmState has been clarified.
 *   o  atmTrafficDescrParamIndexNext has been introduced
 *      in order to provide a manager a free
 *      atmTrafficDescrParamIndex value.
 *   o  The atmTrafficFrameDiscard capability has been added.
 *   o  A connection topology type (atmVpl/VclCastType) and
 *      a call control type (atmVpl/VclConnKind) have been
 *      added.
 *   o  aal2 has been added to atmVccAalType.
 *
 * Revision 1994-06-07 22:45:
 *   The RFC1695 version of this MIB module.
 *
 * $Id: atm-mib.c 3178 2009-07-28 10:23:24Z schoenw $
 */

#include "atm-mib.h"

GNetSnmpEnum const atm_mib_enums_atmInterfaceAddressType[] = {
    { ATM_MIB_ATMINTERFACEADDRESSTYPE_PRIVATE,    "private" },
    { ATM_MIB_ATMINTERFACEADDRESSTYPE_NSAPE164,   "nsapE164" },
    { ATM_MIB_ATMINTERFACEADDRESSTYPE_NATIVEE164, "nativeE164" },
    { ATM_MIB_ATMINTERFACEADDRESSTYPE_OTHER,      "other" },
    { 0, NULL }
};

GNetSnmpEnum const atm_mib_enums_atmInterfaceDs3PlcpAlarmState[] = {
    { ATM_MIB_ATMINTERFACEDS3PLCPALARMSTATE_NOALARM,             "noAlarm" },
    { ATM_MIB_ATMINTERFACEDS3PLCPALARMSTATE_RECEIVEDFARENDALARM, "receivedFarEndAlarm" },
    { ATM_MIB_ATMINTERFACEDS3PLCPALARMSTATE_INCOMINGLOF,         "incomingLOF" },
    { 0, NULL }
};

GNetSnmpEnum const atm_mib_enums_atmInterfaceTCAlarmState[] = {
    { ATM_MIB_ATMINTERFACETCALARMSTATE_NOALARM,    "noAlarm" },
    { ATM_MIB_ATMINTERFACETCALARMSTATE_LCDFAILURE, "lcdFailure" },
    { 0, NULL }
};

GNetSnmpEnum const atm_mib_enums_atmVccAalType[] = {
    { ATM_MIB_ATMVCCAALTYPE_AAL1,    "aal1" },
    { ATM_MIB_ATMVCCAALTYPE_AAL34,   "aal34" },
    { ATM_MIB_ATMVCCAALTYPE_AAL5,    "aal5" },
    { ATM_MIB_ATMVCCAALTYPE_OTHER,   "other" },
    { ATM_MIB_ATMVCCAALTYPE_UNKNOWN, "unknown" },
    { ATM_MIB_ATMVCCAALTYPE_AAL2,    "aal2" },
    { 0, NULL }
};

GNetSnmpEnum const atm_mib_enums_atmVccAal5EncapsType[] = {
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_VCMULTIPLEXROUTEDPROTOCOL,      "vcMultiplexRoutedProtocol" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_VCMULTIPLEXBRIDGEDPROTOCOL8023, "vcMultiplexBridgedProtocol8023" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_VCMULTIPLEXBRIDGEDPROTOCOL8025, "vcMultiplexBridgedProtocol8025" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_VCMULTIPLEXBRIDGEDPROTOCOL8026, "vcMultiplexBridgedProtocol8026" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_VCMULTIPLEXLANEMULATION8023,    "vcMultiplexLANemulation8023" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_VCMULTIPLEXLANEMULATION8025,    "vcMultiplexLANemulation8025" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_LLCENCAPSULATION,               "llcEncapsulation" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_MULTIPROTOCOLFRAMERELAYSSCS,    "multiprotocolFrameRelaySscs" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_OTHER,                          "other" },
    { ATM_MIB_ATMVCCAAL5ENCAPSTYPE_UNKNOWN,                        "unknown" },
    { 0, NULL }
};


static gint32 atmVpCrossConnectIndexNext_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmVcCrossConnectIndexNext_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmTrafficDescrParamIndexNext_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmInterfaceMaxVpcs_constraints[] = {0L, 4096L, 0, 0};
static gint32 atmInterfaceMaxVccs_constraints[] = {0L, 65536L, 0, 0};
static gint32 atmInterfaceConfVpcs_constraints[] = {0L, 4096L, 0, 0};
static gint32 atmInterfaceConfVccs_constraints[] = {0L, 65536L, 0, 0};
static gint32 atmInterfaceMaxActiveVpiBits_constraints[] = {0L, 12L, 0, 0};
static gint32 atmInterfaceMaxActiveVciBits_constraints[] = {0L, 16L, 0, 0};
static gint32 atmInterfaceIlmiVpi_constraints[] = {0L, 4095L, 0, 0};
static gint32 atmInterfaceIlmiVci_constraints[] = {0L, 65535L, 0, 0};
static guint16 atmInterfaceAdminAddress_constraints[] = {0U, 40U, 0, 0};
static guint16 atmInterfaceMyNeighborIpAddress_constraints[] = {4U, 4U, 0, 0};
static guint16 atmInterfaceMyNeighborIfName_constraints[] = {0U, 255U, 0, 0};
static gint32 atmInterfaceCurrentMaxVpiBits_constraints[] = {0L, 12L, 0, 0};
static gint32 atmInterfaceCurrentMaxVciBits_constraints[] = {0L, 16L, 0, 0};
static guint16 atmInterfaceSubscrAddress_constraints[] = {0U, 40U, 0, 0};
static gint32 atmTrafficQoSClass_constraints[] = {0L, 255L, 0, 0};
static gint32 atmVplReceiveTrafficDescrIndex_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmVplTransmitTrafficDescrIndex_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmVplCrossConnectIdentifier_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmVclReceiveTrafficDescrIndex_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmVclTransmitTrafficDescrIndex_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 atmVccAal5CpcsTransmitSduSize_constraints[] = {1L, 65535L, 0, 0};
static gint32 atmVccAal5CpcsReceiveSduSize_constraints[] = {1L, 65535L, 0, 0};
static gint32 atmVclCrossConnectIdentifier_constraints[] = {0L, 2147483647L, 0, 0};


static guint32 const atmMIBObjects_oid[] = {1, 3, 6, 1, 2, 1, 37, 1};

static GNetSnmpAttribute atmMIBObjects_attr[] = {
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPCROSSCONNECTINDEXNEXT, "atmVpCrossConnectIndexNext",
       atmVpCrossConnectIndexNext_constraints,
      G_STRUCT_OFFSET(atm_mib_atmMIBObjects_t, atmVpCrossConnectIndexNext),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCROSSCONNECTINDEXNEXT, "atmVcCrossConnectIndexNext",
       atmVcCrossConnectIndexNext_constraints,
      G_STRUCT_OFFSET(atm_mib_atmMIBObjects_t, atmVcCrossConnectIndexNext),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICDESCRPARAMINDEXNEXT, "atmTrafficDescrParamIndexNext",
       atmTrafficDescrParamIndexNext_constraints,
      G_STRUCT_OFFSET(atm_mib_atmMIBObjects_t, atmTrafficDescrParamIndexNext),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const atmInterfaceConfEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 2, 1};

static GNetSnmpAttribute atmInterfaceConfEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEMAXVPCS, "atmInterfaceMaxVpcs",
       atmInterfaceMaxVpcs_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceMaxVpcs),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEMAXVCCS, "atmInterfaceMaxVccs",
       atmInterfaceMaxVccs_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceMaxVccs),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACECONFVPCS, "atmInterfaceConfVpcs",
       atmInterfaceConfVpcs_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceConfVpcs),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACECONFVCCS, "atmInterfaceConfVccs",
       atmInterfaceConfVccs_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceConfVccs),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEMAXACTIVEVPIBITS, "atmInterfaceMaxActiveVpiBits",
       atmInterfaceMaxActiveVpiBits_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceMaxActiveVpiBits),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEMAXACTIVEVCIBITS, "atmInterfaceMaxActiveVciBits",
       atmInterfaceMaxActiveVciBits_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceMaxActiveVciBits),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEILMIVPI, "atmInterfaceIlmiVpi",
       atmInterfaceIlmiVpi_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceIlmiVpi),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEILMIVCI, "atmInterfaceIlmiVci",
       atmInterfaceIlmiVci_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceIlmiVci),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEADDRESSTYPE, "atmInterfaceAddressType",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceAddressType),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ATM_MIB_ATMINTERFACEADMINADDRESS, "atmInterfaceAdminAddress",
       atmInterfaceAdminAddress_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceAdminAddress),
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, _atmInterfaceAdminAddressLength),
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_IPADDRESS,
      ATM_MIB_ATMINTERFACEMYNEIGHBORIPADDRESS, "atmInterfaceMyNeighborIpAddress",
       atmInterfaceMyNeighborIpAddress_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceMyNeighborIpAddress),
      4,
      GSNMP_ATTR_FLAG_WRITABLE|GSNMP_ATTR_FLAG_FIXED_LENGTH },
    { 12, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ATM_MIB_ATMINTERFACEMYNEIGHBORIFNAME, "atmInterfaceMyNeighborIfName",
       atmInterfaceMyNeighborIfName_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceMyNeighborIfName),
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, _atmInterfaceMyNeighborIfNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACECURRENTMAXVPIBITS, "atmInterfaceCurrentMaxVpiBits",
       atmInterfaceCurrentMaxVpiBits_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceCurrentMaxVpiBits),
      0,
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACECURRENTMAXVCIBITS, "atmInterfaceCurrentMaxVciBits",
       atmInterfaceCurrentMaxVciBits_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceCurrentMaxVciBits),
      0,
      0 },
    { 15, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      ATM_MIB_ATMINTERFACESUBSCRADDRESS, "atmInterfaceSubscrAddress",
       atmInterfaceSubscrAddress_constraints,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, atmInterfaceSubscrAddress),
      G_STRUCT_OFFSET(atm_mib_atmInterfaceConfEntry_t, _atmInterfaceSubscrAddressLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const atmInterfaceDs3PlcpEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 3, 1};

static GNetSnmpAttribute atmInterfaceDs3PlcpEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      ATM_MIB_ATMINTERFACEDS3PLCPSEFSS, "atmInterfaceDs3PlcpSEFSs",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceDs3PlcpEntry_t, atmInterfaceDs3PlcpSEFSs),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACEDS3PLCPALARMSTATE, "atmInterfaceDs3PlcpAlarmState",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceDs3PlcpEntry_t, atmInterfaceDs3PlcpAlarmState),
      0,
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      ATM_MIB_ATMINTERFACEDS3PLCPUASS, "atmInterfaceDs3PlcpUASs",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceDs3PlcpEntry_t, atmInterfaceDs3PlcpUASs),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const atmInterfaceTCEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 4, 1};

static GNetSnmpAttribute atmInterfaceTCEntry_attr[] = {
    { 1, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      ATM_MIB_ATMINTERFACEOCDEVENTS, "atmInterfaceOCDEvents",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceTCEntry_t, atmInterfaceOCDEvents),
      0,
      0 },
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMINTERFACETCALARMSTATE, "atmInterfaceTCAlarmState",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmInterfaceTCEntry_t, atmInterfaceTCAlarmState),
      0,
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const atmTrafficDescrParamEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 5, 1};

static GNetSnmpAttribute atmTrafficDescrParamEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      ATM_MIB_ATMTRAFFICDESCRTYPE, "atmTrafficDescrType",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficDescrType),
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, _atmTrafficDescrTypeLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICDESCRPARAM1, "atmTrafficDescrParam1",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficDescrParam1),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICDESCRPARAM2, "atmTrafficDescrParam2",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficDescrParam2),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICDESCRPARAM3, "atmTrafficDescrParam3",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficDescrParam3),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICDESCRPARAM4, "atmTrafficDescrParam4",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficDescrParam4),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICDESCRPARAM5, "atmTrafficDescrParam5",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficDescrParam5),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICQOSCLASS, "atmTrafficQoSClass",
       atmTrafficQoSClass_constraints,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficQoSClass),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICDESCRROWSTATUS, "atmTrafficDescrRowStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficDescrRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMSERVICECATEGORY, "atmServiceCategory",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmServiceCategory),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMTRAFFICFRAMEDISCARD, "atmTrafficFrameDiscard",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmTrafficDescrParamEntry_t, atmTrafficFrameDiscard),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const atmVplEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 6, 1};

static GNetSnmpAttribute atmVplEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLADMINSTATUS, "atmVplAdminStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLOPERSTATUS, "atmVplOperStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplOperStatus),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      ATM_MIB_ATMVPLLASTCHANGE, "atmVplLastChange",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplLastChange),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLRECEIVETRAFFICDESCRINDEX, "atmVplReceiveTrafficDescrIndex",
       atmVplReceiveTrafficDescrIndex_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplReceiveTrafficDescrIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLTRANSMITTRAFFICDESCRINDEX, "atmVplTransmitTrafficDescrIndex",
       atmVplTransmitTrafficDescrIndex_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplTransmitTrafficDescrIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLCROSSCONNECTIDENTIFIER, "atmVplCrossConnectIdentifier",
       atmVplCrossConnectIdentifier_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplCrossConnectIdentifier),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLROWSTATUS, "atmVplRowStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLCASTTYPE, "atmVplCastType",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplCastType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPLCONNKIND, "atmVplConnKind",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVplEntry_t, atmVplConnKind),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const atmVclEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 7, 1};

static GNetSnmpAttribute atmVclEntry_attr[] = {
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLADMINSTATUS, "atmVclAdminStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLOPERSTATUS, "atmVclOperStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclOperStatus),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      ATM_MIB_ATMVCLLASTCHANGE, "atmVclLastChange",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclLastChange),
      0,
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLRECEIVETRAFFICDESCRINDEX, "atmVclReceiveTrafficDescrIndex",
       atmVclReceiveTrafficDescrIndex_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclReceiveTrafficDescrIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLTRANSMITTRAFFICDESCRINDEX, "atmVclTransmitTrafficDescrIndex",
       atmVclTransmitTrafficDescrIndex_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclTransmitTrafficDescrIndex),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCAALTYPE, "atmVccAalType",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVccAalType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCAAL5CPCSTRANSMITSDUSIZE, "atmVccAal5CpcsTransmitSduSize",
       atmVccAal5CpcsTransmitSduSize_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVccAal5CpcsTransmitSduSize),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCAAL5CPCSRECEIVESDUSIZE, "atmVccAal5CpcsReceiveSduSize",
       atmVccAal5CpcsReceiveSduSize_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVccAal5CpcsReceiveSduSize),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCAAL5ENCAPSTYPE, "atmVccAal5EncapsType",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVccAal5EncapsType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLCROSSCONNECTIDENTIFIER, "atmVclCrossConnectIdentifier",
       atmVclCrossConnectIdentifier_constraints,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclCrossConnectIdentifier),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLROWSTATUS, "atmVclRowStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLCASTTYPE, "atmVclCastType",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclCastType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCLCONNKIND, "atmVclConnKind",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVclEntry_t, atmVclConnKind),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const atmVpCrossConnectEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 9, 1};

static GNetSnmpAttribute atmVpCrossConnectEntry_attr[] = {
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPCROSSCONNECTADMINSTATUS, "atmVpCrossConnectAdminStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVpCrossConnectEntry_t, atmVpCrossConnectAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPCROSSCONNECTL2HOPERSTATUS, "atmVpCrossConnectL2HOperStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVpCrossConnectEntry_t, atmVpCrossConnectL2HOperStatus),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPCROSSCONNECTH2LOPERSTATUS, "atmVpCrossConnectH2LOperStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVpCrossConnectEntry_t, atmVpCrossConnectH2LOperStatus),
      0,
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      ATM_MIB_ATMVPCROSSCONNECTL2HLASTCHANGE, "atmVpCrossConnectL2HLastChange",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVpCrossConnectEntry_t, atmVpCrossConnectL2HLastChange),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      ATM_MIB_ATMVPCROSSCONNECTH2LLASTCHANGE, "atmVpCrossConnectH2LLastChange",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVpCrossConnectEntry_t, atmVpCrossConnectH2LLastChange),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVPCROSSCONNECTROWSTATUS, "atmVpCrossConnectRowStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVpCrossConnectEntry_t, atmVpCrossConnectRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const atmVcCrossConnectEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 11, 1};

static GNetSnmpAttribute atmVcCrossConnectEntry_attr[] = {
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCROSSCONNECTADMINSTATUS, "atmVcCrossConnectAdminStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVcCrossConnectEntry_t, atmVcCrossConnectAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCROSSCONNECTL2HOPERSTATUS, "atmVcCrossConnectL2HOperStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVcCrossConnectEntry_t, atmVcCrossConnectL2HOperStatus),
      0,
      0 },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCROSSCONNECTH2LOPERSTATUS, "atmVcCrossConnectH2LOperStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVcCrossConnectEntry_t, atmVcCrossConnectH2LOperStatus),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      ATM_MIB_ATMVCCROSSCONNECTL2HLASTCHANGE, "atmVcCrossConnectL2HLastChange",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVcCrossConnectEntry_t, atmVcCrossConnectL2HLastChange),
      0,
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_TIMETICKS,
      ATM_MIB_ATMVCCROSSCONNECTH2LLASTCHANGE, "atmVcCrossConnectH2LLastChange",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVcCrossConnectEntry_t, atmVcCrossConnectH2LLastChange),
      0,
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      ATM_MIB_ATMVCCROSSCONNECTROWSTATUS, "atmVcCrossConnectRowStatus",
       NULL,
      G_STRUCT_OFFSET(atm_mib_atmVcCrossConnectEntry_t, atmVcCrossConnectRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const aal5VccEntry_oid[] = {1, 3, 6, 1, 2, 1, 37, 1, 12, 1};

static GNetSnmpAttribute aal5VccEntry_attr[] = {
    { 3, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      ATM_MIB_AAL5VCCCRCERRORS, "aal5VccCrcErrors",
       NULL,
      G_STRUCT_OFFSET(atm_mib_aal5VccEntry_t, aal5VccCrcErrors),
      0,
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      ATM_MIB_AAL5VCCSARTIMEOUTS, "aal5VccSarTimeOuts",
       NULL,
      G_STRUCT_OFFSET(atm_mib_aal5VccEntry_t, aal5VccSarTimeOuts),
      0,
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_COUNTER32,
      ATM_MIB_AAL5VCCOVERSIZEDSDUS, "aal5VccOverSizedSDUs",
       NULL,
      G_STRUCT_OFFSET(atm_mib_aal5VccEntry_t, aal5VccOverSizedSDUs),
      0,
      0 },
    { 0, 0, 0, NULL }
};


atm_mib_atmMIBObjects_t *
atm_mib_new_atmMIBObjects()
{
    atm_mib_atmMIBObjects_t *atmMIBObjects;

    atmMIBObjects = (atm_mib_atmMIBObjects_t *) g_malloc0(sizeof(atm_mib_atmMIBObjects_t) + sizeof(gpointer));
    return atmMIBObjects;
}

static inline atm_mib_atmMIBObjects_t *
assign_atmMIBObjects(GList *vbl)
{
    atm_mib_atmMIBObjects_t *atmMIBObjects;
    char *p;

    atmMIBObjects = atm_mib_new_atmMIBObjects();
    p = (char *) atmMIBObjects + sizeof(atm_mib_atmMIBObjects_t);
    * (GList **) p = vbl;

    gnet_snmp_attr_assign(vbl, atmMIBObjects_oid, G_N_ELEMENTS(atmMIBObjects_oid),
                      atmMIBObjects_attr, atmMIBObjects);

    return atmMIBObjects;
}

void
atm_mib_get_atmMIBObjects(GNetSnmp *s, atm_mib_atmMIBObjects_t **atmMIBObjects, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    static const guint32 _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 0};
    guint32 base[128];

    *atmMIBObjects = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 9, 8, atmMIBObjects_attr, mask);

    out = gnet_snmp_sync_getnext(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if ((error && *error) || s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmMIBObjects = assign_atmMIBObjects(out);
    }
}

void
atm_mib_free_atmMIBObjects(atm_mib_atmMIBObjects_t *atmMIBObjects)
{
    GList *vbl;
    char *p;

    if (atmMIBObjects) {
        p = (char *) atmMIBObjects + sizeof(atm_mib_atmMIBObjects_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmMIBObjects);
    }
}

atm_mib_atmInterfaceConfEntry_t *
atm_mib_new_atmInterfaceConfEntry()
{
    atm_mib_atmInterfaceConfEntry_t *atmInterfaceConfEntry;

    atmInterfaceConfEntry = (atm_mib_atmInterfaceConfEntry_t *) g_malloc0(sizeof(atm_mib_atmInterfaceConfEntry_t) + sizeof(gpointer));
    return atmInterfaceConfEntry;
}

static inline int
unpack_atmInterfaceConfEntry(GNetSnmpVarBind *vb, atm_mib_atmInterfaceConfEntry_t *atmInterfaceConfEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmInterfaceConfEntry->ifIndex = vb->oid[idx++];
    if ((atmInterfaceConfEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmInterfaceConfEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 11;

    base[idx++] = ifIndex;
    return idx;
}

static inline atm_mib_atmInterfaceConfEntry_t *
assign_atmInterfaceConfEntry(GList *vbl)
{
    atm_mib_atmInterfaceConfEntry_t *atmInterfaceConfEntry;
    char *p;

    atmInterfaceConfEntry = atm_mib_new_atmInterfaceConfEntry();
    p = (char *) atmInterfaceConfEntry + sizeof(atm_mib_atmInterfaceConfEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmInterfaceConfEntry((GNetSnmpVarBind *) vbl->data, atmInterfaceConfEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmInterfaceConfEntry");
        g_free(atmInterfaceConfEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmInterfaceConfEntry_oid, G_N_ELEMENTS(atmInterfaceConfEntry_oid),
                      atmInterfaceConfEntry_attr, atmInterfaceConfEntry);

    return atmInterfaceConfEntry;
}

void
atm_mib_get_atmInterfaceConfTable(GNetSnmp *s, atm_mib_atmInterfaceConfEntry_t ***atmInterfaceConfEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 2, 1, 0};
    guint32 base[128];

    *atmInterfaceConfEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmInterfaceConfEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmInterfaceConfEntry = (atm_mib_atmInterfaceConfEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmInterfaceConfEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmInterfaceConfEntry)[i] = assign_atmInterfaceConfEntry(row->data);
        }
    }
}

void
atm_mib_get_atmInterfaceConfEntry(GNetSnmp *s, atm_mib_atmInterfaceConfEntry_t **atmInterfaceConfEntry, gint32 ifIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmInterfaceConfEntry_oid, sizeof(atmInterfaceConfEntry_oid));
    len = pack_atmInterfaceConfEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmInterfaceConfEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmInterfaceConfEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmInterfaceConfEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmInterfaceConfEntry = assign_atmInterfaceConfEntry(out);
    }
}

void
atm_mib_set_atmInterfaceConfEntry(GNetSnmp *s, atm_mib_atmInterfaceConfEntry_t *atmInterfaceConfEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmInterfaceConfEntry_oid, sizeof(atmInterfaceConfEntry_oid));
    len = pack_atmInterfaceConfEntry(base, atmInterfaceConfEntry->ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmInterfaceConfEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, atmInterfaceConfEntry_attr, mask, atmInterfaceConfEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
atm_mib_free_atmInterfaceConfEntry(atm_mib_atmInterfaceConfEntry_t *atmInterfaceConfEntry)
{
    GList *vbl;
    char *p;

    if (atmInterfaceConfEntry) {
        p = (char *) atmInterfaceConfEntry + sizeof(atm_mib_atmInterfaceConfEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmInterfaceConfEntry);
    }
}

void
atm_mib_free_atmInterfaceConfTable(atm_mib_atmInterfaceConfEntry_t **atmInterfaceConfEntry)
{
    int i;

    if (atmInterfaceConfEntry) {
        for (i = 0; atmInterfaceConfEntry[i]; i++) {
            atm_mib_free_atmInterfaceConfEntry(atmInterfaceConfEntry[i]);
        }
        g_free(atmInterfaceConfEntry);
    }
}

atm_mib_atmInterfaceDs3PlcpEntry_t *
atm_mib_new_atmInterfaceDs3PlcpEntry()
{
    atm_mib_atmInterfaceDs3PlcpEntry_t *atmInterfaceDs3PlcpEntry;

    atmInterfaceDs3PlcpEntry = (atm_mib_atmInterfaceDs3PlcpEntry_t *) g_malloc0(sizeof(atm_mib_atmInterfaceDs3PlcpEntry_t) + sizeof(gpointer));
    return atmInterfaceDs3PlcpEntry;
}

static inline int
unpack_atmInterfaceDs3PlcpEntry(GNetSnmpVarBind *vb, atm_mib_atmInterfaceDs3PlcpEntry_t *atmInterfaceDs3PlcpEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmInterfaceDs3PlcpEntry->ifIndex = vb->oid[idx++];
    if ((atmInterfaceDs3PlcpEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmInterfaceDs3PlcpEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 11;

    base[idx++] = ifIndex;
    return idx;
}

static inline atm_mib_atmInterfaceDs3PlcpEntry_t *
assign_atmInterfaceDs3PlcpEntry(GList *vbl)
{
    atm_mib_atmInterfaceDs3PlcpEntry_t *atmInterfaceDs3PlcpEntry;
    char *p;

    atmInterfaceDs3PlcpEntry = atm_mib_new_atmInterfaceDs3PlcpEntry();
    p = (char *) atmInterfaceDs3PlcpEntry + sizeof(atm_mib_atmInterfaceDs3PlcpEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmInterfaceDs3PlcpEntry((GNetSnmpVarBind *) vbl->data, atmInterfaceDs3PlcpEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmInterfaceDs3PlcpEntry");
        g_free(atmInterfaceDs3PlcpEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmInterfaceDs3PlcpEntry_oid, G_N_ELEMENTS(atmInterfaceDs3PlcpEntry_oid),
                      atmInterfaceDs3PlcpEntry_attr, atmInterfaceDs3PlcpEntry);

    return atmInterfaceDs3PlcpEntry;
}

void
atm_mib_get_atmInterfaceDs3PlcpTable(GNetSnmp *s, atm_mib_atmInterfaceDs3PlcpEntry_t ***atmInterfaceDs3PlcpEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 3, 1, 0};
    guint32 base[128];

    *atmInterfaceDs3PlcpEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmInterfaceDs3PlcpEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmInterfaceDs3PlcpEntry = (atm_mib_atmInterfaceDs3PlcpEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmInterfaceDs3PlcpEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmInterfaceDs3PlcpEntry)[i] = assign_atmInterfaceDs3PlcpEntry(row->data);
        }
    }
}

void
atm_mib_get_atmInterfaceDs3PlcpEntry(GNetSnmp *s, atm_mib_atmInterfaceDs3PlcpEntry_t **atmInterfaceDs3PlcpEntry, gint32 ifIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmInterfaceDs3PlcpEntry_oid, sizeof(atmInterfaceDs3PlcpEntry_oid));
    len = pack_atmInterfaceDs3PlcpEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmInterfaceDs3PlcpEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmInterfaceDs3PlcpEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmInterfaceDs3PlcpEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmInterfaceDs3PlcpEntry = assign_atmInterfaceDs3PlcpEntry(out);
    }
}

void
atm_mib_free_atmInterfaceDs3PlcpEntry(atm_mib_atmInterfaceDs3PlcpEntry_t *atmInterfaceDs3PlcpEntry)
{
    GList *vbl;
    char *p;

    if (atmInterfaceDs3PlcpEntry) {
        p = (char *) atmInterfaceDs3PlcpEntry + sizeof(atm_mib_atmInterfaceDs3PlcpEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmInterfaceDs3PlcpEntry);
    }
}

void
atm_mib_free_atmInterfaceDs3PlcpTable(atm_mib_atmInterfaceDs3PlcpEntry_t **atmInterfaceDs3PlcpEntry)
{
    int i;

    if (atmInterfaceDs3PlcpEntry) {
        for (i = 0; atmInterfaceDs3PlcpEntry[i]; i++) {
            atm_mib_free_atmInterfaceDs3PlcpEntry(atmInterfaceDs3PlcpEntry[i]);
        }
        g_free(atmInterfaceDs3PlcpEntry);
    }
}

atm_mib_atmInterfaceTCEntry_t *
atm_mib_new_atmInterfaceTCEntry()
{
    atm_mib_atmInterfaceTCEntry_t *atmInterfaceTCEntry;

    atmInterfaceTCEntry = (atm_mib_atmInterfaceTCEntry_t *) g_malloc0(sizeof(atm_mib_atmInterfaceTCEntry_t) + sizeof(gpointer));
    return atmInterfaceTCEntry;
}

static inline int
unpack_atmInterfaceTCEntry(GNetSnmpVarBind *vb, atm_mib_atmInterfaceTCEntry_t *atmInterfaceTCEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmInterfaceTCEntry->ifIndex = vb->oid[idx++];
    if ((atmInterfaceTCEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmInterfaceTCEntry(guint32 *base, gint32 ifIndex)
{
    guint8 idx = 11;

    base[idx++] = ifIndex;
    return idx;
}

static inline atm_mib_atmInterfaceTCEntry_t *
assign_atmInterfaceTCEntry(GList *vbl)
{
    atm_mib_atmInterfaceTCEntry_t *atmInterfaceTCEntry;
    char *p;

    atmInterfaceTCEntry = atm_mib_new_atmInterfaceTCEntry();
    p = (char *) atmInterfaceTCEntry + sizeof(atm_mib_atmInterfaceTCEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmInterfaceTCEntry((GNetSnmpVarBind *) vbl->data, atmInterfaceTCEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmInterfaceTCEntry");
        g_free(atmInterfaceTCEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmInterfaceTCEntry_oid, G_N_ELEMENTS(atmInterfaceTCEntry_oid),
                      atmInterfaceTCEntry_attr, atmInterfaceTCEntry);

    return atmInterfaceTCEntry;
}

void
atm_mib_get_atmInterfaceTCTable(GNetSnmp *s, atm_mib_atmInterfaceTCEntry_t ***atmInterfaceTCEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 4, 1, 0};
    guint32 base[128];

    *atmInterfaceTCEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmInterfaceTCEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmInterfaceTCEntry = (atm_mib_atmInterfaceTCEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmInterfaceTCEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmInterfaceTCEntry)[i] = assign_atmInterfaceTCEntry(row->data);
        }
    }
}

void
atm_mib_get_atmInterfaceTCEntry(GNetSnmp *s, atm_mib_atmInterfaceTCEntry_t **atmInterfaceTCEntry, gint32 ifIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmInterfaceTCEntry_oid, sizeof(atmInterfaceTCEntry_oid));
    len = pack_atmInterfaceTCEntry(base, ifIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmInterfaceTCEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmInterfaceTCEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmInterfaceTCEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmInterfaceTCEntry = assign_atmInterfaceTCEntry(out);
    }
}

void
atm_mib_free_atmInterfaceTCEntry(atm_mib_atmInterfaceTCEntry_t *atmInterfaceTCEntry)
{
    GList *vbl;
    char *p;

    if (atmInterfaceTCEntry) {
        p = (char *) atmInterfaceTCEntry + sizeof(atm_mib_atmInterfaceTCEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmInterfaceTCEntry);
    }
}

void
atm_mib_free_atmInterfaceTCTable(atm_mib_atmInterfaceTCEntry_t **atmInterfaceTCEntry)
{
    int i;

    if (atmInterfaceTCEntry) {
        for (i = 0; atmInterfaceTCEntry[i]; i++) {
            atm_mib_free_atmInterfaceTCEntry(atmInterfaceTCEntry[i]);
        }
        g_free(atmInterfaceTCEntry);
    }
}

atm_mib_atmTrafficDescrParamEntry_t *
atm_mib_new_atmTrafficDescrParamEntry()
{
    atm_mib_atmTrafficDescrParamEntry_t *atmTrafficDescrParamEntry;

    atmTrafficDescrParamEntry = (atm_mib_atmTrafficDescrParamEntry_t *) g_malloc0(sizeof(atm_mib_atmTrafficDescrParamEntry_t) + sizeof(gpointer));
    return atmTrafficDescrParamEntry;
}

static inline int
unpack_atmTrafficDescrParamEntry(GNetSnmpVarBind *vb, atm_mib_atmTrafficDescrParamEntry_t *atmTrafficDescrParamEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmTrafficDescrParamEntry->atmTrafficDescrParamIndex = vb->oid[idx++];
    if ((atmTrafficDescrParamEntry->atmTrafficDescrParamIndex < 1)
        && (atmTrafficDescrParamEntry->atmTrafficDescrParamIndex < 0)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmTrafficDescrParamEntry(guint32 *base, gint32 atmTrafficDescrParamIndex)
{
    guint8 idx = 11;

    base[idx++] = atmTrafficDescrParamIndex;
    return idx;
}

static inline atm_mib_atmTrafficDescrParamEntry_t *
assign_atmTrafficDescrParamEntry(GList *vbl)
{
    atm_mib_atmTrafficDescrParamEntry_t *atmTrafficDescrParamEntry;
    char *p;

    atmTrafficDescrParamEntry = atm_mib_new_atmTrafficDescrParamEntry();
    p = (char *) atmTrafficDescrParamEntry + sizeof(atm_mib_atmTrafficDescrParamEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmTrafficDescrParamEntry((GNetSnmpVarBind *) vbl->data, atmTrafficDescrParamEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmTrafficDescrParamEntry");
        g_free(atmTrafficDescrParamEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmTrafficDescrParamEntry_oid, G_N_ELEMENTS(atmTrafficDescrParamEntry_oid),
                      atmTrafficDescrParamEntry_attr, atmTrafficDescrParamEntry);

    return atmTrafficDescrParamEntry;
}

void
atm_mib_get_atmTrafficDescrParamTable(GNetSnmp *s, atm_mib_atmTrafficDescrParamEntry_t ***atmTrafficDescrParamEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 5, 1, 0};
    guint32 base[128];

    *atmTrafficDescrParamEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmTrafficDescrParamEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmTrafficDescrParamEntry = (atm_mib_atmTrafficDescrParamEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmTrafficDescrParamEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmTrafficDescrParamEntry)[i] = assign_atmTrafficDescrParamEntry(row->data);
        }
    }
}

void
atm_mib_get_atmTrafficDescrParamEntry(GNetSnmp *s, atm_mib_atmTrafficDescrParamEntry_t **atmTrafficDescrParamEntry, gint32 atmTrafficDescrParamIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmTrafficDescrParamEntry_oid, sizeof(atmTrafficDescrParamEntry_oid));
    len = pack_atmTrafficDescrParamEntry(base, atmTrafficDescrParamIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmTrafficDescrParamEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmTrafficDescrParamEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmTrafficDescrParamEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmTrafficDescrParamEntry = assign_atmTrafficDescrParamEntry(out);
    }
}

void
atm_mib_set_atmTrafficDescrParamEntry(GNetSnmp *s, atm_mib_atmTrafficDescrParamEntry_t *atmTrafficDescrParamEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmTrafficDescrParamEntry_oid, sizeof(atmTrafficDescrParamEntry_oid));
    len = pack_atmTrafficDescrParamEntry(base, atmTrafficDescrParamEntry->atmTrafficDescrParamIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmTrafficDescrParamEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, atmTrafficDescrParamEntry_attr, mask, atmTrafficDescrParamEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
atm_mib_free_atmTrafficDescrParamEntry(atm_mib_atmTrafficDescrParamEntry_t *atmTrafficDescrParamEntry)
{
    GList *vbl;
    char *p;

    if (atmTrafficDescrParamEntry) {
        p = (char *) atmTrafficDescrParamEntry + sizeof(atm_mib_atmTrafficDescrParamEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmTrafficDescrParamEntry);
    }
}

void
atm_mib_free_atmTrafficDescrParamTable(atm_mib_atmTrafficDescrParamEntry_t **atmTrafficDescrParamEntry)
{
    int i;

    if (atmTrafficDescrParamEntry) {
        for (i = 0; atmTrafficDescrParamEntry[i]; i++) {
            atm_mib_free_atmTrafficDescrParamEntry(atmTrafficDescrParamEntry[i]);
        }
        g_free(atmTrafficDescrParamEntry);
    }
}

atm_mib_atmVplEntry_t *
atm_mib_new_atmVplEntry()
{
    atm_mib_atmVplEntry_t *atmVplEntry;

    atmVplEntry = (atm_mib_atmVplEntry_t *) g_malloc0(sizeof(atm_mib_atmVplEntry_t) + sizeof(gpointer));
    return atmVplEntry;
}

static inline int
unpack_atmVplEntry(GNetSnmpVarBind *vb, atm_mib_atmVplEntry_t *atmVplEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmVplEntry->ifIndex = vb->oid[idx++];
    if ((atmVplEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVplEntry->atmVplVpi = vb->oid[idx++];
    if ((atmVplEntry->atmVplVpi < 0 || atmVplEntry->atmVplVpi > 4095)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmVplEntry(guint32 *base, gint32 ifIndex, gint32 atmVplVpi)
{
    guint8 idx = 11;

    base[idx++] = ifIndex;
    base[idx++] = atmVplVpi;
    return idx;
}

static inline atm_mib_atmVplEntry_t *
assign_atmVplEntry(GList *vbl)
{
    atm_mib_atmVplEntry_t *atmVplEntry;
    char *p;

    atmVplEntry = atm_mib_new_atmVplEntry();
    p = (char *) atmVplEntry + sizeof(atm_mib_atmVplEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmVplEntry((GNetSnmpVarBind *) vbl->data, atmVplEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmVplEntry");
        g_free(atmVplEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmVplEntry_oid, G_N_ELEMENTS(atmVplEntry_oid),
                      atmVplEntry_attr, atmVplEntry);

    return atmVplEntry;
}

void
atm_mib_get_atmVplTable(GNetSnmp *s, atm_mib_atmVplEntry_t ***atmVplEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 6, 1, 0};
    guint32 base[128];

    *atmVplEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmVplEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmVplEntry = (atm_mib_atmVplEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmVplEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmVplEntry)[i] = assign_atmVplEntry(row->data);
        }
    }
}

void
atm_mib_get_atmVplEntry(GNetSnmp *s, atm_mib_atmVplEntry_t **atmVplEntry, gint32 ifIndex, gint32 atmVplVpi, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVplEntry_oid, sizeof(atmVplEntry_oid));
    len = pack_atmVplEntry(base, ifIndex, atmVplVpi);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVplEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmVplEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmVplEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmVplEntry = assign_atmVplEntry(out);
    }
}

void
atm_mib_set_atmVplEntry(GNetSnmp *s, atm_mib_atmVplEntry_t *atmVplEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVplEntry_oid, sizeof(atmVplEntry_oid));
    len = pack_atmVplEntry(base, atmVplEntry->ifIndex, atmVplEntry->atmVplVpi);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVplEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, atmVplEntry_attr, mask, atmVplEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
atm_mib_free_atmVplEntry(atm_mib_atmVplEntry_t *atmVplEntry)
{
    GList *vbl;
    char *p;

    if (atmVplEntry) {
        p = (char *) atmVplEntry + sizeof(atm_mib_atmVplEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmVplEntry);
    }
}

void
atm_mib_free_atmVplTable(atm_mib_atmVplEntry_t **atmVplEntry)
{
    int i;

    if (atmVplEntry) {
        for (i = 0; atmVplEntry[i]; i++) {
            atm_mib_free_atmVplEntry(atmVplEntry[i]);
        }
        g_free(atmVplEntry);
    }
}

atm_mib_atmVclEntry_t *
atm_mib_new_atmVclEntry()
{
    atm_mib_atmVclEntry_t *atmVclEntry;

    atmVclEntry = (atm_mib_atmVclEntry_t *) g_malloc0(sizeof(atm_mib_atmVclEntry_t) + sizeof(gpointer));
    return atmVclEntry;
}

static inline int
unpack_atmVclEntry(GNetSnmpVarBind *vb, atm_mib_atmVclEntry_t *atmVclEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmVclEntry->ifIndex = vb->oid[idx++];
    if ((atmVclEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVclEntry->atmVclVpi = vb->oid[idx++];
    if ((atmVclEntry->atmVclVpi < 0 || atmVclEntry->atmVclVpi > 4095)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVclEntry->atmVclVci = vb->oid[idx++];
    if ((atmVclEntry->atmVclVci < 0 || atmVclEntry->atmVclVci > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmVclEntry(guint32 *base, gint32 ifIndex, gint32 atmVclVpi, gint32 atmVclVci)
{
    guint8 idx = 11;

    base[idx++] = ifIndex;
    base[idx++] = atmVclVpi;
    base[idx++] = atmVclVci;
    return idx;
}

static inline atm_mib_atmVclEntry_t *
assign_atmVclEntry(GList *vbl)
{
    atm_mib_atmVclEntry_t *atmVclEntry;
    char *p;

    atmVclEntry = atm_mib_new_atmVclEntry();
    p = (char *) atmVclEntry + sizeof(atm_mib_atmVclEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmVclEntry((GNetSnmpVarBind *) vbl->data, atmVclEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmVclEntry");
        g_free(atmVclEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmVclEntry_oid, G_N_ELEMENTS(atmVclEntry_oid),
                      atmVclEntry_attr, atmVclEntry);

    return atmVclEntry;
}

void
atm_mib_get_atmVclTable(GNetSnmp *s, atm_mib_atmVclEntry_t ***atmVclEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 7, 1, 0};
    guint32 base[128];

    *atmVclEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmVclEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmVclEntry = (atm_mib_atmVclEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmVclEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmVclEntry)[i] = assign_atmVclEntry(row->data);
        }
    }
}

void
atm_mib_get_atmVclEntry(GNetSnmp *s, atm_mib_atmVclEntry_t **atmVclEntry, gint32 ifIndex, gint32 atmVclVpi, gint32 atmVclVci, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVclEntry_oid, sizeof(atmVclEntry_oid));
    len = pack_atmVclEntry(base, ifIndex, atmVclVpi, atmVclVci);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVclEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmVclEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmVclEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmVclEntry = assign_atmVclEntry(out);
    }
}

void
atm_mib_set_atmVclEntry(GNetSnmp *s, atm_mib_atmVclEntry_t *atmVclEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVclEntry_oid, sizeof(atmVclEntry_oid));
    len = pack_atmVclEntry(base, atmVclEntry->ifIndex, atmVclEntry->atmVclVpi, atmVclEntry->atmVclVci);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVclEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, atmVclEntry_attr, mask, atmVclEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
atm_mib_free_atmVclEntry(atm_mib_atmVclEntry_t *atmVclEntry)
{
    GList *vbl;
    char *p;

    if (atmVclEntry) {
        p = (char *) atmVclEntry + sizeof(atm_mib_atmVclEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmVclEntry);
    }
}

void
atm_mib_free_atmVclTable(atm_mib_atmVclEntry_t **atmVclEntry)
{
    int i;

    if (atmVclEntry) {
        for (i = 0; atmVclEntry[i]; i++) {
            atm_mib_free_atmVclEntry(atmVclEntry[i]);
        }
        g_free(atmVclEntry);
    }
}

atm_mib_atmVpCrossConnectEntry_t *
atm_mib_new_atmVpCrossConnectEntry()
{
    atm_mib_atmVpCrossConnectEntry_t *atmVpCrossConnectEntry;

    atmVpCrossConnectEntry = (atm_mib_atmVpCrossConnectEntry_t *) g_malloc0(sizeof(atm_mib_atmVpCrossConnectEntry_t) + sizeof(gpointer));
    return atmVpCrossConnectEntry;
}

static inline int
unpack_atmVpCrossConnectEntry(GNetSnmpVarBind *vb, atm_mib_atmVpCrossConnectEntry_t *atmVpCrossConnectEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmVpCrossConnectEntry->atmVpCrossConnectIndex = vb->oid[idx++];
    if ((atmVpCrossConnectEntry->atmVpCrossConnectIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVpCrossConnectEntry->atmVpCrossConnectLowIfIndex = vb->oid[idx++];
    if ((atmVpCrossConnectEntry->atmVpCrossConnectLowIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVpCrossConnectEntry->atmVpCrossConnectLowVpi = vb->oid[idx++];
    if ((atmVpCrossConnectEntry->atmVpCrossConnectLowVpi < 0 || atmVpCrossConnectEntry->atmVpCrossConnectLowVpi > 4095)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVpCrossConnectEntry->atmVpCrossConnectHighIfIndex = vb->oid[idx++];
    if ((atmVpCrossConnectEntry->atmVpCrossConnectHighIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVpCrossConnectEntry->atmVpCrossConnectHighVpi = vb->oid[idx++];
    if ((atmVpCrossConnectEntry->atmVpCrossConnectHighVpi < 0 || atmVpCrossConnectEntry->atmVpCrossConnectHighVpi > 4095)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmVpCrossConnectEntry(guint32 *base, gint32 atmVpCrossConnectIndex, gint32 atmVpCrossConnectLowIfIndex, gint32 atmVpCrossConnectLowVpi, gint32 atmVpCrossConnectHighIfIndex, gint32 atmVpCrossConnectHighVpi)
{
    guint8 idx = 11;

    base[idx++] = atmVpCrossConnectIndex;
    base[idx++] = atmVpCrossConnectLowIfIndex;
    base[idx++] = atmVpCrossConnectLowVpi;
    base[idx++] = atmVpCrossConnectHighIfIndex;
    base[idx++] = atmVpCrossConnectHighVpi;
    return idx;
}

static inline atm_mib_atmVpCrossConnectEntry_t *
assign_atmVpCrossConnectEntry(GList *vbl)
{
    atm_mib_atmVpCrossConnectEntry_t *atmVpCrossConnectEntry;
    char *p;

    atmVpCrossConnectEntry = atm_mib_new_atmVpCrossConnectEntry();
    p = (char *) atmVpCrossConnectEntry + sizeof(atm_mib_atmVpCrossConnectEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmVpCrossConnectEntry((GNetSnmpVarBind *) vbl->data, atmVpCrossConnectEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmVpCrossConnectEntry");
        g_free(atmVpCrossConnectEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmVpCrossConnectEntry_oid, G_N_ELEMENTS(atmVpCrossConnectEntry_oid),
                      atmVpCrossConnectEntry_attr, atmVpCrossConnectEntry);

    return atmVpCrossConnectEntry;
}

void
atm_mib_get_atmVpCrossConnectTable(GNetSnmp *s, atm_mib_atmVpCrossConnectEntry_t ***atmVpCrossConnectEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 9, 1, 0};
    guint32 base[128];

    *atmVpCrossConnectEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmVpCrossConnectEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmVpCrossConnectEntry = (atm_mib_atmVpCrossConnectEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmVpCrossConnectEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmVpCrossConnectEntry)[i] = assign_atmVpCrossConnectEntry(row->data);
        }
    }
}

void
atm_mib_get_atmVpCrossConnectEntry(GNetSnmp *s, atm_mib_atmVpCrossConnectEntry_t **atmVpCrossConnectEntry, gint32 atmVpCrossConnectIndex, gint32 atmVpCrossConnectLowIfIndex, gint32 atmVpCrossConnectLowVpi, gint32 atmVpCrossConnectHighIfIndex, gint32 atmVpCrossConnectHighVpi, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVpCrossConnectEntry_oid, sizeof(atmVpCrossConnectEntry_oid));
    len = pack_atmVpCrossConnectEntry(base, atmVpCrossConnectIndex, atmVpCrossConnectLowIfIndex, atmVpCrossConnectLowVpi, atmVpCrossConnectHighIfIndex, atmVpCrossConnectHighVpi);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVpCrossConnectEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmVpCrossConnectEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmVpCrossConnectEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmVpCrossConnectEntry = assign_atmVpCrossConnectEntry(out);
    }
}

void
atm_mib_set_atmVpCrossConnectEntry(GNetSnmp *s, atm_mib_atmVpCrossConnectEntry_t *atmVpCrossConnectEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVpCrossConnectEntry_oid, sizeof(atmVpCrossConnectEntry_oid));
    len = pack_atmVpCrossConnectEntry(base, atmVpCrossConnectEntry->atmVpCrossConnectIndex, atmVpCrossConnectEntry->atmVpCrossConnectLowIfIndex, atmVpCrossConnectEntry->atmVpCrossConnectLowVpi, atmVpCrossConnectEntry->atmVpCrossConnectHighIfIndex, atmVpCrossConnectEntry->atmVpCrossConnectHighVpi);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVpCrossConnectEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, atmVpCrossConnectEntry_attr, mask, atmVpCrossConnectEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
atm_mib_free_atmVpCrossConnectEntry(atm_mib_atmVpCrossConnectEntry_t *atmVpCrossConnectEntry)
{
    GList *vbl;
    char *p;

    if (atmVpCrossConnectEntry) {
        p = (char *) atmVpCrossConnectEntry + sizeof(atm_mib_atmVpCrossConnectEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmVpCrossConnectEntry);
    }
}

void
atm_mib_free_atmVpCrossConnectTable(atm_mib_atmVpCrossConnectEntry_t **atmVpCrossConnectEntry)
{
    int i;

    if (atmVpCrossConnectEntry) {
        for (i = 0; atmVpCrossConnectEntry[i]; i++) {
            atm_mib_free_atmVpCrossConnectEntry(atmVpCrossConnectEntry[i]);
        }
        g_free(atmVpCrossConnectEntry);
    }
}

atm_mib_atmVcCrossConnectEntry_t *
atm_mib_new_atmVcCrossConnectEntry()
{
    atm_mib_atmVcCrossConnectEntry_t *atmVcCrossConnectEntry;

    atmVcCrossConnectEntry = (atm_mib_atmVcCrossConnectEntry_t *) g_malloc0(sizeof(atm_mib_atmVcCrossConnectEntry_t) + sizeof(gpointer));
    return atmVcCrossConnectEntry;
}

static inline int
unpack_atmVcCrossConnectEntry(GNetSnmpVarBind *vb, atm_mib_atmVcCrossConnectEntry_t *atmVcCrossConnectEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    atmVcCrossConnectEntry->atmVcCrossConnectIndex = vb->oid[idx++];
    if ((atmVcCrossConnectEntry->atmVcCrossConnectIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVcCrossConnectEntry->atmVcCrossConnectLowIfIndex = vb->oid[idx++];
    if ((atmVcCrossConnectEntry->atmVcCrossConnectLowIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVcCrossConnectEntry->atmVcCrossConnectLowVpi = vb->oid[idx++];
    if ((atmVcCrossConnectEntry->atmVcCrossConnectLowVpi < 0 || atmVcCrossConnectEntry->atmVcCrossConnectLowVpi > 4095)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVcCrossConnectEntry->atmVcCrossConnectLowVci = vb->oid[idx++];
    if ((atmVcCrossConnectEntry->atmVcCrossConnectLowVci < 0 || atmVcCrossConnectEntry->atmVcCrossConnectLowVci > 65535)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVcCrossConnectEntry->atmVcCrossConnectHighIfIndex = vb->oid[idx++];
    if ((atmVcCrossConnectEntry->atmVcCrossConnectHighIfIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVcCrossConnectEntry->atmVcCrossConnectHighVpi = vb->oid[idx++];
    if ((atmVcCrossConnectEntry->atmVcCrossConnectHighVpi < 0 || atmVcCrossConnectEntry->atmVcCrossConnectHighVpi > 4095)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    atmVcCrossConnectEntry->atmVcCrossConnectHighVci = vb->oid[idx++];
    if ((atmVcCrossConnectEntry->atmVcCrossConnectHighVci < 0 || atmVcCrossConnectEntry->atmVcCrossConnectHighVci > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_atmVcCrossConnectEntry(guint32 *base, gint32 atmVcCrossConnectIndex, gint32 atmVcCrossConnectLowIfIndex, gint32 atmVcCrossConnectLowVpi, gint32 atmVcCrossConnectLowVci, gint32 atmVcCrossConnectHighIfIndex, gint32 atmVcCrossConnectHighVpi, gint32 atmVcCrossConnectHighVci)
{
    guint8 idx = 11;

    base[idx++] = atmVcCrossConnectIndex;
    base[idx++] = atmVcCrossConnectLowIfIndex;
    base[idx++] = atmVcCrossConnectLowVpi;
    base[idx++] = atmVcCrossConnectLowVci;
    base[idx++] = atmVcCrossConnectHighIfIndex;
    base[idx++] = atmVcCrossConnectHighVpi;
    base[idx++] = atmVcCrossConnectHighVci;
    return idx;
}

static inline atm_mib_atmVcCrossConnectEntry_t *
assign_atmVcCrossConnectEntry(GList *vbl)
{
    atm_mib_atmVcCrossConnectEntry_t *atmVcCrossConnectEntry;
    char *p;

    atmVcCrossConnectEntry = atm_mib_new_atmVcCrossConnectEntry();
    p = (char *) atmVcCrossConnectEntry + sizeof(atm_mib_atmVcCrossConnectEntry_t);
    * (GList **) p = vbl;

    if (unpack_atmVcCrossConnectEntry((GNetSnmpVarBind *) vbl->data, atmVcCrossConnectEntry) < 0) {
        g_warning("%s: invalid instance identifier", "atmVcCrossConnectEntry");
        g_free(atmVcCrossConnectEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, atmVcCrossConnectEntry_oid, G_N_ELEMENTS(atmVcCrossConnectEntry_oid),
                      atmVcCrossConnectEntry_attr, atmVcCrossConnectEntry);

    return atmVcCrossConnectEntry;
}

void
atm_mib_get_atmVcCrossConnectTable(GNetSnmp *s, atm_mib_atmVcCrossConnectEntry_t ***atmVcCrossConnectEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 11, 1, 0};
    guint32 base[128];

    *atmVcCrossConnectEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, atmVcCrossConnectEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *atmVcCrossConnectEntry = (atm_mib_atmVcCrossConnectEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_atmVcCrossConnectEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*atmVcCrossConnectEntry)[i] = assign_atmVcCrossConnectEntry(row->data);
        }
    }
}

void
atm_mib_get_atmVcCrossConnectEntry(GNetSnmp *s, atm_mib_atmVcCrossConnectEntry_t **atmVcCrossConnectEntry, gint32 atmVcCrossConnectIndex, gint32 atmVcCrossConnectLowIfIndex, gint32 atmVcCrossConnectLowVpi, gint32 atmVcCrossConnectLowVci, gint32 atmVcCrossConnectHighIfIndex, gint32 atmVcCrossConnectHighVpi, gint32 atmVcCrossConnectHighVci, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVcCrossConnectEntry_oid, sizeof(atmVcCrossConnectEntry_oid));
    len = pack_atmVcCrossConnectEntry(base, atmVcCrossConnectIndex, atmVcCrossConnectLowIfIndex, atmVcCrossConnectLowVpi, atmVcCrossConnectLowVci, atmVcCrossConnectHighIfIndex, atmVcCrossConnectHighVpi, atmVcCrossConnectHighVci);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVcCrossConnectEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *atmVcCrossConnectEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, atmVcCrossConnectEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *atmVcCrossConnectEntry = assign_atmVcCrossConnectEntry(out);
    }
}

void
atm_mib_set_atmVcCrossConnectEntry(GNetSnmp *s, atm_mib_atmVcCrossConnectEntry_t *atmVcCrossConnectEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, atmVcCrossConnectEntry_oid, sizeof(atmVcCrossConnectEntry_oid));
    len = pack_atmVcCrossConnectEntry(base, atmVcCrossConnectEntry->atmVcCrossConnectIndex, atmVcCrossConnectEntry->atmVcCrossConnectLowIfIndex, atmVcCrossConnectEntry->atmVcCrossConnectLowVpi, atmVcCrossConnectEntry->atmVcCrossConnectLowVci, atmVcCrossConnectEntry->atmVcCrossConnectHighIfIndex, atmVcCrossConnectEntry->atmVcCrossConnectHighVpi, atmVcCrossConnectEntry->atmVcCrossConnectHighVci);
    if (len < 0) {
        g_warning("%s: invalid index values", "atmVcCrossConnectEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 10, atmVcCrossConnectEntry_attr, mask, atmVcCrossConnectEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
atm_mib_free_atmVcCrossConnectEntry(atm_mib_atmVcCrossConnectEntry_t *atmVcCrossConnectEntry)
{
    GList *vbl;
    char *p;

    if (atmVcCrossConnectEntry) {
        p = (char *) atmVcCrossConnectEntry + sizeof(atm_mib_atmVcCrossConnectEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(atmVcCrossConnectEntry);
    }
}

void
atm_mib_free_atmVcCrossConnectTable(atm_mib_atmVcCrossConnectEntry_t **atmVcCrossConnectEntry)
{
    int i;

    if (atmVcCrossConnectEntry) {
        for (i = 0; atmVcCrossConnectEntry[i]; i++) {
            atm_mib_free_atmVcCrossConnectEntry(atmVcCrossConnectEntry[i]);
        }
        g_free(atmVcCrossConnectEntry);
    }
}

atm_mib_aal5VccEntry_t *
atm_mib_new_aal5VccEntry()
{
    atm_mib_aal5VccEntry_t *aal5VccEntry;

    aal5VccEntry = (atm_mib_aal5VccEntry_t *) g_malloc0(sizeof(atm_mib_aal5VccEntry_t) + sizeof(gpointer));
    return aal5VccEntry;
}

static inline int
unpack_aal5VccEntry(GNetSnmpVarBind *vb, atm_mib_aal5VccEntry_t *aal5VccEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    aal5VccEntry->ifIndex = vb->oid[idx++];
    if ((aal5VccEntry->ifIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    aal5VccEntry->aal5VccVpi = vb->oid[idx++];
    if ((aal5VccEntry->aal5VccVpi < 0 || aal5VccEntry->aal5VccVpi > 4095)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    aal5VccEntry->aal5VccVci = vb->oid[idx++];
    if ((aal5VccEntry->aal5VccVci < 0 || aal5VccEntry->aal5VccVci > 65535)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_aal5VccEntry(guint32 *base, gint32 ifIndex, gint32 aal5VccVpi, gint32 aal5VccVci)
{
    guint8 idx = 11;

    base[idx++] = ifIndex;
    base[idx++] = aal5VccVpi;
    base[idx++] = aal5VccVci;
    return idx;
}

static inline atm_mib_aal5VccEntry_t *
assign_aal5VccEntry(GList *vbl)
{
    atm_mib_aal5VccEntry_t *aal5VccEntry;
    char *p;

    aal5VccEntry = atm_mib_new_aal5VccEntry();
    p = (char *) aal5VccEntry + sizeof(atm_mib_aal5VccEntry_t);
    * (GList **) p = vbl;

    if (unpack_aal5VccEntry((GNetSnmpVarBind *) vbl->data, aal5VccEntry) < 0) {
        g_warning("%s: invalid instance identifier", "aal5VccEntry");
        g_free(aal5VccEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, aal5VccEntry_oid, G_N_ELEMENTS(aal5VccEntry_oid),
                      aal5VccEntry_attr, aal5VccEntry);

    return aal5VccEntry;
}

void
atm_mib_get_aal5VccTable(GNetSnmp *s, atm_mib_aal5VccEntry_t ***aal5VccEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 37, 1, 12, 1, 0};
    guint32 base[128];

    *aal5VccEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, aal5VccEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *aal5VccEntry = (atm_mib_aal5VccEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(atm_mib_aal5VccEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*aal5VccEntry)[i] = assign_aal5VccEntry(row->data);
        }
    }
}

void
atm_mib_get_aal5VccEntry(GNetSnmp *s, atm_mib_aal5VccEntry_t **aal5VccEntry, gint32 ifIndex, gint32 aal5VccVpi, gint32 aal5VccVci, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, aal5VccEntry_oid, sizeof(aal5VccEntry_oid));
    len = pack_aal5VccEntry(base, ifIndex, aal5VccVpi, aal5VccVci);
    if (len < 0) {
        g_warning("%s: invalid index values", "aal5VccEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *aal5VccEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, aal5VccEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *aal5VccEntry = assign_aal5VccEntry(out);
    }
}

void
atm_mib_free_aal5VccEntry(atm_mib_aal5VccEntry_t *aal5VccEntry)
{
    GList *vbl;
    char *p;

    if (aal5VccEntry) {
        p = (char *) aal5VccEntry + sizeof(atm_mib_aal5VccEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(aal5VccEntry);
    }
}

void
atm_mib_free_aal5VccTable(atm_mib_aal5VccEntry_t **aal5VccEntry)
{
    int i;

    if (aal5VccEntry) {
        for (i = 0; aal5VccEntry[i]; i++) {
            atm_mib_free_aal5VccEntry(aal5VccEntry[i]);
        }
        g_free(aal5VccEntry);
    }
}


