package org.codehaus.groovy.classgen.asm

/**
 * Test the utility class InstructionSequence for testing bytecode instructions generated by Groovy
 *
 * @author Guillaume Laforge
 */
class InstructionSequenceHelperClassTest extends GroovyTestCase {

    static final seq = new InstructionSequence(instructions: [
                "A 1",
                "B 2",
                "C",
                "D 3",
                "E 4",
                "F"
        ])

    void testSequence() {
        assert seq.hasSequence([
                "A 1",
                "B 2",
                "C",
                "D 3",
                "E 4",
                "F"
        ])

        assert seq.hasSequence([
                "A",
                "B",
                "C",
                "D",
                "E",
                "F"
        ])

        assert seq.hasSequence([
                "A 1",
                "C",
                "E 4",
        ])

        assert seq.hasSequence([
                "A",
                "E 4",
        ])
    }

    void testStrictSequence() {
        assert seq.hasStrictSequence([
                "A 1",
                "B 2",
                "C",
                "D 3",
                "E 4",
                "F"
        ])

        assert seq.hasStrictSequence([
                "B 2",
                "C",
                "D 3",
        ])

        assert seq.hasStrictSequence([
                "A",
                "B",
                "C",
                "D",
                "E",
                "F"
        ])

        assert seq.hasStrictSequence([
                "B",
                "C",
                "D",
        ])
    }

    void testStrictSequenceWithBytecodeExample() {
        def instrs = new InstructionSequence(instructions: [
                "ILOAD 9",
                "ILOAD 11",
                "IADD"
        ])

        assert instrs.hasStrictSequence([
                "ILOAD",
                "ILOAD",
                "IADD"
        ])
    }
    
    void testStrictSequencePatternPrefixRepetition() {
        def instrs = new InstructionSequence(instructions: [
                "A", "A", "B",
                "A", "A", "C",
        ])

        assert instrs.hasStrictSequence([
                "A", "A", "B"
        ])
        assert instrs.hasStrictSequence([
                "A", "A", "C"
        ])
    }
    
}
