/* -*- c++ -*- */
/*
 * Copyright 2012,2018 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */


#ifndef ABS_BLK_IMPL_H
#define ABS_BLK_IMPL_H

#include <gnuradio/blocks/abs_blk.h>

namespace gr {
namespace blocks {

template <class T>
class BLOCKS_API abs_blk_impl : public abs_blk<T>
{
private:
    const size_t d_vlen;

public:
    abs_blk_impl(size_t vlen);

    int work(int noutput_items,
             gr_vector_const_void_star& input_items,
             gr_vector_void_star& output_items) override;
};

} /* namespace blocks */
} /* namespace gr */

#endif /* ABS_BLK_IMPL_H */
