/* 
 * Copyright (C) 2004, 2005 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GT_LANGUAGE_VIEW_H
#define _GT_LANGUAGE_VIEW_H

#include <gtk/gtk.h>
#include <translate.h>

void gt_language_view_setup_pair (GtkTreeView *source_view,
				  const char *source_conf_key,
				  GtkTreeView *dest_view,
				  const char *dest_conf_key,
				  TranslatePairFlags pair_flags,
				  GCallback selection_changed_handler);

char *gt_language_view_get_selected (GtkTreeView *view);
gboolean gt_language_view_has_selected (GtkTreeView *view);

void gt_language_view_select (GtkTreeView *view, const char *tag);

#endif /* _GT_LANGUAGE_VIEW_H */
