/* PROGRAM:     eggsh
 * FILE:        $Header: /home/egg/src/RCS/network.h,v 1.6 1999/02/28 20:14:26 ghn Exp $
 * PURPOSE:     Definitions for network communication functions
 * AUTHOR:      Greg Nelson
 * DATE:        98-05-09
 *
 * REVISED:
 * $Log: network.h,v $
 * Revision 1.6  1999/02/28 20:14:26  ghn
 * Version 5.1: Modified InitNetwork to take interface (addr) argument as
 * well as port, and handle various cases of interface (NULL, IP,
 * hostname) gracefully.  Modified NetUp to call this new version.
 *
 * Revision 1.5  1999/01/02 00:02:24  ghn
 * Modified NetTalk() api to offer "gripe" argument to silence some perror()s.
 *
 * Revision 1.4  1998/12/31 22:11:05  ghn
 *  Rev 5 code: includes multi-reg support, HTML, etc.
 *
 * Revision 1.3  1998/08/01 18:51:25  ghn
 * Added John's byte-order-independence changes.
 *
 * Revision 1.2  1998/08/01 17:17:40  ghn
 * Added DND support.
 *
 * Revision 1.1  1998/07/21 11:36:34  ghn
 * Initial revision
 *
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

#ifndef _NETWORK_H
#define _NETWORK_H

#include <netinet/in.h>

#ifdef TESTPORT
#define EGGPORT         2074
#define BASKETPORT      2075
#else
#define	EGGPORT		1105
#define	BASKETPORT	2510
#endif

/* Initialize network subsystem, returning socket descriptor */
extern int32 InitNetwork(char *addr, int32 port);

/* Bring net up with command */
extern int32 NetUp(char *cmd, char *addr, int32 port);

/* Bring net down with command */
extern int NetDown(char *cmd, int32 oldsd);

/* Get a sockaddr given a host and port */
extern int NetGetAddr(struct sockaddr_in *sin, char *host, uint16 port);

/* Listen for a data request.

   Listen on specified socket sd.  When one is received, validate the
   checksum, and, if successful, allocate memory and stuff it as a
   character array.  Return the remote sockaddr_in, if the sin pointer
   is not null, and block until something interesting happens if block
   is true. */
extern int NetListen(int sd, char **pktbuf, 
		     struct sockaddr_in *sin,
		     int block);

/* Send a data packet.

   Create a socket, checksum the packet, and send it to the specified
   addr in sin.  Length of packet to be extracted from packet
   header. */
extern int NetTalk(struct sockaddr_in *sin, char *pkt, int gripe);

#endif /* !_NETWORK_H */
