/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2014 by The University of Queensland //
// Centre for Geoscience Computing                         //
// http://earth.uq.edu.au/centre-geoscience-computing      //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __EWALLINTERACTION_H
#define __EWALLINTERACTION_H

#include "Model/WallInteraction.h"
#include "Model/Wall.h"
#include "Model/Particle.h"
#include "Model/RotParticle.h"

/*!
  \class CElasticWallInteraction
  \brief unbonded elastic interaction between a particle and a wall

  \author Steffen Abe
  $Revision$
  $Date$  
*/
template <class T>
class CElasticWallInteraction : public AWallInteraction<T>
{
protected:
  double m_k;//!< spring constant
public:
  CElasticWallInteraction();
  CElasticWallInteraction(T*,CWall*,double,bool);
  virtual ~CElasticWallInteraction(){};

  virtual void calcForces();
  virtual Vec3 getForce();
  virtual void setPP(const vector<T*>){};
  virtual double getStiffness();
};

#include "EWallInteraction.hpp"

#endif //__EWALLINTERACTION_H
