/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 *  Copyright © 2019 Jan-Michael Brummer <jan.brummer@tabos.org>
 *
 *  This file is part of Epiphany.
 *
 *  Epiphany is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Epiphany is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Epiphany.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <glib.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

typedef enum {
  EPHY_FAVICON_TYPE_SHOW_MISSING_PLACEHOLDER,
  EPHY_FAVICON_TYPE_NO_MISSING_PLACEHOLDER
} EphyFaviconType;

gboolean is_desktop_pantheon (void);
gboolean is_desktop_gnome (void);

GtkIconSize get_icon_size (void);

const char *ephy_get_fallback_favicon_name (const char *title, EphyFaviconType type);

G_END_DECLS
