/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class XPath
implements Serializable,
ExpressionOwner {
    static final long serialVersionUID = 3976493477939110553L;
    private Expression m_mainExp;
    private transient FunctionTable m_funcTable = null;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    private void initFunctionTable() {
        this.m_funcTable = new FunctionTable();
    }

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_mainExp.fixupVariables(vars, globalsSize);
    }

    public void setExpression(Expression exp) {
        if (this.m_mainExp != null) {
            exp.exprSetParent(this.m_mainExp.exprGetParent());
        }
        this.m_mainExp = exp;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp;
    }

    public String getPatternString() {
        return this.m_patternString;
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        this.initFunctionTable();
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator, this.m_funcTable);
        if (type == 0) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(type)}));
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
        if (locator != null && locator instanceof ExpressionNode) {
            expr.exprSetParent((ExpressionNode)locator);
        }
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener, FunctionTable aTable) throws TransformerException {
        this.m_funcTable = aTable;
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator, this.m_funcTable);
        if (type == 0) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(type)}));
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
        if (locator != null && locator instanceof ExpressionNode) {
            expr.exprSetParent((ExpressionNode)locator);
        }
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type) throws TransformerException {
        this(exprString, locator, prefixResolver, type, null);
    }

    public XPath(Expression expr) {
        this.setExpression(expr);
        this.initFunctionTable();
    }

    public XObject execute(XPathContext xctxt, Node contextNode, PrefixResolver namespaceContext) throws TransformerException {
        return this.execute(xctxt, xctxt.getDTMHandleFromNode(contextNode), namespaceContext);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject execute(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        xctxt.pushNamespaceContext(namespaceContext);
        xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
        xobj = null;
        try {
            try {
                xobj = this.m_mainExp.execute(xctxt);
                ** GOTO lbl-1000
            }
            catch (TransformerException te) {
                te.setLocator(this.getLocator());
                el = xctxt.getErrorListener();
                if (el == null) throw te;
                el.error(te);
                ** GOTO lbl-1000
            }
            catch (Exception e) {}
            while (true) {
                block8: {
                    if (e instanceof WrappedRuntimeException) break block8;
                    msg = e.getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = XSLMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                    }
                    te = new TransformerException(msg, this.getLocator(), e);
                    el = xctxt.getErrorListener();
                    if (el == null) throw te;
                    el.fatalError(te);
                    break;
                }
                e = ((WrappedRuntimeException)e).getException();
            }
        }
        catch (Throwable var10_12) {
            var9_13 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            throw var10_12;
        }
lbl-1000:
        // 3 sources

        {
            var9_14 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            return xobj;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean bool(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        xctxt.pushNamespaceContext(namespaceContext);
        xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
        try {
            try {
                var10_4 = this.m_mainExp.bool(xctxt);
                var8_5 = null;
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
                return var10_4;
            }
            catch (TransformerException te) {
                te.setLocator(this.getLocator());
                el = xctxt.getErrorListener();
                if (el == null) throw te;
                el.error(te);
                ** GOTO lbl-1000
            }
            catch (Exception e) {}
            while (true) {
                block8: {
                    if (e instanceof WrappedRuntimeException) break block8;
                    msg = e.getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = XSLMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                    }
                    te = new TransformerException(msg, this.getLocator(), e);
                    el = xctxt.getErrorListener();
                    if (el == null) throw te;
                    el.fatalError(te);
                    break;
                }
                e = ((WrappedRuntimeException)e).getException();
            }
        }
        catch (Throwable var9_15) {
            var8_6 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            throw var9_15;
        }
lbl-1000:
        // 2 sources

        {
            var8_7 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            return false;
        }
    }

    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.m_mainExp.execute(xctxt);
            double d = score.num();
            Object var4_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void warn(XPathContext xctxt, int sourceNode, String msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (ehandler != null) {
            ehandler.warning(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        }
    }

    public void assertion(boolean b, String msg) {
        if (!b) {
            String fMsg = XSLMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    public void error(XPathContext xctxt, int sourceNode, String msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (ehandler != null) {
            ehandler.fatalError(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        } else {
            SourceLocator slocator = xctxt.getSAXLocator();
            System.out.println(String.valueOf(fmsg) + "; file " + slocator.getSystemId() + "; line " + slocator.getLineNumber() + "; column " + slocator.getColumnNumber());
        }
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        this.m_mainExp.callVisitors(this, visitor);
    }
}

