info = {
    "name": "te",
    "date_order": "DMY",
    "january": [
        "జన",
        "జనవరి"
    ],
    "february": [
        "ఫిబ్ర",
        "ఫిబ్రవరి"
    ],
    "march": [
        "మార్చి"
    ],
    "april": [
        "ఏప్రి",
        "ఏప్రిల్"
    ],
    "may": [
        "మే"
    ],
    "june": [
        "జూన్"
    ],
    "july": [
        "జులై"
    ],
    "august": [
        "ఆగ",
        "ఆగస్టు"
    ],
    "september": [
        "సెప్టెం",
        "సెప్టెంబర్"
    ],
    "october": [
        "అక్టో",
        "అక్టోబర్"
    ],
    "november": [
        "నవం",
        "నవంబర్"
    ],
    "december": [
        "డిసెం",
        "డిసెంబర్"
    ],
    "monday": [
        "సోమ",
        "సోమవారం"
    ],
    "tuesday": [
        "మంగళ",
        "మంగళవారం"
    ],
    "wednesday": [
        "బుధ",
        "బుధవారం"
    ],
    "thursday": [
        "గురు",
        "గురువారం"
    ],
    "friday": [
        "శుక్ర",
        "శుక్రవారం"
    ],
    "saturday": [
        "శని",
        "శనివారం"
    ],
    "sunday": [
        "ఆది",
        "ఆదివారం"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "సం",
        "సంవత్సరం"
    ],
    "month": [
        "నె",
        "నెల"
    ],
    "week": [
        "వా",
        "వారము"
    ],
    "day": [
        "ది",
        "దినం"
    ],
    "hour": [
        "గం",
        "గంట"
    ],
    "minute": [
        "ని",
        "నిమి",
        "నిమిషము"
    ],
    "second": [
        "సెక",
        "సెకను"
    ],
    "relative-type": {
        "0 day ago": [
            "ఈ రోజు"
        ],
        "0 hour ago": [
            "ఈ గంట"
        ],
        "0 minute ago": [
            "ఈ నిమిషం"
        ],
        "0 month ago": [
            "ఈ నెల"
        ],
        "0 second ago": [
            "ప్రస్తుతం"
        ],
        "0 week ago": [
            "ఈ వారం"
        ],
        "0 year ago": [
            "ఈ సంవత్సరం"
        ],
        "1 day ago": [
            "నిన్న"
        ],
        "1 month ago": [
            "గత నెల"
        ],
        "1 week ago": [
            "గత వారం"
        ],
        "1 year ago": [
            "గత సంవత్సరం"
        ],
        "in 1 day": [
            "రేపు"
        ],
        "in 1 month": [
            "తదుపరి నెల"
        ],
        "in 1 week": [
            "తదుపరి వారం"
        ],
        "in 1 year": [
            "తదుపరి సంవత్సరం"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) రోజు క్రితం",
            "(\\d+[.,]?\\d*) రోజుల క్రితం"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) గం క్రితం",
            "(\\d+[.,]?\\d*) గంట క్రితం",
            "(\\d+[.,]?\\d*) గంటల క్రితం"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) నిమి క్రితం",
            "(\\d+[.,]?\\d*) నిమిషం క్రితం",
            "(\\d+[.,]?\\d*) నిమిషాల క్రితం"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) నెల క్రితం",
            "(\\d+[.,]?\\d*) నెలల క్రితం"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) సెక క్రితం",
            "(\\d+[.,]?\\d*) సెకను క్రితం",
            "(\\d+[.,]?\\d*) సెకన్ల క్రితం"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) వారం క్రితం",
            "(\\d+[.,]?\\d*) వారాల క్రితం"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) సం క్రితం",
            "(\\d+[.,]?\\d*) సంవత్సరం క్రితం",
            "(\\d+[.,]?\\d*) సంవత్సరాల క్రితం"
        ],
        "in \\1 day": [
            "(\\d+[.,]?\\d*) రోజులో",
            "(\\d+[.,]?\\d*) రోజుల్లో"
        ],
        "in \\1 hour": [
            "(\\d+[.,]?\\d*) గంటలో",
            "(\\d+[.,]?\\d*) గంటల్లో",
            "(\\d+[.,]?\\d*) గంలో"
        ],
        "in \\1 minute": [
            "(\\d+[.,]?\\d*) నిమిలో",
            "(\\d+[.,]?\\d*) నిమిషంలో",
            "(\\d+[.,]?\\d*) నిమిషాల్లో"
        ],
        "in \\1 month": [
            "(\\d+[.,]?\\d*) నెలలో",
            "(\\d+[.,]?\\d*) నెలల్లో"
        ],
        "in \\1 second": [
            "(\\d+[.,]?\\d*) సెక లో",
            "(\\d+[.,]?\\d*) సెకనులో",
            "(\\d+[.,]?\\d*) సెకన్లలో"
        ],
        "in \\1 week": [
            "(\\d+[.,]?\\d*) వారంలో",
            "(\\d+[.,]?\\d*) వారాల్లో"
        ],
        "in \\1 year": [
            "(\\d+[.,]?\\d*) సంలో",
            "(\\d+[.,]?\\d*) సంవత్సరంలో",
            "(\\d+[.,]?\\d*) సంవత్సరాల్లో"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
