#include "backendcheck"

string BackendCheck::description() const {
    ostringstream o;

    o << "Back end check type: ";
    switch (check_type) {
    case c_connect:
	o << "TCP connect to ";
	if (srv == "")
	    o << "backend IP, ";
	else
	    o << "alternative IP '" << srv << "', ";
	if (prt == 0)
	    o << "backend port";
	else
	    o << "alternative port '" << prt << "'";
	break;
    case c_get:
	o << "HTTP GET to ";
	if (srv == "")
	    o << "backend IP, ";
	else
	    o << "alternative IP '" << srv << "', ";
	if (prt == 0)
	    o << "backend port";
	else
	    o << "alternative port '" << prt << "'";
	break;
    case c_external:
	o << "External program " << extprog;
	break;
    default:
	throw Error("Internal jam in BackendCheck::description");
    }

    return (o.str());
}
	
