/*                                                                            *
 *   This file is part of the ESO IRPLIB package                              *
 *   Copyright (C) 2004,2005 European Southern Observatory                    *
 *                                                                            *
 *   This library is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 *   This program is distributed in the hope that it will be useful,          *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *   GNU General Public License for more details.                             *
 *                                                                            *
 *   You should have received a copy of the GNU General Public License        *
 *   along with this program; if not, write to the Free Software              *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA     *
 *                                                                            */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include <irplib_plugin.h>
#include <string.h>
#include <float.h>

/*-----------------------------------------------------------------------------
                                   Function prototypes
 -----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 * @defgroup irplib_plugin_test Testing of the IRPLIB utilities
 */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/**
   @brief   Unit tests of plugin module
**/
/*----------------------------------------------------------------------------*/

int main(void)
{



    cpl_parameterlist * parlist;

    /* Initialize CPL for unit testing */
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);

    parlist = cpl_parameterlist_new();


    (void)irplib_parameterlist_get_double(parlist, "INST", "RECIPE", NULL);
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_double(parlist, "INST", NULL, "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_double(parlist, NULL, "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_double(NULL, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_double(parlist, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_DATA_NOT_FOUND);


    (void)irplib_parameterlist_get_int(parlist, "INST", "RECIPE", NULL);
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_int(parlist, "INST", NULL, "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_int(parlist, NULL, "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_int(NULL, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_int(parlist, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_DATA_NOT_FOUND);


    (void)irplib_parameterlist_get_bool(parlist, "INST", "RECIPE", NULL);
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_bool(parlist, "INST", NULL, "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_bool(parlist, NULL, "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_bool(NULL, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_bool(parlist, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_DATA_NOT_FOUND);


    (void)irplib_parameterlist_get_string(parlist, "INST", "RECIPE", NULL);
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_string(parlist, "INST", NULL, "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_string(parlist, NULL, "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_string(NULL, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_NULL_INPUT);

    (void)irplib_parameterlist_get_string(parlist, "INST", "RECIPE", "PAR");
    cpl_test_error(CPL_ERROR_DATA_NOT_FOUND);


    cpl_parameterlist_delete(parlist);

    return cpl_test_end(0);
}
