# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'chromium_code': 1,
    # Override to dynamically link the cras (ChromeOS audio) library.
    'use_cras%': 0,
    # Option e.g. for Linux distributions to link pulseaudio directly
    # (DT_NEEDED) instead of using dlopen. This helps with automated
    # detection of ABI mismatches and prevents silent errors.
    'linux_link_pulseaudio%': 0,
    'conditions': [
      ['OS=="android"', {
        # Android doesn't use ffmpeg.
        'media_use_ffmpeg%': 0,
        # Android doesn't use libvpx.
        'media_use_libvpx%': 0,
      }, {  # 'OS!="android"'
        'media_use_ffmpeg%': 1,
        'media_use_libvpx%': 1,
      }],
      # Enable ALSA and Pulse for runtime selection.
      ['(OS=="linux" or OS=="freebsd" or OS=="solaris") and embedded!=1 and use_cras==0', {
        'use_alsa%': 1,
        'use_pulseaudio%': 1,
      }, {
        'use_alsa%': 0,
        'use_pulseaudio%': 0,
      }],
    ],
  },
  'includes': [
    'media_cdm.gypi',
  ],
  'targets': [
    {
      'target_name': 'media',
      'type': '<(component)',
      'dependencies': [
        '../base/base.gyp:base',
        '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
        '../crypto/crypto.gyp:crypto',
        '../gpu/gpu.gyp:command_buffer_common',
        '../skia/skia.gyp:skia',
        '../third_party/opus/opus.gyp:opus',
        '../ui/events/events.gyp:events_base',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../url/url.gyp:url_lib',
        'shared_memory_support',
      ],
      'defines': [
        'MEDIA_IMPLEMENTATION',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        'audio/agc_audio_stream.h',
        'audio/alsa/alsa_input.cc',
        'audio/alsa/alsa_input.h',
        'audio/alsa/alsa_output.cc',
        'audio/alsa/alsa_output.h',
        'audio/alsa/alsa_util.cc',
        'audio/alsa/alsa_util.h',
        'audio/alsa/alsa_wrapper.cc',
        'audio/alsa/alsa_wrapper.h',
        'audio/alsa/audio_manager_alsa.cc',
        'audio/alsa/audio_manager_alsa.h',
        'audio/android/audio_manager_android.cc',
        'audio/android/audio_manager_android.h',
        'audio/android/audio_record_input.cc',
        'audio/android/audio_record_input.h',
        'audio/android/opensles_input.cc',
        'audio/android/opensles_input.h',
        'audio/android/opensles_output.cc',
        'audio/android/opensles_output.h',
        'audio/android/opensles_wrapper.cc',
        'audio/audio_buffers_state.cc',
        'audio/audio_buffers_state.h',
        'audio/audio_device_name.cc',
        'audio/audio_device_name.h',
        'audio/audio_device_thread.cc',
        'audio/audio_device_thread.h',
        'audio/audio_input_controller.cc',
        'audio/audio_input_controller.h',
        'audio/audio_input_device.cc',
        'audio/audio_input_device.h',
        'audio/audio_input_ipc.cc',
        'audio/audio_input_ipc.h',
        'audio/audio_io.h',
        'audio/audio_manager.cc',
        'audio/audio_manager.h',
        'audio/audio_manager_base.cc',
        'audio/audio_manager_base.h',
        'audio/audio_output_controller.cc',
        'audio/audio_output_controller.h',
        'audio/audio_output_device.cc',
        'audio/audio_output_device.h',
        'audio/audio_output_dispatcher.cc',
        'audio/audio_output_dispatcher.h',
        'audio/audio_output_dispatcher_impl.cc',
        'audio/audio_output_dispatcher_impl.h',
        'audio/audio_output_ipc.cc',
        'audio/audio_output_ipc.h',
        'audio/audio_output_proxy.cc',
        'audio/audio_output_proxy.h',
        'audio/audio_output_resampler.cc',
        'audio/audio_output_resampler.h',
        'audio/audio_power_monitor.cc',
        'audio/audio_power_monitor.h',
        'audio/audio_source_diverter.h',
        'audio/clockless_audio_sink.cc',
        'audio/clockless_audio_sink.h',
        'audio/cras/audio_manager_cras.cc',
        'audio/cras/audio_manager_cras.h',
        'audio/cras/cras_input.cc',
        'audio/cras/cras_input.h',
        'audio/cras/cras_unified.cc',
        'audio/cras/cras_unified.h',
        'audio/fake_audio_consumer.cc',
        'audio/fake_audio_consumer.h',
        'audio/fake_audio_input_stream.cc',
        'audio/fake_audio_input_stream.h',
        'audio/fake_audio_log_factory.h',
        'audio/fake_audio_log_factory.cc',
        'audio/fake_audio_manager.cc',
        'audio/fake_audio_manager.h',
        'audio/fake_audio_output_stream.cc',
        'audio/fake_audio_output_stream.h',
        'audio/linux/audio_manager_linux.cc',
        'audio/mac/audio_auhal_mac.cc',
        'audio/mac/audio_auhal_mac.h',
        'audio/mac/audio_device_listener_mac.cc',
        'audio/mac/audio_device_listener_mac.h',
        'audio/mac/audio_input_mac.cc',
        'audio/mac/audio_input_mac.h',
        'audio/mac/audio_low_latency_input_mac.cc',
        'audio/mac/audio_low_latency_input_mac.h',
        'audio/mac/audio_low_latency_output_mac.cc',
        'audio/mac/audio_low_latency_output_mac.h',
        'audio/mac/audio_manager_mac.cc',
        'audio/mac/audio_manager_mac.h',
        'audio/null_audio_sink.cc',
        'audio/null_audio_sink.h',
        'audio/openbsd/audio_manager_openbsd.cc',
        'audio/openbsd/audio_manager_openbsd.h',
        'audio/pulse/audio_manager_pulse.cc',
        'audio/pulse/audio_manager_pulse.h',
        'audio/pulse/pulse_input.cc',
        'audio/pulse/pulse_input.h',
        'audio/pulse/pulse_output.cc',
        'audio/pulse/pulse_output.h',
        'audio/pulse/pulse_util.cc',
        'audio/pulse/pulse_util.h',
        'audio/sample_rates.cc',
        'audio/sample_rates.h',
        'audio/scoped_task_runner_observer.cc',
        'audio/scoped_task_runner_observer.h',
        'audio/simple_sources.cc',
        'audio/simple_sources.h',
        'audio/sounds/audio_stream_handler.cc',
        'audio/sounds/audio_stream_handler.h',
        'audio/sounds/sounds_manager.cc',
        'audio/sounds/sounds_manager.h',
        'audio/sounds/wav_audio_handler.cc',
        'audio/sounds/wav_audio_handler.h',
        'audio/virtual_audio_input_stream.cc',
        'audio/virtual_audio_input_stream.h',
        'audio/virtual_audio_output_stream.cc',
        'audio/virtual_audio_output_stream.h',
        'audio/win/audio_device_listener_win.cc',
        'audio/win/audio_device_listener_win.h',
        'audio/win/audio_low_latency_input_win.cc',
        'audio/win/audio_low_latency_input_win.h',
        'audio/win/audio_low_latency_output_win.cc',
        'audio/win/audio_low_latency_output_win.h',
        'audio/win/audio_manager_win.cc',
        'audio/win/audio_manager_win.h',
        'audio/win/avrt_wrapper_win.cc',
        'audio/win/avrt_wrapper_win.h',
        'audio/win/core_audio_util_win.cc',
        'audio/win/core_audio_util_win.h',
        'audio/win/device_enumeration_win.cc',
        'audio/win/device_enumeration_win.h',
        'audio/win/wavein_input_win.cc',
        'audio/win/wavein_input_win.h',
        'audio/win/waveout_output_win.cc',
        'audio/win/waveout_output_win.h',
        'base/android/demuxer_android.h',
        'base/android/demuxer_stream_player_params.cc',
        'base/android/demuxer_stream_player_params.h',
        'base/android/media_player_manager.h',
        'base/android/media_resource_getter.cc',
        'base/android/media_resource_getter.h',
        'base/audio_buffer.cc',
        'base/audio_buffer.h',
        'base/audio_buffer_queue.cc',
        'base/audio_buffer_queue.h',
        'base/audio_capturer_source.h',
        'base/audio_converter.cc',
        'base/audio_converter.h',
        'base/audio_decoder.cc',
        'base/audio_decoder.h',
        'base/audio_decoder_config.cc',
        'base/audio_decoder_config.h',
        'base/audio_fifo.cc',
        'base/audio_fifo.h',
        'base/audio_hardware_config.cc',
        'base/audio_hardware_config.h',
        'base/audio_hash.cc',
        'base/audio_hash.h',
        'base/audio_pull_fifo.cc',
        'base/audio_pull_fifo.h',
        'base/audio_renderer.cc',
        'base/audio_renderer.h',
        'base/audio_renderer_mixer.cc',
        'base/audio_renderer_mixer.h',
        'base/audio_renderer_mixer_input.cc',
        'base/audio_renderer_mixer_input.h',
        'base/audio_renderer_sink.h',
        'base/audio_splicer.cc',
        'base/audio_splicer.h',
        'base/audio_timestamp_helper.cc',
        'base/audio_timestamp_helper.h',
        'base/audio_video_metadata_extractor.cc',
        'base/audio_video_metadata_extractor.h',
        'base/bind_to_current_loop.h',
        'base/bit_reader.cc',
        'base/bit_reader.h',
        'base/bit_reader_core.cc',
        'base/bit_reader_core.h',
        'base/bitstream_buffer.h',
        'base/buffers.h',
        'base/byte_queue.cc',
        'base/byte_queue.h',
        'base/channel_mixer.cc',
        'base/channel_mixer.h',
        'base/clock.cc',
        'base/clock.h',
        'base/container_names.cc',
        'base/container_names.h',
        'base/data_buffer.cc',
        'base/data_buffer.h',
        'base/data_source.cc',
        'base/data_source.h',
        'base/decoder_buffer.cc',
        'base/decoder_buffer.h',
        'base/decoder_buffer_queue.cc',
        'base/decoder_buffer_queue.h',
        'base/decrypt_config.cc',
        'base/decrypt_config.h',
        'base/decryptor.cc',
        'base/decryptor.h',
        'base/demuxer.cc',
        'base/demuxer.h',
        'base/demuxer_stream.cc',
        'base/demuxer_stream.h',
        'base/djb2.cc',
        'base/djb2.h',
        'base/filter_collection.cc',
        'base/filter_collection.h',
        'base/keyboard_event_counter.cc',
        'base/keyboard_event_counter.h',
        'base/media.cc',
        'base/media.h',
        'base/media_file_checker.cc',
        'base/media_file_checker.h',
        'base/media_keys.cc',
        'base/media_keys.h',
        'base/media_log.cc',
        'base/media_log.h',
        'base/media_log_event.h',
        'base/media_posix.cc',
        'base/media_switches.cc',
        'base/media_switches.h',
        'base/media_win.cc',
        'base/multi_channel_resampler.cc',
        'base/multi_channel_resampler.h',
        'base/pipeline.cc',
        'base/pipeline.h',
        'base/pipeline_status.h',
        'base/ranges.cc',
        'base/ranges.h',
        'base/sample_format.cc',
        'base/sample_format.h',
        'base/scoped_histogram_timer.h',
        'base/seekable_buffer.cc',
        'base/seekable_buffer.h',
        'base/serial_runner.cc',
        'base/serial_runner.h',
        'base/simd/convert_rgb_to_yuv.h',
        'base/simd/convert_rgb_to_yuv_c.cc',
        'base/simd/convert_yuv_to_rgb.h',
        'base/simd/convert_yuv_to_rgb_c.cc',
        'base/simd/filter_yuv.h',
        'base/simd/filter_yuv_c.cc',
        'base/simd/yuv_to_rgb_table.cc',
        'base/simd/yuv_to_rgb_table.h',
        'base/sinc_resampler.cc',
        'base/sinc_resampler.h',
        'base/stream_parser.cc',
        'base/stream_parser.h',
        'base/stream_parser_buffer.cc',
        'base/stream_parser_buffer.h',
        'base/text_cue.cc',
        'base/text_cue.h',
        'base/text_ranges.cc',
        'base/text_ranges.h',
        'base/text_renderer.cc',
        'base/text_renderer.h',
        'base/text_track.h',
        'base/text_track_config.cc',
        'base/text_track_config.h',
        'base/user_input_monitor.cc',
        'base/user_input_monitor.h',
        'base/user_input_monitor_linux.cc',
        'base/user_input_monitor_mac.cc',
        'base/user_input_monitor_win.cc',
        'base/video_decoder.cc',
        'base/video_decoder.h',
        'base/video_decoder_config.cc',
        'base/video_decoder_config.h',
        'base/video_frame.cc',
        'base/video_frame.h',
        'base/video_frame_pool.cc',
        'base/video_frame_pool.h',
        'base/video_renderer.cc',
        'base/video_renderer.h',
        'base/video_util.cc',
        'base/video_util.h',
        'base/yuv_convert.cc',
        'base/yuv_convert.h',
        'cdm/aes_decryptor.cc',
        'cdm/aes_decryptor.h',
        'cdm/json_web_key.cc',
        'cdm/json_web_key.h',
        'cdm/key_system_names.cc',
        'cdm/key_system_names.h',
        'ffmpeg/ffmpeg_common.cc',
        'ffmpeg/ffmpeg_common.h',
        'filters/audio_file_reader.cc',
        'filters/audio_file_reader.h',
        'filters/audio_renderer_algorithm.cc',
        'filters/audio_renderer_algorithm.h',
        'filters/audio_renderer_impl.cc',
        'filters/audio_renderer_impl.h',
        'filters/blocking_url_protocol.cc',
        'filters/blocking_url_protocol.h',
        'filters/chunk_demuxer.cc',
        'filters/chunk_demuxer.h',
        'filters/decoder_selector.cc',
        'filters/decoder_selector.h',
        'filters/decoder_stream_traits.h',
        'filters/decrypting_audio_decoder.cc',
        'filters/decrypting_audio_decoder.h',
        'filters/decrypting_demuxer_stream.cc',
        'filters/decrypting_demuxer_stream.h',
        'filters/decrypting_video_decoder.cc',
        'filters/decrypting_video_decoder.h',
        'filters/ffmpeg_audio_decoder.cc',
        'filters/ffmpeg_audio_decoder.h',
        'filters/ffmpeg_demuxer.cc',
        'filters/ffmpeg_demuxer.h',
        'filters/ffmpeg_glue.cc',
        'filters/ffmpeg_glue.h',
        'filters/ffmpeg_h264_to_annex_b_bitstream_converter.cc',
        'filters/ffmpeg_h264_to_annex_b_bitstream_converter.h',
        'filters/ffmpeg_video_decoder.cc',
        'filters/ffmpeg_video_decoder.h',
        'filters/file_data_source.cc',
        'filters/file_data_source.h',
        'filters/gpu_video_accelerator_factories.cc',
        'filters/gpu_video_accelerator_factories.h',
        'filters/gpu_video_decoder.cc',
        'filters/gpu_video_decoder.h',
        'filters/h264_bit_reader.cc',
        'filters/h264_bit_reader.h',
        'filters/h264_parser.cc',
        'filters/h264_parser.h',
        'filters/h264_to_annex_b_bitstream_converter.cc',
        'filters/h264_to_annex_b_bitstream_converter.h',
        'filters/in_memory_url_protocol.cc',
        'filters/in_memory_url_protocol.h',
        'filters/opus_audio_decoder.cc',
        'filters/opus_audio_decoder.h',
        'filters/skcanvas_video_renderer.cc',
        'filters/skcanvas_video_renderer.h',
        'filters/source_buffer_stream.cc',
        'filters/source_buffer_stream.h',
        'filters/stream_parser_factory.cc',
        'filters/stream_parser_factory.h',
        'filters/video_frame_painter.cc',
        'filters/video_frame_painter.h',
        'filters/video_frame_stream.cc',
        'filters/video_frame_stream.h',
        'filters/video_renderer_impl.cc',
        'filters/video_renderer_impl.h',
        'filters/vpx_video_decoder.cc',
        'filters/vpx_video_decoder.h',
        'filters/webvtt_util.h',
        'filters/wsola_internals.cc',
        'filters/wsola_internals.h',
        'midi/midi_manager.cc',
        'midi/midi_manager.h',
        'midi/midi_manager_alsa.cc',
        'midi/midi_manager_alsa.h',
        'midi/midi_manager_android.cc',
        'midi/midi_manager_mac.cc',
        'midi/midi_manager_mac.h',
        'midi/midi_manager_usb.cc',
        'midi/midi_manager_usb.h',
        'midi/midi_manager_win.cc',
        'midi/midi_manager_win.h',
        'midi/midi_message_queue.cc',
        'midi/midi_message_queue.h',
        'midi/midi_message_util.cc',
        'midi/midi_message_util.h',
        'midi/midi_port_info.cc',
        'midi/midi_port_info.h',
        'midi/usb_midi_descriptor_parser.cc',
        'midi/usb_midi_descriptor_parser.h',
        'midi/usb_midi_device.h',
        'midi/usb_midi_device_android.cc',
        'midi/usb_midi_device_android.h',
        'midi/usb_midi_device_factory_android.cc',
        'midi/usb_midi_device_factory_android.h',
        'midi/usb_midi_input_stream.cc',
        'midi/usb_midi_input_stream.h',
        'midi/usb_midi_jack.h',
        'midi/usb_midi_output_stream.cc',
        'midi/usb_midi_output_stream.h',
        'video/capture/android/video_capture_device_android.cc',
        'video/capture/android/video_capture_device_android.h',
        'video/capture/fake_video_capture_device.cc',
        'video/capture/fake_video_capture_device.h',
        'video/capture/file_video_capture_device.cc',
        'video/capture/file_video_capture_device.h',
        'video/capture/linux/video_capture_device_linux.cc',
        'video/capture/linux/video_capture_device_linux.h',
        'video/capture/mac/avfoundation_glue.h',
        'video/capture/mac/avfoundation_glue.mm',
        'video/capture/mac/coremedia_glue.h',
        'video/capture/mac/coremedia_glue.mm',
        'video/capture/mac/platform_video_capturing_mac.h',
        'video/capture/mac/video_capture_device_avfoundation_mac.h',
        'video/capture/mac/video_capture_device_avfoundation_mac.mm',
        'video/capture/mac/video_capture_device_mac.h',
        'video/capture/mac/video_capture_device_mac.mm',
        'video/capture/mac/video_capture_device_qtkit_mac.h',
        'video/capture/mac/video_capture_device_qtkit_mac.mm',
        'video/capture/video_capture.h',
        'video/capture/video_capture_device.cc',
        'video/capture/video_capture_device.h',
        'video/capture/video_capture_proxy.cc',
        'video/capture/video_capture_proxy.h',
        'video/capture/video_capture_types.cc',
        'video/capture/video_capture_types.h',
        'video/capture/win/capability_list_win.cc',
        'video/capture/win/capability_list_win.h',
        'video/capture/win/filter_base_win.cc',
        'video/capture/win/filter_base_win.h',
        'video/capture/win/pin_base_win.cc',
        'video/capture/win/pin_base_win.h',
        'video/capture/win/sink_filter_observer_win.h',
        'video/capture/win/sink_filter_win.cc',
        'video/capture/win/sink_filter_win.h',
        'video/capture/win/sink_input_pin_win.cc',
        'video/capture/win/sink_input_pin_win.h',
        'video/capture/win/video_capture_device_mf_win.cc',
        'video/capture/win/video_capture_device_mf_win.h',
        'video/capture/win/video_capture_device_win.cc',
        'video/capture/win/video_capture_device_win.h',
        'video/picture.cc',
        'video/picture.h',
        'video/video_decode_accelerator.cc',
        'video/video_decode_accelerator.h',
        'video/video_encode_accelerator.cc',
        'video/video_encode_accelerator.h',
        'formats/common/offset_byte_queue.cc',
        'formats/common/offset_byte_queue.h',
        'formats/webm/webm_audio_client.cc',
        'formats/webm/webm_audio_client.h',
        'formats/webm/webm_cluster_parser.cc',
        'formats/webm/webm_cluster_parser.h',
        'formats/webm/webm_constants.cc',
        'formats/webm/webm_constants.h',
        'formats/webm/webm_content_encodings.cc',
        'formats/webm/webm_content_encodings.h',
        'formats/webm/webm_content_encodings_client.cc',
        'formats/webm/webm_content_encodings_client.h',
        'formats/webm/webm_crypto_helpers.cc',
        'formats/webm/webm_crypto_helpers.h',
        'formats/webm/webm_info_parser.cc',
        'formats/webm/webm_info_parser.h',
        'formats/webm/webm_parser.cc',
        'formats/webm/webm_parser.h',
        'formats/webm/webm_stream_parser.cc',
        'formats/webm/webm_stream_parser.h',
        'formats/webm/webm_tracks_parser.cc',
        'formats/webm/webm_tracks_parser.h',
        'formats/webm/webm_video_client.cc',
        'formats/webm/webm_video_client.h',
        'formats/webm/webm_webvtt_parser.cc',
        'formats/webm/webm_webvtt_parser.h'
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '..',
        ],
      },
      'conditions': [
        ['arm_neon==1', {
          'defines': [
            'USE_NEON'
          ],
        }],
        ['media_use_ffmpeg==1', {
          'dependencies': [
            '../third_party/ffmpeg/ffmpeg.gyp:ffmpeg',
          ],
        }, {  # media_use_ffmpeg==0
          # Exclude the sources that depend on ffmpeg.
          'sources!': [
            'base/audio_video_metadata_extractor.cc',
            'base/audio_video_metadata_extractor.h',
            'base/container_names.cc',
            'base/container_names.h',
            'base/media_file_checker.cc',
            'base/media_file_checker.h',
            'base/media_posix.cc',
            'ffmpeg/ffmpeg_common.cc',
            'ffmpeg/ffmpeg_common.h',
            'filters/audio_file_reader.cc',
            'filters/audio_file_reader.h',
            'filters/blocking_url_protocol.cc',
            'filters/blocking_url_protocol.h',
            'filters/ffmpeg_audio_decoder.cc',
            'filters/ffmpeg_audio_decoder.h',
            'filters/ffmpeg_demuxer.cc',
            'filters/ffmpeg_demuxer.h',
            'filters/ffmpeg_glue.cc',
            'filters/ffmpeg_glue.h',
            'filters/ffmpeg_h264_to_annex_b_bitstream_converter.cc',
            'filters/ffmpeg_h264_to_annex_b_bitstream_converter.h',
            'filters/ffmpeg_video_decoder.cc',
            'filters/ffmpeg_video_decoder.h',
          ],
        }],
        ['media_use_libvpx==1', {
          'dependencies': [
            '<(DEPTH)/third_party/libvpx/libvpx.gyp:libvpx',
          ],
        }, {  # media_use_libvpx==0
          'direct_dependent_settings': {
            'defines': [
              'MEDIA_DISABLE_LIBVPX',
            ],
          },
          # Exclude the sources that depend on libvpx.
          'sources!': [
            'filters/vpx_video_decoder.cc',
            'filters/vpx_video_decoder.h',
          ],
        }],
        ['OS=="android"', {
          'dependencies': [
            'media_android_jni_headers',
            'player_android',
            'video_capture_android_jni_headers',
          ],
          'sources': [
            'base/media.cc',
            'base/media.h',
            'base/media_stub.cc',
          ],
          'sources!': [
            'filters/opus_audio_decoder.cc',
            'filters/opus_audio_decoder.h',
          ],
          'conditions': [
            ['android_webview_build==0', {
              'dependencies': [
                'media_java',
              ],
            }],
          ],
          'defines': [
            'DISABLE_USER_INPUT_MONITOR',
          ],
        }],
        # A simple WebM encoder for animated avatars on ChromeOS.
        ['chromeos==1', {
          'dependencies': [
            '../third_party/libvpx/libvpx.gyp:libvpx',
            '../third_party/libyuv/libyuv.gyp:libyuv',
          ],
          'sources': [
            'formats/webm/chromeos/ebml_writer.cc',
            'formats/webm/chromeos/ebml_writer.h',
            'formats/webm/chromeos/webm_encoder.cc',
            'formats/webm/chromeos/webm_encoder.h',
          ],
        }],
        ['use_alsa==1', {
          'link_settings': {
            'libraries': [
              '-lasound',
            ],
          },
          'defines': [
            'USE_ALSA',
          ],
        }, { # use_alsa==0
          'sources/': [
            ['exclude', '(^|/)alsa/'],
            ['exclude', '_alsa\\.(h|cc)$'],
          ],
        }],
        ['OS!="openbsd"', {
          'sources!': [
            'audio/openbsd/audio_manager_openbsd.cc',
            'audio/openbsd/audio_manager_openbsd.h',
          ],
        }],
        ['OS=="linux"', {
          'variables': {
            'conditions': [
              ['sysroot!=""', {
                'pkg-config': '../build/linux/pkg-config-wrapper "<(sysroot)" "<(target_arch)"',
              }, {
                'pkg-config': 'pkg-config'
              }],
            ],
          },
          'conditions': [
            ['use_x11==1', {
              'dependencies': [
                '../build/linux/system.gyp:x11',
                '../build/linux/system.gyp:xdamage',
                '../build/linux/system.gyp:xext',
                '../build/linux/system.gyp:xfixes',
                '../build/linux/system.gyp:xtst',
              ],
            }, {  # else: use_x11==0
              'sources!': [
                'base/user_input_monitor_linux.cc',
              ],
              'defines': [
                'DISABLE_USER_INPUT_MONITOR',
              ],
            }],
            ['use_cras==1', {
              'cflags': [
                '<!@(<(pkg-config) --cflags libcras)',
              ],
              'link_settings': {
                'libraries': [
                  '<!@(<(pkg-config) --libs libcras)',
                ],
              },
              'defines': [
                'USE_CRAS',
              ],
            }, {  # else: use_cras==0
              'sources!': [
                'audio/cras/audio_manager_cras.cc',
                'audio/cras/audio_manager_cras.h',
                'audio/cras/cras_input.cc',
                'audio/cras/cras_input.h',
                'audio/cras/cras_unified.cc',
                'audio/cras/cras_unified.h',
              ],
            }],
          ],
        }],
        ['OS!="linux"', {
          'sources!': [
            'audio/cras/audio_manager_cras.cc',
            'audio/cras/audio_manager_cras.h',
            'audio/cras/cras_input.cc',
            'audio/cras/cras_input.h',
            'audio/cras/cras_unified.cc',
            'audio/cras/cras_unified.h',
          ],
        }],
        ['use_pulseaudio==1', {
          'cflags': [
            '<!@(pkg-config --cflags libpulse)',
          ],
          'defines': [
            'USE_PULSEAUDIO',
          ],
          'conditions': [
            ['linux_link_pulseaudio==0', {
              'defines': [
                'DLOPEN_PULSEAUDIO',
              ],
              'variables': {
                'generate_stubs_script': '../tools/generate_stubs/generate_stubs.py',
                'extra_header': 'audio/pulse/pulse_stub_header.fragment',
                'sig_files': ['audio/pulse/pulse.sigs'],
                'outfile_type': 'posix_stubs',
                'stubs_filename_root': 'pulse_stubs',
                'project_path': 'media/audio/pulse',
                'intermediate_dir': '<(INTERMEDIATE_DIR)',
                'output_root': '<(SHARED_INTERMEDIATE_DIR)/pulse',
              },
              'include_dirs': [
                '<(output_root)',
              ],
              'actions': [
                {
                  'action_name': 'generate_stubs',
                  'inputs': [
                    '<(generate_stubs_script)',
                    '<(extra_header)',
                    '<@(sig_files)',
                  ],
                  'outputs': [
                    '<(intermediate_dir)/<(stubs_filename_root).cc',
                    '<(output_root)/<(project_path)/<(stubs_filename_root).h',
                  ],
                  'action': ['python',
                             '<(generate_stubs_script)',
                             '-i', '<(intermediate_dir)',
                             '-o', '<(output_root)/<(project_path)',
                             '-t', '<(outfile_type)',
                             '-e', '<(extra_header)',
                             '-s', '<(stubs_filename_root)',
                             '-p', '<(project_path)',
                             '<@(_inputs)',
                  ],
                  'process_outputs_as_sources': 1,
                  'message': 'Generating Pulse stubs for dynamic loading',
                },
              ],
              'conditions': [
                # Linux/Solaris need libdl for dlopen() and friends.
                ['OS=="linux" or OS=="solaris"', {
                  'link_settings': {
                    'libraries': [
                      '-ldl',
                    ],
                  },
                }],
              ],
            }, {  # else: linux_link_pulseaudio==0
              'link_settings': {
                'ldflags': [
                  '<!@(pkg-config --libs-only-L --libs-only-other libpulse)',
                ],
                'libraries': [
                  '<!@(pkg-config --libs-only-l libpulse)',
                ],
              },
            }],
          ],
        }, {  # else: use_pulseaudio==0
          'sources!': [
            'audio/pulse/audio_manager_pulse.cc',
            'audio/pulse/audio_manager_pulse.h',
            'audio/pulse/pulse_input.cc',
            'audio/pulse/pulse_input.h',
            'audio/pulse/pulse_output.cc',
            'audio/pulse/pulse_output.h',
            'audio/pulse/pulse_util.cc',
            'audio/pulse/pulse_util.h',
          ],
        }],
        ['OS=="mac"', {
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/AudioToolbox.framework',
              '$(SDKROOT)/System/Library/Frameworks/AudioUnit.framework',
              '$(SDKROOT)/System/Library/Frameworks/CoreAudio.framework',
              '$(SDKROOT)/System/Library/Frameworks/CoreMIDI.framework',
              '$(SDKROOT)/System/Library/Frameworks/CoreVideo.framework',
              '$(SDKROOT)/System/Library/Frameworks/OpenGL.framework',
              '$(SDKROOT)/System/Library/Frameworks/QTKit.framework',
            ],
          },
        }],
        ['OS=="win"', {
          'link_settings':  {
            'libraries': [
              '-lmf.lib',
              '-lmfplat.lib',
              '-lmfreadwrite.lib',
              '-lmfuuid.lib',
            ],
          },
          # Specify delayload for media.dll.
          'msvs_settings': {
            'VCLinkerTool': {
              'DelayLoadDLLs': [
                'mf.dll',
                'mfplat.dll',
                'mfreadwrite.dll',
              ],
            },
          },
          # Specify delayload for components that link with media.lib.
          'all_dependent_settings': {
            'msvs_settings': {
              'VCLinkerTool': {
                'DelayLoadDLLs': [
                  'mf.dll',
                  'mfplat.dll',
                  'mfreadwrite.dll',
                ],
              },
            },
          },
          # TODO(wolenetz): Fix size_t to int truncations in win64. See
          # http://crbug.com/171009
          'conditions': [
            ['target_arch=="x64"', {
              'msvs_disabled_warnings': [ 4267, ],
            }],
          ],
        }],
        ['proprietary_codecs==1', {
          'sources': [
            'formats/mp2t/es_parser.h',
            'formats/mp2t/es_parser_adts.cc',
            'formats/mp2t/es_parser_adts.h',
            'formats/mp2t/es_parser_h264.cc',
            'formats/mp2t/es_parser_h264.h',
            'formats/mp2t/mp2t_common.h',
            'formats/mp2t/mp2t_stream_parser.cc',
            'formats/mp2t/mp2t_stream_parser.h',
            'formats/mp2t/ts_packet.cc',
            'formats/mp2t/ts_packet.h',
            'formats/mp2t/ts_section.h',
            'formats/mp2t/ts_section_pat.cc',
            'formats/mp2t/ts_section_pat.h',
            'formats/mp2t/ts_section_pes.cc',
            'formats/mp2t/ts_section_pes.h',
            'formats/mp2t/ts_section_pmt.cc',
            'formats/mp2t/ts_section_pmt.h',
            'formats/mp2t/ts_section_psi.cc',
            'formats/mp2t/ts_section_psi.h',
            'formats/mp4/aac.cc',
            'formats/mp4/aac.h',
            'formats/mp4/avc.cc',
            'formats/mp4/avc.h',
            'formats/mp4/box_definitions.cc',
            'formats/mp4/box_definitions.h',
            'formats/mp4/box_reader.cc',
            'formats/mp4/box_reader.h',
            'formats/mp4/cenc.cc',
            'formats/mp4/cenc.h',
            'formats/mp4/es_descriptor.cc',
            'formats/mp4/es_descriptor.h',
            'formats/mp4/mp4_stream_parser.cc',
            'formats/mp4/mp4_stream_parser.h',
            'formats/mp4/track_run_iterator.cc',
            'formats/mp4/track_run_iterator.h',
            'formats/mpeg/adts_constants.cc',
            'formats/mpeg/adts_constants.h',
            'formats/mpeg/adts_stream_parser.cc',
            'formats/mpeg/adts_stream_parser.h',
            'formats/mpeg/mp3_stream_parser.cc',
            'formats/mpeg/mp3_stream_parser.h',
            'formats/mpeg/mpeg_audio_stream_parser_base.cc',
            'formats/mpeg/mpeg_audio_stream_parser_base.h',
          ],
        }],
        ['toolkit_uses_gtk==1', {
          'dependencies': [
            '../build/linux/system.gyp:gtk',
          ],
        }],
        ['target_arch=="ia32" or target_arch=="x64"', {
          'dependencies': [
            'media_asm',
            'media_mmx',
            'media_sse',
            'media_sse2',
          ],
          'sources': [
            'base/simd/convert_yuv_to_rgb_x86.cc',
          ],
        }],
        ['OS!="linux" and OS!="win"', {
          'sources!': [
            'base/keyboard_event_counter.cc',
            'base/keyboard_event_counter.h',
          ],
        }],
      ],
    },
    {
      'target_name': 'media_unittests',
      'type': '<(gtest_target_type)',
      'dependencies': [
        'media',
        'media_test_support',
        'shared_memory_support',
        '../base/base.gyp:base',
        '../base/base.gyp:base_i18n',
        '../base/base.gyp:test_support_base',
        '../gpu/gpu.gyp:command_buffer_common',
        '../skia/skia.gyp:skia',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/ui.gyp:ui',
      ],
      'sources': [
        'audio/android/audio_android_unittest.cc',
        'audio/alsa/alsa_output_unittest.cc',
        'audio/audio_input_controller_unittest.cc',
        'audio/audio_input_unittest.cc',
        'audio/audio_input_volume_unittest.cc',
        'audio/audio_low_latency_input_output_unittest.cc',
        'audio/audio_manager_unittest.cc',
        'audio/audio_output_controller_unittest.cc',
        'audio/audio_output_device_unittest.cc',
        'audio/audio_output_proxy_unittest.cc',
        'audio/audio_parameters_unittest.cc',
        'audio/audio_power_monitor_unittest.cc',
        'audio/fake_audio_consumer_unittest.cc',
        'audio/mac/audio_auhal_mac_unittest.cc',
        'audio/mac/audio_device_listener_mac_unittest.cc',
        'audio/mac/audio_low_latency_input_mac_unittest.cc',
        'audio/simple_sources_unittest.cc',
        'audio/sounds/audio_stream_handler_unittest.cc',
        'audio/sounds/sounds_manager_unittest.cc',
        'audio/sounds/test_data.cc',
        'audio/sounds/test_data.h',
        'audio/sounds/wav_audio_handler_unittest.cc',
        'audio/virtual_audio_input_stream_unittest.cc',
        'audio/virtual_audio_output_stream_unittest.cc',
        'audio/win/audio_device_listener_win_unittest.cc',
        'audio/win/audio_low_latency_input_win_unittest.cc',
        'audio/win/audio_low_latency_output_win_unittest.cc',
        'audio/win/audio_output_win_unittest.cc',
        'audio/win/core_audio_util_win_unittest.cc',
        'base/android/media_codec_bridge_unittest.cc',
        'base/android/media_source_player_unittest.cc',
        'base/audio_buffer_unittest.cc',
        'base/audio_buffer_queue_unittest.cc',
        'base/audio_bus_unittest.cc',
        'base/audio_converter_unittest.cc',
        'base/audio_fifo_unittest.cc',
        'base/audio_hardware_config_unittest.cc',
        'base/audio_hash_unittest.cc',
        'base/audio_pull_fifo_unittest.cc',
        'base/audio_renderer_mixer_input_unittest.cc',
        'base/audio_renderer_mixer_unittest.cc',
        'base/audio_splicer_unittest.cc',
        'base/audio_timestamp_helper_unittest.cc',
        'base/audio_video_metadata_extractor_unittest.cc',
        'base/bind_to_current_loop_unittest.cc',
        'base/bit_reader_unittest.cc',
        'base/callback_holder.h',
        'base/callback_holder_unittest.cc',
        'base/channel_mixer_unittest.cc',
        'base/clock_unittest.cc',
        'base/container_names_unittest.cc',
        'base/data_buffer_unittest.cc',
        'base/decoder_buffer_queue_unittest.cc',
        'base/decoder_buffer_unittest.cc',
        'base/djb2_unittest.cc',
        'base/gmock_callback_support_unittest.cc',
        'base/media_file_checker_unittest.cc',
        'base/multi_channel_resampler_unittest.cc',
        'base/pipeline_unittest.cc',
        'base/ranges_unittest.cc',
        'base/run_all_unittests.cc',
        'base/scoped_histogram_timer_unittest.cc',
        'base/serial_runner_unittest.cc',
        'base/seekable_buffer_unittest.cc',
        'base/sinc_resampler_unittest.cc',
        'base/stream_parser_unittest.cc',
        'base/test_data_util.cc',
        'base/test_data_util.h',
        'base/text_ranges_unittest.cc',
        'base/text_renderer_unittest.cc',
        'base/user_input_monitor_unittest.cc',
        'base/vector_math_testing.h',
        'base/vector_math_unittest.cc',
        'base/video_frame_unittest.cc',
        'base/video_frame_pool_unittest.cc',
        'base/video_util_unittest.cc',
        'base/yuv_convert_unittest.cc',
        'cdm/aes_decryptor_unittest.cc',
        'cdm/json_web_key_unittest.cc',
        'ffmpeg/ffmpeg_common_unittest.cc',
        'filters/audio_decoder_selector_unittest.cc',
        'filters/audio_file_reader_unittest.cc',
        'filters/audio_renderer_algorithm_unittest.cc',
        'filters/audio_renderer_impl_unittest.cc',
        'filters/blocking_url_protocol_unittest.cc',
        'filters/chunk_demuxer_unittest.cc',
        'filters/decrypting_audio_decoder_unittest.cc',
        'filters/decrypting_demuxer_stream_unittest.cc',
        'filters/decrypting_video_decoder_unittest.cc',
        'filters/fake_demuxer_stream.cc',
        'filters/fake_demuxer_stream.h',
        'filters/fake_demuxer_stream_unittest.cc',
        'filters/fake_video_decoder.cc',
        'filters/fake_video_decoder.h',
        'filters/fake_video_decoder_unittest.cc',
        'filters/ffmpeg_audio_decoder_unittest.cc',
        'filters/ffmpeg_demuxer_unittest.cc',
        'filters/ffmpeg_glue_unittest.cc',
        'filters/ffmpeg_h264_to_annex_b_bitstream_converter_unittest.cc',
        'filters/ffmpeg_video_decoder_unittest.cc',
        'filters/file_data_source_unittest.cc',
        'filters/h264_bit_reader_unittest.cc',
        'filters/h264_parser_unittest.cc',
        'filters/h264_to_annex_b_bitstream_converter_unittest.cc',
        'filters/pipeline_integration_test.cc',
        'filters/pipeline_integration_test_base.cc',
        'filters/skcanvas_video_renderer_unittest.cc',
        'filters/source_buffer_stream_unittest.cc',
        'filters/video_decoder_selector_unittest.cc',
        'filters/video_frame_painter_unittest.cc',
        'filters/video_frame_stream_unittest.cc',
        'filters/video_renderer_impl_unittest.cc',
        'midi/midi_manager_usb_unittest.cc',
        'midi/midi_message_queue_unittest.cc',
        'midi/midi_message_util_unittest.cc',
        'midi/usb_midi_descriptor_parser_unittest.cc',
        'midi/usb_midi_input_stream_unittest.cc',
        'midi/usb_midi_output_stream_unittest.cc',
        'video/capture/video_capture_device_unittest.cc',
        'formats/common/offset_byte_queue_unittest.cc',
        'formats/webm/cluster_builder.cc',
        'formats/webm/cluster_builder.h',
        'formats/webm/tracks_builder.cc',
        'formats/webm/tracks_builder.h',
        'formats/webm/webm_cluster_parser_unittest.cc',
        'formats/webm/webm_content_encodings_client_unittest.cc',
        'formats/webm/webm_parser_unittest.cc',
        'formats/webm/webm_tracks_parser_unittest.cc',
        'formats/webm/webm_webvtt_parser_unittest.cc',
      ],
      'conditions': [
        ['arm_neon==1', {
          'defines': [
            'USE_NEON'
          ],
        }],
        ['media_use_ffmpeg==1', {
          'dependencies': [
            '../third_party/ffmpeg/ffmpeg.gyp:ffmpeg',
          ],
        }, {  # media_use_ffmpeg== 0
          'sources!': [
            'base/audio_video_metadata_extractor_unittest.cc',
            'base/media_file_checker_unittest.cc',
          ],
        }],
        ['use_alsa==1', {
          'defines': [
            'USE_ALSA',
          ],
        }],
        ['use_pulseaudio==1', {
          'defines': [
            'USE_PULSEAUDIO',
          ],
        }],
        ['os_posix==1 and OS!="mac"', {
          'conditions': [
            ['linux_use_tcmalloc==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
          ],
        }],
        ['OS=="android"', {
          'sources!': [
            'audio/audio_input_volume_unittest.cc',
            'base/container_names_unittest.cc',
            'ffmpeg/ffmpeg_common_unittest.cc',
            'filters/audio_file_reader_unittest.cc',
            'filters/blocking_url_protocol_unittest.cc',
            'filters/ffmpeg_audio_decoder_unittest.cc',
            'filters/ffmpeg_demuxer_unittest.cc',
            'filters/ffmpeg_glue_unittest.cc',
            'filters/ffmpeg_h264_to_annex_b_bitstream_converter_unittest.cc',
            'filters/ffmpeg_video_decoder_unittest.cc',
            'filters/pipeline_integration_test.cc',
            'filters/pipeline_integration_test_base.cc',
          ],
          'conditions': [
            ['gtest_target_type=="shared_library"', {
              'dependencies': [
                '../testing/android/native_test.gyp:native_test_native_code',
                'player_android',
              ],
            }],
          ],
        }],
        ['OS=="linux"', {
          'conditions': [
            ['use_cras==1', {
              'sources': [
                'audio/cras/cras_input_unittest.cc',
                'audio/cras/cras_unified_unittest.cc',
              ],
              'defines': [
                'USE_CRAS',
              ],
            }],
          ],
        }],
        ['use_alsa==0', {
          'sources!': [
            'audio/alsa/alsa_output_unittest.cc',
            'audio/audio_low_latency_input_output_unittest.cc',
          ],
        }],
        ['target_arch=="ia32" or target_arch=="x64"', {
          'sources': [
            'base/simd/convert_rgb_to_yuv_unittest.cc',
          ],
        }],
        ['proprietary_codecs==1', {
          'sources': [
            'formats/common/stream_parser_test_base.cc',
            'formats/common/stream_parser_test_base.h',
            'formats/mp2t/mp2t_stream_parser_unittest.cc',
            'formats/mp4/aac_unittest.cc',
            'formats/mp4/avc_unittest.cc',
            'formats/mp4/box_reader_unittest.cc',
            'formats/mp4/es_descriptor_unittest.cc',
            'formats/mp4/mp4_stream_parser_unittest.cc',
            'formats/mp4/track_run_iterator_unittest.cc',
            'formats/mpeg/adts_stream_parser_unittest.cc',
            'formats/mpeg/mp3_stream_parser_unittest.cc',
          ],
        }],
        # TODO(wolenetz): Fix size_t to int truncations in win64. See
        # http://crbug.com/171009
        ['OS=="win" and target_arch=="x64"', {
          'msvs_disabled_warnings': [ 4267, ],
        }],
      ],
    },
    {
      'target_name': 'media_perftests',
      'type': '<(gtest_target_type)',
      'dependencies': [
        'media',
        'media_test_support',
        'shared_memory_support',
        '../base/base.gyp:test_support_base',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../testing/perf/perf_test.gyp:perf_test',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/gl/gl.gyp:gl',
        '../ui/ui.gyp:ui',
      ],
      'sources': [
        'base/audio_bus_perftest.cc',
        'base/audio_converter_perftest.cc',
        'base/demuxer_perftest.cc',
        'base/run_all_perftests.cc',
        'base/sinc_resampler_perftest.cc',
        'base/test_data_util.cc',
        'base/vector_math_perftest.cc',
        'filters/pipeline_integration_perftest.cc',
        'filters/pipeline_integration_test_base.cc',
      ],
      'conditions': [
        ['arm_neon==1', {
          'defines': [
            'USE_NEON'
          ],
        }],
        ['OS=="android"', {
          'conditions': [
            ['gtest_target_type=="shared_library"', {
              'dependencies': [
                '../testing/android/native_test.gyp:native_test_native_code',
              ],
            }],
          ],
        }],
        ['media_use_ffmpeg==1', {
          'dependencies': [
            '../third_party/ffmpeg/ffmpeg.gyp:ffmpeg',
          ],
        }, {  # media_use_ffmpeg==0
          'sources!': [
            'base/demuxer_perftest.cc',
            'filters/pipeline_integration_perftest.cc',
            'filters/pipeline_integration_test_base.cc',
          ],
        }],
      ],
    },
    {
      'target_name': 'media_test_support',
      'type': 'static_library',
      'dependencies': [
        'media',
        'shared_memory_support',
        '../base/base.gyp:base',
        '../skia/skia.gyp:skia',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
      ],
      'sources': [
        'audio/mock_audio_manager.cc',
        'audio/mock_audio_manager.h',
        'audio/mock_audio_source_callback.cc',
        'audio/mock_audio_source_callback.h',
        'audio/test_audio_input_controller_factory.cc',
        'audio/test_audio_input_controller_factory.h',
        'base/fake_audio_render_callback.cc',
        'base/fake_audio_render_callback.h',
        'base/fake_audio_renderer_sink.cc',
        'base/fake_audio_renderer_sink.h',
        'base/fake_text_track_stream.cc',
        'base/fake_text_track_stream.h',
        'base/gmock_callback_support.h',
        'base/mock_audio_renderer_sink.cc',
        'base/mock_audio_renderer_sink.h',
        'base/mock_data_source_host.cc',
        'base/mock_data_source_host.h',
        'base/mock_demuxer_host.cc',
        'base/mock_demuxer_host.h',
        'base/mock_filters.cc',
        'base/mock_filters.h',
        'base/test_helpers.cc',
        'base/test_helpers.h',
        'filters/mock_gpu_video_accelerator_factories.cc',
        'filters/mock_gpu_video_accelerator_factories.h',
        'video/capture/mock_video_capture_event_handler.cc',
        'video/capture/mock_video_capture_event_handler.h',
        'video/mock_video_decode_accelerator.cc',
        'video/mock_video_decode_accelerator.h',
      ],
    },
    {
      # Minimal target for NaCl and other renderer side media clients which
      # only need to send audio data across the shared memory to the browser
      # process.
      'target_name': 'shared_memory_support',
      'type': '<(component)',
      'dependencies': [
        '../base/base.gyp:base',
      ],
      'defines': [
        'MEDIA_IMPLEMENTATION',
      ],
      'include_dirs': [
        '..',
      ],
      'includes': [
        'shared_memory_support.gypi',
      ],
      'sources': [
        '<@(shared_memory_support_sources)',
      ],
      'conditions': [
        ['arm_neon==1', {
          'defines': [
            'USE_NEON'
          ],
        }],
        ['target_arch=="ia32" or target_arch=="x64"', {
          'dependencies': [
            'shared_memory_support_sse'
          ],
        }],
      ],
    },
  ],
  'conditions': [
    ['target_arch!="arm"', {
      'targets': [
       {
          'target_name': 'media_asm',
          'type': 'static_library',
          'sources': [
            'base/simd/convert_rgb_to_yuv_ssse3.asm',
            'base/simd/convert_yuv_to_rgb_mmx.asm',
            'base/simd/convert_yuv_to_rgb_sse.asm',
            'base/simd/convert_yuva_to_argb_mmx.asm',
            'base/simd/empty_register_state_mmx.asm',
            'base/simd/linear_scale_yuv_to_rgb_mmx.asm',
            'base/simd/linear_scale_yuv_to_rgb_sse.asm',
            'base/simd/scale_yuv_to_rgb_mmx.asm',
            'base/simd/scale_yuv_to_rgb_sse.asm',
          ],
          'conditions': [
            ['component=="shared_library"', {
              'variables': {
                'yasm_flags': ['-DEXPORT_SYMBOLS'],
              },
            }],
            ['target_arch=="x64"', {
              # Source files optimized for X64 systems.
              'sources': [
                'base/simd/linear_scale_yuv_to_rgb_mmx_x64.asm',
                'base/simd/scale_yuv_to_rgb_sse2_x64.asm',
              ],
              'variables': {
                'yasm_flags': ['-DARCH_X86_64'],
              },
            }],
            ['OS=="mac"', {
              'variables': {
                'yasm_flags': [
                  '-DPREFIX',
                  '-DMACHO',
                ],
              },
              'sources': [
                # XCode doesn't want to link a pure assembly target and will
                # fail to link when it creates an empty file list.  So add a
                # dummy file keep the linker happy.  See http://crbug.com/157073
                'base/simd/xcode_hack.c',
              ],
            }],
            ['os_posix==1 and OS!="mac"', {
              'variables': {
                'conditions': [
                  ['target_arch=="ia32"', {
                    'yasm_flags': [
                      '-DX86_32',
                      '-DELF',
                    ],
                  }, {
                    'yasm_flags': [
                      '-DELF',
                      '-DPIC',
                    ],
                  }],
                ],
              },
            }],
          ],
          'variables': {
            'yasm_output_path': '<(SHARED_INTERMEDIATE_DIR)/media',
            'yasm_flags': [
              '-DCHROMIUM',
              # In addition to the same path as source asm, let yasm %include
              # search path be relative to src/ per Chromium policy.
              '-I..',
            ],
            'yasm_includes': [
              '../third_party/x86inc/x86inc.asm',
              'base/simd/convert_rgb_to_yuv_ssse3.inc',
              'base/simd/convert_yuv_to_rgb_mmx.inc',
              'base/simd/convert_yuva_to_argb_mmx.inc',
              'base/simd/linear_scale_yuv_to_rgb_mmx.inc',
              'base/simd/media_export.asm',
              'base/simd/scale_yuv_to_rgb_mmx.inc',
            ],
          },
          'msvs_2010_disable_uldi_when_referenced': 1,
          'includes': [
            '../third_party/yasm/yasm_compile.gypi',
          ],
        },
        {
          'target_name': 'media_mmx',
          'type': 'static_library',
          'cflags': [
            '-mmmx',
          ],
          'defines': [
            'MEDIA_IMPLEMENTATION',
          ],
          'include_dirs': [
            '..',
          ],
          'sources': [
            'base/simd/filter_yuv_mmx.cc',
          ],
        },
        {
          'target_name': 'media_sse',
          'type': 'static_library',
          'cflags': [
            '-msse',
          ],
          'defines': [
            'MEDIA_IMPLEMENTATION',
          ],
          'include_dirs': [
            '..',
          ],
          'sources': [
            'base/simd/sinc_resampler_sse.cc',
          ],
        },
        {
          'target_name': 'media_sse2',
          'type': 'static_library',
          'cflags': [
            '-msse2',
          ],
          'defines': [
            'MEDIA_IMPLEMENTATION',
          ],
          'include_dirs': [
            '..',
          ],
          'sources': [
            'base/simd/convert_rgb_to_yuv_sse2.cc',
            'base/simd/convert_rgb_to_yuv_ssse3.cc',
            'base/simd/filter_yuv_sse2.cc',
          ],
        },
        {
          'target_name': 'shared_memory_support_sse',
          'type': 'static_library',
          'cflags': [
            '-msse',
          ],
          'defines': [
            'MEDIA_IMPLEMENTATION',
          ],
          'include_dirs': [
            '..',
          ],
          'sources': [
            'base/simd/vector_math_sse.cc',
          ],
        },
      ], # targets
    }],
    ['use_x11==1', {
      'targets': [
        {
          'target_name': 'player_x11',
          'type': 'executable',
          'dependencies': [
            'media',
            '../base/base.gyp:base',
            '../ui/gl/gl.gyp:gl',
            '../ui/gfx/gfx.gyp:gfx',
            '../ui/gfx/gfx.gyp:gfx_geometry',
            '../build/linux/system.gyp:x11',
            '../build/linux/system.gyp:xext',
            '../build/linux/system.gyp:xrender',
          ],
          'conditions': [
            # Linux/Solaris need libdl for dlopen() and friends.
            ['OS=="linux" or OS=="solaris"', {
              'link_settings': {
                'libraries': [
                  '-ldl',
                ],
              },
            }],
          ],
          'sources': [
            'tools/player_x11/data_source_logger.cc',
            'tools/player_x11/data_source_logger.h',
            'tools/player_x11/gl_video_renderer.cc',
            'tools/player_x11/gl_video_renderer.h',
            'tools/player_x11/player_x11.cc',
            'tools/player_x11/x11_video_renderer.cc',
            'tools/player_x11/x11_video_renderer.h',
          ],
        },
      ],
    }],
    # Special target to wrap a gtest_target_type==shared_library
    # media_unittests into an android apk for execution.
    ['OS=="android" and gtest_target_type=="shared_library"', {
      'targets': [
        {
          'target_name': 'media_unittests_apk',
          'type': 'none',
          'dependencies': [
            'media_java',
            'media_unittests',
          ],
          'variables': {
            'test_suite_name': 'media_unittests',
            'input_shlib_path': '<(SHARED_LIB_DIR)/<(SHARED_LIB_PREFIX)media_unittests<(SHARED_LIB_SUFFIX)',
          },
          'includes': ['../build/apk_test.gypi'],
        },
        {
          'target_name': 'media_perftests_apk',
          'type': 'none',
          'dependencies': [
            'media_java',
            'media_perftests',
          ],
          'variables': {
            'test_suite_name': 'media_perftests',
            'input_shlib_path': '<(SHARED_LIB_DIR)/<(SHARED_LIB_PREFIX)media_perftests<(SHARED_LIB_SUFFIX)',
          },
          'includes': ['../build/apk_test.gypi'],
        },
      ],
    }],
    ['OS=="android"', {
      'targets': [
        {
          'target_name': 'media_android_jni_headers',
          'type': 'none',
          'sources': [
            'base/android/java/src/org/chromium/media/AudioManagerAndroid.java',
            'base/android/java/src/org/chromium/media/AudioRecordInput.java',
            'base/android/java/src/org/chromium/media/MediaCodecBridge.java',
            'base/android/java/src/org/chromium/media/MediaDrmBridge.java',
            'base/android/java/src/org/chromium/media/MediaPlayerBridge.java',
            'base/android/java/src/org/chromium/media/MediaPlayerListener.java',
            'base/android/java/src/org/chromium/media/UsbMidiDeviceAndroid.java',
            'base/android/java/src/org/chromium/media/UsbMidiDeviceFactoryAndroid.java',
            'base/android/java/src/org/chromium/media/WebAudioMediaCodecBridge.java',
          ],
          'variables': {
            'jni_gen_package': 'media',
            'jni_generator_ptr_type': 'long',
          },
          'includes': ['../build/jni_generator.gypi'],
        },
        {
          'target_name': 'video_capture_android_jni_headers',
          'type': 'none',
          'sources': [
            'base/android/java/src/org/chromium/media/VideoCapture.java',
          ],
          'variables': {
            'jni_gen_package': 'media',
            'jni_generator_ptr_type': 'long',
          },
          'includes': ['../build/jni_generator.gypi'],
        },
        {
          'target_name': 'player_android',
          'type': 'static_library',
          'sources': [
            'base/android/audio_decoder_job.cc',
            'base/android/audio_decoder_job.h',
            'base/android/media_codec_bridge.cc',
            'base/android/media_codec_bridge.h',
            'base/android/media_decoder_job.cc',
            'base/android/media_decoder_job.h',
            'base/android/media_drm_bridge.cc',
            'base/android/media_drm_bridge.h',
            'base/android/media_jni_registrar.cc',
            'base/android/media_jni_registrar.h',
            'base/android/media_player_android.cc',
            'base/android/media_player_android.h',
            'base/android/media_player_bridge.cc',
            'base/android/media_player_bridge.h',
            'base/android/media_player_listener.cc',
            'base/android/media_player_listener.h',
            'base/android/media_source_player.cc',
            'base/android/media_source_player.h',
            'base/android/video_decoder_job.cc',
            'base/android/video_decoder_job.h',
            'base/android/webaudio_media_codec_bridge.cc',
            'base/android/webaudio_media_codec_bridge.h',
            'base/android/webaudio_media_codec_info.h',
          ],
          'dependencies': [
            '../base/base.gyp:base',
            '../ui/gl/gl.gyp:gl',
            '../url/url.gyp:url_lib',
            'media_android_jni_headers',
          ],
          'defines': [
            'MEDIA_IMPLEMENTATION',
          ],
        },
        {
          'target_name': 'media_java',
          'type': 'none',
          'dependencies': [
            '../base/base.gyp:base',
            'media_android_imageformat_list',
          ],
          'export_dependent_settings': [
            '../base/base.gyp:base',
          ],
          'variables': {
            'java_in_dir': 'base/android/java',
          },
          'includes': ['../build/java.gypi'],
        },
        {
          'target_name': 'media_android_imageformat_list',
          'type': 'none',
          'sources': [
            'base/android/java/src/org/chromium/media/ImageFormat.template',
          ],
          'variables': {
            'package_name': 'org/chromium/media',
            'template_deps': ['video/capture/android/imageformat_list.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
      ],
    }],
    ['media_use_ffmpeg==1', {
      'targets': [
        {
          'target_name': 'ffmpeg_unittests',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_i18n',
            '../base/base.gyp:test_support_base',
            '../base/base.gyp:test_support_perf',
            '../testing/gtest.gyp:gtest',
            '../third_party/ffmpeg/ffmpeg.gyp:ffmpeg',
            'media',
            'media_test_support',
          ],
          'sources': [
            'ffmpeg/ffmpeg_unittest.cc',
          ],
          'conditions': [
            ['toolkit_uses_gtk==1', {
              'dependencies': [
                # Needed for the following #include chain:
                #   base/run_all_unittests.cc
                #   ../base/test_suite.h
                #   gtk/gtk.h
                '../build/linux/system.gyp:gtk',
              ],
              'conditions': [
                ['linux_use_tcmalloc==1', {
                  'dependencies': [
                    '../base/allocator/allocator.gyp:allocator',
                  ],
                }],
              ],
            }],
          ],
        },
        {
          'target_name': 'ffmpeg_regression_tests',
          'type': 'executable',
          'dependencies': [
            '../base/base.gyp:test_support_base',
            '../testing/gmock.gyp:gmock',
            '../testing/gtest.gyp:gtest',
            '../third_party/ffmpeg/ffmpeg.gyp:ffmpeg',
            'media',
            'media_test_support',
          ],
          'sources': [
            'base/run_all_unittests.cc',
            'base/test_data_util.cc',
            'ffmpeg/ffmpeg_regression_tests.cc',
            'filters/pipeline_integration_test_base.cc',
          ],
          'conditions': [
            ['os_posix==1 and OS!="mac"', {
              'conditions': [
                ['linux_use_tcmalloc==1', {
                  'dependencies': [
                    '../base/allocator/allocator.gyp:allocator',
                  ],
                }],
              ],
            }],
          ],
        },
      ],
    }],
  ],
}
