#! /usr/bin/env perl
#
# Copyright (C) 2010-2022 Alexis Bienvenüe <paamc@passoire.fr>
#
# This file is part of Auto-Multiple-Choice
#
# Auto-Multiple-Choice is free software: you can redistribute it
# and/or modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, either version 2 of
# the License, or (at your option) any later version.
#
# Auto-Multiple-Choice is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Auto-Multiple-Choice.  If not, see
# <http://www.gnu.org/licenses/>.

use Locale::PO;
use Encode;
use utf8;
use Getopt::Long;

my $comment_only = '';

GetOptions( "comment-only!" => \$comment_only );

my ( $from, $to ) = @ARGV;

$v = "1.6.0+git20250411111559 (r:13e52b3d)";

chomp( $date = `date "+%Y-%m-%d %H:%M %z"` );

my $aref = Locale::PO->load_file_asarray($from);

my @ok = grep { $_->msgid() !~ /^\"?gtk-/ } @$aref;

$ok[0]->comment(
    encode_utf8(
"Auto Multiple Choice\nCopyright 2008-2022 Alexis Bienvenüe\nThis file is distributed under the same license as the AMC software"
    )
);

if ( !$comment_only ) {
    $ok[0]->msgstr( "Project-Id-Version: $v\n"
          . "Report-Msgid-Bugs-To: paamc\@passoire.fr\n"
          . "POT-Creation-Date: $date\n"
          . "PO-Revision-Date: YEAR-MO-DA HO:MI +ZONE\n"
          . "Last-Translator: FULL NAME <EMAIL@ADDRESS>\n"
          . "Language-Team: LANGUAGE <LL@li.org>\n"
          . "MIME-Version: 1.0\n"
          . "Content-Type: text/plain; charset=UTF-8\n"
          . "Content-Transfer-Encoding: 8bit" );
}

Locale::PO->save_file_fromarray( $to, \@ok );

