(* Opt *)
(* $Id: opt.ml,v 1.1 2004/10/26 09:44:54 berke Exp $ *)

let config_file = ref "xara.config";;
let user_specified_config_file = ref false;;
let dump_config = ref false;;
let low_memory = ref 131072;; (* KiB *)
let fast = ref true;;
let very_slow = ref (Util.proc_get_free_mem () < !low_memory);;

let specs = [
   "-config",Arg.String(fun w -> user_specified_config_file := true; config_file := w),
     "<path> Set user configuration file name (default ~/.ara/xara.config)";
   "-dump-config",Arg.Set(dump_config)," Dump configuration file to stdout.";

  "-fast",Arg.Clear(very_slow),
    " Run faster but use more memory.";
  "-slow",Arg.Set(very_slow),
    " Use minimal amount of memory but run very slowly.";
  "-cache-strings",Arg.Clear(fast),
    " With -fast, try to conserve memory somewhat.";

 "-debug",Arg.Set(Debug.enable),
   " Enable debugging information";
 "-debug-level",Arg.Set_int(Debug.level),
   " Set debugging level (higher is more verbose, max is 100, default is 10)";
]
;;
