Occitan and French (`apertium-oci-fra`)
===============================================================================

This is an Apertium language pair for translating between (Languedocian and Gascon)
Occitan and French. What you can use this language package for:

* Translating between (Languedocian and Gascon) Occitan and French
* Morphological analysis of (Languedocian and Gascon) Occitan and French
* Part-of-speech tagging of (Languedocian and Gascon) Occitan and French

For information on the latter two points, see subheading "For more
information" below

Requirements
===============================================================================

You will need the following software installed:

* lttoolbox (>= 3.3.0)
* apertium (>= 3.3.0)
* vislcg3 (>= 0.9.9.10297)
* apertium-oci
* apertium-fra

If this does not make any sense, we recommend you look at: apertium.org

Compiling
===============================================================================

Given the requirements being installed, you should be able to just run:

```sh
$ ./configure --with-lang1=../apertium-oci --with-lang2=../apertium-fra
$ make
# make install
```

You should change ../apertium-oci and ../apertium-fra to the paths
of the apertium-oci and apertium-fra repositories, respectively, if they
have different relative paths in your installation.

You can use ./autogen.sh instead of ./configure you're compiling from
SVN. If you installed any prerequisite language packages using a --prefix
to ./configure, make sure to give the same --prefix to ./configure here.

Testing
===============================================================================

If you are in the source directory after running make, the following
commands should work:

Translation from French into Languedocian Occitan:

```sh
$ echo "Apertium est un logiciel de traduction automatique" | apertium -d . fra-oci
Apertium es un logicial de traduccion automatica
```

Translation from French into Gascon Occitan:

```sh
$ echo "Apertium est un logiciel de traduction automatique" | apertium -d . fra-oci_gascon
Apertium qu'ei un logiciau de traduccion automatica
```

Translation from Languedocian Occitan into French:

```sh
$  echo "Apertium es un logicial de traduccion automatica" | apertium -d . oci-fra
Apertium est un logiciel de traduction automatique
```

Translation from Gascon Occitan into French:

```sh
$  echo "Apertium qu'ei un logiciau de traduccion automatica" | apertium -d . oci_gascon-fra
Apertium est un logiciel de traduction automatique
```

After installing somewhere in $PATH, you should be able to do e.g.

```sh
$ echo "Apertium est un logiciel de traduction automatique" | apertium fra-oci
Apertium es un logicial de traduccion automatica
```

Files and data
===============================================================================

* apertium-oci-fra.oci-fra.dix  - Bilingual dictionary
* apertium-oci-fra.oci-fra.t1x  - Chunking rules for translating into French
* apertium-oci-fra.fra-oci.t1x  - Chunking rules for translating into Occitan
* apertium-oci-fra.oci-fra.t2x_temps - Interchunk rules for translating into Occitan dealing with changing verbal tenses (step 1)
* apertium-oci-fra.oci-fra.t2ax  - Interchunk rules for translating into French (steps 2 and 3)
* apertium-oci-fra.oci-fra.t2bx  - Interchunk rules for translating into French (step 4)
* apertium-oci-fra.oci-fra.t2cx  - Interchunk rules for translating into French (step 5)
* apertium-oci-fra.oci-fra.t2dx  - Interchunk rules for translating into French (step 6)
* apertium-oci-fra.oci-fra.t2ex  - Interchunk rules for translating into French (step 7)
* apertium-oci-fra.fra-oci.t2x_ini - Interchunk rules for translating into Occitan dealing with subject-verb agreement (step 1)
* apertium-oci-fra.fra-oci.t2x  - Interchunk rules for translating into Occitan (step 2)
* apertium-oci-fra.fra-oci.t2x_bis - Interchunk rules for translating into Occitan (step 3)
* apertium-oci-fra.fra-oci.t2x_pas - Interchunk rules for translating into Occitan dealing with verbal negative forms (step 4)
* apertium-oci-fra.fra-oci.t2x_pro - Interchunk rules for translating into Occitan dealing with the order of proclitic pronouns (step 5)
* apertium-oci-fra.fra-oci.t2x_supersn  - Interchunk rules for translating into Occitan dealing with the grouping of noun phrases (step 6)
* apertium-oci-fra.fra-oci.t2x_enon - Interchunk rules for translating into Occitan dealing with Gascon enonciatives (step 7)
* apertium-oci-fra.oci-fra.t3x  - Postchunk rules for translating into French
* apertium-oci-fra.fra-oci.t3x  - Postchunk rules for translating into Occitan
* apertium-oci-fra.oci-fra.t4x  - Final transfer rules for translating into French
* apertium-oci-fra.fra-oci.t4x  - Final transfer rules for translating into Occitan
* apertium-oci-fra.oci-fra.lrx  - Lexical selection rules for translating into French
* apertium-oci-fra.fra-oci.lrx  - Lexical selection rules for translating into Occitan
* apertium-oci-fra.oci-fra.l1x  - Rules for recognising expressions with discontiguous words for translating into French
* apertium-oci-fra.oci-fra.l2x  - Rules for reordering words in discontiguous expressions for translating into French
* apertium-oci-fra.fra-oci.l1x  - Rules for recognising expressions with discontiguous words for translating into Occitan
* apertium-oci-fra.fra-oci.l2x  - Rules for reordering words in discontiguous expressions for translating into Occitan
* modes.xml                     - Translation modes

For more information
===============================================================================

* https://wiki.apertium.org/wiki/Installation
* https://wiki.apertium.org/wiki/apertium-oci-fra
* https://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary
* https://wiki.apertium.org/wiki/Paire_Occitan-Fran%C3%A7ais - Overall presentation of the architecture (in French)

Help and support
===============================================================================

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: #apertium on irc.oftc.net

See also the file AUTHORS included in this distribution.
