/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sparql.vocabulary;
 
import org.apache.jena.rdf.model.* ;
 
/**
 * Vocabulary definitions from EARL.rdf 
 * Auto-generated by schemagen 
 */
public class EARL {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.w3.org/ns/earl#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    
    /** <p>assertor of an assertion</p> */
    public static final Property assertedBy = m_model.createProperty( "http://www.w3.org/ns/earl#assertedBy" );
    
    /** <p>additional warnings or error messages in a human-readable form</p> */
    public static final Property info = m_model.createProperty( "http://www.w3.org/ns/earl#info" );
    
    /** <p>assertor that is primarily responsible for performing the test</p> */
    public static final Property mainAssertor = m_model.createProperty( "http://www.w3.org/ns/earl#mainAssertor" );
    
    /** <p>mode in which the test was performed</p> */
    public static final Property mode = m_model.createProperty( "http://www.w3.org/ns/earl#mode" );
    
    /** <p>outcome of performing the test</p> */
    public static final Property outcome = m_model.createProperty( "http://www.w3.org/ns/earl#outcome" );
    
    /** <p>location within a test subject that are most relevant to a test result</p> */
    public static final Property pointer = m_model.createProperty( "http://www.w3.org/ns/earl#pointer" );
    
    /** <p>result of an assertion</p> */
    public static final Property result = m_model.createProperty( "http://www.w3.org/ns/earl#result" );
    
    /** <p>test subject of an assertion</p> */
    public static final Property subject = m_model.createProperty( "http://www.w3.org/ns/earl#subject" );
    
    /** <p>test criterion of an assertion</p> */
    public static final Property test = m_model.createProperty( "http://www.w3.org/ns/earl#test" );
    
    /** <p>a statement that embodies the results of a test</p> */
    public static final Resource Assertion = m_model.createResource( "http://www.w3.org/ns/earl#Assertion" );
    
    /** <p>an entity such as a person, a software tool, an organization, or any other 
     *  grouping that carries out a test collectively</p>
     */
    public static final Resource Assertor = m_model.createResource( "http://www.w3.org/ns/earl#Assertor" );
    
    /** <p>the class of outcomes to denote an undetermined outcome</p> */
    public static final Resource CannotTell = m_model.createResource( "http://www.w3.org/ns/earl#CannotTell" );
    
    /** <p>the class of outcomes to denote failing a test</p> */
    public static final Resource Fail = m_model.createResource( "http://www.w3.org/ns/earl#Fail" );
    
    /** <p>the class of outcomes to denote the test is not applicable</p> */
    public static final Resource NotApplicable = m_model.createResource( "http://www.w3.org/ns/earl#NotApplicable" );
    
    /** <p>the class of outcomes to denote the test has not been carried out</p> */
    public static final Resource NotTested = m_model.createResource( "http://www.w3.org/ns/earl#NotTested" );
    
    /** <p>a discrete value that describes a resulting condition from carrying out the 
     *  test</p>
     */
    public static final Resource OutcomeValue = m_model.createResource( "http://www.w3.org/ns/earl#OutcomeValue" );
    
    /** <p>the class of outcomes to denote passing a test</p> */
    public static final Resource Pass = m_model.createResource( "http://www.w3.org/ns/earl#Pass" );
    
    /** <p>any piece of software such as an authoring tool, browser, or evaluation tool</p> */
    public static final Resource Software = m_model.createResource( "http://www.w3.org/ns/earl#Software" );
    
    /** <p>an atomic test, usually one that is a partial test for a requirement</p> */
    public static final Resource TestCase = m_model.createResource( "http://www.w3.org/ns/earl#TestCase" );
    
    /** <p>a testable statement, usually one that can be passed or failed</p> */
    public static final Resource TestCriterion = m_model.createResource( "http://www.w3.org/ns/earl#TestCriterion" );
    
    /** <p>describes how a test was carried out</p> */
    public static final Resource TestMode = m_model.createResource( "http://www.w3.org/ns/earl#TestMode" );
    
    /** <p>a higher-level requirement that is tested by executing one or more sub-tests</p> */
    public static final Resource TestRequirement = m_model.createResource( "http://www.w3.org/ns/earl#TestRequirement" );
    
    /** <p>the actual result of performing the test</p> */
    public static final Resource TestResult = m_model.createResource( "http://www.w3.org/ns/earl#TestResult" );
    
    /** <p>the class of things that have been tested against some test criterion</p> */
    public static final Resource TestSubject = m_model.createResource( "http://www.w3.org/ns/earl#TestSubject" );
    
    public static final Resource automatic = m_model.createResource( "http://www.w3.org/ns/earl#automatic" );
    
    public static final Resource cantTell = m_model.createResource( "http://www.w3.org/ns/earl#cantTell" );
    
    public static final Resource failed = m_model.createResource( "http://www.w3.org/ns/earl#failed" );
    
    public static final Resource inapplicable = m_model.createResource( "http://www.w3.org/ns/earl#inapplicable" );
    
    public static final Resource manual = m_model.createResource( "http://www.w3.org/ns/earl#manual" );
    
    public static final Resource passed = m_model.createResource( "http://www.w3.org/ns/earl#passed" );
    
    public static final Resource semiAuto = m_model.createResource( "http://www.w3.org/ns/earl#semiAuto" );
    
    public static final Resource undisclosed = m_model.createResource( "http://www.w3.org/ns/earl#undisclosed" );
    
    public static final Resource unknownMode = m_model.createResource( "http://www.w3.org/ns/earl#unknownMode" );
    
    public static final Resource untested = m_model.createResource( "http://www.w3.org/ns/earl#untested" );
}
  