/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

#ifndef FORMAT_SUBS_H
#define FORMAT_SUBS_H

#define SUBS_VERSION VERSION(1, 0)

typedef struct _SUBSRange {
    GlyphId firstGlyph;
    GlyphId lastGlyph;
} SUBSRange;

typedef da_DCL(SUBSRange, SUBSRangesType);

typedef SUBSRangesType *SUBSRangeTypePtr;

typedef struct _SUBSTbl {
    Fixed version;
    Card16 subsetID;
#define SUBS_UNKNOWN 0
#define SUBS_JAPANESEKANA 1
#define SUBS_JAPANESERUBY 2
#define SUBS_ACROBATJ 3
#define SUBS_KOREANHANGUL 4

    Card16 firstCID;
    Card16 lastCID; /* last _real_ CID */
    GlyphId firstGlyph;
    GlyphId lastGlyph; /* last _real_ CID, or _Virtual_ glyphID which is  */
                       /* generated by the "mort" table and is present in */
                       /* the VFMX, ALMX, or ROTA tables                  */
    Card16 numranges;
    SUBSRangesType range; /* [numRanges] */
} SUBSTbl;

#endif /* FORMAT_SUBS_H */
