/*
 * sstack.c
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to SORCERER -- SORCERER is in the public
 * domain.  An individual or company may do whatever they wish with
 * source code distributed with SORCERER or the code generated by
 * SORCERER, including the incorporation of SORCERER, or its output, into
 * commerical software.
 *
 * We encourage users to develop software with SORCERER.  However, we do
 * ask that credit is given to us for developing SORCERER.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like SORCERER and have developed a nice tool with the
 * output, please mention that you developed it using SORCERER.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * SORCERER 1.00B
 * Terence Parr
 * AHPCRC, University of Minnesota
 * 1992-1994
 */

#include "pcctscfg.h"
#include <stdio.h>
#include <setjmp.h>

#ifdef PCCTS_USE_STDARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include "CASTBase.h"
#include "sstack.h"

void
#ifdef __USE_PROTOS
sstack_push( SStack **st, void *e )
#else
sstack_push( st, e )
SStack **st;
void *e;
#endif
{
	SStack *p;
	require(e!=NULL, "sstack_push: attempting to add NULL list element");

	p = newSStack;
	require(p!=NULL, "sstack_push: cannot alloc new list node");
	p->elem = e;
	p->next = *st;
	*st = p;
}

void *
#ifdef __USE_PROTOS
sstack_pop( SStack **st )
#else
sstack_pop( st )
SStack **st;
#endif
{
	SStack *p = *st;
	void *r;

	*st = (*st)->next;
	r = p->elem;
	free(p);
	return r;
}

