/*
 *  acm : an aerial combat simulator for X - Gallery of common drawings
 *  Copyright (C) 2008  Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * This module collects some common drawings.
 * 
 * @file
 */

#ifndef vpath_gallery_H
#define vpath_gallery_H

#include "vpath.h"

#ifdef vpath_gallery_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Return a compass scale drawn over the xy plane in screen coordinates,
 * north is up, radius 1.0.
 */
EXTERN vpath_Type * vpath_gallery_get_compass_scale(void);

/**
 * Release all the internal data structures.
 */
EXTERN void vpath_gallery_free_all(void);

/**
 * Return a compass fixed scale composed of tick marks drawn every 45
 * DEG. The scale is drawn inside a circle of radius 1.0 with internal
 * radius of 0.90. The scale is drawn over the xy plane in screen frame
 * and centered on the origin.
 */
EXTERN vpath_Type * vpath_gallery_get_compass_fixed_scale(void);

/**
 * Return a stylized aircraft draw inside a square box of side length
 * 2.0, nose "up", the center is the origin of the xy plane.
 */
EXTERN vpath_Type * vpath_gallery_get_stylized_aircraft(void);

/**
 * Arrow that points "up" centered on a circle of radius 1.0.
 */
EXTERN vpath_Type * vpath_gallery_get_pointer_arrow(void);

/**
 * Pointer shaped as a triangle and located on the outside border of a
 * circle of radius 1.0. Its initial indication is "up".
 */
EXTERN vpath_Type * vpath_gallery_get_pointer_triangle(void);

#undef EXTERN
#endif
