/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _terrain_h
#define _terrain_h

#include "pm.h"

#ifdef terrain_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Returns the altitude over the sea level of the terrain under the aircraft.
 * The "sea level" is the surface of the WGS84 ellipsoid.
 * 
 * Implementation: takes the altitude of the closer runway within 100 NM "down
 * range"; if none found, the sea level zero is returned.
 * 
 * Since the terrain changes its altitude very slowly, values are cached
 * in c->local_altitude and updated only if c->local_altitude_timeout >
 * curTime, then the timeout is moved forward a few to avoid to repeat
 * the same calculation to often.
 * @param c  The aircraft.
 * @return Terrain altitude over the WGS84 ellipsoid of the point below the
 * given aircraft position (m).
*/
EXTERN double terrain_localAltitude(craft *c);

#undef EXTERN
#endif
